{if file_exists("templates/$template/modules/servers/cpanel/overwrites/overview.tpl")}
    {include file="{$template}/modules/servers/cpanel/overwrites/overview.tpl"}  
{else}
    <script src="modules/servers/cpanel/js/client.js"></script>
    <style>
        .field-icon {
            float: right;
            margin-right: 10px; 
            margin-top: 15px;
            position: absolute;
            right: 45px;
            z-index: 2;
        }
        .billingOverview [class*=col-]>.row {
            margin-bottom: 0 !important;
        }
    </style>
    <script type="text/javascript">
        function copyToClipboard(text, el) {
            var copyTest = document.queryCommandSupported('copy');
            var elOriginalText = el.attr('data-original-title');
            if (copyTest === true) {
                var copyTextArea = document.createElement("textarea");
                copyTextArea.value = text;
                document.body.appendChild(copyTextArea);
                copyTextArea.select();
                try {
                var successful = document.execCommand('copy');
                var msg = successful ? 'Copiado!' : 'Whoops, not copied!';
                el.attr('data-original-title', msg).tooltip('show');
                } catch (err) {
                console.log('Oops, unable to copy');
                }
                document.body.removeChild(copyTextArea);
                el.attr('data-original-title', elOriginalText);
            } else {
                window.prompt("Copy to clipboard: Ctrl+C or Command+C, Enter", text);
            }
        }
        $(document).ready(function() {
            $('.js-tooltip').tooltip();
            $('.js-copy').click(function() {
                var text = $(this).attr('data-copy');
                var el = $(this);
                copyToClipboard(text, el);
            });
        });
    </script>
    <script type="text/javascript">
        jQuery(document).ready(function(){
            $(".toggle-password").click(function() {
                $(this).toggleClass("fa-eye fa-eye-slash");
                var input = jQuery('#inputPassword');
                    if (input.attr("type") == "password") {
                        input.attr("type", "text");
                    } else {
                        input.attr("type", "password");
                    }
            });
        }); 
    </script> 
    <div class="product-details">
        <div class="row row-eq-height row-eq-height-sm">
            <div class="col-md-6">
                <div class="product-icon" id="cPanelPackagePanel">
                    <div class="product-content">
                        <div class="product-image">
                            {include file="$template/includes/common/svg-icon.tpl" icon="addon" onDark=true}
                        </div>
                        <h2 class="product-name">{$groupname} - {$product}</h2>
                        <div class="product-status">{$LANG.clientareastatus}:
                            <span class="label label-success">{$status}</span>
                        </div>
                    </div>
                    {if $domain}  
                    <a class="product-footer" href="http://{$domain}">{$domain}</a>
                    {/if}
                </div>
            </div>
            <div class="col-md-6">
                <div class="panel panel-default cpanel-usage-stats" id="cPanelUsagePanel">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col" id="diskUsage">
                                <div class="usage-stats">
                                    <span>{$LANG.cPanel.diskUsage}</span>
                                    <div class="knob-dial">
                                    <input type="text" value="{$diskpercent|substr:0:-1}" class="usage-dial" data-bgColor="#e6e8ec" data-fgColor="#0c70de" data-angleOffset="-125" data-angleArc="250" data-min="0" data-max="{if substr($diskpercent, 0, -1) > 100}{$diskpercent|substr:0:-1}{else}100{/if}" data-readOnly="true" data-width="104" data-thickness=.3 data-height="80" />        
                                    </div>
                                    <span>{$diskusage} M / {$disklimit} M</span>
                                </div>
                            </div>
                            <div class="col" id="bandwidthUsage">
                                <div class="usage-stats">
                                    <span>{$LANG.cPanel.bandwidthUsage}</span>
                                    <input type="text" value="{$bwpercent|substr:0:-1}" class="usage-dial" data-bgColor="#e6e8ec" data-fgColor="#0c70de" data-angleOffset="-125" data-angleArc="250" data-min="0" data-max="{if substr($bwpercent, 0, -1) > 100}{$bwpercent|substr:0:-1}{else}100{/if}" data-readOnly="true" data-width="104" data-thickness=.3 data-height="80" />
                                    <span>{$bwusage} M / {$bwlimit} M</span>
                                </div>
                            </div>
                        </div>
                        <script src="{$BASE_PATH_JS}/jquery.knob.js"></script>
                        <script type="text/javascript">
                            jQuery(function() {
                                jQuery(".usage-dial").knob({
                                    'change': function (v) { console.log(v); },
                                    draw: function () {
                                        if ($(this.i).val() > 0){
                                            $(this.i).val(this.cv + '%');
                                        }
                                    
                                    }
                                });
                            });
                        </script>
                    </div>
                    <div class="panel-footer">
                        {if $bwpercent|substr:0:-1 > 75}
                            <div class="text-danger text-center">
                                 {if $bwpercent|substr:0:-1 > 100}
                                    {$LANG.cPanel.usageStatsBwOverLimit}
                                {else}
                                    {$LANG.cPanel.usageStatsBwLimitNear}
                                {/if}
                                {if $packagesupgrade}
                                    <a href="upgrade.php?type=package&id={$serviceid}" class="btn btn-xs btn-danger">
                                        <i class="fa fa-arrow-circle-up"></i>
                                         {$LANG.cPanel.usageUpgradeNow}
                                    </a>
                                {/if}
                            </div>
                        {elseif $diskpercent|substr:0:-1 > 75}
                            <div class="text-danger text-center">
                                {if $diskpercent|substr:0:-1 > 100}
                                    {$LANG.cPanel.usageStatsDiskOverLimit}
                                {else}
                                    {$LANG.cPanel.usageStatsDiskLimitNear}
                                {/if}
                                {if $packagesupgrade}
                                    <a href="upgrade.php?type=package&id={$serviceid}" class="btn btn-xs btn-danger">
                                        <i class="fa fa-arrow-circle-up"></i>
                                        {$LANG.cPanel.usageUpgradeNow}
                                    </a>
                                {/if}
                            </div>
                        {else}
                            <div class="text-center">
                                {$LANG.cPanel.usageLastUpdated} {$lastupdate}
                            </div>
                        {/if}
                    </div>
                </div>
            </div>
        </div>
    </div>

    {* Quick Shortcuts *}
    {if $systemStatus == 'Active'}
    {* Infos begin *}
    <div class="section">

        <div class="section-body">

            <div class="panel panel-default">
                
                    <ul class="panel-tabs nav nav-tabs">
                        <li>
                            <a href="#cpanel" data-toggle="tab" class="active"><i class="fa fa-cogs"></i> cPanel</a>
                        </li>
                        <li>
                            <a href="#dns" data-toggle="tab" aria-expanded="true"><i class="fa fa-globe"></i> DNS</a>
                        </li>
                        <li>
                            <a href="#ftp" data-toggle="tab" aria-expanded="true"><i class="fa fa-folder"></i> FTP</a>
                        </li>
                        <li>
                            <a href="#email" data-toggle="tab" aria-expanded="true"><i class="fa fa-envelope"></i> E-mail</a>
                        </li>
                        <li>
                            <a href="#php" data-toggle="tab" aria-expanded="true"><i class="fa fa-hdd"></i> PHP</a>
                        </li>
                        <li>
                            <a href="#mysql" data-toggle="tab" aria-expanded="true"><i class="fa fa-database"></i> MySQL</a>
                        </li>
                    </ul>
                
                
                    <div class="panel-body tab-content">
                        <div class="tab-pane active billingOverview" id="cpanel">                     
                            <div class="row" style="margin-bottom: 0px!important;">
                                <div class="col-sm-12 col-md-8  m-b-2x" style="margin-bottom: 0 !important;"> <!-- EDILSON -->
                                    <div class="col-xs-12" >
                                        <span class="text-light">
                                            <div style="margin-bottom:10px">Seu painel de Controle é o cPanel, um dos mais avançados e populares do mundo.</div>
                                            <p>Para <strong>acessar o seu painel de controle cPanel</strong>, segue o link:</p>
                                        <span>
                                    </div>
                                    <div class="col-xs-12">  
                                        <span class="text-light">
                                            <p><a href=https://avalon.souzahost.com/cpanel" target="_blank">https://avalon.souzahost.com/cpanel <i class="align-top fas fa-external-link-alt"></i></a></p>
                                        </span>
                                    </div>
                                    <div class="col-xs-12" style="margin-top:10px">  
                                        <span class="text-light">
                                            <p>Caso já tenha alterado os DNS a <strong>mais de 24h</strong>, você poderá acessar usando o seu domínio:
                                        </span>
                                    </div>
                                    <div class="col-xs-12">  
                                        <span class="text-light">
                                            <p style="margin-bottom: 0 !important;"><a href="https://cpanel.{$domain}"" target="_blank">https://cpanel.{$domain} <i class="align-top fas fa-external-link-alt"></i></a></p>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-4">
                                    <div>
                                        <div class="col-xs-12">
                                            <span class="text-light text-small">
                                                Usuário cPanel:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="{$username}" value="{$username}" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="{$username}" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12">
                                            <span class="text-light text-small">
                                                Senha cPanel:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="password" name="password" id="inputPassword" data-copy="{$password}" value="{$password}" class="form-control js-tooltip js-copy" readonly="readonly" data-original-title="" title="">
                                                <span toggle="#password-field" data-toggle="tooltip" data-html="true" data-placement="bottom" title="Exibir Senha" class="fa fa-fw fa-eye fa-lg field-icon toggle-password"></span>
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="{$password}" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>    
                                        </div>
                                        <div class="col-xs-12">
                                            <span class="text-faded"><p style="margin-bottom: 0px!important;font-size: 11px;line-height: 16px;margin-top:7px">Problemas com a senha? Clique em <strong>Alterar a Senha</strong> no menu do lado esquerdo.</p>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane billingOverview" id="dns">
                            <div class="row" style="margin-bottom: 0px!important;">
                                <div class="col-sm-12 col-md-8">
                                    <div>
                                        <div class="col-xs-12" >
                                            <span class="text-light">
                                                <p>Caso deseje utilizar seu domínio <strong>{$domain}</strong> em sua conta cPanel, <strong>é necessário apontar o domínio para os nossos servidores de dns</strong>.
                                                Você deverá realizar essa alteração no site do registrador de domínio, onde você comprou o domínio <strong>{$domain}</strong>.</p>
                                            <span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>Caso você utilize DNS externos, tal como os DNS da <strong>CloudFlare</strong>, você precisará apontar na zona de dns o site para o <strong>IP do Servidor de Hospedagem</strong>.</p></span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light">
                                                <p>Você também pode acessar o seu site antecipadamente utilizando o <strong>endereço temporário</strong> abaixo, até que ocorra a propagação dos DNS aplicados no seu domínio:</p>
                                            </span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light">
                                                <p><a href="https://avalon.souzahost.com/~{$username}" target="_blank">https://avalon.souzahost.com/~{$username} <i class="align-top fas fa-external-link-alt"></i></a></p>
                                            </span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p><strong>Lembre-se:</strong> no geral, a propagação das alterações do DNS ocorre dentro de algumas horas. No entanto, pode levar até 48 horas para que a propagação alcance toda a internet. O tempo de propagação pode ser afetado por diversas questões, incluindo o TTL, seu ISP e o registro do domínio.</p>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-4">
                                    <div>
                                        <div class="col-xs-12">
                                            <span class="text-light text-small">
                                                DNS / IP:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="ns1.souzahost.com" value="ns1.souzahost.com" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="66.70.178.43" data-placement="right" title="" class="js-tooltip js-copy" data-original-title="Copiar" style="font-size: 11; min-width: 90px;">66.70.178.43</span></span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12" style="margin-top: 15px;">
                                            <div class="input-group">
                                                <input type="text" data-copy="ns2.souzahost.com" value="ns2.souzahost.com" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="15.235.102.1" data-placement="right" title="" class="js-tooltip js-copy" data-original-title="Copiar" style="font-size: 11; min-width: 90px;">15.235.102.1</span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12">
                                            <span class="text-faded">
                                                <p style="margin-bottom: 14px!important;font-size: 11px;line-height: 16px;margin-top:7px">Lembre-se que leva até 24h para que as alterações de DNS propaguem depois que os DNS são atualizados no domínio.</p>
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <span class="text-light text-small">
                                                IP do Servidor de Hospedagem:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="66.70.178.43" value="66.70.178.43" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="66.70.178.43" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane billingOverview" id="ftp">
                            <div class="row row-eq-height row-eq-height-sm" style="margin-bottom: 0px!important;">
                                <div class="col-sm-12 col-md-8">
                                    <div>
                                        <div class="col-xs-12" >
                                            <span class="text-light">
                                                <p>Você pode utilizar o <strong>Gerenciador de Arquivos</strong> no seu painel cPanel ou utilizar um cliente de FTP como o <a href="https://filezilla-project.org/" target="_blank">FileZilla</a>, para fazer upload de arquivos do seu site.</p>
                                            <span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>Aqui você encontrará informações sobre como conectar via FTP, seja utilizando o endereço do sevidor ou pelo seu próprio domínio, caso ele já esteja apontado para os nossos servidores, conforme já informado em detalhes na aba DNS.</p></span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>Para envio de muitos arquivos ou arquivos grandes recomendamos ao invés do gerenciador de arquivos um aplicativo de FTP: <a href="https://filezilla-project.org/" target="_blank">Download FileZilla</a></p>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-4">
                                    <div>
                                        <div class="col-xs-12">
                                            <div class="col-xs-12" style="padding-left:0!important">
                                                Conexão via FTP
                                            </div>
                                            <span class="text-light text-small">
                                                FTP Host Temporário:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="avalon.souzahost.com" value="avalon.souzahost.com" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="avalon.souzahost.com" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12">
                                            <span class="text-light text-small">
                                                FTP Host:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="ftp.{$domain}" value="ftp.{$domain}" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="ftp.{$domain}" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12">
                                            <span class="text-light text-small">
                                                Usuário / Porta:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="{$username}" value="{$username}" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="21" data-placement="right" title="" class="js-tooltip js-copy" data-original-title="Copiar" style="font-size: 11; min-width: 40px;">21</span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-faded"><p style="margin-bottom: 0px!important;font-size: 11px;line-height: 16px;margin-top:7px">A <strong>senha</strong> é a mesma do cPanel.</p>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane billingOverview" id="email">
                            <div class="row row-eq-height row-eq-height-sm" style="margin-bottom: 0px!important;">
                                <div class="col-sm-12 col-md-8">
                                    <div>
                                        <div class="col-xs-12" >
                                            <span class="text-light">
                                                <p>Para criar, remover e gerenciar as contas de email, no seu painel cPanel, clique em <strong>Contas de Email</strong>.</p>
                                            <span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>Caso deseje acessar através do navegador a caixa de email que criou basta utilizar o webmail, através do link abaixo:</p></span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light">
                                                <p><a href="https://webmail.{$domain}" target="_blank">https://webmail.{$domain} <i class="align-top fas fa-external-link-alt"></i></a>, ou<br>
                                                <a href="https://webmail.souzahost.com" target="_blank">https://webmail.souzahost.com <i class="align-top fas fa-external-link-alt"></i></a></p>
                                            </span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>Seus dados de login no webmail são o endereço de email completo que você criou a senha informada no cPanel na criação da caixa de e-mail.</p></span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>Para configurar um cliente de e-mail off-line, tal como Outlook, Windows Mail, Thunderbird, Mac Mail e outros, por favor utilize as seguintes configurações ao lado direito.</p></span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>Em aplicativos como <strong>Microsoft Outlook e Windows Live Mail</strong> a opção <strong>Servidor de Saída Requer Autenticação</strong> deve ser <strong>ativada</strong>.</p></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-4">
                                    <div>
                                        <div class="col-xs-12">
                                            <div class="col-xs-12" style="padding-left:0!important">
                                                Configuração
                                            </div>
                                            <span class="text-light text-small">
                                                Servidor de Entrada e de Saída:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="mail.souzahost.com" value="mail.souzahost.com" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="mail.souzahost.com" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12" style="margin-top: 15px;">
                                            <div class="input-group">
                                                <input type="text" data-copy="mail.{$domain}" value="mail.{$domain}" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="mail.{$domain}" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12" style="margin-top: 5px;">
                                            <span class="text-light text-small">
                                                Porta POP (Normal/SSL-TLS)
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="110" value="110" class="form-control js-tooltip js-copy" readonly="readonly" style="text-align: center">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="995" data-placement="right" title="" class="js-tooltip js-copy" data-original-title="Copiar" style="font-size: 11; min-width: 95px;text-align: center">995</span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12" style="margin-top: 5px;">
                                            <span class="text-light text-small">
                                                Porta IMAP (Normal/SSL-TLS)
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="143" value="143" class="form-control js-tooltip js-copy" readonly="readonly" style="text-align: center">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="993" data-placement="right" title="" class="js-tooltip js-copy" data-original-title="Copiar" style="font-size: 11; min-width: 95px;text-align: center">993</span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12" style="margin-top: 5px;">
                                            <span class="text-light text-small">
                                                Porta POP/IMAP (Normal/SSL-TLS)
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="587" value="587" class="form-control js-tooltip js-copy" readonly="readonly" style="text-align: center">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="465" data-placement="right" title="" class="js-tooltip js-copy" data-original-title="Copiar" style="font-size: 11; min-width: 95px;text-align: center">465</span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-faded"><p style="margin-bottom: 0px!important;font-size: 11px;line-height: 16px;margin-top:7px">Esta é a porta de saída POP/IMAP.</p>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane billingOverview" id="php" style="margin-bottom: 0px!important;">
                            <div class="row row-eq-height row-eq-height-sm ">
                                <div class="col-sm-12 col-md-12">
                                    <div>
                                        
                                        <div class="col-xs-12" >
                                            <span class="text-light">
                                                <p>Posuímos duas opções de <strong>Seletores de Versão do PHP</strong>, são eles:</p>
                                            <span>
                                        </div>
                                        <div class="col-xs-12">
                                            <p>Selecionar Versão do PHP <smaill style="font-size: 13px; color: #ACB4C1">Seletor CloudLinux (RECOMENDADO)</smaill></p>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>Esse seletor é o que recomendamos para uso, nele é possível determinar a versão do PHP da conta de hospedagem inteira, essa configuração é aplicada através do CloudLinux de forma mais eficiente, sem a utilização de um arquivo <strong>.htaccess</strong></p></span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>Nesse seletor é possível também a <strong>personalização de extensões do PHP</strong> de forma prática, através da interface, além também da configuração de algumas opções do PHP, de forma mais eficiente, sem a utilização de um arquivo <strong>user.ini</strong> e <strong>php.ini</strong>.</p></span>
                                        </div>
                                        <div class="col-xs-12">
                                            <p>Gerenciador de MultiPHP <smaill style="font-size: 13px; color: #ACB4C1">Seletor Nativo</smaill></p>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>Nesse seletor, é possível determinar separadamente a versão no domínio principal e em subdomínios, essa configuração será aplicada através de um arquivo <strong>.htaccess</strong> na raiz do domínio/subdomínio onde foi aplicado..</p></span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>Importante ressaltar que apenas versões do PHP do tipo <strong>ea-php</strong> dever ser utilizado, pois as versões <strong>alt-php</strong> são utilizadas apenas no outro seletor.</p></span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>A personalização de configurações do PHP desse seletor é feito através do ícone <strong>MultiPHP INI Editor</strong> e tais configurações são aplicadas através de um arquivo <strong>user.ini</strong> e <strong>php.ini</strong> na raiz do domínio/subdomínio.</p></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="tab-pane billingOverview" id="mysql">
                            <div class="row row-eq-height row-eq-height-sm" style="margin-bottom: 0px!important;">
                                <div class="col-sm-12 col-md-8">
                                    <div>
                                        <div class="col-xs-12" >
                                            <span class="text-light">
                                                <p>Para criar, remover e gerenciar os banco de dados, no seu painel cPanel, clique:</p>
                                            <span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>-- No ícone <strong>Banco de dados MySQL</strong> para gerenciar os bancos e usuários MySQL</p></span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>-- No ícone <strong>Banco de dados PostGreSQL</strong> para gerenciar os bancos e usuários PostGreSQL</p></span>
                                        </div>
                                        
                                        <div class="col-xs-12" >
                                            <span class="text-light">
                                                <p>Para gerenciar o conteúdo dos banco de dados criados, clique:</p>
                                            <span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>-- No ícone <strong>phpMyAdmin</strong> para gerenciar os banco de dados MySQL</p></span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>-- No ícone <strong>phpPgAdmin</strong> para gerenciar os banco de dados PostGreSQL</p></span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light"><p>Para fazer <strong>acesso remoto</strong> em um banco de dados MySQL, clique no ícone <strong>MySQL Remoto</strong> para liberar o acesso remoto, para bancos de dados PostGreSQL o acesso remoto deve ser solicitado via <strong>chamado de suporte</strong>.</p></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-4">
                                    <div>
                                        <div class="col-xs-12">
                                            <div class="col-xs-12" style="padding-left:0!important">
                                                Conexão para acesso remoto
                                            </div>
                                            <span class="text-light text-small">
                                                Host:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="66.70.178.43" value="66.70.178.43" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="66.70.178.43" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12" style="margin-top: 15px;">
                                            <div class="input-group">
                                                <input type="text" data-copy="avalon.souzahost.com" value="avalon.souzahost.com" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="avalon.souzahost.com" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12" style="margin-top: 5px;">
                                            <span class="text-light text-small">
                                                Porta MySQL / PostGreSQL
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="3306" value="3306" class="form-control js-tooltip js-copy" readonly="readonly" style="text-align: center">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="5432" data-placement="right" title="" class="js-tooltip js-copy" data-original-title="Copiar" style="font-size: 11; min-width: 95px;text-align: center">5432</span></span>
                                            </div>
                                        </div>
                                        
                                        <div class="col-xs-12">  
                                            <span class="text-faded"><p style="margin-bottom: 0px!important;font-size: 11px;line-height: 16px;margin-top:7px">Esta é a porta de saída POP/IMAP.</p>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                   
            </div>

        </div>
        
    </div>
    {* Infos end *}
        {if count($wpInstances) || $allowWpClientInstall}
            <div class="section">
                <h3>WordPress®</h3>
                <div class="panel panel-default" id="cPanelWordPress" data-service-id="{$serviceId}" data-wp-domain="{$wpDomain}">
                    <div class="panel-body" {if !count($wpInstances)}style="display: none" {/if}>
                        <div class="row{if !$allowWpClientInstall} no-margin{/if}" id="wordpressInstanceRow" >
                            <div class="col-md-4">
                                <select class="form-control" id="wordPressInstances">
                                    {foreach $wpInstances as $wpInstance}
                                        <option value="{$wpInstance.instanceUrl}">
                                            {$wpInstance.blogTitle}
                                            {if $wpInstance.path} ({$wpInstance.path}){/if}
                                        </option>
                                    {/foreach}
                                </select>
                            </div>
                            <div class="col-md-4">
                                <button class="btn btn-outline btn-block" id="btnGoToWordPressHome">
                                    <i class="ls ls-dashboard"></i>
                                    {$LANG.cPanel.wptk.goToWebsite}
                                </button>
                            </div>
                            <div class="col-md-4">
                                <button class="btn btn-outline btn-block" id="btnGoToWordPressAdmin">
                                    <i class="ls ls-sign-in"></i>
                                    {$LANG.cPanel.wptk.goToAdmin}
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="panel-body panel-form">        
                        <div class="row" {if !$allowWpClientInstall}style="display: none"{/if}>
                            <div class="col-md-12">
                                <h5>{$LANG.cPanel.wptk.createNew}</h5>
                                <p class="small" id="newWordPressFullUrlPreview">https://{$wpDomain}/</p>
                            </div>
                            <div class="col-md-12" id="wordPressInstallResultRow" style="display: none">
                                <div class="alert alert-success" style="display: none">
                                    {$LANG.cPanel.wptk.installationSuccess}
                                </div>
                                <div class="alert alert-danger" style="display: none">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <input type="text" class="form-control" id="wpNewBlogTitle" placeholder="New Blog Title" />
                            </div>
                            <div class="col-md-3">
                                <input type="text" class="form-control" id="wpNewPath" placeholder="Path (optional)" />
                            </div>
                            <div class="col-md-3">
                                <input type="password" class="form-control" id="wpAdminPass" placeholder="Admin Password" />
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-primary btn-block" id="btnInstallWordpress">
                                    <i class="fal fa-plus"></i>
                                    {$LANG.cPanel.wptk.installWordPressShort}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        {/if}
        <div class="section">
            <div class="section-header">
                <h2 class="section-title">{$LANG.cPanel.quickShortcuts}</h2>
            </div>
            <div class="section-body">
                <div class="panel panel-default" id="cPanelQuickShortcutsPanel">
                    <div class="panel-body">
                        <div class="row cpanel-feature-row">
                            <div class="col-sm-3 col-xs-6" id="cPanelEmailAccounts">
                                <a class="btn btn-link btn-block" href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Email_Accounts" target="_blank">
                                    <i class="lm lm-user"></i>
                                    {$LANG.cPanel.emailAccounts}
                                </a>
                            </div>
                            <div class="col-sm-3 col-xs-6" id="cPanelForwarders">
                                <a class="btn btn-link btn-block" href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Email_Forwarders" target="_blank">
                                    <i class="lm lm-arrow-fat-right"></i>
                                    {$LANG.cPanel.forwarders}
                                </a>
                            </div>
                            <div class="col-sm-3 col-xs-6" id="cPanelAutoResponders">
                                <a class="btn btn-link btn-block" href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Email_AutoResponders" target="_blank">
                                    <i class="lm lm-arrow-fat-left"></i>
                                    {$LANG.cPanel.autoresponders}
                                </a>
                            </div>
                            <div class="col-sm-3 col-xs-6" id="cPanelFileManager">
                                <a class="btn btn-link btn-block" href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=FileManager_Home" target="_blank">
                                    <i class="lm lm-folder"></i>
                                    {$LANG.cPanel.fileManager}
                                </a>
                            </div>
                        </div>
                        <div class="row cpanel-feature-row">
                            <div class="col-sm-3 col-xs-6" id="cPanelBackup">
                                <a class="btn btn-link btn-block" href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Backups_Home" target="_blank">
                                    <i class="lm lm-backup"></i>
                                    {$LANG.cPanel.backup}
                                </a>
                            </div>
                            <div class="col-sm-3 col-xs-6" id="cPanelSubdomains">
                                <a class="btn btn-link btn-block" href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Domains_SubDomains" target="_blank">
                                    <i class="lm lm-globe"></i>
                                    {$LANG.cPanel.subdomains}
                                </a>
                            </div>
                            <div class="col-sm-3 col-xs-6" id="cPanelAddonDomains">
                                <a class="btn btn-link btn-block" href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Domains_AddonDomains" target="_blank">
                                    <i class="lm lm-plus-circle"></i>
                                    {$LANG.cPanel.addonDomains}
                                </a>
                            </div>
                            <div class="col-sm-3 col-xs-6" id="cPanelCronJobs">
                                <a class="btn btn-link btn-block" href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Cron_Home" target="_blank">
                                    <i class="lm lm-clock"></i>
                                    {$LANG.cPanel.cronJobs}
                                </a>
                            </div>
                        </div>
                        <div class="row cpanel-feature-row">
                            <div class="col-sm-3 col-xs-6" id="cPanelMySQLDatabases">
                                <a class="btn btn-link btn-block" href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Database_MySQL" target="_blank">
                                    <i class="lm lm-database"></i>
                                    {$LANG.cPanel.mysqlDatabases}
                                </a>
                            </div>
                            <div class="col-sm-3 col-xs-6" id="cPanelPhpMyAdmin">
                                <a class="btn btn-link btn-block" href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Database_phpMyAdmin" target="_blank">
                                    <i class="lm lm-php-admin"></i>
                                    {$LANG.cPanel.phpMyAdmin}
                                </a>
                            </div>
                            <div class="col-sm-3 col-xs-6" id="cPanelAwstats">
                                <a class="btn btn-link btn-block" href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;dosinglesignon=1&amp;app=Stats_AWStats" target="_blank">
                                    <i class="lm lm-line-graph"></i>
                                    {$LANG.cPanel.awstats}
                                </a>
                            </div>
                            {if $hasWPTDeluxe}
                                <div class="col-sm-3 col-xs-6" id="cPanelWptk">
                                    <a class="btn btn-link btn-block" href="clientarea.php?action=productdetails&amp;id={$serviceid}&amp;addonId={$wptkDeluxeAddonId}&amp;doaddonsignon=1" target="_blank" class="d-block mb-3">
                                        <i class="lm lm-layout"></i>
                                        {$LANG.cPanel.wptk}
                                    </a>
                                </div>
                            {/if}
                        </div>
                    </div>
                </div>
            </div>
        </div>    
        <div class="section">
            <div class="section-header">
                <h2 class="section-title">{$LANG.cPanel.createEmailAccount}</h2>
            </div>
            <div class="section-body">
                <div class="panel panel-default panel-form" id="cPanelQuickEmailPanel">
                    <div class="panel-body">
                        {include file="$template/includes/alert.tpl" type="success" msg=$LANG.cPanel.emailAccountCreateSuccess textcenter=true hide=true idname="emailCreateSuccess" additionalClasses="email-create-feedback"}
                        {include file="$template/includes/alert.tpl" type="danger" msg=$LANG.cPanel.emailAccountCreateFailed|cat:' <span id="emailCreateFailedErrorMsg"></span>' textcenter=true hide=true idname="emailCreateFailed" additionalClasses="email-create-feedback"}
                        <form id="frmCreateEmailAccount" onsubmit="doEmailCreate();return false">
                            <input type="hidden" name="id" value="{$serviceid}" />
                            <input type="hidden" name="email_quota" value="250" />
                            <div class="row row-sm">
                                <div class="form-group col-sm-6 m-b-0x">
                                    <label>{$LANG.contactemail}</label>
                                    <div class="input-group">
                                        <input type="text" name="email_prefix" class="form-control" placeholder="{$LANG.cPanel.usernamePlaceholder}">
                                        <span class="input-group-addon">@{$domain}</span>
                                    </div>
                                </div>
                                <div class="form-group col-sm-6 m-b-0x">
                                    <label>{$LANG.clientareapassword}</label>
                                    <div class="input-group">
                                        <input type="password" name="email_pw" class="form-control" placeholder="{$LANG.cPanel.passwordPlaceholder}">
                                        <div class="input-group-append">
                                            <button type="submit" class="btn btn-primary btn-block">{$LANG.cPanel.create}</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>    
        </div>
    {else}
        <div class="alert alert-warning text-center d-block" role="alert" id="cPanelSuspendReasonPanel">
            {if $suspendreason}
                <strong>{$suspendreason}</strong><br />
            {/if}
            {$LANG.cPanel.packageNotActive} {$status}.<br />
            {if $systemStatus eq "Pending"}
                {$LANG.cPanel.statusPendingNotice}
            {elseif $systemStatus eq "Suspended"}
                {$LANG.cPanel.statusSuspendedNotice}
            {/if}
        </div>
    {/if}
    {foreach $hookOutput as $output}
        <div class="section section-hook-output no-float-banner">
            {$output}
        </div>  
    {/foreach}
    {if $availableAddonProducts}
        <div class="section">
            <div class="section-header">
                <h2 class="section-title">{$LANG.cPanel.addonsExtras}</h2>
            </div>
            <div class="section-body">
                <div class="panel panel-form" id="cPanelExtrasPurchasePanel">
                    <div class="panel-body">
                        <form method="post" action="cart.php?a=add">
                            <input type="hidden" name="serviceid" value="{$serviceid}" />
                            <div class="row row-sm">
                                <div class="col-sm-8">
                                <select name="aid" class="form-control">
                                    {foreach $availableAddonProducts as $addonId => $addonName}
                                        <option value="{$addonId}">{$addonName}</option>
                                    {/foreach}
                                </select>
                                </div>
                                <div class="col-sm-4">
                                    <button type="submit" class="btn btn-primary btn-block">
                                        {$LANG.cPanel.purchaseActivate}
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>    
    {/if}
    <div class="section">
        <div class="section-body">
            <div class="panel panel-default">
                <ul class="panel-tabs nav nav-tabs">
                    <li>
                        <a href="#billingInfo" data-toggle="tab" class="active"><i class="ls ls-wallet"></i> {$LANG.cPanel.billingOverview}</a>
                    </li>
                    <li>
                        <a href="#domainInfo" data-toggle="tab" aria-expanded="true"><i class="ls ls-location"></i>{$LANG.clientareahostingdomain}</a>
                    </li>
                    {if $metricStats}
                    <li>
                        <a href="#tab-metrics" data-toggle="tab" aria-expanded="true"><i class="ls ls-location"></i>{$LANG.metrics.title}</a>
                    </li>
                    {/if}
                    {if $customfields}
                    <li>
                        <a href="#customFields" data-toggle="tab" aria-expanded="true"><i class="ls ls-hosting"></i> {$LANG.additionalInfo}</a>
                    </li>
                    {/if}
                    {if $configurableoptions}
                    <li>
                        <a href="#confiOptions" data-toggle="tab" aria-expanded="false"><i class="ls ls-configure"></i> {$LANG.orderconfigpackage}</a>
                    </li>
                    {/if}
                </ul>
                <div class="tab-content">
                    <div class="panel-body tab-pane active billingOverview" id="billingInfo">
                        <div class="row">				
                            {if $firstpaymentamount neq $recurringamount}
                            <div class="col-sm-6 col-md-3 m-b-2x">
                                <div class="text-faded text-small">
                                    {$LANG.firstpaymentamount}
                                </div>
                                <div>
                                    {$firstpaymentamount}
                                </div>
                            </div>
                            {/if}
                            <div class="col-sm-6 col-md-3 m-b-2x">
                                <div class="text-faded text-small">
                                        {$LANG.clientareahostingregdate}
                                </div>
                                <div>
                                    {$regdate}
                                </div>
                            </div>
                            {if $billingcycle != $LANG.orderpaymenttermonetime && $billingcycle != $LANG.orderfree}
                                <div class="col-sm-6 col-md-3 m-b-2x">
                                    <div class="text-faded text-small">
                                        {$LANG.recurringamount}
                                    </div>
                                    <div>
                                        {$recurringamount}
                                    </div>
                                </div>
                            {/if}
                            <div class="col-sm-6 col-md-3 m-b-2x">
                                <div class="text-faded text-small">
                                    {$LANG.clientareahostingnextduedate}
                                </div>
                                <div>
                                    {$nextduedate}
                                </div>
                            </div>
                            <div class="col-sm-6 col-md-3 m-b-2x">
                                <div class="text-faded text-small">
                                    {$LANG.orderbillingcycle}
                                </div>
                                <div>
                                    {$billingcycle}
                                </div>
                            </div>
                            <div class="col-sm-6 col-md-3 m-b-2x">
                                <div class="text-faded text-small">
                                    {$LANG.orderpaymentmethod}
                                </div>
                                <div>
                                    {$paymentmethod}
                                </div>
                            </div>
                        </div>			
                    </div>
                    <div class="panel-body tab-pane" id="domainInfo">
                        <div class="cpanel-actions-container">
                            <p class="text-center">{$domain}</p>
                            <div class="cpanel-actions-btn">
                                <a href="http://{$domain}" class="btn btn-primary" target="_blank">{$LANG.visitwebsite}</a>
                                {if $domainId}
                                    <a href="clientarea.php?action=domaindetails&id={$domainId}" class="btn btn-primary" target="_blank">{$LANG.managedomain}</a>
                                {/if}
                                <input type="button" onclick="popupWindow('whois.php?domain={$domain}','whois',650,420);return false;" value="{$LANG.whoisinfo}" class="btn btn-primary" />
                            </div>
                        </div>
                    </div>
                    {if $metricStats}
                    <div class="tab-pane" id="tab-metrics">
                        <div id="cPanelMetricStatsPanel">
                            {include file="$template/clientareaproductusagebilling.tpl"}
                        </div>
                    </div>    
                    {/if}
                    {if $customfields}
                    <div class="tab-pane" id="customFields">
                        <ul class="list-info list-info-50 list-info-bordered">
                            {foreach from=$customfields item=field}
                                <li>
                                    <span class="list-info-title">{$field.name}</span>
                                    <span class="list-info-text">
                                        {if empty($field.value)}
                                            {$LANG.blankCustomField}
                                        {else}
                                            {$field.value}
                                        {/if}
                                    </span>
                                </li>
                            {/foreach}
                        </ul>
                    </div>
                    {/if}
                    {if $configurableoptions}
                    <div class="tab-pane" id="confiOptions">
                        <ul class="list-info list-info-50 list-info-bordered">
                            {foreach from=$configurableoptions item=configoption}
                                <li>
                                    <span class="list-info-title">{$configoption.optionname}</span>
                                    <span class="list-info-text">{if $configoption.optiontype eq 3}{if $configoption.selectedqty}{$LANG.yes}{else}{$LANG.no}{/if}{elseif $configoption.optiontype eq 4}{$configoption.selectedqty} x {$configoption.selectedoption}{else}{$configoption.selectedoption}{/if}</span>
                                </li>
                            {/foreach}
                        </ul>
                    </div>
                    {/if}
                </div>
            </div>
        </div>
    </div>
{/if}    