<?php

namespace wappi\App\Api\Cliente;

class Whatsapp {

    private $url;
    private $sessao;
    private $apiKey;

    public function __construct($url,$sessao,$apiKey) {

        $this->url      =   $url;
        $this->sender   =   $sessao;
        $this->apiKey   =   $apiKey;

    }
    
    private function send($method,$resource,$request = []) {
        
        // ENDPINT COMPLETO
        $endpoint 	=	$this->url . $resource;


        // HEADERS
		$headers 	=	[

			"Cache-Control: no-cache",
			"Content-type: application/json",

		];
		
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
          CURLOPT_URL               => $endpoint,
          CURLOPT_RETURNTRANSFER    => true,
          CURLOPT_ENCODING          => '',
          CURLOPT_MAXREDIRS         => 10,
          CURLOPT_TIMEOUT           => 0,
          CURLOPT_FOLLOWLOCATION    => true,
          CURLOPT_HTTP_VERSION      => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST     => 'POST',
          CURLOPT_POSTFIELDS        => json_encode($request),
          CURLOPT_HTTPHEADER 		=> 	$headers,
        ));
        
        $response = curl_exec($curl);
        curl_close($curl);
        return json_decode($response,true);
        
    }
    
    
    private function send222($method,$resource,$request = []) {

        // ENDPINT COMPLETO
        $endpoint 	=	$this->url . $resource;


        // HEADERS
		$headers 	=	[

			"Cache-Control: no-cache",
			"Content-type: application/json",

		];

        // Configuração do CURL

		$curl = curl_init();

        curl_setopt_array($curl,[

        	CURLOPT_URL 			=> 	$endpoint,
            CURLOPT_RETURNTRANSFER 	=> 	true,
            CURLOPT_ENCODING        => '',
            CURLOPT_MAXREDIRS       => 10,
            CURLOPT_TIMEOUT         => 0,
            CURLOPT_FOLLOWLOCATION  => true,
            CURLOPT_HTTP_VERSION    => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST 	=> 	$method,
            CURLOPT_HTTPHEADER 		=> 	$headers,
            CURLOPT_SSL_VERIFYHOST  =>  false,
            CURLOPT_SSL_VERIFYPEER  =>  false

        ]);

        switch ($method) {
        	case "POST":
        	case "PUT":

        		curl_setopt($curl, CURLOPT_POSTFIELDS,json_encode($request));
        		break;
        }

        // EXECUTA O CURL

        $response = curl_exec($curl);
        curl_close($curl);

        return json_decode($response,true);

    }

    
    public function Trata_Numero($tel) {

        $tel = str_replace("-", "", $tel);
        $tel = str_replace("(", "", $tel);
        $tel = str_replace(")", "", $tel);
        $tel = str_replace("_", "", $tel);
        $tel = str_replace(" ", "", $tel);
        $tel = str_replace("+", "", $tel);
        $tel = trim($tel);

        if (strlen($tel) > 12) {

            $inicio = substr($tel, 0, 4);
            $fim =  substr($tel, -8);
            $tel = $inicio.$fim;
          
        }

        return $tel;

    }

    public function Logs_Add($Logs) {

        $Wappi_Query_AddLogs =   "INSERT INTO api_whatsapp_logs (Log, Data) VALUES ('".$Logs."', '" . date("Y-m-d h:i:sa") . "')";
        $result = mysql_query($Wappi_Query_AddLogs) or die(mysql_error());

        return $result;

    }

    public function SimularPresenca($numero,$state) {

        $request    =   [
            "chatId"    =>  $numero,
            "state"     =>  $state
        ];

        //return $this->send("POST","/whatsapp/setpresence",$request);

    }

    public function PinChat($numero) {

        $request    =   [
            "chatId"    =>  $numero,
            "option"    =>  "true"
        ];

        //return $this->send("POST","/whatsapp/pinchat",$request);

    }

    public function ArquivarChat($numero) {

        $request    =   [
            "chatId"    =>  $numero,
            "option"    =>  "true"
        ];

        //return $this->send("POST","/whatsapp/archivechat",$request);

    }

    public function MarcarMensagensLida($numero) {

        $request    =   [
            "chatId"    =>  $numero,
        ];

        //return $this->send("POST","/whatsapp/markread",$request);

    }

    public function EnviarMensagemTexto($telefone,$texto) {

        $Numero_Recebedio   =   ltrim(preg_replace('/\D/', '', $telefone), 0);
        $Numero_Recebedio   =   $this->Trata_Numero($Numero_Recebedio);
        
        $this->SimularPresenca($Numero_Recebedio,"c");

        if((strlen($Numero_Recebedio) < 5)) {

            $this->Logs_Add("[ERROR][{$Numero_Recebedio}] {$send["message"]}.");
            return;

        } else {

            $request    =   [
                'api_key'   => $this->apiKey,
                'sender'    => $this->sender,
                'number'    => $Numero_Recebedio,
                'message'   => str_replace("amp;", "", $texto),
            ];
    
            $send = $this->send("POST","/send-message", $request); /// EDILSON
    
            if(($send["status"] == 'true')) {
    
                $this->Logs_Add("[SUCESSO][{$Numero_Recebedio}] Mensagem adicionada a fila de envio com sucesso.");
    
            } else {
    
                $this->Logs_Add("[ERROR][{$Numero_Recebedio}] {$send["msg"]}.");
    
            }
    

        }

    }

    public function EnviarMensagemTexto_Nove($telefone,$texto) {

        $Numero_Recebedio   =   ltrim(preg_replace('/\D/', '', $telefone), 0);
        
        $this->SimularPresenca($Numero_Recebedio,"c");

        if((strlen($Numero_Recebedio) < 5)) {

            $this->Logs_Add("[ERROR][{$Numero_Recebedio}] {$send["message"]}.");
            return;

        } else {

            $request    =   [
                'api_key'   => $this->apiKey,
                'sender'    => $this->sender,
                'number'    => $Numero_Recebedio,
                'message'   => str_replace("amp;", "", $texto),
            ];
    
            $send = $this->send("POST","/send-message", $request); /// EDILSON
    
            if(($send["status"] == 'true')) {
    
                $this->Logs_Add("[SUCESSO][{$Numero_Recebedio}] Mensagem adicionada a fila de envio com sucesso.");
    
            } else {
    
                $this->Logs_Add("[ERROR][{$Numero_Recebedio}] {$send["msg"]}.");
    
            }
    

        }

    }

    public function EnviarMensagemArquivo($telefone,$file) {

        $extensao = strtolower(end(explode('.',$file)));

        $NomeArquivo    =   md5(date("Y-m-d h:i:sa") . $file) . $extensao;

        $Numero_Recebedio   =   ltrim(preg_replace('/\D/', '', $telefone), 0);
        $Numero_Recebedio   =   $this->Trata_Numero($Numero_Recebedio);

        $this->SimularPresenca($Numero_Recebedio,"c");

        if((strlen($Numero_Recebedio) < 5)) {

            $this->Logs_Add("[ERROR][{$Numero_Recebedio}] {$send["message"]}.");

            return;

        } else {

            $request    =   [
                "number"    =>  $Numero_Recebedio,
                "fileUrl"   =>  $file,
                "caption"   =>  $NomeArquivo
            ];
    
            $send   =   $this->send("POST","/send-media",$request);
    
            if(($send["status"] == 200)) {
    
                $this->Logs_Add("[SUCESSO][{$Numero_Recebedio}] Mensagem adicionada a fila de envio com sucesso.");
    
            } else {
    
                $this->Logs_Add("[ERROR][{$Numero_Recebedio}] {$send["message"]}.");
    
            }

        }


    }

    public function EnviarMensagemImagem($telefone,$texto,$imagem) {

        $Numero_Recebedio   =   ltrim(preg_replace('/\D/', '', $telefone), 0);
        $Numero_Recebedio   =   $this->Trata_Numero($Numero_Recebedio);

        $this->SimularPresenca($Numero_Recebedio,"c");

        if((strlen($Numero_Recebedio) < 5)) {

            $this->Logs_Add("[ERROR][{$Numero_Recebedio}] {$send["message"]}.");

            return;

        } else {

            $request    =   [
                "number"    =>  $Numero_Recebedio,
                "caption"   =>  $texto,
                "fileUrl"   =>  $imagem
            ];
    
            $send   =   $this->send("POST","/send-media",$request);
    
            if(($send["status"] == 200)) {
    
                $this->Logs_Add("[SUCESSO][{$Numero_Recebedio}] Mensagem adicionada a fila de envio com sucesso.");
    
            } else {
    
                $this->Logs_Add("[ERROR][{$Numero_Recebedio}] {$send["message"]}.");
    
            }

        }

    }

    public function EnviarBotao($telefone,$texto,$buttons) {
		
		$buttonsMD	=	explode(",",$buttons);

        $Numero_Recebedio   =   ltrim(preg_replace('/\D/', '', $telefone), 0);

        $this->SimularPresenca($Numero_Recebedio,"c");

        if((strlen($Numero_Recebedio) < 5)) {

            $this->Logs_Add("[ERROR][{$Numero_Recebedio}] {$send["message"]}.");

            return;

        } else {

            $request    =   [
                "chatId"    =>  $Numero_Recebedio,
                "title"     =>  $texto,
                "button1"   =>  $buttonsMD[0] . ",ID1",
				"button2"   =>  $buttonsMD[1] . ",ID2",
				"button3"	=>	$buttonsMD[2] . ",ID3",
                "description"   =>  "Escolha uma opção para darmos inicio ao seu atendimento"
            ];
    
            $send   =   '';  //$this->send("POST","/whatsapp/send/buttonsreply",$request);
    
            if(($send["status"] == 200)) {
    
                $this->Logs_Add("[SUCESSO][{$Numero_Recebedio}] Mensagem adicionada a fila de envio com sucesso.");
    
            } else {
    
                $this->Logs_Add("[ERROR][{$Numero_Recebedio}] {$send["message"]}.");
    
            }

        }

    }

    public function FotoPerfilChat($telefone) {

        $request    =   [
            "chatId"    =>  ltrim(preg_replace('/\D/', '', $telefone), 0),
        ];

        //return $this->send("POST","/whatsapp/profilepic",$request);

    }


    public function SalvarMidia($telefone,$msgId) {

        $request    =   [
            "chatId"    =>  ltrim(preg_replace('/\D/', '', $telefone), 0),
            "msgId"     =>  $msgId,
            "filename"  =>  md5($telefone . $msgId)
        ];

        //return $this->send("POST","/whatsapp/decryptByIdFileSave",$request);

    }

    public function DescriptMidiaRemota($telefone,$msgId) {

        $request    =   [
            "chatId"    =>  ltrim(preg_replace('/\D/', '', $telefone), 0),
            "msgId"     =>  $msgId
        ];

        //return $this->send("POST","/whatsapp/decryptremote",$request);

    }

    public function ObterInformacoesWhatsappConectado() {
        
        //return $this->send("POST","/whatsapp/gethostdevice");

    }

    public function AdicionarMsgFila($numero,$tipo,$mensagem,$arquivo) {

        $Wappi_Adicionar_Fila_Query =   "INSERT INTO api_whatsapp_fila_envio (numero, tipo_msg, mensagem, arquivo, data_envio, status) VALUES ('".$numero."', '" . $tipo . "', '" . $mensagem . "', '" . $arquivo . "', '" . date("Y-m-d h:i:s") . "', '0')";
        $result = mysql_query($Wappi_Adicionar_Fila_Query) or die(mysql_error());

        return $result;

    }
    
}