{if file_exists("templates/$template/store/ssl/shared/overwrites/certificate-pricing.tpl")}
    {include file="{$template}/store/ssl/shared/overwrites/certificate-pricing.tpl"}  
{else} 
    <div class="site-section{if $secondarySectionStyle == 'secondary'} section-secondary{else if $secondarySectionStyle == 'primary'} section-primary{/if}" id="pricing" {$type}>
        <div class="container">
            <h2 class="section-title">{lang key='store.ssl.shared.pricing'}</h2>
            <div class="section-content certificate-options">
                <div class="row row-eq-height row-eq-height-xs">
                    {if count($certificates.$type) > 0}
                        {foreach $certificates.$type as $product}
                            <div class="col-md-{if count($certificates.$type) == 1}12{elseif count($certificates.$type) == 2}6{else}4{/if}">
                                <div class="package package-lg {if $hasFeatured.$type && $product->isFeatured} package-featured{/if}">
                                    {if $hasFeatured.$type && $product->isFeatured}
                                        <span class="label-corner label-primary">{$rslang->trans('order.featured')}</span>
                                    {/if}
                                    <h4 class="package-title">{$product->name}</h4>
                                    <div class="package-price">
                                        <div class="price">
                                            {if $product->pricing()->annual()}
                                                {include file="$template/includes/common/price.tpl" 
                                                    price=$product->pricing()->annual()->yearlyPrice()|replace:"/":""|replace:$LANG.pricingCycleShort.annually:''
                                                    priceCycle="annually"
                                                }  
                                            {/if}
                                            {if $product->pricing()->biennial() && !$product->pricing()->annual()}
                                                {include file="$template/includes/common/price.tpl" 
                                                    price=$product->pricing()->biennial()->yearlyPrice()|replace:"/":""|replace:$LANG.pricingCycleShort.annually:''
                                                    priceCycle="biennially"
                                                }  
                                            {/if}
                                        </div>
                                    </div>    
                                    <ul class="package-features">                              
                                        <li>{lang key='store.ssl.shared.encryption256'}</li>
                                        <li>{lang key='store.ssl.shared.issuanceTime'}: {$certificateFeatures.{$product->configoption1}.issuance}</li>
                                        <li>{lang key='store.ssl.shared.greatFor'}: <b>{$certificateFeatures.{$product->configoption1}.for} </b> </li>
                                        <li>{lang key='store.ssl.shared.warrantyValue'}: <b>USD ${$certificateFeatures.{$product->configoption1}.warranty}</b></li>
                                        <li>{lang key='store.ssl.shared.siteSeal'}</li>
                                        <li>{lang key='store.ssl.shared.freeReissues'}</li>
                                        <li>{lang key='store.ssl.shared.browserSupport'}: <b>99.9%</b></li>
                                    </ul>
                                    <div class="package-actions">
                                        <form method="post" action="{routePath('cart-order')}">
                                            <input type="hidden" name="pid" value="{$product->id}">
                                            <button type="submit" class="btn btn-lg btn-primary{if $secondarySectionStyle == 'primary'}-faded{/if} btn-block">{$LANG.store.ssl.landingPage.buyNow}</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        {/foreach}
                    {else}
                    <div class="col-9">
                        <div class="lead preview-text">
                            {lang key='store.ssl.shared.noProducts'}
                        </div>
                    </div>
                    {/if}
                </div>
            </div>
        </div>
    </div>                
{/if}