<?php
/**
 * PagSeguro - Módulo SouzaHost para integração com WHMCS
 * 
 * @package    PagSeguro para WHMCS
 * @version    1.0.4
 * @author     Mantido por Edilson Souza - https://edilson.site/
 * @license    BSD License (3-clause)
 * @copyright  (c) 2017-2019, SouzaHost
 * @link       https://www.souzahost.com.br/modulo-pagseguro-api
 **/



function souzapagseguro_config()
{
	
	// Verificar IP do servidor
	$moduloid = '245';	// ID do Produto Módulo PagSeguro API
	$host_ip = $_SERVER['SERVER_ADDR'];
	$host_ip_int = (int)preg_replace("/[^0-9]/", "", $host_ip);
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, "https://www.souzahost.com.br/modulos/?moduloip=" . $host_ip_int . "&moduloid=" . $moduloid );
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch,CURLOPT_USERAGENT,$_SERVER['HTTP_USER_AGENT']);

	$check_ip =  curl_exec($ch);
	$check_ip_int = (int)preg_replace("/[^0-9]/", "", $check_ip);
	
	if (!empty($check_ip_int) && ($check_ip_int == $host_ip_int)) {
		$ip_message = '<i class="fas fa-check-circle" style="color:#46A546;"></i> Ativa'; 
	} else if (!empty($check_ip_int) && ($check_ip_int == 'Suspended')) {
		$ip_message = '<i class="fas fa-exclamation-circle" style="color:#F89406;"></i> Suspensa | <a style="color:#d3678d;" href="https://www.souzahost.com.br/modulo-pagseguro-api/#contact_form" target="_blank">Entre em Contato</a>';
	} else {
		$ip_message = '<i class="fas fa-exclamation-circle" style="color:#0768B8;"></i> Pendente | <a style="color:#d3678d;" href="https://www.souzahost.com.br/modulo-pagseguro-api/#contact_form" target="_blank">Entre em Contato</a>';
	}
		
	// Fim
	
	
	// Verify available updates
	
		$modulolv = '1.0.17'; 
		$modulolv_int = (int)preg_replace("/[^0-9]/", "", $modulolv);
		
	/*function shps_verify_module_updates() {
   		$query = 'https://www.souzahost.com.br/modulos/?moduloiv=mpagseguro';
    	$curl = curl_init();
    	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
    	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
    	curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
    	curl_setopt($curl, CURLOPT_URL, $query);
    	
		$result = curl_exec($curl);
    	$http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);
		return array(
			'http_status' => $http_status,
			'result' => $result,
		);
	}*/

	$available_update_ = 0; //shps_verify_module_updates();
	$available_update = 0; //$available_update_['result'];
	$available_update_int = 0; //(int)preg_replace("/[^0-9]/", "", $available_update);
	
	if( $available_update_int === $modulolv_int ) {
		$available_update_message = $available_update.' <i class="fas fa-check-circle" style="color:#4E7408;"></i> Você está executando a versão mais recente!';
	}
	if( $available_update_int > $modulolv_int ) {
		$available_update_message = $available_update.' <i class="fas fa-exclamation-circle" style="color:#d3678d;"></i> Atualização disponível, <a style="color:#d3678d;" href="https://www.souzahost.com.br/modulo-pagseguro-api-download">download</a>.';
	}
	if( $available_update_int < $modulolv_int ) {
		$available_update_message = $available_update.' <i class="fas fa-exclamation-circle" style="color:#d6b200;"></i> Você está executando uma versão beta.';
	}

    return array(
        'FriendlyName' => array('Type' => 'System', 'Value' => 'PagSeguro - SouzaHost'),
		"ipok" 	   => array("FriendlyName" => "<span class='label label-primary'><i class='fa fa-exclamation-circle'></i>  Licença </span>", "Description" => $ip_message),
        'email'        => array('FriendlyName' => 'Email', 'Type' => 'text', 'Size' => '40'),
        'token'        => array('FriendlyName' => 'Token', 'Type' => 'text', 'Size' => '50'),
		'limite'       => array('FriendlyName' => 'Limite', 'Type' => 'text', 'Size' => '4', "Default" => "0", "Description" => "Não aceitar pagamento abaixo de, ex: 50.00 (deixe 0 para desabilitar)."),
		'tarifa'       => array('FriendlyName' => 'Tarifa', 'Type' => 'text', 'Size' => '4', "Default" => "0.40", "Description" => "Valor fixo adicional por fatura. Ex: 0.40"),
		'taxa'         => array('FriendlyName' => 'Taxa', 'Type' => 'text', 'Size' => '4', "Default" => "3.99", "Description" => "Taxa em % sobre o valor da fatura. Ex: 3.99"),
        'tipo'         => array('FriendlyName' => 'Tipo de Checkout', 'Type' => 'dropdown', 'Options' => 'Padrão,Lightbox'),
		"janela" 	   => array("FriendlyName" => "Tela de Pagamento", "Type" => "yesno", "Description" => "Abrir tela de pagamento automaticamente ao acessar a fatura."),
		"txt_btn" 	   => array("FriendlyName" => "Texto do Botão","Type" => "text","Size" => "30", "Default" => "Pagar Agora"),
		"estilo" 	   => array("FriendlyName" => "<span class='label label-primary'><i class='fa fa-exclamation-circle'></i>  Atenção </span>", "Description" => "<i class='fas fa-exclamation-circle' style='color:#d3678d;'></i>  Só altere os próximos dois campos do CSS, se tiver certeza!"),
		"css_btn" 	   => array("FriendlyName" => "Classe CSS do Bot&atilde;o de Pagamento","Type" => "text","Size" => "30","Default" => "btn btn-block btn-primary"),
		"css_custom"   => array("FriendlyName" => "CSS Personalizado","Type" => "textarea","Rows" => "3", "Default" => "padding: 10px 20px; width: 100%; max-width: 200px; float:right;"),
		'suporte'	   => array("FriendlyName" => "<span class='label label-primary'><i class='fa fa-question-circle'></i>  Informações </span>", "Description" =>  '<p>&copy; 2017 - '.date('Y').' / <a style="text-decoration:underline;" target="_blank" title="SouzaHost" href="https://www.souzahost.com.br" target="_blank">SouzaHost</a> - Sua Versão: ' . $modulolv . ' - Última Versão: '.$available_update_message.' - <a  style="text-decoration:underline;"target="_blank" title="Documentação" href="https://www.souzahost.com.br/modulo-pagseguro-api" target="_blank">Documentação</a> - <a style="text-decoration:underline;" target="_blank" title="Suporte" href="https://www.souzahost.com.br/modulo-pagseguro-api">Suporte</a></p>'),
		"UsageNotes"   => array("Type" => "System","Value" => "<p>Licença Anual: R$29,94 &raquo; Um ano de acesso à atualização - Suporte -  Renovação anual &mdash; <a style='color:#fff; text-decoration:none;' href='https://www.souzahost.com.br/modulo-pagseguro-api/#manged_section' target='_blank'><span class='label label-primary'> Comprar </span></a></p><p>Licença Life Time: R$59,76 &raquo; Um ano de acesso à atualização - Suporte - Pague uma vez e usa para sempre &mdash; <a style='color:#fff; text-decoration:none;' href='https://www.souzahost.com.br/modulo-pagseguro-api/#manged_section' target='_blank'><span class='label label-primary'> Comprar </span></a></p>")
    );
	
}

function souzapagseguro_link($params)
{
    
    // Verificar IP do servidor
	$host_ip = $_SERVER['SERVER_ADDR'];
	$host_ip_int = (int)preg_replace("/[^0-9]/", "", $host_ip);
		
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, "https://www.souzahost.com.br/modulos/?moduloip=" . $host_ip_int . "&moduloid=" . $moduloid );
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch,CURLOPT_USERAGENT,$_SERVER['HTTP_USER_AGENT']);

	$check_ip =  curl_exec($ch);
	$check_ip_int = (int)preg_replace("/[^0-9]/", "", $check_ip);
	
	// Fim
	
	$taxa_percentual = ( $params['amount'] / 100) * $params['taxa'];
    $taxa_total = $taxa_percentual + $params['tarifa'];
	$taxa_total = number_format($taxa_total, 2, '.', '');
    $valor_total = $params['amount'] + $taxa_total;
    $valor_total = number_format($valor_total, 2, '.', '');
	$valor_limite = number_format($params['limite'], 2, '.', '');
	
	
	
	$xml_checkout = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
						<checkout>
							<currency>BRL</currency>
							<items>
								<item>
									<id>1</id>
									<description>' . htmlspecialchars($params['description']) . '</description>
									<amount>' . $valor_total . '</amount>
									<extraAmount>' . $taxa_total . '</extraAmount>
									<quantity>1</quantity>
								</item>
							</items>
							<reference>' . $params['invoiceid'] . '</reference>
							<redirectURL>' . $params['systemurl'] . '/viewinvoice.php?id=' . $params['invoiceid'] . '</redirectURL>
							<notificationURL>' . $params['systemurl'] . '/modules/gateways/' . basename(__FILE__) . '</notificationURL>
						</checkout>';

    $curl = curl_init('https://ws.pagseguro.uol.com.br/v2/checkout/?email=' . $params['email'] . '&token=' . $params['token']);
	
    curl_setopt_array($curl, array(
        CURLOPT_POST           => 1,
        CURLOPT_POSTFIELDS     => $xml_checkout,
        CURLOPT_RETURNTRANSFER => 1,
        CURLOPT_HTTPHEADER     => array('Content-Type: application/xml; charset=UTF-8')));
    $retorno_curl    = curl_exec($curl);
    $checkout_parsed = simplexml_load_string($retorno_curl);
    
	/* Verificação do IP */
	if (!empty($valor_limite) And ($valor_total >= $valor_limite)) {
		//if (!empty($check_ip_int) && ($check_ip_int == $host_ip_int)) {
			if ($checkout_parsed->code) {
				if ($params["tipo"] == "Lightbox") {
					$result .= '<div style="text-align: right; width: 100%; max-width: 100%;">'. "\n";
					$result .= '<script type="text/javascript" src="https://stc.pagseguro.uol.com.br/pagseguro/api/v2/checkout/pagseguro.lightbox.js"></script>'."\n";
					$result .= '<script>'. "\n";
					$result .= 'function iniciaPagamento() {'. "\n";
					$result .= '  if (!PagSeguroLightbox("'.$checkout_parsed->code.'")) location.href="https://pagseguro.uol.com.br/v2/checkout/payment.html?code='.$checkout_parsed->code.'"'."\n";
					$result .= '}'. "\n";
					$result .= '</script>'. "\n";
					
					$result .= '<p style="padding-bottom: 5px;"><strong>Boleto & PIX</strong></p>'. "\n";
                    $result .= '<div style="display: inline-block; width: 52px;"><img style="margin: 2px !important;" src="https://www.souzahost.com.br/wp-content/uploads/2019/08/boleto.png" title="Boleto Bancário" alt="Boleto Bancário" border="0" width="51" height="32" /></div>'. "\n";
                    $result .= '<div style="display: inline-block; width: 52px;"><img style="margin: 2px !important;" src="https://www.souzahost.com.br/wp-content/uploads/2019/08/pix.png" title="PIX" alt="PIX" border="0" width="51" height="32" /></div>'. "\n";
                    
                    $result .= '<p style="margin-top: 10px;padding-bottom: 5px;"><strong>Cartão de Crédito e Débito</strong></p>'. "\n";
					$result .= '<div style="display: inline-block; width: 52px;"><img style="margin: 2px !important;" src="https://www.souzahost.com.br/wp-content/uploads/2019/08/mastercard.png" title="Mastercard" alt="Mastercard" border="0" width="51" height="32" /></div>'. "\n";
					$result .= '<div style="display: inline-block; width: 52px;"><img style="margin: 2px !important;" src="https://www.souzahost.com.br/wp-content/uploads/2019/08/visa.png" title="Visa" alt="Visa" border="0" width="51" height="32" /></div>'. "\n";
					$result .= '<div style="display: inline-block; width: 52px;"><img style="margin: 2px !important;" src="https://www.souzahost.com.br/wp-content/uploads/2019/08/hiper.png" title="Hipercard" alt="Hipercard" border="0" width="51" height="32" /></div>'. "\n";
					$result .= '<div style="display: inline-block; width: 52px;"><img style="margin: 2px !important; margin-right: 2px !important;" src="https://www.souzahost.com.br/wp-content/uploads/2019/08/elo.png" title="Elo" alt="Elo" border="0" width="51" height="32" /></div>'. "\n";
					$result .= '<hr style=\'border-top: 0.05rem solid #2ba5fb;\'> <input name="MP-payButton" id="MP-payButton" class="' . $params["css_btn"] . '" style="' . $params["css_custom"] . '" type="button" value="' . $params["txt_btn"] . '" onclick="iniciaPagamento();"><br><br>' . "\n";
					$result .= '</div>'. "\n";
					
					if ( $params['janela'] ) {
						$result .= "<script type=\"text/javascript\">document.getElementById(\"MP-payButton\").click();</script>";
					}
			
					$result .= "<p style=\"text-align: right; margin-top: 85px !important; margin-right: 2px !important;\">Tarifa de <strong>" . formatCurrency($taxa_total) . "</strong> do PagSeguro</p>";
					$result .= "<p style=\"text-align: right; margin-right: 2px !important;\">Valor Total &agrave; Pagar: <strong>" . formatCurrency($valor_total) . "</strong></p>";
					
				}
				else {
					$result = '<form action="https://pagseguro.uol.com.br/v2/checkout/payment.html" method="get">' . "\n";
					$result .= '    <input type="hidden" name="code" value="' . $checkout_parsed->code . '">' . "\n";
					$result .= '    <input type="submit" value="Pagar Agora">' . "\n";
					$result .= '</form>' . "\n";
				}
			} else {
				$result = '<font style="color:red"><i class="fa fa-exclamation-circle"></i>  Ocorreu um erro na comunicação com o PagSeguro.</font>';
				logTransaction($params['name'], $retorno_curl . print_r($params, true) . ($checkout_parsed ? " / " . $checkout_parsed : ""), 'Comunication Error');
			}
		//} else {
		//	$result = '<font style="color:red"><i class="fa fa-exclamation-circle"></i>  Ocorreu um erro na confirmação do servidor &mdash; <a style="color:#fff; text-decoration:none;" href="https://www.souzahost.com.br/modulo-pagseguro-api/#contact_form" target="_blank"><span class="label label-primary"> Entre em Contato </span></a></font>';
		//	logTransaction($params['name'], $retorno_curl . print_r($params, true) . ($checkout_parsed ? " / " . $checkout_parsed : ""), 'Server Confirmation Error');	
		//}
	} else {	
		$result = '<font style="color:red"><i class="fa fa-exclamation-circle"></i>  Valor mínimo (' . formatCurrency($valor_limite) . ') p/fatura não atingido para esta forma de pagamento.</font>';
		logTransaction($params['name'], $retorno_curl . print_r($params, true) . ($checkout_parsed ? " / " . $checkout_parsed : ""), 'Minimum Value');
	}
	
    return $result;
	
}

if (basename(__FILE__) == basename($_SERVER['SCRIPT_NAME'])) {
	
    if (!array_key_exists('notificationCode', $_POST) || !array_key_exists('notificationType', $_POST)) {
        header($_SERVER["SERVER_PROTOCOL"] . " 404 Not Found");
        die();
    }
	
    require '../../init.php';
    require '../../includes/invoicefunctions.php';
    require '../../includes/gatewayfunctions.php';

    $GATEWAY = getGatewayVariables('souzapagseguro');

    $curl = curl_init('https://ws.pagseguro.uol.com.br/v3/transactions/notifications/' . $_POST['notificationCode'] . '?email=' . $GATEWAY['email'] . '&token=' . $GATEWAY['token']);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    $xml = simplexml_load_string(curl_exec($curl));

    logTransaction($GATEWAY['name'], print_r($_POST, true) . print_r($xml, true), 'Successful Payment');
    $invoiceid = checkCbInvoiceID($xml->reference, $GATEWAY["name"]);
    checkCbTransID($xml->code); // redirecionar

	if ($xml->status == 3 || $xml->status == 4) {
        $valor_pagamento = (float)$xml->grossAmount - (float)$xml->extraAmount;
        $taxas = (float)$xml->grossAmount - (float)$xml->netAmount;
        addInvoicePayment($invoiceid, $xml->code, $valor_pagamento, $taxas, 'souzapagseguro');
    }
	
}
?>