<?php
    /**
     * PicPay - Módulo SouzaHost para integração com WHMCS
     * 
     * @package    PicPay para WHMCS
     * @version    1.0.0
     * @author     Mantido por Edilson Souza - https://edilson.site/
     * @license    BSD License (3-clause)
     * @copyright  (c) 2017-2021, SouzaHost
     * @link       https://www.souzahost.com.br/modulo-picpay-api
     **/
    
    if (!defined("WHMCS")) {die();}
    use WHMCS\Database\Capsule;

    function picpay_config()
    {
    	
        return array(
            'FriendlyName'      => array('Type' => 'System', 'Value' => 'PicPay'),
            'email'             => array('FriendlyName' => 'Email', 'Type' => 'text', 'Size' => '40'),
            'x_picpay_token'    => array('FriendlyName' => 'Token', 'Type' => 'text', 'Size' => '50'),
            'x_seller_token'    => array('FriendlyName' => 'Seller', 'Type' => 'text', 'Size' => '50'),
            'taxa'              => array('FriendlyName' => 'Taxa', 'Type' => 'text', 'Size' => '4', "Default" => "5.89", "Description" => "Taxa em % sobre o valor da fatura. Ex: 5.89"),
           	"txt_btn" 	        => array("FriendlyName" => "Texto do Botão","Type" => "text","Size" => "30", "Default" => "Pagar Agora"),
    		"css_btn" 	        => array("FriendlyName" => "Classe CSS do Bot&atilde;o de Pagamento","Type" => "text","Size" => "30","Default" => "btn btn-block btn-primary"),
    		"css_custom"        => array("FriendlyName" => "CSS Personalizado","Type" => "textarea","Rows" => "3", "Default" => "padding: 10px 20px; width: 100%; max-width: 200px; float:right;"),
    	);
    	
    }
    
    function picpay_link($params)
    {	
    	/*BEGIN TAXAS*/
        $taxa_percentual = ( $params['amount'] / 100) * $params['taxa'];
    	$taxa_total = number_format($taxa_percentual, 2, '.', '');
        $valor_total = $params['amount'] + $taxa_total;
        $valor_total = number_format($valor_total, 2, '.', '');
    	/*END TAXAS*/
    	
    	$userid = $params['clientdetails']['userid'];
    	$fieldid = '37'; // Campo do CPF/CNPJ
        
        foreach (Capsule::table("tblcustomfieldsvalues")->WHERE("fieldid", $fieldid)->WHERE("relid", $userid)->get() as $client){
            $documentcpfcnpj = $client->value;
    	}

    	$data = array(
            'referenceId' => $params['invoiceid'],
            'callbackUrl' => $params['systemurl'] . 'modules/gateways/' . basename(__FILE__),
            'returnUrl'   => $params['systemurl'] . 'viewinvoice.php?id=' . $params['invoiceid'],
            'value'       => $valor_total,
            'buyer'       => [
                'firstName' => $params['clientdetails']['firstname'],
                'lastName'  => $params['clientdetails']['lastname'],
                'document'  => $documentcpfcnpj,
                'email'     => $params['clientdetails']['email'],
                'phone'     => $params['clientdetails']['phonenumber'],
            ],
        );
        
        // Cancelar se pendente
        
        $curl = curl_init('https://appws.picpay.com/ecommerce/public/payments/'.$params['invoiceid'].'/cancellations');
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'x-picpay-token: '.$params['x_picpay_token']));
        $res = curl_exec($curl);
        curl_close($curl);
        
        // Cancelar se pendente
        
        
        $curl = curl_init('https://appws.picpay.com/ecommerce/public/payments');
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('x-picpay-token: '.$params['x_picpay_token']));
    
        $res = curl_exec($curl);
        curl_close($curl);
        $notification = json_decode($res);
        
        $qrCode = $notification->qrcode->base64;
        
        if (!isset($notification->{'message'})) {
            
            $result .= '<p style="text-align: right; padding-right: 5px;"><svg class="svg-icon" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="74px" height="24px" viewBox="0 0 74 24" style="enable-background:new 0 0 74 24;" xml:space="preserve">
                        <path fill="#21c25e" d="M15.3 19.379h3.476v-10.14h-3.476zM19.979 2.34h-2.343v2.343h2.343zM6.839 3.479h-3.36v2.941h3.12c1.98 0 3.12 0.96 3.12 2.76s-1.14 2.82-3.12 2.82h-3.12v-5.517h-3.476v12.897h3.476v-4.44h3.3c4.020 0 6.36-2.16 6.36-5.88 0-3.48-2.28-5.58-6.301-5.58zM22.32 0.003h-7.020v7.016h7.020zM21.18 5.822h-4.68v-4.683h4.68zM41.58 3.479h-3.18v2.941h3c1.98 0 3.12 0.96 3.12 2.76s-1.14 2.82-3.12 2.82h-3v-5.517h-3.476v12.897h3.476v-4.44h3.18c4.020 0 6.36-2.16 6.36-5.88 0-3.48-2.34-5.58-6.36-5.58zM70.8 7.2l-3 7.557-3-7.557h-3.6l4.8 12.179-1.86 4.62h3.66l6.6-16.799zM55.2 7.139c-2.1 0-3.72 0.48-5.521 1.38l1.081 2.4c1.26-0.72 2.52-1.080 3.659-1.080 1.68 0 2.52 0.72 2.52 2.040v0.24h-3.362c-3 0-4.62 1.38-4.62 3.66 0 2.22 1.56 3.779 4.2 3.779 1.68 0 2.88-0.599 3.84-1.62v1.32h3.42v-7.919c-0.114-2.58-1.978-4.2-5.218-4.2zM57.24 15.301c-0.36 1.019-1.38 1.86-2.82 1.86-1.199 0-1.92-0.6-1.92-1.56s0.66-1.38 1.98-1.38h2.76zM27.659 16.74c-1.68 0-2.879-1.32-2.879-3.3 0-1.92 1.199-3.24 2.879-3.24 1.2 0 2.1 0.48 2.761 1.32l2.343-1.68c-1.080-1.62-2.94-2.58-5.28-2.58-3.66-0.060-6.18 2.46-6.18 6.18s2.52 6.18 6.18 6.18c2.52 0 4.383-1.020 5.401-2.7l-2.4-1.62c-0.603 0.96-1.563 1.44-2.823 1.44z"></path>
                        </svg></p>'. "\n";
                
            $result .= '<div style="text-align: right; width: 380px; max-width: 100%;">'. "\n";
    		
    		$result .= '<img width="250" src="'.$qrCode.'" class="img-responsive img-thumbnail" />' . "\n";
    		$result .= '</div>'. "\n";
    		
    		$result .= "<p style=\"text-align: right; margin-top: 20px !important; margin-right: 2px !important;\">Tarifa de " . formatCurrency($taxa_total) . " do PicPay</p>";
			$result .= "<p style=\"text-align: right; margin-right: 2px !important;\">Valor total &agrave; pagar: " . formatCurrency($valor_total) . "</p>";

    	} else {
    	    
    		$result = '<font style="color:red"><i class="fa fa-exclamation-circle"></i>  Ocorreu um erro na comunicação com o PicPay.</font>';
    		logTransaction($params['name'], $retorno_curl . print_r($params, true) . ($checkout_parsed ? " / " . $checkout_parsed : ""), $notification->{'message'});
    		
    	}
    
        return $result;
    	
    }
    
    function notificationPayment(){
    	$content = trim(file_get_contents("php://input"));
        $payBody = json_decode($content);
        if(isset($payBody->authorizationId)):
            $referenceId = $payBody->referenceId;
            $ch = curl_init('https://appws.picpay.com/ecommerce/public/payments/'.$referenceId.'/status');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('x-picpay-token: '.$this->x_picpay_token));
            $res = curl_exec($ch);
            curl_close($ch);
            $notification = json_decode($res);
            $notification->referenceId     = $payBody->referenceId;
            $notification->authorizationId = $payBody->authorizationId;
            return $notification;
        else:
            return false;
        endif;
    }
    
    if (basename(__FILE__) == basename($_SERVER['SCRIPT_NAME'])) {
    	
        if (!array_key_exists('notification', $_POST)) {
            header($_SERVER["SERVER_PROTOCOL"] . " 404 Not Found");
            die();
        }
    	
        require '../../init.php';
        require '../../includes/invoicefunctions.php';
        require '../../includes/gatewayfunctions.php';
    
        $GATEWAY = getGatewayVariables('picpay');
        
        
        // função que verifica a requisição do PicPay
        $notification = $picpay->notificationPayment();
        
            if($notification){
        
        	  $status	        = $notification->status;
        	  $authorizationId  = $notification->authorizationId;
        	  $referenceId      = $notification->referenceId;
        
        
          switch ($status):
        
            case 'created'    : $s = "Pendente"; break;
            case 'expired'    : $s = "Expirado"; break;
            case 'analysis'   : $s = "Pendente"; break;
            case 'paid'       : $s = "Pago"; break;
            case 'completed'  : $s = "Pago"; break;
            case 'refunded'   : $s = "Devolvido"; break;
            case 'chargeback' : $s = "Pago"; break;
            default           : $s = "Pendente"; break;
        
          endswitch;
        
          //$update = $fatura->update($referenceId,$s);
          
          logTransaction($GATEWAY['name'], print_r($_POST, true) . print_r($status, true), $s);
          $invoiceid = checkCbInvoiceID($referenceId, $GATEWAY["name"]);
            checkCbTransID($authorizationId); // redirecionar
          
            if ($status == 'paid' || $status == 'completed' || $status == 'chargeback') {
                
                $valor_pagamento = (float)$xml->grossAmount - (float)$xml->extraAmount;
                
                $taxas = (float)$xml->grossAmount - (float)$xml->netAmount;
                
                addInvoicePayment($invoiceid, $authorizationId, $valor_pagamento, $taxas, 'picpay');
                
            }
            
        
        }
        
        
    
        $curl = curl_init('https://appws.picpay.com/ecommerce/public/payments/'. $_POST['notificationCode'] .'/status');	   
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $xml = simplexml_load_string(curl_exec($curl));
        
        
    
        logTransaction($GATEWAY['name'], print_r($_POST, true) . print_r($xml, true), 'Successful Payment');
        $invoiceid = checkCbInvoiceID($xml->reference, $GATEWAY["name"]);
        checkCbTransID($xml->code); // redirecionar
    
    	
    	
    	if ($xml->status == 3 || $xml->status == 4) {
            $valor_pagamento = (float)$xml->grossAmount - (float)$xml->extraAmount;
            $taxas = (float)$xml->grossAmount - (float)$xml->netAmount;
            addInvoicePayment($invoiceid, $xml->code, $valor_pagamento, $taxas, 'picpay');
        }
        
        
        
    	
    }
?>