<?php
/**
 * Módulo Juno PIX para WHMCS
 * @copyright	2020 Gofas Software
 * @see			https://gofas.net/?p=14128
 * @license		https://gofas.net/?p=9340
 * @support		https://gofas.net/?p=14299
 * @version		1.0.0
 */
require_once __DIR__ . '/../../../../init.php';
require_once __DIR__ . '/../../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../../includes/invoicefunctions.php';
$params = getGatewayVariables('gofasjunopix');
if(!$params['type']){die();}
use WHMCS\Database\Capsule;
$post_ = file_get_contents('php://input');
$post = json_decode($post_,true);

if($post and ($post['data']['0']['attributes']['charge']['reference'] or $post['data']['0']['attributes']['reference']) and
    ((string)$post['eventType'] === (string)'PAYMENT_NOTIFICATION' or (string)$post['eventType'] === (string)'CHARGE_STATUS_CHANGED')
    ){

    if($post['data']['0']['attributes']['charge']['reference']){
        $invoice_id = $post['data']['0']['attributes']['charge']['reference'];
    }
    if($post['data']['0']['attributes']['reference']){
        $invoice_id = $post['data']['0']['attributes']['reference'];
    }
    if($post['data']['0']['attributes']['charge']['id']){
        $charge_id = $post['data']['0']['attributes']['charge']['id'];
    }
    if($post['data']['0']['entityId']){
        $charge_id = $post['data']['0']['entityId'];
    }

    require_once __DIR__.'/functions.php';
    if ($params['sandbox']){
        $api_mode = 'sandbox';
        $client_id = $params['sandbox_client_id'];
        $client_secret = $params['sandbox_client_secret'];
        $private_token = $params['sandbox_private_token'];
        if($params['sandbox_key']){
            $pix_key = $params['sandbox_key'];
        }
        $api_url ='https://sandbox.boletobancario.com/api-integration/';
        $auth_url ='https://sandbox.boletobancario.com/authorization-server/oauth/token';
        $toKenrPartner = 'D6534FBF56FDAE78FABEA6D423DF7966331F142A711DAD4E183087A60F586BD128D4433E56E52671';
        $trans_api_mode = '-'.$api_mode;
    }
    elseif (!$params['sandbox']){
        $api_mode = 'live';
        $client_id = $params['client_id'];
        $client_secret = $params['client_secret'];
        $private_token = $params['private_token'];
        if($params['key']){
            $pix_key = $params['key'];
        }
        $api_url ='https://api.juno.com.br/';
        $auth_url = 'https://api.juno.com.br/authorization-server/oauth/token';
        $toKenrPartner = 'DE1836BFE5AD353FE74E38F767A3F280ED4A6A443C22895B31D90FA148C9A73EC1E6346B29319A98';
        $trans_api_mode = '';
    }
    // Verifica/confirma transação
    $access_token_ = gjp_get_token($auth_url,$client_id,$client_secret);
    if($access_token_['response']['access_token']){
        $access_token = $access_token_['response']['access_token'];
    }
    else{
        $error .= $access_token_['response_code'].': '.json_encode($access_token_['response']);
    }
	$url_check_charge = $api_url.'charges/'.$charge_id;
    $check_charge_request = 'GET';
	$header = [
		'content-type: application/json;charset=UTF-8',
		'accept-charset: utf-8',
		'x-platform: gofaspixparawhmcs',
		'X-Api-Version: 2',
		'X-Resource-Token: '.$private_token,
		'Authorization: Bearer '.$access_token,
	];				
    $charge = gjp_charge($url_check_charge,$access_token,$private_token,$header,$check_charge_request);
    $invoice = localAPI('getinvoice',array('invoiceid'=>$invoice_id),(int)$params['admin']);
	
    if((string)$invoice['paymentmethod'] === (string)'gofasjunopix' and
        (string)$invoice['status'] === (string)'Unpaid' and
        (string)$charge['status'] === (string)'PAID' and
        (float)$invoice['total'] === (float)$charge['amount']
        ){
        $AddTransaction = localAPI(
			'AddTransaction', 
			[
				'invoiceid' => $invoice_id,
				'transid' => 'gjp-'.$charge['code'].$trans_api_mode,
				'paymentmethod' => 'gofasjunopix',
				'date' => date("d/m/Y"),
				'description' => 'Pagamento recebido via PIX',
				'amountin'=> $charge['amount'],
				'fees' => $charge['payments']['0']['fee'],
            ],
			(int)$params['admin']);
        //
        Capsule::table('gofasjunopix')->where('charge_id','=',$charge['id'])->delete();
    }
}
if($params['log'] and !$_REQUEST['invoice_id']){
    $log['post'] = $post;
    $log['params'] = $params;
    $log['access_token_'] = $access_token_;
    $log['invoice'] = $invoice;
    $log['charge'] = $charge;
    if($error){
        $log['error'] = $error;
    }
    //echo '<pre>', print_r($log),'</pre>';
    foreach( Capsule::table('tblconfiguration') -> where('setting','=','gjp_version') -> get(['value']) as $gjp_version_ ){
        $gjp_version			= $gjp_version_->value;
    }
	logModuleCall('gofasjunopix','receive_callback',array('module_version'=>$gjp_version),'',array( $log ));
}
//
if(!function_exists('gjp_is_ajax')){
	function gjp_is_ajax(){
		return isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
	}
}
if(gjp_is_ajax() and $_REQUEST['invoice_id']){
    $invoice = localAPI('getinvoice',array('invoiceid'=>$_REQUEST['invoice_id']),(int)$params['admin']);
    echo $invoice['status'];
}