<?php

date_default_timezone_set('America/Sao_Paulo');

include_once(dirname(__FILE__) . "/../../../init.php");
include_once(dirname(__FILE__) . "/wappi_classes/App/wappi.php");
include_once(dirname(__FILE__) . "/lang/portuguese-br.php");

//////////////////////////////////////////////////////////////////////////////////////////
// Gerencia sessoes //////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

use WHMCS\Session;

//////////////////////////////////////////////////////////////////////////////////////////
// API Carbon ////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

use Carbon\Carbon;

//////////////////////////////////////////////////////////////////////////////////////////
// API Laravel DataBase //////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

use WHMCS\Database\Capsule;

//////////////////////////////////////////////////////////////////////////////////////////

use wappi\App\Api\Cliente\Whatsapp;

//////////////////////////////////////////////////////////////////////////////////////////

try {
    
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Msg_ForaHorario']])->get() as $wappi) {
        $WHATSAPP_API_MSG_FORAHORARIO    =   $wappi->value;
    }
    
} catch (\Throwable $th) { 

}

header("access-control-allow-origin: *");

$Wappi_Webhook	=	json_decode(file_get_contents('php://input'), True);

//file_put_contents("debug.txt",json_encode($Wappi_Webhook) . "\n", FILE_APPEND);

//////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

$wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

if(($Wappi_Webhook["event"] == "on-message")) {

    $ExisteChat =   Capsule::table('api_whatsapp_chat')->WHERE([ ['send_id',$Wappi_Webhook["from"]] , ['status','<','3'] ])->get();

    if(($ExisteChat[0] != NULL)) {

        $Numero_Cliente    =   $ExisteChat[0]->send_id;
        $Departamento       =   $ExisteChat[0]->departamento;
        $Ticket             =   $ExisteChat[0]->ticket;
        $Funcionario        =   $ExisteChat[0]->funcionario;

        if(($Wappi_Webhook["type"] == "buttons-response")) {

            // Trata as strings para o template da mensagem
            $alteracao_stings_msg_whatsapp = array(
                "{nome_departamento}"
            );

            $alteracao_stings_msg_whatsapp_novos = array(
                $Departamento 
            );

            $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp, $alteracao_stings_msg_whatsapp_novos, MSG_TICKET_ABERTO);

            $wappi_classes->EnviarMensagemTexto($Wappi_Webhook["from"],$Wappi_Whatsapp_Mensagem);
            exit();

        }

        if(($Ticket != NULL)) {


            Capsule::table('api_whatsapp_mensagens_chat')->insert([

                "tipo_msg"  =>  $Wappi_Webhook["type"],
                "ticket"    =>  $Ticket,
                "id_mensagem"   =>  $Wappi_Webhook["id"],
                "send_id"   =>  $Numero_Cliente,
                "mensagem"  =>  ($Wappi_Webhook["content"] != NULL ? $Wappi_Webhook["content"] : ($Wappi_Webhook["text"] != NULL ? $Wappi_Webhook["text"] : $Wappi_Webhook["type"]) ),
                "recev_id"  =>  $Wappi_Webhook["device"],
                "data"  =>  date("Y-m-d h:i:s"),
                "status"    => "0"

            ]);

            if(($Wappi_Webhook["type"] == "reply")) {

                Capsule::table('api_whatsapp_mensagens_chat')->WHERE("id_mensagem",$Wappi_Webhook["id"])->update([

                    "id_mensagem_resposta"  =>  $Wappi_Webhook["reply"]["id"]
    
                ]);

            }
                
            if(($Wappi_Webhook["type"] == "image") || ($Wappi_Webhook["type"] == "video") || ($Wappi_Webhook["type"] == "voice") || ($Wappi_Webhook["type"] == "document" || ($Wappi_Webhook["subtype"] == "voice") || ($Wappi_Webhook["subtype"] == "image") || ($Wappi_Webhook["subtype"] == "document") || ($Wappi_Webhook["subtype"] == "video") )) {

                $ConverterRemoto    =   $wappi_classes->DescriptMidiaRemota($Numero_Cliente,$Wappi_Webhook["id"]);

                if(($ConverterRemoto["status"] == "200")) {

                    Capsule::table('api_whatsapp_mensagens_chat')->WHERE("id_mensagem",$Wappi_Webhook["id"])->update([

                        "arquivo_name"  =>  $ConverterRemoto["url"]
        
                    ]);

                } else {

                    $ConverterMidia =   $wappi_classes->SalvarMidia($Numero_Cliente,$Wappi_Webhook["id"]);

                    Capsule::table('api_whatsapp_mensagens_chat')->WHERE("id_mensagem",$Wappi_Webhook["id"])->update([

                        "arquivo_name"  =>  $ConverterMidia["response"]
        
                    ]);

                }

                //file_put_contents("debug.txt","ERROR JSON: " . json_encode($ConverterMidia) . "\n", FILE_APPEND);

            }
            

        }

    } else {

        $ID_Ticket_Criar  =   uniqid();

        if(($Wappi_Webhook["type"] != "buttons-response")) {

            foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Menu de Atendimento')->get() as $wappi) {
                $corpo_mensagem = $wappi->corpo;
                $status_mensagem = $wappi->status;
            }

            foreach (WHMCS\Database\Capsule::table('api_whatsapp_filaatendimento')->WHERE('status','1')->get() as $wappi) {
                $Menu_Atendimento .= $wappi->Fila . ',';
            }

            $wappi_classes->EnviarBotao($Wappi_Webhook["from"],$corpo_mensagem,substr($Menu_Atendimento,0,-1));

        } else {

            // Tratamento de Horario de funcionamento

            foreach (WHMCS\Database\Capsule::table('api_whatsapp_robo_horario')->WHERE([ ['Robo_ID',$Wappi_Webhook["title"]], ['Dia_Semana',date("N")] ])->get() as $dataAtendimento) {
                $Hora_inicio    =   $dataAtendimento->Hora_Inicio;
                $Hora_Fim       =   $dataAtendimento->Hora_Fim;
            }

            if(($Hora_inicio != NULL)) {

                if((date("H:i") < $Hora_inicio) || (date("H:i") > $Hora_Fim)) {

                    $wappi_classes->EnviarMensagemTexto($Wappi_Webhook["from"],$WHATSAPP_API_MSG_FORAHORARIO);
                    exit();
    
                }

            }

            $Foto_Cliente   =   $wappi_classes->FotoPerfilChat($Wappi_Webhook["from"]);

            Capsule::table('api_whatsapp_chat')->insert([

                "ticket"    =>  $ID_Ticket_Criar,
                "send_id"   =>  $Wappi_Webhook["from"],
                "departamento"  =>  $Wappi_Webhook["title"],
                "recev_id"  =>  $Wappi_Webhook["device"],
                "foto_cliente_sessao"   =>  ($Foto_Cliente["picture"] != NULL ? $Foto_Cliente["picture"] : '../modules/addons/whatsapp/templates/imagens/nophoto.png' ),
                "status"    => "0"

            ]);

            $wappi_classes->PinChat($Wappi_Webhook["from"]);

            $wappi_classes->EnviarMensagemTexto($Wappi_Webhook["from"],MSG_AGUARDE_ATENDENTE);

            //file_put_contents("debug.txt",json_encode($Wappi_Webhook));

        }

    }

}