<?php

include_once(dirname(__FILE__) . "/wappi_classes/App/wappi.php");
include_once(dirname(__FILE__) . "/lang/portuguese-br.php");

//////////////////////////////////////////////////////////////////////////////////////////
// Gerencia sessoes //////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

use WHMCS\Session;

//////////////////////////////////////////////////////////////////////////////////////////
// API Carbon ////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

use Carbon\Carbon;

//////////////////////////////////////////////////////////////////////////////////////////
// API Laravel DataBase //////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

use WHMCS\Database\Capsule;

//////////////////////////////////////////////////////////////////////////////////////////

use wappi\App\Api\Cliente\Whatsapp;

//////////////////////////////////////////////////////////////////////////////////////////
// Modulo desenvolvido pela wappi /////////////////////////////////////////////////
// A venda e copia deste modulo sem nossa autorização e totalmente proibida! /////////////
// Versão: 1.0.0 BETA ////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

if (!defined('WHMCS')) {
    exit('Acesso restrito - Power by www.wappi.com.br');
}

//////////////////////////////////////////////////////////////////////////////////////////
// Add novo Cliente //////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('ClientAdd', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Nome Empresa /////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblconfiguration')->where('setting','CompanyName')->get() as $dados) {
        $NOME_EMPRESA 	=	$dados->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // ID Cliente ///////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $iddocliente    =   $vars['client_id'];

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Dados do Cliente /////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {

        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;

    }


    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Cadastro Novo Cliente')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{Assinatura}",
            "{Dominio_WHMCS}",
            "{Nome_Empresa}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA,
            $NOME_EMPRESA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp

                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }

});




//////////////////////////////////////////////////////////////////////////////////////////
// Alteração de senha Cliente ////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('UserChangePassword', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // ID Cliente ///////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////


    // Dados do Cliente pal tabela usuario
    foreach (Capsule::table('tblusers_clients')->where('auth_user_id',$vars['userid'])->get() as $dados) {
        $iddocliente 	=	$dados->client_id;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Dados do Cliente /////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {

        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;

    }


    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Alteração de Senha')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{NovaSenha}",
            "{Assinatura}",
            "{Dominio_WHMCS}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $vars["password"],
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }

});

//////////////////////////////////////////////////////////////////////////////////////////
// Invoice Created ///////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('InvoiceCreated', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Funções padrões do WHMCS /////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Pega o ID do usuario
    $numerodafatura = $vars['invoiceid'];

    // ID do Cliente pela fatura
    foreach (Capsule::table('tblinvoices')->where('id',$numerodafatura)->get() as $client) {
        $iddocliente = $client->userid;
        $datadopagamento = $client->datepaid;
        $datadecriacaofatura = explode('-',$client->date);
        $datadevencimentofatura = explode('-',$client->duedate);
        $valordafaturacomponto = number_format($client->total, 2, '.', '');
        $valordafaturacomvirgula = number_format($client->total, 2, ',', '');
    }

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
        $TipoMoeda	=	$informacoesdocliente->currency;
    }

    foreach (Capsule::table('tblinvoiceitems')->where('invoiceid',$numerodafatura)->get() as $iteminvoice) {
        $Item_Invoice .= $iteminvoice->description . " - " . $iteminvoice->amount . "
";
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }


    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Fatura Criada')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{NumeroFatura}", 
            "{ValordaFatura}", 
            "{DataCriacaoFatura}",
            "{DataVencimentoFatura}",
            "{Itens_Invoice}",
            "{Assinatura}",
            "{Dominio_WHMCS}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $numerodafatura,
            $Wappi_TipoMoeda . $valordafaturacomponto,
            $datadecriacaofatura[2] . '/' . $datadecriacaofatura[1] . '/' . $datadecriacaofatura[0],
            $datadevencimentofatura[2] . '/' . $datadevencimentofatura[1] . '/' . $datadevencimentofatura[0],
            $Item_Invoice,
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }

});


//////////////////////////////////////////////////////////////////////////////////////////
// InvoicePaymentReminder ////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('InvoicePaymentReminder', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Funções padrões do WHMCS /////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Pega o ID do usuario
    $numerodafatura = $vars['invoiceid'];

    // ID do Cliente pela fatura
    foreach (Capsule::table('tblinvoices')->where('id',$numerodafatura)->get() as $client) {
        $iddocliente = $client->userid;
        $datadopagamento = $client->datepaid;
        $datadecriacaofatura = explode('-',$client->date);
        $datadevencimentofatura = explode('-',$client->duedate);
        $valordafaturacomponto = number_format($client->total, 2, '.', '');
        $valordafaturacomvirgula = number_format($client->total, 2, ',', '');
    }

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
        $TipoMoeda	=	$informacoesdocliente->currency;
    }

    foreach (Capsule::table('tblinvoiceitems')->where('invoiceid',$numerodafatura)->get() as $iteminvoice) {
        $Item_Invoice .= $iteminvoice->description . " - " . $iteminvoice->amount . "
";
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }


    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Lembrete de Vencimento')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{NumeroFatura}", 
            "{ValordaFatura}", 
            "{DataCriacaoFatura}",
            "{DataVencimentoFatura}",
            "{Itens_Invoice}",
            "{Assinatura}",
            "{Dominio_WHMCS}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $numerodafatura,
            $Wappi_TipoMoeda . $valordafaturacomponto,
            $datadecriacaofatura[2] . '/' . $datadecriacaofatura[1] . '/' . $datadecriacaofatura[0],
            $datadevencimentofatura[2] . '/' . $datadevencimentofatura[1] . '/' . $datadevencimentofatura[0],
            $Item_Invoice,
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }

});

//////////////////////////////////////////////////////////////////////////////////////////
// InvoicePaid ///////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('InvoicePaid', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Nome Empresa /////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblconfiguration')->where('setting','CompanyName')->get() as $dados) {
        $NOME_EMPRESA 	=	$dados->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Funções padrões do WHMCS /////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Pega o ID do usuario
    $numerodafatura = $vars['invoiceid'];

    // ID do Cliente pela fatura
    foreach (Capsule::table('tblinvoices')->where('id',$numerodafatura)->get() as $client) {
        $iddocliente = $client->userid;
        $datadopagamento = $client->datepaid;
        $datadecriacaofatura = explode('-',$client->date);
        $datadevencimentofatura = explode('-',$client->duedate);
        $valordafaturacomponto = number_format($client->total, 2, '.', '');
        $valordafaturacomvirgula = number_format($client->total, 2, ',', '');
    }

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
        $TipoMoeda	=	$informacoesdocliente->currency;
    }

    foreach (Capsule::table('tblinvoiceitems')->where('invoiceid',$numerodafatura)->get() as $iteminvoice) {
        $Item_Invoice .= $iteminvoice->description . " - " . $iteminvoice->amount . "
";
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }


    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Confirmação de Pagamento')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{NumeroFatura}", 
            "{ValordaFatura}", 
            "{DataCriacaoFatura}",
            "{DataVencimentoFatura}",
            "{Itens_Invoice}",
            "{Assinatura}",
            "{Dominio_WHMCS}",
            "{Nome_Empresa}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $numerodafatura,
            $Wappi_TipoMoeda . $valordafaturacomponto,
            $datadecriacaofatura[2] . '/' . $datadecriacaofatura[1] . '/' . $datadecriacaofatura[0],
            $datadevencimentofatura[2] . '/' . $datadevencimentofatura[1] . '/' . $datadevencimentofatura[0],
            $Item_Invoice,
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA,
            $NOME_EMPRESA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }


});

//////////////////////////////////////////////////////////////////////////////////////////
// Invoice Cancelled /////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('InvoiceCancelled', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Nome Empresa /////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblconfiguration')->where('setting','CompanyName')->get() as $dados) {
        $NOME_EMPRESA 	=	$dados->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Funções padrões do WHMCS /////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Pega o ID do usuario
    $numerodafatura = $vars['invoiceid'];

    // ID do Cliente pela fatura
    foreach (Capsule::table('tblinvoices')->where('id',$numerodafatura)->get() as $client) {
        $iddocliente = $client->userid;
        $datadopagamento = $client->datepaid;
        $datadecriacaofatura = explode('-',$client->date);
        $datadevencimentofatura = explode('-',$client->duedate);
        $valordafaturacomponto = number_format($client->total, 2, '.', '');
        $valordafaturacomvirgula = number_format($client->total, 2, ',', '');
    }

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
        $TipoMoeda	=	$informacoesdocliente->currency;
    }

    foreach (Capsule::table('tblinvoiceitems')->where('invoiceid',$numerodafatura)->get() as $iteminvoice) {
        $Item_Invoice .= $iteminvoice->description . " - " . $iteminvoice->amount . "
";
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }


    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Cancelamento de Fatura')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{NumeroFatura}", 
            "{ValordaFatura}", 
            "{DataCriacaoFatura}",
            "{DataVencimentoFatura}",
            "{Itens_Invoice}",
            "{Assinatura}",
            "{Dominio_WHMCS}",
            "{Nome_Empresa}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $numerodafatura,
            $Wappi_TipoMoeda . $valordafaturacomponto,
            $datadecriacaofatura[2] . '/' . $datadecriacaofatura[1] . '/' . $datadecriacaofatura[0],
            $datadevencimentofatura[2] . '/' . $datadevencimentofatura[1] . '/' . $datadevencimentofatura[0],
            $Item_Invoice,
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA,
            $NOME_EMPRESA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }

});

//////////////////////////////////////////////////////////////////////////////////////////
// EmailPreSend //////////////////////////////////////////////////////////////////////////
// Suspensão e Reativação de Serviços ////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('EmailPreSend', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Nome Empresa /////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblconfiguration')->where('setting','CompanyName')->get() as $dados) {
        $NOME_EMPRESA 	=	$dados->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Funções padrões do WHMCS /////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Pega o ID do usuario
	$idproduto = $vars['relid'];

    // ID do Cliente pelo serviço
    foreach (Capsule::table('tblhosting')->where('id',$idproduto)->get() as $client) {
        $iddocliente = $client->userid;
        $packageid = $client->packageid;
        $nomeDominio = $client->domain;
        $ns1 = $client->ns1;
        $ns2 = $client->ns2;
        $username = $client->username;
        $senha = $client->password;
    }

    // Descript Sennha
    $Post_DescriptSennha = ['password2' => $senha];
    $SenhaDescript = localAPI('DecryptPassword', $Post_DescriptSennha);
    if(($SenhaDescript["result"] == "success")) {
        $SenhaProduto   =   $SenhaDescript["password"];
    }

    // Gerencia o Produto
    foreach (Capsule::table('tblproducts')->where('id',$packageid)->get() as $client2) {
        $nomeProduto = $client2->name;
    }

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }


    if($vars['messagename'] == 'Service Suspension Notification') {

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Suspensão de Serviço')->get() as $wappi) {
            $corpo_mensagem = $wappi->corpo;
            $status_mensagem = $wappi->status;
        }

        if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

            // Trata as strings para o template da mensagem
            $alteracao_stings_msg_whatsapp = [
                "{NomeCliente}",
                "{SobrenomeCliente}",
                "{Dominio}",
			    "{NomeProduto}",
                "{Assinatura}",
                "{Dominio_WHMCS}"
            ];

            $alteracao_stings_msg_whatsapp_novos = [
                $primeironome,
                $sobrenome,
                $nomeDominio,
			    $nomeProduto,
                $WHATSAPP_API_ASSINATURA,
                $WHMCS_URLSISTEMA
            ];

            $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

            if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

                $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
        
                if(($CodigoBancoDados[0]->status == "1")) {
        
                    // Integração API Whatsapp
        
                    $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
        
                }
        
            } else {
        
                // Integração API Whatsapp
        
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
        
            }

        }

    }

    if($vars['messagename'] == 'Service Unsuspension Notification') {

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Reativação do Serviço')->get() as $wappi) {
            $corpo_mensagem = $wappi->corpo;
            $status_mensagem = $wappi->status;
        }

        if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

            // Trata as strings para o template da mensagem
            $alteracao_stings_msg_whatsapp = [
                "{NomeCliente}",
                "{SobrenomeCliente}",
                "{Dominio}",
			    "{NomeProduto}",
                "{Assinatura}",
                "{Dominio_WHMCS}"
            ];

            $alteracao_stings_msg_whatsapp_novos = [
                $primeironome,
                $sobrenome,
                $nomeDominio,
			    $nomeProduto,
                $WHATSAPP_API_ASSINATURA,
                $WHMCS_URLSISTEMA
            ];

            $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

            if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

                $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
        
                if(($CodigoBancoDados[0]->status == "1")) {
        
                    // Integração API Whatsapp
        
                    $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
        
                }
        
            } else {
        
                // Integração API Whatsapp
        
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
        
            }

        }

    }

    $merge_fields = [];
    return $merge_fields;

});


//////////////////////////////////////////////////////////////////////////////////////////
// TicketOpen ////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('TicketOpen', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Funções padrões do WHMCS /////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Pega o ID do usuario
    $iddoticket = $vars['ticketid'];
    $departamentodoticket = $vars['deptname'];
    $prioridadedoticket = $vars['priority'];

    // ID do Cliente pelo chamado
    foreach (Capsule::table('tbltickets')->where('id',$iddoticket)->get() as $client) {
        $iddocliente = $client->userid;
        $iddochamadotelacliente = $client->tid;
        $keydochamado = $client->c;
        $titulodochamado = $client->title;
    }

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
        $TipoMoeda	=	$informacoesdocliente->currency;
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }

    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Abertura de Ticket')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    $query = "SELECT tk.date, rp.date, tk.id FROM tbltickets as tk, tblticketreplies as rp WHERE tk.id=rp.tid AND tk.admin='' GROUP BY tk.id ORDER BY tk.date DESC LIMIT 0,10";
    $result = full_query($query);	
    while ($data = @mysql_fetch_array ($result)) {
        $tempo = abs(strtotime($data['0']) - strtotime($data['1']));
        $minutos  = floor(($tempo)/ 60);
        $tempos[] = $minutos;
    }
    $media = round(array_sum($tempos)/10);
    $horas = (int)($media / 60);
    $h = $horas." horas ";
    $minutos = $media - ($horas * 60);
    $m = $minutos." minutos";

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{TempoResposta}",
            "{TituloChamado}",
            "{IdChamado}",
            "{DepartamentoChamado}",
            "{KeyChamado}",
            "{PrioridadeChamado}",
            "{Assinatura}",
            "{Dominio_WHMCS}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $h . $m,
            $titulodochamado,
            $iddochamadotelacliente,
            $departamentodoticket,
            $keydochamado,
            $prioridadedoticket,
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }

});

//////////////////////////////////////////////////////////////////////////////////////////
// TicketAdminReply //////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('TicketAdminReply', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Funções padrões do WHMCS /////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Pega o ID do usuario
    $iddoticket = $vars['ticketid'];
    $titulodoticket = $vars['subject'];
    $responsaveldoticket = $vars['admin'];
    $textorespostadoticket = $vars['message'];

    // ID do Cliente pelo chamado
    foreach (Capsule::table('tbltickets')->where('id',$iddoticket)->get() as $client) {
        $iddocliente = $client->userid;
        $iddochamadotelacliente = $client->tid;
        $keydochamado = $client->c;
        $titulodochamado = $client->title;
    }

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
        $TipoMoeda	=	$informacoesdocliente->currency;
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }

    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Resposta do Ticket')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    $query = "SELECT tk.date, rp.date, tk.id FROM tbltickets as tk, tblticketreplies as rp WHERE tk.id=rp.tid AND tk.admin='' GROUP BY tk.id ORDER BY tk.date DESC LIMIT 0,10";
    $result = full_query($query);	
    while ($data = @mysql_fetch_array ($result)) {
        $tempo = abs(strtotime($data['0']) - strtotime($data['1']));
        $minutos  = floor(($tempo)/ 60);
        $tempos[] = $minutos;
    }
    $media = round(array_sum($tempos)/10);
    $horas = (int)($media / 60);
    $h = $horas." horas ";
    $minutos = $media - ($horas * 60);
    $m = $minutos." minutos";

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{TituloChamado}",
            "{IdChamado}",
            "{KeyChamado}",
            "{ResponsavelChamado}",
            "{ConteudoResposta}",
            "{Assinatura}",
            "{Dominio_WHMCS}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $titulodoticket,
            $iddochamadotelacliente,
            $keydochamado,
            $responsaveldoticket,
            $textorespostadoticket,
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }

});

//////////////////////////////////////////////////////////////////////////////////////////
// TicketClose ///////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('TicketClose', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Pega o ID do usuario
    $iddoticket = $vars['ticketid'];

    // ID do Cliente pelo chamado
    foreach (Capsule::table('tbltickets')->where('id',$iddoticket)->get() as $client) {
        $iddocliente = $client->userid;
        $iddochamadotelacliente = $client->tid;
        $keydochamado = $client->c;
        $titulodochamado = $client->title;
    }

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
        $TipoMoeda	=	$informacoesdocliente->currency;
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Fechar Ticket')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    $query = "SELECT tk.date, rp.date, tk.id FROM tbltickets as tk, tblticketreplies as rp WHERE tk.id=rp.tid AND tk.admin='' GROUP BY tk.id ORDER BY tk.date DESC LIMIT 0,10";
    $result = full_query($query);	
    while ($data = @mysql_fetch_array ($result)) {
        $tempo = abs(strtotime($data['0']) - strtotime($data['1']));
        $minutos  = floor(($tempo)/ 60);
        $tempos[] = $minutos;
    }
    $media = round(array_sum($tempos)/10);
    $horas = (int)($media / 60);
    $h = $horas." horas ";
    $minutos = $media - ($horas * 60);
    $m = $minutos." minutos";

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{TituloChamado}",
            "{IdChamado}",
            "{KeyChamado}",
            "{Assinatura}",
            "{Dominio_WHMCS}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $titulodochamado,
            $iddochamadotelacliente,
            $keydochamado,
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }

});

//////////////////////////////////////////////////////////////////////////////////////////
// EmailPreSend //////////////////////////////////////////////////////////////////////////
// Ativação de Serviços Geral ////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('EmailPreSend', 5000, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Nome Empresa /////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblconfiguration')->where('setting','CompanyName')->get() as $dados) {
        $NOME_EMPRESA 	=	$dados->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Funções padrões do WHMCS /////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Pega o ID do usuario
	$idproduto = $vars['relid'];

    // ID do Cliente pelo serviço
    foreach (Capsule::table('tblhosting')->where('id',$idproduto)->get() as $client) {
        $iddocliente = $client->userid;
        $packageid = $client->packageid;
        $nomeDominio = $client->domain;
        $ns1 = $client->ns1;
        $ns2 = $client->ns2;
        $username = $client->username;
        $senha = $client->password;
        $ip = $client->dedicatedip;
    }

    // Descript Sennha
    $Post_DescriptSennha = ['password2' => $senha];
    $SenhaDescript = localAPI('DecryptPassword', $Post_DescriptSennha);
    if(($SenhaDescript["result"] == "success")) {
        $SenhaProduto   =   $SenhaDescript["password"];
    }

    // Gerencia o Produto
    foreach (Capsule::table('tblproducts')->where('id',$packageid)->get() as $client2) {
        $nomeProduto = $client2->name;
    }

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
    }

    // Hospedagem de Site
    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }

    if($vars['messagename'] == 'Hosting Account Welcome Email') {

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Ativação de Serviço [ Hospedagem de Site ]')->get() as $wappi) {
            $corpo_mensagem = $wappi->corpo;
            $status_mensagem = $wappi->status;
        }

        if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

            // Trata as strings para o template da mensagem
            $alteracao_stings_msg_whatsapp = [
                "{NomeCliente}",
                "{SobrenomeCliente}",
                "{Dominio}",
			    "{NomeProduto}",
                "{Ns1}",
                "{Ns2}",
                "{Username}",
                "{Senha}",
                "{Assinatura}",
                "{Dominio_WHMCS}"
            ];

            $alteracao_stings_msg_whatsapp_novos = [
                $primeironome,
                $sobrenome,
                $nomeDominio,
			    $nomeProduto,
                $ns1,
                $ns2,
                $username,
                $SenhaProduto,
                $WHATSAPP_API_ASSINATURA,
                $WHMCS_URLSISTEMA
            ];

            $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

            if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

                $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
        
                if(($CodigoBancoDados[0]->status == "1")) {
        
                    // Integração API Whatsapp
        
                    $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
        
                }
        
            } else {
        
                // Integração API Whatsapp
        
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
        
            }

        }

    }

    // Revenda de Hospedagem
    if($vars['messagename'] == 'Reseller Account Welcome Email') {

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Ativação de Serviço [ Revenda de Hospedagem ]')->get() as $wappi) {
            $corpo_mensagem = $wappi->corpo;
            $status_mensagem = $wappi->status;
        }

        if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

            // Trata as strings para o template da mensagem
            $alteracao_stings_msg_whatsapp = [
                "{NomeCliente}",
                "{SobrenomeCliente}",
                "{Dominio}",
			    "{NomeProduto}",
                "{Ns1}",
                "{Ns2}",
                "{Username}",
                "{Senha}",
                "{Assinatura}",
                "{Dominio_WHMCS}"
            ];

            $alteracao_stings_msg_whatsapp_novos = [
                $primeironome,
                $sobrenome,
                $nomeDominio,
			    $nomeProduto,
                $ns1,
                $ns2,
                $username,
                $SenhaProduto,
                $WHATSAPP_API_ASSINATURA,
                $WHMCS_URLSISTEMA
            ];

            $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

            if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

                $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
        
                if(($CodigoBancoDados[0]->status == "1")) {
        
                    // Integração API Whatsapp
        
                    $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
        
                }
        
            } else {
        
                // Integração API Whatsapp
        
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
        
            }

        }

    }


    if($vars['messagename'] == 'Dedicated/VPS Server Welcome Email') {

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Ativação de Serviço [ VPS / Dedicado ]')->get() as $wappi) {
            $corpo_mensagem = $wappi->corpo;
            $status_mensagem = $wappi->status;
        }

        if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

            // Trata as strings para o template da mensagem
            $alteracao_stings_msg_whatsapp = [
                "{NomeCliente}",
                "{SobrenomeCliente}",
                "{Dominio}",
			    "{NomeProduto}",
                "{Ns1}",
                "{Ns2}",
                "{Username}",
                "{Senha}",
                "{Assinatura}",
                "{Dominio_WHMCS}",
                "{IP_Dedicado}"
            ];

            $alteracao_stings_msg_whatsapp_novos = [
                $primeironome,
                $sobrenome,
                $nomeDominio,
			    $nomeProduto,
                $ns1,
                $ns2,
                $username,
                $SenhaProduto,
                $WHATSAPP_API_ASSINATURA,
                $WHMCS_URLSISTEMA,
                $ip
            ];

            $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

            if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

                $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
        
                if(($CodigoBancoDados[0]->status == "1")) {
        
                    // Integração API Whatsapp
        
                    $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
        
                }
        
            } else {
        
                // Integração API Whatsapp
        
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
        
            }

        }

    }


    if($vars['messagename'] == 'Other Product/Service Welcome Email') {

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Ativação de Serviço [ Outros ]')->get() as $wappi) {
            $corpo_mensagem = $wappi->corpo;
            $status_mensagem = $wappi->status;
        }

        if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

            // Trata as strings para o template da mensagem
            $alteracao_stings_msg_whatsapp = [
                "{NomeCliente}",
                "{SobrenomeCliente}",
                "{Dominio}",
			    "{NomeProduto}",
                "{Ns1}",
                "{Ns2}",
                "{Username}",
                "{Senha}",
                "{Assinatura}",
                "{Dominio_WHMCS}",
                "{IP_Dedicado}"
            ];

            $alteracao_stings_msg_whatsapp_novos = [
                $primeironome,
                $sobrenome,
                $nomeDominio,
			    $nomeProduto,
                $ns1,
                $ns2,
                $username,
                $SenhaProduto,
                $WHATSAPP_API_ASSINATURA,
                $WHMCS_URLSISTEMA,
                $ip
            ];

            $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

            if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

                $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
        
                if(($CodigoBancoDados[0]->status == "1")) {
        
                    // Integração API Whatsapp
        
                    $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
        
                }
        
            } else {
        
                // Integração API Whatsapp
        
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
        
            }

        }

    }

    

    $merge_fields = [];
    return $merge_fields;

});

//////////////////////////////////////////////////////////////////////////////////////////
// Cotação Send //////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('QuoteCreated', 1, function($vars) {
   
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Nome Empresa /////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblconfiguration')->where('setting','CompanyName')->get() as $dados) {
        $NOME_EMPRESA 	=	$dados->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Funções padrões do WHMCS /////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblquotes')->where('id',$vars["quoteid"])->get() as $dados) {
        $iddocliente 	=	$dados->userid;
    }

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }


    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Enviar Cotação')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{Numero_Cotacao}",
            "{Status_Cotacao}",
            "{Assinatura}",
            "{Dominio_WHMCS}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $vars["quoteid"],
            $vars["status"],
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }
    
});


//////////////////////////////////////////////////////////////////////////////////////////
// Alteração Status Cotação //////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('QuoteCreated', 1, function($vars) {
   
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Nome Empresa /////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblconfiguration')->where('setting','CompanyName')->get() as $dados) {
        $NOME_EMPRESA 	=	$dados->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Funções padrões do WHMCS /////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblquotes')->where('id',$vars["quoteid"])->get() as $dados) {
        $iddocliente 	=	$dados->userid;
    }

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }


    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Alteração Status Cotação')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{Numero_Cotacao}",
            "{Status_Cotacao}",
            "{Assinatura}",
            "{Dominio_WHMCS}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $vars["quoteid"],
            $vars["status"],
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }

});


//////////////////////////////////////////////////////////////////////////////////////////
// Cotação Aceita ////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('QuoteCreated', 1, function($vars) {
   
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Nome Empresa /////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblconfiguration')->where('setting','CompanyName')->get() as $dados) {
        $NOME_EMPRESA 	=	$dados->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Funções padrões do WHMCS /////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblquotes')->where('id',$vars["quoteid"])->get() as $dados) {
        $iddocliente 	=	$dados->userid;
    }

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }


    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Cotação Aceita')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{Numero_Cotacao}",
            "{Status_Cotacao}",
            "{Nome_Empresa}",
            "{Assinatura}",
            "{Dominio_WHMCS}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $vars["quoteid"],
            $vars["status"],
            $NOME_EMPRESA,
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }


    
});

//////////////////////////////////////////////////////////////////////////////////////////
// Cancelamento de serviço ///////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('CancellationRequest', 1, function($vars) {
    
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Nome Empresa /////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (Capsule::table('tblconfiguration')->where('setting','CompanyName')->get() as $dados) {
        $NOME_EMPRESA 	=	$dados->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Funções padrões do WHMCS /////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $iddocliente    =   $vars["userid"];

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }


    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Solicitação Cancelamento')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{ID_Servico}",
            "{Rasao_Cancelamento}",
            "{Tipo}",
            "{Nome_Empresa}",
            "{Assinatura}",
            "{Dominio_WHMCS}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $vars["relid"],
            $vars["reason"],
            $vars["type"],
            $NOME_EMPRESA,
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }

});

//////////////////////////////////////////////////////////////////////////////////////////
// Finalizar produto /////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('AfterModuleTerminate', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $service_id = $vars['params']['model']['id'];
    $iddocliente = $vars['params']['model']['userid'];
    $product_id = $vars['params']['model']['packageid'];
    $nomeDominio = $vars['params']['model']['domain'];
    $nomeProduto = $vars['params']['model']['product']['name'];
    $ip = $vars['params']['model']['dedicatedIp'];

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$iddocliente)->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
    }

    // Hospedagem de Site
    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    } else {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$iddocliente],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }

    }


     /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Integração API Whatsapp //////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    foreach (WHMCS\Database\Capsule::table('api_whatsapp_template_mensagens')->WHERE('titulo', 'Serviço Cancelado')->get() as $wappi) {
        $corpo_mensagem = $wappi->corpo;
        $status_mensagem = $wappi->status;
    }

    if(($status_mensagem == "1") && ($Wappi_NumeroWhatsapp != "") && ($Wappi_NumeroWhatsapp != "0") && (strlen($Wappi_NumeroWhatsapp) > 8) && ($iddocliente != 0) && ($iddocliente != "")) {

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = [
            "{NomeCliente}",
            "{SobrenomeCliente}",
            "{Dominio}",
            "{NomeProduto}",
            "{Assinatura}",
            "{Dominio_WHMCS}",
            "{IP_Dedicado}"
        ];

        $alteracao_stings_msg_whatsapp_novos = [
            $primeironome,
            $sobrenome,
            $nomeDominio,
            $nomeProduto,
            $WHATSAPP_API_ASSINATURA,
            $WHMCS_URLSISTEMA,
            $ip
        ];

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp,$alteracao_stings_msg_whatsapp_novos,$corpo_mensagem);

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$iddocliente)->get();
    
            if(($CodigoBancoDados[0]->status == "1")) {
    
                // Integração API Whatsapp
    
                $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
            }
    
        } else {
    
            // Integração API Whatsapp
    
            $wappi_classes->EnviarMensagemTexto($Wappi_NumeroWhatsapp,$Wappi_Whatsapp_Mensagem);
    
        }

    }
    
});

//////////////////////////////////////////////////////////////////////////////////////////
// Validação de Conta ////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook("ClientAreaPage", 1, function ($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    if (!isset($_SESSION["uid"])) {

        return NULL;

    } else {

        // Verifica se e obrigatorio verificação de whatsapp 
        // 1 = Ativado
        // 0 = Desativado

        if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$_SESSION["uid"])->get();

            if(($CodigoBancoDados[0]->status != 1)) {

                if(($_GET["m"] != "whatsapp")) {

                    // Faz o redirecionamento
                    redir("m=whatsapp", "index.php");
                    exit();
    
                }

            }

        }

    }

});

//////////////////////////////////////////////////////////////////////////////////////////
// Cliente Edit //////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

add_hook('ClientEdit', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    try {
        
        foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'wappi_whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
            $Wappi_Validacao_Whatsapp    =   $wappi->value;
        }

    } catch (\Throwable $th) {
        
    }

    if(($Wappi_Validacao_Whatsapp == "1")) {

        try {
            
            WHMCS\Database\Capsule::table("api_whatsapp_validacao_whatsapp")->where("ID_CLIENTE_WHMCS",$vars["userid"])->delete();
            
        } catch (\Throwable $th) {}

    }

    
});

add_hook('AdminAreaClientSummaryActionLinks', 1, function($vars) {

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    // Dados do Cliente tblclients
    foreach (Capsule::table('tblclients')->where('id',$_GET["userid"])->get() as $informacoesdocliente) {
        $primeironome = $informacoesdocliente->firstname;
        $sobrenome = $informacoesdocliente->lastname;
        $email = $informacoesdocliente->email;
        $telefone = ltrim(preg_replace('/\D/', '', $informacoesdocliente->phonenumber), 0);
        $endereço = $informacoesdocliente->address1;
        $bairro = $informacoesdocliente->address2;
        $cidade = $informacoesdocliente->city;
        $estato = $informacoesdocliente->state;
        $cep = $informacoesdocliente->postcode;
        $pais_Cliente = $informacoesdocliente->country;
        $IdiomaCliente	=	($informacoesdocliente->language == '' ? $Wappi_Defalt_IdiomaWHMCS : $informacoesdocliente->language);
    }

    if(($WHATSAPP_API_VALIDACAOWHATSAPP == "1")) {

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {
    
            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$_GET["userid"]],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }
    
    } else {
    
        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {
    
            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }
    
            foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$_GET["userid"]],])->get() as $dados) {
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
            }
    
        } else {
    
            $Wappi_NumeroWhatsapp = $telefone;
    
        }
    
    }

    $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$_GET["userid"])->get();
    
    $Wappi_ConteudoAdminArray = [];

    $Wappi_ConteudoAdminArray[] = '<div id="div_carregando_whatsapp" style="display: none; text-align: center;">
        <img src="../modules/addons/whatsapp/templates/imagens/loading.svg" style="padding: 10px; width: 82px;">
    </div>

    <div id="div_retorno_whatsapp"></div>
    
    <form method="POST" id="enviarMensagemCustom" onSubmit="sendEnviarMensagemCustom();return false;">
                                    
        <input type="hidden" name="acao" value="sendCustomMsg">
        <input type="hidden" name="id_cliente" value="' . $_GET["userid"] . '">

        <button type="submit" class="btn btn-success btn-sm" data-toggle="modal" data-target="#WappiWhatsapp" style="margin: 0px 0px 10px 0px; width: 96%; padding: 15px; font-size: 13px;"><i class="fab fa-whatsapp"></i> Mensagem Por Whatsapp</button>

        <script type="text/javascript">

            function sendEnviarMensagemCustom(){
                $.ajax({
                    type: "POST",
                    url: "../modules/addons/whatsapp/funcoes.php",
                    data: $("#enviarMensagemCustom").serialize(),
                    beforeSend: function(){
                        $("#div_retorno_whatsapp").hide();
                        $("#div_carregando_whatsapp").show();
                    },
                    success: function(data){
                        $("#div_carregando_whatsapp").hide();
                        $("#div_retorno_whatsapp").show();
                        $("#div_retorno_whatsapp").empty().html(data);
                    },
                    // Se acontecer algum erro é executada essa função
                    error: function(erro){
                        $("#div_carregando_whatsapp").hide();
                    }
                });
            }

        </script>

    </form>

    <br>
    <div class="title">Validação de Whatsapp</div>

    <li>Número whatsapp: <strong>' . $Wappi_NumeroWhatsapp . '</strong> ' . ($CodigoBancoDados[0]->status == "1" ? '<div class="btn btn-xs btn-success">Verificado</div>' : '<div class="btn btn-xs btn-danger">Não verificado</div>') . '</li>
    <br>
    <div class="title">Outras ações</div>';

    return $Wappi_ConteudoAdminArray;

});

// Button

add_hook('ClientAreaHeaderOutput', 1, function($vars) {

    // Integração API

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    try {
        
        foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
            $WHATSAPP_API_URL    =   $wappi->value;
        }
    
        foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
            $WHATSAPP_API_SESSAO    =   $wappi->value;
        }
    
        foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
            $WHATSAPP_API_APIKEY    =   $wappi->value;
        }
    
        foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
            $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
        }
    
        foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
            $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
        }
    
        foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
            $WHATSAPP_API_ASSINATURA    =   $wappi->value;
        }

        foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_BotaoSite']])->get() as $wappi) {
            $WHATSAPP_API_BOTAOSITE    =   $wappi->value;
        }
		

		foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_NumeroWhatsapp']])->get() as $wappi) {
            $WHATSAPP_API_BOTAOSITE_NUMEROWHATSAPP    =   $wappi->value;
        }
		


        
        
    } catch (\Throwable $th) {
        //throw $th;
    }

    if(($WHATSAPP_API_URL != NULL)) {

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

        $BOTAO_NOME_ATENDENTE   =   BOTAO_NOME_ATENDENTE;
        $BOTAO_NOME_EMPRESA     =   BOTAO_NOME_EMPRESA;
        $BOTAO_MSG_CHAT         =   BOTAO_MSG_CHAT;
        $BOTAO_MSG_PRED_CLIENTE =   BOTAO_MSG_PRED_CLIENTE;
        $BOTAO_COR              =   COR_BOTAO;
        $BOTAO_COR_HEADER       =   COR_HEADER;


        if(($WHATSAPP_API_BOTAOSITE == "1")) {

            //$Wappi_Infor_Whatsapp    =   $wappi_classes->ObterInformacoesWhatsappConectado();

            //$Numero_Whatsapp_Conectado  =   $Wappi_Infor_Whatsapp["phone"];
			

            if((!$WHATSAPP_API_BOTAOSITE_NUMEROWHATSAPP)) {
                return;
            }

            return <<<HTML

                <link rel="stylesheet" href="{$WHMCS_URLSISTEMA}/modules/addons/whatsapp/templates/css/wappi.css">
                <script type="text/javascript" src="{$WHMCS_URLSISTEMA}/modules/addons/whatsapp/templates/javascript/button.js"></script>

                <div id="Api_Whatsapp_Botao"></div>

                <script type="text/javascript">

                    $("#Api_Whatsapp_Botao").WappiWhatsappButton({
                        phone: "{$WHATSAPP_API_BOTAOSITE_NUMEROWHATSAPP}",
                        message: "{$BOTAO_MSG_PRED_CLIENTE}",
                        chatMessage: "{$BOTAO_MSG_CHAT}",
                        size: "62px",
                        showPopup: true,
                        autoOpenTimeout: 5000,
                        headerColor: "{$BOTAO_COR_HEADER}",
                        buttonColor: "{$BOTAO_COR}",
                        avatar: "{$WHMCS_URLSISTEMA}/modules/addons/whatsapp/templates/imagens/admin.png",
                        buttonImage: "{$WHMCS_URLSISTEMA}/modules/addons/whatsapp/templates/imagens/whatsapp.svg",
                        position: "left",
                        linkButton: false,
                        showOnIE: true,
                        nameClient: "{$BOTAO_NOME_ATENDENTE}",
                        headerTitle: "{$BOTAO_NOME_EMPRESA}",
                        zIndex: "999999999999999",
                    });

                </script>
                
            HTML;

        }

    }

});

add_hook('AdminAreaHeaderOutput', 1, function($vars) {
    
    $return = '';

    if (($_GET["module"] != "whatsapp")) {

        $return = '<link rel="stylesheet" href="../modules/addons/whatsapp/templates/css/wappi.css">

        <script>

            $(document).ready(function() {

                let updateFila_bottom  =   function() {

                    $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php",{
                        lista_chat_bottom: true
                    },
                    function(data, status) {
                        $("#chat_bottom_admin").html(data);
                    });

                }

                updateFila_bottom();

                /** Intervalo para atualização **/

                setInterval(updateFila_bottom, 10000);

            });

        </script>

        <div class="chat_bottom_admin" id="chat_bottom_admin">';

        $sessao_admin   =   $_SESSION["adminid"];

        $chat = 0;

        $Query_Chats_left   =   'SELECT * FROM api_whatsapp_chat WHERE status = "0" ORDER BY id DESC';

        $Query_Chats_left_Exec =   mysql_query($Query_Chats_left);

        $Query_Chats_leftCount =   mysql_query("SELECT * FROM api_whatsapp_chat");
        $Query_Chats_leftCount_rows = mysql_num_rows($Query_Chats_leftCount);

        while ($dados = mysql_fetch_array($Query_Chats_left_Exec)) {

            $Query_New_MsgCount =   mysql_query("SELECT * FROM api_whatsapp_mensagens_chat WHERE ticket = '" . $dados["ticket"] . "' AND status = '0'");
            $Query_New_MsgCount_rows = mysql_num_rows($Query_New_MsgCount);

            if(($sessao_admin == $dados["funcionario"]) || ($dados["status"] == "0")) {

                if(($dados["status"] != "3")) {

                    foreach (Capsule::table('api_whatsapp_filaatendimento')->WHERE('Fila',$dados["departamento"])->get() as $value) {

                        $Usuarios_Permitidos    =   explode(",",$value->Usuarios);

                        foreach ($Usuarios_Permitidos as $key => $values) {

                            if(($values == $_SESSION["adminid"])) {

                                $return .= '<script>
    
                                    $(document).ready(function() {
        
                                        $("#aceitarAtendimento_' . $dados["ticket"] . '").on("click", function() {
        
                                            var $this = $(this);
                                            $this.button("loading");
        
                                            setTimeout(function() {
                                                $this.button("reset"); 
                                            }, 8000);
        
                                            $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php", { aceitarAtendimento: true, id_chat: "' . $dados["ticket"] . '" });
        
                                            setTimeout(function() {
                                                window.location = "./addonmodules.php?module=whatsapp&chat=' . $dados["ticket"] . '"; 
                                            }, 2000);
        
                                        });
        
                                    });
        
                                </script>
                                
                                <li>
        
                                    <a href="./addonmodules.php?module=whatsapp&chat=' . $dados["ticket"] . '" class="disabled">

                                        <div class="foto" style="background: url(' . $dados["foto_cliente_sessao"] . '); background-size: 100% 100% !important; width: 77px;"></div>
                                        <div class="informacao">
                                            <p>
                                                ' . $dados["send_id"] . '<br>
                                                FILA: <strong>' . $dados["departamento"] . '</strong>

                                                ' . ($Query_New_MsgCount_rows > 0 ? '<span class="new_msg">' . $Query_New_MsgCount_rows . '</span>' : '' ) . '

                                            </p>
                                        </div> 

                                    </a>

                                    ' . ($dados["status"] == 0 ? '<center><button class="btn btn-primary" id="aceitarAtendimento_' . $dados["ticket"] . '" data-loading-text="<i class=\'fad fa-spinner fa-spin\' style=\'margin-right: 5px;\'></i> Carregando" style="color: #FFF;">ACEITAR</button></center>' : '') . '
                                
                                </li>';

                            }

                        }

                    }

                }

            }

        }

        $return .= '</div>';

    }

    return $return;

});


add_hook("AdminInvoicesControlsOutput", 1, function ($vars) {

    $invoice = WHMCS\Database\Capsule::table("tblinvoices")->where("id", $vars["invoiceid"])->first();

    switch ($invoice->status) {
        case 'Unpaid':
            
            return '<form method="POST" id="Form_Alerta_LembreteVencimento" onSubmit="SendAlerta_LembreteVencimento();return false;" style="padding: 10px;">

                <input type="hidden" name="acao" value="EnviarAlerta_LembreteVencimento">
                <input type="hidden" name="id" value="' . $_GET["id"] . '">
                <button class="btn btn-primary" type="submit"><i class="fab fa-whatsapp"></i> Enviar lembrete no whatsapp</button>

            </form>

            <br>
            
            <div id="conteudo_invoice"></div>
            
            <div id="div_carregando" style="display: none; text-align: center;">
                <img src="../modules/addons/whatsapp/templates/imagens/loading.svg" style="padding: 34px;">
            </div>
            
            <script type="text/javascript">

                function SendAlerta_LembreteVencimento() {

                    $.ajax({

                        type: "POST",
                        url: "../modules/addons/whatsapp/funcoes.php",
                        data: $("#Form_Alerta_LembreteVencimento").serialize(),
                        beforeSend: function(){
                            $("#div_carregando").show();
                        },
                        success: function(data){
                            $("#div_carregando").hide();
                            $("#conteudo_invoice").empty().html(data);
                        },
                        // Se acontecer algum erro é executada essa função
                        error: function(erro){
                            $("#div_carregando").hide();
                        }

                    });

                }

            </script>';
            
            break;
        
        default:
            return;
            break;
    }

});


/*
add_hook("AdminAreaViewQuotePage", 1, function ($vars) {

    if ($_GET["envio"]) {
        $enviado = "<div class=\"successbox\"><strong><span class=\"title\">Cotação</span></strong><br>Enviada com sucesso!</div>";
    } else {
        $enviado = "<div class=\"errorbox\"><strong><span class=\"title\">Cotação</span></strong><br>Falha ao enviar!  Motivo: " . $_GET["msg"] . "</div>";
    }
    if ($_GET["id"] && $_GET["msg"]) {
        return "        \r\n          <script>         \r\n                \r\n           \t\t\r\n\t\t\t\t \$( document ).ready(function() {\t                    \t\t                    \r\n\t\t\t\t\t\$( \"form[id=\\\"clientinfo\\\"]\" ).before(`" . $enviado . "`);\t\t\t\t\t\t\r\n                });\r\n                </script>\r\n            ";
    }
    $quote = WHMCS\Database\Capsule::table("tblquotes")->where("id", $vars["quoteid"])->first();
    
       
            return "<script>      \r\n\t\t\t\t\$( document ).ready(function() {\t\t\t\t\t\r\n\t\t\t\t\t\$( \"#inputSaveChanges\" ).after(` <a target=\"_self\" href=\"addonmodules.php?module=notifica&outputaction=quota&id=" . $vars["quoteid"] . "\"><button type=\"button\" class=\"btn btn-success subs-btn\"><i class=\"far fa-paper-plane\"></i> Enviar Cotação</button></a>`);\t\t\t\t\t\r\n\t\t\t\t});\r\n\t\t\t\t</script>\r\n\t\t\t";
       

});
*/