{extends file="adminarea/template/includes/header.tpl"}

{block name="template-heading"}
    {include file="adminarea/template/includes/breadcrumb.tpl"}
{/block}

{block name="template-tabs"}
    {include file="adminarea/template/includes/tabs.tpl"} 
{/block}

{block name="template-content"}
    <div class="section">
        <div class="t-c mob-t-c--full" data-table-container data-table-check-container>
            <div class="t-c__top top m-b-3x" data-top-search data-toggler-options="toggleClass: is-open;">
                <div class="top__toolbar">
                    <h2 class="section__title type-5">Pages</h2>
                </div>
                <div class="top__toolbar is-right">
                    <div class="top__search input-group">
                        <span class="input-group__icon zmdi zmdi-search"></span>
                        <input class="form-control input-group__form-control table-search" data-toggler-options="toggleFocus: true; clearOnBlur: true;" value="" placeholder="Search..." id="table-search" placeholder="Search">
                    </div>
                    <div class="top__filter has-dropdown" data-filter-table="#pages-table">
                        <button class="btn btn--default btn--outline btn--mob-link" type="button" data-toggle="filter-dropdown" data-placement="bottom right">
                            <span class="btn__label">Group:</span>
                            <span class="btn__text">
                                <span class="status" data-filter-icon><span class="status__text" data-filter>All</span></span>
                            </span>
                            <span class="btn__icon btn__icon-arrow zmdi zmdi-chevron-down" data-arrow-target></span>
                        </button>
                        <div class="dropdown" data-dropdown-menu>
                            <div class="dropdown__arrow" data-arrow></div>
                            <div class="dropdown__menu" data-filter-table="#pages-table">
                                <ul class="nav nav--sm">
                                    <li class="nav__header">
                                        <span class="nav__title">Filter by group</span>
                                    </li>
                                    <li class="nav__item is-active" data-value="All">
                                        <a class="nav__link" href="#">
                                            <span class="nav__link-text">All</span>
                                            <span class="badge badge--outline"></span>
                                        </a>
                                    </li>
                                    <li class="nav__item" data-value="Client Area" data-status-class="active">
                                        <a class="nav__link" href="#">
                                            <span class="nav__link-text">Client Area</span>
                                            <span class="badge badge--outline"></span>
                                        </a>
                                    </li>
                                    <li class="nav__item" data-value="Order Form" data-status-class="error">
                                        <a class="nav__link" href="#">
                                            <span class="nav__link-text">Order Form</span>
                                            <span class="badge badge--outline"></span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="t-c__body t-c__body--boxed">
                <table class="t-c__table table mob-table--block" id="pages-table" data-services-table data-search-input="#table-search" data-order='[3, "asc"]' data-clickable-rows="true" data-responsive="false">
                    <colgroup>
                        <col class="table__col-15">
                        <col class="table__col-5">
                        <col class="table__col-4">
                        <col class="table__col-0">
                    </colgroup>
                    <thead>
                        <tr>
                            <th class="cell-name">
                                <span>Name</span>
                            </th>
                            <th class="cell-layout">
                                <span>Layout</span>
                            </th>
                            <th class="cell-group filter">
                                <span>Group</span>
                            </th>
                            <th class="cell-actions no-sort"></th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach from=$template->getPages() item=page key=k}
                            <tr data-url="{$helper->url('Template@pages',['templateName'=>$template->getMainName(), 'pageName' => $page->getMainName()])}">
                                <td class="cell-name">
                                    <div class="content-name">
                                        <strong>{$page->getName()}</strong>
                                        {*<p class="extensions-description">{$page->getDescription()}</p>*}
                                    </div>
                                </td>
                                <td class="cell-layout">
                                    <div class="status">
                                        {assign var="activePageOption" value=false}
                                        {foreach from=$page->getPageOptions() item=pageOption}
                                            {if $pageOption->isActive()}
                                                {assign var="activePageOption" value=true}
                                                {$pageOption->getName()}
                                            {/if}
                                        {/foreach}
                                        {if $activePageOption==false}
                                            Default
                                        {/if}
                                    </div>
                                </td>
                                <td class="cell-group" data-order="group">
                                    <strong>{$page->getGroup()}</strong>
                                </td>
                                <td class="cell-actions">
                                    {if $page->isDashboard()}
                                        <a class="btn btn--sm btn--default btn--outline" href="{$helper->url('Template@widgets',['templateName'=>$template->getMainName(), 'pageName' => $page->getMainName(),'gridName'=>'default'])}">
                                            <span class="btn__text">Manage</span>
                                        </a>
                                    {else}
                                        <a class="btn btn--sm btn--default btn--outline" href="{$helper->url('Template@pages',['templateName'=>$template->getMainName(), 'pageName' => $page->getMainName()])}">
                                            <span class="btn__text">Manage</span>
                                        </a>
                                    {/if}
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
                <div class="preloader-container" data-table-preloader>
                    <div class="preloader"></div>
                </div>
            </div>
        </div>
    </div>

    {foreach from=$template->getPages() item=page key=k}
        <div id="modalPreview-page-{$k}" class="modal modal--preview">
            <div class="modal__dialog">
                <div class="modal__content">
                    <button class="close btn btn--xs btn--icon btn--link is-absolute" data-dismiss="lu-modal" aria-label="Close">
                        <i class="btn__icon zmdi zmdi-close"></i>
                    </button>
                    {if $page->hasConfiguredOption() && !$page->isDashboard()}
                        <img src="{$page->getConfiguredOption()->getPreview()}" alt=""/>
                    {else}
                        {if $page->getPreview()}
                            <img src="{$page->getPreview()}" alt=""/>
                        {else}
                            <img src="{$helper->img('placeholders/placeholder-xs.svg')}" alt=""/>
                        {/if}
                    {/if}
                </div>
            </div>
        </div>
    {/foreach}
    {* <div class="top top--tools">
    <div class="top__toolbar top__toolbar--left">
    <div class="input-group">
    <span class="icon-sm input-group__icon">
    <i class="zmdi zmdi-search"></i>
    </span>
    <input class="form-control input-group__form-control  table-search" value="" placeholder="Search">
    </div>
    </div>
    <div class="top__toolbar">
    <div class="form-group">
    <div class="has-dropdown"  data-drop-position="bottom left" >
    <div class="btn btn--light text-normal dropdown-toggle">
    <span class="btn__text">
    <span class="status">Category:</span> 
    <span class="filter">All</span>
    </span>
    <span class="btn__icon btn__icon--right">
    <i class="zmdi zmdi-caret-down"></i>
    </span>
    </div>           
    </div>
    </div>
    </div>
    </div> *}
{/block}






