{extends file="adminarea/template/includes/header.tpl"}

{block name="template-heading"}
    {include file="adminarea/template/includes/breadcrumb.tpl"}
{/block}

{block name="template-tabs"}
    {include file="adminarea/template/includes/tabs.tpl"}
{/block}
{block name="template-content"}
    <form id="settingsForm" action="{$helper->url('Template@saveSettings',['templateName'=>$template->getMainName()])}" method="POST">
        <div class="section">
            <h2 class="section__title type-5">General Settings</h2>
            <div class="row">
                <div class="col-lg-4 col-md-6 col-sm-12">
                    <div class="form-group">
                        <label class="form-label text-default">Logo URL
                            <i class="zmdi zmdi-help m-l-1x text-faded" data-toggle="tooltip" data-title="By default Lagom logo in main navigation links to main page of WHMCS Client Area. Placing different URL to this input, will change default behavior, and logo will link to this specific URL."></i>
                        </label>
                        <input value="{$settings['logo_url']}" class="form-control " type="text" name="settings[logo_url]">
                    </div>
                    
{*                    <div class="form-group d-flex">*}
{*                        <span class="form-label text-default form-text flex-grow-1">Display mode switcher*}
{*                             <i class="zmdi zmdi-help m-l-1x text-faded" data-toggle="tooltip" data-title="Displays switcher which is used to change website to dark or light theme."></i>*}
{*                         </span>*}
{*                         <label>*}
{*                             <div class="switch switch--primary">*}
{*                                 <input type="hidden" name="settings[display_mode_switcher]" value="0" />*}
{*                                 <input class="switch__checkbox mode-display" name="settings[display_mode_switcher]" value="1" type="checkbox" {if $settings['display_mode_switcher']} checked="checked" {/if}>*}
{*                                 <span class="switch__container"><span class="switch__handle"></span></span>*}
{*                             </div>*}
{*                         </label>*}
{*                     </div>*}
{*                    <div class="theme-selectors row" style="display: {if !$settings['display_mode_switcher']}none{/if};">*}
{*                        <div class="form-group col-sm-6">*}
{*                            <label class="form-text">Light Mode</label>*}
{*                            <select class="form-control" name="settings[light_mode_theme]" data-mode-switcher>*}
{*                                {foreach $template->getStyles() as $style}*}
{*                                    <option value="{$style->getMainName()}" {if $settings['light_mode_theme'] == $style->getMainName()} selected {/if}>{$style->getName()}</option>*}
{*                                {/foreach}*}
{*                            </select>*}
{*                        </div>*}
{*                        <div class="form-group col-sm-6">*}
{*                            <label class="form-text">Dark Mode</label>*}
{*                            <select class="form-control" name="settings[dark_mode_theme]" data-mode-switcher>*}
{*                                {foreach $template->getStyles() as $style}*}
{*                                    <option value="{$style->getMainName()}" {if $settings['dark_mode_theme'] == $style->getMainName()} selected {/if}>{$style->getName()}</option>*}
{*                                {/foreach}*}
{*                            </select>*}
{*                        </div>*}
{*                    </div>*}
                    {* <h3 class="type-6">Homepage Price Display <i class="zmdi zmdi-help m-l-1x text-faded" data-toggle="tooltip" data-title="Modern homepage template, by default shows product group price from the first active billing cycle. Activating this option, will change this behavior and will use the longest billing cycle, which will allow you to always shows the lowest price."></i></h3>
                    <div class="form-group  d-flex form-group--bordered">
                        <span class="form-label text-default form-text flex-grow-1 m-b-0x">Use longest billing cycle</span>
                        <label>
                            <div class="switch switch--primary">
                                <input type="hidden" name="settings[display_longest_billing_cycle_monthly_price]" value="0" />
                                <input class="switch__checkbox" name="settings[display_longest_billing_cycle_monthly_price]" value="1" type="checkbox" {if $settings['display_longest_billing_cycle_monthly_price']} checked="checked" {/if}>
                                <span class="switch__container"><span class="switch__handle"></span></span>
                            </div>
                        </label>
                    </div>    *}
                    <h3 class="type-6">Gravatar <i class="zmdi zmdi-help m-l-1x text-faded" data-toggle="tooltip" data-title="Show gravatar"></i></h3>
                    <div class="form-group  d-flex form-group--bordered">
                        <span class="form-label text-default form-text flex-grow-1 m-b-0x">Show Gravatar</span>
                        <label>
                            <div class="switch switch--primary">
                                <input type="hidden" name="settings[show_gravatar_image]" value="hidden" />
                                <input class="switch__checkbox" name="settings[show_gravatar_image]" value="displayed" type="checkbox" {if $settings['show_gravatar_image'] == "displayed"} checked="checked" {/if}>
                                <span class="switch__container"><span class="switch__handle"></span></span>
                            </div>
                        </label>
                    </div>
                    <h3 class="type-6">Affixed Navigation <i class="zmdi zmdi-help m-l-1x text-faded" data-toggle="tooltip" data-title="Affixed Navigation"></i></h3>
                    <div class="form-group  d-flex form-group--bordered">
                        <span class="form-label text-default form-text flex-grow-1 m-b-0x">Affixed Navigation</span>
                        <label>
                            <div class="switch switch--primary">
                                <input type="hidden" name="settings[show_affixed_navigation]" value="disabled" />
                                <input class="switch__checkbox" name="settings[show_affixed_navigation]" value="enabled" type="checkbox" {if $settings['show_affixed_navigation'] == "enabled"} checked="checked" {/if}>
                                <span class="switch__container"><span class="switch__handle"></span></span>
                            </div>
                        </label>
                    </div>
                    {include file="adminarea/template/includes/cookie_group.tpl"
                        title='Cookie Box'
                        name='cookie_box_config'
                        label='Cookie box'
                        tooltip='Cookie box'
                        value=$settings['show_cookie_box']
                    }
                </div>
            </div>
        </div>
        <div class="section">
            <h2 class="section__title type-5">Order Form</h2>
             <div class="row">
                <div class="col-lg-4 col-md-6 col-sm-12">
                    <h3 class="type-6">Package Width <i class="zmdi zmdi-help m-l-1x text-faded" data-toggle="tooltip" data-title="Automatic adjustment of the package width in a row depending on their quantity"></i></h3>
                    <div class="form-group  d-flex form-group--bordered">
                        <span class="form-label text-default form-text flex-grow-1 m-b-0x">Auto adjustments width</span>
                        <label>
                            <div class="switch switch--primary">
                                <input type="hidden" name="settings[auto_recalculate_package_width]" value="0" />
                                <input class="switch__checkbox" name="settings[auto_recalculate_package_width]" value="1" type="checkbox" {if $settings['auto_recalculate_package_width']} checked="checked" {/if}>
                                <span class="switch__container"><span class="switch__handle"></span></span>
                            </div>
                        </label>
                    </div>
                    <div class="form-group">
                        <h3 class="type-6">Package Price
                            <i class="zmdi zmdi-help m-l-1x text-faded" data-toggle="tooltip" data-title="Decide how to wrap long price amounts, during order process in first order steps, where all product packages are displayed."></i>
                        </h3>
                        <select class="form-control" name="settings[package_price_wrap]">
                            <option value="default" {if $settings['package_price_wrap'] == 'default'} selected {/if}>Default</option>
                            <option value="break-all" {if $settings['package_price_wrap'] == 'break-all'} selected {/if}>Break All</option>
                        </select>
                    </div>
                    {include file="adminarea/template/includes/group_inputs.tpl"
                        title='Product Nameserver'
                        name='hide_nameserver_fields'
                        label='Hide name server fields'
                        tooltip='Hide name server fields, in product configuration step, during ordering process.'
                        value=$settings['hide_nameserver_fields']
                        customHostname=true
                    }
                    {include file="adminarea/template/includes/group_inputs.tpl"
                        title='Product Hostname'
                        name='hide_password_fields'
                        label='Hide hostname/root password fields'
                        tooltip='Hide hostname/root password fields, in product configuration step, during ordering process.'
                        value=$settings['hide_password_fields']
                    }
                </div>
            </div>
        </div>
    </form>
    <div class="modal modal--hero" id="settingsConfirmationModal">
        <div class="modal__dialog">
            <div class="modal__content">
                <div class="modal__top top">
                    <div class="top__title type-4 text-primary"><i class="zmdi zmdi-alert-circle-o m-r-2x"></i>Confirmation</div>
                    <div class="top__toolbar">
                        <button class="close btn btn--xs btn--icon btn--link" data-dismiss="lu-modal" aria-label="Close">
                            <i class="btn__icon zmdi zmdi-close"></i>
                        </button>
                    </div>
                </div>
                <div class="modal__body">
                    <p><strong>Are you sure, that you'd like to save these changes?</strong></p>
                </div>
                <div class="modal__actions">
                    <a class="btn btn--primary" onclick="$('#settingsForm').submit()">
                        <span class="btn__text">Confirm</span>
                    </a>
                    <button data-dismiss="lu-modal" aria-label="Close" type="button" class="btn btn--default btn--outline"><span class="btn__text">Cancel</span></button>
                </div>
            </div>
        </div>
    </div>
    {literal}
        <style>
            .form-error{
                font-weight: 400;
                color: red;
                margin-top: 5px;
            }
        </style>
    {/literal}
{/block}
{block name="template-actions"}
    <div class="app-main__actions">
        <div class="container">
            <a class="btn btn--success" data-general-save>
                <span class="btn__text">Save</span>
                <span class="btn__preloader preloader"></span>
            </a>
            <a class="btn btn--default btn--outline " href="{$helper->url('Template@general',['templateName'=>$template->getMainName()])}">
                <span class="btn__text">Cancel</span>
                <span class="btn__preloader preloader"></span>
            </a>
        </div>
    </div>
{/block}
