{extends file="adminarea/template/includes/header.tpl"} 

{block name="template-heading"}
    {include file="adminarea/template/includes/breadcrumb.tpl"}
{/block}

{block name="template-tabs"}
    {include file="adminarea/template/includes/tabs.tpl"} 
{/block}
{block name="template-content"}
    <div class="section">
        <div class="t-c mob-t-c--full" data-table-container data-table-check-container>
            <div class="t-c__top top m-b-3x" data-top-search data-toggler-options="toggleClass: is-open;">
                <div class="top__toolbar">
                    <h2 class="section__title type-5">Extensions</h2>
                </div>
                <div class="top__toolbar is-right">
                    <div class="top__search input-group">
                        <span class="input-group__icon zmdi zmdi-search"></span>
                        <input class="form-control input-group__form-control table-search" data-toggler-options="toggleFocus: true; clearOnBlur: true;" value="" placeholder="Search..." id="table-search" placeholder="Search">
                    </div>
                    <div class="top__filter has-dropdown" data-filter-table="#extensions-table">
                        <button class="btn btn--default btn--outline btn--mob-link" type="button" data-toggle="filter-dropdown" data-placement="bottom right">
                            <span class="btn__label">Status: </span>
                            <span class="btn__text">
                                <span class="status" data-filter-icon><span class="status__text" data-filter>All</span></span>
                            </span>
                            <span class="btn__icon btn__icon-arrow zmdi zmdi-chevron-down" data-arrow-target></span>
                        </button>
                        <div class="dropdown" data-dropdown-menu>
                            <div class="dropdown__arrow" data-arrow></div>
                            <div class="dropdown__menu" data-filter-table="#extensions-table">
                                <ul class="nav nav--sm">
                                    <li class="nav__header">
                                        <span class="nav__title">Filter by status</span>
                                    </li>
                                    <li class="nav__item is-active" data-value="All">
                                        <a class="nav__link" href="#">
                                            <span class="nav__link-icon status status--"></span>
                                            <span class="nav__link-text">All</span>
                                            <span class="badge badge--outline"></span>
                                        </a>
                                    </li>
                                    <li class="nav__item" data-value="Disabled"  data-status-class="error">
                                        <a class="nav__link" href="#">
                                            <span class="nav__link-icon status status--closed"></span>
                                            <span class="nav__link-text">Disabled</span>
                                            <span class="badge badge--outline"></span>
                                        </a>
                                    </li>
                                    <li class="nav__item" data-value="Active"  data-status-class="active">
                                        <a class="nav__link" href="#">
                                            <span class="nav__link-icon status status--active"></span>
                                            <span class="nav__link-text">Active</span>
                                            <span class="badge badge--outline"></span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="t-c__body t-c__body--boxed">
                <table class="t-c__table table mob-table--block" id="extensions-table" data-services-table data-search-input="#table-search" data-order='[3, "asc"]' data-clickable-rows="true" data-responsive="false">
                    <colgroup>
                        <col class="table__col-15">
                        <col class="table__col-5">
                        <col class="table__col-4">
                        <col class="table__col-0">
                    </colgroup>
                    <thead>
                        <tr>
                            <th class="cell-name">
                                <span>Name</span>
                            </th>
                            <th class="cell-version">
                                <span>Version</span>
                            </th>
                            <th class="cell-status filter">
                                <span>Status</span>
                            </th>
                            <th class="cell-actions no-sort"></th>
                        </tr>
                    </thead>
                    <tbody>
                        {if $template->getExtensions()|@count == 0}
                            {* Brak *}
                        {else}                            
                            {foreach from=$template->getExtensions() item=extension key=k}
                                <tr data-url="{if $extension->isActive()} {$helper->url('Template@extension',['templateName'=>$template->getMainName(),'extension'=>$extension->getLinkName(),'exaction'=>'settings'])} {else} {$helper->url('Template@extension',['templateName'=>$template->getMainName(),'extension'=>$extension->getLinkName(),'exaction'=>'info'])} {/if}">
                                    <td class="cell-name">
                                        <div class="rail">
                                            <div class="content-extension">
                                                <div class="img-thumbnail">
                                                    <img src="{$whmcsURL}/templates/lagom/core/extensions/{$extension->className}/thumb.png" alt=""/>
                                                </div>
                                            </div>
                                            <div class="content-extension">
                                                <strong>{$extension->getName()}</strong>
                                                <p class="extensions-description">{$extension->getDescription()}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="cell-version">
                                        <strong>v{$extension->getVersion()}</strong>
                                    </td>
                                    <td class="cell-status">
                                        <div class="status">
                                            {if $extension->isActive()}
                                                <label class="label label--success label--outline">Active</label>
                                            {else}
                                                <label class="label label--outline is-disabled">Disabled</label>
                                            {/if}
                                        </div>
                                    </td>
                                    <td class="cell-actions">
                                        {if $extension->isActive()}
                                            <a href="{$helper->url('Template@extension',['templateName'=>$template->getMainName(),'extension'=>$extension->getLinkName(),'exaction'=>'settings'])}" class="btn btn--sm btn--default btn--outline"><span class="btn__text">Manage</span></a>
                                        {else}
                                            <a href="{$helper->url('Template@extension',['templateName'=>$template->getMainName(),'extension'=>$extension->getLinkName(),'exaction'=>'info'])}" class="btn btn--sm btn--default btn--outline"><span class="btn__text">Manage</span></a>
                                        {/if}
                                    </td>
                                </tr>
                            {/foreach}
                        {/if}
                    </tbody>
                </table>
                <div class="preloader-container is-hidden" data-table-preloader>
                    <div class="preloader"></div>
                </div>
            </div>
        </div>
    </div>
    {*<div class="row row--eq-height">
    {foreach from=$template->getExtensions() item=extension key=k}
    <div class="col-4">
    <div class="widget">
    {if $extension->getPreview()}
    <img src="{$extension->getPreview()}" alt=""/>
    {else}
    <img src="{$helper->img('placeholders/placeholder-xs.svg')}" alt=""/>
    {/if}
    <div class="widget__actions widget__actions--raised flex flex-items-xs-between">
    <div><span class="type-7">{$extension->getName()}</span></div>
    {$extension->getDescription()}
    <div class="p-0x">
    <a class="btn btn--sm btn--default btn--outline" href="{$helper->url('Template@extension',['templateName'=>$template->getMainName(),'extension'=>$extension->getLinkName()])}">
    <span class="btn__text">Manage</span>
    </a>
    </div>
    </div>
    </div>   
    </div>
    {/foreach}
    </div>*}
{/block}



















