import { Component } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { select, Store } from "@ngrx/store";
import { loadSchemePreviewResponse, saveColorScheme, unsavedChangesSetDefault } from "../../../../../store/colors/color.actions";
import { selectColorIsLoading, selectColorSchemeData } from "../../../../../store/colors/color.selector";
import { ColorsProperties } from '../../../../../model/colorsProperties';
import { Observable, Subscription } from "rxjs";
import { ColorsService } from 'src/app/services/colors.service';

@Component({
  selector: 'app-simple',
  templateUrl: './simple.component.html',
  styleUrls: ['./simple.component.scss'],
})
export class SimpleComponent  {
  isLoading$: Observable<boolean> = this.store.pipe(select(selectColorIsLoading));
  colorForm: FormGroup;
  dynamicFormFields: ColorsProperties[];
  editorType: string = 'simple';
  subscription: Subscription;
  confirmSaveChanges: any;
  constructor(
    private store: Store,
    private fb: FormBuilder,
    private colorsService: ColorsService,
  ) { }

  ngOnInit(): void {
    this.confirmSaveChanges = document.querySelector('[data-confirm-changes]')
    this.subscription = this.store.pipe(select(selectColorSchemeData)).subscribe(data => {
      this.colorForm = this.fb.group({});
      if ( data instanceof Array) {
        this.dynamicFormFields = data;
        this.dynamicFormFields.forEach(formItem => {
          this.colorForm.addControl(formItem.variable.name, this.fb.control(formItem.variable.value));
        });
      }
    });
  }

  detectChanges(field: ColorsProperties, color: string) {
    this.colorForm.controls[field.variable.name].patchValue(color);
  }

  saveChanges(): void {

    this.store.dispatch(saveColorScheme(
      {colorSchemeData: this.colorForm.getRawValue()}
    ));

    this.colorsService.getColors().subscribe(data=>{
      this.store.dispatch(loadSchemePreviewResponse({colorPreview: data}))
    })

    this.store.dispatch(unsavedChangesSetDefault())

    // alert('Save changes successfully!');
  }

  ngOnDestroy(): void {
    this.subscription.unsubscribe();
  }

  getColorForm(){
    return this.colorForm.getRawValue()
  }
}
