{extends file="adminarea/template/includes/header.tpl"} 

{block name="template-heading"}
    {include file="adminarea/extensions/emailstyle/includes/breadcrumb.tpl"}
{/block}

{block name="template-tabs"}
    {include file="adminarea/extensions/emailstyle/includes/tabs.tpl"} 
{/block}

{block name="template-content"}
    <div class="block">
        <div class="block__body max-w-sm">
            <div class="section">
                <h2 class="section__title type-5">Extension Information</h2>
                <ul class="list list--info list--p-1x">
                    <li class="list__item">
                        <span class="list__label">Extension Version:</span>
                        <span class="list__value"><b>{$extension->getVersion()}</b></span>
                    </li>
                    <li class="list__item">
                        <span class="list__label">Extension Name:</span>
                        <span class="list__value"><b>{$extension->getName()}</b></span>
                    </li>
                    <li class="list__item">
                        <span class="list__label">Extension Description:</span>
                        <span class="list__value"><b>{$extension->getDescription()}</b></span>
                    </li>
                </ul>
            </div>
        </div>
        <div class="block__sidebar block__sidebar--lg">
            <div class="widget">
                <a class="widget__media has-overlay" href="#modalPreview-layers-preview" data-toggle="lu-modal">
                    <div class="widget__overlay">
                        <div class="widget__content">
                            <div class="msg">
                                <div class="msg__icon i-circled bg-white">
                                    <span class="i-c zmdi zmdi-zoom-in text-default"></span>
                                </div>
                                <div class="msg__body">
                                    <div class="msg__title type-7">Click to zoom in</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    {if $template->getPreview()}
                        <img src="{$template->getPreview()}">
                    {else}
                        <img src="{$helper->img('placeholders/placeholder-xs.svg')}">
                    {/if}
                </a>
            </div>
            <div id="modalPreview-layers-preview" class="modal modal--preview">
                <div class="modal__dialog">
                    <div class="modal__content">
                        <button class="close btn btn--xs btn--icon btn--link is-absolute" data-dismiss="lu-modal" aria-label="Close">
                            <i class="btn__icon zmdi zmdi-close"></i>
                        </button>
                        {if $template->getPreview()}
                            <img src="{$template->getPreview()}">
                        {else}
                            <img src="{$helper->img('placeholders/placeholder-xs.svg')}">
                        {/if}
                    </div>
                </div>
            </div>
        </div>
    </div>
{/block}























