class LiveEditor {
    constructor(instance) {
        console.log('Init');
        this.liveeditor = $(instance);
        this.cacheDOM();
        this.bindEvents();
        this.refs = {
            currentColor: '',
            currentScheme: '',
        };
        this.root = document.documentElement;
    }

    cacheDOM() {
        this.activeClass = 'is-active';
        this.colorSchemeItem = this.liveeditor.find('.radio.radio--color .radio__label');
        this.settingsIcon = this.liveeditor.find('.radio__actions .btn');
        this.activeCardName = this.liveeditor.find('#themeName');
        this.dataContentTitle = this.liveeditor.find('[data-content-title]');
        this.colorScheme = $('meta[name="colorScheme"]').attr('content');
        this.loadDataContainer = this.liveeditor.find('#loadData');
    }

    bindEvents() {
        // Customize (icon Click)
        this.settingsIcon.on('click.icon_element', (event) => {
            event.preventDefault();
            let inputScheme = $(event.currentTarget).closest('.radio--color').find('input');
            let value = inputScheme.val();
            let colorSchemeJson = JSON.parse(this.colorScheme);

            inputScheme.iCheck('check');

            this.paginationToggle('default', value);
            this.setStyle(colorSchemeJson[value], value);
            this.advancedSettingToggle('load');
        });

        // Pagination back
        this.dataContentTitle.on('click.pagination_back', (event) => {
            this.paginationToggle('back');
        });

        // Radio (icheck) change
        this.colorSchemeItem.on('click.radio_change', (event) => {
            let styleValue = $(event.currentTarget).find('input').val();
            let colorSchemeJson = JSON.parse(this.colorScheme);
            this.setStyle(colorSchemeJson[styleValue], styleValue);
        });
    }

    setStyle(scheme, value) {
        this.refs.currentColor = value;
        this.refs.currentScheme = scheme;
        for (let [key, value] of Object.entries(scheme)) {
            if (key !== 'args') {
                for (let [propertyName, propertyValue] of Object.entries(value)) {
                    if (propertyValue.gradient) {
                        let [direction, arg1, arg2, ...other] = propertyValue.gradient;
                        this.root.style.setProperty(propertyName, `linear-gradient(${direction} , ${arg1} , ${arg2})`);
                    } else if (propertyValue.variable) {
                        this.root.style.setProperty(propertyName, `var(${propertyValue.variable})`);
                    } else {
                        this.root.style.setProperty(propertyName, propertyValue.color);
                    }
                }
            }
        }
    }

    paginationToggle(type = 'default', value = null) {
        if (type === 'back') {
            this.activeCardName.html(``);
            this.activeCardName.removeClass(this.activeClass);
            this.dataContentTitle.next('i').fadeOut();
            this.dataContentTitle.addClass(this.activeClass);
            this.loadDataContainer.removeClass(this.activeClass);
        } else {
            this.activeCardName.html(LiveEditor.ucfirst(value));
            this.activeCardName.addClass(this.activeClass);
            this.dataContentTitle.next('i').show();
            this.dataContentTitle.removeClass(this.activeClass)
        }
    }

    advancedSettingToggle(type = 'toggle') {
        this.loadDataContainer.toggleClass(this.activeClass);
        if (type === 'load') {
            let renderTemplate = ``;
            let renderTemplateContent = ``;

            for (let [sectionName, sectionValue] of Object.entries(this.refs.currentScheme)) {
                this.renderField(sectionValue);

                if (sectionName !== 'args') {
                    renderTemplateContent += `
                        <div class="panel panel--accordion_color panel-accordion">
                            <div class="panel-heading collapsed" data-toggle="collapse" data-parent="#colorsCollapse" data-target="#${this.generateSlug(sectionName)}" aria-expanded="false">
                                <h4 class="panel-title"><i class="fas fa-chevron-down"></i><span class="panel-title__text">${sectionName}</span></h4>
                            </div>
                            <div id="${this.generateSlug(sectionName)}" class="panel-collapse collapse" aria-expanded="false">
                                <div class="panel-body p-t-0x">
                                <div class="rs-group disabled" data-group="${sectionName}">
                                    <div class="row">
                                        ${this.renderField(sectionValue)}
                                    </div>
                                </div>
                                </div>
                            </div>        
                        </div>`;
                }
            }
            renderTemplate += `<div id="colorsCollapse">${renderTemplateContent}</div>`;
            this.loadDataContainer.html(renderTemplate);
            this.colorPickerInitialization();
        }
    }

    colorPickerInitialization() {
        $("[data-rs-dropdown]").each((index, instance) => {
            new RsDropdown(instance , 'client');
        });
    }


    renderField(sectionValue) {
        let renderInputs = ``;
        let iteration = 0;
        let dynamicClass = `disabled hsl-field`;
        for (let [key, value] of Object.entries(sectionValue)) {

            if(value.args && value.args.hidden === 'colors'){
                console.log('hidden');
            }else{
                iteration++;
                if (iteration === 1) {
                    dynamicClass = `hsl-match`;
                } else {
                    dynamicClass = `disabled hsl-field`;
                }
                renderInputs += `
                    <div class="col-md-12">
                        <div class="color-chose__container ${dynamicClass}">
                            <label>${value.name}</label>
                            <div class="form-group form-group__custom">
                                <div class="dropdown-container" data-rs-dropdown="color-picker" data-color-hex="#fff">
                                    <div class="color-preview-container">
                                        <div class="opacity-pattern"></div>
                                        <div class="color-preview activeColor" style="background-color:${value.color}">
                                        </div>
                                    </div>
                                    <div class="drop-content">
                                        <div class="drop-input">
                                            <input value="${value.color}" class="rs-input form-control form-control--xs" name="config[${value.varName}]">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>`;
            }
        }

        return renderInputs;
    }

    // Helpers
    static ucfirst(string) {
        return string.charAt(0).toUpperCase() + string.slice(1);
    }

    generateSlug(string, delimiter = '_') {
        let replaceString;
        replaceString = string.replace(/ /g, `${delimiter}`);
        return replaceString;
    }
}

// Initialization class
new LiveEditor(document.getElementById('lagom-live-editor'));
