function initColorPickers(element) {
    var $element = $(element);
    var picker = Pickr.create({
        el: element,
        useAsButton: false,
        comparison: false,
        theme: 'monolith', // or 'monolith', or 'nano'
        default: element.value,
        swatches: [
            'rgba(244, 67, 54, 1)',
            'rgba(233, 30, 99, 0.95)',
            'rgba(156, 39, 176, 0.9)',
            'rgba(103, 58, 183, 0.85)',
            'rgba(63, 81, 181, 0.8)',
            'rgba(33, 150, 243, 0.75)',
            'rgba(3, 169, 244, 0.7)',
            'rgba(0, 188, 212, 0.7)',
            'rgba(0, 150, 136, 0.75)',
            'rgba(76, 175, 80, 0.8)',
            'rgba(139, 195, 74, 0.85)',
            'rgba(205, 220, 57, 0.9)',
            'rgba(255, 235, 59, 0.95)',
            'rgba(255, 193, 7, 1)'
        ],

        components: {
            // Main components
            preview: true,
            opacity: true,
            hue: true,

            // Input / output Options
            interaction: {
                hex: false,
                rgba: false,
                hsla: false,
                hsva: false,
                cmyk: false,
                input: true,
                clear: false,
                save: false
            }
        }
    });
    picker.on('swatchselect', (color, instance) => {
        element.value = instance.getColor().toHEXA().toString();
        $element.trigger('change');
    });

    picker.on('change', (color, instance) => {
        element.value = instance.getColor().toHEXA().toString();
        $element.trigger('change');
        console.log(element.value);


        /*if($(element).parent().find('.color-picker').length>1)
        {
            if($(element).next().length>0)
                background = 'linear-gradient( 90deg, ' + $(element).val() + ' 0%, ' + $(element).next().val() + ')';
            else
                background = 'linear-gradient( 90deg, ' + $(element).prev().val() + ' 0%, ' + $(element).val() + ')';
            $(element).parent().children(".color-preview").css(
                {
                    "background-image": background
                }
            );

        }else{
            $(element).prev(".color-preview").css(
                {
                    "background-image": "",
                    "background-color": instance.getColor().toHEXA().toString()
                }
            );
            if($element.attr('data-schemacolor'))
            {
                $("#"+$element.attr('data-schemacolor')).css(
                    {
                        "background-image": "",
                        "background-color": instance.getColor().toHEXA().toString()
                    }
                );
            }
        }*/
    });
}
