$(document).ready(function () {
    $('body').attr('id','whmcs');


    $(document).on('click', '[data-form="submit"]', function () {
        $('#themesConfig').find('form').submit();
    });
    $(document).on('click', ' [data-form]', function () {
        var formId = $(this).data('form');
        var type = $(this).attr('type');
        if (this.type == 'reset'){
            $(this.formId)[0].reset();
        }
        else{
            $(this.formId).submit();
        }
    });
    $(document).on('click', '[data-toggle="radio"]', function () {
        $('.app-main__body').find('input[type="radio"]').prop('checked', false);
        $('.app-main__body').find('.widget').removeClass('is-active');
        $(this).find('input[type="radio"]').prop('checked', true);
        $(this).addClass('is-active');
    });
    $('.multiselect').selectize({
        maxItems: 1000
    });
    $('#widgetsTemplates').selectize({
        create: true,
        sortField: 'text'
    });
    $('div#themesConfig').on('click', 'button[data-action="removeGroup"]', function () {
        console.log(2332);
        var groupId = $(this).attr('data-id');
        $('li[group-id="' + groupId + '"]').remove();
    });
    $('div#themesConfig').on('submit', 'form', function (e) {
        $('div.product-group').each(function () {
            var groupId = $(this).attr('group-id');
            if (groupId != 'newGroup') {
                if ($('input[name="config[groups][' + groupId + '][name]"]').val().length == 0) {
                    e.preventDefault();
                    alert('Name can\'t be empty!');
                    return false;
                }
                if ($('select[name="config[groups][' + groupId + '][groups][]"]')[0].selectize.getValue().length == 0) {
                    e.preventDefault();
                    alert('Please select at least one group!');
                    return false;
                }
            }
        });
    });

    $('div.product-group').each(function () {
        var groupId = $(this).attr('group-id');
        if (!$('input[name="config[groups][' + groupId + '][icon]"]').is(':checked')) {
            $('input[name="config[groups][' + groupId + '][icon]"]:first').attr('checked', true);
        }
    });
    $(document).on('click', '.tile',function (e) {
        e.preventDefault();
        $(this).find('input[type="radio"]').attr('checked', true);
        $(this).closest('.form-group').find('.tile').removeClass('is-checked');
        $(this).addClass('is-checked');
    });

    $('div#themesConfig').on('click', 'button[data-action="addGroup"]', function () {
        var html = $('div#emptyGroup ul').html();
        $('div#themesConfig div#products-groups-list ul#renderedGroups').append(replaceAll(html, 'newGroup', groupIndex));
        $('select[name="config[groups][' + groupIndex + '][groups]"]').selectize().attr('name', 'config[groups][' + groupIndex + '][groups][]');
        $('input[name="config[groups][' + groupIndex + '][icon]"]:first').attr('checked', true);
        groupIndex++;
    });
    if ($('#renderedGroups').lenght > 0){
        $('#renderedGroups').sortable({
            handle: ".handle",
            tolerance: 'pointer',
            cursor: "move",
            axis: "y",
            items: "> li",
            opacity: 0.5
        });
        $( "#renderedGroups" ).disableSelection();
    }

    if ($('div#themesConfig').length > 0) {
        if (!$('input[name="config[icon]"]').is(':checked')) {
            $('input[name="config[icon]"]:first').attr('checked', true);
        }
    }

    //notify
    if ($('[data-message]').length){

        var alert = $('[data-message]'),
            alerttitle = alert.data('title'),
            alertbody = alert.data('body'),
            alertstatus = alert.data('status');

        luNotification({
            title: alerttitle,
            body: alertbody,
            status: alertstatus,
            timeOut: 8000
        });
    }


    var pageName = $('#pageOptionsForm').data('page-name');
    var formType = $('input[name="page['+pageName+'][option]"]:checked').val();
    var formUrl = $('#pageOptionsForm').data('ajax-url');

    if (formUrl !== undefined){
        loadPageOptionSettings(formUrl, formType);
        $('#pageOptionsForm .widget--checkbox').on('click', function () {
            var checkbox = $(this).find('input[name="page['+pageName+'][option]"]').val();
             loadPageOptionSettings(formUrl, checkbox);
        });
    }

    $('.group-input-visibility').on('change', function () {
        var name = $(this).data('name');
        var groupInputs = $('.group_inputs_' + name);
        var groupsSelect = $('.group_select_' + name);
        if ($(this).prop("checked")) {
            groupInputs.show();
            var radioInputValue = $('input[type=radio][data-name="' + name + '"]:checked').val();
            if (radioInputValue === 'all') {
                groupsSelect.hide();
            } else {
                groupsSelect.show();
            }
            return;
        }
        groupInputs.hide();
    });

    $('input.group-radio[type=radio]').on('change', function () {
        var name = $(this).data('name');
        var groupsSelect = $('.group_select_' + name);
        if ($(this).val() === 'all') {
            groupsSelect.hide();
        } else {
            groupsSelect.show();
        }
    });

    $('.mode-display').change(function () {
        var themeSelectors = $('.theme-selectors');
        if ($(this).prop("checked")) {
            themeSelectors.css('display', 'flex');
            $('[data-mode-switcher]').attr('disabled', false);
        } else {
            themeSelectors.hide();
            $('[data-mode-switcher]').attr('disabled', true);
        }
    });

    $('.custom-hostname').change(function () {
        var customHostnameInputs = $('.custom-hostname-group');
        if ($(this).prop('checked')) {
            customHostnameInputs.css('display', 'block');
            $('[data-hostname-input]').attr('disabled', false);
        } else {
            customHostnameInputs.css('display', 'none');
            $('[data-hostname-input]').attr('disabled', true);
        }
    });

    $('#settingsForm').validate({
        errorClass : 'form-error',
    });

    $('[data-general-save]').on('click', function(e) {
        if ($('#settingsForm').valid()) {
            $('#settingsConfirmationModal').modal('show');
        }
    });
});

var groupIndex = 1000;
function escapeRegExp(str) {
    return str.replace(/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1");
}
function replaceAll(str, find, replace) {
    return str.replace(new RegExp(escapeRegExp(find), 'g'), replace);
}

function loadPageOptionSettings(formUrl, formType) {
    var type = formType;
    var ajaxUrl = formUrl;
    $('div#pageOptionSettings').html('');
    $.ajax({
        url: ajaxUrl,
        method: "post",
        data: {
            pageOption: type
        }
    }).done(function (response) {
        $('div#pageOptionSettings').html(response);
        $('#pageOptionSettings select').selectize({
            copyClassesToDropdown: false
        });
        $('#pageOptionSettings .multiselect').selectize({
            maxItems: 1000
        });

    });
}

