<?php
// Desenvolvido por Joel - WHMCS.RED || Modificações de search inteligente feita por Luciano - WHMCS.RED
// Pegar Session
use WHMCS\Session;
// Pegar Conexão com Banco de Dados
use WHMCS\Database\Capsule;
// Pegar Seções do Menu
use WHMCS\View\Menu\Item as MenuItem;
// Bloqueia o acesso direto ao arquivo
if (!defined("WHMCS")){
	die("Acesso restrito!");
}
// Monta o PIN
function montar_pin($id){
	$limite = 6;
	$montar = md5($id);
	$montar = preg_replace("/[^0-9]/", "", $montar);
	$quantidade_numeros = mb_strlen($montar);
	$contar = $limite - quantidade_numeros;
	$resultado = substr($montar, $limite, $contar);
	return $resultado;
}
// Página de Administrador
add_hook("AdminAreaClientSummaryPage", 1, function($vars){
	return "<p>&nbsp;&nbsp;Código PIN <span class=\"badge badge-secondary\">".montar_pin($vars["userid"])."</span></p>";
});
// Página do Cliente
add_hook('ClientAreaHomepagePanels', 1, function(MenuItem $primarySidebar) {
    $newMenu = $primarySidebar->addChild(
        'uniqueMenuItemName',
        array(
            'name' => 'Home',
            'label' => Lang::trans('PIN de Atendimento'),
            'uri' => 'https://www.souzahost.com.br/central/knowledgebase/44/PIN-de-Atendimento.html',
            'order' => 2,
            'icon' => 'far fa-life-ring',
        )
    );
    $newMenu->addChild(
        'uniqueSubMenuItemName',
        array(
            'name' => 'Item Name 1',
            //'label' => Lang::trans(montar_pin($_SESSION["uid"])),
            'label' => '<span style="font-size: 32px;line-height: 1;color: #1062fe;background: #e4effc;padding: 2px 8px;border-radius: 3px;font-weight: 400;">'. Lang::trans(montar_pin($_SESSION["uid"])) . '</span>',
            'uri' => 'https://www.souzahost.com.br/central/knowledgebase/44/PIN-de-Atendimento.html',
            'order' => 0,
            //'icon' => 'fas fa-lock',
        )
    );
     $newMenu->addChild(
        'unique-css-name-id1',
        array(
            'label' => '</strong>Forne&ccedil;a este c&oacute;digo, quando solicitado pele suporte.',
            'order' => 10,
        )
    );
});
// Adicionando função de pesquisa do PIN
add_hook("IntelligentSearch", 1, function($vars){
	$pesquisa = array();
	foreach (Capsule::table("tblclients")->get() as $clientes){
		$resultado = montar_pin($clientes->id);
		if($resultado == $vars["searchTerm"]){
			$idcliente = $clientes->id;
			$pin = $resultado;
		}
	}
	foreach (Capsule::table("tblclients")->WHERE("id", $idcliente)->get() as $cliente){
		$pesquisa[] = '
		<div class="searchresult">
			<a href="clientssummary.php?userid='.$cliente->id.'">
				<strong>'.$cliente->firstname.' '.$cliente->lastname.'</strong>
				(PIN: '.$pin.')<br />
				<span class="desc">' . $cliente->email . '</span>
			</a>
		</div>';
	}
	return $pesquisa;
});
// Adiciona string para os templates de email
add_hook("EmailPreSend", 1, function($vars){
	$pinstring = array();
	$pinstring["pin"] = montar_pin($vars['relid']);
	return $pinstring;
});