<?php
/*
*
* Order Notes To Ticket
* Created By Idan Ben-Ezra
*
* Copyrights @ Jetserver Web Hosting
* www.jetserver.net
*
* Hook version 1.0.1
*
**/

if (!defined("WHMCS"))
	die("This file cannot be accessed directly");

use Illuminate\Database\Capsule\Manager as Capsule;

/*********************
 Order Notes To Ticket Settings
*********************/
function jetserverOrderNotesToTicket_settings()
{
	global $_LANG, $CONFIG;

	$output['apiuser'] = 'edilsonlsouza'; // one of the admins username
	$output['ticket_subject'] = 'Notas para o pedido #%1$s'; // the ticket subject with the order number * use the $_LANG var to use system language file
	$output['ticket_pre_message'] = 'Esta é uma mesagem automática gerada pelo sistema de pedidos'; // the ticket start of the message * use the $_LANG var to use system language file
	$output['ticket_priority'] = 'Low'; // the ticket priority (Low, Medium or High) * default priority is Low 
	$output['ticket_department'] = '7'; // the department id you want to open the ticket to.
	$output['stop_email_to_client'] = false; // mark false if you want to send email notification to the client

	return $output;
}
/********************/

function jetserverOrderNotesToTicket_openTicket($vars)
{
	global $CONFIG;

	if($vars['OrderID'])
	{
		$settings = jetserverOrderNotesToTicket_settings();

		$order_details = Capsule::table('tblorders')
		->where('id', '=', $vars['OrderID'])
		->get();

		if(isset($order_details[0]) && trim($order_details[0]->notes) != '')
		{
			$api_settings = array(
				'clientid' 	=> $order_details[0]->userid,
				'noemail' 	=> $settings['stop_email_to_client'],
				'deptid'	=> $settings['ticket_department'],
				'subject' 	=> sprintf($settings['ticket_subject'], $vars['OrderNumber']),
				'message' 	=> ($settings['ticket_pre_message'] ? $settings['ticket_pre_message'] . "\n\n" : '') . $order_details[0]->notes,
				'priority' 	=> in_array($settings['ticket_priority'], array('Low','Medium','High')) ? $settings['ticket_priority'] : 'Low',
			);

			$result = localApi('openTicket', $api_settings, $settings['apiuser']);

			logModuleCall("Order Notes To Ticket", "Open Ticket", $api_settings, $result);
		}
	}
}

add_hook("AfterShoppingCartCheckout", 0, "jetserverOrderNotesToTicket_openTicket");

?>