{if file_exists("templates/$template/payment/overwrites/billing-address.tpl")}
    {include file="{$template}/payment/overwrites/billing-address.tpl"}  
{else}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {

        //Validação do campo CEP
        //$("#inputPostcode").mask("00000-000");

        function limpa_formulário_cep() {
            // Limpa valores do formulário de cep.
            $("#inputAddress1").val("");
            $("#inputAddress2").val("");
            $("#inputCity").val("");
            $("#stateselect").val("");
        }
        //Quando o campo cep perde o foco.
        $("#inputPostcode, #postcode").blur(function() {
            //Nova variável "cep" somente com dígitos.
            var cep = $(this).val().replace(/\D/g, "");
            //Verifica se campo cep possui valor informado.
            if (cep != "") {
            
                //Preenche os campos com "..." enquanto consulta webservice.
                $("#address1").val("...");
                $("#inputAddress2, #address2").val("...");
                $("#inputCity, #city").val("...");
                $("#stateselect").val("...");
                //Consulta o webservice viacep.com.br/
                $.getJSON("https://viacep.com.br/ws/" + cep + "/json/?callback=?", function(dados) {
                    if (!("erro" in dados)) {
                        //Atualiza os campos com os valores da consulta.
                        $("#inputAddress1, #address1").val(dados.logradouro + ", ");
                        $("#inputAddress2, #address2").val(dados.bairro);
                        $("#inputCity, #city").val(dados.localidade);
                        $("#stateselect").val(dados.uf);
                    } //end if.
                    else {
                        //CEP pesquisado não foi encontrado.
                        limpa_formulário_cep();
                        alert("CEP não encontrado.");
                    }
                });
               
            } //end if.
            else {
                //cep sem valor, limpa formulário.
                limpa_formulário_cep();
            }
        });
    });
    </script>
    <script>
        $(document).ready(function() {
            $('input[type="text"]').keyup(function() {
                //var val = $(this).val()
                //$(this).val(val.toUpperCase());
                
                var split = this.value.split(' ');
                for (var i = 0, len = split.length; i < len; i++) {
                    split[i] = split[i].charAt(0).toUpperCase() + split[i].slice(1).toLowerCase();
                }
                this.value = split.join(' ');
                return this;
                
            });
        });
    </script>
    <div class="form-group" id="billingAddressChoice">
        <h6 class="m-t-2x">{$LANG.billingAddress}</h6>
        <div class="radio">
            <label class="radio-inline icheck-label billing-contact-0">
                <input class="icheck-control" type="radio" name="billingcontact" value="0" {if $billingContact == 0} checked{/if} > <strong class="name">{$client->fullName}</strong>
                <span class="address1">{$client->address1}</span>, {if $client->address2}<span class="address2">{$client->address2}</span>,{/if} <span class="city">{$client->city}</span>, <span class="state">{$client->state}</span>, <span class="postcode">{$client->postcode}</span>, <span class="country">{$client->country}</span>
            </label>
        </div> 
        {foreach $client->contacts()->orderBy('firstname', 'asc')->orderBy('lastname', 'asc')->get() as $contact} 
            <div class="radio">
                <label class="radio-inline icheck-label billing-contact-{$contact->id}">
                    <input class="icheck-control" type="radio" name="billingcontact" value="{$contact->id}" {if $billingContact == $contact->id} checked{/if} > <strong class="name">{$contact->fullName}</strong>
                    <span class="address1">{$contact->address1}</span>, {if $contact->address2}<span class="address2">{$contact->address2}</span>,{/if} <span class="city">{$contact->city}</span>, <span class="state">{$contact->state}</span>, <span class="postcode">{$contact->postcode}</span>, <span class="country">{$contact->country}</span>
                </label>
            </div> 
        {/foreach} 
        <div class="radio">
            <label class="radio-inline icheck-label">
                <input class="icheck-control" type="radio" name="billingcontact" value="new" {if $billingContact === 'new'} checked{/if}> {$LANG.paymentMethodsManage.addNewBillingAddress} 
            </label>
        </div>
    </div>
    <div {if !$userDetailsValidationError && $billingcontact !== 'new'} style="display: none"{/if}>
        <div id="newBillingAddress">
            <div class="form-group cc-billing-address row">
                <div class="col-sm-4">
                    <label for="inputFirstName" class="control-label">{$LANG.clientareafirstname}</label>
                    <input type="text" name="firstname" id="inputFirstName" value="{$firstname}" class="form-control" />
                </div>
                <div class="col-sm-4">
                    <label for="inputLastName" class="control-label">{$LANG.clientarealastname}</label>
                    <input type="text" name="lastname" id="inputLastName" value="{$lastname}" class="form-control" />
                </div>
                <div class="col-sm-4">
                    <label for="inputPhone" class="control-label">{$LANG.clientareaphonenumber}</label>
                    <input type="text" name="phonenumber" id="inputPhone" value="{$phonenumber}" class="form-control" />
                </div>
            </div>
        
            <div class="form-group cc-billing-address row">
                <div class="col-sm-4">
                    <label for="inputPostcode" class="control-label">{$LANG.clientareapostcode}</label>
                    <input type="text" name="postcode" id="inputPostcode" value="{$postcode}" class="form-control" />
                </div>
                <div class="col-sm-8">
                    <label for="inputAddress1" class="control-label">{$LANG.clientareaaddress1}</label>
                    <input type="text" name="address1" id="inputAddress1" value="{$address1}" class="form-control" />
                </div>
            </div>
            <div class="form-group cc-billing-address row">
                <div class="col-sm-4">
                    <label for="inputAddress2" class="control-label">{$LANG.clientareaaddress2}</label>
                    <input type="text" name="address2" id="inputAddress2" value="{$address2}" class="form-control" />
                </div>
                <div class="col-sm-4">
                    <label for="inputCity" class="control-label">{$LANG.clientareacity}</label>
                    <input type="text" name="city" id="inputCity" value="{$city}" class="form-control" />
                </div>
                <div class="col-sm-2">
                    <label for="inputState" class="control-label">{$LANG.clientareastate}</label>
                    <input type="text" name="state" id="inputState" value="{$state}" class="form-control" />
                </div>
                <div class="col-sm-2">
                    <label for="inputCountry" class="control-label">{$LANG.clientareacountry}</label> 
                    {$countriesdropdown|replace:"select-inline":""} 
                </div>
            </div>
        </div>
    </div>    
{/if}    