<?php

/*
 * ******************************************
   RS Studio Template Hook
   1. Namespaces
   2. Layout Helpers
   3. Template Classes
   4. Order Redirection
   5. Page Header Type
   6. Market Connect Banners
   7. Client Area Home Panels
   8. Module Classes Helper
   9. Site Helper
   10. Light/Dark Mode switcher
   11. Product Details - Get Product group ID
   12. Remove addon from cart + select product period
 * ******************************************
 */

/*
 * ******************************************
   1. Namespaces
 * ******************************************
 */

use RSThemes\Models\Icons;
use RSThemes\Models\Page;
use RSThemes\Processors\MenuProcessor;
use RSThemes\Processors\SidebarProcessor;
use WHMCS\Product\Group as ProductGroup;
use WHMCS\Database\Capsule;
use WHMCS\MarketConnect\Service;
use WHMCS\View\Menu\Item as MenuItem;

use WHMCS\CustomField;
use WHMCS\CustomField\CustomFieldValue;
use WHMCS\User\Client;

/*
 * ******************************************
   2. Layout Helpers
 * ******************************************
 */

add_hook('ClientAreaPage', 2, function($vars) {
    $actionFile = $vars['templatefile'];
    $configFilePath = realpath(dirname(__FILE__)) . DS .'..'.DS. 'config' . DS . 'layouthelpers.php';
    $configFilePathCustom = realpath(dirname(__FILE__)) . DS .'..'.DS. 'config' . DS . 'layouthelpers-custom.php';

    /* DEFAULT */
    if (file_exists($configFilePath)) {
        $config = require_once $configFilePath;
        if (isset($config[$actionFile])) {
            if (count($config[$actionFile]) == 1) {
                return [
                    'ignoreSidebars' => $config[$actionFile][0],
                    'ignoreHeader' => false,
                    'forceSidebar' => false,
                    'ignoreMainBody' => false,
                    'sidebarOnRight' => false,
                ];
            } else if (count($config[$actionFile]) == 2) {
                return [
                    'ignoreSidebars' => $config[$actionFile][0],
                    'ignoreHeader' => $config[$actionFile][1],
                    'forceSidebar' => false,
                    'ignoreMainBody' => false,
                    'sidebarOnRight' => false,
                ];
            }
            else if (count($config[$actionFile]) == 3) {
                return [
                    'ignoreSidebars' => $config[$actionFile][0],
                    'ignoreHeader' => $config[$actionFile][1],
                    'forceSidebar' => $config[$actionFile][2],
                    'ignoreMainBody' => false,
                    'sidebarOnRight' => false,
                ];
            }
            else if (count($config[$actionFile]) == 4) {
                return [
                    'ignoreSidebars' => $config[$actionFile][0],
                    'ignoreHeader' => $config[$actionFile][1],
                    'forceSidebar' => $config[$actionFile][2],
                    'ignoreMainBody' => $config[$actionFile][3],
                    'sidebarOnRight' => false,
                ];
            }
            else if (count($config[$actionFile]) == 5) {
                return [
                    'ignoreSidebars' => $config[$actionFile][0],
                    'ignoreHeader' => $config[$actionFile][1],
                    'forceSidebar' => $config[$actionFile][2],
                    'ignoreMainBody' => $config[$actionFile][3],
                    'sidebarOnRight' => $config[$actionFile][4],
                ];
            }
            else{
                return [
                    'ignoreSidebars' => false,
                    'ignoreHeader' => false,
                    'forceSidebar' => false,
                    'ignoreMainBody' => false,
                    'sidebarOnRight' => false,
                ];
            }
        } else {
            return [
                'ignoreSidebars' => false,
                'ignoreHeader' => false,
                'forceSidebar' => false,
                'ignoreMainBody' => false,
                'sidebarOnRight' => false,
            ];
        }
    }

    /* CUSTOM */
    if (file_exists($configFilePathCustom)) {
        $config = require_once $configFilePathCustom;
        if (isset($config[$actionFile])) {
            if (count($config[$actionFile]) == 1) {
                return [
                    'ignoreSidebars' => $config[$actionFile][0],
                    'ignoreHeader' => false,
                    'forceSidebar' => false,
                    'ignoreMainBody' => false,
                    'sidebarOnRight' => false,
                ];
            } else if (count($config[$actionFile]) == 2) {
                return [
                    'ignoreSidebars' => $config[$actionFile][0],
                    'ignoreHeader' => $config[$actionFile][1],
                    'forceSidebar' => false,
                    'ignoreMainBody' => false,
                    'sidebarOnRight' => false,
                ];
            }
            else if (count($config[$actionFile]) == 3) {
                return [
                    'ignoreSidebars' => $config[$actionFile][0],
                    'ignoreHeader' => $config[$actionFile][1],
                    'forceSidebar' => $config[$actionFile][2],
                    'ignoreMainBody' => false,
                    'sidebarOnRight' => false,
                ];
            }
            else if (count($config[$actionFile]) == 4) {
                return [
                    'ignoreSidebars' => $config[$actionFile][0],
                    'ignoreHeader' => $config[$actionFile][1],
                    'forceSidebar' => $config[$actionFile][2],
                    'ignoreMainBody' => $config[$actionFile][3],
                    'sidebarOnRight' => false,
                ];
            }
            else if (count($config[$actionFile]) == 5) {
                return [
                    'ignoreSidebars' => $config[$actionFile][0],
                    'ignoreHeader' => $config[$actionFile][1],
                    'forceSidebar' => $config[$actionFile][2],
                    'ignoreMainBody' => $config[$actionFile][3],
                    'sidebarOnRight' => $config[$actionFile][4],
                ];
            }
        }
    }
});

/*
 * ******************************************
   3. Template Classes
 * ******************************************
 */

add_hook('ClientAreaPage', 2, function($vars) {
    $actionFile = $vars['templatefile'];
    $configFilePath = realpath(dirname(__FILE__)) . DS .'..'.DS. 'config' . DS . 'templateclasses.php';
    $configFilePathCustom = realpath(dirname(__FILE__)) . DS .'..'.DS. 'config' . DS . 'templateclasses-custom.php';
    
    /* DEFAULT */
    if (file_exists($configFilePath)) {
        $config = require_once $configFilePath;
        if (isset($config[$actionFile])) {
            if (count($config[$actionFile]) == 1) {
                return [
                    'appMainBodyClasses' => $config[$actionFile][0],
                    'bodyClasses' => false,
                    'mainContentClasses' => false,
                ];
            } else if (count($config[$actionFile]) == 2) {
                return [
                    'appMainBodyClasses' => $config[$actionFile][0],
                    'bodyClasses' => $config[$actionFile][1],
                    'mainContentClasses' => false,
                ];
            }
            else if (count($config[$actionFile]) == 3) {
                return [
                    'appMainBodyClasses' => $config[$actionFile][0],
                    'bodyClasses' => $config[$actionFile][1],
                    'mainContentClasses' => $config[$actionFile][2],
                ];
            }            
        }
    }

    /* CUSTOM */
    if (file_exists($configFilePathCustom)) {
        $config = require_once $configFilePathCustom;
        if (isset($config[$actionFile])) {
            if (count($config[$actionFile]) == 1) {
                return [
                    'appMainBodyClasses' => $config[$actionFile][0],
                    'bodyClasses' => false,
                    'mainContentClasses' => false,
                ];
            } else if (count($config[$actionFile]) == 2) {
                return [
                    'appMainBodyClasses' => $config[$actionFile][0],
                    'bodyClasses' => $config[$actionFile][1],
                    'mainContentClasses' => false,
                ];
            }
            else if (count($config[$actionFile]) == 3) {
                return [
                    'appMainBodyClasses' => $config[$actionFile][0],
                    'bodyClasses' => $config[$actionFile][1],
                    'mainContentClasses' => $config[$actionFile][2],
                ];
            }
        }
    }
});

/*
 * ****************************************************************
   4. Order Redirection - Don't show view cart page as separate
 * ****************************************************************
 */

add_hook('ClientAreaPage', -100000000, function($vars) {
    if (isset($vars['inShoppingCart'])) {
        if (isset($_GET['a']) && $_GET['a'] == 'view') {
            $url = 'cart.php?a=checkout';
            header("Location: $url");
            die();
        }
    }
});

/*
 * ******************************************
   5. Page Header Type
 * ******************************************
 */

add_hook('ClientAreaPage', 2, function($vars) {
    $actionFile = $vars['templatefile'];
    $configFilePath = realpath(dirname(__FILE__)) . DS .'..'.DS. 'config' . DS . 'pageheader.php';
    $configFilePathCustom = realpath(dirname(__FILE__)) . DS .'..'.DS. 'config' . DS . 'pageheader-custom.php';

    /* DEFAULT */
    if (file_exists($configFilePath)) {
        $config = require_once $configFilePath;
        if (isset($config[$actionFile])) {
            if (count($config[$actionFile]) == 1) {
                return [
                    'RSheadersearch' => $config[$actionFile][0],
                    'RSheadercenter' => false,
                ];
            } else if (count($config[$actionFile]) == 2) {
                return [
                    'RSheadersearch' => $config[$actionFile][0],
                    'RSheadercenter' => $config[$actionFile][1],
                ];
            }
            else{
                return [
                    'RSheadersearch' => false,
                    'RSheadercenter' => false,
                ];
            }
        } else {
            return [
                'RSheadersearch' => false,
                'RSheadercenter' => false,
            ];
        }
    }

    /* CUSTOM */
    if (file_exists($configFilePathCustom)) {
        $config = require_once $configFilePathCustom;
        if (isset($config[$actionFile])) {
            if (count($config[$actionFile]) == 1) {
                return [
                    'RSheadersearch' => $config[$actionFile][0],
                    'RSheadercenter' => false,
                ];
            } else if (count($config[$actionFile]) == 2) {
                return [
                    'RSheadersearch' => $config[$actionFile][0],
                    'RSheadercenter' => $config[$actionFile][1],
                ];
            } 
        }
    }
});

/*
 * ******************************************
   6. Market Connect Banners
 * ******************************************
 */

if(isset($_SESSION['uid']) && basename($_SERVER['SCRIPT_NAME']) !== 'logout.php' && strpos($_SERVER['QUERY_STRING'], 'verificationId') === false){
    $rsServicesHooks = [
        'ClientAreaPage',
        'ClientAreaPageProductsServices',
        'ClientAreaHomepage',
        'ClientAreaPageProductDetails'
    ];
}
else{
    $rsServicesHooks = [
        'ClientAreaPageProductsServices',
        'ClientAreaHomepage',
        'ClientAreaPageProductDetails'
    ];
}

foreach ($rsServicesHooks as $rsServicesHook) {
    add_hook($rsServicesHook, -2, function($var = NULL) {
        return [
            'RSMarketConnectServices' => Service::active()->get()->toArray()
        ];
    });
}

/*
 * ******************************************
   7. Client Area Home Panels
 * ******************************************
 */

use WHMCS\View\Menu\Item;
add_hook('ClientAreaHomepagePanels', 1, function (Item $homePagePanels) {

    $recentTicketsPanel = $homePagePanels->getChild('Recent Support Tickets');
    $activeServicesPanel = $homePagePanels->getChild('Active Products/Services');
    $affiliatePanel = $homePagePanels->getChild('Affiliate Program');
    $recentNewsPanel = $homePagePanels->getChild('Recent News');

    if (!is_null($recentTicketsPanel)) {
        $recentTicketsPanel->setExtras(
            []
        );
    }
    if (!is_null($activeServicesPanel)) {
        GLOBAL $smarty;
        $vars = $smarty->getTemplateVars();
        $user = $vars['client'];
        $client = Client::find($user->id);

        $clientServices = $client->services()->whereIn("domainstatus", ["Active", "Suspended"])->orderBy("domainstatus", "asc")->orderBy("id", "desc")->limit(101)->get();
        $activeServices = $activeServicesPanel->getChildren();

        foreach($activeServices as $i=>$activeService){
            $url = $activeService->getUri();
            $id = explode("id=",$url);
            $id = intval($id[1]);
            foreach ($clientServices as $service) {
                if ($service->id == $id){
                    $nextDue = $service->nextduedate;
                    $nexDueTS = strtotime($service->nextduedate);
                    $billingcycle = $service->billingcycle;
                    if ($billingcycle == "Monthly"){
                        $nexDueTSConv = strtotime( "-3 day", strtotime($service->nextduedate));
                    }
                    else{
                        $nexDueTSConv = strtotime( "-30 day", strtotime($service->nextduedate));
                    }
                    $today = strtotime(date("Y-m-d",time()));
                    define('DAY', 60*60*24, true);
                    $days = floor(($nexDueTS - $today) / (DAY));
                    if (($nexDueTSConv <= $today) && ($nextDue != '0000-00-00')){
                        if ($days < 0){
                            $days = $days*(-1);
                            $activeServicesPanel->getChild($i)->setBadge(Lang::trans('domainRenewal.expiredDaysAgo', [":days" => $days]).'<i class="ls ls-exclamation-circle"></i>');
                        }
                        else{
                            $activeServicesPanel->getChild($i)->setBadge(Lang::trans('domainRenewal.expiringIn', [":days" => $days]).'<i class="ls ls-exclamation-circle"></i>');
                        }  
                    }
                }
            }
        }
        $activeServicesPanel->setExtras(
            []
        );
    }
    if (!is_null($affiliatePanel)) {
        $affiliatePanel->setExtras(
            []
        );
    }
    if (!is_null($recentNewsPanel)) {
        $recentNewsPanel->setExtras(
            []
        );
    }
});

/*
 * ******************************************
   8. Module Classes Helper
 * ******************************************
 */

add_hook('ClientAreaPage', 2, function($vars) {
    if (isset($_GET['m'])){
        if ($_GET['m'] == "DomainOrdersExtended"){
            return [
                'pageModuleName' => 'searchdomains'
            ];
        }
        else if ($_GET['m'] == "DNSManager2"){
            return [
                'pageModuleName' => 'dnsmanager'
            ];
        }
        else{
            $moduleName = strtolower($_GET['m']);
            $moduleName = str_replace(' ', '', $moduleName);
            return [
                'pageModuleName' => $moduleName
            ];
        }
    }
});

/*
 * ******************************************
   9. Site Helper
 * ******************************************
 */

add_hook('ClientAreaPage', 2, function($vars) {
    $actionFile = $vars['templatefile'];
    $configFilePath = realpath(dirname(__FILE__)) . DS .'..'.DS. 'config' . DS . 'site.php';
    $configFilePathCustom = realpath(dirname(__FILE__)) . DS .'..'.DS. 'config' . DS . 'site-custom.php';

    /* DEFAULT */
    if (file_exists($configFilePath)) {
        $config = require_once $configFilePath;
        if (isset($config[$actionFile])) {
            if (count($config[$actionFile]) == 1) {
                return [
                    'isSite' => $config[$actionFile][0]
                ];
            }
            else{
                return [
                    'isSite' => false
                ];
            }
        } else {
            return [
                'isSite' => false
            ];
        }
    }

    /* CUSTOM */
    if (file_exists($configFilePathCustom)) {
        $config = require_once $configFilePathCustom;
        if (isset($config[$actionFile])) {
            if (count($config[$actionFile]) == 1) {
                return [
                    'isSite' => $config[$actionFile][0]
                ];
            }
        } 
    }
});

/*
 * ******************************************
   10. Light/Dark Mode switcher
 * ******************************************
 */

add_hook('ClientAreaPage', 1, function($vars) {
    $displayModeSwitcher = \RSThemes\Models\Settings::where('setting', 'display_mode_switcher')->first();
    $displayModeSwitcherEnabled = (bool) $displayModeSwitcher->value;
    $darkModeEnabledValue = false; //default value
    if ($displayModeSwitcherEnabled) {
        if (!$vars['loggedin']) {  //unlogged user
            if (isset($_COOKIE['dark_mode_enabled'])) { //get cookie value
                $darkModeEnabledValue = $_COOKIE['dark_mode_enabled'];
            }
        } else { //logged user
            if (isset($_COOKIE['dark_mode_enabled'])) {
                $darkModeEnabledValue = $_COOKIE['dark_mode_enabled'];
            } else {
                $clientId = '';
                if (isset($vars['client'])) {
                    $clientId = $vars['client']->id; //user has not clients
                } else {
                    $loggedInUser = $vars['loggedinUser'];
                    foreach ($loggedInUser->getClientIds() as $id) {
                        $client = Client::find($id);
                        if ($client->email == $loggedInUser->email) { //account selection
                            $clientId = $client->id;
                        }
                    }
                }
                $darkModeCustomField = CustomField::where('fieldname', 'Dark Mode Enabled')
                    ->where('type', 'client')
                    ->where('fieldtype', 'tickbox')
                    ->where('relid', 0)
                    ->first();
                $darkModeCustomFieldValue = CustomFieldValue::where('fieldid', $darkModeCustomField->id)
                    ->where('relid', $clientId)
                    ->first();
                if (!is_null($darkModeCustomFieldValue) && $darkModeCustomFieldValue->value == 'on') { //if user has custom field and value is true
                    $darkModeEnabledValue = true;
                }
            }
        }
    }
    return [
        'mode_switcher' => [
            'enabled' => $displayModeSwitcherEnabled,
            'value' => $darkModeEnabledValue
        ]
    ];
});

add_hook('ClientAreaRegister', 1, function($vars) {
    $darkModeEnabledValue = false;
    if (isset($_COOKIE['dark_mode_enabled'])) {
        $darkModeEnabledValue = $_COOKIE['dark_mode_enabled'];
    }
    $darkModeCustomField = CustomField::where('fieldname', 'Dark Mode Enabled')
        ->where('type', 'client')
        ->where('fieldtype', 'tickbox')
        ->where('relid', 0)
        ->first();
    if (!is_null($darkModeCustomField)) {
        $darkModeCustomFieldValue = new CustomFieldValue(); //custom field value creation
        $darkModeCustomFieldValue->fieldid = $darkModeCustomField->id;
        $darkModeCustomFieldValue->relid = $vars['client_id'];
        $darkModeCustomFieldValue->value = $darkModeEnabledValue ? 'on' : '';
        $darkModeCustomFieldValue->created_at = new DateTime();
        $darkModeCustomFieldValue->updated_at = new DateTime();
        $darkModeCustomFieldValue->save();
    }
});

add_hook('UserLogin', 1, function($vars) {
    $user = $vars['user'];
    $clientExists = false;
    foreach ($user->getClientIds() as $id) {
        $client = Client::find($id);
        if ($client->email == $user->email) {
            $clientId = $client->id;
            $clientExists = true; // orderform account creation login hook is triggered, no client in db
        }
    }
    $darkModeEnabledValue = false;
    if (isset($_COOKIE['dark_mode_enabled'])) {
        $darkModeEnabledValue = $_COOKIE['dark_mode_enabled'];
    }
    $darkModeCustomField = CustomField::where('fieldname', 'Dark Mode Enabled')
        ->where('type', 'client')
        ->where('fieldtype', 'tickbox')
        ->where('relid', 0)
        ->first();
    if (!is_null($darkModeCustomField) && $clientExists) {
        $darkModeCustomFieldValue = new CustomFieldValue(); //custom field value creation
        $darkModeCustomFieldValue->fieldid = $darkModeCustomField->id;
        $darkModeCustomFieldValue->relid = $clientId;
        $darkModeCustomFieldValue->value = $darkModeEnabledValue ? 'on' : '';
        $darkModeCustomFieldValue->created_at = new DateTime();
        $darkModeCustomFieldValue->updated_at = new DateTime();
        $darkModeCustomFieldValue->save();
    }
});

/*
 * ******************************************
   11. Product Details - Get Product group ID
 * ******************************************
 */

add_hook('ClientAreaPageProductDetails', 2, function($vars) {
    $groupId = ProductGroup::where('name', $vars['groupname'])->value('id');
    return [
        'groupId' => $groupId
    ];
});


add_hook('ClientAreaPage', 1, function($vars) {
    $uri = $_SERVER['REQUEST_URI'];

    $uri = strstr($s, '?rs', true) ?: $uri;
    $uri = strstr($s, '&rs', true) ?: $uri;
  
    return [
        'currentUrl' => $uri,
        'hideServerAlert' => $_SESSION['hide_server_alert']
    ];
});

/*
 * ******************************************
   12. Remove addon from cart + select product period
 * ******************************************
*/

add_hook('ClientAreaPage', 1, function($vars) {
    
    if ($vars['templatefile'] == "viewcart"){

        $currency = getCurrency(WHMCS\Session::get("uid"), WHMCS\Session::get("currency"));
        
        if(App::getFromRequest("removeAddon"))
        {   
            if (App::getFromRequest("pt") == "products" && $_SESSION['cart']['products'][App::getFromRequest("pi")]){
                unset($_SESSION['cart']['products'][App::getFromRequest("pi")]['addons'][App::getFromRequest("ai")]);
            }
            if (App::getFromRequest("pt") == "domains" && $_SESSION['cart']['domains'][App::getFromRequest("pi")]){
                $_SESSION['cart']['domains'][App::getFromRequest("pi")][App::getFromRequest("ai")] = NULL;
            }
            if (App::getFromRequest("pt") == "renewals" && $_SESSION['cart']['rewals'][App::getFromRequest("pi")]){
                $_SESSION['cart']['rewals'][App::getFromRequest("pi")][App::getFromRequest("ai")] = NULL;
            }

            $response = new WHMCS\Http\JsonResponse();
            $response->setData(calcCartTotals(null, false, $currency));
            $response->send();
            WHMCS\Terminus::getInstance()->doExit();
        }

        elseif(App::getFromRequest("selectProductPeriod") && App::getFromRequest("pi") >= 0 && App::getFromRequest("pc") )
        {
            if($_SESSION['cart']['products'][App::getFromRequest("pi")])
            {
                $_SESSION['cart']['products'][App::getFromRequest("pi")]['billingcycle'] = App::getFromRequest("pc");
            }
            
            $response = new WHMCS\Http\JsonResponse();
            $response->setData(calcCartTotals(null, false, $currency));
            $response->send();
            WHMCS\Terminus::getInstance()->doExit();
        }
        $cycles = [];
        foreach($vars['products'] as $i => $p)
        {
            $product = \WHMCS\Product\Product::find($vars['products'][$i]['pid']);
            $cycles[$i] = $product->pricing()->allAvailableCycles();
        }
        return [ 'allAvailableCycles' => $cycles];
    }
});