<?php
// Version v1.0

if (!defined("WHMCS")) {
    die("Fatal Error");
}

use WHMCS\Database\Capsule;

function sonicpanel_ConfigOptions() {

// Fetch Active sonicpanel Server
try {
foreach (Capsule::table('tblservers')->where('type', '=', 'sonicpanel') ->where('active', '=', 1) ->get() as $srv) {
    $hostname = $srv->hostname;
    $server_p = decrypt($srv->password);
    $serveruser = $srv->username;
}
} catch (\Exception $e) {
    throw new Exception("Unable to connect to WHMCS Database or there is no active SonicPanel server set. Click on the sonicpanel server name under the servers list to activate it if you didnt activate the server. {$e->getMessage()}");
}
// Fetch Active sonicpanel Server



// Check Hostname


// Get Account Packages from the sonicpanel Server
$sonicpanelserver = "https://$hostname/api/sonic_api.php";
$ch = curl_init();
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, "cmd=packs&owner=$serveruser&key=$server_p");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_URL, $sonicpanelserver);
$retval = curl_exec($ch);
$getresponse = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if (curl_error($ch)) {$error = "Unable to connect to the SonicPanel server: <b>$hostname</b> on port 443 by SSL/HTTPS. <br><br> Make sure that you have entered your SonicPanel server hostname correctly in the WHMCS server settings for the server.";}
if ($getresponse == 401) {$error = "<b>SonicPanel Server Invalid API Key!</b> Check your username and API Key(Password) in server settings for this active server <b>$hostname</b>. You need to enter the API key, not your root password. See the instructions <a href='https://kb.sonicpanel.com/article.php?id=15' target='_blank'>https://kb.sonicpanel.com/article.php?id=15</a> <br><br> Multiple login failures in 1 hour will get your website IP banned for 1 hour. You can disable the brute force ban protection from your SonicPanel root >> Services link on the left menu. Make sure to reactivate it after you have completed the configurations. It is an important security.";}
if ($getresponse == 403) {$error = "<b>SonicPanel Server Invalid API Key!</b> Check your username and API Key(Password) in server settings for this active server <b>$hostname</b>. You need to enter the API key, not your root password. See the instructions https://kb.sonicpanel.com/article.php?id=15";}
if ($getresponse == 500) {$error = "Multiple API Login Failures Detected: Your website IP is blocked for 1 hour to login. Read the limits and security in SonicPanel under the Billing and API page. Unban the IP instructions https://kb.sonicpanel.com/article.php?id=24";}
curl_close($ch);
// Get Account Packages from the sonicpanel Server

if ($getresponse != 200) {
$configarraysonic = array("" => array("Description" => "<div class='errorbox'><strong><span class='title'>Module Command Error</span></strong><br><br>$error</div>"),);
return $configarraysonic;
}

if ($getresponse == 200) {
$configarraysonic = array(
  "Radio Account Packages" => array( "Type" => "dropdown", "Options" => "$retval","Description" => "Create packages in SonicPanel to use here. SonicPanel >> Left Menu >> Add Radio Package"),
);
return $configarraysonic;
}

} // Config



function sonicpanel_CreateAccount($params) {

    // Get Information
    $package = $params["configoption1"];
    $orderid = $params["serviceid"];
    $hostname = $params["serverhostname"];
    $serverp = $params["serverpassword"];
    $serveruser = $params["serverusername"];
    $radiousername = $params["username"];
    // Get The Client Information
    $client_email = $params["clientsdetails"]["email"];

    $chars = "ABCDEFGHJKMNPQRSTUVWXYZ23456789";
    srand((double)microtime()*1000000);
    $i = 0;
    $pass = '' ;
    while ($i <= 20) {
    $num = rand() % 45;
    $tmp = substr($chars, $num, 1);
    $pass = $pass . $tmp;
    $i++;
    }

$sonicpanelserver = "https://$hostname/api/sonic_api.php";
$data = "cmd=create&client_email=$client_email&rad_username=$radiousername&panel_pass=$pass&owner=$serveruser&package=$package&send_email=yes&key=$serverp";
$ch = curl_init();
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 59);
curl_setopt($ch, CURLOPT_URL, $sonicpanelserver);
$retval = curl_exec($ch);
$getresponse = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if (curl_error($ch)) {throw new Exception("Unable to connect to the SonicPanel server: $hostname on port 443 by SSL/HTTPS. Make sure that you have entered your SonicPanel server hostname correctly in the WHMCS server settings for the server.");}
if ($getresponse == 401) {throw new Exception("<b>SonicPanel Server Invalid API Key!</b> Check your username and API Key(Password) in server settings for this active server $hostname. You need to enter the API key, not your root password. See the instructions https://kb.sonicpanel.com/article.php?id=15 Multiple login failures in 1 hour will get your website IP banned for 1 hour. You can disable the brute force ban protection from your SonicPanel root >> Services link on the left menu. Make sure to reactivate it after you have completed the configurations. It is an important security.");}
if ($getresponse == 403) {throw new Exception("<b>SonicPanel Server Invalid API Key!</b> Check your username and API Key(Password) in server settings for this active server $hostname. You need to enter the API key, not your root password. See the instructions https://kb.sonicpanel.com/article.php?id=15"); }
if ($getresponse == 500) {throw new Exception("Multiple API Login Failures Detected: Your website IP is blocked for 1 hour to login. Read the limits and security in SonicPanel under the Billing and API page. Unban the IP instructions https://kb.sonicpanel.com/article.php?id=24");}
curl_close($ch);

    $obj = json_decode($retval);
    $return = $obj->{'result'};
    $radiousername = $obj->{'username'};

	if ($return=="complete") {
	// Update WHMCS Database
	   $encryptedPassword = encrypt($pass);
       $updatehosting = Capsule::table('tblhosting')->where('id', $params["accountid"])->update(['username' => $radiousername, 'dedicatedip' => $hostname, 'password' => $encryptedPassword]);
    // Update WHMCS Database
	$result = "success";
	} else {
	$result = $return;
	}
	return $result;
}


function sonicpanel_TerminateAccount($params) {

    // Details
    $hostname = $params["serverhostname"];
    $rad_username= $params["username"];
    $serverp = $params["serverpassword"];
    $serveruser = $params["serverusername"];

$sonicpanelserver = "https://$hostname/api/sonic_api.php";
$data = "cmd=terminate&rad_username=$rad_username&key=$serverp&owner=$serveruser";
$ch = curl_init();
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 59);
curl_setopt($ch, CURLOPT_URL, $sonicpanelserver);
$retval = curl_exec($ch);
$getresponse = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if (curl_error($ch)) {throw new Exception("Unable to connect to the SonicPanel server: <b>$hostname</b> on port 443 by SSL/HTTPS. <br><br> Make sure that you have entered your SonicPanel server hostname correctly in the WHMCS server settings for the server.");}
if ($getresponse == 401) {throw new Exception("<b>SonicPanel Server Invalid API Key!</b> Check your username and API Key(Password) in server settings for this active server <b>$hostname</b>. You need to enter the API key, not your root password. See the instructions <a href='https://kb.sonicpanel.com/article.php?id=15' target='_blank'>https://kb.sonicpanel.com/article.php?id=15</a> <br><br> Multiple login failures in 1 hour will get your website IP banned for 1 hour. You can disable the brute force ban protection from your SonicPanel root >> Services link on the left menu. Make sure to reactivate it after you have completed the configurations. It is an important security.");}
if ($getresponse == 403) {throw new Exception("<b>SonicPanel Server Invalid API Key!</b> Check your username and API Key(Password) in server settings for this active server <b>$hostname</b>. You need to enter the API key, not your root password. See the instructions https://kb.sonicpanel.com/article.php?id=15"); }
if ($getresponse == 500) {throw new Exception("Multiple API Login Failures Detected: Your website IP is blocked for 1 hour to login. Read the limits and security in SonicPanel under the Billing and API page. Unban the IP instructions https://kb.sonicpanel.com/article.php?id=24");}
curl_close($ch);

    $obj = json_decode($retval);
    $return = $obj->{'result'};

	if ($return=="complete") {
		$result = "success";
	} else {
		$result = $return;
	}
	return $result;
}

function sonicpanel_SuspendAccount($params) {

    // Details
    $hostname = $params["serverhostname"];
    $rad_username= $params["username"];
    $serverp = $params["serverpassword"];
    $serveruser = $params["serverusername"];

$sonicpanelserver = "https://$hostname/api/sonic_api.php";
$data = "cmd=suspend&rad_username=$rad_username&key=$serverp&owner=$serveruser";
$ch = curl_init();
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 59);
curl_setopt($ch, CURLOPT_URL, $sonicpanelserver);
$retval = curl_exec($ch);
$getresponse = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if (curl_error($ch)) {throw new Exception("Unable to connect to the SonicPanel server: <b>$hostname</b> on port 443 by SSL/HTTPS. <br><br> Make sure that you have entered your SonicPanel server hostname correctly in the WHMCS server settings for the server.");}
if ($getresponse == 401) {throw new Exception("<b>SonicPanel Server Invalid API Key!</b> Check your username and API Key(Password) in server settings for this active server <b>$hostname</b>. You need to enter the API key, not your root password. See the instructions <a href='https://kb.sonicpanel.com/article.php?id=15' target='_blank'>https://kb.sonicpanel.com/article.php?id=15</a> <br><br> Multiple login failures in 1 hour will get your website IP banned for 1 hour. You can disable the brute force ban protection from your SonicPanel root >> Services link on the left menu. Make sure to reactivate it after you have completed the configurations. It is an important security.");}
if ($getresponse == 403) {throw new Exception("<b>SonicPanel Server Invalid API Key!</b> Check your username and API Key(Password) in server settings for this active server <b>$hostname</b>. You need to enter the API key, not your root password. See the instructions https://kb.sonicpanel.com/article.php?id=15"); }
if ($getresponse == 500) {throw new Exception("Multiple API Login Failures Detected: Your website IP is blocked for 1 hour to login. Read the limits and security in SonicPanel under the Billing and API page. Unban the IP instructions https://kb.sonicpanel.com/article.php?id=24");}
curl_close($ch);

    $obj = json_decode($retval);
    $return = $obj->{'result'};

	if ($return=="complete") {
		$result = "success";
	} else {
		$result = $return;
	}
	return $result;
}

function sonicpanel_UnsuspendAccount($params) {

    // Details
    $hostname = $params["serverhostname"];
    $rad_username= $params["username"];
    $serverp = $params["serverpassword"];
    $serveruser = $params["serverusername"];

$sonicpanelserver = "https://$hostname/api/sonic_api.php";
$data = "cmd=unsuspend&rad_username=$rad_username&key=$serverp&owner=$serveruser";
$ch = curl_init();
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 59);
curl_setopt($ch, CURLOPT_URL, $sonicpanelserver);
$retval = curl_exec($ch);
$getresponse = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if (curl_error($ch)) {throw new Exception("Unable to connect to the SonicPanel server: <b>$hostname</b> on port 443 by SSL/HTTPS. <br><br> Make sure that you have entered your SonicPanel server hostname correctly in the WHMCS server settings for the server.");}
if ($getresponse == 401) {throw new Exception("<b>SonicPanel Server Invalid API Key!</b> Check your username and API Key(Password) in server settings for this active server <b>$hostname</b>. You need to enter the API key, not your root password. See the instructions <a href='https://kb.sonicpanel.com/article.php?id=15' target='_blank'>https://kb.sonicpanel.com/article.php?id=15</a> <br><br> Multiple login failures in 1 hour will get your website IP banned for 1 hour. You can disable the brute force ban protection from your SonicPanel root >> Services link on the left menu. Make sure to reactivate it after you have completed the configurations. It is an important security.");}
if ($getresponse == 403) {throw new Exception("<b>SonicPanel Server Invalid API Key!</b> Check your username and API Key(Password) in server settings for this active server <b>$hostname</b>. You need to enter the API key, not your root password. See the instructions https://kb.sonicpanel.com/article.php?id=15"); }
if ($getresponse == 500) {throw new Exception("Multiple API Login Failures Detected: Your website IP is blocked for 1 hour to login. Read the limits and security in SonicPanel under the Billing and API page. Unban the IP instructions https://kb.sonicpanel.com/article.php?id=24");}
curl_close($ch);

    $obj = json_decode($retval);
    $return = $obj->{'result'};

	if ($return=="complete") {
		$result = "success";
	} else {
		$result = $return;
	}
	return $result;

}

function sonicpanel_ClientArea($params) {

    $serveruser = $params["serverusername"];
	$hostname = $params["serverhostname"];
	$client = $params["username"];
    $server_p = $params["serverpassword"];
    $token = md5(uniqid($client, true));

    $sonicpanelserver = "https://$hostname/api/sonic_api.php";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "cmd=login&owner=$serveruser&client=$client&usertoken=$token&key=$server_p");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    curl_setopt($ch, CURLOPT_URL, $sonicpanelserver);
    $retval = curl_exec($ch);
    $getresponse = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_error($ch)) {$error = "Unable to connect to the server: <b>$hostname</b> on port 443 by SSL/HTTPS. <br><br> Please contact your radio hosting provider, the hostname <b>$hostname</b> in the billing server settings for the control panel is invalid. You may check the welcome email sent by your radio hosting provider to see the direct login url.";}
    if ($getresponse == 401) {$error = "<b>Invalid API Key!</b> Please contact your radio hosting provider, the control panel API Key set on this billing server settings is invalid. You may check the welcome email sent by your radio hosting provider to see the direct login url.";}
    if ($getresponse == 403) {$error = "<b>Invalid API Key!</b> Please contact your radio hosting provider, the control panel API Key set on this billing server settings is invalid. You may check the welcome email sent by your radio hosting provider to see the direct login url.";}
    if ($getresponse == 500) {$error = "Multiple API Login Failures Detected: Please contact your radio hosting provider, the control panel API Key set on this billing server settings is invalid. You may check the welcome email sent by your radio hosting provider to see the direct login url.";}
    curl_close($ch);
    // Get Account Packages from the sonicpanel Server

    if ($getresponse != 200) {
    $fail = "<div class='alert alert-danger'><strong><span class='title'>Module Error</span></strong><br><br>$error</div>";
    return $fail;
    }


    if ($getresponse == 200) {
        $process = $client . ':' . $token;
        $process64 = base64_encode($process);
        $connection = $params["serverip"];
        $orderid = $params["serviceid"];
        $eye = false;
        $appesite = flase;
        $aplicativo = '...'; 
        $site = '...';
        $login = '...';
        $senha = '...';
    
        $packageid = '191'; // Informar o pacote que não tem aplicativo e site grátis.
        
        //$invoice = Capsule::table('tblinvoices')->where('userid', $params['userid'])->first();
        $invoices = Capsule::table('tblinvoices')->where('userid', $params['userid'])->where('total', '>=', 10.00)->orderBy("id", "asc")->get();
        
        foreach($invoices as $invoice)
        {
            if(isset($invoice->status) && $invoice->status == 'Paid' )
            {   
                $eye = true;
            } 
            else
            {
                $eye = false;
            }
        }
        
        foreach (Capsule::table("tblcustomfieldsvalues")->where("fieldid", '84')->where("relid", $params['userid'])->get() as $client){
            $aplicativo = $client->value; // Campo URL da Play Store do Aplicativo Android
        }
        
        foreach (Capsule::table("tblcustomfieldsvalues")->where("fieldid", '88')->where("relid", $params['userid'])->get() as $client){
            $site = $client->value; // Campo URL do Site para Web Radio
        }
        
        foreach (Capsule::table("tblcustomfieldsvalues")->where("fieldid", '91')->where("relid", $params['userid'])->get() as $client){
            $dir = $client->value; // Campo DIRETORIO do admin do Site para Web Radio
        }
        
        foreach (Capsule::table("tblcustomfieldsvalues")->where("fieldid", '89')->where("relid", $params['userid'])->get() as $client){
            $login = $client->value; // Campo LOGIN do Site para Web Radio
        }
        
        foreach (Capsule::table("tblcustomfieldsvalues")->where("fieldid", '90')->where("relid", $params['userid'])->get() as $client){
            $senha = $client->value; // Campo SENHA do Site para Web Radio
        }
    
        foreach (Capsule::table("tbltickets")->where("title", 'Solicitação de Aplicativo')->where("userid", $params['userid'])->get() as $client){
            $ticketsId = $client->id; // Verifica se já pediu aplicativo
            $ticketsC = $client->c;
            $ticketsTid = $client->tid;
        }
    
        foreach (Capsule::table("tblhosting")->where("id", $orderid)->where("packageid", $packageid)->where("userid", $params['userid'])->orderBy("regdate", "desc")->get() as $client){
            
            $data_registro  = strtotime($client->regdate);
            $fim           = strtotime("2022-03-23");
    
            if($data_registro <= $fim) 
            { 
                $appesite = true;
            } 
            else 
            {
                $appesite = false;
            }
        }
        
        $code = '
        <style>
            .field-icon {
                float: right;
                margin-right: 10px;
                margin-top: 15px;
                position: absolute;
                right: 45px;
                z-index: 2;
            }
            .billingOverview [class*=col-]>.row {
                margin-bottom: 0 !important;
            }
            
            .panel-nav {
                -webkit-border-top-left-radius: 8px;
                -webkit-border-top-right-radius: 8px;
                -moz-border-radius-topleft: 8px;
                -moz-border-radius-topright: 8px;
                border-top-left-radius: 8px;
                border-top-right-radius: 8px;
            }
            .panel-body, .module-client-area {
                padding:0 !important;
            }
            
        </style>
        <script type="text/javascript">
            function copyToClipboard(text, el) {
                var copyTest = document.queryCommandSupported("copy");
                var elOriginalText = el.attr("data-original-title");
                if (copyTest === true) {
                    var copyTextArea = document.createElement("textarea");
                    copyTextArea.value = text;
                    document.body.appendChild(copyTextArea);
                    copyTextArea.select();
                    try {
                    var successful = document.execCommand("copy");
                    var msg = successful ? "Copiado!" : "Whoops, not copied!";
                    el.attr("data-original-title", msg).tooltip("show");
                    } catch (err) {
                    console.log("Oops, unable to copy");
                    }
                    document.body.removeChild(copyTextArea);
                    el.attr("data-original-title", elOriginalText);
                } else {
                    window.prompt("Copy to clipboard: Ctrl+C or Command+C, Enter", text);
                }
            }
            $(document).ready(function() {
                $(".js-tooltip").tooltip();
                $(".js-copy").click(function() {
                    var text = $(this).attr("data-copy");
                    var el = $(this);
                    copyToClipboard(text, el);
                });
            });
        </script>
        <script type="text/javascript">
            jQuery(document).ready(function(){
                $(".toggle-password").click(function() {
                    $(this).toggleClass("fa-eye fa-eye-slash");
                    var input = jQuery("#inputPassword");
                        if (input.attr("type") == "password") {
                            input.attr("type", "text");
                        } else {
                            input.attr("type", "password");
                        }
                });
                $(".toggle-password-2").click(function() {
                    $(this).toggleClass("fa-eye fa-eye-slash");
                    var input = jQuery("#inputPassword2");
                        if (input.attr("type") == "password") {
                            input.attr("type", "text");
                        } else {
                            input.attr("type", "password");
                        }
                });
            }); 
        </script>
        <div class="section">
            <div class="section-body">
                <div class="panel panel-default">
                        <ul class="panel-tabs nav nav-tabs">
                            <li>
                                <a href="#panel" data-toggle="tab" class="active"><i class="fa fa-cogs"></i> Panel</a>
                            </li>
                            <li>';
                                if ($appesite) {
                                    $code .='<a href="#app" data-toggle="tab" aria-expanded="true"><i class="fa fa-globe"></i> Aplicativo</a>';
                                }
                            $code .= '
                            </li>
                            <li>
                                <a href="#site" data-toggle="tab" aria-expanded="true"><i class="fa fa-folder"></i> Site</a>
                            </li>
                            <li>
                                <a href="#ajuda" data-toggle="tab" aria-expanded="true"><i class="fa fa-hdd"></i> Ajuda</a>
                            </li>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" data-toggle="dropdown" href="#" role="button" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ticket ls ls-new-window"></i> Acesso Remoto</a>
                                <div class="dropdown-menu">
                                  <a href="https://wa.me/5581988327966?text=Ol%C3%A1%2C+gostaria+de+agendar+um+acesso+remotto+para+configurar+minha+WebR%C3%A1dio." target="_blank">Agendar suporte remoto</a>
                                </div>
                            </li>
                            
                        </ul>
                    <div class="tab-content" style="padding: var(--panel-body-padding);">
                        <div class="tab-pane active billingOverview" id="panel" style="margin-bottom: 0px!important;">
                             <div class="row" style="margin-bottom: 0px!important;">
                                <div class="col-sm-12 col-md-7 m-b-2x">
                                    <div id="firstPaymentAmount">
                                        <div class="col-xs-12" >
                                            <span class="text-light">
                                                <h5>Painel SonicPanel</h5>
                                                <div style="margin-bottom:10px">Seu painel de Controle é o <strong>SonicPanel</strong>, um dos mais completos e populares do mundo.</div>
                                                <p>Para acessar o seu painel de controle <strong>SonicPanel</strong>, clique no botão abaixo:<p>
                                            <span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light">
                                                <p><form action=https://'.$hostname.'/cp/log.php method=post target=_blank> <input name=cstoken type="hidden" value="'.$process64.'"> <button type="submit" class="btn btn-primary"><i class="fas fa-chevron-circle-right"></i> Painel de Controle da Rádio</button></form></p>
                                            </span>
                                        </div>
                                        <div class="col-xs-12" style="margin-top:10px">  
                                            <span class="text-light"><p>Caso seja seu primeiro accesso, navega até a aba <strong>Ajuda</strong> para os primeiros passos.</p></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-5">
                                    <div>
                                        <div class="col-xs-12">
                                            <span class="text-light  text-small">
                                                Usuário:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="'.$params["username"].'" value="'.$params["username"].'" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="'.$params["username"].'" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12">
                                            <span class="text-light  text-small">
                                                Senha:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="password" name="password" id="inputPassword" data-copy="'.$params["password"].'" value="'.$params["password"].'" class="form-control js-tooltip js-copy" readonly="readonly" data-original-title="" title="">
                                                <span toggle="#password-field" data-toggle="tooltip" data-html="true" data-placement="bottom" title="Exibir Senha" class="fa fa-fw fa-eye fa-lg field-icon toggle-password"></span>
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="'.$params["password"].'" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>    
                                        </div>
                                        <div class="col-xs-12">
                                            <span class="text-faded"><p style="margin-bottom: 0px!important;font-size: 11px;line-height: 16px;margin-top:7px">Problemas com a senha? Clique em <strong>Alterar a Senha</strong> no menu do lado esquerdo.</p>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane billingOverview" id="app" style="margin-bottom: 0px!important;">
                            <div class="row" style="margin-bottom: 0px!important;">
                                <div class="col-sm-12 col-md-7">
                                    <div>
                                        <div class="col-xs-12" >
                                            <span class="text-light">Seu plano contempla o desenvolvimento de aplicativo Android totalmente GRÁTIS e personalizado com suas cores e logo-marca.</span>
                                        </div>
                                        <div class="col-xs-12" style="margin-top:10px">  
                                            <span class="text-light"><p>Para efetuar sua solicitação (e posterior publicação na Play Store), clique no botão abaixo e modernize a sua rádio web. É rápido e fácil!</p></span>
                                        </div>';
                            if ($eye == false) 
                            {
                                $code .='<div class="col-xs-12">  
                                            <div class="section">
                                                <div class="alert alert-warning alert-faded alert-panel">   
                                                    <div class="alert-icon ls ls-exclamation-circle"></div>
                                                    <div class="alert-body">
                                                        <p>A solicitação não está disponível durante o período de teste.</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xs-12" style="margin-top:30px">  
                                            <span class="text-light"><p>Você pode adiantar a liberação do app efetuando uma adição de crédito no valor do seu plano. Esta valor será acrecentado a sua futura fatura.</p></span>
                                        </div>
                                        <div class="col-xs-12" style="margin-top:10px">  
                                            <span class="text-light"><p>Adicionando crédito: acesse o menu <strong>Faturas -> <a href="https://www.souzahost.com.br/central/clientarea.php?action=addfunds" target="_blank">Adicionar Crédtos</a></strong>.</p></span>
                                        </div>';
                            } else {
                                $code .='<div class="col-xs-12">  
                                            <div class="row">
                                                <div class="col-4">';
                                                    if (!$ticketsId) {
                                                        $code .='<a class="btn btn-primary" href="https://www.souzahost.com.br/formulario-solicitar-aplicativo/?getEmail='.$params["clientsdetails"]["email"].'"  target="_blank"><span>Solicitar Aplicativo</span></a>';
                                                    } else {
                                                        $code .='<a class="btn btn-danger" href="https://www.souzahost.com.br/central/viewticket.php?tid='.$ticketsTid.'&c='.$ticketsC.'"><span>Aplicativo Solicitado</span></a>';
                                                    }; 
                                                $code .='
                                                </div>
                                                <div class="col-8">
                                                    <img style="height: 30px;padding-top: 10px;" class="align-self-end mr-3" src="./assets/img/app-webradio-android.png" alt="Aplicativo Android Grátis">
                                                </div>
                                            </div>
                                        </div>';
                            }
    
                            $code .= '</div>
                                </div>
                                <div class="col-sm-12 col-md-5">
                                    <div>
                                        <div class="col-xs-12">
                                            <span class="text-light">
                                                URL do seu Aplicativo:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="'.$aplicativo.'" value="'.$aplicativo.'" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="'.$aplicativo.'" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>
                                        </div>';
                            
                            if ($eye == false) 
                            {
                                $code .='<div class="col-xs-12">
                                            <span class="text-faded">
                                                <p style="margin-bottom: 14px!important;font-size: 11px;line-height: 16px;margin-top:7px">A solicitação do app não está disponível durante o período de teste. Efetue o seu primeiro pagamento conosco e teste volte novamente.</p>
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <p class="text-center" style="margin-top: 40px; line-height: 22px">
                                                <a href="https://play.google.com/store/apps/details?id=com.souzahost.alternativapublicidademedia" target="_blank"><i style="font-size: 35px;margin-bottom: 5px" class="fas fa-download"></i><br>
                                                BAIXE NOSSO<br>
                                                APLICATIVO DEMO</a>
                                                
                                            </p>
                                        </div>';
                            } else {
                                $code .='<div class="col-xs-12">
                                            <span class="text-faded">
                                                <p style="margin-bottom: 14px!important;font-size: 11px;line-height: 16px;margin-top:7px">A solicitação do app personalizado está disponível gratuitamente. Solicte agora mesmo!</p>
                                            </span>
                                        </div>';
                            }
    
                            $code .= '</div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane billingOverview" id="site" style="margin-bottom: 0px!important;">
                            <div class="row" style="margin-bottom: 0px!important;">
                                <div class="col-sm-12 col-md-8">
                                    <div>
                                        <div class="col-xs-12" >
                                            <span class="text-light">
                                                <h5>Site para Web Rádio Grátis</h5>
                                                <p>Seu plano de <strong>Hospedagem Streaming</strong> contempla um <strong>Site para Web Rádio</strong> como cortesia para você.</p>
                                            <span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light">
                                                <p><a href="https://www.souzahost.com.br/central/knowledgebase/75/Como-gerar-meu-cupom-promocional-para-adquirir-o-Site-para-Web-Radio.html" target="_blank">Como gerar meu cupom promocional? <i class="align-top fas fa-external-link-alt"></i></a><br>
                                                <a href="https://www.souzahost.com.br/central/knowledgebase/76/Como-utilizar-meu-cupom-promocional-para-adquirir-o-Site-para-Web-Radio.html" target="_blank">Como utilizar meu cupom promocional? <i class="align-top fas fa-external-link-alt"></i></a></p>
                                            </span>
                                        </div>
                                        <div class="col-xs-12" style="margin-top:15px">
                                            <span class="text-light">
                                                <h5>Importante</h5>
                                                <p>Nossos planos de Streaming contam com um Site Web Rádio para utilização, de forma totalmente gratuita.</p>
                                            <span>
                                        </div>
                                        <div class="col-xs-12" >
                                            <span class="text-light">
                                                <p>Para ativar seu site, você precisa não está no período gratuito e ter um endereço de domínio previamente registrado. Caso não possua, poderá adquiri-lo-lo conosco ou usar o nosso subdomínio ( <strong>suaradio.webradio.vip</strong> ) para webrádio gratuitamente.</p>
                                            <span>
                                        </div>
                                        <div class="col-xs-12" >
                                            <span class="text-light">
                                                <p>Se já tiver, basta alterar os DNS para a SouzaHost (este procedimento poderá ser feito por nossa equipe sem nenhum custo adicional, bastando apenas abrir um chamado solicitando esta alteração).</p>
                                            <span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-4">
                                    <div>
                                        <div class="col-xs-12">
                                            <span class="text-light">
                                                Administração do seu Site:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="'.$site.'/'.$dir.'" value="'.$site.'/'.$dir.'" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="'.$site.'/'.$dir.'" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12" style="margin-top: 15px;">
                                            <span class="text-light  text-small">
                                                Usuário:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="text" data-copy="'.$login.'" value="'.$login.'" class="form-control js-tooltip js-copy" readonly="readonly">
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="'.$login.'" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>
                                        </div>
                                        <div class="col-xs-12">
                                            <span class="text-light  text-small">
                                                Senha:
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                <input type="password" name="password" id="inputPassword2" data-copy="'.$senha.'" value="'.$senha.'" class="form-control js-tooltip js-copy" readonly="readonly" data-original-title="" title="">
                                                <span toggle="#password-field" data-toggle="tooltip" data-html="true" data-placement="bottom" title="Exibir Senha" class="fa fa-fw fa-eye fa-lg field-icon toggle-password-2"></span>
                                                <span class="input-group-addon"><span data-toggle="tooltip" data-copy="'.$senha.'" data-placement="right" title="" class="ls ls-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                                            </div>    
                                        </div>
                                        <div class="col-xs-12">
                                            <span class="text-faded"><p style="margin-bottom: 30px!important;font-size: 11px;line-height: 16px;margin-top:7px">Login e senha do painel do site.</p>
                                            </span>
                                        </div>
                                        <div class="col-xs-12">';
                                if ($site == '...' or !$site) {
                                    
                                    $code .='<span class="text-faded">
                                                
                                                <script src="//cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.js"></script>
                                                <link rel="stylesheet" href="./modules/gateways/singlepix/sweetalert2.min.css" id="theme-styles">
                                                <button type="submit" class="btn btn-primary" onclick="gerarCupom();">Gerar Cupom</button>
                                                <script type="text/javascript">
                                                    function gerarCupom() {';
                                            if ($eye == false){
                                                    $code .='
                                                        Swal.fire({
                                                           icon: \'error\',
                                                           confirmButtonColor: "#3085d6",
                                                           title: \'Oops...\',
                                                           text: \'A solicitação do cupom não está disponível durante o período de teste da promoção.\',
                                                           confirmButtonText: "Entendi",
                                                           footer: \'<a href="https://www.souzahost.com.br/regulamento-da-promocao-30-dias-gratis/" target="_blank">Regulamento da Promoção</a>\'
                                                        });';
                                            } else {
                                                    $code .='
                                                        Swal.fire({
                                                           icon: \'success\',
                                                           title: \'Maravilha!!\',
                                                           html: \'Estamos felizes em informar que seu cupom web rádio grátis, foi gerado com sucesso!<br><br>Seu cupom <strong>WRHSGTS</strong>\',
                                                           showCancelButton: true,
                                                           confirmButtonColor: "#3085d6",
                                                           confirmButtonText: "Efetuar a Contratação Agora",
                                                           cancelButtonColor: "#3085d6",
                                                           cancelButtonText: "Entendi",
                                                           allowOutsideClick: () => !Swal.isLoading(),
                                                           footer: \'<a href="https://www.souzahost.com.br/central/knowledgebase/76/Como-utilizar-meu-cupom-promocional-para-adquirir-o-Site-para-Web-Radio.html" target="_blank">Como utilizar meu cupom promocional?</a>\'
                                                        }).then((result) => {
                                                            if (result.isConfirmed) {
                                                                let timerInterval
                                                                Swal.fire({
                                                                title: "Redirecionando!",
                                                                text: "Gerando o pedido em instantes...",
                                                                icon: "success",
                                                                footer: "Aguarde! Você será redirecionar...",
                                                                didOpen: () => {
                                                                    Swal.showLoading()
                                                                    const b = Swal.getHtmlContainer().querySelector(\'b\')
                                                                    timerInterval = setInterval(() => {
                                                                    b.textContent = Swal.getTimerLeft()
                                                                    }, 2000)
                                                                },
                                                                willClose: () => {
                                                                    clearInterval(timerInterval)
                                                                }
                                                                });
                                                                location.href = "https://www.souzahost.com.br/central/cart.php?a=add&pid=197&billingcycle=monthly&promocode=WRHSGTS"; 
                                                            }
                                                        });';
                                            }
                                                    $code .= '
                                                    }
                                                </script>
                                                
                                                <p style="margin-top:10px;">Clique no botão para gerar seu cupom personalizado para um site administrável.</p>
                                            </span>';
                                } else {
                                    $code .='<span class="text-faded">
                                                <a href="'.$site.'/'.$dir.'" class="btn btn-primary" role="button" aria-pressed="true" target="_blank">Administrar</a>
                                                <a href="'.$site.'" class="btn btn-default" role="button" aria-pressed="true" target="_blank">Site</a>
                                                <p style="margin-top:10px!important;font-size: 11px;line-height: 16px;">Clique no botão acima para administrar seu site informe a senha e o login, se precisar.</p>
                                            </span>';
                                }
                                    $code .= '
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane billingOverview" id="ajuda" style="margin-bottom: 0px!important;">
                            <div class="row" style="margin-bottom: 0px!important;">
                                <div class="col-sm-12 col-md-8">
                                    <div>
                                        <div class="col-xs-12" >
                                            <span class="text-light">
                                                <h5>URL de Transmissão dos Streaming</h5>
                                                <p>Para obter a lista com todas as URLs de transmissão de seu plano de Streaming, basta acessar o painel SonicPanel e, no menu lateral, clicar na opção <strong>Player Listen Links</strong>.</p>
                                                <p>Lá, você poderá ver a URL para ouvir sua rádio via Winamp, VLC, iTunes, Player com HTML e URL com SSL.</p>
                                            <span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light">
                                                <h5>Tutorial Úteis</h5>
                                                <p>Abaixo, preparamos alguns tutoriais que podem ser úteis neste primeiro momento:</p>
                                            </span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light">
                                                <p><a href="https://www.souzahost.com.br/central/knowledgebase/63/Como-enviar-musicas-para-o-streaming.html" target="_blank"><i class="fas fa-external-link-alt"></i> Como enviar músicas para o streaming?</a><br>
                                                <a href="https://www.souzahost.com.br/central/knowledgebase/65/Como-se-conectar-ao-AutoDJ-para-transmitir-ao-vivo.html" target="_blank"><i class="fas fa-external-link-alt"></i> Como se conectar ao AutoDJ para transmitir ao vivo?</a><br>
                                                <a href="https://www.souzahost.com.br/central/knowledgebase/60/Como-criar-uma-playlist-no-SonicPanel.html" target="_blank"><i class="fas fa-external-link-alt"></i> Como criar uma playlist no SonicPanel?</a></p>
                                            </span>
                                        </div>
                                        <div class="col-xs-12">  
                                            <span class="text-light">
                                                <p>Para gerar os players de áudio para sua rádio, pedimos por gentileza que acesse seu painel administrativo e vá até a opção <strong>Widgets do Player</strong>.</p>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-4">
                                    <div>
                                        <div class="col-xs-12">
                                            <div class="col-xs-12" style="padding-left:0!important">
                                                <h5>Vídeos</h5>
                                            </div>
                                            <span class="text-light">
                                                Conhecendo o nosso painel de Streaming
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                
                                                <iframe style="border-radius: 5px" width="280" src="https://www.youtube.com/embed/InjPjmlTbwA" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
    
                                            </div>
                                        </div>
                                        <div class="col-xs-12" style="margin-top: 15px;">
                                            <span class="text-light">
                                                Configurar e transmitir ao vivo p/AutoDJ
                                            </span>
                                        </div>
                                        <div class="col-xs-12">
                                            <div class="input-group">
                                                
                                                <iframe style="border-radius: 5px" width="280" src="https://www.youtube.com/embed/GMgf0vTJw0M" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
    
                                            </div>
                                        </div>
                                        
                                        <div class="col-xs-12">  
                                            <span class="text-faded"><p style="margin-bottom: 0px!important;font-size: 11px;line-height: 16px;margin-top:7px">Para mais tutoriais, acesse nosso canal.</p>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        
                    </div>
                </div>
            </div>
        </div>';
        return $code;
    }

    }
    function sonicpanel_AdminLink($params) {
        $connection = $params["serverhostname"];
        $code = "<button type='submit' class='btn btn-primary' onclick=\"window.open('https://$connection:2087','_blank')\"><i class='fas fa-chevron-circle-right'></i> SonicPanel Admin Login</button>";
        return $code;
    }
?>