<?php
/**
 * Single PIX - Módulo SouzaHost para integração com WHMCS
 * 
 * @package    PagSeguro para WHMCS
 * @version    1.0.0
 * @author     Mantido por Edilson Souza - https://edilson.site/
 * @license    BSD License (3-clause)
 * @copyright  (c) 2017-2019, SouzaHost
 * @link       https://www.souzahost.com.br/modulo-pagseguro-api
 **/
 
if (!defined("WHMCS")) die("This file cannot be accessed directly");

include_once "singlepix/phpqrcode/qrlib.php"; 
include_once "singlepix/funcoes_pix.php";

function singlepix_config() {

    global $CONFIG;

    $modulo = '1.0.0'; 
    $modulo_int = (int)preg_replace("/[^0-9]/", "", $modulo);
	
    $query = 'https://www.souzahost.com.br/modulos/?modulo=pix';
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
    curl_setopt($curl, CURLOPT_URL, $query);
    
    $result = curl_exec($curl);
    $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);

	$available_update = $result;
	$available_update_int = (int)preg_replace("/[^0-9]/", "", $available_update);
	
	if( $available_update_int === $modulo_int ) {
		$available_update_message = $available_update.' <i class="fas fa-check-circle" style="color:#4E7408;"></i> Você está executando a versão mais recente!';
	}
	if( $available_update_int > $modulo_int ) {
		$available_update_message = $available_update.' <i class="fas fa-exclamation-circle" style="color:#d3678d;"></i> Atualização disponível, <a style="color:#d3678d;" href="https://www.souzahost.com.br/central/dl.php?type=d&id=7">Download</a>.';
	}
	if( $available_update_int < $modulo_int ) {
		$available_update_message = $available_update.' <i class="fas fa-exclamation-circle" style="color:#d6b200;"></i> Você está executando uma versão beta.';
	}

    $ip_message = '<i class="fas fa-check-circle" style="color:#46A546;"></i> Ativa'; 

    $configarray = array(
        "FriendlyName" => array("Type" => "System", "Value" => "Single PIX" ),
        "ipok" 	   => array("FriendlyName" => "<span class='label label-primary'><i class='fa fa-exclamation-circle'></i>  Licença </span>", "Description" => $ip_message),
        "pixkey" => array("FriendlyName" => "PIX key", "Type" => "text", "Size" => "80", "Description" => "Informe sua chave PIX."),
        "youname" => array("FriendlyName" => "Nome", "Type" => "text", "Size" => "80", "Description" => "Informe o nome do titular da conta."),
        'suporte'	   => array("FriendlyName" => "<span class='label label-primary'><i class='fa fa-question-circle'></i>  Informações </span>", "Description" =>  '<p>&copy; 2017 - '.date('Y').' / <a style="text-decoration:underline;" target="_blank" title="SouzaHost" href="https://www.souzahost.com.br" target="_blank">SouzaHost</a> - Sua Versão: ' . $modulo . ' - Última Versão: '.$available_update_message.' - <g-emoji class="g-emoji" alias="heart" fallback-src="https://github.githubassets.com/images/icons/emoji/unicode/2764.png">❤️</g-emoji> <a style="text-decoration:underline;" target="_blank" title="Suporte" href="https://www.souzahost.com.br/donate">Donate</a></p>'),            
    );

    return $configarray;

}

function singlepix_link($params) {

    $px[00]="01"; 
    //$px[01]="12";
    $px[26][00]="br.gov.bcb.pix";
    $px[26][01]=$params['pixkey'];
    //$px[26][02]="FATURA#" . $params['invoicenum'];

    $px[52]="0000";
    $px[53]="986";
    $px[54]=$params['amount'];
    $px[58]="BR";
    $px[59]=strtoupper($params['youname']);
    $px[60]=strtoupper($params['clientdetails']['city']);
    $px[62][05]="***";

    $pix=montaPix($px);
    $pix.="6304";
    $pix.=crcChecksum($pix);

	ob_start();
	QRCode::png($pix, null,'M',5);
	$imageString = base64_encode( ob_get_contents() );
	ob_end_clean();
   
    $strcode = base64_encode($params['invoicenum'].$params['amount']);
    
    $code = '<div style="text-align: left; width: 100%; max-width: 100%;">'. "\n";
	$code .= '<script type="text/javascript">
        function copyToClipboard(text, el) {
            var copyTest = document.queryCommandSupported(\'copy\');
            var elOriginalText = el.attr(\'data-original-title\');
            if (copyTest === true) {
                var copyTextArea = document.createElement("textarea");
                copyTextArea.value = text;
                document.body.appendChild(copyTextArea);
                copyTextArea.select();
                try {
                var successful = document.execCommand(\'copy\');
                var msg = successful ? \'Copiado!\' : \'Whoops, not copied!\';
                el.attr(\'data-original-title\', msg).tooltip(\'show\');
                } catch (err) {
                console.log(\'Oops, unable to copy\');
                }
                document.body.removeChild(copyTextArea);
                el.attr(\'data-original-title\', elOriginalText);
            } else {
                window.prompt("Copy to clipboard: Ctrl+C or Command+C, Enter", text);
            }
        }
        $(document).ready(function() {
            $(\'.js-tooltip\').tooltip();
            $(\'.js-copy\').click(function() {
                var text = $(this).attr(\'data-copy\');
                var el = $(this);
                copyToClipboard(text, el);
            });
        });
    </script>
    <script type="text/javascript">
        jQuery(document).ready(function(){
            $(".toggle-password").click(function() {
                $(this).toggleClass("fa-eye fa-eye-slash");
                var input = jQuery(\'#inputPassword\');
                    if (input.attr("type") == "password") {
                        input.attr("type", "text");
                    } else {
                        input.attr("type", "password");
                    }
            });
        }); 
    </script>'."\n";

    $code .= '<div style="margin-top: 20px;">
            <div class="col-xs-12" style="padding-bottom: 5px;">
                <span class="gray-base">
                    <strong>QRCode:</strong>
                </span>
            </div>
            <div class="col-xs-12">
                <img style="-webkit-border-radius: 5px; -moz-border-radius: 5px; border-radius: 5px; border-width: 1px; border-style: solid; border-color: #3f79bc; width: 100% !important; max-width: 350px !important;" src="data:image/png;base64,' . $imageString . '" alt="QRCode" />
            </div>
        </div>'. "\n";
    $code .= '<div style="margin-top: 10px;">
                <div class="col-xs-12" style="padding-bottom: 5px;">
                    <span class="gray-base">
                        <strong>Chave CNPJ:</strong>
                    </span>
                </div>
                <div class="col-xs-12">
                    <div class="input-group">
                        <input type="text" data-copy="'.$params['pixkey'].'" value="'.$params['pixkey'].'" class="js-tooltip js-copy" readonly="readonly" style="padding: 2px 5px;background-color: #e9eaec; color: #1e1e1e; font-weight: 500;">
                        <span class="input-group-addon"><span data-toggle="tooltip" data-copy="'.$params['pixkey'].'" data-placement="right" title="" class="fa fa-copy js-tooltip js-copy" data-original-title="Copiar"></span></span></span>
                    </div>
                </div>
                <div class="col-xs-12" style="margin-top: 10px;padding-bottom: 5px;">
                    <span class="gray-base">
                        <strong>PIX Copiar e Cola:</strong>
                    </span>
                </div>
                <div class="col-xs-12">
                    <div class="input-group">
                        <input type="text" data-copy="'.$pix.'" value="'.$pix.'" class="js-tooltip js-copy" readonly="readonly" style="padding: 2px 5px;background-color: #e9eaec; color: #1e1e1e; font-weight: 500;">
                        <span class="input-group-addon"><span data-toggle="tooltip" data-copy="'.$pix.'" data-placement="right" title="" class="fa fa-copy js-tooltip js-copy" data-original-title="Copiar"></span></span>
                    </div>
                </div>
                <div class="col-xs-12">
                    <span class="gray-base">
                        <p style="margin-bottom: 14px!important;font-size: 11px;line-height: 16px;margin-top:7px">Abra o app do seu <strong>Banco</strong> em seu smartphone e escaneie o <strong>QRCode</strong> ou pague com <strong>PIX copia e cola</strong> ou a <strong>chave PIX aleatória</strong>.</p>
                    </span>
                </div>
                <div class="col-xs-12" style="margin-top: 0px;padding-bottom: 5px;">
                    <div class="input-group">
                        <div class="col-sm-12" style="padding-left: 0; padding-right: 0;">
                            <script src="//cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.js"></script>
                            <link rel="stylesheet" href="./modules/gateways/singlepix/sweetalert2.min.css" id="theme-styles">
                            <a onclick="fatura_'.$params['invoicenum'].'();" style="cursor: pointer;"><button type="submit" class="btn btn-primary btn-block">Confirmar pagamento</button></a>
                            <script type="text/javascript">
                                function fatura_'.$params['invoicenum'].'() {
                                    Swal.fire({
                                        title: "Confirma o pagamento?",
                                        text: "Caso o PIX não tenha sido feito, não confirme!",
                                        icon: "question",
                                        showCancelButton: true,
                                        confirmButtonColor: "#3085d6",
                                        cancelButtonColor: "#d33",
                                        confirmButtonText: "Sim, confirmo o pagamento!",
                                        cancelButtonText: "Não confirmo...",
                                        allowOutsideClick: () => !Swal.isLoading(),
                                        footer: "Um email será enviado ao financeiro."
                                    }).then((result) => {
                                        if (result.isConfirmed) {
                                            let timerInterval
                                            Swal.fire({
                                            title: "Confirmado!",
                                            text: "Seu pagamento será liberado em breve...",
                                            icon: "success",
                                            footer: "Aguarde! Você será redirecionar...",
                                            didOpen: () => {
                                                Swal.showLoading()
                                                const b = Swal.getHtmlContainer().querySelector(\'b\')
                                                timerInterval = setInterval(() => {
                                                b.textContent = Swal.getTimerLeft()
                                                }, 2000)
                                            },
                                            willClose: () => {
                                                clearInterval(timerInterval)
                                            }
                                            });
                                            
                                            location.href = "modules/gateways/callback/singlepix.php?strcode='.$strcode.'&invoicenum='.$params['invoicenum'].'&amount='.$params['amount'].'&clientid='.$params['clientdetails']['id'].'"; 
                                        }
                                    });
                                }
                            </script>
                        </div>
                    </div>
                </div>
                <div class="col-xs-12">
                    <span class="gray-base">
                        <p style="margin-bottom: 14px!important;font-size: 11px;line-height: 16px;margin-top:7px">Confirme o valor <strong>'. formatCurrency($params['amount']) .'</strong> da fatura <strong>#'.$params['invoicenum'].'</strong> e conclua o pagamento. Em seguida clique no botão <strong>Confirmar</strong> acima.</p>
                    </span>
                </div>
            </div>';
    
    $code .= '</div>'. "\n";

	return $code;

}
