<?php
/**
 * Módulo Juno PIX para WHMCS
 * @copyright	2020 Gofas Software
 * @see			https://gofas.net/?p=14128
 * @license		https://gofas.net/?p=9340
 * @support		https://gofas.net/?p=14299
 * @version		1.0.0
 */

if( !defined('WHMCS')){ die(''); }
use WHMCS\Database\Capsule;
function gofasjunopix_MetaData(){
    return array(
        'DisplayName' => 'Gofas Juno - PIX',
        'APIVersion' => '1.1',
    );
}
function gofasjunopix_config(){
	$module_version = '1.0.0';
	$module_version_int = (int)preg_replace("/[^0-9]/", "", $module_version);
	if( !function_exists('gjp_verifyInstall') ){
	function gjp_verifyInstall(){
		if( !Capsule::schema()->hasTable('gofasjunopix') ){
    		try {
				Capsule::schema()->create('gofasjunopix', function($table){
        			$table->increments('id');
					$table->string('invoice_id');
					$table->string('charge_id');
					$table->string('user_id');
					$table->string('amount');
					$table->string('api_mode');
					$table->string('qrc_id');
					$table->text('payloadInBase64');
					$table->text('imageInBase64');
					$table->string('created_at');
					$table->string('updated_at');
    			});
			}
			catch (\Exception $e){
    			$error .= "Não foi possível criar a tabela do módulo no banco de dados: {$e->getMessage()}";
			}
		}
		if(!$error){
			return array('sucess'=>1);
		}
		elseif($error){
			return array('error'=>$error);
		}
	}}
	$verifyInstall = gjp_verifyInstall();
	if($verifyInstall['error']){
		$error = $verifyInstall['error'];
	}
	$actual_link		= (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
	if( stripos( $actual_link, '/configgateways.php') ){
		$whmcs_url__ = str_replace("\\",'/',(isset($_SERVER['HTTPS']) ? "https://" : "http://").$_SERVER['HTTP_HOST'].substr(getcwd(),strlen($_SERVER['DOCUMENT_ROOT'])));
		$admin_url = $whmcs_url__.'/';
		$vtokens = explode('/', $actual_link);
		$whmcs_admin_path = '/'.$vtokens[sizeof($vtokens)-2].'/';
		$whmcs_url = str_replace( $whmcs_admin_path, '', $admin_url).'/';
		foreach( Capsule::table('tblconfiguration') -> where('setting', '=', 'gjpwhmcsurl') -> get( array( 'value','created_at') ) as $gjpwhmcsurl_ ){
			$gjpwhmcsurl					= $gjpwhmcsurl_->value;
			$gjpwhmcsurl_created_at			= $gjpwhmcsurl_->created_at;
		}
		foreach( Capsule::table('tblconfiguration') -> where('setting', '=', 'gjpwhmcsadminurl') -> get( array( 'value','created_at') ) as $gjpwhmcsadminurl_ ){
			$gjpwhmcsadminurl				= $gjpwhmcsadminurl_->value;
			$gjpwhmcsadminurl_created_at	= $gjpwhmcsurl_->created_at;
		}
		foreach( Capsule::table('tblconfiguration') -> where('setting', '=', 'gjpwhmcsadminpath') -> get( array( 'value','created_at') ) as $gjpwhmcsadminpath_ ){
			$gjpwhmcsadminpath				= $gjpwhmcsadminpath_->value;
			$gjpwhmcsadminpath_created_at	= $gjpwhmcsurl_->created_at;
		}
		if( !$gjpwhmcsurl ){
			try { Capsule::table('tblconfiguration')->insert(array('setting' => 'gjpwhmcsurl', 'value' => $whmcs_url, 'created_at' => date("Y-m-d H:i:s") , 'updated_at' => date("Y-m-d H:i:s")));}
			catch (\Exception $e){ $e->getMessage(); }
			try { Capsule::table('tblconfiguration')->insert(array('setting' => 'gjpwhmcsadminurl', 'value' => $admin_url, 'created_at' => date("Y-m-d H:i:s") , 'updated_at' => date("Y-m-d H:i:s")));}
			catch (\Exception $e){ $e->getMessage(); }
			try { Capsule::table('tblconfiguration')->insert(array('setting' => 'gjpwhmcsadminpath', 'value' => $whmcs_admin_path, 'created_at' => date("Y-m-d H:i:s") , 'updated_at' => date("Y-m-d H:i:s")));}
			catch (\Exception $e){ $e->getMessage(); }
		}
		if( $gjpwhmcsurl and ($whmcs_url !== $gjpwhmcsurl) ){
			try { Capsule::table('tblconfiguration')->where( 'setting', 'gjpwhmcsurl')->update(array('value' => $whmcs_url, 'created_at' =>  $gjpwhmcsurl_created_at , 'updated_at' => date("Y-m-d H:i:s")));}
			catch (\Exception $e){$e->getMessage();}
		}
		if( $gjpwhmcsadminurl and ($admin_url !== $gjpwhmcsadminurl) ){
			try { Capsule::table('tblconfiguration')->where( 'setting', 'gjpwhmcsadminurl')->update(array('value' => $admin_url, 'created_at' =>  $gjpwhmcsadminurl_created_at , 'updated_at' => date("Y-m-d H:i:s")));}
			catch (\Exception $e){$e->getMessage();}
		}
		if( $gjpwhmcsadminpath and ($whmcs_admin_path !== $gjpwhmcsadminpath) ){
			try { Capsule::table('tblconfiguration')->where( 'setting', 'gjpwhmcsadminpath')->update(array('value' => $whmcs_admin_path, 'created_at' =>  $gjpwhmcsadminpath_created_at , 'updated_at' => date("Y-m-d H:i:s")));}
			catch (\Exception $e){$e->getMessage();}
		}
		foreach( Capsule::table('tblconfiguration') -> where('setting', '=', 'gjp_version') -> get( array( 'value','created_at') ) as $gjp_version_ ){
			$gjp_version			= $gjp_version_->value;
			$gjp_version_created_at	= $gjp_version_->created_at;
		}
		if( !$gjp_version ){
			try { Capsule::table('tblconfiguration')->insert(array('setting' => 'gjp_version', 'value' => $module_version, 'created_at' => date("Y-m-d H:i:s") , 'updated_at' => date("Y-m-d H:i:s")));}
			catch (\Exception $e){ $e->getMessage(); }
		}
		if( $gjp_version and ((string)$gjp_version !== (string)$module_version) ){
			try { Capsule::table('tblconfiguration')->where( 'setting', 'gjp_version')->update(array('value' => $gjp_version, 'created_at' =>  $gjp_version_created_at , 'updated_at' => date("Y-m-d H:i:s")));}
			catch (\Exception $e){$e->getMessage();}
		}
	}
	if( !function_exists('gjp_verify_module_updates') ){
	function gjp_verify_module_updates($page_id, $referer,$module_version){
   		$query = 'https://gofas.net/br/updates/?software='.$page_id.'&referer='.$referer.'&version='.$module_version;
    	$curl = curl_init();
    	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
    	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
    	curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
    	curl_setopt($curl, CURLOPT_URL, $query);
		$result = curl_exec($curl);
    	$http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);
		return array(
			'http_status' => $http_status,
			'result' => $result,
		);
	}}
	//
	foreach( Capsule::table('tblconfiguration') -> where('setting', '=', 'gjp_update_verify') -> get( array( 'value','created_at') ) as $gjp_update_verify_ ){
		$gjp_update_verify				= json_decode($gjp_update_verify_->value, true);
		$gjp_update_verify_created_at	= $gjp_update_verify_->created_at;
		$available_update				= $gjp_update_verify['last_version'];
		$available_update_int			= (int)preg_replace("/[^0-9]/", "", $gjp_update_verify['last_version']);
		//$situation = '1ª';
	}
	if( !$gjp_update_verify ){
		$available_update_ = gjp_verify_module_updates('14128',$whmcs_url,$module_version);
		if( (int)$available_update_['http_status'] === 200 ){
			$available_update = $available_update_['result'];
			$available_update_int = (int)preg_replace("/[^0-9]/", "", $available_update);
		}
		else {
			$available_update_int = '000';
		}
		try { Capsule::table('tblconfiguration')->insert(array('setting' => 'gjp_update_verify', 'value' => json_encode(['time'=>time(),'last_version'=>$available_update]), 'created_at' => date("Y-m-d H:i:s") , 'updated_at' => date("Y-m-d H:i:s")));}
		catch (\Exception $e){ $e->getMessage(); }
		//$situation = '2ª';
	}
	if( $gjp_update_verify['time'] and ((int)((int)$gjp_update_verify['time']+86400) < (int)time())){ // Verifica só depois de 24h
		$available_update_ = gjp_verify_module_updates('14128',$whmcs_url,$module_version);
		if( (int)$available_update_['http_status'] === 200 ){
			$available_update = $available_update_['result'];
			$available_update_int = (int)preg_replace("/[^0-9]/", "", $available_update);
		}
		else {
			$available_update_int = '000';
		}
		try { Capsule::table('tblconfiguration')->where( 'setting', 'gjp_update_verify')->update(array('value' =>json_encode(['time'=>time(),'last_version'=>$available_update]), 'created_at' =>  $gjp_version_created_at , 'updated_at' => date("Y-m-d H:i:s")));}
		catch (\Exception $e){$e->getMessage();}
		//$situation = '3ª';
	}
	//else {
	//	$available_update = $module_version;
	//	$available_update_int = (int)preg_replace("/[^0-9]/", "", $module_version);
	//}
	//echo '<pre>',print_r(['$available_update'=>$available_update,'$gjp_update_verify'=>$gjp_update_verify,'time'=>time(),'situation'=>$situation]),'</pre>'; // debug


	if( $available_update_int === $module_version_int ){
		$available_update_message = '<p style="color: green"><i class="fas fa-check-square"></i> Você está executando a versão mais recente do módulo.</p>';
	}
	elseif( $available_update_int > $module_version_int ){
		$available_update_message = '<p style="font-size: 14px; color: red;"><i class="fas fa-exclamation-triangle"></i> Atualização disponível, verifique a <a style="color:#CC0000;text-decoration:underline;" href="https://gofas.net/?p=14128" target="_blank">versão '.$available_update.'</a>';
	}
	elseif( $available_update_int < $module_version_int ){
		$available_update_message = '<p style="font-size: 14px; color: orange;"><i class="fas fa-exclamation-triangle"></i> Você está executando uma versão Beta desse módulo.<br>Não recomendamos o uso dessa versão em produção.<br>Baixar versão estável: <a style="color:#CC0000;text-decoration:underline;" href="https://gofas.net/?p=14128" target="_blank">v'.$available_update.'</a>';
	}
	else {
		$available_update_message = '<p style="color: green"><i class="fas fa-check-square"></i> Você está executando a versão mais recente do módulo.</p>';
	}
	
	$tbladmins = array();
	foreach( Capsule::table('tbladmins') -> get() as $tbladmins_ ){
		$tbladmins[$tbladmins_->id] = $tbladmins_->id.' - '.$tbladmins_->firstname.' '.$tbladmins_->lastname.' ('.$tbladmins_->username.')';
	}
	$opt_num = 1;
	$renderize = array(
		'FriendlyName' => array(
			'Type' => 'System',
			'Value' => 'Gofas Juno - PIX',
		),
		'separator_1' => array(
			'Description' => '
			<style>
			.gjp_required {
				color: red;
			}
			.gjp_optional {
				color: green;
			}
			</style>
			<div id="gjp_separator" class="gjp_separator" style="padding: 1px 15px 9px;">
			<div id="gjpifrm"></div>
			<script src="https://gofas.github.io/docs/includes/js/whmcs_admin_embed.js"></script>
			<a target="_blank" href="https://app.juno.com.br/#/onboarding/320395:07fc5f">
			<img style="margin: 10px 0px 10px 0px;" src="'.$whmcs_url.'/modules/gateways/gofasjunopix/assets/img/logo.png"></a>
				
				<div style="margin-left: 10px;">
					<h4 style="padding-top: 5px;">Módulo Gofas Juno PIX para WHMCS v'.$module_version.'</h4>
					'.$available_update_message
				),
		'separator_1_a' => array(
			'Description' => '<h4>Credenciais de Produção (<i>Live</i>)</h4>',
		),
		// Secret Token
		'client_id' => array(
			'FriendlyName' => $opt_num++.'- Client ID<span class="gjp_required">*</span>',
			'Type' => 'text',
			'Size' => '50',
			'Default' => '',
			'Description' => '<span class="gjp_required">(Obrigatório)</span> Client ID | Produção',
		),
		'client_secret' => array(
			'FriendlyName' => $opt_num++.'- Client Secret<span class="gjp_required">*</span>',
			'Type' => 'text',
			'Size' => '50',
			'Default' => '',
			'Description' => '<span class="gjp_required">(Obrigatório)</span> Client Secret | Produção',
		),
		'private_token' => array(
			'FriendlyName' => $opt_num++.'- Token Privado<span class="gjp_required">*</span>',
			'Type' => 'text',
			'Size' => '50',
			'Default' => '',
			'Description' => '<span class="gjp_required">(Obrigatório)</span> Token Privado | Produção',
		),
		'key' => array(
			'FriendlyName' => $opt_num++.'- Chave Aleatória',
			'Type' => 'text',
			'Size' => '50',
			'Default' => '',
			'Description' => '<span class="gjp_optional">(Opcional)</span> Chave Aleatória de Endereçamento | Produção<br>Deixe em branco e o módulo criará uma nova chave ao gerar o primeiro QR Code.',
		),
		'separator_1_b' => array(
			'Description' => '<h4>Credenciais de Teste (<i>Sandbox</i>)</h4>',
		),
		// Sandbox Secret Token
		'sandbox_client_id' => array(
			'FriendlyName' => $opt_num++.'- Client ID<span class="gjp_required">*</span>',
			'Type' => 'text',
			'Size' => '50',
			'Default' => '',
			'Description' => '<span class="gjp_required">(Obrigatório)</span> Client ID | Testes',
		),
		// Sandbox Secret Token
		'sandbox_client_secret' => array(
			'FriendlyName' => $opt_num++.'- Client Secret<span class="gjp_required">*</span>',
			'Type' => 'text',
			'Size' => '50',
			'Default' => '',
			'Description' => '<span class="gjp_required">(Obrigatório)</span> Client Secret | Testes',
		),
		'sandbox_private_token' => array(
			'FriendlyName' => $opt_num++.'- Token Privado<span class="gjp_required">*</span>',
			'Type' => 'text',
			'Size' => '50',
			'Default' => '',
			'Description' => '<span class="gjp_required">(Obrigatório)</span> Token Privado | Testes',
		),
		'sandbox_key' => array(
			'FriendlyName' => $opt_num++.'- Chave Aleatória',
			'Type' => 'text',
			'Size' => '50',
			'Default' => '',
			'Description' => '<span class="gjp_optional">(Opcional)</span> Chave Aleatória de Endereçamento | Testes<br>Deixe em branco e o módulo criará uma nova chave ao gerar o primeiro QR Code.',
		),
		'admin' => array(
			'FriendlyName' => $opt_num++.'- Administrador do WHMCS<span class="gjp_required">*</span>',
			'Type'          => 'dropdown',
			'Default' 		=> key(reset($tbladmins)),
            'Options'       => $tbladmins,
			'Description' => 'Defina o administrador com permissões para utilizar a API interna do WHMCS.',
		),
		// Sandbox
		'sandbox' => array(
			'FriendlyName' => $opt_num++.'- <i>Sandbox</i>',
			'Type' => 'yesno',
			'Default' => 'yes',
			'Description' => 'Ative essa opção para gerar cobranças em modo de testes.',
		),
		// Log
		'log' => array(
			'FriendlyName' => $opt_num++.'- Salvar Logs',
			'Type' => 'yesno',
			'Default' => 'yes',
			'Description' => 'Acesse <a target="_blank" style="text-decoration: underline;" href="'.$admin_url.'/systemmodulelog.php">Utilitários > Logs > Log de Módulo</a> para ver as informações de diagnóstico salvas.',
		),
		// minimum amount
		'minimunamount' => array(
			'FriendlyName' => $opt_num++.'- Valor mínimo',
			'Type' => 'text',
			'Size' => '10',
			'Default' => '3.90',
			'Description' => 'Insira o valor total mínimo da fatura para permitir pagamento via PIX.<br>Formato: Decimal, separado por ponto. Maior ou igual a 0.01 e menor ou igual a 1000000.00.',
		),
		// top message
		'top_message' => array(
			'FriendlyName' => $opt_num++.'- Mensagem acima do código QR',
			'Type' => 'text',
			'Size' => '50',
			'Default' => 'Pague escaneando o QR code<br>ou copiando e colando a chave',
			'Description' => 'Permitido HTML',
		),
		// Logo
		'pix_logo' => array(
			'FriendlyName' => $opt_num++.'- Exibir Logo PIX',
			'Type' => 'yesno',
			'Default' => 'yes',
			'Description' => 'Exibe logotipo "PIX powered by Banco Central" na fatura, acima do <i>QR Code</i>',
		),
		// Data e hora
		'show_date' => array(
			'FriendlyName' => $opt_num++.'- Exibir data e hora do código QR',
			'Type' => 'yesno',
			'Default' => 'yes',
			'Description' => 'Exemplo: "Gerado em 08/01/2022 às 08:06:30"',
		),
		// Log
		'show_total' => array(
			'FriendlyName' => $opt_num++.'- Exibir valor total do código QR',
			'Type' => 'yesno',
			'Default' => 'yes',
			'Description' => 'Exemplo: "Total: R$ 24.800,00"',
		),
	);
	$footer = array('footer' => array(
			'Description' => '<div class="gjp_section">
			<p>&copy; '.date('Y').' <a style="text-decoration:underline;" target="_blank" title="↗ Gofas.net" href="https://gofas.net">Gofas.net</a> | <a style="text-decoration:underline;" target="_blank" title="↗ Gofas.net" href="https://gofas.net/?p=14128#changelog">Versão '.$module_version.'</a> | <a  style="text-decoration:underline;"target="_blank" title="↗ Documentação" href="https://gofas.net/?p=14128">Documentação</a> | <a style="text-decoration:underline;" target="_blank" title="↗ Fórum de Suporte" href="https://gofas.net/foruns/">Suporte</a>.</p>
			<p style="font-size: 11px;">
			Ao utilizar esse módulo você concorda com nosso <a style="text-decoration:underline;" target="_blank" title="↗ Contrato de licença de uso de software" href="https://gofas.net/?p=9340">contrato de licença de uso de software</a>.
			</p>
			'.$available_update_message.'
			</div>',
		),
	);
	return array_merge($renderize,$footer);
}