<?php

include_once(dirname(__FILE__) . "/wappi_classes/App/wappi.php");
include_once(dirname(__FILE__) . "/lang/portuguese-br.php");

//////////////////////////////////////////////////////////////////////////////////////////
// Gerencia sessoes //////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

use WHMCS\Session;

//////////////////////////////////////////////////////////////////////////////////////////
// API Carbon ////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

use Carbon\Carbon;

//////////////////////////////////////////////////////////////////////////////////////////
// API Laravel DataBase //////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

use WHMCS\Database\Capsule;

//////////////////////////////////////////////////////////////////////////////////////////

use wappi\App\Api\Cliente\Whatsapp;

//////////////////////////////////////////////////////////////////////////////////////////
// Modulo desenvolvido pela wappi /////////////////////////////////////////////////
// A venda e copia deste modulo sem nossa autorização e totalmente proibida! /////////////
// Versão: 1.0.5 /////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

if (!defined('WHMCS')) {
    exit('Acesso restrito - Power by www.souzahsot.com.br');
}

function whatsapp_config() {
    
    $query_origem_telefone = mysql_query("SELECT * FROM tblcustomfields");

    $Origem_Celular["select"]   =   'Campo padrão WHMCS,';

    while ($row = mysql_fetch_array($query_origem_telefone)) {

        $Array_Opcoes   =   [
            $row["id"]  =>  $row["fieldname"]  
        ];

    }
    

    //

    return [

        'name' => 'API Whatsapp',
        'description' => 'Modulo de integração com a API do whatsapp desenvolvido pela SouzaHost.',
        'version' => '1.0.0',
        'language' => 'portuguese-br',
        'author' => 'wappi',
        'premium' => true,
        'fields' => [
        
            'Addon_Whatsapp_URL' => [
                'FriendlyName' => 'URL de Conexão',
                'Type' => 'text',
                'Size' => '255',
                'Default' => '',
                'Description' => '',
            ],
            'Addon_Whatsapp_Sessao' => [
                'FriendlyName' => 'Sessão',
                'Type' => 'text',
                'Size' => '255',
                'Default' => '',
                'Description' => '',
            ],

            'Addon_Whatsapp_ApiKey' => [
                'FriendlyName' => 'API Key',
                'Type' => 'text',
                'Size' => '800',
                'Default' => '',
                'Description' => '',
            ],

            'Api_Whatsapp_Validacao_Whatsapp' => [
                'FriendlyName' => 'Validação do Número Whatsapp',
                'Type' => 'dropdown',
                'Options' => [
                    '0' =>  'Desabilitado',
                    '1' =>  'Habilitado'
                ],
                'Default' => '',
                'Description' => '<div class="alert alert-warning" role="alert" style="margin: 10px 0px 0px 0px;">
                    <strong>Desabilitado:</strong> O sistema não obrigara o usuário a válidar seu número para que as mensagens sejam enviadas.<br>
                    <strong>Habilitado:</strong> Quando habilitado será exibido uma tela de validação para que o cliente valide seu número "As mensagens só serão enviadas após a validação do número whatsapp".
                </div>',
            ],

            'Api_Whatsapp_Metodo_Envio' => [
                'FriendlyName' => 'Origem Número Whatsapp',
                'Type' => 'text',
                'Default' => 'Campo padrão WHMCS',
                'Description' => '<div class="alert alert-warning" role="alert" style="margin: 10px 0px 0px 0px;">
                    Informe o metodo de envio ao qual o sistema ira enviar as mensagens conforme descrito abaixo!<br>
                    Para enviar as mensagens usando o número de telefone padrão do WHMCS use: <strong>Campo padrão WHMCS</strong><br><br>
                    Para enviar as mensagens usando um campo custom informe o nome do campo exatamente como ele existe: <strong>EXEMPLO</strong> Você possui um campo custom no cadastro do cliente com nome "Telefone Celular" voce deve informar acima "Telefone Celular" desta forma o sistema localizara o número de telefone no campo custom.<br><br>
                    <a href="./configcustomfields.php" target="_blank" class="btn btn-primary">Ver lista de campo custom</a>
                </div>',
            ],

            'Api_Whatsapp_Assinatura' => [
                'FriendlyName' => 'Assinatura',
                'Type' => 'textarea',
                'Rows' => '4',
                'Cols' => '60',
                'Default' => '',
                'Description' => '<div class="alert alert-warning" role="alert" style="margin: 10px 0px 0px 0px;">
                    Template para envio da assinatura nas mensagens <strong>{Assinatura}</strong>
                </div>',
            ],

            'Api_Whatsapp_Msg_FinalizarAtendimento' => [
                'FriendlyName' => 'Finalizar Atendimento',
                'Type' => 'textarea',
                'Rows' => '6',
                'Cols' => '60',
                'Default' => 'Este atendimento foi finalizado com sucesso, caso necessite de ajuda é só nós chamar novamente.

HORÁRIOS DE ATENDIMENTO VIA WHATSAPP:

✅ Segunda a Sexta: das *08:00* às *18:00* hrs.
✅ Sábado das *8:00 as 13:00* hrs
❌ Domingo e Feriados: Não há atendimento.

Caso precise de ajuda fora destes horários por favor acesse nosso site e abra um ticket de suporte.

A *wappi* agradece o contato.

Site: *www.wappi.com.br*

Telefones de contato

*62 3142-5255* - Goiânia
*11 4210-6655* - São Paulo
*21 2042-0348* - Rio de Janeiro
*31 2342-0630* - Belo Horizonte',
                'Description' => '<div class="alert alert-warning" role="alert" style="margin: 10px 0px 0px 0px;">
                    Defina a mensagem que sera enviada ao cliente quando o atendimento for finalizado.
                </div>',
            ],


            'Api_Whatsapp_Msg_ForaHorario' => [
                'FriendlyName' => 'Fora Horário de Atendimento',
                'Type' => 'textarea',
                'Rows' => '6',
                'Cols' => '60',
                'Default' => 'No momento não estamos disponíveis para te atender, por favor acesse www.wappi.com.br e abra um ticket de suporte.',
                'Description' => '<div class="alert alert-warning" role="alert" style="margin: 10px 0px 0px 0px;">
                    Defina uma mensagem quando a fila estiver fora do horário de atendimento.
                </div>',
            ],

            'Api_Whatsapp_BotaoSite' => [
                'FriendlyName' => 'Botão Whatsapp Site',
                'Type' => 'dropdown',
                'Options' => [
                    '0' =>  'Desabilitado',
                    '1' =>  'Habilitado'
                ],
                'Description' => '<div class="alert alert-warning" role="alert" style="margin: 10px 0px 0px 0px;">
                    Adiciona um botão para contato diretamente para o whatsapp conectado a API, todo o conteúdo deste botão pode ser alterado no arquivo de idioma localizado na pasta lang dentro do addon.
                </div>',
            ],
			
			
			'Addon_Whatsapp_NumeroWhatsapp' => [
                'FriendlyName' => 'Número Whatsapp',
                'Type' => 'text',
                'Size' => '255',
                'Default' => '',
                'Description' => 'Informe o número whatsapp que sera usado no botão do site.',
            ],
            
        ]

    ];

}


function whatsapp_activate() {

    if (!Capsule::schema()->hasTable('api_whatsapp_configuracao')) {

        try {

            Capsule::schema()->create('api_whatsapp_configuracao', function ($table) {
                $table->increments('id');
                $table->string('Nome_Modulo');
                $table->string('versao');
            });

            Capsule::table('api_whatsapp_configuracao')->insert([
                "Nome_Modulo"   =>  "Wappi_Whatsapp",
                "versao"    =>  '1.0.5'
            ]);
    
        } catch (\Exception $e) {
    
            echo "Unable to create api_whatsapp_template_mensagens: {$e->getMessage()}";
    
        }

    }

    ////////////////////////////////////////////////////////////////////////
    // Cria a Tabela do sistema - Template Mensagens ///////////////////////
    ////////////////////////////////////////////////////////////////////////

    if (!Capsule::schema()->hasTable('api_whatsapp_template_mensagens')) {

        try {

            Capsule::schema()->create('api_whatsapp_template_mensagens', function ($table) {
                $table->increments('id');
                $table->string('titulo', (int)6000);
                $table->string('corpo', (int)6000);
                $table->integer('status');
            });
    
        } catch (\Exception $e) {
    
            echo "Unable to create api_whatsapp_template_mensagens: {$e->getMessage()}";
    
        }

    }

    ////////////////////////////////////////////////////////////////////////
    // Cria a Tabela do sistema - validação ////////////////////////////////
    ////////////////////////////////////////////////////////////////////////

    if (!Capsule::schema()->hasTable('api_whatsapp_validacao_whatsapp')) {

        try {

            Capsule::schema()->create('api_whatsapp_validacao_whatsapp',function ($table) {
                $table->increments('id');
                $table->integer('ID_CLIENTE_WHMCS');
                $table->string('NUMERO_WHATSAPP');
                $table->string('CODIGO_VALIDACAO');
                $table->integer('status');
            });
    
        } catch (\Exception $e) {
    
            echo "Unable to create api_whatsapp_validacao_whatsapp: {$e->getMessage()}";
    
        }

    }

    // Logs

    if (!Capsule::schema()->hasTable('api_whatsapp_logs')) {

        try {

            Capsule::schema()->create('api_whatsapp_logs', function($table) {
                
                $table->increments('id');
                $table->string('Log',(int)4000);
                $table->datetime('Data');

            });
            
        } catch (ExceptionA $e) {

            $error .= "Não foi possível criar tabela no banco de dados: {$e->getMessage()}";
            
        }

    }

    // Robô auto atendimento

    if (!Capsule::schema()->hasTable('api_whatsapp_robo')) {

        try {

            Capsule::schema()->create('api_whatsapp_robo', function($table) {
                
                $table->increments('id');
                $table->string('Titulo',(int)4000);
                $table->string('Texto_Pricipal',(int)6000);
                $table->string('Fila_Atendimento',(int)6000);
                $table->datetime('Data');

            });
            
        } catch (ExceptionA $e) {

            $error .= "Não foi possível criar tabela no banco de dados: {$e->getMessage()}";
            
        }

    }

    if (!Capsule::schema()->hasTable('api_whatsapp_robo_horario')) {

        try {

            Capsule::schema()->create('api_whatsapp_robo_horario', function($table) {
                
                $table->increments('id');
                $table->string('Robo_ID');
                $table->string('Dia_Semana');
                $table->string('Hora_Inicio');
                $table->string('Hora_Fim');
                $table->string('Mensagem_ForaHorario');
                $table->string('status');

            });
            
        } catch (ExceptionA $e) {

            $error .= "Não foi possível criar tabela no banco de dados: {$e->getMessage()}";
            
        }

    }

    if (!Capsule::schema()->hasTable('api_whatsapp_filaatendimento')) {

        try {

            Capsule::schema()->create('api_whatsapp_filaatendimento', function($table) {
                
                $table->increments('id');
                $table->string('Fila',(int)4000);
                $table->string('Usuarios',(int)6000);
                $table->integer('status');

            });
            
        } catch (ExceptionA $e) {

            $error .= "Não foi possível criar tabela no banco de dados: {$e->getMessage()}";
            
        }

    }

    // Mensagem

    if (!Capsule::schema()->hasTable('api_whatsapp_chat')) {
        
        try {

            Capsule::schema()->create('api_whatsapp_chat',function ($table) {
                $table->increments('id');
                $table->string('ticket');
                $table->string('send_id');
                $table->string('recev_id');
                $table->string('departamento');
                $table->string('funcionario');
                $table->string('foto_cliente_sessao');
                $table->string('notificado');
                $table->integer('status');
            });

        } catch (\Exception $e) {

            echo "Unable to create api_whatsapp_chat: {$e->getMessage()}";

        }

    }

    if (!Capsule::schema()->hasTable('api_whatsapp_mensagens_chat')) {
        
        try {

            Capsule::schema()->create('api_whatsapp_mensagens_chat',function ($table) {
                $table->increments('id');
                $table->string('id_mensagem');
                $table->string('ticket');
                $table->string('send_id');
                $table->string('recev_id');
                $table->string('nome_funcionario');
                $table->longText('mensagem');
                $table->datetime('data');
                $table->string('id_mensagem_resposta');
                $table->string('tipo_msg');
                $table->string('arquivo_name');
                $table->integer('status');
            });

        } catch (\Exception $e) {

            echo "Unable to create api_whatsapp_chat: {$e->getMessage()}";

        }

    }


    if (!Capsule::schema()->hasTable('api_whatsapp_mensagens_rapidas')) {
        
        try {

            Capsule::schema()->create('api_whatsapp_mensagens_rapidas',function ($table) {
                $table->increments('id');
                $table->string('titulo');
                $table->longText('mensagem');
                $table->string('status');
            });

        } catch (\Exception $e) {

            echo "Unable to create api_whatsapp_chat: {$e->getMessage()}";

        }

    }

    if (!Capsule::schema()->hasTable('api_whatsapp_fila_envio')) {
        
        try {

            Capsule::schema()->create('api_whatsapp_fila_envio',function ($table) {
                $table->increments('id');
                $table->string('numero');
                $table->string('tipo_msg');
                $table->longText('mensagem');
                $table->string('arquivo');
                $table->datetime('data_envio');
                $table->string('status');
            });

        } catch (\Exception $e) {

            echo "Unable to create api_whatsapp_chat: {$e->getMessage()}";

        }

    }


    $tabelas = [
        'api_whatsapp_template_mensagens',
        'api_whatsapp_validacao_whatsapp',
        'api_whatsapp_chat',
        'api_whatsapp_logs',
        'api_whatsapp_mensagens_chat'
    ];

    foreach($tabelas as $tabela) {

        $changeCollationQuery = "ALTER TABLE $tabela CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_bin";

        mysql_query($changeCollationQuery);

    }

    // Adiciona as msgs na tabela api_whatsapp_template_mensagens
    try {
        Capsule::connection()->transaction(
            function ($connectionManager)
            {

                // Mensagens

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Validação Número Whatsapp',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?

Use o código *{Codigo_Validacao}* em nosso site para validar sua conta.

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Cadastro Novo Cliente',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?

Seja bem vindo à {Nome_Empresa}!

Primeiramente gostaríamos de agradecer a preferência por nossa empresa. Muito obrigado! Faremos o possível para lhe oferecer um excelente atendimento.

Acesso a Central do Cliente

Você pode acessar nossa central do cliente: {Dominio_WHMCS}

Basta entrar com seu e-mail e senha escolhido na contratação, caso tenha esquecido a senha por favor clique em esqueci minha senha

Se você não criou a conta, provavelmente um de nossos atendentes deve ter criado pra você por conta de um pedido via WhatsApp ou e-mail, de qualquer forma, esta mensagem apenas confirma que você está cadastrado e pode acessar nossa central quando precisar.

{Assinatura}',
                        'status' => 0,
                    ]
                );
            
                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Alteração de Senha',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?
Sua senha acabou de ser alterada! Caso não tenha sido você que tenha alterado a senha, pedimos que entre em contato conosco o mais rápido possível!

Nova senha: {NovaSenha}

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Fatura Criada',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?
Estamos passando para te lembrar que a fatura de número #{NumeroFatura} criada no dia {DataCriacaoFatura} esta disponível para pagamento!

ID da Fatura: #{NumeroFatura}
Valor da Fatura: {ValordaFatura}
Data de Vencimento: {DataVencimentoFatura}

Para visualizar esta fatura acesse {Dominio_WHMCS}/viewinvoice.php?id={NumeroFatura}

{Assinatura}',
                        'status' => 0,
                    ]
                );


                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Lembrete de Vencimento',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?
Estamos passando para te lembrar que a fatura de número #{NumeroFatura} criada no dia {DataCriacaoFatura} esta disponível para pagamento!

ID da Fatura: #{NumeroFatura}
Valor da Fatura: {ValordaFatura}
Data de Vencimento: {DataVencimentoFatura}

Para visualizar esta fatura acesse {Dominio_WHMCS}/viewinvoice.php?id={NumeroFatura}

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Confirmação de Pagamento',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?
A wappi vem por meio desta informar que recebemos o pagamento da fatura de nº #{NumeroFatura} no valor de {ValordaFatura}.

ATENÇÃO: Caso o pagamento tenha sido feito por Cartão de Crédito ou Cartão de Debito constará no extrato do seu cartão como {Nome_Empresa} o valor referente ao pagamento da(s) parcela(s) da sua fatura #{NumeroFatura} na {Nome_Empresa}. Isso ocorre pois a PAYPAL é a responsável pela intermediação do pagamento ou seja será um pagamento válido e autorizado!

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Cancelamento de Fatura',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?
A fatura de número #{NumeroFatura} no valor de {ValordaFatura} foi cancelada com sucesso!

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Suspensão de Serviço',
                        'corpo' => 'Olá {NomeCliente} tudo bem? 
Infelizmente o serviço abaixo acabou de ser suspenso! Pedimos que entre em contato conosco o mais rápido possível para resolver este problema! 

Serviço: {NomeProduto} 
Domínio: {Dominio}

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Reativação do Serviço',
                        'corpo' => 'Olá {NomeCliente} tudo bem? 
Que legal o serviço abaixo acabou de ser reativado!

Serviço: {NomeProduto} 
Domínio: {Dominio}

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Abertura de Ticket',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?
Você acabou de abrir um chamado em nosso site! Estou passando pra te avisar que normalmente os chamados estão sendo respondidos em {TempoResposta}, cálculo obtido entre a média do tempo de reposta entre os chamados abertos/respondidos.

Titulo do Chamado: {TituloChamado}
ID do Chamado: #{IdChamado}
Departamento: {DepartamentoChamado}
Prioridade: {PrioridadeChamado}

Para visualizar este chamado acesse {Dominio_WHMCS}/viewticket.php?tid={IdChamado}&c={KeyChamado}

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Resposta do Ticket',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?
O chamado abaixo acabou de ser atualizado pela nossa equipe!

ID do Chamado: #{IdChamado}
Titulo do Chamado: {TituloChamado}
Funcionário Responsável: {ResponsavelChamado}

Para visualizar este chamado acesse {Dominio_WHMCS}/viewticket.php?tid={IdChamado}&c={KeyChamado}

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Fechar Ticket',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?
O chamado abaixo acabou de ser marcado como resolvido!

ID do Chamado: #{IdChamado}
Titulo do Chamado: {TituloChamado}

Para visualizar este chamado acesse {Dominio_WHMCS}/viewticket.php?tid={IdChamado}&c={KeyChamado}

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Ativação de Serviço [ Hospedagem de Site ]',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?
Estamos felizes em poder atender suas necessidades e pela oportunidade de fazê-lo satisfeito. Sua confiança é importante para nós e por isso agradecemos profundamente.
Saiba que a nossa missão é sempre corresponder com as suas expectativas, através de um trabalho cuidadoso e de qualidade.
Conte sempre com os nossos serviços e não hesite em nos procurar para qualquer coisa.
Muito Obrigado Cliente e Parceiro. 

Segue abaixo dados de acesso ao seu produto

Produto: {NomeProduto}
Domínio: {Dominio}
Nome de usuário: {Username}
Senha: {Senha}

Os demais dados de acesso foram enviados para seu e-mail de cadastro.

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Ativação de Serviço [ Revenda de Hospedagem ]',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?
Estamos felizes em poder atender suas necessidades e pela oportunidade de fazê-lo satisfeito. Sua confiança é importante para nós e por isso agradecemos profundamente.
Saiba que a nossa missão é sempre corresponder com as suas expectativas, através de um trabalho cuidadoso e de qualidade.
Conte sempre com os nossos serviços e não hesite em nos procurar para qualquer coisa.
Muito Obrigado Cliente e Parceiro. 

Segue abaixo dados de acesso ao seu produto

Produto: {NomeProduto}
Domínio: {Dominio}
Nome de usuário: {Username}
Senha: {Senha}

Os demais dados de acesso foram enviados para seu e-mail de cadastro.

{Assinatura}',
                        'status' => 0,
                    ]
                );


                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Ativação de Serviço [ VPS / Dedicado ]',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?
Estamos felizes em poder atender suas necessidades e pela oportunidade de fazê-lo satisfeito. Sua confiança é importante para nós e por isso agradecemos profundamente.
Saiba que a nossa missão é sempre corresponder com as suas expectativas, através de um trabalho cuidadoso e de qualidade.
Conte sempre com os nossos serviços e não hesite em nos procurar para qualquer coisa.
Muito Obrigado Cliente e Parceiro. 

Segue abaixo dados de acesso ao seu produto

Produto: {NomeProduto}
Domínio: {Dominio}
Nome de usuário: {Username}
Senha: {Senha}

Os demais dados de acesso foram enviados para seu e-mail de cadastro.

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Ativação de Serviço [ Outros ]',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?
Estamos felizes em poder atender suas necessidades e pela oportunidade de fazê-lo satisfeito. Sua confiança é importante para nós e por isso agradecemos profundamente.
Saiba que a nossa missão é sempre corresponder com as suas expectativas, através de um trabalho cuidadoso e de qualidade.
Conte sempre com os nossos serviços e não hesite em nos procurar para qualquer coisa.
Muito Obrigado Cliente e Parceiro. 

Segue abaixo dados de acesso ao seu produto

Produto: {NomeProduto}
Domínio: {Dominio}
Nome de usuário: {Username}
Senha: {Senha}

Os demais dados de acesso foram enviados para seu e-mail de cadastro.

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Serviço Cancelado',
                        'corpo' => 'Olá {NomeCliente}, tudo bem?

O serviço {NomeProduto} foi cancelado com sucesso. 
Se você acha que isso e um erro por favor entre em contato conosco o mais rápido possível.
                        
{Assinatura}',
                        'status' => 0,
                    ]
                );


                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Enviar Cotação',
                        'corpo' => 'Olá {NomeCliente}, como vai?

Conforme solicitado, fazemos uso do presente para encaminhar o link do orçamento dos produtos (ou serviços) requisitados.

Orçamento de número: *#{Numero_Cotacao}* 
Link do Orçamento: {Dominio_WHMCS}/viewquote.php?id={Numero_Cotacao}

Nos colocamos à disposição para qualquer esclarecimento que se fizer necessário e esperamos poder concretizar o pedido brevemente.

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Alteração Status Cotação',
                        'corpo' => 'Olá {NomeCliente}, como vai?
A cotação de número {Numero_Cotacao} teve seu status alterado para {Status_Cotacao}, use o link  {Dominio_WHMCS}/viewquote.php?id={Numero_Cotacao} para visualizar esta cotação.

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Cotação Aceita',
                        'corpo' => 'Olá {NomeCliente}, como vai?
Notamos que você acabou de aceitar a cotação de número *#{Numero_Cotacao}*! 

Nossa equipe comercial já esta providenciando e organizando seu pedido, em breve você recebera um contato de nossa equipe.

Gratos pela confiabilidade e solicitação de nossos produtos.

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Solicitação Cancelamento',
                        'corpo' => 'Olá {NomeCliente}, como vai?
Recebemos um pedido de cancelamento do serviço de ID #{ID_Servico}, gostaríamos de entender melhor o motivo desta solicitação.

Segue detalhamento da solicitação:

ID Serviço: *{ID_Servico}*
Tipo: *{Tipo}*
Razão: *{Rasao_Cancelamento}*

{Assinatura}',
                        'status' => 0,
                    ]
                );

                $connectionManager->table('api_whatsapp_template_mensagens')->insert(
                    [
                        'titulo' => 'Menu de Atendimento',
                        'corpo' => 'Olá tudo bem?
Seja bem vindo(a) ao atendimento da wappi, para darmos inicio ao seu atendimento escolha uma das opções abaixo. ',
                        'status' => 0,
                    ]
                );


            }
        );
    } catch (\Exception $e) {
        echo "Uh oh! Inserting didn't work, but I was able to rollback. {$e->getMessage()}";
    }

    return array('status'=>'success','description'=>'Módulo API Whatsapp ativado com sucesso!');
    return array('status'=>'error','description'=>'Não foi possível ativar o módulo API Whatsapp por causa de um erro desconhecido');

}


function whatsapp_output($vars) {

    $URL_API    =   $vars["Addon_Whatsapp_URL"];
    $SESSAO_API =   $vars["Addon_Whatsapp_Sessao"];
    $APIKEY     =   $vars["Addon_Whatsapp_ApiKey"];

    $ACESSO_PERMITIDO_NIVELADMINN   =   $vars["access"]; // 1,2,3 (1 = FULL ADMIN)

    $wappi   =   (new Whatsapp($URL_API,$SESSAO_API,$APIKEY));

    $Permissao_NIVELADMIN   =   Capsule::table('tbladmins')->WHERE([ ['id',$_SESSION["adminid"]],["roleid","1"] ])->get();

    // CSS e Javascript
    echo '<link href="../modules/addons/whatsapp/templates/css/wappi.css" type="text/css" rel="stylesheet" />

    <script type="text/javascript" src="../modules/addons/whatsapp/templates/javascript/send_sound.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/FileSaver.js/2.0.5/FileSaver.min.js"></script>

    <script>
        $(document).ready(function(){
            
            $(\'#templates_Mensagens\').DataTable({
                "order": [[ 0, "desc" ]],
                "className": "mdl-data-table__cell--non-numeric",
                "language": {
                    "lengthMenu": "Mostrando _MENU_ registros por página",
                    "zeroRecords": "Nada encontrado",
                    "info": "Mostrando página _PAGE_ de _PAGES_",
                    "infoEmpty": "Nenhum registro disponível",
                    "infoFiltered": "(filtrado de _MAX_ registros no total)",
                }
            }),
            
            $(\'#templates_MsgRapidas\').DataTable({
                "order": [[ 0, "desc" ]],
                "className": "mdl-data-table__cell--non-numeric",
                "language": {
                    "lengthMenu": "Mostrando _MENU_ registros por página",
                    "zeroRecords": "Nada encontrado",
                    "info": "Mostrando página _PAGE_ de _PAGES_",
                    "infoEmpty": "Nenhum registro disponível",
                    "infoFiltered": "(filtrado de _MAX_ registros no total)",
                }
            });

        });

        jQuery(document).ready(function() {

            var table = jQuery(\'#TabelaProcurarLog\').show().DataTable();         
    
            table.order([0, \'desc\']);
            table.draw();

            jQuery(\'#Log_Carregando\').hide();

        });


        jQuery(document).ready(function() {

            var table = jQuery(\'#TabelaRelatorio_Atendimento\').show().DataTable();         
    
            table.order([0, \'desc\']);
            table.draw();

            jQuery(\'#RelatorioMsgEnviadas_Carregando\').hide();

        });


        


        jQuery(document).ready(function() {

            var table = jQuery(\'#templates_MsgRapidas\').show().DataTable();         
    
            table.order([0, \'desc\']);
            table.draw();

            jQuery(\'#Log_templates_MsgRapidas\').hide();

        });


        jQuery(document).ready(function() {

            var table = jQuery(\'#templates_MensagensRapidasModal\').show().DataTable();         
    
            table.order([0, \'desc\']);
            table.draw();

            jQuery(\'#Log_templates_MsgRapidasModal\').hide();

        });
        
    </script>';

    if(($_GET["acao"] == "deletarFila")) {
        
        $Fila_Deletar   =   Capsule::table('api_whatsapp_filaatendimento')->WHERE("id",$_GET["id"])->get();

        try {
            
            Capsule::table('api_whatsapp_robo_horario')->WHERE("Robo_ID",$Fila_Deletar[0]->Fila)->delete();
            
            Capsule::table('api_whatsapp_filaatendimento')->WHERE("id",$_GET["id"])->delete();

            echo '<div class="alert alert-secondary" role="alert">
                Fila deletada com sucesso.
            </div>';

            echo '<script>

                $(document).ready(function() {

                        window.location = "./addonmodules.php?module=whatsapp"; 
                });

            </script>';
            
        } catch (\Throwable $th) {
            
            echo '<div class="alert alert-danger" role="alert">
                Ops não foi possivel deletar a fila de atendimento.
            </div>';

            echo '<script>

                $(document).ready(function() {

                        window.location = "./addonmodules.php?module=whatsapp"; 
                });

            </script>';
            
        }

    }

    if(($_GET["acao"] == "deletarMsgRapida")) {

        try {
            
            Capsule::table('api_whatsapp_mensagens_rapidas')->WHERE("id",$_GET["id"])->delete();
            
            echo '<div class="alert alert-secondary" role="alert">
                Mensagem rapida deletada com sucesso.
            </div>';

            echo '<script>

                $(document).ready(function() {

                        window.location = "./addonmodules.php?module=whatsapp"; 
                });

            </script>';
            
        } catch (\Throwable $th) {
            
            echo '<div class="alert alert-danger" role="alert">
                Ops não foi possivel deletar a mensagem rapida.
            </div>';

            echo '<script>

                $(document).ready(function() {

                        window.location = "./addonmodules.php?module=whatsapp"; 
                });

            </script>';
            
        }

    }

    // Conteudo

    echo '<div class="conteudo_Wappi_Addon" id="wappi_sac">

        <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">

            <li class="nav-item"><a class="nav-link" id="Wappi_Atendimento-tab" data-toggle="pill" href="#Wappi_Atendimento" role="tab" aria-controls="Wappi_Atendimento" aria-selected="false"><i class="fal fa-comment-lines" style="margin-right: 5px"></i> ' . MENU_01 . '</a></li>
            
            ' . ($Permissao_NIVELADMIN[0] != NULL ? '<li class="nav-item active"><a class="nav-link" id="Wappi_TemplatesMensagens-tab" data-toggle="pill" href="#Wappi_TemplatesMensagens" role="tab" aria-controls="Wappi_TemplatesMensagens" aria-selected="false"><i class="fal fa-theater-masks" style="margin-right: 5px"></i> ' . MENU_02 . '</a></li>' : '') . '
            ' . ($Permissao_NIVELADMIN[0] != NULL ? '<li class="nav-item"><a class="nav-link" id="Wappi_Robo-tab" data-toggle="pill" href="#Wappi_Robo" role="tab" aria-controls="Wappi_Robo" aria-selected="false"><i class="fal fa-crown" style="margin-right: 5px"></i> ' . MENU_03 . '</a></li>' : '') . '
            ' . ($Permissao_NIVELADMIN[0] != NULL ? '<li class="nav-item"><a class="nav-link" id="Wappi_Msg_Rapidas-tab" data-toggle="pill" href="#Wappi_Msg_Rapidas" role="tab" aria-controls="Wappi_Msg_Rapidas" aria-selected="false"><i class="fal fa-fighter-jet" style="margin-right: 5px"></i> ' . MENU_04 . '</a></li>' : '') . '
            ' . ($Permissao_NIVELADMIN[0] != NULL ? '<li class="nav-item"><a class="nav-link" id="Wappi_Relatorio_Atendimento-tab" data-toggle="pill" href="#Wappi_Relatorio_Atendimento" role="tab" aria-controls="Wappi_Relatorio_Atendimento" aria-selected="false"><i class="fal fa-file-chart-line" style="margin-right: 5px"></i> ' . MENU_07 . '</a></li>' : '') . '
            ' . ($Permissao_NIVELADMIN[0] != NULL ? '<li class="nav-item"><a class="nav-link" id="Wappi_RelatorioLogs-tab" data-toggle="pill" href="#Wappi_RelatorioLogs" role="tab" aria-controls="Wappi_RelatorioLogs" aria-selected="false" style="margin-right: 5px"><i class="fal fa-box-check"></i> ' . MENU_05 . '</a></li>' : '') . '

            <script>

                var elem    =   document.getElementById("wappi_sac");

                function openFullscreen() {
                    if (elem.requestFullscreen) {
                        elem.requestFullscreen();
                    } else if (elem.webkitRequestFullscreen) { /* Safari */
                        elem.webkitRequestFullscreen();
                    } else if (elem.msRequestFullscreen) { /* IE11 */
                        elem.msRequestFullscreen();
                    }

                    $("#FULL_SCREEN").hide();
                    $("#FULL_SCREEN_CLOSE").show();

                }
                
                function closeFullscreen() {
                    if (document.exitFullscreen) {
                        document.exitFullscreen();
                    } else if (document.webkitExitFullscreen) { /* Safari */
                        document.webkitExitFullscreen();
                    } else if (document.msExitFullscreen) { /* IE11 */
                        document.msExitFullscreen();
                    }

                    $("#FULL_SCREEN").show();
                    $("#FULL_SCREEN_CLOSE").hide();
                    
                }

            </script>

            <button type="button" id="FULL_SCREEN" onclick="openFullscreen();" class="btn btn-primary" class="nav-item" style="float:right; margin-right: 0px" data-toggle="tooltip" data-placement="left" title="" data-original-title="ATIVAR Full Screen">
                <i class="fas fa-compress"></i>
            </button>

            <button type="button" id="FULL_SCREEN_CLOSE" onclick="closeFullscreen();" class="btn btn-danger" class="nav-item" style="display:none; float:right; margin-right: 0px" data-toggle="tooltip" data-placement="left" title="" data-original-title="DESATIVAR Full Screen">
                <i class="fas fa-compress"></i>
            </button>
            
        </ul>

        <div class="tab-content Wappi_Conteudo">

            <div class="tab-pane fade" id="Wappi_Atendimento" role="tabpanel" aria-labelledby="Wappi_Atendimento">

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item active" aria-current="page">WHMCS</li>
                        <li class="breadcrumb-item active" aria-current="page">Addons</li>
                        <li class="breadcrumb-item active" aria-current="page">API Whatsapp</li>
                        <li class="breadcrumb-item active" aria-current="page">' . MENU_01 . '</li>
                    </ol>
                </nav>

                <script>

                    $(document).ready(function() {
                                        
                        $("#buscar_cliente_Btn").on("click", function() {

                            var BucarCliente    =   $("#buscar_cliente").val();

                            $("#div_carregando_newTicket").show();
                            $("#resultado_find_Cliente").hide();

                            $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php",{
                                buscarCliente: true,
                                cliente: BucarCliente
                            },
                            function(data, status) {
                                $("#resultado_find_Cliente").show();
                                $("#resultado_find_Cliente").html(data);
                                $("#div_carregando_newTicket").hide();
                            });

                        });

                    });

                    $(document).ready(function() {
                                    
                        $("#buscar_atendimento_finalizado").on("input", function() {

                            var BuscarNumero    =   $(this).val();

                            $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php",{
                                buscarNumeroPost: true,
                                numero: BuscarNumero
                            },
                            function(data, status) {
                                $("#lista_chats_finalizado").html(data);
                            });

                        });

                    });

                    $(document).ready(function() {
                                
                        $("#buscar_atendimento_finnalizado_Btn").on("click", function() {

                            var BuscarNumero    =   $("#buscar_atendimento").val();

                            $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php",{
                                buscarNumeroPost: true,
                                numero: BuscarNumero
                            },
                            function(data, status) {
                                $("#lista_chats_finalizado").html(data);
                            });

                        });

                    });

                    $(document).ready(function() {
                                
                        $("#buscar_atendimento").on("input", function() {

                            var BuscarNumero    =   $(this).val();

                            $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php",{
                                buscarNumeroPost: true,
                                numero: BuscarNumero
                            },
                            function(data, status) {
                                $("#lista_chats").html(data);
                            });

                        });

                    });


                    $(document).ready(function() {
                                
                        $("#buscar_atendimento_Btn").on("click", function() {

                            var BuscarNumero    =   $("#buscar_atendimento").val();

                            $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php",{
                                buscarNumeroPost: true,
                                numero: BuscarNumero
                            },
                            function(data, status) {
                                $("#lista_chats").html(data);
                            });

                        });

                    });

                    $(document).ready(function() {

                        let updateFila  =   function() {

                            $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php",{
                                lista_chat: true,
                                in_chat: "' . $_GET["chat"] . '"
                            },
                            function(data, status) {
                                $("#lista_chats").html(data);
                            });

                        }

                        updateFila();

                        /** Intervalo para atualização **/

                        setInterval(updateFila, 10000);

                    });

                </script>

                <script>

                    /* Send Mensagem */

                    $(document).ready(function() {

                        $("#sendMsg").on(\'click\', function() {

                            message = $("#message").val();

                            if (message == "") return;

                            $("#message").prop(\'disabled\', true);
                            $("#sendMsg").prop(\'disabled\', true);

                            $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php", { message: message, id_chat: "' . $_GET["chat"] . '" },

                                function(data,status){

                                    $("#message").val("");
                                    $("#mensagens_chat").append(data);

                                    $("#message").prop(\'disabled\', false);
                                    $("#sendMsg").prop(\'disabled\', false);

                                    $("#message").focus();
                                    
                                });

                        });

                    });
                </script>



                <script>

                    let fechData    =   function() {

                        $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php", 
                        {
                            acao: "atualizarChatSozinho",
                            id_chat: "' . $_GET["chat"] . '"
                        },
                        function(data,status){

                            $("#mensagens_chat").append(data);
                            
                        });
                    
                    }

                    /** Intervalo para atualização **/

                    setInterval(fechData, 2000);

                </script>


                <script>

                $(document).ready(function() {

                    var scrollDown = function() {

                        $("#mensagens_chat").animate({

                            scrollTop: 100000000000000000000

                        }, 50);

                    }

                    scrollDown();

                });

                </script>


                <div class="chat">    

                    <!-- Left -->
                    <nav class="left">

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb" style="margin-bottom: 8px; overflow: hidden;">
                                <li class="breadcrumb-item active" aria-current="page" style="float: left; width: max-content; padding: 20px !important; margin: 0 !important; line-height: 0 !important;">' . TITULO_01 . '</li>


                                <button id="newTicketBtn"><i class="fal fa-plus-circle"></i> Novo</button>

                                <!-- The Modal -->
                                <div id="newTicket" class="modal_mm">

                                    <div class="modal-content_mm">

                                        <span class="close_new_atendimento">&times;</span>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb" style="margin-bottom: 8px;">
                                                <li class="breadcrumb-item active" aria-current="page" style="padding: 20px !important; margin: 0 !important; line-height: 0 !important; text-align: center !important;">
                                                    <i class="fal fa-plus-circle" style="margin-right: 5px;"></i> Iniciar novo atendimento
                                                </li>
                                            </ol>
                                        </nav>

                                        <div class="buscar">
                                            <input type="text" id="buscar_cliente" placeholder="Nome do Cliente">
                                            <button class="btn btn-primary" id="buscar_cliente_Btn"><i class="far fa-search"></i></button>
                                        </div>

                                        <div id="div_carregando_newTicket" style="display: none; text-align: center;">
                                            <img src="../modules/addons/whatsapp/templates/imagens/loading.svg" style="padding: 34px;">
                                        </div>

                                        <div id="resultado_find_Cliente" style="max-height: 400px; overflow: auto;">

                                            <div class="alert alert-warning" role="alert">
                                                Informe o nome do cliente acima para iniciar a busca.
                                            </div>
                                        
                                        </div>

                                    </div>

                                </div>

                                <script>
                                    // Get the modal
                                    var modalNewTicket = document.getElementById("newTicket");

                                    // Get the button that opens the modal
                                    var btnNewTicket = document.getElementById("newTicketBtn");

                                    // Get the <span> element that closes the modal
                                    var spanNewTicket = document.getElementsByClassName("close_new_atendimento")[0];

                                    // When the user clicks the button, open the modal 
                                    btnNewTicket.onclick = function() {
                                        modalNewTicket.style.display = "block";
                                    }

                                    // When the user clicks on <span> (x), close the modal
                                    spanNewTicket.onclick = function() {
                                        modalNewTicket.style.display = "none";
                                    }

                                    // When the user clicks anywhere outside of the modal, close it
                                    window.onclick = function(event) {
                                        if (event.target == modalNewTicket) {
                                            modalNewTicket.style.display = "none";
                                        }
                                    }
                                </script>

                            </ol>
                        </nav>

                        <ul class="tipo_pagina_atendimento nav nav-pills mb-3" id="pills-tab" role="tablist">
                        
                            <li class="nav-item active"><a class="nav-link" id="Wappi_Atendimento_Ativo-tab" data-toggle="pill" href="#Wappi_Atendimento_Ativo" role="tab" aria-controls="Wappi_Atendimento_Ativo" aria-selected="false"><i class="fal fa-clipboard-user"></i> ' . BOTAO_ATENDENDO . '</a></li>
                            <li class="nav-item"><a class="nav-link" id="Wappi_Atendimento_Resolvido-tab" data-toggle="pill" href="#Wappi_Atendimento_Resolvido" role="tab" aria-controls="Wappi_Atendimento_Resolvido" aria-selected="false"><i class="fal fa-box-check"></i> ' . BOTAO_RESOLVIDO . '</a></li>

                        </ul>

                        <div class="tab-content">

                            <div class="tab-pane fade active in" id="Wappi_Atendimento_Ativo" role="tabpanel" aria-labelledby="Wappi_Atendimento_Ativo">
                            
                                <div class="buscar">
                                    <input type="text" id="buscar_atendimento" placeholder="' . INPUT_BUSCAR . '">
                                    <button class="btn btn-primary" id="buscar_atendimento_Btn"><i class="far fa-search"></i></button>
                                </div>

                                <div id="lista_chats">';

                                    $sessao_admin   =   $_SESSION["adminid"];

                                    $chat = 0;

                                    $Query_Chats_left   =   'SELECT * FROM api_whatsapp_chat ORDER BY id DESC';

                                    $Query_Chats_left_Exec =   mysql_query($Query_Chats_left);

                                    $Query_Chats_leftCount =   mysql_query("SELECT * FROM api_whatsapp_chat");
                                    $Query_Chats_leftCount_rows = mysql_num_rows($Query_Chats_leftCount);

                                    while ($dados = mysql_fetch_array($Query_Chats_left_Exec)) {

                                        $Query_New_MsgCount =   mysql_query("SELECT * FROM api_whatsapp_mensagens_chat WHERE ticket = '" . $dados["ticket"] . "' AND status = '0'");
                                        $Query_New_MsgCount_rows = mysql_num_rows($Query_New_MsgCount);

                                        $ID_Chat_Ticket = $_GET["chat"];


                                        if(($sessao_admin == $dados["funcionario"]) || ($dados["status"] == "0")) {

                                            if(($dados["status"] != "3")) {

                                                foreach (Capsule::table('api_whatsapp_filaatendimento')->WHERE('Fila',$dados["departamento"])->get() as $value) {

                                                    $Usuarios_Permitidos    =   explode(",",$value->Usuarios);
                                    
                                                    foreach ($Usuarios_Permitidos as $key => $values) {
                                    
                                                        if(($values == $_SESSION["adminid"])) {
                                    
                                                            if(($dados["notificado"] < 1)) {
                                    
                                                                echo '<audio controls autoplay style="display:none;">
                                                                    <source src="../modules/addons/whatsapp/templates/audios/notificacao.mp3" type="audio/mpeg">
                                                                </audio>';
                                    
                                                                /*
                                                                Capsule::table('api_whatsapp_chat')->WHERE('ticket',$dados["ticket"])->update([
                                                                    "notificado"    =>   "1"
                                                                ]);
                                                                */
                                    
                                                            }
                                    
                                                            echo '<script>
                                    
                                                                $(document).ready(function() {
                                    
                                                                    $("#aceitarAtendimento_' . $dados["ticket"] . '").on("click", function() {
                                    
                                                                        var $this = $(this);
                                                                        $this.button("loading");
                                    
                                                                        setTimeout(function() {
                                                                            $this.button("reset"); 
                                                                        }, 10000);
                                    
                                                                        $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php", { aceitarAtendimento: true, id_chat: "' . $dados["ticket"] . '" });
                                    
                                                                        setTimeout(function() {
                                                                            window.location = "./addonmodules.php?module=whatsapp&chat=' . $dados["ticket"] . '"; 
                                                                        }, 2000);
                                    
                                                                    });
                                    
                                                                });
                                    
                                                            </script>
                                    
                                                            <li>
                                    
                                                                <a href="./addonmodules.php?module=whatsapp&chat=' . $dados["ticket"] . '" class="' . ($dados["status"] == 0 ? 'disabled' : '') . ' ' . ($_GET["id"] == $dados["ticket"] ? 'nochat' : '') . '">
                                    
                                                                    <div class="foto" style="background: url(' . $dados["foto_cliente_sessao"] . '); background-size: 100% 100%;"></div>
                                                                    <div class="informacao">
                                                                        <p>
                                                                            ' . $dados["send_id"] . '<br>
                                                                            ' . LABEL_FILA . ' <strong>' . $dados["departamento"] . '</strong>
                                    
                                                                            ' . ($Query_New_MsgCount_rows > 0 ? '<span class="new_msg">' . $Query_New_MsgCount_rows . '</span>' : '' ) . '
                                    
                                                                        </p>
                                                                    </div> 
                                    
                                                                </a>
                                    
                                                                ' . ($dados["status"] == 0 ? '<center><button class="btn btn-primary" id="aceitarAtendimento_' . $dados["ticket"] . '" data-loading-text="<i class=\'fad fa-spinner fa-spin\' style=\'margin-right: 5px;\'></i> Carregando" style="color: #FFF;">' . BOTAO_ACEITAR . '</button></center>' : '') . '
                                                            
                                                            </li>';
                                    
                                                        }
                                                        
                                                    }
                                    
                                                }

                                            }

                                        }

                                    }

                                
                                echo '</div>

                            </div>

                            <div class="tab-pane fade" id="Wappi_Atendimento_Resolvido" role="tabpanel" aria-labelledby="Wappi_Atendimento_Resolvido">
                            
                                <div class="buscar">
                                    <input type="text" id="buscar_atendimento_finalizado" placeholder="' . INPUT_BUSCAR . '">
                                    <button class="btn btn-primary" id="buscar_atendimento_finalizado_Btn"><i class="far fa-search"></i></button>
                                </div>
                                
                                <div id="lista_chats_finalizado">';
                            
                                    $sessao_admin   =   $_SESSION["adminid"];

                                    $chat = 0;

                                    $Query_Chats_left   =   'SELECT * FROM api_whatsapp_chat WHERE `status` > 2 ORDER BY id DESC';
                                    $Query_Chats_left_Exec =   mysql_query($Query_Chats_left);

                                    while ($dados = mysql_fetch_array($Query_Chats_left_Exec)) {

                                        $ID_Chat_Ticket = $_GET["chat"];

                                        if( ($sessao_admin == $dados["funcionario"]) ) {

                                            foreach (Capsule::table('api_whatsapp_filaatendimento')->WHERE('Fila',$dados["departamento"])->get() as $value) {

                                                $Usuarios_Permitidos    =   explode(",",$value->Usuarios);
                                
                                                foreach ($Usuarios_Permitidos as $key => $values) {
                                
                                                    if(($values == $_SESSION["adminid"])) {
                                
                                                        echo '<li>
                                
                                                            <a href="./addonmodules.php?module=whatsapp&chat=' . $dados["ticket"] . '" class="' . ($dados["status"] == 0 ? 'disabled' : '') . ' ' . ($_GET["chat"] == $dados["ticket"] ? 'nochat' : '') . '">
                                
                                                                <div class="foto" style="background: url(' . $dados["foto_cliente_sessao"] . '); background-size: 100% 100%;"></div>
                                                                <div class="informacao">
                                                                    <p>
                                                                        ' . $dados["send_id"] . '<br>
                                                                        ' . LABEL_FILA . ' <strong>' . $dados["departamento"] . '</strong>
                                                                    </p>
                                                                </div> 
                                
                                                            </a>
                                                        
                                                        </li>';
                                
                                                    }
                                                    
                                                }
                                
                                            }

                                        }


                                    }
                            
                            echo '</div>
                            
                            </div>
                        
                        </div>


                        <div class="clear"></div>
                    </nav>
                    
                    <!-- Right -->';

                    if(($_GET["chat"])) {

                        foreach (Capsule::table('api_whatsapp_chat')->WHERE('ticket',$_GET['chat'])->get() as $chat) {

                            if(($chat->funcionario == $_SESSION["adminid"])) {

                                $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('NUMERO_WHATSAPP',$chat->send_id)->get();

                                if(($CodigoBancoDados[0]->NUMERO_WHATSAPP != NULL)) {

                                    foreach (Capsule::table('tblclients')->WHERE('id',$CodigoBancoDados[0]->ID_CLIENTE_WHMCS)->get() as $cliente_informacao) {
                                        
                                        $Nome_Cliente_Whatsapp   =   $cliente_informacao->firstname;
                                        $ID_Cliente_Whatsapp     =   $cliente_informacao->id;
                                        
                                    }
        
                                }

                                echo '<div class="right">

                                    <nav aria-label="breadcrumb">
                                        <ol class="breadcrumb" style="margin-bottom: 8px; padding: 20px;">

                                            <a href="./addonmodules.php?module=whatsapp" class="btn btn-primary" style="margin: -12px 15px -12px -6px;" data-toggle="tooltip" data-placement="top" title="Voltar"><i class="fas fa-angle-left"></i></a>
                                            
                                            <li class="breadcrumb-item active" aria-current="page"><i class="fal fa-comment-lines" style="margin-right: 5px;"></i> ' . TITULO_02 . '</li>
                                            <li class="breadcrumb-item active" aria-current="page">' . $chat->send_id . '</li>

                                            <div style="float:right; margin: -6px;">

                                                <script>
                                                    $(document).ready(function() {
                                            
                                                        $("#buscar_vincularCliente_Btn").on("click", function() {
                                
                                                            var BucarCliente_vincularCliente    =   $("#buscar_vincularCliente").val();
                                
                                                            $("#div_carregando_vincularCliente").show();
                                                            $("#resultado_find_vincularCliente").hide();
                                
                                                            $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php",{
                                                                buscarCliente_vincularCliente: true,
                                                                cliente: BucarCliente_vincularCliente,
                                                                NumeroWhatsapp: "' . $chat->send_id . '"
                                                            },
                                                            function(data, status) {
                                                                $("#resultado_find_vincularCliente").show();
                                                                $("#resultado_find_vincularCliente").html(data);
                                                                $("#div_carregando_vincularCliente").hide();
                                                            });
                                
                                                        });
                                
                                                    });
                                                </script>


                                                <div id="vincularCliente" class="modal_mm">

                                                    <div class="modal-content_mm">

                                                        <span class="close_vincularCliente">&times;</span>
                                                        <nav aria-label="breadcrumb">
                                                            <ol class="breadcrumb" style="margin-bottom: 8px;">
                                                                <li class="breadcrumb-item active" aria-current="page" style="padding: 20px !important; margin: 0 !important; line-height: 0 !important; text-align: center !important;">
                                                                    <i class="fal fa-heart" style="margin-right: 5px;"></i> Vincular Cliente
                                                                </li>
                                                            </ol>
                                                        </nav>
                
                                                        <div class="buscar_VincularCliente">
                                                            <input type="text" id="buscar_vincularCliente" placeholder="Nome do Cliente">
                                                            <button class="btn btn-primary" id="buscar_vincularCliente_Btn"><i class="far fa-search"></i></button>
                                                        </div>
                
                                                        <div id="div_carregando_vincularCliente" style="display: none; text-align: center;">
                                                            <img src="../modules/addons/whatsapp/templates/imagens/loading.svg" style="padding: 34px;">
                                                        </div>
                
                                                        <div id="resultado_find_vincularCliente" style="max-height: 400px; overflow: auto;">
                
                                                            <div class="alert alert-warning" role="alert">
                                                                Informe o nome do cliente acima para iniciar a busca.
                                                            </div>
                                                        
                                                        </div>
                
                                                    </div>
                                                    
                                                </div>

                                                ' . ($ID_Cliente_Whatsapp != NULL ? '<a class="btn btn-success" href="./clientssummary.php?userid=' . $ID_Cliente_Whatsapp . '" target="_blank">Ver Perfil</a>' : '') . '
                                               
                                                <button ' . ($CodigoBancoDados[0]->NUMERO_WHATSAPP != NULL ? 'disabled' : '') . ' class="btn btn-primary" id="vincularClienteBtn" data-toggle="tooltip" data-placement="top" title="' . BOTAO_VINCULAR_WHATSAPP . '"><i class="fal fa-heart"></i></button>

                                                <script>

                                                    var modalVincularCliente = document.getElementById("vincularCliente");

                                                    var btnVincularCliente = document.getElementById("vincularClienteBtn");

                                                    var spanVincularCliente = document.getElementsByClassName("close_OpenTicketSuporte")[0];

                                                    btnVincularCliente.onclick = function() {
                                                        modalVincularCliente.style.display = "block";
                                                    }

                                                    spanVincularCliente.onclick = function() {
                                                        modalVincularCliente.style.display = "none";
                                                    }

                                                    window.onclick = function(event) {
                                                        if (event.target == modalVincularCliente) {
                                                            modalVincularCliente.style.display = "none";
                                                        }
                                                    }

                                                </script>

                                                

                                                <script>

                                                    $(document).ready(function() {
                        
                                                        $("#terminarAtendimento_' . $chat->ticket . '").on("click", function() {
                        
                                                            var $this = $(this);
                                                            $this.button("loading");
                        
                                                            setTimeout(function() {
                                                                $this.button("reset"); 
                                                            }, 10000);
                        
                                                            $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php", { terminarAtendimento: true, id_chat: "' . $chat->ticket . '" });
                        
                                                            window.location = "./addonmodules.php?module=whatsapp";
                        
                                                        });
                        
                                                    });
                        
                                                </script>
                                            
                                                <button ' . ($chat->status != "3" ? '' : 'disabled="disabled"') . ' type="button" class="btn btn-primary" id="transferir_' . $chat->ticket . '_btn" data-toggle="tooltip" data-placement="top" title="' . BOTAO_TRANSFERIR_ATENDIMENTO . '"><i class="fal fa-random"></i></button>

                                                <div id="transferir_' . $chat->ticket . '" class="modal_mm">

                                                    <!-- Modal content -->
                                                    <div class="modal-content_mm">
                                                        <span class="close_newAtendimento">&times;</span>
                                                        <nav aria-label="breadcrumb">
                                                            <ol class="breadcrumb" style="margin-bottom: 8px;">
                                                                <li class="breadcrumb-item active" aria-current="page" style="padding: 20px !important; margin: 0 !important; line-height: 0 !important; text-align: center !important;">
                                                                    <i class="fal fa-random" style="margin-right: 5px;"></i> ' . BOTAO_TRANSFERIR_ATENDIMENTO . '
                                                                </li>
                                                            </ol>
                                                        </nav>

                                                        <div class="alert alert-warning" role="alert">
                                                            <i class="fal fa-info-circle"></i> ' . ALERTA_01 . '
                                                        </div>  

                                                        <form method="POST" id="TransferirAtendimento_' . $chat->ticket . '" onSubmit="sendTransferirAtendimento_' . $chat->ticket . '();return false;">
                                                        
                                                            <input type="hidden" type="text" name="acao" value="TransferirAtendimento">
                                                            <input type="hidden" type="text" name="id" value="' . $chat->ticket . '">';

                                                            $Staff_Online = localAPI("GetStaffOnline", []);

                                                            foreach ($Staff_Online["staffonline"]["staff"] as $staff) {

                                                                $StaffAtual =   Capsule::table('tbladmins')->WHERE('username',$staff["adminusername"])->get();

                                                                //$_SESSION["adminid"]

                                                                if(($StaffAtual[0]->id != $_SESSION["adminid"])) {

                                                                    echo '<div class="form-check" style="text-align: center; width: 48%; float: left; padding: 20px; border: 1px solid #eee; border-radius: 5px; margin-right: 10px;">
                                                                        <input class="form-check-input" type="radio" value="' . $StaffAtual[0]->id . '" id="' . $StaffAtual[0]->id . '" name="id_staff">
                                                                        <label class="form-check-label" for="' . $StaffAtual[0]->id . '">
                                                                            ' . $StaffAtual[0]->firstname . ' ' . $StaffAtual[0]->lastname . '
                                                                        </label>
                                                                    </div>';

                                                                }
                                                                

                                                            }

                                                            echo '<div class="clear"></div>

                                                            <button type="submit" class="btn btn-success" style="width: 100%; padding: 20px; margin-top: 10px;"><i class="fal fa-random" style="margin-right: 5px;"></i> ' . BOTAO_TRANSFERIR . '</button>
                                                        
                                                        </form>

                                                        <div id="div_carregando_transferencia" style="display: none; text-align: center; padding: 20px;">
                                                            <center><img src="../modules/addons/whatsapp/templates/imagens/loading.svg" style="padding: 34px;"></center>
                                                        </div>

                                                        <div id="div_retorno_transferencia" style="margin-top: 10px;"></div>

                                                        <script type="text/javascript">

                                                            function sendTransferirAtendimento_' . $chat->ticket . '(){
                                                                $.ajax({
                                                                    type: "POST",
                                                                    url: "../modules/addons/whatsapp/funcoes.php",
                                                                    data: $("#TransferirAtendimento_' . $chat->ticket . '").serialize(),
                                                                    beforeSend: function(){
                                                                        $("#div_retorno_transferencia").hide();
                                                                        $("#div_carregando_transferencia").show();
                                                                    },
                                                                    success: function(data){
                                                                        $("#div_carregando_transferencia").hide();
                                                                        $("#div_retorno_transferencia").show();
                                                                        $("#div_retorno_transferencia").empty().html(data);
                                                                    },
                                                                    // Se acontecer algum erro é executada essa função
                                                                    error: function(erro){
                                                                        ("#div_carregando_transferencia").hide();
                                                                    }
                                                                });
                                                            }

                                                        </script>

                                                        <div class="clear"></div>

                                                    </div>

                                                </div>

                                                <script>
                                                // Get the modal
                                                    var modal = document.getElementById("transferir_' . $chat->ticket . '");

                                                    // Get the button that opens the modal
                                                    var btn = document.getElementById("transferir_' . $chat->ticket . '_btn");

                                                    // Get the <span> element that closes the modal
                                                    var span = document.getElementsByClassName("close_newAtendimento")[0];

                                                    // When the user clicks on the button, open the modal
                                                    btn.onclick = function() {
                                                    modal.style.display = "block";
                                                    }

                                                    // When the user clicks on <span> (x), close the modal
                                                    span.onclick = function() {
                                                    modal.style.display = "none";
                                                    }

                                                    // When the user clicks anywhere outside of the modal, close it
                                                    window.onclick = function(event) {
                                                        if (event.target == modal) {
                                                            modal.style.display = "none";
                                                        }
                                                    }
                                                </script>

                                                

                                                <button ' . ($chat->status != "3" ? '' : 'disabled="disabled"') . ' id="terminarAtendimento_' . $chat->ticket . '" class="btn btn-danger" style="color: #FFF;" data-loading-text="<i class=\'fad fa-spinner fa-spin\' style=\'margin-right: 5px;\'></i> Carregando" data-toggle="tooltip" data-placement="top" title="Resolvido"><i class="fal fa-times-circle"></i></button>

                                            </div>

                                        </ol>
                                    </nav>

                                    <script>
                        
                                        $(document).ready(function() {
                    
                                            var input = document.getElementById("message");
                                            
                                            input.addEventListener("keyup", function(event) {
                                                    if (event.keyCode === 13) {
                                                        event.preventDefault();
                                                        document.getElementById("sendMsg").click();
                                                    }
                                            });
                    
                                        });
                                        
                                    </script>

                                    <div class="conteudo_chat" id="mensagens_chat"><div style="padding: 10px;">';
                                                
                                        foreach (Capsule::table('api_whatsapp_mensagens_chat')->WHERE('ticket',$chat->ticket)->get() as $chat) {

                                            foreach (Capsule::table('api_whatsapp_chat')->WHERE('ticket',$chat->ticket)->get() as $info) {
                                                $Foto_Cliente   =   $info->foto_cliente_sessao;
                                                $Numero_SendAdmin   =   $info->recev_id;
                                                $ID_Admin_Sessao    =   $info->funcionario;
                                                $Status_Chat        =   $info->status;
                                            }
                                    
                                            foreach (Capsule::table('tbladmins')->WHERE('id',$ID_Admin_Sessao)->get() as $info) {
                                                $Nome_Admin =   $info->firstname . " " . $info->lastname;
                                            }

                                            $date = new DateTime($chat->data);

                                            if(str_contains($chat->arquivo_name, "./")) {

                                                $arquivotratado =   str_replace("./files/","",$chat->arquivo_name);

                                                $arquivo_msg    =   $URL_API . "/" . $arquivotratado;


                                            } else {
                                                
                                                $arquivo_msg    =   $chat->arquivo_name;
                                                
                                            }

                                            if(($chat->status == 0)) {

                                                // Notifica
                                    
                                                echo '<audio controls autoplay style="display:none;">
                                                    <source src="../modules/addons/whatsapp/templates/audios/notificacao_newmsg.mp3" type="audio/mpeg">
                                                </audio>
                                                
                                                <script>
                                    
                                                    var scrollDown = function() {
                                    
                                                        $("#mensagens_chat").animate({
                                    
                                                            scrollTop: 100000000000000000000
                                    
                                                        }, 50);
                                    
                                                    }
                                    
                                                    scrollDown();
                                    
                                                </script>';
                                    
                                                Capsule::table('api_whatsapp_mensagens_chat')->WHERE('id',$chat->id)->update([
                                    
                                                    'status'    =>  '1'
                                                
                                                ]);
                                    
                                                $wappi->MarcarMensagensLida($chat->send_id);
                                    
                                            }

                                            if(($chat->tipo_msg == "image")) {

                                                echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">

                                                    <div style="margin-bottom: 20px;"></div>
                                    
                                                    <div style="position:relative;width:100%;">

                                                        <div class="conteudo" style="">
                                                            <p>
                                                                <a href="#' . $arquivo_msg . '">
                                                                    <img src="' . $arquivo_msg . '" style="max-width: 150px;padding: 5px;' . ($Numero_SendAdmin == $chat->send_id ? 'background: #D9FDD3; right:0px;' : 'background: #ffffff; left:0px;') . '">
                                                                </a>
                                                            </p>
                                                            <div class="time" style="position: absolute; ' . ($Numero_SendAdmin == $chat->send_id ? 'bottom: 13px;right: 13px;' : 'bottom: 15px;left: 19px;') . ' text-shadow: 0.1em 0.1em 0.2em #000; color: #fff">' . $date->format('d/m') . ' as <smile>' . $date->format('H:i') . '</smile></div>
                                                            <div id="' . $arquivo_msg . '" class="overlay">
                                                                <div class="popup">
                                                                    <a class="close_popup btn btn-danger" href="#">&times;</a>
                                                                    <div class="content">
                                                                        <img src="' . $arquivo_msg . '" style="max-width: 90%;">
                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>';
                                    
                                            } elseif(($chat->tipo_msg == "voice")) {
                                    
                                                echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">
                                    
                                                    <div class="nome">
                                                        <div class="foto" style="background: url(' . ($Numero_SendAdmin == $chat->send_id ? '../modules/addons/whatsapp/templates/imagens/admin.png' : $Foto_Cliente) . '); background-size: 100% 100%;"></div>
                                                        ' . ($Numero_SendAdmin == $chat->send_id ? $chat->nome_funcionario : ($Nome_Cliente_Whatsapp != NULL ? $Nome_Cliente_Whatsapp : $chat->send_id)) . '
                                                    </div>
                                                    <div class="time">' . $date->format('d/m/Y') . ' <span>' . $date->format('H:i') . '</span></div>
                                    
                                                    <div class="clear"></div>
                                                    <div class="conteudo">
                                                        <p>
                                                            <audio controls>
                                                                <source src="' . $arquivo_msg . '" type="audio/ogg">
                                                                Seu navegador não suporta este tipo de arquivo.
                                                            </audio>
                                                        </p>
                                                    </div>
                                                
                                                </div>';
                                    
                                            } elseif(($chat->tipo_msg == "video")) {
                                    
                                                echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">
                                    
                                                    <div class="nome">
                                                        <div class="foto" style="background: url(' . ($Numero_SendAdmin == $chat->send_id ? '../modules/addons/whatsapp/templates/imagens/admin.png' : $Foto_Cliente) . '); background-size: 100% 100%;"></div>
                                                        ' . ($Numero_SendAdmin == $chat->send_id ? $chat->nome_funcionario : ($Nome_Cliente_Whatsapp != NULL ? $Nome_Cliente_Whatsapp : $chat->send_id)) . '
                                                    </div>
                                                    <div class="time">' . $date->format('d/m/Y') . ' as <span>' . $date->format('H:i') . '</span></div>
                                    
                                                    <div class="clear"></div>
                                                    <div class="conteudo">
                                                        <p>
                                                            <video width="320" controls>
                                                                <source src="' . $arquivo_msg . '" type="video/mp4">
                                                                Seu navegador não suporta este tipo de arquivo.
                                                            </video>
                                                        </p>
                                                    </div>
                                                
                                                </div>';
                                    
                                            } elseif(($chat->tipo_msg == "document")) {

                                                echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">
                                    
                                                    <div class="nome">
                                                        <div class="foto" style="background: url(' . ($Numero_SendAdmin == $chat->send_id ? '../modules/addons/whatsapp/templates/imagens/admin.png' : $Foto_Cliente) . '); background-size: 100% 100%;"></div>
                                                        ' . ($Numero_SendAdmin == $chat->send_id ? $chat->nome_funcionario : ($Nome_Cliente_Whatsapp != NULL ? $Nome_Cliente_Whatsapp : $chat->send_id)) . '
                                                    </div>
                                                    <div class="time">' . $date->format('d/m') . ' as <span>' . $date->format('H:i') . '</span></div>
                                    
                                                    <div class="clear"></div>
                                                    <div class="conteudo">
                                                        <p><a href="' . $arquivo_msg . '" class="btn btn-danger" target="_blank"><i class="far fa-eye" style="margin-right: 5px;"></i> ' . BOTAO_VER_DOCUMENTO . '</a></p>
                                                    </div>
                                                
                                                </div>';
                                            
                                            } elseif(($chat->tipo_msg == "text")) {
                                    
                                                echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">
                                    
                                                    <div style="margin-bottom: 20px;"></div>
                                                    <div style="position:relative;width:100%;">
                                                        <div class="conteudo" style="' . ($Numero_SendAdmin == $chat->send_id ? 'background: #D9FDD3; max-width:calc(100% - 360px); position:absolute;right:0px;' : 'background: #ffffff; max-width:calc(100% - 360px); position:absolute;left:0px;') . '">
                                                            <p>' . htmlspecialchars($chat->mensagem) . '
                                                            <span class="time"> ' . $date->format('d/m') . ' <span>' . $date->format('H:i') . '</span></span></p>
                                                        </div>
                                                    </div>
                                                
                                                </div>';
                                    
                                            } elseif(($chat->tipo_msg == "reply")) {

                                                $resposta   =   Capsule::table('api_whatsapp_mensagens_chat')->WHERE('id_mensagem',$chat->id_mensagem_resposta)->get();
                                                    
                                                echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">
                            
                                                    <div class="nome">
                                                        <div class="foto" style="background: url(' . ($Numero_SendAdmin == $chat->send_id ? '../modules/addons/whatsapp/templates/imagens/admin.png' : $Foto_Cliente) . '); background-size: 100% 100%;"></div>
                                                        ' . ($Numero_SendAdmin == $chat->send_id ? $chat->nome_funcionario : ($Nome_Cliente_Whatsapp != NULL ? $Nome_Cliente_Whatsapp : $chat->send_id)) . '
                                                    </div>
                                                    <div class="time">' . $date->format('d/m/Y') . ' as <span>' . $date->format('H:i') . '</span></div>
                                    
                                                    <div class="clear"></div>

                                                    <div class="conteudo" style="background-color: #E8E8E8; padding: 10px 20px;">
                                                        <p style="width: 99%; float: left;">' . htmlspecialchars($resposta[0]->mensagem) . '</p>
                                                        <i class="fas fa-angle-down"></i>
                                                    </div>';

                                                    $TipoArquivos    =   explode(".",$arquivo_msg);

                                                    if(($TipoArquivos[5] != NULL)) {

                                                        $TipoArquivo    =   $TipoArquivos[5];

                                                    } else {

                                                        $TipoArquivo    =   $TipoArquivos[4];

                                                    }

                                                    switch ($TipoArquivo) {

                                                        case 'jpeg':
                                                        case 'png':
                                                        case 'gif':
                                                        case 'jpg':

                                                            echo '<div class="conteudo" style="border-left: 4px solid  #E8E8E8;">
                                                                
                                                                <p>
                                                                    <a href="#' . $arquivo_msg . '"><img src="' . $arquivo_msg . '" style="max-width: 150px;"></a>
                                                                </p>

                                                                <div id="' . $arquivo_msg . '" class="overlay">
                                                                    <div class="popup">
                                                                        <a class="close_popup btn btn-danger" href="#">&times;</a>
                                                                        <div class="content">
                                                                            <img src="' . $arquivo_msg . '" style="max-width: 100%;">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            
                                                            </div>';
                                                            break;

                                                        case 'ogg':
                                                        case 'mp3':

                                                            echo '<div class="conteudo" style="border-left: 4px solid  #E8E8E8;">
                                                                <p>
                                                                    <audio controls>
                                                                        <source src="' . $arquivo_msg . '" type="audio/ogg">
                                                                        Seu navegador não suporta este tipo de arquivo.
                                                                    </audio>
                                                                </p>
                                    
                                                            </div>';
                                                            break;

                                                        case 'mp4':

                                                            echo '<div class="conteudo" style="border-left: 4px solid  #E8E8E8;">
                                                                <p>
                                                                    <video width="320" controls>
                                                                        <source src="' . $arquivo_msg . '" type="video/mp4">
                                                                        Seu navegador não suporta este tipo de arquivo.
                                                                    </video>
                                                                </p>
                                    
                                                            </div>';
                                                            break;

                                                        case 'pdf':

                                                            echo '<div class="conteudo" style="border-left: 4px solid  #E8E8E8;">
                                                                <p>
                                                                    <a href="' . $arquivo_msg . '" class="btn btn-danger" target="_blank"><i class="far fa-eye" style="margin-right: 5px;"></i> ' . BOTAO_VER_DOCUMENTO . '</a>
                                                                </p>
                                    
                                                            </div>';
                                                            break;
                                                        
                                                        default:
                                                        
                                                            echo '<div class="conteudo" style="border-left: 4px solid  #E8E8E8;"><p>' . htmlspecialchars($chat->mensagem) . '</p></div>';
                                                            break;

                                                    }
                                                    

                                                    //
                                                
                                                echo '</div>';
                                                

                                            } else {
                                    
                                                echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">
                                    
                                                    <div class="nome">
                                                        <div class="foto" style="background: url(' . ($Numero_SendAdmin == $chat->send_id ? '../modules/addons/whatsapp/templates/imagens/admin.png' : $Foto_Cliente) . '); background-size: 100% 100%;"></div>
                                                        ' . ($Numero_SendAdmin == $chat->send_id ? $chat->nome_funcionario : ($Nome_Cliente_Whatsapp != NULL ? $Nome_Cliente_Whatsapp : $chat->send_id)) . '
                                                    </div>
                                                    <div class="time">' . $date->format('d/m/Y') . ' as <span>' . $date->format('H:i') . '</span></div>
                                    
                                                    <div class="clear"></div>
                                                    <div class="conteudo"><p>' . htmlspecialchars($chat->mensagem) . '</p></div>
                                                
                                                </div>';
                                    
                                            }

                                        }
                                    
                                    echo '</div></div>

                                    <div class="acoes_chat ' . ($Status_Chat != "3" ? '' : 'disabled') . '">

                                        <div id="modalMsgRapidas" class="modal_mm">

                                            <!-- Modal content -->
                                            <div class="modal-content_mm">
                                                <span class="close_msgrapida">&times;</span>
                                                <nav aria-label="breadcrumb">
                                                    <ol class="breadcrumb" style="margin-bottom: 8px;">
                                                        <li class="breadcrumb-item active" aria-current="page" style="padding: 20px !important; margin: 0 !important; line-height: 0 !important; text-align: center !important;">
                                                            <i class="fal fa-exchange" style="margin-right: 5px;"></i> ' . BOTAO_MENSAGENS_RAPIDAS . '
                                                        </li>
                                                    </ol>
                                                </nav>

                                                <div class="alert alert-warning" role="alert">
                                                    <i class="fal fa-info-circle"></i> ' . ALERTA_03 . '
                                                </div>

                                                <script>

                                                    $(document).ready(function() {

                                                        $("input[type=\'button\']").click(function(){
                                                            var radioValue = $("input[name=\'id_MsgRapida\']:checked").val();
                                                            
                                                            if(radioValue){
                                                                
                                                                var modal_msgrapida = document.getElementById("modalMsgRapidas");

                                                                $("#message").val(radioValue);

                                                                modal_msgrapida.style.display = "none";


                                                            } else {

                                                                alert("Você deve selecionar uma mensagem rápida para continuar.")

                                                            }

                                                        });
                        
                                                    });
                                                
                                                </script>
                                                
                                                <table class="table table-bordered table-hover" id="templates_MensagensRapidasModal">
                        
                                                    <thead>
                                                        <tr>
                                                            <th style="text-align: center;">#</th>
                                                            <th style="text-align: center;">Titulo</th>
                                                        </tr>
                                                    </thead>

                                                    <tbody>';

                                                    foreach (Capsule::table("api_whatsapp_mensagens_rapidas")->get() as $msgRapida) {

                                                        echo '<tr>
                                                            <td style="width: 30px; text-align: center;">
                                                                <input class="form-check-input" type="radio" value="' . $msgRapida->mensagem . '" name="id_MsgRapida" id="' . $msgRapida->id . '">
                                                            </td>
                                                            <td style="text-align: center;"><label for="' . $msgRapida->id . '">' . $msgRapida->titulo . '</label></td>
                                                        </tr>';                                                       

                                                    }

                                                echo '</tbody>
                                                </table>

                                                <div class="text-center" id="Log_templates_MsgRapidasModal">
                                                    <div class="alert alert-warning" role="alert" style="text-align: center;"><i class="fas fa-spinner fa-spin"></i> Carregando tabela.</div>
                                                </div>
                                                
                                                <input type="button" value="' . BOTAO_ADICIONAR . '" class="btn btn-primary">

                                                <div class="clear"></div>

                                            </div>

                                        </div>       

                                        <button id="modalMsgRapidas_btn" ' . ($Status_Chat != "3" ? '' : 'disabled="disabled"') . '><i class="fal fa-fighter-jet"></i> ' . BOTAO_MENSAGENS_RAPIDAS . '</button>

                                        <script>
                                        // Get the modal
                                            var modal_msgrapida = document.getElementById("modalMsgRapidas");

                                            // Get the button that opens the modal
                                            var btn_MsgRapida = document.getElementById("modalMsgRapidas_btn");

                                            // Get the <span> element that closes the modal
                                            var span_MsgRapida = document.getElementsByClassName("close_msgrapida")[0];

                                            // When the user clicks on the button, open the modal
                                            btn_MsgRapida.onclick = function() {
                                                modal_msgrapida.style.display = "block";
                                            }

                                            // When the user clicks on <span> (x), close the modal
                                            span_MsgRapida.onclick = function() {
                                                modal_msgrapida.style.display = "none";
                                            }

                                            // When the user clicks anywhere outside of the modal, close it
                                            window.onclick = function(event) {
                                                if (event.target == modal) {
                                                    modal_msgrapida.style.display = "none";
                                                }
                                            }
                                        </script>
                                        

                                        <input type="text" id="message" placeholder="' . INPUT_MENSAGEM . '" class="form-control" autofocus ' . ($Status_Chat != "3" ? '' : 'disabled="disabled"') . ' rows="2">
                                        
                                        <button id="gravar_audio" data-toggle="tooltip" data-placement="top" title="Enviar um audio">
                                            <i class="fal fa-microphone"></i>
                                        </button>

                                        <button id="enviar_gravacao" data-toggle="tooltip" data-placement="top" title="Parar e Enviar">
                                            <i class="fas fa-stop"></i>
                                        </button>
                                        
                                        <button id="sendMsg" ' . ($Status_Chat != "3" ? '' : 'disabled="disabled"') . ' data-toggle="tooltip" data-placement="top" title="Enviar mensagem">
                                            <i class="fas fa-paper-plane"></i>
                                        </button>
                                    
                                    </div>

                                    <div class="clear"></div>
                                </div>';

                            } else {

                                echo '<div class="alert alert-danger" role="alert" style="text-align: center">
                                    ' . ALERTA_04 . '
                                </div>';

                            }
                            
                        }

                        

                    } else {

                        echo '<div class="right">

                            <div class="alert alert-warning" role="alert" style="text-align: center;">
                                ' . ALERTA_05 . '
                            </div>
                            
                            
                            <div class="clear"></div>
                        </div>';

                    }

                    echo '<div class="clear"></div>
                </div>
                
            </div>


            <div class="tab-pane fade active in" id="Wappi_TemplatesMensagens" role="tabpanel" aria-labelledby="Wappi_TemplatesMensagens">


                <div id="div_carregando_template" style="display: none; text-align: center;">
                    <img src="../modules/addons/whatsapp/templates/imagens/loading.svg" style="padding: 34px;">
                </div>

                <div id="div_retorno_template"></div>

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item active" aria-current="page">WHMCS</li>
                        <li class="breadcrumb-item active" aria-current="page">Addons</li>
                        <li class="breadcrumb-item active" aria-current="page">API Whatsapp</li>
                        <li class="breadcrumb-item active" aria-current="page">Templates de Mensagem</li>
                    </ol>
                </nav>';

                $Wappi_ModeloMensagens_Query            =   "SELECT * FROM api_whatsapp_template_mensagens ORDER BY id DESC";
                $Wappi_ModeloMensagens_Query_Exec       =   mysql_query($Wappi_ModeloMensagens_Query);

                echo '<div class="pag_connteudo">';
                
                    echo '<table class="table table-bordered table-hover" id="templates_Mensagens">
                        
                        <thead>
                            <tr>
                                <th style="text-align: center;">ID</th>
                                <th style="text-align: center;">Titulo da Mensagem</th>
                                <th style="text-align: center;">Status</th>
                                <th style="text-align: center;">Editar</th>
                                <th style="text-align: center;">Ações</th>
                            </tr>
                        </thead>

                        <tbody>';

                        while ($dados = mysql_fetch_array($Wappi_ModeloMensagens_Query_Exec)) {

                            echo '<tr>

                                <td style="text-align: center; padding-top: 15px;">
                                    ' . $dados['id'] . '
                                </td>

                                <td style="text-align: center; padding-top: 15px;">' . $dados['titulo'] . '</td>
                                <td style="text-align: center; padding-top: 8px;">


                                ' . ($dados['status'] == '1' ? '<div class="btn btn-success"><i class="fa fa-check" aria-hidden="true"></i></div>':'<div class="btn btn-danger"><i class="fas fa-times"></i></div>') . '


                                </td>

                                <td style="text-align: center; padding-top: 15px;">


                                    <form method="POST" id="EditarMensagem_' . $dados['id'] . '" onSubmit="sendEditarMensagem_' . $dados['id'] . '();return false;">
                                            
                                        <input type="hidden" name="acao" value="editarTemplateMensagem">
                                        <input type="hidden" name="id" value="' . $dados['id'] . '">

                                        <button class="btn btn-default" type="submit"><i class="far fa-edit"></i> Editar mensagem</button>

                                        <script type="text/javascript">

                                            function sendEditarMensagem_' . $dados['id'] . '(){
                                                $.ajax({
                                                    type: "POST",
                                                    url: "../modules/addons/whatsapp/funcoes.php",
                                                    data: $("#EditarMensagem_' . $dados['id'] . '").serialize(),
                                                    beforeSend: function(){
                                                        $("#div_retorno_template").hide();
                                                        $("#div_carregando_template").show();
                                                    },
                                                    success: function(data){
                                                        $("#div_carregando_template").hide();
                                                        $("#div_retorno_template").show();
                                                        $("#div_retorno_template").empty().html(data);
                                                    },
                                                    // Se acontecer algum erro é executada essa função
                                                    error: function(erro){
                                                    $("#div_carregando_template").hide();
                                                    }
                                                });
                                            }

                                        </script>

                                    </form>


                                </td>

                                <td style="text-align: center; padding-top: 15px;">


                                    <form style="float: left; margin-right: 10px;" method="POST" id="DesativarTemplate_' . $dados['id'] . '" onSubmit="sendDesativarTemplate_' . $dados['id'] . '();return false;">
                                                
                                        <input type="hidden" name="acao" value="desativarTemplate">
                                        <input type="hidden" name="id" value="' . $dados['id'] . '">

                                        <button class="btn btn-default" type="submit" ' . ($dados['status'] == '0' ? 'disabled':'') . '><i class="far fa-bell-slash"></i> Desativar Envio</button>

                                        <script type="text/javascript">

                                            function sendDesativarTemplate_' . $dados['id'] . '(){
                                                $.ajax({
                                                    type: "POST",
                                                    url: "../modules/addons/whatsapp/funcoes.php",
                                                    data: $("#DesativarTemplate_' . $dados['id'] . '").serialize(),
                                                    beforeSend: function(){
                                                        $("#div_retorno_template").hide();
                                                        $("#div_carregando_template").show();
                                                    },
                                                    success: function(data){
                                                        $("#div_carregando_template").hide();
                                                        $("#div_retorno_template").show();
                                                        $("#div_retorno_template").empty().html(data);
                                                    },
                                                    // Se acontecer algum erro é executada essa função
                                                    error: function(erro){
                                                    $("#div_carregando_template").hide();
                                                    }
                                                });
                                            }

                                        </script>

                                    </form>

                                    <form style="float: left; margin-right: 10px;" method="POST" id="AtivarTemplate_' . $dados['id'] . '" onSubmit="sendAtivarTemplate_' . $dados['id'] . '();return false;">
                                                
                                        <input type="hidden" name="acao" value="ativarTemplate">
                                        <input type="hidden" name="id" value="' . $dados['id'] . '">

                                        <button class="btn btn-success" type="submit" ' . ($dados['status'] == '1' ? 'disabled':'') . '><i class="far fa-bell"></i> Ativar Envio</button>

                                        <script type="text/javascript">

                                            function sendAtivarTemplate_' . $dados['id'] . '(){
                                                $.ajax({
                                                    type: "POST",
                                                    url: "../modules/addons/whatsapp/funcoes.php",
                                                    data: $("#AtivarTemplate_' . $dados['id'] . '").serialize(),
                                                    beforeSend: function(){
                                                        $("#div_retorno_template").hide();
                                                        $("#div_carregando_template").show();
                                                    },
                                                    success: function(data){
                                                        $("#div_carregando_template").hide();
                                                        $("#div_retorno_template").show();
                                                        $("#div_retorno_template").empty().html(data);
                                                    },
                                                    // Se acontecer algum erro é executada essa função
                                                    error: function(erro){
                                                        $("#div_carregando_template").hide();
                                                    }
                                                });
                                            }

                                        </script>

                                    </form>

                                </td>

                            </tr>';

                        }


                echo '</tbody>
                    </table>
                </div>
            </div>';


            $QuantasFilas   =   Capsule::table('api_whatsapp_filaatendimento')->count();


            echo '<div class="tab-pane fade" id="Wappi_Robo" role="tabpanel" aria-labelledby="Wappi_Robo">

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item active" aria-current="page">WHMCS</li>
                        <li class="breadcrumb-item active" aria-current="page">Addons</li>
                        <li class="breadcrumb-item active" aria-current="page">API Whatsapp</li>
                        <li class="breadcrumb-item active" aria-current="page">Fila de Atendimento</li>
                    </ol>
                </nav>

                <div class="alert alert-warning" role="alert">
                    <strong>AVISO:</strong> Nosso sistema possui uma limitação de 3 filas de atendimento.
                </div>

                <form method="POST" id="Form_AdicionarNewFila" onSubmit="sendForm_AdicionarNewFila();return false;">
                    
                    <input type="hidden" name="acao" value="AdicionarNewFilaAtendimento">
                    <button type="submit" ' . ($QuantasFilas >= 3 ? 'disabled="disabled"' : '') . ' class="btn btn-success">Adicionar uma nova fila</button>

                    <script type="text/javascript">

                        function sendForm_AdicionarNewFila() {
                            
                            $.ajax({

                                type: "POST",
                                url: "../modules/addons/whatsapp/funcoes.php",
                                data: $("#Form_AdicionarNewFila").serialize(),
                                beforeSend: function(){
                                    $("#div_retorno_adicionarRobo").hide();
                                    $("#div_carregando_adicionarRobo").show();
                                },
                                success: function(data){
                                    $("#div_carregando_adicionarRobo").hide();
                                    $("#div_retorno_adicionarRobo").show();
                                    $("#div_retorno_adicionarRobo").empty().html(data);
                                },
                                // Se acontecer algum erro é executada essa função
                                error: function(erro){
                                    $("#div_carregando_adicionarRobo").hide();
                                }

                            });

                        }

                    </script>

                </form>

                <div id="div_retorno_adicionarRobo"></div>

                <div id="div_carregando_adicionarRobo" style="display: none; text-align: center;">
                    <img src="../modules/addons/whatsapp/templates/imagens/loading.svg" style="padding: 34px;">
                </div>
            
                <table class="table table-hover" style="border: 1px solid #eee !important; margin-top: 10px;">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Funcionarios Atendentes</th>
                            <th>Status</th>
                            <th>Ações</th>
                        </tr>
                    </thead>

                    <tbody>';

                    $Query_Logs_FilaAtendimento      =   "SELECT * FROM api_whatsapp_filaatendimento ORDER BY id DESC";
                    $Query_Logs_FilaAtendimento_Exec =   mysql_query($Query_Logs_FilaAtendimento);

                    while ($dados = mysql_fetch_array($Query_Logs_FilaAtendimento_Exec)) {

                        echo '<tr>
                                <td>'.$dados['Fila'].'</td>
                                <td>'.$dados['Usuarios'].'</td>
                                <td>'.($dados['status'] == "1" ? '<button class="btn btn-secondary btn-sm">Ativo</button>' : '<button class="btn btn-danger btn-sm">Desativado</button>').'</td>
                                <td><a class="btn btn-danger btn-sm" href="./addonmodules.php?module=whatsapp&acao=deletarFila&id='.$dados["id"].'">Deletar</a></td>
                        </tr>';

                    }

                    echo '</tbody>
                
                </table>

            </div>

            <div class="tab-pane fade" id="Wappi_Msg_Rapidas" role="tabpanel" aria-labelledby="Wappi_Msg_Rapidas">

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item active" aria-current="page">WHMCS</li>
                        <li class="breadcrumb-item active" aria-current="page">Addons</li>
                        <li class="breadcrumb-item active" aria-current="page">API Whatsapp</li>
                        <li class="breadcrumb-item active" aria-current="page">Mensagens Rápidas</li>
                    </ol>
                </nav>

                <form method="POST" id="Form_AdicionarMensagemRapida" onSubmit="sendForm_AdicionarMensagemRapida();return false;" style="margin-bottom: 14px;">
                    
                    <input type="hidden" name="acao" value="AdicionarMensagemRapidao">
                    <button type="submit" class="btn btn-success"><i class="fal fa-plus-circle"></i> Adicionar</button>

                    <script type="text/javascript">

                        function sendForm_AdicionarMensagemRapida() {
                            
                            $.ajax({

                                type: "POST",
                                url: "../modules/addons/whatsapp/funcoes.php",
                                data: $("#Form_AdicionarMensagemRapida").serialize(),
                                beforeSend: function(){
                                    $("#div_retorno_adicionarNewMsgRapida").hide();
                                    $("#div_carregando_adicionarNewMsgRapida").show();
                                },
                                success: function(data){
                                    $("#div_carregando_adicionarNewMsgRapida").hide();
                                    $("#div_retorno_adicionarNewMsgRapida").show();
                                    $("#div_retorno_adicionarNewMsgRapida").empty().html(data);
                                },
                                // Se acontecer algum erro é executada essa função
                                error: function(erro){
                                    $("#div_carregando_adicionarNewMsgRapida").hide();
                                }

                            });

                        }

                    </script>

                </form>

                <div id="div_retorno_adicionarNewMsgRapida"></div>

                <div id="div_carregando_adicionarNewMsgRapida" style="display: none; text-align: center;">
                    <img src="../modules/addons/whatsapp/templates/imagens/loading.svg" style="padding: 34px;">
                </div>

                <table class="table table-hover" style="border: 1px solid #eee !important; margin-top: 10px;" id="templates_MsgRapidas">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Titulo</th>
                            <th>Ações</th>
                        </tr>
                    </thead>

                    <tbody>';

                    $Query_Logs_MsgRapidas      =   "SELECT * FROM api_whatsapp_mensagens_rapidas ORDER BY id DESC";
                    $Query_Logs_MsgRapidas_Exec =   mysql_query($Query_Logs_MsgRapidas);

                    while ($dados = mysql_fetch_array($Query_Logs_MsgRapidas_Exec)) {

                        echo '<tr>
                            <td>'.$dados['id'].'</td>
                            <td>'.$dados['titulo'].'</td>
                            <td>
                                <a class="btn btn-danger btn-sm" href="./addonmodules.php?module=whatsapp&acao=deletarMsgRapida&id='.$dados["id"].'">Deletar</a>
                            </td>
                        </tr>';

                    }

                    echo '</tbody>
                
                </table>

                <div class="text-center" id="Log_templates_MsgRapidas">
                    <div class="alert alert-warning" role="alert" style="text-align: center;"><i class="fas fa-spinner fa-spin"></i> Carregando tabela.</div>
                </div>

            </div>


            <div class="tab-pane fade" id="Wappi_Relatorio_Atendimento" role="tabpanel" aria-labelledby="Wappi_Relatorio_Atendimento">

                <div id="div_retorno_VerAtendimentoRelatorio"></div>

                <div id="div_carregando_VerAtendimentoRelatorio" style="display: none; text-align: center;">
                    <img src="../modules/addons/whatsapp/templates/imagens/loading.svg" style="padding: 34px;">
                </div>

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item active" aria-current="page">WHMCS</li>
                        <li class="breadcrumb-item active" aria-current="page">Addons</li>
                        <li class="breadcrumb-item active" aria-current="page">API Whatsapp</li>
                        <li class="breadcrumb-item active" aria-current="page">Relatório de Atendimento</li>
                    </ol>
                </nav>

                <table class="table table-hover" id="TabelaRelatorio_Atendimento" style="border: 1px solid #eee !important;">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Funcionario</th>
                            <th>Protocolo</th>
                            <th>Número</th>
                            <th>Departamento</th>
                            <th>Status</th>
                            <th>Ações</th>
                        </tr>
                    </thead>

                    <tbody>';

                    $Query_MsgSend      =   "SELECT * FROM api_whatsapp_chat ORDER BY id DESC";
                    $Query_MsgSend_Exec =   mysql_query($Query_MsgSend);

                    while ($atendimento = mysql_fetch_array($Query_MsgSend_Exec)) {

                        foreach (Capsule::table('tbladmins')->WHERE('id',$atendimento["funcionario"])->get() as $info) {
                            $Nome_Admin =   $info->firstname . " " . $info->lastname;
                        }

                        switch ($atendimento["status"]) {

                            case '1':
                               
                                $Status_Ticket  =   '<div style="padding: 5px 10px; background-color: #24B814; color: #FFF; text-align: center;">Em atendimento</div>';

                                break;

                            case '2':
                                
                                
                                break;

                            case '3':

                                $Status_Ticket  =   '<div style="padding: 5px 10px; background-color: #CC3300; color: #FFF; text-align: center;">Finalizado</div>';

                                break;
                            
                            default:

                                $Status_Ticket  =   '<div style="padding: 5px 10px; background-color: #1C66B0; color: #FFF; text-align: center;">Aguardando</div>';
                                
                                break;
                        }

                        echo '<tr>
                                <td>' . $atendimento['id'] . '</td>
                                <td>' . $Nome_Admin . '</td>
                                <td>' . $atendimento['ticket'] . '</td>
                                <td>' . $atendimento["send_id"] . '</td>
                                <td>' . $atendimento["departamento"] . '</td>
                                <td>' . $Status_Ticket . '</td>
                                <td>

                                    <form method="POST" id="Form_VerAtendimentoRelatorio' . $atendimento['id'] . '" onSubmit="sendForm_VerAtendimentoRelatorio' . $atendimento['id'] . '();return false;" style="margin-bottom: 14px;">
                        
                                        <input type="hidden" name="acao" value="VerAtendimentoRelatorio">
                                        <input type="hidden" name="ticket" value="' . $atendimento['ticket'] . '">
                                        <button type="submit" class="btn btn-primary"><i class="far fa-eye"></i> Visualizar</button>

                                        <script type="text/javascript">

                                            function sendForm_VerAtendimentoRelatorio' . $atendimento['id'] . '() {
                                                
                                                $.ajax({

                                                    type: "POST",
                                                    url: "../modules/addons/whatsapp/funcoes.php",
                                                    data: $("#Form_VerAtendimentoRelatorio' . $atendimento['id'] . '").serialize(),
                                                    beforeSend: function(){
                                                        $("#div_retorno_VerAtendimentoRelatorio").hide();
                                                        $("#div_carregando_VerAtendimentoRelatorio").show();
                                                    },
                                                    success: function(data){
                                                        $("#div_carregando_VerAtendimentoRelatorio").hide();
                                                        $("#div_retorno_VerAtendimentoRelatorio").show();
                                                        $("#div_retorno_VerAtendimentoRelatorio").empty().html(data);
                                                    },
                                                    // Se acontecer algum erro é executada essa função
                                                    error: function(erro){
                                                        $("#div_carregando_VerAtendimentoRelatorio").hide();
                                                    }

                                                });

                                            }

                                        </script>

                                    </form>
                                

                                </td>
                        </tr>';

                    }
                    

                        echo '</tbody>
                </table>

                <div class="text-center" id="RelatorioMsgEnviadas_Carregando">
                    <div class="alert alert-warning" role="alert" style="text-align: center;"><i class="fas fa-spinner fa-spin"></i> Carregando tabela.</div>
                </div>

            </div>

            


            <div class="tab-pane fade" id="Wappi_RelatorioLogs" role="tabpanel" aria-labelledby="Wappi_RelatorioLogs">

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item active" aria-current="page">WHMCS</li>
                        <li class="breadcrumb-item active" aria-current="page">Addons</li>
                        <li class="breadcrumb-item active" aria-current="page">API Whatsapp</li>
                        <li class="breadcrumb-item active" aria-current="page">Logs</li>
                    </ol>
                </nav>

                <table class="table table-hover" id="TabelaProcurarLog" style="border: 1px solid #eee !important;">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Log</th>
                            <th>Data e Hora</th>
                        </tr>
                    </thead>

                    <tbody>';

                    $Query_Logs      =   "SELECT * FROM api_whatsapp_logs ORDER BY id DESC";
                    $Query_Logs_Exec =   mysql_query($Query_Logs);

                    while ($dados = mysql_fetch_array($Query_Logs_Exec)) {

                        echo '<tr>
                                <td>'.$dados['id'].'</td>
                                <td>'.$dados['Log'].'</td>
                                <td>'.$dados['Data'].'</td>
                        </tr>';

                    }
                    

                        echo '</tbody>
                </table>

                <div class="text-center" id="Log_Carregando">
                    <div class="alert alert-warning" role="alert" style="text-align: center;"><i class="fas fa-spinner fa-spin"></i> Carregando tabela.</div>
                </div>

            </div>

        </div>

    </div>';

}


function whatsapp_upgrade($vars) {

    // Versão 1.0.0 para 1.0.1

    try {
        
        foreach (Capsule::schema()->hasTable('api_whatsapp_configuracao')->WHERE("Nome_Modulo","Wappi_Whatsapp")->get() as $dados) {
            $Versao_DB  =   $dados->versao;
        }
        
    } catch (\Throwable $th) {
        //throw $th;
    }

    

    if(($Versao_DB != NULL)) {

    } else {

        // Se a tabela de configuração não existe cria!

        if (!Capsule::schema()->hasTable('api_whatsapp_configuracao')) {

            Capsule::schema()->create('api_whatsapp_configuracao', function ($table) {
                $table->increments('id');
                $table->string('Nome_Modulo');
                $table->string('versao');
            });

            // Add

            Capsule::table('api_whatsapp_configuracao')->insert([
                "Nome_Modulo"   =>  "Wappi_Whatsapp",
                "versao"    =>  '1.0.0'
            ]);

        }
    
    }

    // 1.0.1
    if(($Versao_DB < "1.0.1")) {

        if (!Capsule::schema()->hasTable('api_whatsapp_mensagens_rapidas')) {
        
            try {
    
                Capsule::schema()->create('api_whatsapp_mensagens_rapidas',function ($table) {
                    $table->increments('id');
                    $table->string('titulo');
                    $table->string('mensagem');
                    $table->string('status');
                });
    
            } catch (\Exception $e) {
    
                echo "Unable to create api_whatsapp_chat: {$e->getMessage()}";
    
            }
    
        }

        Capsule::table('api_whatsapp_configuracao')->WHERE("Nome_Modulo","Wappi_Whatsapp")->update([
            "versao"    =>  '1.0.1'
        ]);

        $schema = Capsule::schema();

        try {
            
            $schema->table('api_whatsapp_mensagens_chat', function($table) {
                $table->string('id_mensagem_resposta');
                $table->string('tipo_msg');
                $table->string('arquivo_name');
            });
            
        } catch (\Throwable $th) {
            //throw $th;
        }
        
        

    }

    // 1.0.2

    if(($Versao_DB < "1.0.2")) {        

        $schema = Capsule::schema();

        if (!Capsule::schema()->hasTable('api_whatsapp_fila_envio')) {
        
            try {
    
                Capsule::schema()->create('api_whatsapp_fila_envio',function ($table) {
                    $table->increments('id');
                    $table->string('numero');
                    $table->string('tipo_msg');
                    $table->longText('mensagem');
                    $table->string('arquivo');
                    $table->datetime('data_envio');
                    $table->string('status');
                });
    
            } catch (\Exception $e) {
    
                echo "Unable to create api_whatsapp_chat: {$e->getMessage()}";
    
            }
    
        }

        $schema->table('api_whatsapp_mensagens_chat', function($table) {
            $table->dropColumn('mensagem');
        });

        $schema->table('api_whatsapp_mensagens_chat', function($table) {
            $table->longText('mensagem');
        });
            
        Capsule::table('api_whatsapp_configuracao')->WHERE("Nome_Modulo","Wappi_Whatsapp")->update([
            "versao"    =>  '1.0.2'
        ]);

    }

    // 1.0.3

    if(($Versao_DB < "1.0.3")) {        
            
        Capsule::table('api_whatsapp_configuracao')->WHERE("Nome_Modulo","Wappi_Whatsapp")->update([
            "versao"    =>  '1.0.3'
        ]);

    }
	
		
	if(($Versao_DB < "1.0.5")) {        
            
        Capsule::table('api_whatsapp_configuracao')->WHERE("Nome_Modulo","Wappi_Whatsapp")->update([
            "versao"    =>  '1.0.5'
        ]);

    }


    

}



function whatsapp_clientarea($vars) {   

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    $wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // URL do Sistema WHMCS /////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $WHMCS_URLSISTEMA = rtrim(\App::getSystemUrl(),"/");

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

        $cliente = Illuminate\Database\Capsule\Manager::table("tblclients")->find($_SESSION["uid"]);

        foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
            $whatsapp_origem = $dados->id;
        }

        foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$cliente->id],])->get() as $dados) {
            $Wappi_NumeroWhatsappUm = preg_replace('/\D/', '', $dados->value);
        }

        $Wappi_NumeroWhatsapp    =   "+" . $Wappi_NumeroWhatsappUm;

    } else {

        $cliente = Illuminate\Database\Capsule\Manager::table("tblclients")->find($_SESSION["uid"]);

        $Wappi_NumeroWhatsapp = "+" . $cliente->phonenumber;

    }

    return array(
        'pagetitle' => 'Validação Whatsapp',
        'breadcrumb' => array('index.php?m=whatsapp'=>'Validação Whatsapp'),
        'templatefile' => 'templates/validacao',
        'requirelogin' => true, # accepts true/false
        'forcessl' => true, # accepts true/false
        'vars' => array(
            'id_cliente' => $_SESSION["uid"],
            'Telefone_Whatsapp' =>  $Wappi_NumeroWhatsapp
        ),
    );

}