<?php

date_default_timezone_set('America/Recife');

include_once(dirname(__FILE__) . "/../../../../init.php");
include_once(dirname(__FILE__) . "/../wappi_classes/App/wappi.php");
include_once(dirname(__FILE__) . "/../lang/portuguese-br.php");

//////////////////////////////////////////////////////////////////////////////////////////
// Gerencia sessoes //////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

use WHMCS\Session;

//////////////////////////////////////////////////////////////////////////////////////////
// API Carbon ////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

use Carbon\Carbon;

//////////////////////////////////////////////////////////////////////////////////////////
// API Laravel DataBase //////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

use WHMCS\Database\Capsule;

//////////////////////////////////////////////////////////////////////////////////////////

use wappi\App\Api\Cliente\Whatsapp;

//////////////////////////////////////////////////////////////////////////////////////////

if((!$_SESSION["adminid"])) {
    exit('Acesso restrito');
}

try {
    
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // Monta a estrutura interna do WHMCS pegando os dados da API ///////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   
    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Msg_FinalizarAtendimento']])->get() as $wappi) {
        $WHATSAPP_API_MSG_FINALIZAR_ATENDIMENTO    =   $wappi->value;
    }
    
} catch (\Throwable $th) { }

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

$wappi_classes   =   (new Whatsapp($WHATSAPP_API_URL,$WHATSAPP_API_SESSAO,$WHATSAPP_API_APIKEY));

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

if((isset($_POST["lista_chat"]))) {

    $sessao_admin   =   $_SESSION["adminid"];

    $chat = 0;

    $Query_Chats_left   =   'SELECT * FROM api_whatsapp_chat ORDER BY id DESC';

    $Query_Chats_left_Exec =   mysql_query($Query_Chats_left);

    $Query_Chats_leftCount =   mysql_query("SELECT * FROM api_whatsapp_chat");
    $Query_Chats_leftCount_rows = mysql_num_rows($Query_Chats_leftCount);


    while ($dados = mysql_fetch_array($Query_Chats_left_Exec)) {

        $Query_New_MsgCount =   mysql_query("SELECT * FROM api_whatsapp_mensagens_chat WHERE ticket = '" . $dados["ticket"] . "' AND status = '0'");
        $Query_New_MsgCount_rows = mysql_num_rows($Query_New_MsgCount);

        $ID_Chat_Ticket = $_GET["chat"];

        if(($sessao_admin == $dados["funcionario"]) || ($dados["status"] == "0")) {

            if(($dados["status"] != "3")) {

                foreach (Capsule::table('api_whatsapp_filaatendimento')->WHERE('Fila',$dados["departamento"])->get() as $value) {

                    $Usuarios_Permitidos    =   explode(",",$value->Usuarios);
    
                    foreach ($Usuarios_Permitidos as $key => $values) {

                        if(($values == $_SESSION["adminid"])) {
    
                            if(($dados["notificado"] < 1)) {
    
                                echo '<audio controls autoplay style="display:none;">
                                    <source src="../modules/addons/whatsapp/templates/audios/notificacao.mp3" type="audio/mpeg">
                                </audio>';
    
                                /*
                                Capsule::table('api_whatsapp_chat')->WHERE('ticket',$dados["ticket"])->update([
                                    "notificado"    =>   "1"
                                ]);
                                */
    
                            }
    
                            echo '<script>
    
                                $(document).ready(function() {
    
                                    $("#aceitarAtendimento_' . $dados["ticket"] . '").on("click", function() {
    
                                        var $this = $(this);
                                        $this.button("loading");
    
                                        setTimeout(function() {
                                            $this.button("reset"); 
                                        }, 8000);
    
                                        $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php", { aceitarAtendimento: true, id_chat: "' . $dados["ticket"] . '" });
    
                                        setTimeout(function() {
                                            window.location = "./addonmodules.php?module=whatsapp&chat=' . $dados["ticket"] . '"; 
                                        }, 2000);
    
                                    });
    
                                });
    
                            </script>
    
                            <li>
    
                                <a href="./addonmodules.php?module=whatsapp&chat=' . $dados["ticket"] . '" class="' . ($dados["status"] == 0 ? 'disabled' : '') . ' ' . ($_POST["in_chat"] == $dados["ticket"] ? 'nochat' : '') . '">
    
                                    <div class="foto" style="background: url(' . $dados["foto_cliente_sessao"] . '); background-size: 100% 100%;"></div>
                                    <div class="informacao">
                                        <p>
                                            ' . ($Nome_Cliente != NULL ? $Nome_Cliente : $dados["send_id"]) . '<br>
                                            FILA: <strong>' . $dados["departamento"] . '</strong>
    
                                            ' . ($Query_New_MsgCount_rows > 0 ? '<span class="new_msg">' . $Query_New_MsgCount_rows . '</span>' : '' ) . '
    
                                        </p>
                                    </div> 
    
                                </a>
    
                                ' . ($dados["status"] == 0 ? '<center><button class="btn btn-primary" id="aceitarAtendimento_' . $dados["ticket"] . '" data-loading-text="<i class=\'fad fa-spinner fa-spin\' style=\'margin-right: 5px;\'></i> Carregando" style="color: #FFF;">ACEITAR</button></center>' : '') . '
                            
                            </li>';
    
                        }
                        
                    }
    
                }

            }

            $chat++;

        }

    }

}


if((isset($_POST["lista_chat_bottom"]))) {

    $sessao_admin   =   $_SESSION["adminid"];

    $chat = 0;

    $Query_Chats_left   =   'SELECT * FROM api_whatsapp_chat WHERE status = "0" ORDER BY id DESC';

    $Query_Chats_left_Exec =   mysql_query($Query_Chats_left);

    $Query_Chats_leftCount =   mysql_query("SELECT * FROM api_whatsapp_chat");
    $Query_Chats_leftCount_rows = mysql_num_rows($Query_Chats_leftCount);

    while ($dados = mysql_fetch_array($Query_Chats_left_Exec)) {

        $Query_New_MsgCount =   mysql_query("SELECT * FROM api_whatsapp_mensagens_chat WHERE ticket = '" . $dados["ticket"] . "' AND status = '0'");
        $Query_New_MsgCount_rows = mysql_num_rows($Query_New_MsgCount);

        if(($sessao_admin == $dados["funcionario"]) || ($dados["status"] == "0")) {

            if(($dados["status"] != "3")) {

                foreach (Capsule::table('api_whatsapp_filaatendimento')->WHERE('Fila',$dados["departamento"])->get() as $value) {

                    $Usuarios_Permitidos    =   explode(",",$value->Usuarios);

                    foreach ($Usuarios_Permitidos as $key => $values) {

                        if(($values == $_SESSION["adminid"])) {

                            $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('NUMERO_WHATSAPP',$dados["send_id"])->get();

                            if(($CodigoBancoDados[0]->NUMERO_WHATSAPP != NULL)) {

                                foreach (Capsule::table('tblclients')->WHERE('id',$CodigoBancoDados[0]->ID_CLIENTE_WHMCS)->get() as $cliente_informacao) {
                                    
                                    $Nome_Cliente   =   $cliente_informacao->firstname;
                                    
                                }

                            }

                            
                            if(($dados["notificado"] < 1)) {
    
                                echo '<audio controls autoplay style="display:none;">
                                    <source src="../modules/addons/whatsapp/templates/audios/notificacao.mp3" type="audio/mpeg">
                                </audio>';
    
                                /*
                                Capsule::table('api_whatsapp_chat')->WHERE('ticket',$dados["ticket"])->update([
                                    "notificado"    =>   "1"
                                ]);
                                */
    
                            }
                            

                            echo '<script>

                                $(document).ready(function() {
    
                                    $("#aceitarAtendimento_' . $dados["ticket"] . '").on("click", function() {
    
                                        var $this = $(this);
                                        $this.button("loading");
    
                                        setTimeout(function() {
                                            $this.button("reset"); 
                                        }, 8000);
    
                                        $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php", { aceitarAtendimento: true, id_chat: "' . $dados["ticket"] . '" });
    
                                        setTimeout(function() {
                                            window.location = "./addonmodules.php?module=whatsapp&chat=' . $dados["ticket"] . '"; 
                                        }, 2000);
    
                                    });
    
                                });
    
                            </script>
                            
                            <li>
    
                                <a href="./addonmodules.php?module=whatsapp&chat=' . $dados["ticket"] . '" class="disabled">

                                    <div class="foto" style="background: url(' . $dados["foto_cliente_sessao"] . '); background-size: 100% 100% !important; width: 77px;"></div>
                                    <div class="informacao">
                                        <p>
                                            ' . ($Nome_Cliente != NULL ? $Nome_Cliente : $dados["send_id"]) . '<br>
                                            FILA: <strong>' . $dados["departamento"] . '</strong>

                                            ' . ($Query_New_MsgCount_rows > 0 ? '<span class="new_msg">' . $Query_New_MsgCount_rows . '</span>' : '' ) . '

                                        </p>
                                    </div> 

                                </a>

                                ' . ($dados["status"] == 0 ? '<center><button class="btn btn-primary" id="aceitarAtendimento_' . $dados["ticket"] . '" data-loading-text="<i class=\'fad fa-spinner fa-spin\' style=\'margin-right: 5px;\'></i> Carregando" style="color: #FFF;">ACEITAR</button></center>' : '') . '
                            
                            </li>';

                        }

                    }

                }

            }
        }

    }

}


if((isset($_POST["message"]))) {

    if((isset($_POST["message"]) && isset($_POST["id_chat"]))) {

        foreach (Capsule::table('api_whatsapp_chat')->WHERE('ticket',$_POST["id_chat"])->get() as $info) {
            $Numero_Cliente =   $info->send_id;
            $Numero_Recebeu =   $info->recev_id;
            $Foto_Cliente   =   $info->foto_cliente_sessao;
            $ID_Admin_Sessao    =   $info->funcionario;
        }

        foreach (Capsule::table('tbladmins')->WHERE('id',$ID_Admin_Sessao)->get() as $info) {
            $Nome_Admin =   $info->firstname . " " . $info->lastname;
        }
    
        $send_mensagem  =   $wappi_classes->EnviarMensagemTexto($Numero_Cliente,"*" . $Nome_Admin . "* \n" . $_POST["message"]);
    
        if(($send_mensagem["status"] == 200)) {

            $StaffAtual =   Capsule::table('tbladmins')->WHERE('id',$ID_Admin_Sessao)->get();
    
            Capsule::table('api_whatsapp_mensagens_chat')->insert([
    
                "id_mensagem"   =>  $send_mensagem["id"],
                "ticket"    =>  $_POST["id_chat"],
                "send_id"   =>  $Numero_Recebeu,
                "recev_id"  =>  $Numero_Cliente,
                "mensagem"  =>  $_POST["message"],
                "data"      =>  date("Y-m-d h:i:s"),
                "nome_funcionario"  =>  $StaffAtual[0]->firstname . ' ' . $StaffAtual[0]->lastname,
                "tipo_msg"  =>  "text",
                "status"    => "0"
        
            ]);
    
        }

    }
        
}


if(($_POST["acao"] == "atualizarChatSozinho")) {

    $opend  =   0;

    foreach (Capsule::table('api_whatsapp_mensagens_chat')->WHERE([ ['ticket',$_POST["id_chat"]], ['status',"0"] ])->get() as $chat) {   

        foreach (Capsule::table('api_whatsapp_chat')->WHERE('ticket',$_POST["id_chat"])->get() as $info) {
            $Foto_Cliente   =   $info->foto_cliente_sessao;
            $Numero_SendAdmin   =   $info->recev_id;
            $ID_Admin_Sessao    =   $info->funcionario;
        }

        foreach (Capsule::table('tbladmins')->WHERE('id',$ID_Admin_Sessao)->get() as $info) {
            $Nome_Admin =   $info->firstname . " " . $info->lastname;
        }

        $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('NUMERO_WHATSAPP',$chat->send_id)->get();

        if(($CodigoBancoDados[0]->NUMERO_WHATSAPP != NULL)) {

            foreach (Capsule::table('tblclients')->WHERE('id',$CodigoBancoDados[0]->ID_CLIENTE_WHMCS)->get() as $cliente_informacao) {
                
                $Nome_Cliente   =   $cliente_informacao->firstname;
                
            }

        }
        
        $date = new DateTime($chat->data);

        $arquivo_msg = (str_contains($chat->arquivo_name, "./") == true ? $WHATSAPP_API_URL . "/" . str_replace("./files/","",$chat->arquivo_name) : $chat->arquivo_name);

        if(($chat->tipo_msg == "image")) {

            echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">

                <div style="margin-bottom: 20px;"></div>

                <div style="position:relative;width:100%;">

                    <div class="conteudo" style="">
                        <p>
                            <a href="#' . $arquivo_msg . '">
                                <img src="' . $arquivo_msg . '" style="max-width: 150px;padding: 5px;' . ($Numero_SendAdmin == $chat->send_id ? 'background: #D9FDD3; right:0px;' : 'background: #ffffff; left:0px;') . '">
                            </a>
                        </p>
                        <div class="time" style="position: absolute; ' . ($Numero_SendAdmin == $chat->send_id ? 'bottom: 13px;right: 13px;' : 'bottom: 15px;left: 19px;') . ' text-shadow: 0.1em 0.1em 0.2em #000; color: #fff">' . $date->format('d/m') . ' as <smile>' . $date->format('H:i') . '</smile></div>
                        <div id="' . $arquivo_msg . '" class="overlay">
                            <div class="popup">
                                <a class="close_popup btn btn-danger" href="#">&times;</a>
                                <div class="content">
                                    <img src="' . $arquivo_msg . '" style="max-width: 90%;">
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>';

        } elseif(($chat->tipo_msg == "video")) {
                                    
            echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">

                <div class="nome">
                    <div class="foto" style="background: url(' . ($Numero_SendAdmin == $chat->send_id ? '../modules/addons/whatsapp/templates/imagens/admin.png' : $Foto_Cliente) . '); background-size: 100% 100%;"></div>
                    ' . ($Numero_SendAdmin == $chat->send_id ? $chat->nome_funcionario : ($Nome_Cliente != NULL ? $Nome_Cliente : $chat->send_id)) . '
                </div>
                <div class="time">' . $date->format('d/m/Y') . ' as <span>' . $date->format('H:i') . '</span></div>

                <div class="clear"></div>
                <div class="conteudo">
                    <p>
                        <video width="320" controls>
                            <source src="' . $arquivo_msg . '" type="video/mp4">
                            Seu navegador não suporta este tipo de arquivo.
                        </video>
                    </p>
                </div>
            
            </div>';

        } elseif(($chat->tipo_msg == "voice")) {

            echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">

                <div class="nome">
                    <div class="foto" style="background: url(' . ($Numero_SendAdmin == $chat->send_id ? '../modules/addons/whatsapp/templates/imagens/admin.png' : $Foto_Cliente) . '); background-size: 100% 100%;"></div>
                    ' . ($Numero_SendAdmin == $chat->send_id ? $chat->nome_funcionario : ($Nome_Cliente != NULL ? $Nome_Cliente : $chat->send_id)) . '
                </div>
                <div class="time">' . $date->format('d/m/Y') . ' as <span>' . $date->format('H:i') . '</span></div>

                <div class="clear"></div>
                <div class="conteudo">
                    <p>
                        <audio controls>
                            <source src="' . $arquivo_msg . '" type="audio/ogg">
                            Seu navegador não suporta este tipo de arquivo.
                        </audio>
                    </p>
                </div>
            
            </div>';

        } elseif(($chat->tipo_msg == "document")) {

            echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">

                <div class="nome">
                    <div class="foto" style="background: url(' . ($Numero_SendAdmin == $chat->send_id ? '../modules/addons/whatsapp/templates/imagens/admin.png' : $Foto_Cliente) . '); background-size: 100% 100%;"></div>
                    ' . ($Numero_SendAdmin == $chat->send_id ? $chat->nome_funcionario : ($Nome_Cliente != NULL ? $Nome_Cliente : $chat->send_id)) . '
                </div>
                <div class="time">' . $date->format('d/m/Y') . ' as <span>' . $date->format('H:i') . '</span></div>

                <div class="clear"></div>
                <div class="conteudo">
                    <p>
                        <a href="' . $arquivo_msg . '" class="btn btn-danger" target="_blank"><i class="far fa-eye" style="margin-right: 5px;"></i> Ver Documento</a>
                    </p>
                </div>
            
            </div>';
        
        } elseif(($chat->tipo_msg == "text")) {

            echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">
                                    
                <div style="margin-bottom: 20px;"></div>
                <div style="position:relative;width:100%;">
                    <div class="conteudo" style="' . ($Numero_SendAdmin == $chat->send_id ? 'background: #D9FDD3; max-width:calc(100% - 360px); position:absolute;right:0px;' : 'background: #ffffff; max-width:calc(100% - 360px); position:absolute;left:0px;') . '">
                        <p>' . htmlspecialchars($chat->mensagem) . '
                        <span class="time"> ' . $date->format('d/m') . ' <span>' . $date->format('H:i') . '</span></span></p>
                    </div>
                </div>
            
            </div>';

        } elseif(($chat->tipo_msg == "reply")) {

            $resposta   =   Capsule::table('api_whatsapp_mensagens_chat')->WHERE('id_mensagem',$chat->id_mensagem_resposta)->get();
                
            echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">

                <div class="nome">
                    <div class="foto" style="background: url(' . ($Numero_SendAdmin == $chat->send_id ? '../modules/addons/whatsapp/templates/imagens/admin.png' : $Foto_Cliente) . '); background-size: 100% 100%;"></div>
                    ' . ($Numero_SendAdmin == $chat->send_id ? $chat->nome_funcionario : ($Nome_Cliente != NULL ? $Nome_Cliente : $chat->send_id)) . '
                </div>
                <div class="time">' . $date->format('d/m/Y') . ' as <span>' . $date->format('H:i') . '</span></div>

                <div class="clear"></div>
                <div class="conteudo" style="background-color: #E8E8E8; padding: 10px 20px;">
                    <p style="width: 99%; float: left;">' . htmlspecialchars($resposta[0]->mensagem) . '</p>
                    <i class="fas fa-angle-down"></i>
                </div>';

                $TipoArquivos    =   explode(".",$arquivo_msg);

                if(($TipoArquivos[5] != NULL)) {

                    $TipoArquivo    =   $TipoArquivos[5];

                } else {

                    $TipoArquivo    =   $TipoArquivos[4];

                }

                switch ($TipoArquivo) {

                    case 'jpeg':
                    case 'png':
                    case 'gif':
                    case 'jpg':

                        echo '<div class="conteudo" style="border-left: 4px solid  #E8E8E8;">
                            <p>
                                <a href="#' . $arquivo_msg . '"><img src="' . $arquivo_msg . '" style="max-width: 150px;"></a>
                            </p>

                            <div id="' . $arquivo_msg . '" class="overlay">
                                <div class="popup">
                                    <a class="close_popup btn btn-danger" href="#">&times;</a>
                                    <div class="content">
                                        <img src="' . $arquivo_msg . '" style="max-width: 100%;">
                                    </div>
                                </div>
                            </div>
                        </div>';
                        break;

                    case 'ogg':
                    case 'mp3':

                        echo '<div class="conteudo" style="border-left: 4px solid  #E8E8E8;">
                            <p>
                                <audio controls>
                                    <source src="' . $arquivo_msg . '" type="audio/ogg">
                                    Seu navegador não suporta este tipo de arquivo.
                                </audio>
                            </p>

                        </div>';
                        break;
                        
                    case 'mp4':

                        echo '<div class="conteudo" style="border-left: 4px solid  #E8E8E8;">
                            <p>
                                <video width="320" controls>
                                    <source src="' . $arquivo_msg . '" type="video/mp4">
                                    Seu navegador não suporta este tipo de arquivo.
                                </video>
                            </p>

                        </div>';
                        break;

                    case 'pdf':

                        echo '<div class="conteudo" style="border-left: 4px solid  #E8E8E8;">
                            <p>
                                <a href="' . $arquivo_msg . '" class="btn btn-danger" target="_blank"><i class="far fa-eye" style="margin-right: 5px;"></i> ' . BOTAO_VER_DOCUMENTO . '</a>
                            </p>

                        </div>';
                        break;
                    
                    default:

                        echo '<div class="conteudo" style="border-left: 4px solid  #E8E8E8;"><p>' . htmlspecialchars($chat->mensagem) . '</p></div>';
                        break;
                        
                }
                
            echo '</div>';

        } else {
                                    
            echo '<div class="chat_recebido" id="' . $chat->id_mensagem . '">

                <div class="nome">
                    <div class="foto" style="background: url(' . ($Numero_SendAdmin == $chat->send_id ? '../modules/addons/whatsapp/templates/imagens/admin.png' : $Foto_Cliente) . '); background-size: 100% 100%;"></div>
                    ' . ($Numero_SendAdmin == $chat->send_id ? $chat->nome_funcionario : ($Nome_Cliente_Whatsapp != NULL ? $Nome_Cliente_Whatsapp : $chat->send_id)) . '
                </div>
                <div class="time">' . $date->format('d/m/Y') . ' as <span>' . $date->format('H:i') . '</span></div>

                <div class="clear"></div>
                <div class="conteudo"><p>' . htmlspecialchars($chat->mensagem) . '</p></div>
            
            </div>';

        }

        if(($chat->status == 0)) {

            // Notifica

            echo '<audio controls autoplay style="display:none;">
                <source src="../modules/addons/whatsapp/templates/audios/notificacao_newmsg.mp3" type="audio/mpeg">
            </audio>
            
            <script>

                var scrollDown = function() {

                    $("#mensagens_chat").animate({

                        scrollTop: 100000000000000000000

                    }, 50);

                }

                scrollDown();

            </script>';

            Capsule::table('api_whatsapp_mensagens_chat')->WHERE('id',$chat->id)->update([

                'status'    =>  '1'
            
            ]);

            $wappi_classes->MarcarMensagensLida($chat->send_id);

        } 

        # code...
    }

}


if((isset($_POST["aceitarAtendimento"]))) {

    $ChatRecebido   =   Capsule::table('api_whatsapp_chat')->WHERE('ticket',$_POST["id_chat"])->get();

    if(($ChatRecebido[0]->status == 0)) {

        Capsule::table('api_whatsapp_chat')->WHERE('ticket',$ChatRecebido[0]->ticket)->update([

            'funcionario'   =>  $_SESSION["adminid"],
            'notificado'    =>  '1',
            'status'    =>  '1'
        
        ]);
		
		foreach (Capsule::table('tbladmins')->WHERE('id',$_SESSION["adminid"])->get() as $admin) {
            $Nome_Admin =   $admin->firstname . " " . $admin->lastname;
        }

        // Trata as strings para o template da mensagem
        $alteracao_stings_msg_whatsapp = array(
            "{nome_admin}"
        );

        $alteracao_stings_msg_whatsapp_novos = array(
            $Nome_Admin 
        );

        $Wappi_Whatsapp_Mensagem = str_replace($alteracao_stings_msg_whatsapp, $alteracao_stings_msg_whatsapp_novos, MSG_ADMIN_ENTRARCHAT);

        $wappi_classes->EnviarMensagemTexto($ChatRecebido[0]->send_id,$Wappi_Whatsapp_Mensagem);

    }
    
}


if((isset($_POST["terminarAtendimento"]))) {

    $ChatRecebido   =   Capsule::table('api_whatsapp_chat')->WHERE('ticket',$_POST["id_chat"])->get();

    $wappi_classes->EnviarMensagemTexto($ChatRecebido[0]->send_id,$WHATSAPP_API_MSG_FINALIZAR_ATENDIMENTO);

    $wappi_classes->ArquivarChat($ChatRecebido[0]->send_id);

    Capsule::table('api_whatsapp_chat')->WHERE('ticket',$_POST["id_chat"])->update([

        'status'    =>  '3'
    
    ]);

    //Capsule::table('api_whatsapp_chat')->WHERE('ticket',$_POST["id_chat"])->delete();
    //Capsule::table('api_whatsapp_mensagens_chat')->WHERE('ticket',$_POST["id_chat"])->delete();

    
}

if((isset($_POST["buscarCliente"]))) {

    $Nome_Cliente   =   explode(" ",$_POST["cliente"]);

    if(($_POST["cliente"] == NULL)) {
        
        exit('<div class="alert alert-danger" role="alert">
            <i class="fal fa-times-circle"></i> Você deve informar um nome de cliente para continuar.
        </div>');
        
    } else {

        $dados_buscaCliente =   Capsule::table('tblclients')->WHERE([ ['firstname','like','%' . $Nome_Cliente[0] . '%'], ['lastname', 'like', '%' . $Nome_Cliente[1] . '%'] ])->get();

        if(($dados_buscaCliente[0] == NULL)) {

            exit('<div class="alert alert-danger" role="alert">
                <i class="fal fa-exclamation-circle"></i> Não existe resultados para esta busca.
            </div>');

        }

        foreach (Capsule::table('tblclients')->WHERE([ ['firstname','like','%' . $Nome_Cliente[0] . '%'], ['lastname', 'like', '%' . $Nome_Cliente[1] . '%'] ])->get() as $cliente) {

            if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

                foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                    $whatsapp_origem = $dados->id;
                }
        
                foreach (Capsule::table('tblcustomfieldsvalues')->where([['fieldid',$whatsapp_origem],['relid',$cliente->id],])->get() as $dados) {
                    $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', ($pais_Cliente == 'BR' ? '55' : '') . $dados->value), 0);
                }
        
            } else {
        
                $Wappi_NumeroWhatsapp = ltrim(preg_replace('/\D/', '', $cliente->phonenumber), 0);
        
            }

            $Foto_Cliente   =   $wappi_classes->FotoPerfilChat($Wappi_NumeroWhatsapp);

            $FotoTratada    =   ($Foto_Cliente["picture"] != NULL ? $Foto_Cliente["picture"] : '../modules/addons/whatsapp/templates/imagens/nophoto.png' );

            $sessao_admin   =   $_SESSION["adminid"];

            echo '<div class="new_Ticket_Usuario">

                <div class="foto" style="background-image: url(' . ($Foto_Cliente["picture"] != NULL ? $Foto_Cliente["picture"] : '../modules/addons/whatsapp/templates/imagens/nophoto.png' ) . '); background-size: 100% 100%;"></div>
                <div class="texto">
                    <li>' . $cliente->firstname . ' ' . $cliente->lastname . '</li>
                    <li>' . $cliente->email . '</li>
                </div>

                <div class="departamentos">
                
                    <select id="departamentos">';

                    foreach (Capsule::table('api_whatsapp_filaatendimento')->get() as $departamento) {

                       echo '<option value="' . $departamento->Fila . '">' . $departamento->Fila . '</option>';
        
                    }
                    
                    echo '</select>

                </div>

                <div class="botoes">

                    <script>

                        $(document).ready(function() {
                                            
                            $("#AbrirTicket-' . $cliente->id . '").on("click", function() {

                                var Depart    =   $("#departamentos").val();

                                var $this = $(this);
                                $this.button("loading");

                                setTimeout(function() {
                                    $this.button("reset"); 
                                }, 15000);

                                $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php",{
                                    AbrirTicketCliente: true,
                                    fila: Depart,
                                    id: "' . $Wappi_NumeroWhatsapp . '",
                                    foto: "' . $FotoTratada . '",
                                    funcionario: "' . $sessao_admin . '"
                                },
                                function(data, status) {
                                    $("#resultado_find_Cliente").html(data);
                                });

                            });

                        });

                    </script>

                    <button data-loading-text="<i class=\'fad fa-spinner fa-spin\' style=\'margin-right: 5px;\'></i> Abrindo um atendimennto" type="button" id="AbrirTicket-' . $cliente->id . '" class="btn btn-success"><i class="fal fa-plus-circle"></i> Iniciar</button>

                </div>

            </div>';

        }

    }

}

if((isset($_POST["AbrirTicketCliente"]))) {

    $ID_Ticket  =   uniqid();

    if(($_POST["id"] != NULL)) {

        Capsule::table('api_whatsapp_chat')->insert([

            "ticket"    =>  $ID_Ticket,
            "send_id"   =>  $_POST["id"],
            "departamento"  =>  $_POST["fila"],
            "foto_cliente_sessao"   =>  $_POST['foto'],
            "funcionario"   =>  $_POST['funcionario'],
            "notificado"    =>  "1",
            "status"    => "1"
    
        ]);
        
        $wappi_classes->PinChat($_POST["id"]);
    
        echo '<div class="alert alert-success" role="alert">
            Atendimento aberto com sucesso. ID: <strong>' . $ID_Ticket . '</strong>, aguarde estamos redirecionando você.
        </div>
        
        <meta http-equiv="refresh" content="0;url=./addonmodules.php?module=whatsapp&chat=' . $ID_Ticket . '">';

    } else {

        echo '<div class="alert alert-danger" role="alert">
            Ops não foi possivel iniciar este atendimento tente novamente.
        </div>
        
        <meta http-equiv="refresh" content="0;url=./addonmodules.php?module=whatsapp">';

    }

}


if((isset($_POST["buscarNumeroPost"]))) {

    if(($_POST["numero"] == NULL)) {
        
        return '';
        
    } else {

        $sessao_admin   =   $_SESSION["adminid"];
   
        $sql    =   Capsule::table('api_whatsapp_chat')->WHERE('send_id','like','%'. $_POST["numero"] . '%')->get();

        if(($sql[0] == NULL)) {

            echo '<div class="alert alert-info" role="alert" style="text-align: center;">
                Nenhum resultado encontrado.
            </div>';
            exit();

        }
        
        foreach ($sql as $chat_left) {

            if(($chat_left->id != NULL)) {
    
                if(($sessao_admin == $chat_left->funcionario) || ($chat_left->status == "0")) {
    
                    foreach (Capsule::table('api_whatsapp_filaatendimento')->WHERE('Fila',$chat_left->departamento)->get() as $value) {
    
                        $Usuarios_Permitidos    =   explode(",",$value->Usuarios);
    
                        foreach ($Usuarios_Permitidos as $key => $values) {
    
                            if(($values == $_SESSION["adminid"])) {
    
                                echo '<script>
            
                                    $(document).ready(function() {
            
                                        $("#aceitarAtendimento_' . $chat_left->ticket . '").on("click", function() {
            
                                            var $this = $(this);
                                            $this.button("loading");
            
                                            setTimeout(function() {
                                                $this.button("reset"); 
                                            }, 8000);
            
                                            $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php", { aceitarAtendimento: true, id_chat: "' . $chat_left->ticket . '" });
            
                                            window.location = "./addonmodules.php?module=whatsapp&chat=' . $chat_left->ticket . '"; 
            
                                        });
            
                                    });
            
                                </script>
    
                                
                                <li>
            
                                    <a href="./addonmodules.php?module=whatsapp&chat=' . $chat_left->ticket . '" class="' . ($chat_left->status == 0 ? 'disabled' : '') . ' ' . ($_POST["in_chat"] == $chat_left->ticket ? 'nochat' : '') . '">
            
                                        <div class="foto" style="background: url(' . $chat_left->foto_cliente_sessao . '); background-size: 100% 100%;"></div>
                                        <div class="informacao">
                                            <p>
                                                ' . $chat_left->send_id . '<br>
                                                <strong>' . $chat_left->departamento . '</strong>
            
                                            </p>
                                        </div> 
            
                                    </a>
            
                                    ' . ($chat_left->status == 0 ? '<center><button class="btn btn-primary" id="aceitarAtendimento_' . $chat_left->ticket . '" data-loading-text="<i class=\'fad fa-spinner fa-spin\' style=\'margin-right: 5px;\'></i> Carregando" style="color: #FFF;">ACEITAR</button></center>' : '') . '
                                
                                </li>';
    
                            }
    
                        }
    
                    }
    
                }
    
            }
    
            # code...
        }

    }

}

if((isset($_POST["buscarCliente_vincularCliente"]))) {

    $Nome_Cliente   =   explode(" ",$_POST["cliente"]);

    if(($_POST["cliente"] == NULL)) {
        
        exit('<div class="alert alert-danger" role="alert">
            <i class="fal fa-times-circle"></i> Você deve informar um nome de cliente para continuar.
        </div>');
        
    } else {

        $dados_buscaCliente =   Capsule::table('tblclients')->WHERE([ ['firstname','like','%' . $Nome_Cliente[0] . '%'], ['lastname', 'like', '%' . $Nome_Cliente[1] . '%'] ])->get();

        if(($dados_buscaCliente[0] == NULL)) {

            exit('<div class="alert alert-danger" role="alert">
                <i class="fal fa-exclamation-circle"></i> Não existe resultados para esta busca.
            </div>');

        }

        echo '<table class="table table-bordered">
        
        <thead>
            <tr>
            <th scope="col">ID</th>
            <th scope="col">Nome</th>
            <th scope="col">Email</th>
            <th scope="col">Ação</th>
            </tr>
        </thead>
        <tbody>';

        foreach (Capsule::table('tblclients')->WHERE([ ['firstname','like','%' . $Nome_Cliente[0] . '%'], ['lastname', 'like', '%' . $Nome_Cliente[1] . '%'] ])->get() as $cliente) {

           echo '<tr>
                <th scope="row">' . $cliente->id . '</th>
                <td>' . $cliente->firstname . ' ' . $cliente->lastname . '</td>
                <td>' . $cliente->email . '</td>
                <td>
                
                    <script>

                        $(document).ready(function() {
                                            
                            $("#Vincular-' . $cliente->id . '").on("click", function() {

                                var $this = $(this);
                                $this.button("loading");

                                setTimeout(function() {
                                    $this.button("reset"); 
                                }, 15000);

                                $.post("../modules/addons/whatsapp/wappi_ajax/update_fila.php",{
                                    VincularCliente: true,
                                    idCliente: "' . $cliente->id . '",
                                    NumeroWhatsapp: "' . $_POST["NumeroWhatsapp"] . '"
                                },
                                function(data, status) {
                                    $("#resultado_find_vincularCliente").html(data);
                                });

                            });

                        });

                    </script>

                    <button data-loading-text="<i class=\'fad fa-spinner fa-spin\' style=\'margin-right: 5px;\'></i> Vinculando" type="button" id="Vincular-' . $cliente->id . '" class="btn btn-success"> Vincular</button>

                </td>
            </tr>';

        }

        echo '</tbody>
        </table>';

    }

}

if((isset($_POST["VincularCliente"]))) {

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_URL']])->get() as $wappi) {
        $WHATSAPP_API_URL    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_Sessao']])->get() as $wappi) {
        $WHATSAPP_API_SESSAO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Addon_Whatsapp_ApiKey']])->get() as $wappi) {
        $WHATSAPP_API_APIKEY    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Validacao_Whatsapp']])->get() as $wappi) {
        $WHATSAPP_API_VALIDACAOWHATSAPP    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Metodo_Envio']])->get() as $wappi) {
        $WHATSAPP_API_METODO_ENVIO    =   $wappi->value;
    }

    foreach (WHMCS\Database\Capsule::table('tbladdonmodules')->WHERE([['module', 'whatsapp'],['setting', 'Api_Whatsapp_Assinatura']])->get() as $wappi) {
        $WHATSAPP_API_ASSINATURA    =   $wappi->value;
    }

    $CodigoBancoDados   =   Capsule::table('api_whatsapp_validacao_whatsapp')->where('ID_CLIENTE_WHMCS',$_POST["idCliente"])->get();


    if(($CodigoBancoDados[0] != NULL)) {

        if(($CodigoBancoDados[0]->NUMERO_WHATSAPP == $_POST["NumeroWhatsapp"])) {

            echo '<div class="alert alert-warning" role="alert">
                O cliente de ID ' . $_POST["idCliente"] . ' já esta vinculado a este telefone.
            </div>
            
            <meta http-equiv="refresh" content="0;url=./addonmodules.php?module=whatsapp">';
    
        } else {
    
            if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

                foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                    $whatsapp_origem = $dados->id;
                }
    
                Capsule::table('tblcustomfieldsvalues')->where([ ['fieldid',$whatsapp_origem], ['relid',$_POST["idCliente"]] ])->update([
                    "value" =>  $_POST["NumeroWhatsapp"]
                ]);

                echo '<div class="alert alert-success" role="alert">
                    Whatsapp vinculado a conta de ID ' . $_POST["idCliente"] . '
                </div>
                
                <meta http-equiv="refresh" content="0;url=./addonmodules.php?module=whatsapp">';
    
            } else {
    
                Capsule::table('tblclients')->where("id",$_POST["idCliente"])->update([
                    "phonenumber" =>  "+" . $_POST["NumeroWhatsapp"]
                ]);

                echo '<div class="alert alert-success" role="alert">
                    Whatsapp vinculado a conta de ID ' . $_POST["idCliente"] . '
                </div>
                
                <meta http-equiv="refresh" content="0;url=./addonmodules.php?module=whatsapp">';
    
            }
    
        }

    } else {

        Capsule::table('api_whatsapp_validacao_whatsapp')->insert([

            "ID_CLIENTE_WHMCS"  =>  $_POST["idCliente"],
            "NUMERO_WHATSAPP"   =>  $_POST["NumeroWhatsapp"],
            "CODIGO_VALIDACAO"  =>  "VINCULADO",
            "status"            =>  "1"

        ]);

        if(($WHATSAPP_API_METODO_ENVIO != "Campo padrão WHMCS")) {

            foreach (Capsule::table('tblcustomfields')->where('fieldname',$WHATSAPP_API_METODO_ENVIO)->get() as $dados) {
                $whatsapp_origem = $dados->id;
            }

            Capsule::table('tblcustomfieldsvalues')->where([ ['fieldid',$whatsapp_origem], ['relid',$_POST["idCliente"]] ])->update([
                "value" =>  $_POST["NumeroWhatsapp"]
            ]);

            echo '<div class="alert alert-success" role="alert">
                Whatsapp vinculado a conta de ID ' . $_POST["idCliente"] . '
            </div>
            
            <meta http-equiv="refresh" content="0;url=./addonmodules.php?module=whatsapp">';

        } else {

            Capsule::table('tblclients')->where("id",$_POST["idCliente"])->update([
                "phonenumber" =>  "+" . $_POST["NumeroWhatsapp"]
            ]);

            echo '<div class="alert alert-success" role="alert">
                Whatsapp vinculado a conta de ID ' . $_POST["idCliente"] . '
            </div>
            
            <meta http-equiv="refresh" content="0;url=./addonmodules.php?module=whatsapp">';

        }

    }

    


}