<div id="rs-module">
    <div class="app app--navbar-top app--navbar-h-simple">
        {include file="adminarea/header.tpl"} 
        {include file="adminarea/navbar.tpl"}
        <div class="app-main">
            <div class="app-main__header">
                <div class="app-main__top p-b-0x">
                    <div class="container">
                        <div class="top">
                            <div class="top__content">
                                <div class="top__title">
                                    <h1 class="top__title-text">Installed Themes</h1>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="app-main__body">
                <div class="container">
                    <div class="row row--eq-height">
                        {foreach name=templatesLoop from=$templates key=k item=template}
                            <div class="col-4">
                                <div class="widget">
                                    <a class="widget__media has-overlay" href="#modalPreview-layers-preview-{$k}" data-toggle="lu-modal">
                                        <div class="widget__overlay">
                                            <div class="widget__content">
                                                <div class="msg">
                                                    <div class="msg__icon i-circled  bg-white">
                                                        <span class="i-c zmdi zmdi-zoom-in text-default"></span>
                                                    </div>
                                                    <div class="msg__body">
                                                        <div class="msg__title type-7">Click to zoom in</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        {if $template->getPreview()}
                                            <img src="{$template->getPreview()}" alt=""/>
                                        {else}
                                            <img src="{$helper->img('/placeholders/placeholder-xs.svg')}" alt=""/>
                                        {/if}
                                    </a>
                                    <div class="widget__actions widget__actions--raised flex flex-items-xs-between">
                                        {if $template->newVersionAvailable()}
                                            <span id="newVersion">New version is available! {$template->newVersion()}</span>
                                        {/if}
                                        {if $template->license()->hasProblem()}
                                            <span id="newVersion">{$template->license()->getProblem()}</span>
                                        {/if}
                                        <span class="rail">
                                            <span class="type-6">{$template->getName()}</span>
                                            {if $template->isActive()}<span class="label label--outline label--success m-l-2x">Active</span>{/if}
                                            {*{$template->getName()} {$template->getVersion()} {$template->getDescription()}*}
                                        </span>
                                        <div class="p-0x">
                                            {if $template->license()->isActive()}
                                                <a class="btn btn--sm btn--icon btn--link" href="{$template->getSysTplLink()}" target="_blank" data-toggle="lu-tooltip" data-options="classes: lu-tooltip" data-title="Live preview">
                                                    <i class="btn__icon zmdi zmdi-search-in-file"></i>
                                                </a>
                                            {/if}
                                            <a class="btn btn--sm btn--default btn--outline" href="{$helper->url('Template@info',['templateName'=>$template->getMainName()])}">
                                                <span class="btn__text">Manage Theme</span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div id="modalPreview-layers-preview-{$k}" class="modal modal--preview">
                                    <div class="modal__dialog">
                                        <div class="modal__content">
                                            <button class="close btn btn--xs btn--icon btn--link is-absolute" data-dismiss="lu-modal" aria-label="Close">
                                                <i class="btn__icon zmdi zmdi-close"></i>
                                            </button>
                                            <img src="{$template->getPreview()}" alt=""/>
                                        </div>
                                    </div>
                                </div> 
                            </div>      
                        {/foreach}
                    </div>
                    {* in da future bejbe:

                    <h5>Available Themes</h5>
                    <div class="row">
                    <div class="col-md-4">
                    <div class="widget">
                    <div class="widget__header">
                    <div class="widget__media widget__media--lg">
                    <img src="{$helper->img('/placeholders/placeholder-xs.svg')}" alt="">
                    </div>
                    </div>
                    <div class="widget__actions flex flex-items-xs-between align-items-center">
                    <a class="btn btn--link text-normal m-l-n" href="#">
                    <span class="btn__icon btn__icon--left">
                    <i class="zmdi zmdi-check"></i>
                    </span> Buy Now
                    </a>
                    <span class="price price-md">
                    $199
                    </span>
                    </div>
                    </div>
                    </div>
                    </div>
                    *}  
                </div>
            </div>
            {* <div class="modal fade" id="modalDeleteTheme">
            <div class="modal__dialog">
            <div class="modal__content">
            <div class="modal__top top">
            <h4 class="top__title h6">Delete Theme</h4>
            <div class="top__toolbar">
            <button class="close btn btn--xs btn--icon btn--link" data-dismiss="lu-modal" aria-label="Close">
            <i class="btn__icon zmdi zmdi-close"></i>
            </button>
            </div>
            </div>
            <div class="modal__body">
            <p class="m-b-3x">This action removes theme permanently. If you want save your configuration please export configuration by clicking button below.</p>
            <button class="btn btn--primary">
            <span class="btn__text">Export</span>
            </button>
            </div>
            <div class="modal__actions">
            <button class="btn btn--primary" type="submit">
            <span class="btn__text">Delete</span>
            </button>
            <a class="btn btn--default btn--outline" data-dismiss="lu-modal">
            <span class="btn__text">Cancel</span>
            </a>
            </div>
            </div>
            </div>
            </div> *}
        </div>
        {include file="adminarea/footer.tpl"}
    </div>    
</div>




