{extends file="adminarea/template/includes/header.tpl"} 

{block name="template-heading"}
    {include file="adminarea/template/includes/breadcrumb.tpl"}
{/block}

{block name="template-tabs"}
    {include file="adminarea/template/includes/tabs.tpl"} 
{/block}
{block name="template-content"}
    <div class="row row--eq-height">        
        {foreach from=$template->getStyles() item=style key=k}
            <div class="col-4 col-xs-4">
                <div class="widget">
                    <div class="widget__media">
                        {if {$style->getPreview()}}
                            <img src="{$style->getPreview()}" width="100%"/>
                        {else}
                            <img src="{$helper->img('placeholders/placeholder-xs.svg')}" alt="" width="100%"/>
                        {/if}
                    </div>
                    <div class="widget__actions widget__actions--raised flex flex-items-xs-between">
                        <span class="rail">
                            <span class="type-7">{$style->getName()}</span>
                            {if $style->isActiveFromConfig()}<span class="label label--outline label--success m-l-2x">Active</span>{/if}    
                        </span>
                        <div class="p-0x">
                            <a class="btn btn--sm btn--icon btn--link" target="_blank" href="{$style->getLivePreviewLink()}" data-toggle="lu-tooltip" data-options="classes: lu-tooltip" data-title="Live preview">
                                <i class="btn__icon zmdi zmdi-search-in-file"></i>
                            </a> 
                            {if !$style->isActiveFromConfig()}
                                <a class="btn btn--success btn--sm btn--outline btn--plain" href="{$helper->url('Template@setStyle',['templateName'=>$template->getMainName(), 'styleName' => $style->getMainName()])}" data-toggle="lu-notification" data-status="success" data-timeout="5000" data-title="Success" data-body="Changes has been sucesfully saved!">
                                    <span class="btn__text">Activate</span>
                                </a>
                            {/if}
                        </div>
                    </div>
                </div>    
            </div>

            {* <div id="modalPreview-style-{$k}" class="modal modal--preview">
                <div class="modal__dialog">
                    <div class="modal__content">
                        <button class="close btn btn--xs btn--icon btn--link is-absolute" data-dismiss="lu-modal" aria-label="Close">
                            <i class="btn__icon zmdi zmdi-close"></i>
                        </button>
                         {if {$style->getPreview()}}
                            <img src="{$style->getPreview()}" />
                        {else}
                            <img src="{$helper->img('placeholders/placeholder-xs.svg')}" alt=""/>
                        {/if}
                    </div>
                </div>
            </div>             *}
        {/foreach}

        <div class="col-4">
            <a class="widget widget--dashed widget--half" href="https://rsstudio.net/my-account/submitticket.php?step=2&deptid=2" target="_blank">
                <div class="widget__body">
                    <div class="widget__content d-flex align-items-center">
                        <div class="msg">
                            <div class="msg__icon i-circled i-circled--border border-default m-b-2x">
                                <span class="i-c zmdi zmdi-plus text-default"></span>
                            </div>
                            <div class="msg__body">
                                <div class="msg__title type-7">Request Custom Style</div>
                            </div>
                        </div>
                    </div>
                </div>
            </a>                
        </div>        
    </div>
{/block}


