{extends file="adminarea/template/includes/header.tpl"}

{block name="template-heading"}
    {include file="adminarea/template/includes/breadcrumb.tpl"}
{/block}

{block name="template-tabs"}
    {include file="adminarea/template/includes/tabs.tpl"} 
{/block}

{block name="template-content"}
    <div class="row row--eq-height">
        {foreach from=$template->getLayouts() item=layout key=k}
            <div class="col-4">
                <div class="widget">
                    <div class="widget__media">
                        {if {$layout->getPreview()}}
                            <img src="{$layout->getPreview()}" alt=""/>
                        {else}
                            <img src="{$helper->img('placeholders/placeholder-xs.svg')}" alt=""/>
                        {/if}
                        {* {$layout->getVersion()}
                            {$layout->getDescription()}
                            not used now
                        *}
                    </div>
                    <div class="widget__actions widget__actions--raised flex flex-items-xs-between">
                        <span class="rail">
                            <span class="type-7">{$layout->getName()}</span>
                            {if $layout->isActiveFromConfig()}
                                <span class="label label--outline label--success m-l-2x">Active</span>
                            {/if}
                        </span>                        
                        <div class="p-0x">
                            <a class="btn btn--sm btn--icon btn--link" href="{$layout->getLivePreviewLink()}" target="_blank" data-toggle="lu-tooltip" data-options="classes: lu-tooltip" data-title="Live preview">
                                <i class="btn__icon zmdi zmdi-search-in-file"></i>
                            </a>
                            {if !$layout->isActiveFromConfig()}
                                <a href="{$helper->url('Template@setLayout',['templateName'=>$template->getMainName(), 'layoutName' => $layout->getMainName()])}" class="btn btn--success btn--sm btn--outline btn--plain">
                                    <span class="btn__text">Activate</span>
                                </a>
                            {/if}
                        </div>
                    </div>
                </div>
                
                {* <div id="modalPreview-style-1" class="modal modal--preview">
                    <div class="modal__dialog">
                        <div class="modal__content">
                            <button class="close btn btn--xs btn--icon btn--link is-absolute" data-dismiss="lu-modal" aria-label="Close">
                                <i class="btn__icon zmdi zmdi-close"></i>
                            </button>
                            {if {$layout->getPreview()}}
                                <img src="{$layout->getPreview()}" alt=""/>
                            {else}
                                <img src="{$helper->img('placeholders/placeholder-xs.svg')}" alt=""/>
                            {/if}
                        </div>
                    </div>
                </div>                 *}
            </div>
        {/foreach}
    </div> 
{/block}


