{extends file="adminarea/template/includes/header.tpl"}

{block name="template-heading"}
    {include file="adminarea/template/includes/breadcrumb.tpl"} 
{/block}

{block name="template-tabs"}
    {include file="adminarea/template/includes/tabs.tpl"} 
{/block}

{block name="template-content"}
    <div class="block">
        {if $template->license()->getAddonMessages()}
            {literal}
                <script>
                    function getCookie(cname) {
                        var name = cname + "=";
                        var ca = document.cookie.split(';');
                        for(var i = 0; i < ca.length; i++) {
                            var c = ca[i];
                            while (c.charAt(0) == ' ') {
                            c = c.substring(1);
                            }
                            if (c.indexOf(name) == 0) {
                            return c.substring(name.length, c.length);
                            }
                        }
                        return "";
                    }
                    function checkCookie() {
                        var licenseexp = getCookie("licenseexp");
                        var daystoexp = $('.alert--license').attr('data-daysToExp');
                        if (licenseexp != "" && daystoexp > 2) {
                            
                            $('.alert--license').remove();
                        } else {
                           
                        }
                    }
                 
                    function createCookie(name, value, days) {
                        var date, expires;
                        if (days) {
                            date = new Date();
                            date.setTime(date.getTime()+(days*24*60*60*1000));
                            expires = "; expires="+date.toGMTString();
                        } else {
                            expires = "";
                        }
                        document.cookie = name+"="+value+expires+"; path=/";
                    }

                    $(document).ready(function(){
                        checkCookie();

                        $('.alert--license').on('closed.bs.alert', function () {
                            
                        var name = 'licenseexp';
                        var value = 1;
                        var days = 7;
                            createCookie(name, value, days);
                           
                        });     
                    })           
                </script>
            {/literal}    
            {$template->license()->getAddonMessages()}
        {/if}

        <div class="block__body max-w-md">
            <div class="section">
                <div class="section__title type-5">Theme Information</div>
                <div class="section__body">
                    <ul class="list list--info list--p-1x">
                        <li class="list__item">
                            <span class="list__label">Theme Version:</span>
                            <span class="list__value">
                                <b>{$template->getVersion()}</b>  
                                {if $template->newVersionAvailable()}
                                    <span id="newVersion"><a class="status status--success" href="https://rsstudio.net/my-account/" target="_blank"><i class="zmdi zmdi-info-outline text-info"></i> New version is available! {$template->newVersion()}</a></span>
                                {/if}  
                            </span>
                        </li> 
                        <li class="list__item">
                            <span class="list__label">Registration Date:</span>
                            <span class="list__value">{$template->license()->details('regdate')|date_format:"%A, %B %e, %Y"}</span>
                        </li>
                        <li class="list__item">
                            <span class="list__label">Next Due Date:</span>
                            <span class="list__value">
                                {if $template->license()->details('nextduedate')!='0000-00-00'}
                                    {$template->license()->details('nextduedate')|date_format:"%A, %B %e, %Y"}
                                {else}
                                    Lifetime license
                                {/if}
                            </span>
                        </li>
                        <li class="list__item">
                            <span class="list__label">First Payment Amount:</span>
                            <span class="list__value">
                                {$template->license()->details('first_payment_amount')}
                            </span>
                        </li>
                        <li class="list__item">
                            <span class="list__label">Recurring Amount:</span>
                            <span class="list__value">
                                {$template->license()->details('recuring_amount')}
                            </span>
                        </li>
                        <li class="list__item">
                            <span class="list__label">Payment Method:</span>
                            <span class="list__value">
                                {$template->license()->details('payment_method')}
                            </span>
                        </li>
                        <ul>
                    </div>
                </div>
                <div class="section">
                    <div class="section__title type-5">License Key</div>
                    <div class="section__body">
                        <ul class="list list--info list--p-1x m-b-2x">
                            <li class="list__item">
                                <span class="list__label">License Status:</span>
                                 <span class="list__value">    
                                    <span class="status {if $template->license()->details('license_status') == "Active"}text-success{else}text-danger{/if}">{if $template->license()->details('license_status') == "Active"}<i class="zmdi zmdi-check-circle"></i>{else}<i class="zmdi zmdi-alert-triangle"></i>{/if}{$template->license()->details('license_status')}</span>
                                </span>
                            </li> 
                            <li class="list__item">
                                <span class="list__label">Access to support & updates:</span>
                                <span class="list__value">
                                    <span class="status {if $template->license()->details('service_status') == "Active"}text-success{else}text-danger{/if}">{if $template->license()->details('service_status') == "Active"}<i class="zmdi zmdi-check-circle"></i>{else}<i class="zmdi zmdi-alert-triangle"></i>{/if}{$template->license()->details('service_status')}</span>
                                </span>
                               
                            </li> 
                        </ul>    
                        <form action="{$helper->url('Template@info',['templateName'=>$template->getMainName()])}" method="POST">
                            <div class="form-group">
                                <div class="input-group input-group--lg">
                                    <input name="licenseKey" class="form-control form-control--lg" value="{$template->license()->getLicenseKey()}" placeholder="">
                                    <button type="submit" class="input-group__btn btn btn--lg btn--default">
                                        <span class="btn__text">Save</span>
                                        <span class="btn__preloader preloader"></span>
                                    </button>
                                </div>
                        
                                {if $template->license()->hasInputError()}
                                    <div class="form-feedback form-feedback-lg form-feedback--icon {if $template->license()->details('status')|lower == "suspended"}form-feedback-danger{else}form-feedback-info{/if}">
                                        <span>{$template->license()->getInputError()}</span>
                                    </div>
                                {/if}
                            </div>
                        </form>
                    </div>
                </div>
                </div>
                <div class="block__sidebar block__sidebar--lg">
                    <div class="widget">
                        <a class="widget__media has-overlay" href="#modalPreview-layers-preview" data-toggle="lu-modal">
                            <div class="widget__overlay">
                                <div class="widget__content">
                                    <div class="msg">
                                        <div class="msg__icon i-circled bg-white">
                                            <span class="i-c zmdi zmdi-zoom-in text-default"></span>
                                        </div>
                                        <div class="msg__body">
                                            <div class="msg__title type-7">Click to zoom in</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {if $template->getPreview()}
                                <img src="{$template->getPreview()}">
                            {else}
                                <img src="{$helper->img('placeholders/placeholder-xs.svg')}">
                            {/if}
                        </a>
                    </div>
                    <div id="modalPreview-layers-preview" class="modal modal--preview">
                        <div class="modal__dialog">
                            <div class="modal__content">
                                <button class="close btn btn--xs btn--icon btn--link is-absolute" data-dismiss="lu-modal" aria-label="Close">
                                    <i class="btn__icon zmdi zmdi-close"></i>
                                </button>
                                {if $template->getPreview()}
                                    <img src="{$template->getPreview()}">
                                {else}
                                    <img src="{$helper->img('placeholders/placeholder-xs.svg')}">
                                {/if}
                            </div>
                        </div>
                    </div>	
                </div>
            </div>    
            {literal}
                <style>
                    #rs-module .form-feedback-lg{
                        font-size: 14px;
                        margin-top: 16px;
                    }
                    #rs-module .form-feedback-lg:before{
                        font-size: 22px;
                        width: 22px;
                        min-width: 22px;
                        height: 22px;
                        margin-right: 12px;
                        color: #f55656;
                    } 
                    #rs-module .form-feedback-info:before{
                        content: '\f1f7'!important;
                        color: #50bfff;
                    }
                    #rs-module .form-feedback-warning:before{
                        content: '\f1f4'!important;
                        color: #ff8f33;
                    }
                    #rs-module .form-feedback-danger:before{
                        content: '\f1f0'!important;
                        color: #ea6262;
                    }
                    #rs-module .alert--license{
                        margin-bottom: 32px;
                        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
                    }
                    #rs-module .alert--license b{
                        font-size: 16px;
                        display: block;
                        margin-bottom: 8px;
                    }       
                    #rs-module .alert--license p{
                        color: #505459;
                    }

                    #rs-module .status{
                        vertical-align: middle;
                    }
                    #rs-module .status i{
                        font-size: 18px;
                        margin-right: 4px;
                    }
                    #newVersion{
                        margin-left: 8px;
                    }
                </style>
            {/literal}

        {/block}



















