<h3 class="type-6">{$title}<i class="zmdi zmdi-help m-l-1x text-faded" data-toggle="tooltip" data-title="{$tooltip}"></i></h3>
<div class="form-group form-group--bordered">
    <div class="d-flex">
        <span class="form-label text-default form-text flex-grow-1">
            {$label}
        </span>
        <label>
            <div class="switch switch--primary">
                <input type="hidden" name="group_inputs[{$name}][visibility]" value="0"/>
                <input class="switch__checkbox group-input-visibility" name="group_inputs[{$name}][visibility]" value="1" type="checkbox"
                        {if isset($value) && $value !== 'displayed'} checked="checked" {/if} data-name="{$name}">
                <span class="switch__container"><span class="switch__handle"></span></span>
            </div>
        </label>
    </div>
    <div class="group_inputs_{$name}" style="display: {if isset($value) && $value !== 'displayed'} block {else} none {/if};">
        <div class="d-flex flex-row m-t-2x">
            <div class="form-check form-check--inline">
                <label>
                    <input class="group-radio form-radio" type="radio" name="group_inputs[{$name}][group_selection]" value="all"
                        data-name="{$name}" {if is_null($value) || $value === 'displayed' || $value === $allGroups} checked {/if}>
                        <span class="form-indicator"></span>
                        <span class="form-text">All</span>
                </label>
            </div>
           <div class="form-check form-check--inline">
                <label>
                    <input class="group-radio form-radio" type="radio" name="group_inputs[{$name}][group_selection]" value="groups"
                       data-name="{$name}" {if isset($value) && $value !== 'displayed' && $value !== $allGroups && !empty($value)} checked {/if}>
                    <span class="form-indicator"></span>
                    <span class="form-text">Choose Product Groups</span>
                </label>
            </div>
        </div>
        <div class="form-group m-t-2x group_select_{$name}" style="display: {if isset($value) && $value !== $allGroups && !empty($value)} block {else} none {/if};">
            <label class="form-text" for="group_select_{$name}">Product Groups</label>
            <select id="group_select_{$name}" class="form-control multiselect form-control--basic group-multi-select" name="group_inputs[{$name}][groups][]" multiple required>
                {foreach $productGroups as $productGroup}
                    <option value="{$productGroup->id}" {if isset($value) && $value !== 'displayed' && in_array($productGroup->id, explode(',', $value))} selected {/if}>{$productGroup->name}</option>
                {/foreach}
            </select>
        </div>
        {if $customHostname}
            <div class="form-group d-flex m-t-2x">
                <span class="form-label text-default form-text flex-grow-1">Use custom hostname</span>
                <label>
                    <div class="switch switch--primary">
                        <input type="hidden" name="settings[enable_custom_hostname]" value="0">
                        <input class="switch__checkbox custom-hostname" name="settings[enable_custom_hostname]" value="1" type="checkbox" {if $settings['enable_custom_hostname']} checked="checked" {/if}>
                        <span class="switch__container"><span class="switch__handle"></span></span>
                    </div>
                </label>
            </div>
            <div class="custom-hostname-group" style="display: {if $settings['enable_custom_hostname']} block {else} none {/if}">
                <div class="form-group">
                    <label class="form-text">Prefix</label>
                    <input class="form-control" name="hostname_settings[custom_hostname_prefix]" type="text"
                           value="{$settings['custom_hostname_prefix']}" data-hostname-input required>
                </div>
                <div class="form-group">
                    <label class="form-text">Interfix random chars length</label>
                    <input class="form-control" name="hostname_settings[custom_hostname_interfix_length]" type="number" min="8" max="50"
                           value="{$settings['custom_hostname_interfix_length']}" data-hostname-input required>
                </div>
                <div class="form-group">
                    <label class="form-text">Suffix</label>
                    <input class="form-control" name="hostname_settings[custom_hostname_suffix]" type="text" pattern="^\.[a-zA-z.]+"
                           value="{$settings['custom_hostname_suffix']}" data-hostname-input required>
                </div>
            </div>
        {/if}
    </div>
</div>
