<h3 class="type-6">{$title}<i class="zmdi zmdi-help m-l-1x text-faded" data-toggle="tooltip" data-title="{$tooltip}"></i></h3>
<div class="form-group form-group--bordered">
    <div class="d-flex">
        <span class="form-label text-default form-text flex-grow-1">
            {$label}
        </span>
        <label>
            <div class="switch switch--primary">
                <input type="hidden" name="settings[show_cookie_box]" value="hidden"/>
                <input class="switch__checkbox group-input-visibility" name="settings[show_cookie_box]" value="displayed" type="checkbox"
                        {if isset($value) && $value == 'displayed'} checked="checked" {/if} data-name="{$name}">
                <span class="switch__container"><span class="switch__handle"></span></span>
            </div>
        </label>
    </div>
    <div class="group_inputs_{$name}" style="display: {if isset($value) && $value !== 'displayed'} none  {else} block {/if};">
        <div class="form-group m-t-2x m-b-0x">
            <label class="form-label text-default">Cookie box position
                <i class="zmdi zmdi-help m-l-1x text-faded" data-toggle="tooltip" data-title="Cookie Box"></i>
            </label>
            <select class="form-control selectized m-b-2x" name="settings[cookie_box_position]" tabindex="-1">
                <option value="bottom-left" {if $settings['cookie_box_position'] == 'bottom-left'} selected="selected" {/if}>bottom-left</option>
                <option value="bottom" {if $settings['cookie_box_position'] == 'bottom'} selected="selected" {/if}>bottom</option>
                <option value="bottom-right" {if $settings['cookie_box_position'] == 'bottom-right'} selected="selected" {/if}>bottom-right</option>
            </select>
            <div class="d-flex justify-content-between">
                <label class="form-label text-default">Cookie box message
                    <i class="zmdi zmdi-help m-l-1x text-faded" data-toggle="tooltip" data-title="Cookie Box"></i>
                </label>
                <a class="label-link m-l-a" href="#cookieBoxTranslationsModal" data-toggle="lu-modal">Translate</a>
            </div>
            <textarea id="cookie_box_message_textarea" class="form-control" type="text" data-form-counter-input="">{$cookiebox_settings[$systemLanguage]}</textarea>
            <input id="cookie_box_message_json" type="hidden" name="settings[cookie_box_message]" value='{json_encode($cookiebox_settings)}'>
        </div>
    </div>
</div>
<div class="modal" id="cookieBoxTranslationsModal" data-translation-modal>
    <div class="modal__dialog">
        <div class="modal__content">
            <div class="modal__top top">
                <h6 class="top__title text-default">Menu item translation</h6>
                <div class="top__toolbar">
                    <button class="close btn btn--xs btn--icon btn--link" data-dismiss="lu-modal" aria-label="Close">
                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M10.41 8.99997L17.85 1.55997C17.8968 1.51349 17.934 1.45819 17.9594 1.39726C17.9848 1.33633 17.9979 1.27098 17.9979 1.20497C17.9979 1.13897 17.9848 1.07362 17.9594 1.01269C17.934 0.951756 17.8968 0.896456 17.85 0.849974L17.15 0.149974C17.1035 0.10311 17.0482 0.065913 16.9873 0.0405287C16.9263 0.0151443 16.861 0.0020752 16.795 0.0020752C16.729 0.0020752 16.6636 0.0151443 16.6027 0.0405287C16.5418 0.065913 16.4865 0.10311 16.44 0.149974L8.99997 7.58997L1.55997 0.149974C1.51349 0.10311 1.45819 0.065913 1.39726 0.0405287C1.33633 0.0151443 1.27098 0.0020752 1.20497 0.0020752C1.13897 0.0020752 1.07362 0.0151443 1.01269 0.0405287C0.951756 0.065913 0.896456 0.10311 0.849974 0.149974L0.149974 0.849974C0.10311 0.896456 0.065913 0.951756 0.0405287 1.01269C0.0151443 1.07362 0.0020752 1.13897 0.0020752 1.20497C0.0020752 1.27098 0.0151443 1.33633 0.0405287 1.39726C0.065913 1.45819 0.10311 1.51349 0.149974 1.55997L7.58997 8.99997L0.149974 16.44C0.10311 16.4865 0.065913 16.5418 0.0405287 16.6027C0.0151443 16.6636 0.0020752 16.729 0.0020752 16.795C0.0020752 16.861 0.0151443 16.9263 0.0405287 16.9873C0.065913 17.0482 0.10311 17.1035 0.149974 17.15L0.849974 17.85C0.945363 17.9457 1.07484 17.9996 1.20997 18C1.34186 17.9981 1.46766 17.9442 1.55997 17.85L8.99997 10.41L16.44 17.85C16.5323 17.9442 16.6581 17.9981 16.79 18C16.9251 17.9996 17.0546 17.9457 17.15 17.85L17.85 17.15C17.8968 17.1035 17.934 17.0482 17.9594 16.9873C17.9848 16.9263 17.9979 16.861 17.9979 16.795C17.9979 16.729 17.9848 16.6636 17.9594 16.6027C17.934 16.5418 17.8968 16.4865 17.85 16.44L10.41 8.99997Z" fill="#B9BDC5"/>
                        </svg>
                    </button>
                </div>
            </div>
            <div class="modal__body p-b-0x">
                <div class="row" id="cookieBoxTranslationForm">
                    {foreach $whmcsLanguages as $whmcsLanguage}
                        <div class="col-xs-12">
                            <div class="form-group">
                                <label class="form-label">{ucfirst($whmcsLanguage)}</label>
                                <textarea class="form-control lang-{$whmcsLanguage}-input" name={$whmcsLanguage}>{if isset($cookiebox_settings[$whmcsLanguage])}{$cookiebox_settings[$whmcsLanguage]}{/if}</textarea>
                            </div>
                        </div>
                    {/foreach}
                </div>
            </div>
            <div class="modal__actions">
                <button class="btn btn--primary" type="button" id="cookieBoxTranslationFormButton">
                    <span class="btn__text">Save Changes</span>
                </button>
                <a class="btn btn--default btn--outline" data-dismiss="lu-modal">
                    <span class="btn__text">Cancel</span>
                </a>
            </div>
        </div>
    </div>
</div>
{literal}
<script>
    {/literal}
    var translations = {if is_array($cookiebox_settings)}{json_encode($cookiebox_settings)}{else}new Array(){/if};
    {literal}
    $('#cookieBoxTranslationFormButton').on('click', function(e){
        $('#cookieBoxTranslationForm textarea').each(
            function(index){
                var input = $(this);
                translations[input.attr('name')] = input.val();
                if(input.attr('name') == '{/literal}{$systemLanguage}{literal}')
                {
                    $("#cookie_box_message_textarea").val(input.val());
                }
            }
        );
        var fixed = Object.assign({},translations);
        $('#cookie_box_message_json').val(JSON.stringify(fixed));
        $('#cookieBoxTranslationsModal').modal('hide');
        e.preventDefault();
        return false;
    });
    $( "#cookie_box_message_textarea" ).on("input",function() {
        $("#cookieBoxTranslationForm textarea[name='{/literal}{$systemLanguage}{literal}']").val($(this).val());
        translations['{/literal}{$systemLanguage}{literal}'] = $(this).val();
        var fixed = Object.assign({},translations);
        $('#cookie_box_message_json').val(JSON.stringify(fixed));
    });
</script>
{/literal}