{extends file="adminarea/template/includes/header.tpl"}
{block name="template-heading"}
    {include file="adminarea/template/includes/breadcrumb.tpl"}
{/block}
{block name="template-tabs"}
    {include file="adminarea/template/includes/tabs.tpl"}
{/block}
{block name="template-content"}
    <form id="#themesConfig" action="{$helper->url('Template@branding',['templateName'=>$template->getMainName()])}" method="POST" enctype="multipart/form-data">
        <div class="section">
            <div class="section__title type-5">Full Logo</div>
            <div class="section__body">
                <div class="row row--eq-height">
                    <div class="col-4 logo-box logo-box--full-light">
                        {if $images.logo_big}
                            <input style="display:none" type="file" name="logo_big">
                            <div class="widget has-overlay">
                                <div class="widget__media">
                                    <a class="widget__overlay" href="#" data-trigger='logo_big'>
                                        <div class="widget__content">
                                            <div class="msg">
                                                <div class="msg__icon i-circled bg-white">
                                                    <span class="i-c zmdi zmdi-upload text-default"></span>
                                                </div>
                                                <div class="msg__body">
                                                    <div class="msg__title type-7">Click to upload file</div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="widget__content text-center">
                                        <div class="brand-logo-preview p-5x">
                                            <img style="max-height: 40px;" name="logo_bigImage" src="{$images.logo_big}" alt="" height="100%"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="widget__actions">
                                    <div class="widget__content">
                                        <p class="p-4 m-b-0x text-center flex-1">Full logo displayed on light and white background</p>
                                    </div>
                                </div>
                            </div>
                        {else}
                            <input style="display:none" type="file" name="logo_big">
                            <a class="widget widget--link" href="#" data-trigger='logo_big'>
                                <div class="widget__body">
                                    <div class="msg">
                                        <div class="msg__icon i-circled i-circled--border border-default">
                                            <span class="i-c zmdi zmdi-upload text-default"></span>
                                        </div>
                                        <div class="msg__body">
                                            <div class="msg__title type-7">Click to upload file</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="widget__actions">
                                    <div class="widget__content">
                                        <p class="p-4 m-b-0x text-center flex-1">Full logo displayed on light background</p>
                                    </div>
                                </div>
                            </a>
                        {/if}
                    </div>
                    <div class="col-4 logo-box logo-box--full-dark">
                        {if $images.logo_big_inverse}
                            <input style="display:none" type="file" name="logo_big_inverse">
                            <div class="widget has-overlay">
                                <div class="widget__media">
                                    <a class="widget__overlay" href="#" data-trigger='logo_big_inverse' >
                                        <div class="widget__content">
                                            <div class="msg">
                                                <div class="msg__icon i-circled bg-white">
                                                    <span class="i-c zmdi zmdi-upload text-default"></span>
                                                </div>
                                                <div class="msg__body">
                                                    <div class="msg__title type-7">Click to upload file</div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="widget__content text-center bg-dark">
                                        <div class="brand-logo-preview p-5x">
                                            <img style="max-height: 40px;" name="logo_big_inverseImage"  src="{$images.logo_big_inverse}" alt="" height="100%"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="widget__actions">
                                    <div class="widget__content">
                                        <p class="p-4 m-b-0x text-center flex-1">Full logo displayed on dark background</p>
                                    </div>
                                </div>
                            </div>
                        {else}
                            <input style="display:none" type="file" name="logo_big_inverse">
                            <a class="widget widget--link" href="#" data-trigger='logo_big_inverse' >
                                <div class="widget__body">
                                    <div class="msg">
                                        <div class="msg__icon i-circled i-circled--border border-default">
                                            <span class="i-c zmdi zmdi-upload text-default"></span>
                                        </div>
                                        <div class="msg__body">
                                            <div class="msg__title type-7">Click to upload file</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="widget__actions">
                                    <div class="widget__content">
                                        <p class="p-4 m-b-0x text-center flex-1">Full logo displayed on dark background</p>
                                    </div>
                                </div>
                            </a>
                        {/if}
                    </div>
                </div>
            </div>
        </div>
        <div class="section">
            <div class="section__title type-5">Square Logo</div>
            <div class="section__body">
                <div class="row row--eq-height">
                    <div class="col-4 logo-box logo-box--square-light">
                        {if $images.logo_small}
                            <input style="display:none" type="file" name="logo_small">
                            <div class="widget has-overlay">
                                <div class="widget__media">
                                    <a class="widget__overlay" href="#" data-trigger='logo_small' >
                                        <div class="widget__content">
                                            <div class="msg">
                                                <div class="msg__icon i-circled bg-white">
                                                    <span class="i-c zmdi zmdi-upload text-default"></span>
                                                </div>
                                                <div class="msg__body">
                                                    <div class="msg__title type-7">Click to upload file</div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="widget__content text-center">
                                        <div class="brand-logo-preview p-5x">
                                            <img name="logo_smallImage" src="{$images.logo_small}" alt="" style="max-height:40px;"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="widget__actions">
                                    <div class="widget__content">
                                        <p class="p-4 m-b-0x text-center flex-1">Square logo displayed on light background</p>
                                    </div>
                                </div>
                            </div>
                        {else}
                            <input style="display:none" type="file" name="logo_small">
                            <a class="widget widget--link" href="#" data-trigger='logo_small' >
                                <div class="widget__body">
                                    <div class="msg">
                                        <div class="msg__icon i-circled i-circled--border border-default">
                                            <span class="i-c zmdi zmdi-upload text-default"></span>
                                        </div>
                                        <div class="msg__body">
                                            <div class="msg__title type-7">Click to upload file</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="widget__actions">
                                    <div class="widget__content">
                                        <p class="p-4 m-b-0x text-center flex-1">Square logo displayed on light background</p>
                                    </div>
                                </div>
                            </a>
                        {/if}
                    </div>
                    <div class="col-4 logo-box logo-box--square-dark">
                        {if $images.logo_small_inverse}
                            <input style="display:none" type="file" name="logo_small_inverse">
                            <div class="widget has-overlay">
                                <div class="widget__media">
                                    <a class="widget__overlay" href="#" data-trigger='logo_small_inverse' >
                                        <div class="widget__content">
                                            <div class="msg">
                                                <div class="msg__icon i-circled bg-white">
                                                    <span class="i-c zmdi zmdi-upload text-default"></span>
                                                </div>
                                                <div class="msg__body">
                                                    <div class="msg__title type-7">Click to upload file</div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="widget__content text-center bg-dark">
                                        <div class="brand-logo-preview p-5x">
                                            <img name="logo_small_inverseImage"  src="{$images.logo_small_inverse}" alt="" style="max-height: 40px;"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="widget__actions">
                                    <div class="widget__content">
                                        <p class="p-4 m-b-0x text-center flex-1">Square logo displayed on dark background</p>
                                    </div>
                                </div>
                            </div>
                        {else}
                            <input style="display:none" type="file" name="logo_small_inverse">
                            <a class="widget widget--link" href="#" data-trigger='logo_small_inverse' >
                                <div class="widget__body">
                                    <div class="msg">
                                        <div class="msg__icon i-circled i-circled--border border-default">
                                            <span class="i-c zmdi zmdi-upload text-default"></span>
                                        </div>
                                        <div class="msg__body">
                                            <div class="msg__title type-7">Click to upload file</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="widget__actions">
                                    <div class="widget__content">
                                        <p class="p-4 m-b-0x text-center flex-1">Square logo displayed on dark background</p>
                                    </div>
                                </div>
                            </a>
                        {/if}
                    </div>
                </div>
            </div>
        </div>

        <div class="section">
            <div class="section__title type-5">Favicon</div>
            <div class="section__body">
                <div class="row row--eq-height">
                    <div class="col-4 logo-box logo-box--favicon">
                        {if $images.icon}
                            <input style="display:none" type="file" name="icon">
                            <div class="widget has-overlay">
                                <div class="widget__media">
                                    <a class="widget__overlay" href="#" data-trigger='icon'>
                                        <div class="widget__content">
                                            <div class="msg">
                                                <div class="msg__icon i-circled bg-white">
                                                    <span class="i-c zmdi zmdi-upload text-default"></span>
                                                </div>
                                                <div class="msg__body">
                                                    <div class="msg__title type-7">Click to upload file</div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="widget__content text-center">
                                        <div class="brand-logo-preview p-5x">
                                            <img style="max-width:40px; height:40px" name="iconImage" src="{$images.icon}" alt="" height="100%"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="widget__actions">
                                    <div class="widget__content">
                                        <p class="p-4 m-b-0x text-center flex-1">Favicon shown in browser tab</p>
                                    </div>
                                </div>
                            </div>
                        {else}
                            <input style="display:none" type="file" name="icon">
                            <a class="widget widget--link" href="#" data-trigger='icon' >
                                <div class="widget__body">
                                    <div class="msg">
                                        <div class="msg__icon i-circled i-circled--border border-default">
                                            <span class="i-c zmdi zmdi-upload text-default"></span>
                                        </div>
                                        <div class="msg__body">
                                            <div class="msg__title type-7">Click to upload file</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="widget__actions">
                                    <div class="widget__content">
                                        <p class="p-4 m-b-0x text-center flex-1">Favicon shown in browser tab</p>
                                    </div>
                                </div>
                            </a>
                        {/if}
                    </div>
                </div>
            </div>
        </div>
    </form>
    <script type="text/javascript">
        $(document).ready(function () {
            $('a[data-trigger="logo_big"]').on('click', function (e) {
                e.preventDefault();
                $('input[name="logo_big"]').trigger('click');
            });
            $('input[name="logo_big"]').on('change', function () {
                if (this.files && this.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        var insertHtml = $('#image_template').html();
                        $('input[name="logo_big"]').siblings('.widget').remove();
                        $(insertHtml).insertAfter($('input[name="logo_big"]'));
                        $('body').find($('[data-trigger="newLogo"]')).attr('data-trigger', 'logo_big');
                        $('body').find($('[name="newLogoImage"]')).attr('name', 'logo_bigImage');
                        $('img[name="logo_bigImage"]').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(this.files[0]);
                }
            });
            $('a[data-trigger="logo_big_inverse"]').on('click', function (e) {
                e.preventDefault();
                $('input[name="logo_big_inverse"]').trigger('click');
            });
            $('input[name="logo_big_inverse"]').on('change', function () {
                if (this.files && this.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        var insertHtml = $('#image_template').html();
                        $('input[name="logo_big_inverse"]').siblings('.widget').remove();
                        $(insertHtml).insertAfter($('input[name="logo_big_inverse"]'));
                        $('body').find($('[data-trigger="newLogo"]')).attr('data-trigger', 'logo_big_inverse');
                        $('body').find($('[name="newLogoImage"]')).attr('name', 'logo_big_inverseImage');
                        $('img[name="logo_big_inverseImage"]').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(this.files[0]);
                }
            });
            $('a[data-trigger="logo_small"]').on('click', function (e) {
                e.preventDefault();
                $('input[name="logo_small"]').trigger('click');
            });
            $('input[name="logo_small"]').on('change', function () {
                if (this.files && this.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        var insertHtml = $('#image_template').html();
                        $('input[name="logo_small"]').siblings('.widget').remove();
                        $(insertHtml).insertAfter($('input[name="logo_small"]'));
                        $('body').find($('[data-trigger="newLogo"]')).attr('data-trigger', 'logo_small');
                        $('body').find($('[name="newLogoImage"]')).attr('name', 'logo_smallImage');
                        $('img[name="logo_smallImage"]').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(this.files[0]);
                }
            });
            $('a[data-trigger="logo_small_inverse"]').on('click', function (e) {
                e.preventDefault();
                $('input[name="logo_small_inverse"]').trigger('click');
            });
            $('input[name="logo_small_inverse"]').on('change', function () {
                if (this.files && this.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        var insertHtml = $('#image_template').html();
                        $('input[name="logo_small_inverse"]').siblings('.widget').remove();
                        $(insertHtml).insertAfter($('input[name="logo_small_inverse"]'));
                        $('body').find($('[data-trigger="newLogo"]')).attr('data-trigger', 'logo_small_inverse');
                        $('body').find($('[name="newLogoImage"]')).attr('name', 'logo_small_inverseImage');
                        $('img[name="logo_small_inverseImage"]').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(this.files[0]);
                }
            });
            $('a[data-trigger="icon"]').on('click', function (e) {
                e.preventDefault();
                $('input[name="icon"]').trigger('click');
            });
            $('input[name="icon"]').on('change', function () {
                if (this.files && this.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        var insertHtml = $('#image_template').html();
                        $('input[name="icon"]').siblings('.widget').remove();
                        $(insertHtml).insertAfter($('input[name="icon"]'));
                        $('body').find($('[data-trigger="newLogo"]')).attr('data-trigger', 'icon');
                        $('body').find($('[name="newLogoImage"]')).attr('name', 'iconImage');
                        $('img[name="iconImage"]').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(this.files[0]);
                }
            });
        });
    </script>
    <script id="image_template" type="text/template">
        <div class="widget has-overlay">
            <div class="widget__media">
                <a class="widget__overlay" href="#" data-trigger='newLogo'>
                    <div class="widget__content">
                        <div class="msg">
                            <div class="msg__icon i-circled bg-white">
                                <span class="i-c zmdi zmdi-upload text-default"></span>
                            </div>
                            <div class="msg__body">
                                <div class="msg__title type-7">Click to upload file</div>
                            </div>
                        </div>
                    </div>

                </a>
                <div class="widget__content text-center">
                    <div class="brand-logo-preview p-5x">
                        <img name="newLogoImage" src="" alt="" style="max-height:40px"/>
                    </div>
                    <p class="p-4 text-faded">
                        <span class="preview-full-light">Full logo displayed on light and white background</span>
                        <span class="preview-full-dark">Full logo displayed on dark background</span>
                        <span class="preview-square-light">Square logo displayed on light background</span>
                        <span class="preview-square-dark">Square logo displayed on dark background</span>
                        <span class="preview-favicon">Favicon shown in browser tab</span>
                    </p>
                </div>
            </div>
        </div>
    </script>
    <style>
        .widget__body{
            min-height: 160px;
        }
        #rs-module .app-main__body {
            padding-bottom: 120px;
        }
        #rs-module .app-main__actions {
            bottom: 0;
            left: 0;
            right: 0;
        }

        #rs-module .preview-full-light, #rs-module .preview-full-dark, #rs-module .preview-square-light, #rs-module .preview-square-dark, #rs-module .preview-favicon {
	        display: none;
        }
        #rs-module .logo-box--full-light .preview-full-light {
            display: inline;
        }
        #rs-module .logo-box--full-dark .preview-full-dark {
            display: inline;
        }
        #rs-module .logo-box--square-light .preview-square-light {
            display: inline;
        }
        #rs-module .logo-box--square-dark .preview-square-dark {
            display: inline;
        }
        #rs-module .logo-box--favicon .preview-favicon {
            display: inline;
        }
 
    </style>
{/block}
{block name="template-actions"}
    <div class="app-main__actions is-absolute">
        <div class="container">
            <a class="btn btn--success" href="#" data-form="submit">
                <span class="btn__text">Save Settings</span>
                <span class="btn__preloader preloader"></span>
            </a>
            <a class="btn btn--default btn--outline " href="{$helper->url('Template@branding',['templateName'=>$template->getMainName()])}">
                <span class="btn__text">Cancel</span>
                <span class="btn__preloader preloader"></span>
            </a>
        </div>
    </div>
{/block}