{extends file="adminarea/template/includes/header.tpl"} 

{block name="template-heading"}
    {include file="adminarea/extensions/emailstyle/includes/breadcrumb.tpl"}
{/block}

{block name="template-tabs"}
    {include file="adminarea/extensions/emailstyle/includes/tabs.tpl"} 
{/block}

{block name="template-content"}
    <div class="row row--eq-height">
        {foreach $extension->getStyles() as $key => $emailTemplate}
            <div class="col-md-4">
                <div class="widget">
                    <div class="widget__media">
                        <img src="{$whmcsURL}/templates/{$themeName}/core/extensions/{$extension->className}/styles/{$key}/thumb.png"" alt="">
                    </div>
                    <div class="widget__actions widget__actions--raised flex flex-items-xs-between">
                        <span class="rail">
                            <span class="type-7">{ucfirst($key)}</span>
                            {if $extension->getActivatedStyle() == $key}
                                <span class="label label--outline label--success m-l-2x">Active</span>
                            {/if}
                        </span>
                        <div class="p-0x" style="min-height: 36px;">
                            <form method="POST" action="{$helper->url('Template@extension',['templateName'=>$template->getMainName(),'extension'=>$extension->getLinkName(),'exaction'=>'styles'])}">
                                <input type="hidden" name="exaction" value="activatestyle">
                                <input type="hidden" name="style" value="{$key}">
                                {if $extension->getActivatedStyle() != $key}
                                    <button class="btn btn--success btn--sm btn--outline btn--plain">
                                        <span class="btn__text">Activate</span>
                                    </button>
                                {/if}
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        {/foreach}
    </div>
{/block}

































