/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 59);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

module.exports = jQuery;

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/**
 * Swiper 3.4.2
 * Most modern mobile touch slider and framework with hardware accelerated transitions
 * 
 * http://www.idangero.us/swiper/
 * 
 * Copyright 2017, Vladimir Kharlampidi
 * The iDangero.us
 * http://www.idangero.us/
 * 
 * Licensed under MIT
 * 
 * Released on: March 10, 2017
 */
(function () {
    'use strict';

    var $;

    /*===========================
    Swiper
    ===========================*/
    var Swiper = function Swiper(container, params) {
        if (!(this instanceof Swiper)) return new Swiper(container, params);

        var defaults = {
            direction: 'horizontal',
            touchEventsTarget: 'container',
            initialSlide: 0,
            speed: 300,
            // autoplay
            autoplay: false,
            autoplayDisableOnInteraction: true,
            autoplayStopOnLast: false,
            // To support iOS's swipe-to-go-back gesture (when being used in-app, with UIWebView).
            iOSEdgeSwipeDetection: false,
            iOSEdgeSwipeThreshold: 20,
            // Free mode
            freeMode: false,
            freeModeMomentum: true,
            freeModeMomentumRatio: 1,
            freeModeMomentumBounce: true,
            freeModeMomentumBounceRatio: 1,
            freeModeMomentumVelocityRatio: 1,
            freeModeSticky: false,
            freeModeMinimumVelocity: 0.02,
            // Autoheight
            autoHeight: false,
            // Set wrapper width
            setWrapperSize: false,
            // Virtual Translate
            virtualTranslate: false,
            // Effects
            effect: 'slide', // 'slide' or 'fade' or 'cube' or 'coverflow' or 'flip'
            coverflow: {
                rotate: 50,
                stretch: 0,
                depth: 100,
                modifier: 1,
                slideShadows: true
            },
            flip: {
                slideShadows: true,
                limitRotation: true
            },
            cube: {
                slideShadows: true,
                shadow: true,
                shadowOffset: 20,
                shadowScale: 0.94
            },
            fade: {
                crossFade: false
            },
            // Parallax
            parallax: false,
            // Zoom
            zoom: false,
            zoomMax: 3,
            zoomMin: 1,
            zoomToggle: true,
            // Scrollbar
            scrollbar: null,
            scrollbarHide: true,
            scrollbarDraggable: false,
            scrollbarSnapOnRelease: false,
            // Keyboard Mousewheel
            keyboardControl: false,
            mousewheelControl: false,
            mousewheelReleaseOnEdges: false,
            mousewheelInvert: false,
            mousewheelForceToAxis: false,
            mousewheelSensitivity: 1,
            mousewheelEventsTarged: 'container',
            // Hash Navigation
            hashnav: false,
            hashnavWatchState: false,
            // History
            history: false,
            // Commong Nav State
            replaceState: false,
            // Breakpoints
            breakpoints: undefined,
            // Slides grid
            spaceBetween: 0,
            slidesPerView: 1,
            slidesPerColumn: 1,
            slidesPerColumnFill: 'column',
            slidesPerGroup: 1,
            centeredSlides: false,
            slidesOffsetBefore: 0, // in px
            slidesOffsetAfter: 0, // in px
            // Round length
            roundLengths: false,
            // Touches
            touchRatio: 1,
            touchAngle: 45,
            simulateTouch: true,
            shortSwipes: true,
            longSwipes: true,
            longSwipesRatio: 0.5,
            longSwipesMs: 300,
            followFinger: true,
            onlyExternal: false,
            threshold: 0,
            touchMoveStopPropagation: true,
            touchReleaseOnEdges: false,
            // Unique Navigation Elements
            uniqueNavElements: true,
            // Pagination
            pagination: null,
            paginationElement: 'span',
            paginationClickable: false,
            paginationHide: false,
            paginationBulletRender: null,
            paginationProgressRender: null,
            paginationFractionRender: null,
            paginationCustomRender: null,
            paginationType: 'bullets', // 'bullets' or 'progress' or 'fraction' or 'custom'
            // Resistance
            resistance: true,
            resistanceRatio: 0.85,
            // Next/prev buttons
            nextButton: null,
            prevButton: null,
            // Progress
            watchSlidesProgress: false,
            watchSlidesVisibility: false,
            // Cursor
            grabCursor: false,
            // Clicks
            preventClicks: true,
            preventClicksPropagation: true,
            slideToClickedSlide: false,
            // Lazy Loading
            lazyLoading: false,
            lazyLoadingInPrevNext: false,
            lazyLoadingInPrevNextAmount: 1,
            lazyLoadingOnTransitionStart: false,
            // Images
            preloadImages: true,
            updateOnImagesReady: true,
            // loop
            loop: false,
            loopAdditionalSlides: 0,
            loopedSlides: null,
            // Control
            control: undefined,
            controlInverse: false,
            controlBy: 'slide', //or 'container'
            normalizeSlideIndex: true,
            // Swiping/no swiping
            allowSwipeToPrev: true,
            allowSwipeToNext: true,
            swipeHandler: null, //'.swipe-handler',
            noSwiping: true,
            noSwipingClass: 'swiper-no-swiping',
            // Passive Listeners
            passiveListeners: true,
            // NS
            containerModifierClass: 'swiper-container-', // NEW
            slideClass: 'swiper-slide',
            slideActiveClass: 'swiper-slide-active',
            slideDuplicateActiveClass: 'swiper-slide-duplicate-active',
            slideVisibleClass: 'swiper-slide-visible',
            slideDuplicateClass: 'swiper-slide-duplicate',
            slideNextClass: 'swiper-slide-next',
            slideDuplicateNextClass: 'swiper-slide-duplicate-next',
            slidePrevClass: 'swiper-slide-prev',
            slideDuplicatePrevClass: 'swiper-slide-duplicate-prev',
            wrapperClass: 'swiper-wrapper',
            bulletClass: 'swiper-pagination-bullet',
            bulletActiveClass: 'swiper-pagination-bullet-active',
            buttonDisabledClass: 'swiper-button-disabled',
            paginationCurrentClass: 'swiper-pagination-current',
            paginationTotalClass: 'swiper-pagination-total',
            paginationHiddenClass: 'swiper-pagination-hidden',
            paginationProgressbarClass: 'swiper-pagination-progressbar',
            paginationClickableClass: 'swiper-pagination-clickable', // NEW
            paginationModifierClass: 'swiper-pagination-', // NEW
            lazyLoadingClass: 'swiper-lazy',
            lazyStatusLoadingClass: 'swiper-lazy-loading',
            lazyStatusLoadedClass: 'swiper-lazy-loaded',
            lazyPreloaderClass: 'swiper-lazy-preloader',
            notificationClass: 'swiper-notification',
            preloaderClass: 'preloader',
            zoomContainerClass: 'swiper-zoom-container',

            // Observer
            observer: false,
            observeParents: false,
            // Accessibility
            a11y: false,
            prevSlideMessage: 'Previous slide',
            nextSlideMessage: 'Next slide',
            firstSlideMessage: 'This is the first slide',
            lastSlideMessage: 'This is the last slide',
            paginationBulletMessage: 'Go to slide {{index}}',
            // Callbacks
            runCallbacksOnInit: true
            /*
            Callbacks:
            onInit: function (swiper)
            onDestroy: function (swiper)
            onBeforeResize: function (swiper)
            onAfterResize: function (swiper)
            onClick: function (swiper, e)
            onTap: function (swiper, e)
            onDoubleTap: function (swiper, e)
            onSliderMove: function (swiper, e)
            onSlideChangeStart: function (swiper)
            onSlideChangeEnd: function (swiper)
            onTransitionStart: function (swiper)
            onTransitionEnd: function (swiper)
            onImagesReady: function (swiper)
            onProgress: function (swiper, progress)
            onTouchStart: function (swiper, e)
            onTouchMove: function (swiper, e)
            onTouchMoveOpposite: function (swiper, e)
            onTouchEnd: function (swiper, e)
            onReachBeginning: function (swiper)
            onReachEnd: function (swiper)
            onSetTransition: function (swiper, duration)
            onSetTranslate: function (swiper, translate)
            onAutoplayStart: function (swiper)
            onAutoplayStop: function (swiper),
            onLazyImageLoad: function (swiper, slide, image)
            onLazyImageReady: function (swiper, slide, image)
            onKeyPress: function (swiper, keyCode)
            */

        };
        var initialVirtualTranslate = params && params.virtualTranslate;

        params = params || {};
        var originalParams = {};
        for (var param in params) {
            if (_typeof(params[param]) === 'object' && params[param] !== null && !(params[param].nodeType || params[param] === window || params[param] === document || typeof Dom7 !== 'undefined' && params[param] instanceof Dom7 || typeof jQuery !== 'undefined' && params[param] instanceof jQuery)) {
                originalParams[param] = {};
                for (var deepParam in params[param]) {
                    originalParams[param][deepParam] = params[param][deepParam];
                }
            } else {
                originalParams[param] = params[param];
            }
        }
        for (var def in defaults) {
            if (typeof params[def] === 'undefined') {
                params[def] = defaults[def];
            } else if (_typeof(params[def]) === 'object') {
                for (var deepDef in defaults[def]) {
                    if (typeof params[def][deepDef] === 'undefined') {
                        params[def][deepDef] = defaults[def][deepDef];
                    }
                }
            }
        }

        // Swiper
        var s = this;

        // Params
        s.params = params;
        s.originalParams = originalParams;

        // Classname
        s.classNames = [];
        /*=========================
          Dom Library and plugins
          ===========================*/
        if (typeof $ !== 'undefined' && typeof Dom7 !== 'undefined') {
            $ = Dom7;
        }
        if (typeof $ === 'undefined') {
            if (typeof Dom7 === 'undefined') {
                $ = window.Dom7 || window.Zepto || window.jQuery;
            } else {
                $ = Dom7;
            }
            if (!$) return;
        }
        // Export it to Swiper instance
        s.$ = $;

        /*=========================
          Breakpoints
          ===========================*/
        s.currentBreakpoint = undefined;
        s.getActiveBreakpoint = function () {
            //Get breakpoint for window width
            if (!s.params.breakpoints) return false;
            var breakpoint = false;
            var points = [],
                point;
            for (point in s.params.breakpoints) {
                if (s.params.breakpoints.hasOwnProperty(point)) {
                    points.push(point);
                }
            }
            points.sort(function (a, b) {
                return parseInt(a, 10) > parseInt(b, 10);
            });
            for (var i = 0; i < points.length; i++) {
                point = points[i];
                if (point >= window.innerWidth && !breakpoint) {
                    breakpoint = point;
                }
            }
            return breakpoint || 'max';
        };
        s.setBreakpoint = function () {
            //Set breakpoint for window width and update parameters
            var breakpoint = s.getActiveBreakpoint();
            if (breakpoint && s.currentBreakpoint !== breakpoint) {
                var breakPointsParams = breakpoint in s.params.breakpoints ? s.params.breakpoints[breakpoint] : s.originalParams;
                var needsReLoop = s.params.loop && breakPointsParams.slidesPerView !== s.params.slidesPerView;
                for (var param in breakPointsParams) {
                    s.params[param] = breakPointsParams[param];
                }
                s.currentBreakpoint = breakpoint;
                if (needsReLoop && s.destroyLoop) {
                    s.reLoop(true);
                }
            }
        };
        // Set breakpoint on load
        if (s.params.breakpoints) {
            s.setBreakpoint();
        }

        /*=========================
          Preparation - Define Container, Wrapper and Pagination
          ===========================*/
        s.container = $(container);
        if (s.container.length === 0) return;
        if (s.container.length > 1) {
            var swipers = [];
            s.container.each(function () {
                var container = this;
                swipers.push(new Swiper(this, params));
            });
            return swipers;
        }

        // Save instance in container HTML Element and in data
        s.container[0].swiper = s;
        s.container.data('swiper', s);

        s.classNames.push(s.params.containerModifierClass + s.params.direction);

        if (s.params.freeMode) {
            s.classNames.push(s.params.containerModifierClass + 'free-mode');
        }
        if (!s.support.flexbox) {
            s.classNames.push(s.params.containerModifierClass + 'no-flexbox');
            s.params.slidesPerColumn = 1;
        }
        if (s.params.autoHeight) {
            s.classNames.push(s.params.containerModifierClass + 'autoheight');
        }
        // Enable slides progress when required
        if (s.params.parallax || s.params.watchSlidesVisibility) {
            s.params.watchSlidesProgress = true;
        }
        // Max resistance when touchReleaseOnEdges
        if (s.params.touchReleaseOnEdges) {
            s.params.resistanceRatio = 0;
        }
        // Coverflow / 3D
        if (['cube', 'coverflow', 'flip'].indexOf(s.params.effect) >= 0) {
            if (s.support.transforms3d) {
                s.params.watchSlidesProgress = true;
                s.classNames.push(s.params.containerModifierClass + '3d');
            } else {
                s.params.effect = 'slide';
            }
        }
        if (s.params.effect !== 'slide') {
            s.classNames.push(s.params.containerModifierClass + s.params.effect);
        }
        if (s.params.effect === 'cube') {
            s.params.resistanceRatio = 0;
            s.params.slidesPerView = 1;
            s.params.slidesPerColumn = 1;
            s.params.slidesPerGroup = 1;
            s.params.centeredSlides = false;
            s.params.spaceBetween = 0;
            s.params.virtualTranslate = true;
        }
        if (s.params.effect === 'fade' || s.params.effect === 'flip') {
            s.params.slidesPerView = 1;
            s.params.slidesPerColumn = 1;
            s.params.slidesPerGroup = 1;
            s.params.watchSlidesProgress = true;
            s.params.spaceBetween = 0;
            if (typeof initialVirtualTranslate === 'undefined') {
                s.params.virtualTranslate = true;
            }
        }

        // Grab Cursor
        if (s.params.grabCursor && s.support.touch) {
            s.params.grabCursor = false;
        }

        // Wrapper
        s.wrapper = s.container.children('.' + s.params.wrapperClass);

        // Pagination
        if (s.params.pagination) {
            s.paginationContainer = $(s.params.pagination);
            if (s.params.uniqueNavElements && typeof s.params.pagination === 'string' && s.paginationContainer.length > 1 && s.container.find(s.params.pagination).length === 1) {
                s.paginationContainer = s.container.find(s.params.pagination);
            }

            if (s.params.paginationType === 'bullets' && s.params.paginationClickable) {
                s.paginationContainer.addClass(s.params.paginationModifierClass + 'clickable');
            } else {
                s.params.paginationClickable = false;
            }
            s.paginationContainer.addClass(s.params.paginationModifierClass + s.params.paginationType);
        }
        // Next/Prev Buttons
        if (s.params.nextButton || s.params.prevButton) {
            if (s.params.nextButton) {
                s.nextButton = $(s.params.nextButton);
                if (s.params.uniqueNavElements && typeof s.params.nextButton === 'string' && s.nextButton.length > 1 && s.container.find(s.params.nextButton).length === 1) {
                    s.nextButton = s.container.find(s.params.nextButton);
                }
            }
            if (s.params.prevButton) {
                s.prevButton = $(s.params.prevButton);
                if (s.params.uniqueNavElements && typeof s.params.prevButton === 'string' && s.prevButton.length > 1 && s.container.find(s.params.prevButton).length === 1) {
                    s.prevButton = s.container.find(s.params.prevButton);
                }
            }
        }

        // Is Horizontal
        s.isHorizontal = function () {
            return s.params.direction === 'horizontal';
        };
        // s.isH = isH;

        // RTL
        s.rtl = s.isHorizontal() && (s.container[0].dir.toLowerCase() === 'rtl' || s.container.css('direction') === 'rtl');
        if (s.rtl) {
            s.classNames.push(s.params.containerModifierClass + 'rtl');
        }

        // Wrong RTL support
        if (s.rtl) {
            s.wrongRTL = s.wrapper.css('display') === '-webkit-box';
        }

        // Columns
        if (s.params.slidesPerColumn > 1) {
            s.classNames.push(s.params.containerModifierClass + 'multirow');
        }

        // Check for Android
        if (s.device.android) {
            s.classNames.push(s.params.containerModifierClass + 'android');
        }

        // Add classes
        s.container.addClass(s.classNames.join(' '));

        // Translate
        s.translate = 0;

        // Progress
        s.progress = 0;

        // Velocity
        s.velocity = 0;

        /*=========================
          Locks, unlocks
          ===========================*/
        s.lockSwipeToNext = function () {
            s.params.allowSwipeToNext = false;
            if (s.params.allowSwipeToPrev === false && s.params.grabCursor) {
                s.unsetGrabCursor();
            }
        };
        s.lockSwipeToPrev = function () {
            s.params.allowSwipeToPrev = false;
            if (s.params.allowSwipeToNext === false && s.params.grabCursor) {
                s.unsetGrabCursor();
            }
        };
        s.lockSwipes = function () {
            s.params.allowSwipeToNext = s.params.allowSwipeToPrev = false;
            if (s.params.grabCursor) s.unsetGrabCursor();
        };
        s.unlockSwipeToNext = function () {
            s.params.allowSwipeToNext = true;
            if (s.params.allowSwipeToPrev === true && s.params.grabCursor) {
                s.setGrabCursor();
            }
        };
        s.unlockSwipeToPrev = function () {
            s.params.allowSwipeToPrev = true;
            if (s.params.allowSwipeToNext === true && s.params.grabCursor) {
                s.setGrabCursor();
            }
        };
        s.unlockSwipes = function () {
            s.params.allowSwipeToNext = s.params.allowSwipeToPrev = true;
            if (s.params.grabCursor) s.setGrabCursor();
        };

        /*=========================
          Round helper
          ===========================*/
        function round(a) {
            return Math.floor(a);
        }
        /*=========================
          Set grab cursor
          ===========================*/
        s.setGrabCursor = function (moving) {
            s.container[0].style.cursor = 'move';
            s.container[0].style.cursor = moving ? '-webkit-grabbing' : '-webkit-grab';
            s.container[0].style.cursor = moving ? '-moz-grabbin' : '-moz-grab';
            s.container[0].style.cursor = moving ? 'grabbing' : 'grab';
        };
        s.unsetGrabCursor = function () {
            s.container[0].style.cursor = '';
        };
        if (s.params.grabCursor) {
            s.setGrabCursor();
        }
        /*=========================
          Update on Images Ready
          ===========================*/
        s.imagesToLoad = [];
        s.imagesLoaded = 0;

        s.loadImage = function (imgElement, src, srcset, sizes, checkForComplete, callback) {
            var image;
            function onReady() {
                if (callback) callback();
            }
            if (!imgElement.complete || !checkForComplete) {
                if (src) {
                    image = new window.Image();
                    image.onload = onReady;
                    image.onerror = onReady;
                    if (sizes) {
                        image.sizes = sizes;
                    }
                    if (srcset) {
                        image.srcset = srcset;
                    }
                    if (src) {
                        image.src = src;
                    }
                } else {
                    onReady();
                }
            } else {
                //image already loaded...
                onReady();
            }
        };
        s.preloadImages = function () {
            s.imagesToLoad = s.container.find('img');
            function _onReady() {
                if (typeof s === 'undefined' || s === null || !s) return;
                if (s.imagesLoaded !== undefined) s.imagesLoaded++;
                if (s.imagesLoaded === s.imagesToLoad.length) {
                    if (s.params.updateOnImagesReady) s.update();
                    s.emit('onImagesReady', s);
                }
            }
            for (var i = 0; i < s.imagesToLoad.length; i++) {
                s.loadImage(s.imagesToLoad[i], s.imagesToLoad[i].currentSrc || s.imagesToLoad[i].getAttribute('src'), s.imagesToLoad[i].srcset || s.imagesToLoad[i].getAttribute('srcset'), s.imagesToLoad[i].sizes || s.imagesToLoad[i].getAttribute('sizes'), true, _onReady);
            }
        };

        /*=========================
          Autoplay
          ===========================*/
        s.autoplayTimeoutId = undefined;
        s.autoplaying = false;
        s.autoplayPaused = false;
        function autoplay() {
            var autoplayDelay = s.params.autoplay;
            var activeSlide = s.slides.eq(s.activeIndex);
            if (activeSlide.attr('data-swiper-autoplay')) {
                autoplayDelay = activeSlide.attr('data-swiper-autoplay') || s.params.autoplay;
            }
            s.autoplayTimeoutId = setTimeout(function () {
                if (s.params.loop) {
                    s.fixLoop();
                    s._slideNext();
                    s.emit('onAutoplay', s);
                } else {
                    if (!s.isEnd) {
                        s._slideNext();
                        s.emit('onAutoplay', s);
                    } else {
                        if (!params.autoplayStopOnLast) {
                            s._slideTo(0);
                            s.emit('onAutoplay', s);
                        } else {
                            s.stopAutoplay();
                        }
                    }
                }
            }, autoplayDelay);
        }
        s.startAutoplay = function () {
            if (typeof s.autoplayTimeoutId !== 'undefined') return false;
            if (!s.params.autoplay) return false;
            if (s.autoplaying) return false;
            s.autoplaying = true;
            s.emit('onAutoplayStart', s);
            autoplay();
        };
        s.stopAutoplay = function (internal) {
            if (!s.autoplayTimeoutId) return;
            if (s.autoplayTimeoutId) clearTimeout(s.autoplayTimeoutId);
            s.autoplaying = false;
            s.autoplayTimeoutId = undefined;
            s.emit('onAutoplayStop', s);
        };
        s.pauseAutoplay = function (speed) {
            if (s.autoplayPaused) return;
            if (s.autoplayTimeoutId) clearTimeout(s.autoplayTimeoutId);
            s.autoplayPaused = true;
            if (speed === 0) {
                s.autoplayPaused = false;
                autoplay();
            } else {
                s.wrapper.transitionEnd(function () {
                    if (!s) return;
                    s.autoplayPaused = false;
                    if (!s.autoplaying) {
                        s.stopAutoplay();
                    } else {
                        autoplay();
                    }
                });
            }
        };
        /*=========================
          Min/Max Translate
          ===========================*/
        s.minTranslate = function () {
            return -s.snapGrid[0];
        };
        s.maxTranslate = function () {
            return -s.snapGrid[s.snapGrid.length - 1];
        };
        /*=========================
          Slider/slides sizes
          ===========================*/
        s.updateAutoHeight = function () {
            var activeSlides = [];
            var newHeight = 0;
            var i;

            // Find slides currently in view
            if (s.params.slidesPerView !== 'auto' && s.params.slidesPerView > 1) {
                for (i = 0; i < Math.ceil(s.params.slidesPerView); i++) {
                    var index = s.activeIndex + i;
                    if (index > s.slides.length) break;
                    activeSlides.push(s.slides.eq(index)[0]);
                }
            } else {
                activeSlides.push(s.slides.eq(s.activeIndex)[0]);
            }

            // Find new height from heighest slide in view
            for (i = 0; i < activeSlides.length; i++) {
                if (typeof activeSlides[i] !== 'undefined') {
                    var height = activeSlides[i].offsetHeight;
                    newHeight = height > newHeight ? height : newHeight;
                }
            }

            // Update Height
            if (newHeight) s.wrapper.css('height', newHeight + 'px');
        };
        s.updateContainerSize = function () {
            var width, height;
            if (typeof s.params.width !== 'undefined') {
                width = s.params.width;
            } else {
                width = s.container[0].clientWidth;
            }
            if (typeof s.params.height !== 'undefined') {
                height = s.params.height;
            } else {
                height = s.container[0].clientHeight;
            }
            if (width === 0 && s.isHorizontal() || height === 0 && !s.isHorizontal()) {
                return;
            }

            //Subtract paddings
            width = width - parseInt(s.container.css('padding-left'), 10) - parseInt(s.container.css('padding-right'), 10);
            height = height - parseInt(s.container.css('padding-top'), 10) - parseInt(s.container.css('padding-bottom'), 10);

            // Store values
            s.width = width;
            s.height = height;
            s.size = s.isHorizontal() ? s.width : s.height;
        };

        s.updateSlidesSize = function () {
            s.slides = s.wrapper.children('.' + s.params.slideClass);
            s.snapGrid = [];
            s.slidesGrid = [];
            s.slidesSizesGrid = [];

            var spaceBetween = s.params.spaceBetween,
                slidePosition = -s.params.slidesOffsetBefore,
                i,
                prevSlideSize = 0,
                index = 0;
            if (typeof s.size === 'undefined') return;
            if (typeof spaceBetween === 'string' && spaceBetween.indexOf('%') >= 0) {
                spaceBetween = parseFloat(spaceBetween.replace('%', '')) / 100 * s.size;
            }

            s.virtualSize = -spaceBetween;
            // reset margins
            if (s.rtl) s.slides.css({ marginLeft: '', marginTop: '' });else s.slides.css({ marginRight: '', marginBottom: '' });

            var slidesNumberEvenToRows;
            if (s.params.slidesPerColumn > 1) {
                if (Math.floor(s.slides.length / s.params.slidesPerColumn) === s.slides.length / s.params.slidesPerColumn) {
                    slidesNumberEvenToRows = s.slides.length;
                } else {
                    slidesNumberEvenToRows = Math.ceil(s.slides.length / s.params.slidesPerColumn) * s.params.slidesPerColumn;
                }
                if (s.params.slidesPerView !== 'auto' && s.params.slidesPerColumnFill === 'row') {
                    slidesNumberEvenToRows = Math.max(slidesNumberEvenToRows, s.params.slidesPerView * s.params.slidesPerColumn);
                }
            }

            // Calc slides
            var slideSize;
            var slidesPerColumn = s.params.slidesPerColumn;
            var slidesPerRow = slidesNumberEvenToRows / slidesPerColumn;
            var numFullColumns = slidesPerRow - (s.params.slidesPerColumn * slidesPerRow - s.slides.length);
            for (i = 0; i < s.slides.length; i++) {
                slideSize = 0;
                var slide = s.slides.eq(i);
                if (s.params.slidesPerColumn > 1) {
                    // Set slides order
                    var newSlideOrderIndex;
                    var column, row;
                    if (s.params.slidesPerColumnFill === 'column') {
                        column = Math.floor(i / slidesPerColumn);
                        row = i - column * slidesPerColumn;
                        if (column > numFullColumns || column === numFullColumns && row === slidesPerColumn - 1) {
                            if (++row >= slidesPerColumn) {
                                row = 0;
                                column++;
                            }
                        }
                        newSlideOrderIndex = column + row * slidesNumberEvenToRows / slidesPerColumn;
                        slide.css({
                            '-webkit-box-ordinal-group': newSlideOrderIndex,
                            '-moz-box-ordinal-group': newSlideOrderIndex,
                            '-ms-flex-order': newSlideOrderIndex,
                            '-webkit-order': newSlideOrderIndex,
                            'order': newSlideOrderIndex
                        });
                    } else {
                        row = Math.floor(i / slidesPerRow);
                        column = i - row * slidesPerRow;
                    }
                    slide.css('margin-' + (s.isHorizontal() ? 'top' : 'left'), row !== 0 && s.params.spaceBetween && s.params.spaceBetween + 'px').attr('data-swiper-column', column).attr('data-swiper-row', row);
                }
                if (slide.css('display') === 'none') continue;
                if (s.params.slidesPerView === 'auto') {
                    slideSize = s.isHorizontal() ? slide.outerWidth(true) : slide.outerHeight(true);
                    if (s.params.roundLengths) slideSize = round(slideSize);
                } else {
                    slideSize = (s.size - (s.params.slidesPerView - 1) * spaceBetween) / s.params.slidesPerView;
                    if (s.params.roundLengths) slideSize = round(slideSize);

                    if (s.isHorizontal()) {
                        s.slides[i].style.width = slideSize + 'px';
                    } else {
                        s.slides[i].style.height = slideSize + 'px';
                    }
                }
                s.slides[i].swiperSlideSize = slideSize;
                s.slidesSizesGrid.push(slideSize);

                if (s.params.centeredSlides) {
                    slidePosition = slidePosition + slideSize / 2 + prevSlideSize / 2 + spaceBetween;
                    if (prevSlideSize === 0 && i !== 0) slidePosition = slidePosition - s.size / 2 - spaceBetween;
                    if (i === 0) slidePosition = slidePosition - s.size / 2 - spaceBetween;
                    if (Math.abs(slidePosition) < 1 / 1000) slidePosition = 0;
                    if (index % s.params.slidesPerGroup === 0) s.snapGrid.push(slidePosition);
                    s.slidesGrid.push(slidePosition);
                } else {
                    if (index % s.params.slidesPerGroup === 0) s.snapGrid.push(slidePosition);
                    s.slidesGrid.push(slidePosition);
                    slidePosition = slidePosition + slideSize + spaceBetween;
                }

                s.virtualSize += slideSize + spaceBetween;

                prevSlideSize = slideSize;

                index++;
            }
            s.virtualSize = Math.max(s.virtualSize, s.size) + s.params.slidesOffsetAfter;
            var newSlidesGrid;

            if (s.rtl && s.wrongRTL && (s.params.effect === 'slide' || s.params.effect === 'coverflow')) {
                s.wrapper.css({ width: s.virtualSize + s.params.spaceBetween + 'px' });
            }
            if (!s.support.flexbox || s.params.setWrapperSize) {
                if (s.isHorizontal()) s.wrapper.css({ width: s.virtualSize + s.params.spaceBetween + 'px' });else s.wrapper.css({ height: s.virtualSize + s.params.spaceBetween + 'px' });
            }

            if (s.params.slidesPerColumn > 1) {
                s.virtualSize = (slideSize + s.params.spaceBetween) * slidesNumberEvenToRows;
                s.virtualSize = Math.ceil(s.virtualSize / s.params.slidesPerColumn) - s.params.spaceBetween;
                if (s.isHorizontal()) s.wrapper.css({ width: s.virtualSize + s.params.spaceBetween + 'px' });else s.wrapper.css({ height: s.virtualSize + s.params.spaceBetween + 'px' });
                if (s.params.centeredSlides) {
                    newSlidesGrid = [];
                    for (i = 0; i < s.snapGrid.length; i++) {
                        if (s.snapGrid[i] < s.virtualSize + s.snapGrid[0]) newSlidesGrid.push(s.snapGrid[i]);
                    }
                    s.snapGrid = newSlidesGrid;
                }
            }

            // Remove last grid elements depending on width
            if (!s.params.centeredSlides) {
                newSlidesGrid = [];
                for (i = 0; i < s.snapGrid.length; i++) {
                    if (s.snapGrid[i] <= s.virtualSize - s.size) {
                        newSlidesGrid.push(s.snapGrid[i]);
                    }
                }
                s.snapGrid = newSlidesGrid;
                if (Math.floor(s.virtualSize - s.size) - Math.floor(s.snapGrid[s.snapGrid.length - 1]) > 1) {
                    s.snapGrid.push(s.virtualSize - s.size);
                }
            }
            if (s.snapGrid.length === 0) s.snapGrid = [0];

            if (s.params.spaceBetween !== 0) {
                if (s.isHorizontal()) {
                    if (s.rtl) s.slides.css({ marginLeft: spaceBetween + 'px' });else s.slides.css({ marginRight: spaceBetween + 'px' });
                } else s.slides.css({ marginBottom: spaceBetween + 'px' });
            }
            if (s.params.watchSlidesProgress) {
                s.updateSlidesOffset();
            }
        };
        s.updateSlidesOffset = function () {
            for (var i = 0; i < s.slides.length; i++) {
                s.slides[i].swiperSlideOffset = s.isHorizontal() ? s.slides[i].offsetLeft : s.slides[i].offsetTop;
            }
        };

        /*=========================
          Dynamic Slides Per View
          ===========================*/
        s.currentSlidesPerView = function () {
            var spv = 1,
                i,
                j;
            if (s.params.centeredSlides) {
                var size = s.slides[s.activeIndex].swiperSlideSize;
                var breakLoop;
                for (i = s.activeIndex + 1; i < s.slides.length; i++) {
                    if (s.slides[i] && !breakLoop) {
                        size += s.slides[i].swiperSlideSize;
                        spv++;
                        if (size > s.size) breakLoop = true;
                    }
                }
                for (j = s.activeIndex - 1; j >= 0; j--) {
                    if (s.slides[j] && !breakLoop) {
                        size += s.slides[j].swiperSlideSize;
                        spv++;
                        if (size > s.size) breakLoop = true;
                    }
                }
            } else {
                for (i = s.activeIndex + 1; i < s.slides.length; i++) {
                    if (s.slidesGrid[i] - s.slidesGrid[s.activeIndex] < s.size) {
                        spv++;
                    }
                }
            }
            return spv;
        };
        /*=========================
          Slider/slides progress
          ===========================*/
        s.updateSlidesProgress = function (translate) {
            if (typeof translate === 'undefined') {
                translate = s.translate || 0;
            }
            if (s.slides.length === 0) return;
            if (typeof s.slides[0].swiperSlideOffset === 'undefined') s.updateSlidesOffset();

            var offsetCenter = -translate;
            if (s.rtl) offsetCenter = translate;

            // Visible Slides
            s.slides.removeClass(s.params.slideVisibleClass);
            for (var i = 0; i < s.slides.length; i++) {
                var slide = s.slides[i];
                var slideProgress = (offsetCenter + (s.params.centeredSlides ? s.minTranslate() : 0) - slide.swiperSlideOffset) / (slide.swiperSlideSize + s.params.spaceBetween);
                if (s.params.watchSlidesVisibility) {
                    var slideBefore = -(offsetCenter - slide.swiperSlideOffset);
                    var slideAfter = slideBefore + s.slidesSizesGrid[i];
                    var isVisible = slideBefore >= 0 && slideBefore < s.size || slideAfter > 0 && slideAfter <= s.size || slideBefore <= 0 && slideAfter >= s.size;
                    if (isVisible) {
                        s.slides.eq(i).addClass(s.params.slideVisibleClass);
                    }
                }
                slide.progress = s.rtl ? -slideProgress : slideProgress;
            }
        };
        s.updateProgress = function (translate) {
            if (typeof translate === 'undefined') {
                translate = s.translate || 0;
            }
            var translatesDiff = s.maxTranslate() - s.minTranslate();
            var wasBeginning = s.isBeginning;
            var wasEnd = s.isEnd;
            if (translatesDiff === 0) {
                s.progress = 0;
                s.isBeginning = s.isEnd = true;
            } else {
                s.progress = (translate - s.minTranslate()) / translatesDiff;
                s.isBeginning = s.progress <= 0;
                s.isEnd = s.progress >= 1;
            }
            if (s.isBeginning && !wasBeginning) s.emit('onReachBeginning', s);
            if (s.isEnd && !wasEnd) s.emit('onReachEnd', s);

            if (s.params.watchSlidesProgress) s.updateSlidesProgress(translate);
            s.emit('onProgress', s, s.progress);
        };
        s.updateActiveIndex = function () {
            var translate = s.rtl ? s.translate : -s.translate;
            var newActiveIndex, i, snapIndex;
            for (i = 0; i < s.slidesGrid.length; i++) {
                if (typeof s.slidesGrid[i + 1] !== 'undefined') {
                    if (translate >= s.slidesGrid[i] && translate < s.slidesGrid[i + 1] - (s.slidesGrid[i + 1] - s.slidesGrid[i]) / 2) {
                        newActiveIndex = i;
                    } else if (translate >= s.slidesGrid[i] && translate < s.slidesGrid[i + 1]) {
                        newActiveIndex = i + 1;
                    }
                } else {
                    if (translate >= s.slidesGrid[i]) {
                        newActiveIndex = i;
                    }
                }
            }
            // Normalize slideIndex
            if (s.params.normalizeSlideIndex) {
                if (newActiveIndex < 0 || typeof newActiveIndex === 'undefined') newActiveIndex = 0;
            }
            // for (i = 0; i < s.slidesGrid.length; i++) {
            // if (- translate >= s.slidesGrid[i]) {
            // newActiveIndex = i;
            // }
            // }
            snapIndex = Math.floor(newActiveIndex / s.params.slidesPerGroup);
            if (snapIndex >= s.snapGrid.length) snapIndex = s.snapGrid.length - 1;

            if (newActiveIndex === s.activeIndex) {
                return;
            }
            s.snapIndex = snapIndex;
            s.previousIndex = s.activeIndex;
            s.activeIndex = newActiveIndex;
            s.updateClasses();
            s.updateRealIndex();
        };
        s.updateRealIndex = function () {
            s.realIndex = parseInt(s.slides.eq(s.activeIndex).attr('data-swiper-slide-index') || s.activeIndex, 10);
        };

        /*=========================
          Classes
          ===========================*/
        s.updateClasses = function () {
            s.slides.removeClass(s.params.slideActiveClass + ' ' + s.params.slideNextClass + ' ' + s.params.slidePrevClass + ' ' + s.params.slideDuplicateActiveClass + ' ' + s.params.slideDuplicateNextClass + ' ' + s.params.slideDuplicatePrevClass);
            var activeSlide = s.slides.eq(s.activeIndex);
            // Active classes
            activeSlide.addClass(s.params.slideActiveClass);
            if (params.loop) {
                // Duplicate to all looped slides
                if (activeSlide.hasClass(s.params.slideDuplicateClass)) {
                    s.wrapper.children('.' + s.params.slideClass + ':not(.' + s.params.slideDuplicateClass + ')[data-swiper-slide-index="' + s.realIndex + '"]').addClass(s.params.slideDuplicateActiveClass);
                } else {
                    s.wrapper.children('.' + s.params.slideClass + '.' + s.params.slideDuplicateClass + '[data-swiper-slide-index="' + s.realIndex + '"]').addClass(s.params.slideDuplicateActiveClass);
                }
            }
            // Next Slide
            var nextSlide = activeSlide.next('.' + s.params.slideClass).addClass(s.params.slideNextClass);
            if (s.params.loop && nextSlide.length === 0) {
                nextSlide = s.slides.eq(0);
                nextSlide.addClass(s.params.slideNextClass);
            }
            // Prev Slide
            var prevSlide = activeSlide.prev('.' + s.params.slideClass).addClass(s.params.slidePrevClass);
            if (s.params.loop && prevSlide.length === 0) {
                prevSlide = s.slides.eq(-1);
                prevSlide.addClass(s.params.slidePrevClass);
            }
            if (params.loop) {
                // Duplicate to all looped slides
                if (nextSlide.hasClass(s.params.slideDuplicateClass)) {
                    s.wrapper.children('.' + s.params.slideClass + ':not(.' + s.params.slideDuplicateClass + ')[data-swiper-slide-index="' + nextSlide.attr('data-swiper-slide-index') + '"]').addClass(s.params.slideDuplicateNextClass);
                } else {
                    s.wrapper.children('.' + s.params.slideClass + '.' + s.params.slideDuplicateClass + '[data-swiper-slide-index="' + nextSlide.attr('data-swiper-slide-index') + '"]').addClass(s.params.slideDuplicateNextClass);
                }
                if (prevSlide.hasClass(s.params.slideDuplicateClass)) {
                    s.wrapper.children('.' + s.params.slideClass + ':not(.' + s.params.slideDuplicateClass + ')[data-swiper-slide-index="' + prevSlide.attr('data-swiper-slide-index') + '"]').addClass(s.params.slideDuplicatePrevClass);
                } else {
                    s.wrapper.children('.' + s.params.slideClass + '.' + s.params.slideDuplicateClass + '[data-swiper-slide-index="' + prevSlide.attr('data-swiper-slide-index') + '"]').addClass(s.params.slideDuplicatePrevClass);
                }
            }

            // Pagination
            if (s.paginationContainer && s.paginationContainer.length > 0) {
                // Current/Total
                var current,
                    total = s.params.loop ? Math.ceil((s.slides.length - s.loopedSlides * 2) / s.params.slidesPerGroup) : s.snapGrid.length;
                if (s.params.loop) {
                    current = Math.ceil((s.activeIndex - s.loopedSlides) / s.params.slidesPerGroup);
                    if (current > s.slides.length - 1 - s.loopedSlides * 2) {
                        current = current - (s.slides.length - s.loopedSlides * 2);
                    }
                    if (current > total - 1) current = current - total;
                    if (current < 0 && s.params.paginationType !== 'bullets') current = total + current;
                } else {
                    if (typeof s.snapIndex !== 'undefined') {
                        current = s.snapIndex;
                    } else {
                        current = s.activeIndex || 0;
                    }
                }
                // Types
                if (s.params.paginationType === 'bullets' && s.bullets && s.bullets.length > 0) {
                    s.bullets.removeClass(s.params.bulletActiveClass);
                    if (s.paginationContainer.length > 1) {
                        s.bullets.each(function () {
                            if ($(this).index() === current) $(this).addClass(s.params.bulletActiveClass);
                        });
                    } else {
                        s.bullets.eq(current).addClass(s.params.bulletActiveClass);
                    }
                }
                if (s.params.paginationType === 'fraction') {
                    s.paginationContainer.find('.' + s.params.paginationCurrentClass).text(current + 1);
                    s.paginationContainer.find('.' + s.params.paginationTotalClass).text(total);
                }
                if (s.params.paginationType === 'progress') {
                    var scale = (current + 1) / total,
                        scaleX = scale,
                        scaleY = 1;
                    if (!s.isHorizontal()) {
                        scaleY = scale;
                        scaleX = 1;
                    }
                    s.paginationContainer.find('.' + s.params.paginationProgressbarClass).transform('translate3d(0,0,0) scaleX(' + scaleX + ') scaleY(' + scaleY + ')').transition(s.params.speed);
                }
                if (s.params.paginationType === 'custom' && s.params.paginationCustomRender) {
                    s.paginationContainer.html(s.params.paginationCustomRender(s, current + 1, total));
                    s.emit('onPaginationRendered', s, s.paginationContainer[0]);
                }
            }

            // Next/active buttons
            if (!s.params.loop) {
                if (s.params.prevButton && s.prevButton && s.prevButton.length > 0) {
                    if (s.isBeginning) {
                        s.prevButton.addClass(s.params.buttonDisabledClass);
                        if (s.params.a11y && s.a11y) s.a11y.disable(s.prevButton);
                    } else {
                        s.prevButton.removeClass(s.params.buttonDisabledClass);
                        if (s.params.a11y && s.a11y) s.a11y.enable(s.prevButton);
                    }
                }
                if (s.params.nextButton && s.nextButton && s.nextButton.length > 0) {
                    if (s.isEnd) {
                        s.nextButton.addClass(s.params.buttonDisabledClass);
                        if (s.params.a11y && s.a11y) s.a11y.disable(s.nextButton);
                    } else {
                        s.nextButton.removeClass(s.params.buttonDisabledClass);
                        if (s.params.a11y && s.a11y) s.a11y.enable(s.nextButton);
                    }
                }
            }
        };

        /*=========================
          Pagination
          ===========================*/
        s.updatePagination = function () {
            if (!s.params.pagination) return;
            if (s.paginationContainer && s.paginationContainer.length > 0) {
                var paginationHTML = '';
                if (s.params.paginationType === 'bullets') {
                    var numberOfBullets = s.params.loop ? Math.ceil((s.slides.length - s.loopedSlides * 2) / s.params.slidesPerGroup) : s.snapGrid.length;
                    for (var i = 0; i < numberOfBullets; i++) {
                        if (s.params.paginationBulletRender) {
                            paginationHTML += s.params.paginationBulletRender(s, i, s.params.bulletClass);
                        } else {
                            paginationHTML += '<' + s.params.paginationElement + ' class="' + s.params.bulletClass + '"></' + s.params.paginationElement + '>';
                        }
                    }
                    s.paginationContainer.html(paginationHTML);
                    s.bullets = s.paginationContainer.find('.' + s.params.bulletClass);
                    if (s.params.paginationClickable && s.params.a11y && s.a11y) {
                        s.a11y.initPagination();
                    }
                }
                if (s.params.paginationType === 'fraction') {
                    if (s.params.paginationFractionRender) {
                        paginationHTML = s.params.paginationFractionRender(s, s.params.paginationCurrentClass, s.params.paginationTotalClass);
                    } else {
                        paginationHTML = '<span class="' + s.params.paginationCurrentClass + '"></span>' + ' / ' + '<span class="' + s.params.paginationTotalClass + '"></span>';
                    }
                    s.paginationContainer.html(paginationHTML);
                }
                if (s.params.paginationType === 'progress') {
                    if (s.params.paginationProgressRender) {
                        paginationHTML = s.params.paginationProgressRender(s, s.params.paginationProgressbarClass);
                    } else {
                        paginationHTML = '<span class="' + s.params.paginationProgressbarClass + '"></span>';
                    }
                    s.paginationContainer.html(paginationHTML);
                }
                if (s.params.paginationType !== 'custom') {
                    s.emit('onPaginationRendered', s, s.paginationContainer[0]);
                }
            }
        };
        /*=========================
          Common update method
          ===========================*/
        s.update = function (updateTranslate) {
            if (!s) return;
            s.updateContainerSize();
            s.updateSlidesSize();
            s.updateProgress();
            s.updatePagination();
            s.updateClasses();
            if (s.params.scrollbar && s.scrollbar) {
                s.scrollbar.set();
            }
            var newTranslate;
            function forceSetTranslate() {
                var translate = s.rtl ? -s.translate : s.translate;
                newTranslate = Math.min(Math.max(s.translate, s.maxTranslate()), s.minTranslate());
                s.setWrapperTranslate(newTranslate);
                s.updateActiveIndex();
                s.updateClasses();
            }
            if (updateTranslate) {
                var translated;
                if (s.controller && s.controller.spline) {
                    s.controller.spline = undefined;
                }
                if (s.params.freeMode) {
                    forceSetTranslate();
                    if (s.params.autoHeight) {
                        s.updateAutoHeight();
                    }
                } else {
                    if ((s.params.slidesPerView === 'auto' || s.params.slidesPerView > 1) && s.isEnd && !s.params.centeredSlides) {
                        translated = s.slideTo(s.slides.length - 1, 0, false, true);
                    } else {
                        translated = s.slideTo(s.activeIndex, 0, false, true);
                    }
                    if (!translated) {
                        forceSetTranslate();
                    }
                }
            } else if (s.params.autoHeight) {
                s.updateAutoHeight();
            }
        };

        /*=========================
          Resize Handler
          ===========================*/
        s.onResize = function (forceUpdatePagination) {
            if (s.params.onBeforeResize) s.params.onBeforeResize(s);
            //Breakpoints
            if (s.params.breakpoints) {
                s.setBreakpoint();
            }

            // Disable locks on resize
            var allowSwipeToPrev = s.params.allowSwipeToPrev;
            var allowSwipeToNext = s.params.allowSwipeToNext;
            s.params.allowSwipeToPrev = s.params.allowSwipeToNext = true;

            s.updateContainerSize();
            s.updateSlidesSize();
            if (s.params.slidesPerView === 'auto' || s.params.freeMode || forceUpdatePagination) s.updatePagination();
            if (s.params.scrollbar && s.scrollbar) {
                s.scrollbar.set();
            }
            if (s.controller && s.controller.spline) {
                s.controller.spline = undefined;
            }
            var slideChangedBySlideTo = false;
            if (s.params.freeMode) {
                var newTranslate = Math.min(Math.max(s.translate, s.maxTranslate()), s.minTranslate());
                s.setWrapperTranslate(newTranslate);
                s.updateActiveIndex();
                s.updateClasses();

                if (s.params.autoHeight) {
                    s.updateAutoHeight();
                }
            } else {
                s.updateClasses();
                if ((s.params.slidesPerView === 'auto' || s.params.slidesPerView > 1) && s.isEnd && !s.params.centeredSlides) {
                    slideChangedBySlideTo = s.slideTo(s.slides.length - 1, 0, false, true);
                } else {
                    slideChangedBySlideTo = s.slideTo(s.activeIndex, 0, false, true);
                }
            }
            if (s.params.lazyLoading && !slideChangedBySlideTo && s.lazy) {
                s.lazy.load();
            }
            // Return locks after resize
            s.params.allowSwipeToPrev = allowSwipeToPrev;
            s.params.allowSwipeToNext = allowSwipeToNext;
            if (s.params.onAfterResize) s.params.onAfterResize(s);
        };

        /*=========================
          Events
          ===========================*/

        //Define Touch Events
        s.touchEventsDesktop = { start: 'mousedown', move: 'mousemove', end: 'mouseup' };
        if (window.navigator.pointerEnabled) s.touchEventsDesktop = { start: 'pointerdown', move: 'pointermove', end: 'pointerup' };else if (window.navigator.msPointerEnabled) s.touchEventsDesktop = { start: 'MSPointerDown', move: 'MSPointerMove', end: 'MSPointerUp' };
        s.touchEvents = {
            start: s.support.touch || !s.params.simulateTouch ? 'touchstart' : s.touchEventsDesktop.start,
            move: s.support.touch || !s.params.simulateTouch ? 'touchmove' : s.touchEventsDesktop.move,
            end: s.support.touch || !s.params.simulateTouch ? 'touchend' : s.touchEventsDesktop.end
        };

        // WP8 Touch Events Fix
        if (window.navigator.pointerEnabled || window.navigator.msPointerEnabled) {
            (s.params.touchEventsTarget === 'container' ? s.container : s.wrapper).addClass('swiper-wp8-' + s.params.direction);
        }

        // Attach/detach events
        s.initEvents = function (detach) {
            var actionDom = detach ? 'off' : 'on';
            var action = detach ? 'removeEventListener' : 'addEventListener';
            var touchEventsTarget = s.params.touchEventsTarget === 'container' ? s.container[0] : s.wrapper[0];
            var target = s.support.touch ? touchEventsTarget : document;

            var moveCapture = s.params.nested ? true : false;

            //Touch Events
            if (s.browser.ie) {
                touchEventsTarget[action](s.touchEvents.start, s.onTouchStart, false);
                target[action](s.touchEvents.move, s.onTouchMove, moveCapture);
                target[action](s.touchEvents.end, s.onTouchEnd, false);
            } else {
                if (s.support.touch) {
                    var passiveListener = s.touchEvents.start === 'touchstart' && s.support.passiveListener && s.params.passiveListeners ? { passive: true, capture: false } : false;
                    touchEventsTarget[action](s.touchEvents.start, s.onTouchStart, passiveListener);
                    touchEventsTarget[action](s.touchEvents.move, s.onTouchMove, moveCapture);
                    touchEventsTarget[action](s.touchEvents.end, s.onTouchEnd, passiveListener);
                }
                if (params.simulateTouch && !s.device.ios && !s.device.android || params.simulateTouch && !s.support.touch && s.device.ios) {
                    touchEventsTarget[action]('mousedown', s.onTouchStart, false);
                    document[action]('mousemove', s.onTouchMove, moveCapture);
                    document[action]('mouseup', s.onTouchEnd, false);
                }
            }
            window[action]('resize', s.onResize);

            // Next, Prev, Index
            if (s.params.nextButton && s.nextButton && s.nextButton.length > 0) {
                s.nextButton[actionDom]('click', s.onClickNext);
                if (s.params.a11y && s.a11y) s.nextButton[actionDom]('keydown', s.a11y.onEnterKey);
            }
            if (s.params.prevButton && s.prevButton && s.prevButton.length > 0) {
                s.prevButton[actionDom]('click', s.onClickPrev);
                if (s.params.a11y && s.a11y) s.prevButton[actionDom]('keydown', s.a11y.onEnterKey);
            }
            if (s.params.pagination && s.params.paginationClickable) {
                s.paginationContainer[actionDom]('click', '.' + s.params.bulletClass, s.onClickIndex);
                if (s.params.a11y && s.a11y) s.paginationContainer[actionDom]('keydown', '.' + s.params.bulletClass, s.a11y.onEnterKey);
            }

            // Prevent Links Clicks
            if (s.params.preventClicks || s.params.preventClicksPropagation) touchEventsTarget[action]('click', s.preventClicks, true);
        };
        s.attachEvents = function () {
            s.initEvents();
        };
        s.detachEvents = function () {
            s.initEvents(true);
        };

        /*=========================
          Handle Clicks
          ===========================*/
        // Prevent Clicks
        s.allowClick = true;
        s.preventClicks = function (e) {
            if (!s.allowClick) {
                if (s.params.preventClicks) e.preventDefault();
                if (s.params.preventClicksPropagation && s.animating) {
                    e.stopPropagation();
                    e.stopImmediatePropagation();
                }
            }
        };
        // Clicks
        s.onClickNext = function (e) {
            e.preventDefault();
            if (s.isEnd && !s.params.loop) return;
            s.slideNext();
        };
        s.onClickPrev = function (e) {
            e.preventDefault();
            if (s.isBeginning && !s.params.loop) return;
            s.slidePrev();
        };
        s.onClickIndex = function (e) {
            e.preventDefault();
            var index = $(this).index() * s.params.slidesPerGroup;
            if (s.params.loop) index = index + s.loopedSlides;
            s.slideTo(index);
        };

        /*=========================
          Handle Touches
          ===========================*/
        function findElementInEvent(e, selector) {
            var el = $(e.target);
            if (!el.is(selector)) {
                if (typeof selector === 'string') {
                    el = el.parents(selector);
                } else if (selector.nodeType) {
                    var found;
                    el.parents().each(function (index, _el) {
                        if (_el === selector) found = selector;
                    });
                    if (!found) return undefined;else return selector;
                }
            }
            if (el.length === 0) {
                return undefined;
            }
            return el[0];
        }
        s.updateClickedSlide = function (e) {
            var slide = findElementInEvent(e, '.' + s.params.slideClass);
            var slideFound = false;
            if (slide) {
                for (var i = 0; i < s.slides.length; i++) {
                    if (s.slides[i] === slide) slideFound = true;
                }
            }

            if (slide && slideFound) {
                s.clickedSlide = slide;
                s.clickedIndex = $(slide).index();
            } else {
                s.clickedSlide = undefined;
                s.clickedIndex = undefined;
                return;
            }
            if (s.params.slideToClickedSlide && s.clickedIndex !== undefined && s.clickedIndex !== s.activeIndex) {
                var slideToIndex = s.clickedIndex,
                    realIndex,
                    duplicatedSlides,
                    slidesPerView = s.params.slidesPerView === 'auto' ? s.currentSlidesPerView() : s.params.slidesPerView;
                if (s.params.loop) {
                    if (s.animating) return;
                    realIndex = parseInt($(s.clickedSlide).attr('data-swiper-slide-index'), 10);
                    if (s.params.centeredSlides) {
                        if (slideToIndex < s.loopedSlides - slidesPerView / 2 || slideToIndex > s.slides.length - s.loopedSlides + slidesPerView / 2) {
                            s.fixLoop();
                            slideToIndex = s.wrapper.children('.' + s.params.slideClass + '[data-swiper-slide-index="' + realIndex + '"]:not(.' + s.params.slideDuplicateClass + ')').eq(0).index();
                            setTimeout(function () {
                                s.slideTo(slideToIndex);
                            }, 0);
                        } else {
                            s.slideTo(slideToIndex);
                        }
                    } else {
                        if (slideToIndex > s.slides.length - slidesPerView) {
                            s.fixLoop();
                            slideToIndex = s.wrapper.children('.' + s.params.slideClass + '[data-swiper-slide-index="' + realIndex + '"]:not(.' + s.params.slideDuplicateClass + ')').eq(0).index();
                            setTimeout(function () {
                                s.slideTo(slideToIndex);
                            }, 0);
                        } else {
                            s.slideTo(slideToIndex);
                        }
                    }
                } else {
                    s.slideTo(slideToIndex);
                }
            }
        };

        var isTouched,
            isMoved,
            allowTouchCallbacks,
            touchStartTime,
            isScrolling,
            currentTranslate,
            startTranslate,
            allowThresholdMove,

        // Form elements to match
        formElements = 'input, select, textarea, button, video',

        // Last click time
        lastClickTime = Date.now(),
            clickTimeout,

        //Velocities
        velocities = [],
            allowMomentumBounce;

        // Animating Flag
        s.animating = false;

        // Touches information
        s.touches = {
            startX: 0,
            startY: 0,
            currentX: 0,
            currentY: 0,
            diff: 0
        };

        // Touch handlers
        var isTouchEvent, startMoving;
        s.onTouchStart = function (e) {
            if (e.originalEvent) e = e.originalEvent;
            isTouchEvent = e.type === 'touchstart';
            if (!isTouchEvent && 'which' in e && e.which === 3) return;
            if (s.params.noSwiping && findElementInEvent(e, '.' + s.params.noSwipingClass)) {
                s.allowClick = true;
                return;
            }
            if (s.params.swipeHandler) {
                if (!findElementInEvent(e, s.params.swipeHandler)) return;
            }

            var startX = s.touches.currentX = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
            var startY = s.touches.currentY = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;

            // Do NOT start if iOS edge swipe is detected. Otherwise iOS app (UIWebView) cannot swipe-to-go-back anymore
            if (s.device.ios && s.params.iOSEdgeSwipeDetection && startX <= s.params.iOSEdgeSwipeThreshold) {
                return;
            }

            isTouched = true;
            isMoved = false;
            allowTouchCallbacks = true;
            isScrolling = undefined;
            startMoving = undefined;
            s.touches.startX = startX;
            s.touches.startY = startY;
            touchStartTime = Date.now();
            s.allowClick = true;
            s.updateContainerSize();
            s.swipeDirection = undefined;
            if (s.params.threshold > 0) allowThresholdMove = false;
            if (e.type !== 'touchstart') {
                var preventDefault = true;
                if ($(e.target).is(formElements)) preventDefault = false;
                if (document.activeElement && $(document.activeElement).is(formElements)) {
                    document.activeElement.blur();
                }
                if (preventDefault) {
                    e.preventDefault();
                }
            }
            s.emit('onTouchStart', s, e);
        };

        s.onTouchMove = function (e) {
            if (e.originalEvent) e = e.originalEvent;
            if (isTouchEvent && e.type === 'mousemove') return;
            if (e.preventedByNestedSwiper) {
                s.touches.startX = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;
                s.touches.startY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;
                return;
            }
            if (s.params.onlyExternal) {
                // isMoved = true;
                s.allowClick = false;
                if (isTouched) {
                    s.touches.startX = s.touches.currentX = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;
                    s.touches.startY = s.touches.currentY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;
                    touchStartTime = Date.now();
                }
                return;
            }
            if (isTouchEvent && s.params.touchReleaseOnEdges && !s.params.loop) {
                if (!s.isHorizontal()) {
                    // Vertical
                    if (s.touches.currentY < s.touches.startY && s.translate <= s.maxTranslate() || s.touches.currentY > s.touches.startY && s.translate >= s.minTranslate()) {
                        return;
                    }
                } else {
                    if (s.touches.currentX < s.touches.startX && s.translate <= s.maxTranslate() || s.touches.currentX > s.touches.startX && s.translate >= s.minTranslate()) {
                        return;
                    }
                }
            }
            if (isTouchEvent && document.activeElement) {
                if (e.target === document.activeElement && $(e.target).is(formElements)) {
                    isMoved = true;
                    s.allowClick = false;
                    return;
                }
            }
            if (allowTouchCallbacks) {
                s.emit('onTouchMove', s, e);
            }
            if (e.targetTouches && e.targetTouches.length > 1) return;

            s.touches.currentX = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;
            s.touches.currentY = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;

            if (typeof isScrolling === 'undefined') {
                var touchAngle;
                if (s.isHorizontal() && s.touches.currentY === s.touches.startY || !s.isHorizontal() && s.touches.currentX === s.touches.startX) {
                    isScrolling = false;
                } else {
                    touchAngle = Math.atan2(Math.abs(s.touches.currentY - s.touches.startY), Math.abs(s.touches.currentX - s.touches.startX)) * 180 / Math.PI;
                    isScrolling = s.isHorizontal() ? touchAngle > s.params.touchAngle : 90 - touchAngle > s.params.touchAngle;
                }
            }
            if (isScrolling) {
                s.emit('onTouchMoveOpposite', s, e);
            }
            if (typeof startMoving === 'undefined') {
                if (s.touches.currentX !== s.touches.startX || s.touches.currentY !== s.touches.startY) {
                    startMoving = true;
                }
            }
            if (!isTouched) return;
            if (isScrolling) {
                isTouched = false;
                return;
            }
            if (!startMoving) {
                return;
            }
            s.allowClick = false;
            s.emit('onSliderMove', s, e);
            e.preventDefault();
            if (s.params.touchMoveStopPropagation && !s.params.nested) {
                e.stopPropagation();
            }

            if (!isMoved) {
                if (params.loop) {
                    s.fixLoop();
                }
                startTranslate = s.getWrapperTranslate();
                s.setWrapperTransition(0);
                if (s.animating) {
                    s.wrapper.trigger('webkitTransitionEnd transitionend oTransitionEnd MSTransitionEnd msTransitionEnd');
                }
                if (s.params.autoplay && s.autoplaying) {
                    if (s.params.autoplayDisableOnInteraction) {
                        s.stopAutoplay();
                    } else {
                        s.pauseAutoplay();
                    }
                }
                allowMomentumBounce = false;
                //Grab Cursor
                if (s.params.grabCursor && (s.params.allowSwipeToNext === true || s.params.allowSwipeToPrev === true)) {
                    s.setGrabCursor(true);
                }
            }
            isMoved = true;

            var diff = s.touches.diff = s.isHorizontal() ? s.touches.currentX - s.touches.startX : s.touches.currentY - s.touches.startY;

            diff = diff * s.params.touchRatio;
            if (s.rtl) diff = -diff;

            s.swipeDirection = diff > 0 ? 'prev' : 'next';
            currentTranslate = diff + startTranslate;

            var disableParentSwiper = true;
            if (diff > 0 && currentTranslate > s.minTranslate()) {
                disableParentSwiper = false;
                if (s.params.resistance) currentTranslate = s.minTranslate() - 1 + Math.pow(-s.minTranslate() + startTranslate + diff, s.params.resistanceRatio);
            } else if (diff < 0 && currentTranslate < s.maxTranslate()) {
                disableParentSwiper = false;
                if (s.params.resistance) currentTranslate = s.maxTranslate() + 1 - Math.pow(s.maxTranslate() - startTranslate - diff, s.params.resistanceRatio);
            }

            if (disableParentSwiper) {
                e.preventedByNestedSwiper = true;
            }

            // Directions locks
            if (!s.params.allowSwipeToNext && s.swipeDirection === 'next' && currentTranslate < startTranslate) {
                currentTranslate = startTranslate;
            }
            if (!s.params.allowSwipeToPrev && s.swipeDirection === 'prev' && currentTranslate > startTranslate) {
                currentTranslate = startTranslate;
            }

            // Threshold
            if (s.params.threshold > 0) {
                if (Math.abs(diff) > s.params.threshold || allowThresholdMove) {
                    if (!allowThresholdMove) {
                        allowThresholdMove = true;
                        s.touches.startX = s.touches.currentX;
                        s.touches.startY = s.touches.currentY;
                        currentTranslate = startTranslate;
                        s.touches.diff = s.isHorizontal() ? s.touches.currentX - s.touches.startX : s.touches.currentY - s.touches.startY;
                        return;
                    }
                } else {
                    currentTranslate = startTranslate;
                    return;
                }
            }

            if (!s.params.followFinger) return;

            // Update active index in free mode
            if (s.params.freeMode || s.params.watchSlidesProgress) {
                s.updateActiveIndex();
            }
            if (s.params.freeMode) {
                //Velocity
                if (velocities.length === 0) {
                    velocities.push({
                        position: s.touches[s.isHorizontal() ? 'startX' : 'startY'],
                        time: touchStartTime
                    });
                }
                velocities.push({
                    position: s.touches[s.isHorizontal() ? 'currentX' : 'currentY'],
                    time: new window.Date().getTime()
                });
            }
            // Update progress
            s.updateProgress(currentTranslate);
            // Update translate
            s.setWrapperTranslate(currentTranslate);
        };
        s.onTouchEnd = function (e) {
            if (e.originalEvent) e = e.originalEvent;
            if (allowTouchCallbacks) {
                s.emit('onTouchEnd', s, e);
            }
            allowTouchCallbacks = false;
            if (!isTouched) return;
            //Return Grab Cursor
            if (s.params.grabCursor && isMoved && isTouched && (s.params.allowSwipeToNext === true || s.params.allowSwipeToPrev === true)) {
                s.setGrabCursor(false);
            }

            // Time diff
            var touchEndTime = Date.now();
            var timeDiff = touchEndTime - touchStartTime;

            // Tap, doubleTap, Click
            if (s.allowClick) {
                s.updateClickedSlide(e);
                s.emit('onTap', s, e);
                if (timeDiff < 300 && touchEndTime - lastClickTime > 300) {
                    if (clickTimeout) clearTimeout(clickTimeout);
                    clickTimeout = setTimeout(function () {
                        if (!s) return;
                        if (s.params.paginationHide && s.paginationContainer.length > 0 && !$(e.target).hasClass(s.params.bulletClass)) {
                            s.paginationContainer.toggleClass(s.params.paginationHiddenClass);
                        }
                        s.emit('onClick', s, e);
                    }, 300);
                }
                if (timeDiff < 300 && touchEndTime - lastClickTime < 300) {
                    if (clickTimeout) clearTimeout(clickTimeout);
                    s.emit('onDoubleTap', s, e);
                }
            }

            lastClickTime = Date.now();
            setTimeout(function () {
                if (s) s.allowClick = true;
            }, 0);

            if (!isTouched || !isMoved || !s.swipeDirection || s.touches.diff === 0 || currentTranslate === startTranslate) {
                isTouched = isMoved = false;
                return;
            }
            isTouched = isMoved = false;

            var currentPos;
            if (s.params.followFinger) {
                currentPos = s.rtl ? s.translate : -s.translate;
            } else {
                currentPos = -currentTranslate;
            }
            if (s.params.freeMode) {
                if (currentPos < -s.minTranslate()) {
                    s.slideTo(s.activeIndex);
                    return;
                } else if (currentPos > -s.maxTranslate()) {
                    if (s.slides.length < s.snapGrid.length) {
                        s.slideTo(s.snapGrid.length - 1);
                    } else {
                        s.slideTo(s.slides.length - 1);
                    }
                    return;
                }

                if (s.params.freeModeMomentum) {
                    if (velocities.length > 1) {
                        var lastMoveEvent = velocities.pop(),
                            velocityEvent = velocities.pop();

                        var distance = lastMoveEvent.position - velocityEvent.position;
                        var time = lastMoveEvent.time - velocityEvent.time;
                        s.velocity = distance / time;
                        s.velocity = s.velocity / 2;
                        if (Math.abs(s.velocity) < s.params.freeModeMinimumVelocity) {
                            s.velocity = 0;
                        }
                        // this implies that the user stopped moving a finger then released.
                        // There would be no events with distance zero, so the last event is stale.
                        if (time > 150 || new window.Date().getTime() - lastMoveEvent.time > 300) {
                            s.velocity = 0;
                        }
                    } else {
                        s.velocity = 0;
                    }
                    s.velocity = s.velocity * s.params.freeModeMomentumVelocityRatio;

                    velocities.length = 0;
                    var momentumDuration = 1000 * s.params.freeModeMomentumRatio;
                    var momentumDistance = s.velocity * momentumDuration;

                    var newPosition = s.translate + momentumDistance;
                    if (s.rtl) newPosition = -newPosition;
                    var doBounce = false;
                    var afterBouncePosition;
                    var bounceAmount = Math.abs(s.velocity) * 20 * s.params.freeModeMomentumBounceRatio;
                    if (newPosition < s.maxTranslate()) {
                        if (s.params.freeModeMomentumBounce) {
                            if (newPosition + s.maxTranslate() < -bounceAmount) {
                                newPosition = s.maxTranslate() - bounceAmount;
                            }
                            afterBouncePosition = s.maxTranslate();
                            doBounce = true;
                            allowMomentumBounce = true;
                        } else {
                            newPosition = s.maxTranslate();
                        }
                    } else if (newPosition > s.minTranslate()) {
                        if (s.params.freeModeMomentumBounce) {
                            if (newPosition - s.minTranslate() > bounceAmount) {
                                newPosition = s.minTranslate() + bounceAmount;
                            }
                            afterBouncePosition = s.minTranslate();
                            doBounce = true;
                            allowMomentumBounce = true;
                        } else {
                            newPosition = s.minTranslate();
                        }
                    } else if (s.params.freeModeSticky) {
                        var j = 0,
                            nextSlide;
                        for (j = 0; j < s.snapGrid.length; j += 1) {
                            if (s.snapGrid[j] > -newPosition) {
                                nextSlide = j;
                                break;
                            }
                        }
                        if (Math.abs(s.snapGrid[nextSlide] - newPosition) < Math.abs(s.snapGrid[nextSlide - 1] - newPosition) || s.swipeDirection === 'next') {
                            newPosition = s.snapGrid[nextSlide];
                        } else {
                            newPosition = s.snapGrid[nextSlide - 1];
                        }
                        if (!s.rtl) newPosition = -newPosition;
                    }
                    //Fix duration
                    if (s.velocity !== 0) {
                        if (s.rtl) {
                            momentumDuration = Math.abs((-newPosition - s.translate) / s.velocity);
                        } else {
                            momentumDuration = Math.abs((newPosition - s.translate) / s.velocity);
                        }
                    } else if (s.params.freeModeSticky) {
                        s.slideReset();
                        return;
                    }

                    if (s.params.freeModeMomentumBounce && doBounce) {
                        s.updateProgress(afterBouncePosition);
                        s.setWrapperTransition(momentumDuration);
                        s.setWrapperTranslate(newPosition);
                        s.onTransitionStart();
                        s.animating = true;
                        s.wrapper.transitionEnd(function () {
                            if (!s || !allowMomentumBounce) return;
                            s.emit('onMomentumBounce', s);

                            s.setWrapperTransition(s.params.speed);
                            s.setWrapperTranslate(afterBouncePosition);
                            s.wrapper.transitionEnd(function () {
                                if (!s) return;
                                s.onTransitionEnd();
                            });
                        });
                    } else if (s.velocity) {
                        s.updateProgress(newPosition);
                        s.setWrapperTransition(momentumDuration);
                        s.setWrapperTranslate(newPosition);
                        s.onTransitionStart();
                        if (!s.animating) {
                            s.animating = true;
                            s.wrapper.transitionEnd(function () {
                                if (!s) return;
                                s.onTransitionEnd();
                            });
                        }
                    } else {
                        s.updateProgress(newPosition);
                    }

                    s.updateActiveIndex();
                }
                if (!s.params.freeModeMomentum || timeDiff >= s.params.longSwipesMs) {
                    s.updateProgress();
                    s.updateActiveIndex();
                }
                return;
            }

            // Find current slide
            var i,
                stopIndex = 0,
                groupSize = s.slidesSizesGrid[0];
            for (i = 0; i < s.slidesGrid.length; i += s.params.slidesPerGroup) {
                if (typeof s.slidesGrid[i + s.params.slidesPerGroup] !== 'undefined') {
                    if (currentPos >= s.slidesGrid[i] && currentPos < s.slidesGrid[i + s.params.slidesPerGroup]) {
                        stopIndex = i;
                        groupSize = s.slidesGrid[i + s.params.slidesPerGroup] - s.slidesGrid[i];
                    }
                } else {
                    if (currentPos >= s.slidesGrid[i]) {
                        stopIndex = i;
                        groupSize = s.slidesGrid[s.slidesGrid.length - 1] - s.slidesGrid[s.slidesGrid.length - 2];
                    }
                }
            }

            // Find current slide size
            var ratio = (currentPos - s.slidesGrid[stopIndex]) / groupSize;

            if (timeDiff > s.params.longSwipesMs) {
                // Long touches
                if (!s.params.longSwipes) {
                    s.slideTo(s.activeIndex);
                    return;
                }
                if (s.swipeDirection === 'next') {
                    if (ratio >= s.params.longSwipesRatio) s.slideTo(stopIndex + s.params.slidesPerGroup);else s.slideTo(stopIndex);
                }
                if (s.swipeDirection === 'prev') {
                    if (ratio > 1 - s.params.longSwipesRatio) s.slideTo(stopIndex + s.params.slidesPerGroup);else s.slideTo(stopIndex);
                }
            } else {
                // Short swipes
                if (!s.params.shortSwipes) {
                    s.slideTo(s.activeIndex);
                    return;
                }
                if (s.swipeDirection === 'next') {
                    s.slideTo(stopIndex + s.params.slidesPerGroup);
                }
                if (s.swipeDirection === 'prev') {
                    s.slideTo(stopIndex);
                }
            }
        };
        /*=========================
          Transitions
          ===========================*/
        s._slideTo = function (slideIndex, speed) {
            return s.slideTo(slideIndex, speed, true, true);
        };
        s.slideTo = function (slideIndex, speed, runCallbacks, internal) {
            if (typeof runCallbacks === 'undefined') runCallbacks = true;
            if (typeof slideIndex === 'undefined') slideIndex = 0;
            if (slideIndex < 0) slideIndex = 0;
            s.snapIndex = Math.floor(slideIndex / s.params.slidesPerGroup);
            if (s.snapIndex >= s.snapGrid.length) s.snapIndex = s.snapGrid.length - 1;

            var translate = -s.snapGrid[s.snapIndex];
            // Stop autoplay
            if (s.params.autoplay && s.autoplaying) {
                if (internal || !s.params.autoplayDisableOnInteraction) {
                    s.pauseAutoplay(speed);
                } else {
                    s.stopAutoplay();
                }
            }
            // Update progress
            s.updateProgress(translate);

            // Normalize slideIndex
            if (s.params.normalizeSlideIndex) {
                for (var i = 0; i < s.slidesGrid.length; i++) {
                    if (-Math.floor(translate * 100) >= Math.floor(s.slidesGrid[i] * 100)) {
                        slideIndex = i;
                    }
                }
            }

            // Directions locks
            if (!s.params.allowSwipeToNext && translate < s.translate && translate < s.minTranslate()) {
                return false;
            }
            if (!s.params.allowSwipeToPrev && translate > s.translate && translate > s.maxTranslate()) {
                if ((s.activeIndex || 0) !== slideIndex) return false;
            }

            // Update Index
            if (typeof speed === 'undefined') speed = s.params.speed;
            s.previousIndex = s.activeIndex || 0;
            s.activeIndex = slideIndex;
            s.updateRealIndex();
            if (s.rtl && -translate === s.translate || !s.rtl && translate === s.translate) {
                // Update Height
                if (s.params.autoHeight) {
                    s.updateAutoHeight();
                }
                s.updateClasses();
                if (s.params.effect !== 'slide') {
                    s.setWrapperTranslate(translate);
                }
                return false;
            }
            s.updateClasses();
            s.onTransitionStart(runCallbacks);

            if (speed === 0 || s.browser.lteIE9) {
                s.setWrapperTranslate(translate);
                s.setWrapperTransition(0);
                s.onTransitionEnd(runCallbacks);
            } else {
                s.setWrapperTranslate(translate);
                s.setWrapperTransition(speed);
                if (!s.animating) {
                    s.animating = true;
                    s.wrapper.transitionEnd(function () {
                        if (!s) return;
                        s.onTransitionEnd(runCallbacks);
                    });
                }
            }

            return true;
        };

        s.onTransitionStart = function (runCallbacks) {
            if (typeof runCallbacks === 'undefined') runCallbacks = true;
            if (s.params.autoHeight) {
                s.updateAutoHeight();
            }
            if (s.lazy) s.lazy.onTransitionStart();
            if (runCallbacks) {
                s.emit('onTransitionStart', s);
                if (s.activeIndex !== s.previousIndex) {
                    s.emit('onSlideChangeStart', s);
                    if (s.activeIndex > s.previousIndex) {
                        s.emit('onSlideNextStart', s);
                    } else {
                        s.emit('onSlidePrevStart', s);
                    }
                }
            }
        };
        s.onTransitionEnd = function (runCallbacks) {
            s.animating = false;
            s.setWrapperTransition(0);
            if (typeof runCallbacks === 'undefined') runCallbacks = true;
            if (s.lazy) s.lazy.onTransitionEnd();
            if (runCallbacks) {
                s.emit('onTransitionEnd', s);
                if (s.activeIndex !== s.previousIndex) {
                    s.emit('onSlideChangeEnd', s);
                    if (s.activeIndex > s.previousIndex) {
                        s.emit('onSlideNextEnd', s);
                    } else {
                        s.emit('onSlidePrevEnd', s);
                    }
                }
            }
            if (s.params.history && s.history) {
                s.history.setHistory(s.params.history, s.activeIndex);
            }
            if (s.params.hashnav && s.hashnav) {
                s.hashnav.setHash();
            }
        };
        s.slideNext = function (runCallbacks, speed, internal) {
            if (s.params.loop) {
                if (s.animating) return false;
                s.fixLoop();
                var clientLeft = s.container[0].clientLeft;
                return s.slideTo(s.activeIndex + s.params.slidesPerGroup, speed, runCallbacks, internal);
            } else return s.slideTo(s.activeIndex + s.params.slidesPerGroup, speed, runCallbacks, internal);
        };
        s._slideNext = function (speed) {
            return s.slideNext(true, speed, true);
        };
        s.slidePrev = function (runCallbacks, speed, internal) {
            if (s.params.loop) {
                if (s.animating) return false;
                s.fixLoop();
                var clientLeft = s.container[0].clientLeft;
                return s.slideTo(s.activeIndex - 1, speed, runCallbacks, internal);
            } else return s.slideTo(s.activeIndex - 1, speed, runCallbacks, internal);
        };
        s._slidePrev = function (speed) {
            return s.slidePrev(true, speed, true);
        };
        s.slideReset = function (runCallbacks, speed, internal) {
            return s.slideTo(s.activeIndex, speed, runCallbacks);
        };

        s.disableTouchControl = function () {
            s.params.onlyExternal = true;
            return true;
        };
        s.enableTouchControl = function () {
            s.params.onlyExternal = false;
            return true;
        };

        /*=========================
          Translate/transition helpers
          ===========================*/
        s.setWrapperTransition = function (duration, byController) {
            s.wrapper.transition(duration);
            if (s.params.effect !== 'slide' && s.effects[s.params.effect]) {
                s.effects[s.params.effect].setTransition(duration);
            }
            if (s.params.parallax && s.parallax) {
                s.parallax.setTransition(duration);
            }
            if (s.params.scrollbar && s.scrollbar) {
                s.scrollbar.setTransition(duration);
            }
            if (s.params.control && s.controller) {
                s.controller.setTransition(duration, byController);
            }
            s.emit('onSetTransition', s, duration);
        };
        s.setWrapperTranslate = function (translate, updateActiveIndex, byController) {
            var x = 0,
                y = 0,
                z = 0;
            if (s.isHorizontal()) {
                x = s.rtl ? -translate : translate;
            } else {
                y = translate;
            }

            if (s.params.roundLengths) {
                x = round(x);
                y = round(y);
            }

            if (!s.params.virtualTranslate) {
                if (s.support.transforms3d) s.wrapper.transform('translate3d(' + x + 'px, ' + y + 'px, ' + z + 'px)');else s.wrapper.transform('translate(' + x + 'px, ' + y + 'px)');
            }

            s.translate = s.isHorizontal() ? x : y;

            // Check if we need to update progress
            var progress;
            var translatesDiff = s.maxTranslate() - s.minTranslate();
            if (translatesDiff === 0) {
                progress = 0;
            } else {
                progress = (translate - s.minTranslate()) / translatesDiff;
            }
            if (progress !== s.progress) {
                s.updateProgress(translate);
            }

            if (updateActiveIndex) s.updateActiveIndex();
            if (s.params.effect !== 'slide' && s.effects[s.params.effect]) {
                s.effects[s.params.effect].setTranslate(s.translate);
            }
            if (s.params.parallax && s.parallax) {
                s.parallax.setTranslate(s.translate);
            }
            if (s.params.scrollbar && s.scrollbar) {
                s.scrollbar.setTranslate(s.translate);
            }
            if (s.params.control && s.controller) {
                s.controller.setTranslate(s.translate, byController);
            }
            s.emit('onSetTranslate', s, s.translate);
        };

        s.getTranslate = function (el, axis) {
            var matrix, curTransform, curStyle, transformMatrix;

            // automatic axis detection
            if (typeof axis === 'undefined') {
                axis = 'x';
            }

            if (s.params.virtualTranslate) {
                return s.rtl ? -s.translate : s.translate;
            }

            curStyle = window.getComputedStyle(el, null);
            if (window.WebKitCSSMatrix) {
                curTransform = curStyle.transform || curStyle.webkitTransform;
                if (curTransform.split(',').length > 6) {
                    curTransform = curTransform.split(', ').map(function (a) {
                        return a.replace(',', '.');
                    }).join(', ');
                }
                // Some old versions of Webkit choke when 'none' is passed; pass
                // empty string instead in this case
                transformMatrix = new window.WebKitCSSMatrix(curTransform === 'none' ? '' : curTransform);
            } else {
                transformMatrix = curStyle.MozTransform || curStyle.OTransform || curStyle.MsTransform || curStyle.msTransform || curStyle.transform || curStyle.getPropertyValue('transform').replace('translate(', 'matrix(1, 0, 0, 1,');
                matrix = transformMatrix.toString().split(',');
            }

            if (axis === 'x') {
                //Latest Chrome and webkits Fix
                if (window.WebKitCSSMatrix) curTransform = transformMatrix.m41;
                //Crazy IE10 Matrix
                else if (matrix.length === 16) curTransform = parseFloat(matrix[12]);
                    //Normal Browsers
                    else curTransform = parseFloat(matrix[4]);
            }
            if (axis === 'y') {
                //Latest Chrome and webkits Fix
                if (window.WebKitCSSMatrix) curTransform = transformMatrix.m42;
                //Crazy IE10 Matrix
                else if (matrix.length === 16) curTransform = parseFloat(matrix[13]);
                    //Normal Browsers
                    else curTransform = parseFloat(matrix[5]);
            }
            if (s.rtl && curTransform) curTransform = -curTransform;
            return curTransform || 0;
        };
        s.getWrapperTranslate = function (axis) {
            if (typeof axis === 'undefined') {
                axis = s.isHorizontal() ? 'x' : 'y';
            }
            return s.getTranslate(s.wrapper[0], axis);
        };

        /*=========================
          Observer
          ===========================*/
        s.observers = [];
        function initObserver(target, options) {
            options = options || {};
            // create an observer instance
            var ObserverFunc = window.MutationObserver || window.WebkitMutationObserver;
            var observer = new ObserverFunc(function (mutations) {
                mutations.forEach(function (mutation) {
                    s.onResize(true);
                    s.emit('onObserverUpdate', s, mutation);
                });
            });

            observer.observe(target, {
                attributes: typeof options.attributes === 'undefined' ? true : options.attributes,
                childList: typeof options.childList === 'undefined' ? true : options.childList,
                characterData: typeof options.characterData === 'undefined' ? true : options.characterData
            });

            s.observers.push(observer);
        }
        s.initObservers = function () {
            if (s.params.observeParents) {
                var containerParents = s.container.parents();
                for (var i = 0; i < containerParents.length; i++) {
                    initObserver(containerParents[i]);
                }
            }

            // Observe container
            initObserver(s.container[0], { childList: false });

            // Observe wrapper
            initObserver(s.wrapper[0], { attributes: false });
        };
        s.disconnectObservers = function () {
            for (var i = 0; i < s.observers.length; i++) {
                s.observers[i].disconnect();
            }
            s.observers = [];
        };
        /*=========================
          Loop
          ===========================*/
        // Create looped slides
        s.createLoop = function () {
            // Remove duplicated slides
            s.wrapper.children('.' + s.params.slideClass + '.' + s.params.slideDuplicateClass).remove();

            var slides = s.wrapper.children('.' + s.params.slideClass);

            if (s.params.slidesPerView === 'auto' && !s.params.loopedSlides) s.params.loopedSlides = slides.length;

            s.loopedSlides = parseInt(s.params.loopedSlides || s.params.slidesPerView, 10);
            s.loopedSlides = s.loopedSlides + s.params.loopAdditionalSlides;
            if (s.loopedSlides > slides.length) {
                s.loopedSlides = slides.length;
            }

            var prependSlides = [],
                appendSlides = [],
                i;
            slides.each(function (index, el) {
                var slide = $(this);
                if (index < s.loopedSlides) appendSlides.push(el);
                if (index < slides.length && index >= slides.length - s.loopedSlides) prependSlides.push(el);
                slide.attr('data-swiper-slide-index', index);
            });
            for (i = 0; i < appendSlides.length; i++) {
                s.wrapper.append($(appendSlides[i].cloneNode(true)).addClass(s.params.slideDuplicateClass));
            }
            for (i = prependSlides.length - 1; i >= 0; i--) {
                s.wrapper.prepend($(prependSlides[i].cloneNode(true)).addClass(s.params.slideDuplicateClass));
            }
        };
        s.destroyLoop = function () {
            s.wrapper.children('.' + s.params.slideClass + '.' + s.params.slideDuplicateClass).remove();
            s.slides.removeAttr('data-swiper-slide-index');
        };
        s.reLoop = function (updatePosition) {
            var oldIndex = s.activeIndex - s.loopedSlides;
            s.destroyLoop();
            s.createLoop();
            s.updateSlidesSize();
            if (updatePosition) {
                s.slideTo(oldIndex + s.loopedSlides, 0, false);
            }
        };
        s.fixLoop = function () {
            var newIndex;
            //Fix For Negative Oversliding
            if (s.activeIndex < s.loopedSlides) {
                newIndex = s.slides.length - s.loopedSlides * 3 + s.activeIndex;
                newIndex = newIndex + s.loopedSlides;
                s.slideTo(newIndex, 0, false, true);
            }
            //Fix For Positive Oversliding
            else if (s.params.slidesPerView === 'auto' && s.activeIndex >= s.loopedSlides * 2 || s.activeIndex > s.slides.length - s.params.slidesPerView * 2) {
                    newIndex = -s.slides.length + s.activeIndex + s.loopedSlides;
                    newIndex = newIndex + s.loopedSlides;
                    s.slideTo(newIndex, 0, false, true);
                }
        };
        /*=========================
          Append/Prepend/Remove Slides
          ===========================*/
        s.appendSlide = function (slides) {
            if (s.params.loop) {
                s.destroyLoop();
            }
            if ((typeof slides === 'undefined' ? 'undefined' : _typeof(slides)) === 'object' && slides.length) {
                for (var i = 0; i < slides.length; i++) {
                    if (slides[i]) s.wrapper.append(slides[i]);
                }
            } else {
                s.wrapper.append(slides);
            }
            if (s.params.loop) {
                s.createLoop();
            }
            if (!(s.params.observer && s.support.observer)) {
                s.update(true);
            }
        };
        s.prependSlide = function (slides) {
            if (s.params.loop) {
                s.destroyLoop();
            }
            var newActiveIndex = s.activeIndex + 1;
            if ((typeof slides === 'undefined' ? 'undefined' : _typeof(slides)) === 'object' && slides.length) {
                for (var i = 0; i < slides.length; i++) {
                    if (slides[i]) s.wrapper.prepend(slides[i]);
                }
                newActiveIndex = s.activeIndex + slides.length;
            } else {
                s.wrapper.prepend(slides);
            }
            if (s.params.loop) {
                s.createLoop();
            }
            if (!(s.params.observer && s.support.observer)) {
                s.update(true);
            }
            s.slideTo(newActiveIndex, 0, false);
        };
        s.removeSlide = function (slidesIndexes) {
            if (s.params.loop) {
                s.destroyLoop();
                s.slides = s.wrapper.children('.' + s.params.slideClass);
            }
            var newActiveIndex = s.activeIndex,
                indexToRemove;
            if ((typeof slidesIndexes === 'undefined' ? 'undefined' : _typeof(slidesIndexes)) === 'object' && slidesIndexes.length) {
                for (var i = 0; i < slidesIndexes.length; i++) {
                    indexToRemove = slidesIndexes[i];
                    if (s.slides[indexToRemove]) s.slides.eq(indexToRemove).remove();
                    if (indexToRemove < newActiveIndex) newActiveIndex--;
                }
                newActiveIndex = Math.max(newActiveIndex, 0);
            } else {
                indexToRemove = slidesIndexes;
                if (s.slides[indexToRemove]) s.slides.eq(indexToRemove).remove();
                if (indexToRemove < newActiveIndex) newActiveIndex--;
                newActiveIndex = Math.max(newActiveIndex, 0);
            }

            if (s.params.loop) {
                s.createLoop();
            }

            if (!(s.params.observer && s.support.observer)) {
                s.update(true);
            }
            if (s.params.loop) {
                s.slideTo(newActiveIndex + s.loopedSlides, 0, false);
            } else {
                s.slideTo(newActiveIndex, 0, false);
            }
        };
        s.removeAllSlides = function () {
            var slidesIndexes = [];
            for (var i = 0; i < s.slides.length; i++) {
                slidesIndexes.push(i);
            }
            s.removeSlide(slidesIndexes);
        };

        /*=========================
          Effects
          ===========================*/
        s.effects = {
            fade: {
                setTranslate: function setTranslate() {
                    for (var i = 0; i < s.slides.length; i++) {
                        var slide = s.slides.eq(i);
                        var offset = slide[0].swiperSlideOffset;
                        var tx = -offset;
                        if (!s.params.virtualTranslate) tx = tx - s.translate;
                        var ty = 0;
                        if (!s.isHorizontal()) {
                            ty = tx;
                            tx = 0;
                        }
                        var slideOpacity = s.params.fade.crossFade ? Math.max(1 - Math.abs(slide[0].progress), 0) : 1 + Math.min(Math.max(slide[0].progress, -1), 0);
                        slide.css({
                            opacity: slideOpacity
                        }).transform('translate3d(' + tx + 'px, ' + ty + 'px, 0px)');
                    }
                },
                setTransition: function setTransition(duration) {
                    s.slides.transition(duration);
                    if (s.params.virtualTranslate && duration !== 0) {
                        var eventTriggered = false;
                        s.slides.transitionEnd(function () {
                            if (eventTriggered) return;
                            if (!s) return;
                            eventTriggered = true;
                            s.animating = false;
                            var triggerEvents = ['webkitTransitionEnd', 'transitionend', 'oTransitionEnd', 'MSTransitionEnd', 'msTransitionEnd'];
                            for (var i = 0; i < triggerEvents.length; i++) {
                                s.wrapper.trigger(triggerEvents[i]);
                            }
                        });
                    }
                }
            },
            flip: {
                setTranslate: function setTranslate() {
                    for (var i = 0; i < s.slides.length; i++) {
                        var slide = s.slides.eq(i);
                        var progress = slide[0].progress;
                        if (s.params.flip.limitRotation) {
                            progress = Math.max(Math.min(slide[0].progress, 1), -1);
                        }
                        var offset = slide[0].swiperSlideOffset;
                        var rotate = -180 * progress,
                            rotateY = rotate,
                            rotateX = 0,
                            tx = -offset,
                            ty = 0;
                        if (!s.isHorizontal()) {
                            ty = tx;
                            tx = 0;
                            rotateX = -rotateY;
                            rotateY = 0;
                        } else if (s.rtl) {
                            rotateY = -rotateY;
                        }

                        slide[0].style.zIndex = -Math.abs(Math.round(progress)) + s.slides.length;

                        if (s.params.flip.slideShadows) {
                            //Set shadows
                            var shadowBefore = s.isHorizontal() ? slide.find('.swiper-slide-shadow-left') : slide.find('.swiper-slide-shadow-top');
                            var shadowAfter = s.isHorizontal() ? slide.find('.swiper-slide-shadow-right') : slide.find('.swiper-slide-shadow-bottom');
                            if (shadowBefore.length === 0) {
                                shadowBefore = $('<div class="swiper-slide-shadow-' + (s.isHorizontal() ? 'left' : 'top') + '"></div>');
                                slide.append(shadowBefore);
                            }
                            if (shadowAfter.length === 0) {
                                shadowAfter = $('<div class="swiper-slide-shadow-' + (s.isHorizontal() ? 'right' : 'bottom') + '"></div>');
                                slide.append(shadowAfter);
                            }
                            if (shadowBefore.length) shadowBefore[0].style.opacity = Math.max(-progress, 0);
                            if (shadowAfter.length) shadowAfter[0].style.opacity = Math.max(progress, 0);
                        }

                        slide.transform('translate3d(' + tx + 'px, ' + ty + 'px, 0px) rotateX(' + rotateX + 'deg) rotateY(' + rotateY + 'deg)');
                    }
                },
                setTransition: function setTransition(duration) {
                    s.slides.transition(duration).find('.swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left').transition(duration);
                    if (s.params.virtualTranslate && duration !== 0) {
                        var eventTriggered = false;
                        s.slides.eq(s.activeIndex).transitionEnd(function () {
                            if (eventTriggered) return;
                            if (!s) return;
                            if (!$(this).hasClass(s.params.slideActiveClass)) return;
                            eventTriggered = true;
                            s.animating = false;
                            var triggerEvents = ['webkitTransitionEnd', 'transitionend', 'oTransitionEnd', 'MSTransitionEnd', 'msTransitionEnd'];
                            for (var i = 0; i < triggerEvents.length; i++) {
                                s.wrapper.trigger(triggerEvents[i]);
                            }
                        });
                    }
                }
            },
            cube: {
                setTranslate: function setTranslate() {
                    var wrapperRotate = 0,
                        cubeShadow;
                    if (s.params.cube.shadow) {
                        if (s.isHorizontal()) {
                            cubeShadow = s.wrapper.find('.swiper-cube-shadow');
                            if (cubeShadow.length === 0) {
                                cubeShadow = $('<div class="swiper-cube-shadow"></div>');
                                s.wrapper.append(cubeShadow);
                            }
                            cubeShadow.css({ height: s.width + 'px' });
                        } else {
                            cubeShadow = s.container.find('.swiper-cube-shadow');
                            if (cubeShadow.length === 0) {
                                cubeShadow = $('<div class="swiper-cube-shadow"></div>');
                                s.container.append(cubeShadow);
                            }
                        }
                    }
                    for (var i = 0; i < s.slides.length; i++) {
                        var slide = s.slides.eq(i);
                        var slideAngle = i * 90;
                        var round = Math.floor(slideAngle / 360);
                        if (s.rtl) {
                            slideAngle = -slideAngle;
                            round = Math.floor(-slideAngle / 360);
                        }
                        var progress = Math.max(Math.min(slide[0].progress, 1), -1);
                        var tx = 0,
                            ty = 0,
                            tz = 0;
                        if (i % 4 === 0) {
                            tx = -round * 4 * s.size;
                            tz = 0;
                        } else if ((i - 1) % 4 === 0) {
                            tx = 0;
                            tz = -round * 4 * s.size;
                        } else if ((i - 2) % 4 === 0) {
                            tx = s.size + round * 4 * s.size;
                            tz = s.size;
                        } else if ((i - 3) % 4 === 0) {
                            tx = -s.size;
                            tz = 3 * s.size + s.size * 4 * round;
                        }
                        if (s.rtl) {
                            tx = -tx;
                        }

                        if (!s.isHorizontal()) {
                            ty = tx;
                            tx = 0;
                        }

                        var transform = 'rotateX(' + (s.isHorizontal() ? 0 : -slideAngle) + 'deg) rotateY(' + (s.isHorizontal() ? slideAngle : 0) + 'deg) translate3d(' + tx + 'px, ' + ty + 'px, ' + tz + 'px)';
                        if (progress <= 1 && progress > -1) {
                            wrapperRotate = i * 90 + progress * 90;
                            if (s.rtl) wrapperRotate = -i * 90 - progress * 90;
                        }
                        slide.transform(transform);
                        if (s.params.cube.slideShadows) {
                            //Set shadows
                            var shadowBefore = s.isHorizontal() ? slide.find('.swiper-slide-shadow-left') : slide.find('.swiper-slide-shadow-top');
                            var shadowAfter = s.isHorizontal() ? slide.find('.swiper-slide-shadow-right') : slide.find('.swiper-slide-shadow-bottom');
                            if (shadowBefore.length === 0) {
                                shadowBefore = $('<div class="swiper-slide-shadow-' + (s.isHorizontal() ? 'left' : 'top') + '"></div>');
                                slide.append(shadowBefore);
                            }
                            if (shadowAfter.length === 0) {
                                shadowAfter = $('<div class="swiper-slide-shadow-' + (s.isHorizontal() ? 'right' : 'bottom') + '"></div>');
                                slide.append(shadowAfter);
                            }
                            if (shadowBefore.length) shadowBefore[0].style.opacity = Math.max(-progress, 0);
                            if (shadowAfter.length) shadowAfter[0].style.opacity = Math.max(progress, 0);
                        }
                    }
                    s.wrapper.css({
                        '-webkit-transform-origin': '50% 50% -' + s.size / 2 + 'px',
                        '-moz-transform-origin': '50% 50% -' + s.size / 2 + 'px',
                        '-ms-transform-origin': '50% 50% -' + s.size / 2 + 'px',
                        'transform-origin': '50% 50% -' + s.size / 2 + 'px'
                    });

                    if (s.params.cube.shadow) {
                        if (s.isHorizontal()) {
                            cubeShadow.transform('translate3d(0px, ' + (s.width / 2 + s.params.cube.shadowOffset) + 'px, ' + -s.width / 2 + 'px) rotateX(90deg) rotateZ(0deg) scale(' + s.params.cube.shadowScale + ')');
                        } else {
                            var shadowAngle = Math.abs(wrapperRotate) - Math.floor(Math.abs(wrapperRotate) / 90) * 90;
                            var multiplier = 1.5 - (Math.sin(shadowAngle * 2 * Math.PI / 360) / 2 + Math.cos(shadowAngle * 2 * Math.PI / 360) / 2);
                            var scale1 = s.params.cube.shadowScale,
                                scale2 = s.params.cube.shadowScale / multiplier,
                                offset = s.params.cube.shadowOffset;
                            cubeShadow.transform('scale3d(' + scale1 + ', 1, ' + scale2 + ') translate3d(0px, ' + (s.height / 2 + offset) + 'px, ' + -s.height / 2 / scale2 + 'px) rotateX(-90deg)');
                        }
                    }
                    var zFactor = s.isSafari || s.isUiWebView ? -s.size / 2 : 0;
                    s.wrapper.transform('translate3d(0px,0,' + zFactor + 'px) rotateX(' + (s.isHorizontal() ? 0 : wrapperRotate) + 'deg) rotateY(' + (s.isHorizontal() ? -wrapperRotate : 0) + 'deg)');
                },
                setTransition: function setTransition(duration) {
                    s.slides.transition(duration).find('.swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left').transition(duration);
                    if (s.params.cube.shadow && !s.isHorizontal()) {
                        s.container.find('.swiper-cube-shadow').transition(duration);
                    }
                }
            },
            coverflow: {
                setTranslate: function setTranslate() {
                    var transform = s.translate;
                    var center = s.isHorizontal() ? -transform + s.width / 2 : -transform + s.height / 2;
                    var rotate = s.isHorizontal() ? s.params.coverflow.rotate : -s.params.coverflow.rotate;
                    var translate = s.params.coverflow.depth;
                    //Each slide offset from center
                    for (var i = 0, length = s.slides.length; i < length; i++) {
                        var slide = s.slides.eq(i);
                        var slideSize = s.slidesSizesGrid[i];
                        var slideOffset = slide[0].swiperSlideOffset;
                        var offsetMultiplier = (center - slideOffset - slideSize / 2) / slideSize * s.params.coverflow.modifier;

                        var rotateY = s.isHorizontal() ? rotate * offsetMultiplier : 0;
                        var rotateX = s.isHorizontal() ? 0 : rotate * offsetMultiplier;
                        // var rotateZ = 0
                        var translateZ = -translate * Math.abs(offsetMultiplier);

                        var translateY = s.isHorizontal() ? 0 : s.params.coverflow.stretch * offsetMultiplier;
                        var translateX = s.isHorizontal() ? s.params.coverflow.stretch * offsetMultiplier : 0;

                        //Fix for ultra small values
                        if (Math.abs(translateX) < 0.001) translateX = 0;
                        if (Math.abs(translateY) < 0.001) translateY = 0;
                        if (Math.abs(translateZ) < 0.001) translateZ = 0;
                        if (Math.abs(rotateY) < 0.001) rotateY = 0;
                        if (Math.abs(rotateX) < 0.001) rotateX = 0;

                        var slideTransform = 'translate3d(' + translateX + 'px,' + translateY + 'px,' + translateZ + 'px)  rotateX(' + rotateX + 'deg) rotateY(' + rotateY + 'deg)';

                        slide.transform(slideTransform);
                        slide[0].style.zIndex = -Math.abs(Math.round(offsetMultiplier)) + 1;
                        if (s.params.coverflow.slideShadows) {
                            //Set shadows
                            var shadowBefore = s.isHorizontal() ? slide.find('.swiper-slide-shadow-left') : slide.find('.swiper-slide-shadow-top');
                            var shadowAfter = s.isHorizontal() ? slide.find('.swiper-slide-shadow-right') : slide.find('.swiper-slide-shadow-bottom');
                            if (shadowBefore.length === 0) {
                                shadowBefore = $('<div class="swiper-slide-shadow-' + (s.isHorizontal() ? 'left' : 'top') + '"></div>');
                                slide.append(shadowBefore);
                            }
                            if (shadowAfter.length === 0) {
                                shadowAfter = $('<div class="swiper-slide-shadow-' + (s.isHorizontal() ? 'right' : 'bottom') + '"></div>');
                                slide.append(shadowAfter);
                            }
                            if (shadowBefore.length) shadowBefore[0].style.opacity = offsetMultiplier > 0 ? offsetMultiplier : 0;
                            if (shadowAfter.length) shadowAfter[0].style.opacity = -offsetMultiplier > 0 ? -offsetMultiplier : 0;
                        }
                    }

                    //Set correct perspective for IE10
                    if (s.browser.ie) {
                        var ws = s.wrapper[0].style;
                        ws.perspectiveOrigin = center + 'px 50%';
                    }
                },
                setTransition: function setTransition(duration) {
                    s.slides.transition(duration).find('.swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left').transition(duration);
                }
            }
        };

        /*=========================
          Images Lazy Loading
          ===========================*/
        s.lazy = {
            initialImageLoaded: false,
            loadImageInSlide: function loadImageInSlide(index, loadInDuplicate) {
                if (typeof index === 'undefined') return;
                if (typeof loadInDuplicate === 'undefined') loadInDuplicate = true;
                if (s.slides.length === 0) return;

                var slide = s.slides.eq(index);
                var img = slide.find('.' + s.params.lazyLoadingClass + ':not(.' + s.params.lazyStatusLoadedClass + '):not(.' + s.params.lazyStatusLoadingClass + ')');
                if (slide.hasClass(s.params.lazyLoadingClass) && !slide.hasClass(s.params.lazyStatusLoadedClass) && !slide.hasClass(s.params.lazyStatusLoadingClass)) {
                    img = img.add(slide[0]);
                }
                if (img.length === 0) return;

                img.each(function () {
                    var _img = $(this);
                    _img.addClass(s.params.lazyStatusLoadingClass);
                    var background = _img.attr('data-background');
                    var src = _img.attr('data-src'),
                        srcset = _img.attr('data-srcset'),
                        sizes = _img.attr('data-sizes');
                    s.loadImage(_img[0], src || background, srcset, sizes, false, function () {
                        if (typeof s === 'undefined' || s === null || !s) return;
                        if (background) {
                            _img.css('background-image', 'url("' + background + '")');
                            _img.removeAttr('data-background');
                        } else {
                            if (srcset) {
                                _img.attr('srcset', srcset);
                                _img.removeAttr('data-srcset');
                            }
                            if (sizes) {
                                _img.attr('sizes', sizes);
                                _img.removeAttr('data-sizes');
                            }
                            if (src) {
                                _img.attr('src', src);
                                _img.removeAttr('data-src');
                            }
                        }

                        _img.addClass(s.params.lazyStatusLoadedClass).removeClass(s.params.lazyStatusLoadingClass);
                        slide.find('.' + s.params.lazyPreloaderClass + ', .' + s.params.preloaderClass).remove();
                        if (s.params.loop && loadInDuplicate) {
                            var slideOriginalIndex = slide.attr('data-swiper-slide-index');
                            if (slide.hasClass(s.params.slideDuplicateClass)) {
                                var originalSlide = s.wrapper.children('[data-swiper-slide-index="' + slideOriginalIndex + '"]:not(.' + s.params.slideDuplicateClass + ')');
                                s.lazy.loadImageInSlide(originalSlide.index(), false);
                            } else {
                                var duplicatedSlide = s.wrapper.children('.' + s.params.slideDuplicateClass + '[data-swiper-slide-index="' + slideOriginalIndex + '"]');
                                s.lazy.loadImageInSlide(duplicatedSlide.index(), false);
                            }
                        }
                        s.emit('onLazyImageReady', s, slide[0], _img[0]);
                    });

                    s.emit('onLazyImageLoad', s, slide[0], _img[0]);
                });
            },
            load: function load() {
                var i;
                var slidesPerView = s.params.slidesPerView;
                if (slidesPerView === 'auto') {
                    slidesPerView = 0;
                }
                if (!s.lazy.initialImageLoaded) s.lazy.initialImageLoaded = true;
                if (s.params.watchSlidesVisibility) {
                    s.wrapper.children('.' + s.params.slideVisibleClass).each(function () {
                        s.lazy.loadImageInSlide($(this).index());
                    });
                } else {
                    if (slidesPerView > 1) {
                        for (i = s.activeIndex; i < s.activeIndex + slidesPerView; i++) {
                            if (s.slides[i]) s.lazy.loadImageInSlide(i);
                        }
                    } else {
                        s.lazy.loadImageInSlide(s.activeIndex);
                    }
                }
                if (s.params.lazyLoadingInPrevNext) {
                    if (slidesPerView > 1 || s.params.lazyLoadingInPrevNextAmount && s.params.lazyLoadingInPrevNextAmount > 1) {
                        var amount = s.params.lazyLoadingInPrevNextAmount;
                        var spv = slidesPerView;
                        var maxIndex = Math.min(s.activeIndex + spv + Math.max(amount, spv), s.slides.length);
                        var minIndex = Math.max(s.activeIndex - Math.max(spv, amount), 0);
                        // Next Slides
                        for (i = s.activeIndex + slidesPerView; i < maxIndex; i++) {
                            if (s.slides[i]) s.lazy.loadImageInSlide(i);
                        }
                        // Prev Slides
                        for (i = minIndex; i < s.activeIndex; i++) {
                            if (s.slides[i]) s.lazy.loadImageInSlide(i);
                        }
                    } else {
                        var nextSlide = s.wrapper.children('.' + s.params.slideNextClass);
                        if (nextSlide.length > 0) s.lazy.loadImageInSlide(nextSlide.index());

                        var prevSlide = s.wrapper.children('.' + s.params.slidePrevClass);
                        if (prevSlide.length > 0) s.lazy.loadImageInSlide(prevSlide.index());
                    }
                }
            },
            onTransitionStart: function onTransitionStart() {
                if (s.params.lazyLoading) {
                    if (s.params.lazyLoadingOnTransitionStart || !s.params.lazyLoadingOnTransitionStart && !s.lazy.initialImageLoaded) {
                        s.lazy.load();
                    }
                }
            },
            onTransitionEnd: function onTransitionEnd() {
                if (s.params.lazyLoading && !s.params.lazyLoadingOnTransitionStart) {
                    s.lazy.load();
                }
            }
        };

        /*=========================
          Scrollbar
          ===========================*/
        s.scrollbar = {
            isTouched: false,
            setDragPosition: function setDragPosition(e) {
                var sb = s.scrollbar;
                var x = 0,
                    y = 0;
                var translate;
                var pointerPosition = s.isHorizontal() ? e.type === 'touchstart' || e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX || e.clientX : e.type === 'touchstart' || e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY || e.clientY;
                var position = pointerPosition - sb.track.offset()[s.isHorizontal() ? 'left' : 'top'] - sb.dragSize / 2;
                var positionMin = -s.minTranslate() * sb.moveDivider;
                var positionMax = -s.maxTranslate() * sb.moveDivider;
                if (position < positionMin) {
                    position = positionMin;
                } else if (position > positionMax) {
                    position = positionMax;
                }
                position = -position / sb.moveDivider;
                s.updateProgress(position);
                s.setWrapperTranslate(position, true);
            },
            dragStart: function dragStart(e) {
                var sb = s.scrollbar;
                sb.isTouched = true;
                e.preventDefault();
                e.stopPropagation();

                sb.setDragPosition(e);
                clearTimeout(sb.dragTimeout);

                sb.track.transition(0);
                if (s.params.scrollbarHide) {
                    sb.track.css('opacity', 1);
                }
                s.wrapper.transition(100);
                sb.drag.transition(100);
                s.emit('onScrollbarDragStart', s);
            },
            dragMove: function dragMove(e) {
                var sb = s.scrollbar;
                if (!sb.isTouched) return;
                if (e.preventDefault) e.preventDefault();else e.returnValue = false;
                sb.setDragPosition(e);
                s.wrapper.transition(0);
                sb.track.transition(0);
                sb.drag.transition(0);
                s.emit('onScrollbarDragMove', s);
            },
            dragEnd: function dragEnd(e) {
                var sb = s.scrollbar;
                if (!sb.isTouched) return;
                sb.isTouched = false;
                if (s.params.scrollbarHide) {
                    clearTimeout(sb.dragTimeout);
                    sb.dragTimeout = setTimeout(function () {
                        sb.track.css('opacity', 0);
                        sb.track.transition(400);
                    }, 1000);
                }
                s.emit('onScrollbarDragEnd', s);
                if (s.params.scrollbarSnapOnRelease) {
                    s.slideReset();
                }
            },
            draggableEvents: function () {
                if (s.params.simulateTouch === false && !s.support.touch) return s.touchEventsDesktop;else return s.touchEvents;
            }(),
            enableDraggable: function enableDraggable() {
                var sb = s.scrollbar;
                var target = s.support.touch ? sb.track : document;
                $(sb.track).on(sb.draggableEvents.start, sb.dragStart);
                $(target).on(sb.draggableEvents.move, sb.dragMove);
                $(target).on(sb.draggableEvents.end, sb.dragEnd);
            },
            disableDraggable: function disableDraggable() {
                var sb = s.scrollbar;
                var target = s.support.touch ? sb.track : document;
                $(sb.track).off(sb.draggableEvents.start, sb.dragStart);
                $(target).off(sb.draggableEvents.move, sb.dragMove);
                $(target).off(sb.draggableEvents.end, sb.dragEnd);
            },
            set: function set() {
                if (!s.params.scrollbar) return;
                var sb = s.scrollbar;
                sb.track = $(s.params.scrollbar);
                if (s.params.uniqueNavElements && typeof s.params.scrollbar === 'string' && sb.track.length > 1 && s.container.find(s.params.scrollbar).length === 1) {
                    sb.track = s.container.find(s.params.scrollbar);
                }
                sb.drag = sb.track.find('.swiper-scrollbar-drag');
                if (sb.drag.length === 0) {
                    sb.drag = $('<div class="swiper-scrollbar-drag"></div>');
                    sb.track.append(sb.drag);
                }
                sb.drag[0].style.width = '';
                sb.drag[0].style.height = '';
                sb.trackSize = s.isHorizontal() ? sb.track[0].offsetWidth : sb.track[0].offsetHeight;

                sb.divider = s.size / s.virtualSize;
                sb.moveDivider = sb.divider * (sb.trackSize / s.size);
                sb.dragSize = sb.trackSize * sb.divider;

                if (s.isHorizontal()) {
                    sb.drag[0].style.width = sb.dragSize + 'px';
                } else {
                    sb.drag[0].style.height = sb.dragSize + 'px';
                }

                if (sb.divider >= 1) {
                    sb.track[0].style.display = 'none';
                } else {
                    sb.track[0].style.display = '';
                }
                if (s.params.scrollbarHide) {
                    sb.track[0].style.opacity = 0;
                }
            },
            setTranslate: function setTranslate() {
                if (!s.params.scrollbar) return;
                var diff;
                var sb = s.scrollbar;
                var translate = s.translate || 0;
                var newPos;

                var newSize = sb.dragSize;
                newPos = (sb.trackSize - sb.dragSize) * s.progress;
                if (s.rtl && s.isHorizontal()) {
                    newPos = -newPos;
                    if (newPos > 0) {
                        newSize = sb.dragSize - newPos;
                        newPos = 0;
                    } else if (-newPos + sb.dragSize > sb.trackSize) {
                        newSize = sb.trackSize + newPos;
                    }
                } else {
                    if (newPos < 0) {
                        newSize = sb.dragSize + newPos;
                        newPos = 0;
                    } else if (newPos + sb.dragSize > sb.trackSize) {
                        newSize = sb.trackSize - newPos;
                    }
                }
                if (s.isHorizontal()) {
                    if (s.support.transforms3d) {
                        sb.drag.transform('translate3d(' + newPos + 'px, 0, 0)');
                    } else {
                        sb.drag.transform('translateX(' + newPos + 'px)');
                    }
                    sb.drag[0].style.width = newSize + 'px';
                } else {
                    if (s.support.transforms3d) {
                        sb.drag.transform('translate3d(0px, ' + newPos + 'px, 0)');
                    } else {
                        sb.drag.transform('translateY(' + newPos + 'px)');
                    }
                    sb.drag[0].style.height = newSize + 'px';
                }
                if (s.params.scrollbarHide) {
                    clearTimeout(sb.timeout);
                    sb.track[0].style.opacity = 1;
                    sb.timeout = setTimeout(function () {
                        sb.track[0].style.opacity = 0;
                        sb.track.transition(400);
                    }, 1000);
                }
            },
            setTransition: function setTransition(duration) {
                if (!s.params.scrollbar) return;
                s.scrollbar.drag.transition(duration);
            }
        };

        /*=========================
          Controller
          ===========================*/
        s.controller = {
            LinearSpline: function LinearSpline(x, y) {
                var binarySearch = function () {
                    var maxIndex, minIndex, guess;
                    return function (array, val) {
                        minIndex = -1;
                        maxIndex = array.length;
                        while (maxIndex - minIndex > 1) {
                            if (array[guess = maxIndex + minIndex >> 1] <= val) {
                                minIndex = guess;
                            } else {
                                maxIndex = guess;
                            }
                        }return maxIndex;
                    };
                }();
                this.x = x;
                this.y = y;
                this.lastIndex = x.length - 1;
                // Given an x value (x2), return the expected y2 value:
                // (x1,y1) is the known point before given value,
                // (x3,y3) is the known point after given value.
                var i1, i3;
                var l = this.x.length;

                this.interpolate = function (x2) {
                    if (!x2) return 0;

                    // Get the indexes of x1 and x3 (the array indexes before and after given x2):
                    i3 = binarySearch(this.x, x2);
                    i1 = i3 - 1;

                    // We have our indexes i1 & i3, so we can calculate already:
                    // y2 := ((x2−x1) × (y3−y1)) ÷ (x3−x1) + y1
                    return (x2 - this.x[i1]) * (this.y[i3] - this.y[i1]) / (this.x[i3] - this.x[i1]) + this.y[i1];
                };
            },
            //xxx: for now i will just save one spline function to to
            getInterpolateFunction: function getInterpolateFunction(c) {
                if (!s.controller.spline) s.controller.spline = s.params.loop ? new s.controller.LinearSpline(s.slidesGrid, c.slidesGrid) : new s.controller.LinearSpline(s.snapGrid, c.snapGrid);
            },
            setTranslate: function setTranslate(translate, byController) {
                var controlled = s.params.control;
                var multiplier, controlledTranslate;
                function setControlledTranslate(c) {
                    // this will create an Interpolate function based on the snapGrids
                    // x is the Grid of the scrolled scroller and y will be the controlled scroller
                    // it makes sense to create this only once and recall it for the interpolation
                    // the function does a lot of value caching for performance
                    translate = c.rtl && c.params.direction === 'horizontal' ? -s.translate : s.translate;
                    if (s.params.controlBy === 'slide') {
                        s.controller.getInterpolateFunction(c);
                        // i am not sure why the values have to be multiplicated this way, tried to invert the snapGrid
                        // but it did not work out
                        controlledTranslate = -s.controller.spline.interpolate(-translate);
                    }

                    if (!controlledTranslate || s.params.controlBy === 'container') {
                        multiplier = (c.maxTranslate() - c.minTranslate()) / (s.maxTranslate() - s.minTranslate());
                        controlledTranslate = (translate - s.minTranslate()) * multiplier + c.minTranslate();
                    }

                    if (s.params.controlInverse) {
                        controlledTranslate = c.maxTranslate() - controlledTranslate;
                    }
                    c.updateProgress(controlledTranslate);
                    c.setWrapperTranslate(controlledTranslate, false, s);
                    c.updateActiveIndex();
                }
                if (Array.isArray(controlled)) {
                    for (var i = 0; i < controlled.length; i++) {
                        if (controlled[i] !== byController && controlled[i] instanceof Swiper) {
                            setControlledTranslate(controlled[i]);
                        }
                    }
                } else if (controlled instanceof Swiper && byController !== controlled) {

                    setControlledTranslate(controlled);
                }
            },
            setTransition: function setTransition(duration, byController) {
                var controlled = s.params.control;
                var i;
                function setControlledTransition(c) {
                    c.setWrapperTransition(duration, s);
                    if (duration !== 0) {
                        c.onTransitionStart();
                        c.wrapper.transitionEnd(function () {
                            if (!controlled) return;
                            if (c.params.loop && s.params.controlBy === 'slide') {
                                c.fixLoop();
                            }
                            c.onTransitionEnd();
                        });
                    }
                }
                if (Array.isArray(controlled)) {
                    for (i = 0; i < controlled.length; i++) {
                        if (controlled[i] !== byController && controlled[i] instanceof Swiper) {
                            setControlledTransition(controlled[i]);
                        }
                    }
                } else if (controlled instanceof Swiper && byController !== controlled) {
                    setControlledTransition(controlled);
                }
            }
        };

        /*=========================
          Hash Navigation
          ===========================*/
        s.hashnav = {
            onHashCange: function onHashCange(e, a) {
                var newHash = document.location.hash.replace('#', '');
                var activeSlideHash = s.slides.eq(s.activeIndex).attr('data-hash');
                if (newHash !== activeSlideHash) {
                    s.slideTo(s.wrapper.children('.' + s.params.slideClass + '[data-hash="' + newHash + '"]').index());
                }
            },
            attachEvents: function attachEvents(detach) {
                var action = detach ? 'off' : 'on';
                $(window)[action]('hashchange', s.hashnav.onHashCange);
            },
            setHash: function setHash() {
                if (!s.hashnav.initialized || !s.params.hashnav) return;
                if (s.params.replaceState && window.history && window.history.replaceState) {
                    window.history.replaceState(null, null, '#' + s.slides.eq(s.activeIndex).attr('data-hash') || '');
                } else {
                    var slide = s.slides.eq(s.activeIndex);
                    var hash = slide.attr('data-hash') || slide.attr('data-history');
                    document.location.hash = hash || '';
                }
            },
            init: function init() {
                if (!s.params.hashnav || s.params.history) return;
                s.hashnav.initialized = true;
                var hash = document.location.hash.replace('#', '');
                if (hash) {
                    var speed = 0;
                    for (var i = 0, length = s.slides.length; i < length; i++) {
                        var slide = s.slides.eq(i);
                        var slideHash = slide.attr('data-hash') || slide.attr('data-history');
                        if (slideHash === hash && !slide.hasClass(s.params.slideDuplicateClass)) {
                            var index = slide.index();
                            s.slideTo(index, speed, s.params.runCallbacksOnInit, true);
                        }
                    }
                }
                if (s.params.hashnavWatchState) s.hashnav.attachEvents();
            },
            destroy: function destroy() {
                if (s.params.hashnavWatchState) s.hashnav.attachEvents(true);
            }
        };

        /*=========================
          History Api with fallback to Hashnav
          ===========================*/
        s.history = {
            init: function init() {
                if (!s.params.history) return;
                if (!window.history || !window.history.pushState) {
                    s.params.history = false;
                    s.params.hashnav = true;
                    return;
                }
                s.history.initialized = true;
                this.paths = this.getPathValues();
                if (!this.paths.key && !this.paths.value) return;
                this.scrollToSlide(0, this.paths.value, s.params.runCallbacksOnInit);
                if (!s.params.replaceState) {
                    window.addEventListener('popstate', this.setHistoryPopState);
                }
            },
            setHistoryPopState: function setHistoryPopState() {
                s.history.paths = s.history.getPathValues();
                s.history.scrollToSlide(s.params.speed, s.history.paths.value, false);
            },
            getPathValues: function getPathValues() {
                var pathArray = window.location.pathname.slice(1).split('/');
                var total = pathArray.length;
                var key = pathArray[total - 2];
                var value = pathArray[total - 1];
                return { key: key, value: value };
            },
            setHistory: function setHistory(key, index) {
                if (!s.history.initialized || !s.params.history) return;
                var slide = s.slides.eq(index);
                var value = this.slugify(slide.attr('data-history'));
                if (!window.location.pathname.includes(key)) {
                    value = key + '/' + value;
                }
                if (s.params.replaceState) {
                    window.history.replaceState(null, null, value);
                } else {
                    window.history.pushState(null, null, value);
                }
            },
            slugify: function slugify(text) {
                return text.toString().toLowerCase().replace(/\s+/g, '-').replace(/[^\w\-]+/g, '').replace(/\-\-+/g, '-').replace(/^-+/, '').replace(/-+$/, '');
            },
            scrollToSlide: function scrollToSlide(speed, value, runCallbacks) {
                if (value) {
                    for (var i = 0, length = s.slides.length; i < length; i++) {
                        var slide = s.slides.eq(i);
                        var slideHistory = this.slugify(slide.attr('data-history'));
                        if (slideHistory === value && !slide.hasClass(s.params.slideDuplicateClass)) {
                            var index = slide.index();
                            s.slideTo(index, speed, runCallbacks);
                        }
                    }
                } else {
                    s.slideTo(0, speed, runCallbacks);
                }
            }
        };

        /*=========================
          Keyboard Control
          ===========================*/
        function handleKeyboard(e) {
            if (e.originalEvent) e = e.originalEvent; //jquery fix
            var kc = e.keyCode || e.charCode;
            // Directions locks
            if (!s.params.allowSwipeToNext && (s.isHorizontal() && kc === 39 || !s.isHorizontal() && kc === 40)) {
                return false;
            }
            if (!s.params.allowSwipeToPrev && (s.isHorizontal() && kc === 37 || !s.isHorizontal() && kc === 38)) {
                return false;
            }
            if (e.shiftKey || e.altKey || e.ctrlKey || e.metaKey) {
                return;
            }
            if (document.activeElement && document.activeElement.nodeName && (document.activeElement.nodeName.toLowerCase() === 'input' || document.activeElement.nodeName.toLowerCase() === 'textarea')) {
                return;
            }
            if (kc === 37 || kc === 39 || kc === 38 || kc === 40) {
                var inView = false;
                //Check that swiper should be inside of visible area of window
                if (s.container.parents('.' + s.params.slideClass).length > 0 && s.container.parents('.' + s.params.slideActiveClass).length === 0) {
                    return;
                }
                var windowScroll = {
                    left: window.pageXOffset,
                    top: window.pageYOffset
                };
                var windowWidth = window.innerWidth;
                var windowHeight = window.innerHeight;
                var swiperOffset = s.container.offset();
                if (s.rtl) swiperOffset.left = swiperOffset.left - s.container[0].scrollLeft;
                var swiperCoord = [[swiperOffset.left, swiperOffset.top], [swiperOffset.left + s.width, swiperOffset.top], [swiperOffset.left, swiperOffset.top + s.height], [swiperOffset.left + s.width, swiperOffset.top + s.height]];
                for (var i = 0; i < swiperCoord.length; i++) {
                    var point = swiperCoord[i];
                    if (point[0] >= windowScroll.left && point[0] <= windowScroll.left + windowWidth && point[1] >= windowScroll.top && point[1] <= windowScroll.top + windowHeight) {
                        inView = true;
                    }
                }
                if (!inView) return;
            }
            if (s.isHorizontal()) {
                if (kc === 37 || kc === 39) {
                    if (e.preventDefault) e.preventDefault();else e.returnValue = false;
                }
                if (kc === 39 && !s.rtl || kc === 37 && s.rtl) s.slideNext();
                if (kc === 37 && !s.rtl || kc === 39 && s.rtl) s.slidePrev();
            } else {
                if (kc === 38 || kc === 40) {
                    if (e.preventDefault) e.preventDefault();else e.returnValue = false;
                }
                if (kc === 40) s.slideNext();
                if (kc === 38) s.slidePrev();
            }
            s.emit('onKeyPress', s, kc);
        }
        s.disableKeyboardControl = function () {
            s.params.keyboardControl = false;
            $(document).off('keydown', handleKeyboard);
        };
        s.enableKeyboardControl = function () {
            s.params.keyboardControl = true;
            $(document).on('keydown', handleKeyboard);
        };

        /*=========================
          Mousewheel Control
          ===========================*/
        s.mousewheel = {
            event: false,
            lastScrollTime: new window.Date().getTime()
        };
        function isEventSupported() {
            var eventName = 'onwheel';
            var isSupported = eventName in document;

            if (!isSupported) {
                var element = document.createElement('div');
                element.setAttribute(eventName, 'return;');
                isSupported = typeof element[eventName] === 'function';
            }

            if (!isSupported && document.implementation && document.implementation.hasFeature &&
            // always returns true in newer browsers as per the standard.
            // @see http://dom.spec.whatwg.org/#dom-domimplementation-hasfeature
            document.implementation.hasFeature('', '') !== true) {
                // This is the only way to test support for the `wheel` event in IE9+.
                isSupported = document.implementation.hasFeature('Events.wheel', '3.0');
            }

            return isSupported;
        }
        /**
         * Mouse wheel (and 2-finger trackpad) support on the web sucks.  It is
         * complicated, thus this doc is long and (hopefully) detailed enough to answer
         * your questions.
         *
         * If you need to react to the mouse wheel in a predictable way, this code is
         * like your bestest friend. * hugs *
         *
         * As of today, there are 4 DOM event types you can listen to:
         *
         *   'wheel'                -- Chrome(31+), FF(17+), IE(9+)
         *   'mousewheel'           -- Chrome, IE(6+), Opera, Safari
         *   'MozMousePixelScroll'  -- FF(3.5 only!) (2010-2013) -- don't bother!
         *   'DOMMouseScroll'       -- FF(0.9.7+) since 2003
         *
         * So what to do?  The is the best:
         *
         *   normalizeWheel.getEventType();
         *
         * In your event callback, use this code to get sane interpretation of the
         * deltas.  This code will return an object with properties:
         *
         *   spinX   -- normalized spin speed (use for zoom) - x plane
         *   spinY   -- " - y plane
         *   pixelX  -- normalized distance (to pixels) - x plane
         *   pixelY  -- " - y plane
         *
         * Wheel values are provided by the browser assuming you are using the wheel to
         * scroll a web page by a number of lines or pixels (or pages).  Values can vary
         * significantly on different platforms and browsers, forgetting that you can
         * scroll at different speeds.  Some devices (like trackpads) emit more events
         * at smaller increments with fine granularity, and some emit massive jumps with
         * linear speed or acceleration.
         *
         * This code does its best to normalize the deltas for you:
         *
         *   - spin is trying to normalize how far the wheel was spun (or trackpad
         *     dragged).  This is super useful for zoom support where you want to
         *     throw away the chunky scroll steps on the PC and make those equal to
         *     the slow and smooth tiny steps on the Mac. Key data: This code tries to
         *     resolve a single slow step on a wheel to 1.
         *
         *   - pixel is normalizing the desired scroll delta in pixel units.  You'll
         *     get the crazy differences between browsers, but at least it'll be in
         *     pixels!
         *
         *   - positive value indicates scrolling DOWN/RIGHT, negative UP/LEFT.  This
         *     should translate to positive value zooming IN, negative zooming OUT.
         *     This matches the newer 'wheel' event.
         *
         * Why are there spinX, spinY (or pixels)?
         *
         *   - spinX is a 2-finger side drag on the trackpad, and a shift + wheel turn
         *     with a mouse.  It results in side-scrolling in the browser by default.
         *
         *   - spinY is what you expect -- it's the classic axis of a mouse wheel.
         *
         *   - I dropped spinZ/pixelZ.  It is supported by the DOM 3 'wheel' event and
         *     probably is by browsers in conjunction with fancy 3D controllers .. but
         *     you know.
         *
         * Implementation info:
         *
         * Examples of 'wheel' event if you scroll slowly (down) by one step with an
         * average mouse:
         *
         *   OS X + Chrome  (mouse)     -    4   pixel delta  (wheelDelta -120)
         *   OS X + Safari  (mouse)     -  N/A   pixel delta  (wheelDelta  -12)
         *   OS X + Firefox (mouse)     -    0.1 line  delta  (wheelDelta  N/A)
         *   Win8 + Chrome  (mouse)     -  100   pixel delta  (wheelDelta -120)
         *   Win8 + Firefox (mouse)     -    3   line  delta  (wheelDelta -120)
         *
         * On the trackpad:
         *
         *   OS X + Chrome  (trackpad)  -    2   pixel delta  (wheelDelta   -6)
         *   OS X + Firefox (trackpad)  -    1   pixel delta  (wheelDelta  N/A)
         *
         * On other/older browsers.. it's more complicated as there can be multiple and
         * also missing delta values.
         *
         * The 'wheel' event is more standard:
         *
         * http://www.w3.org/TR/DOM-Level-3-Events/#events-wheelevents
         *
         * The basics is that it includes a unit, deltaMode (pixels, lines, pages), and
         * deltaX, deltaY and deltaZ.  Some browsers provide other values to maintain
         * backward compatibility with older events.  Those other values help us
         * better normalize spin speed.  Example of what the browsers provide:
         *
         *                          | event.wheelDelta | event.detail
         *        ------------------+------------------+--------------
         *          Safari v5/OS X  |       -120       |       0
         *          Safari v5/Win7  |       -120       |       0
         *         Chrome v17/OS X  |       -120       |       0
         *         Chrome v17/Win7  |       -120       |       0
         *                IE9/Win7  |       -120       |   undefined
         *         Firefox v4/OS X  |     undefined    |       1
         *         Firefox v4/Win7  |     undefined    |       3
         *
         */
        function normalizeWheel( /*object*/event) /*object*/{
            // Reasonable defaults
            var PIXEL_STEP = 10;
            var LINE_HEIGHT = 40;
            var PAGE_HEIGHT = 800;

            var sX = 0,
                sY = 0,
                // spinX, spinY
            pX = 0,
                pY = 0; // pixelX, pixelY

            // Legacy
            if ('detail' in event) {
                sY = event.detail;
            }
            if ('wheelDelta' in event) {
                sY = -event.wheelDelta / 120;
            }
            if ('wheelDeltaY' in event) {
                sY = -event.wheelDeltaY / 120;
            }
            if ('wheelDeltaX' in event) {
                sX = -event.wheelDeltaX / 120;
            }

            // side scrolling on FF with DOMMouseScroll
            if ('axis' in event && event.axis === event.HORIZONTAL_AXIS) {
                sX = sY;
                sY = 0;
            }

            pX = sX * PIXEL_STEP;
            pY = sY * PIXEL_STEP;

            if ('deltaY' in event) {
                pY = event.deltaY;
            }
            if ('deltaX' in event) {
                pX = event.deltaX;
            }

            if ((pX || pY) && event.deltaMode) {
                if (event.deltaMode === 1) {
                    // delta in LINE units
                    pX *= LINE_HEIGHT;
                    pY *= LINE_HEIGHT;
                } else {
                    // delta in PAGE units
                    pX *= PAGE_HEIGHT;
                    pY *= PAGE_HEIGHT;
                }
            }

            // Fall-back if spin cannot be determined
            if (pX && !sX) {
                sX = pX < 1 ? -1 : 1;
            }
            if (pY && !sY) {
                sY = pY < 1 ? -1 : 1;
            }

            return {
                spinX: sX,
                spinY: sY,
                pixelX: pX,
                pixelY: pY
            };
        }
        if (s.params.mousewheelControl) {
            /**
             * The best combination if you prefer spinX + spinY normalization.  It favors
             * the older DOMMouseScroll for Firefox, as FF does not include wheelDelta with
             * 'wheel' event, making spin speed determination impossible.
             */
            s.mousewheel.event = navigator.userAgent.indexOf('firefox') > -1 ? 'DOMMouseScroll' : isEventSupported() ? 'wheel' : 'mousewheel';
        }
        function handleMousewheel(e) {
            if (e.originalEvent) e = e.originalEvent; //jquery fix
            var delta = 0;
            var rtlFactor = s.rtl ? -1 : 1;

            var data = normalizeWheel(e);

            if (s.params.mousewheelForceToAxis) {
                if (s.isHorizontal()) {
                    if (Math.abs(data.pixelX) > Math.abs(data.pixelY)) delta = data.pixelX * rtlFactor;else return;
                } else {
                    if (Math.abs(data.pixelY) > Math.abs(data.pixelX)) delta = data.pixelY;else return;
                }
            } else {
                delta = Math.abs(data.pixelX) > Math.abs(data.pixelY) ? -data.pixelX * rtlFactor : -data.pixelY;
            }

            if (delta === 0) return;

            if (s.params.mousewheelInvert) delta = -delta;

            if (!s.params.freeMode) {
                if (new window.Date().getTime() - s.mousewheel.lastScrollTime > 60) {
                    if (delta < 0) {
                        if ((!s.isEnd || s.params.loop) && !s.animating) {
                            s.slideNext();
                            s.emit('onScroll', s, e);
                        } else if (s.params.mousewheelReleaseOnEdges) return true;
                    } else {
                        if ((!s.isBeginning || s.params.loop) && !s.animating) {
                            s.slidePrev();
                            s.emit('onScroll', s, e);
                        } else if (s.params.mousewheelReleaseOnEdges) return true;
                    }
                }
                s.mousewheel.lastScrollTime = new window.Date().getTime();
            } else {
                //Freemode or scrollContainer:
                var position = s.getWrapperTranslate() + delta * s.params.mousewheelSensitivity;
                var wasBeginning = s.isBeginning,
                    wasEnd = s.isEnd;

                if (position >= s.minTranslate()) position = s.minTranslate();
                if (position <= s.maxTranslate()) position = s.maxTranslate();

                s.setWrapperTransition(0);
                s.setWrapperTranslate(position);
                s.updateProgress();
                s.updateActiveIndex();

                if (!wasBeginning && s.isBeginning || !wasEnd && s.isEnd) {
                    s.updateClasses();
                }

                if (s.params.freeModeSticky) {
                    clearTimeout(s.mousewheel.timeout);
                    s.mousewheel.timeout = setTimeout(function () {
                        s.slideReset();
                    }, 300);
                } else {
                    if (s.params.lazyLoading && s.lazy) {
                        s.lazy.load();
                    }
                }
                // Emit event
                s.emit('onScroll', s, e);

                // Stop autoplay
                if (s.params.autoplay && s.params.autoplayDisableOnInteraction) s.stopAutoplay();

                // Return page scroll on edge positions
                if (position === 0 || position === s.maxTranslate()) return;
            }

            if (e.preventDefault) e.preventDefault();else e.returnValue = false;
            return false;
        }
        s.disableMousewheelControl = function () {
            if (!s.mousewheel.event) return false;
            var target = s.container;
            if (s.params.mousewheelEventsTarged !== 'container') {
                target = $(s.params.mousewheelEventsTarged);
            }
            target.off(s.mousewheel.event, handleMousewheel);
            s.params.mousewheelControl = false;
            return true;
        };

        s.enableMousewheelControl = function () {
            if (!s.mousewheel.event) return false;
            var target = s.container;
            if (s.params.mousewheelEventsTarged !== 'container') {
                target = $(s.params.mousewheelEventsTarged);
            }
            target.on(s.mousewheel.event, handleMousewheel);
            s.params.mousewheelControl = true;
            return true;
        };

        /*=========================
          Parallax
          ===========================*/
        function setParallaxTransform(el, progress) {
            el = $(el);
            var p, pX, pY;
            var rtlFactor = s.rtl ? -1 : 1;

            p = el.attr('data-swiper-parallax') || '0';
            pX = el.attr('data-swiper-parallax-x');
            pY = el.attr('data-swiper-parallax-y');
            if (pX || pY) {
                pX = pX || '0';
                pY = pY || '0';
            } else {
                if (s.isHorizontal()) {
                    pX = p;
                    pY = '0';
                } else {
                    pY = p;
                    pX = '0';
                }
            }

            if (pX.indexOf('%') >= 0) {
                pX = parseInt(pX, 10) * progress * rtlFactor + '%';
            } else {
                pX = pX * progress * rtlFactor + 'px';
            }
            if (pY.indexOf('%') >= 0) {
                pY = parseInt(pY, 10) * progress + '%';
            } else {
                pY = pY * progress + 'px';
            }

            el.transform('translate3d(' + pX + ', ' + pY + ',0px)');
        }
        s.parallax = {
            setTranslate: function setTranslate() {
                s.container.children('[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y]').each(function () {
                    setParallaxTransform(this, s.progress);
                });
                s.slides.each(function () {
                    var slide = $(this);
                    slide.find('[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y]').each(function () {
                        var progress = Math.min(Math.max(slide[0].progress, -1), 1);
                        setParallaxTransform(this, progress);
                    });
                });
            },
            setTransition: function setTransition(duration) {
                if (typeof duration === 'undefined') duration = s.params.speed;
                s.container.find('[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y]').each(function () {
                    var el = $(this);
                    var parallaxDuration = parseInt(el.attr('data-swiper-parallax-duration'), 10) || duration;
                    if (duration === 0) parallaxDuration = 0;
                    el.transition(parallaxDuration);
                });
            }
        };

        /*=========================
          Zoom
          ===========================*/
        s.zoom = {
            // "Global" Props
            scale: 1,
            currentScale: 1,
            isScaling: false,
            gesture: {
                slide: undefined,
                slideWidth: undefined,
                slideHeight: undefined,
                image: undefined,
                imageWrap: undefined,
                zoomMax: s.params.zoomMax
            },
            image: {
                isTouched: undefined,
                isMoved: undefined,
                currentX: undefined,
                currentY: undefined,
                minX: undefined,
                minY: undefined,
                maxX: undefined,
                maxY: undefined,
                width: undefined,
                height: undefined,
                startX: undefined,
                startY: undefined,
                touchesStart: {},
                touchesCurrent: {}
            },
            velocity: {
                x: undefined,
                y: undefined,
                prevPositionX: undefined,
                prevPositionY: undefined,
                prevTime: undefined
            },
            // Calc Scale From Multi-touches
            getDistanceBetweenTouches: function getDistanceBetweenTouches(e) {
                if (e.targetTouches.length < 2) return 1;
                var x1 = e.targetTouches[0].pageX,
                    y1 = e.targetTouches[0].pageY,
                    x2 = e.targetTouches[1].pageX,
                    y2 = e.targetTouches[1].pageY;
                var distance = Math.sqrt(Math.pow(x2 - x1, 2) + Math.pow(y2 - y1, 2));
                return distance;
            },
            // Events
            onGestureStart: function onGestureStart(e) {
                var z = s.zoom;
                if (!s.support.gestures) {
                    if (e.type !== 'touchstart' || e.type === 'touchstart' && e.targetTouches.length < 2) {
                        return;
                    }
                    z.gesture.scaleStart = z.getDistanceBetweenTouches(e);
                }
                if (!z.gesture.slide || !z.gesture.slide.length) {
                    z.gesture.slide = $(this);
                    if (z.gesture.slide.length === 0) z.gesture.slide = s.slides.eq(s.activeIndex);
                    z.gesture.image = z.gesture.slide.find('img, svg, canvas');
                    z.gesture.imageWrap = z.gesture.image.parent('.' + s.params.zoomContainerClass);
                    z.gesture.zoomMax = z.gesture.imageWrap.attr('data-swiper-zoom') || s.params.zoomMax;
                    if (z.gesture.imageWrap.length === 0) {
                        z.gesture.image = undefined;
                        return;
                    }
                }
                z.gesture.image.transition(0);
                z.isScaling = true;
            },
            onGestureChange: function onGestureChange(e) {
                var z = s.zoom;
                if (!s.support.gestures) {
                    if (e.type !== 'touchmove' || e.type === 'touchmove' && e.targetTouches.length < 2) {
                        return;
                    }
                    z.gesture.scaleMove = z.getDistanceBetweenTouches(e);
                }
                if (!z.gesture.image || z.gesture.image.length === 0) return;
                if (s.support.gestures) {
                    z.scale = e.scale * z.currentScale;
                } else {
                    z.scale = z.gesture.scaleMove / z.gesture.scaleStart * z.currentScale;
                }
                if (z.scale > z.gesture.zoomMax) {
                    z.scale = z.gesture.zoomMax - 1 + Math.pow(z.scale - z.gesture.zoomMax + 1, 0.5);
                }
                if (z.scale < s.params.zoomMin) {
                    z.scale = s.params.zoomMin + 1 - Math.pow(s.params.zoomMin - z.scale + 1, 0.5);
                }
                z.gesture.image.transform('translate3d(0,0,0) scale(' + z.scale + ')');
            },
            onGestureEnd: function onGestureEnd(e) {
                var z = s.zoom;
                if (!s.support.gestures) {
                    if (e.type !== 'touchend' || e.type === 'touchend' && e.changedTouches.length < 2) {
                        return;
                    }
                }
                if (!z.gesture.image || z.gesture.image.length === 0) return;
                z.scale = Math.max(Math.min(z.scale, z.gesture.zoomMax), s.params.zoomMin);
                z.gesture.image.transition(s.params.speed).transform('translate3d(0,0,0) scale(' + z.scale + ')');
                z.currentScale = z.scale;
                z.isScaling = false;
                if (z.scale === 1) z.gesture.slide = undefined;
            },
            onTouchStart: function onTouchStart(s, e) {
                var z = s.zoom;
                if (!z.gesture.image || z.gesture.image.length === 0) return;
                if (z.image.isTouched) return;
                if (s.device.os === 'android') e.preventDefault();
                z.image.isTouched = true;
                z.image.touchesStart.x = e.type === 'touchstart' ? e.targetTouches[0].pageX : e.pageX;
                z.image.touchesStart.y = e.type === 'touchstart' ? e.targetTouches[0].pageY : e.pageY;
            },
            onTouchMove: function onTouchMove(e) {
                var z = s.zoom;
                if (!z.gesture.image || z.gesture.image.length === 0) return;
                s.allowClick = false;
                if (!z.image.isTouched || !z.gesture.slide) return;

                if (!z.image.isMoved) {
                    z.image.width = z.gesture.image[0].offsetWidth;
                    z.image.height = z.gesture.image[0].offsetHeight;
                    z.image.startX = s.getTranslate(z.gesture.imageWrap[0], 'x') || 0;
                    z.image.startY = s.getTranslate(z.gesture.imageWrap[0], 'y') || 0;
                    z.gesture.slideWidth = z.gesture.slide[0].offsetWidth;
                    z.gesture.slideHeight = z.gesture.slide[0].offsetHeight;
                    z.gesture.imageWrap.transition(0);
                    if (s.rtl) z.image.startX = -z.image.startX;
                    if (s.rtl) z.image.startY = -z.image.startY;
                }
                // Define if we need image drag
                var scaledWidth = z.image.width * z.scale;
                var scaledHeight = z.image.height * z.scale;

                if (scaledWidth < z.gesture.slideWidth && scaledHeight < z.gesture.slideHeight) return;

                z.image.minX = Math.min(z.gesture.slideWidth / 2 - scaledWidth / 2, 0);
                z.image.maxX = -z.image.minX;
                z.image.minY = Math.min(z.gesture.slideHeight / 2 - scaledHeight / 2, 0);
                z.image.maxY = -z.image.minY;

                z.image.touchesCurrent.x = e.type === 'touchmove' ? e.targetTouches[0].pageX : e.pageX;
                z.image.touchesCurrent.y = e.type === 'touchmove' ? e.targetTouches[0].pageY : e.pageY;

                if (!z.image.isMoved && !z.isScaling) {
                    if (s.isHorizontal() && Math.floor(z.image.minX) === Math.floor(z.image.startX) && z.image.touchesCurrent.x < z.image.touchesStart.x || Math.floor(z.image.maxX) === Math.floor(z.image.startX) && z.image.touchesCurrent.x > z.image.touchesStart.x) {
                        z.image.isTouched = false;
                        return;
                    } else if (!s.isHorizontal() && Math.floor(z.image.minY) === Math.floor(z.image.startY) && z.image.touchesCurrent.y < z.image.touchesStart.y || Math.floor(z.image.maxY) === Math.floor(z.image.startY) && z.image.touchesCurrent.y > z.image.touchesStart.y) {
                        z.image.isTouched = false;
                        return;
                    }
                }
                e.preventDefault();
                e.stopPropagation();

                z.image.isMoved = true;
                z.image.currentX = z.image.touchesCurrent.x - z.image.touchesStart.x + z.image.startX;
                z.image.currentY = z.image.touchesCurrent.y - z.image.touchesStart.y + z.image.startY;

                if (z.image.currentX < z.image.minX) {
                    z.image.currentX = z.image.minX + 1 - Math.pow(z.image.minX - z.image.currentX + 1, 0.8);
                }
                if (z.image.currentX > z.image.maxX) {
                    z.image.currentX = z.image.maxX - 1 + Math.pow(z.image.currentX - z.image.maxX + 1, 0.8);
                }

                if (z.image.currentY < z.image.minY) {
                    z.image.currentY = z.image.minY + 1 - Math.pow(z.image.minY - z.image.currentY + 1, 0.8);
                }
                if (z.image.currentY > z.image.maxY) {
                    z.image.currentY = z.image.maxY - 1 + Math.pow(z.image.currentY - z.image.maxY + 1, 0.8);
                }

                //Velocity
                if (!z.velocity.prevPositionX) z.velocity.prevPositionX = z.image.touchesCurrent.x;
                if (!z.velocity.prevPositionY) z.velocity.prevPositionY = z.image.touchesCurrent.y;
                if (!z.velocity.prevTime) z.velocity.prevTime = Date.now();
                z.velocity.x = (z.image.touchesCurrent.x - z.velocity.prevPositionX) / (Date.now() - z.velocity.prevTime) / 2;
                z.velocity.y = (z.image.touchesCurrent.y - z.velocity.prevPositionY) / (Date.now() - z.velocity.prevTime) / 2;
                if (Math.abs(z.image.touchesCurrent.x - z.velocity.prevPositionX) < 2) z.velocity.x = 0;
                if (Math.abs(z.image.touchesCurrent.y - z.velocity.prevPositionY) < 2) z.velocity.y = 0;
                z.velocity.prevPositionX = z.image.touchesCurrent.x;
                z.velocity.prevPositionY = z.image.touchesCurrent.y;
                z.velocity.prevTime = Date.now();

                z.gesture.imageWrap.transform('translate3d(' + z.image.currentX + 'px, ' + z.image.currentY + 'px,0)');
            },
            onTouchEnd: function onTouchEnd(s, e) {
                var z = s.zoom;
                if (!z.gesture.image || z.gesture.image.length === 0) return;
                if (!z.image.isTouched || !z.image.isMoved) {
                    z.image.isTouched = false;
                    z.image.isMoved = false;
                    return;
                }
                z.image.isTouched = false;
                z.image.isMoved = false;
                var momentumDurationX = 300;
                var momentumDurationY = 300;
                var momentumDistanceX = z.velocity.x * momentumDurationX;
                var newPositionX = z.image.currentX + momentumDistanceX;
                var momentumDistanceY = z.velocity.y * momentumDurationY;
                var newPositionY = z.image.currentY + momentumDistanceY;

                //Fix duration
                if (z.velocity.x !== 0) momentumDurationX = Math.abs((newPositionX - z.image.currentX) / z.velocity.x);
                if (z.velocity.y !== 0) momentumDurationY = Math.abs((newPositionY - z.image.currentY) / z.velocity.y);
                var momentumDuration = Math.max(momentumDurationX, momentumDurationY);

                z.image.currentX = newPositionX;
                z.image.currentY = newPositionY;

                // Define if we need image drag
                var scaledWidth = z.image.width * z.scale;
                var scaledHeight = z.image.height * z.scale;
                z.image.minX = Math.min(z.gesture.slideWidth / 2 - scaledWidth / 2, 0);
                z.image.maxX = -z.image.minX;
                z.image.minY = Math.min(z.gesture.slideHeight / 2 - scaledHeight / 2, 0);
                z.image.maxY = -z.image.minY;
                z.image.currentX = Math.max(Math.min(z.image.currentX, z.image.maxX), z.image.minX);
                z.image.currentY = Math.max(Math.min(z.image.currentY, z.image.maxY), z.image.minY);

                z.gesture.imageWrap.transition(momentumDuration).transform('translate3d(' + z.image.currentX + 'px, ' + z.image.currentY + 'px,0)');
            },
            onTransitionEnd: function onTransitionEnd(s) {
                var z = s.zoom;
                if (z.gesture.slide && s.previousIndex !== s.activeIndex) {
                    z.gesture.image.transform('translate3d(0,0,0) scale(1)');
                    z.gesture.imageWrap.transform('translate3d(0,0,0)');
                    z.gesture.slide = z.gesture.image = z.gesture.imageWrap = undefined;
                    z.scale = z.currentScale = 1;
                }
            },
            // Toggle Zoom
            toggleZoom: function toggleZoom(s, e) {
                var z = s.zoom;
                if (!z.gesture.slide) {
                    z.gesture.slide = s.clickedSlide ? $(s.clickedSlide) : s.slides.eq(s.activeIndex);
                    z.gesture.image = z.gesture.slide.find('img, svg, canvas');
                    z.gesture.imageWrap = z.gesture.image.parent('.' + s.params.zoomContainerClass);
                }
                if (!z.gesture.image || z.gesture.image.length === 0) return;

                var touchX, touchY, offsetX, offsetY, diffX, diffY, translateX, translateY, imageWidth, imageHeight, scaledWidth, scaledHeight, translateMinX, translateMinY, translateMaxX, translateMaxY, slideWidth, slideHeight;

                if (typeof z.image.touchesStart.x === 'undefined' && e) {
                    touchX = e.type === 'touchend' ? e.changedTouches[0].pageX : e.pageX;
                    touchY = e.type === 'touchend' ? e.changedTouches[0].pageY : e.pageY;
                } else {
                    touchX = z.image.touchesStart.x;
                    touchY = z.image.touchesStart.y;
                }

                if (z.scale && z.scale !== 1) {
                    // Zoom Out
                    z.scale = z.currentScale = 1;
                    z.gesture.imageWrap.transition(300).transform('translate3d(0,0,0)');
                    z.gesture.image.transition(300).transform('translate3d(0,0,0) scale(1)');
                    z.gesture.slide = undefined;
                } else {
                    // Zoom In
                    z.scale = z.currentScale = z.gesture.imageWrap.attr('data-swiper-zoom') || s.params.zoomMax;
                    if (e) {
                        slideWidth = z.gesture.slide[0].offsetWidth;
                        slideHeight = z.gesture.slide[0].offsetHeight;
                        offsetX = z.gesture.slide.offset().left;
                        offsetY = z.gesture.slide.offset().top;
                        diffX = offsetX + slideWidth / 2 - touchX;
                        diffY = offsetY + slideHeight / 2 - touchY;

                        imageWidth = z.gesture.image[0].offsetWidth;
                        imageHeight = z.gesture.image[0].offsetHeight;
                        scaledWidth = imageWidth * z.scale;
                        scaledHeight = imageHeight * z.scale;

                        translateMinX = Math.min(slideWidth / 2 - scaledWidth / 2, 0);
                        translateMinY = Math.min(slideHeight / 2 - scaledHeight / 2, 0);
                        translateMaxX = -translateMinX;
                        translateMaxY = -translateMinY;

                        translateX = diffX * z.scale;
                        translateY = diffY * z.scale;

                        if (translateX < translateMinX) {
                            translateX = translateMinX;
                        }
                        if (translateX > translateMaxX) {
                            translateX = translateMaxX;
                        }

                        if (translateY < translateMinY) {
                            translateY = translateMinY;
                        }
                        if (translateY > translateMaxY) {
                            translateY = translateMaxY;
                        }
                    } else {
                        translateX = 0;
                        translateY = 0;
                    }
                    z.gesture.imageWrap.transition(300).transform('translate3d(' + translateX + 'px, ' + translateY + 'px,0)');
                    z.gesture.image.transition(300).transform('translate3d(0,0,0) scale(' + z.scale + ')');
                }
            },
            // Attach/Detach Events
            attachEvents: function attachEvents(detach) {
                var action = detach ? 'off' : 'on';

                if (s.params.zoom) {
                    var target = s.slides;
                    var passiveListener = s.touchEvents.start === 'touchstart' && s.support.passiveListener && s.params.passiveListeners ? { passive: true, capture: false } : false;
                    // Scale image
                    if (s.support.gestures) {
                        s.slides[action]('gesturestart', s.zoom.onGestureStart, passiveListener);
                        s.slides[action]('gesturechange', s.zoom.onGestureChange, passiveListener);
                        s.slides[action]('gestureend', s.zoom.onGestureEnd, passiveListener);
                    } else if (s.touchEvents.start === 'touchstart') {
                        s.slides[action](s.touchEvents.start, s.zoom.onGestureStart, passiveListener);
                        s.slides[action](s.touchEvents.move, s.zoom.onGestureChange, passiveListener);
                        s.slides[action](s.touchEvents.end, s.zoom.onGestureEnd, passiveListener);
                    }

                    // Move image
                    s[action]('touchStart', s.zoom.onTouchStart);
                    s.slides.each(function (index, slide) {
                        if ($(slide).find('.' + s.params.zoomContainerClass).length > 0) {
                            $(slide)[action](s.touchEvents.move, s.zoom.onTouchMove);
                        }
                    });
                    s[action]('touchEnd', s.zoom.onTouchEnd);

                    // Scale Out
                    s[action]('transitionEnd', s.zoom.onTransitionEnd);
                    if (s.params.zoomToggle) {
                        s.on('doubleTap', s.zoom.toggleZoom);
                    }
                }
            },
            init: function init() {
                s.zoom.attachEvents();
            },
            destroy: function destroy() {
                s.zoom.attachEvents(true);
            }
        };

        /*=========================
          Plugins API. Collect all and init all plugins
          ===========================*/
        s._plugins = [];
        for (var plugin in s.plugins) {
            var p = s.plugins[plugin](s, s.params[plugin]);
            if (p) s._plugins.push(p);
        }
        // Method to call all plugins event/method
        s.callPlugins = function (eventName) {
            for (var i = 0; i < s._plugins.length; i++) {
                if (eventName in s._plugins[i]) {
                    s._plugins[i][eventName](arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
                }
            }
        };

        /*=========================
          Events/Callbacks/Plugins Emitter
          ===========================*/
        function normalizeEventName(eventName) {
            if (eventName.indexOf('on') !== 0) {
                if (eventName[0] !== eventName[0].toUpperCase()) {
                    eventName = 'on' + eventName[0].toUpperCase() + eventName.substring(1);
                } else {
                    eventName = 'on' + eventName;
                }
            }
            return eventName;
        }
        s.emitterEventListeners = {};
        s.emit = function (eventName) {
            // Trigger callbacks
            if (s.params[eventName]) {
                s.params[eventName](arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
            }
            var i;
            // Trigger events
            if (s.emitterEventListeners[eventName]) {
                for (i = 0; i < s.emitterEventListeners[eventName].length; i++) {
                    s.emitterEventListeners[eventName][i](arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
                }
            }
            // Trigger plugins
            if (s.callPlugins) s.callPlugins(eventName, arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
        };
        s.on = function (eventName, handler) {
            eventName = normalizeEventName(eventName);
            if (!s.emitterEventListeners[eventName]) s.emitterEventListeners[eventName] = [];
            s.emitterEventListeners[eventName].push(handler);
            return s;
        };
        s.off = function (eventName, handler) {
            var i;
            eventName = normalizeEventName(eventName);
            if (typeof handler === 'undefined') {
                // Remove all handlers for such event
                s.emitterEventListeners[eventName] = [];
                return s;
            }
            if (!s.emitterEventListeners[eventName] || s.emitterEventListeners[eventName].length === 0) return;
            for (i = 0; i < s.emitterEventListeners[eventName].length; i++) {
                if (s.emitterEventListeners[eventName][i] === handler) s.emitterEventListeners[eventName].splice(i, 1);
            }
            return s;
        };
        s.once = function (eventName, handler) {
            eventName = normalizeEventName(eventName);
            var _handler = function _handler() {
                handler(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
                s.off(eventName, _handler);
            };
            s.on(eventName, _handler);
            return s;
        };

        // Accessibility tools
        s.a11y = {
            makeFocusable: function makeFocusable($el) {
                $el.attr('tabIndex', '0');
                return $el;
            },
            addRole: function addRole($el, role) {
                $el.attr('role', role);
                return $el;
            },

            addLabel: function addLabel($el, label) {
                $el.attr('aria-label', label);
                return $el;
            },

            disable: function disable($el) {
                $el.attr('aria-disabled', true);
                return $el;
            },

            enable: function enable($el) {
                $el.attr('aria-disabled', false);
                return $el;
            },

            onEnterKey: function onEnterKey(event) {
                if (event.keyCode !== 13) return;
                if ($(event.target).is(s.params.nextButton)) {
                    s.onClickNext(event);
                    if (s.isEnd) {
                        s.a11y.notify(s.params.lastSlideMessage);
                    } else {
                        s.a11y.notify(s.params.nextSlideMessage);
                    }
                } else if ($(event.target).is(s.params.prevButton)) {
                    s.onClickPrev(event);
                    if (s.isBeginning) {
                        s.a11y.notify(s.params.firstSlideMessage);
                    } else {
                        s.a11y.notify(s.params.prevSlideMessage);
                    }
                }
                if ($(event.target).is('.' + s.params.bulletClass)) {
                    $(event.target)[0].click();
                }
            },

            liveRegion: $('<span class="' + s.params.notificationClass + '" aria-live="assertive" aria-atomic="true"></span>'),

            notify: function notify(message) {
                var notification = s.a11y.liveRegion;
                if (notification.length === 0) return;
                notification.html('');
                notification.html(message);
            },
            init: function init() {
                // Setup accessibility
                if (s.params.nextButton && s.nextButton && s.nextButton.length > 0) {
                    s.a11y.makeFocusable(s.nextButton);
                    s.a11y.addRole(s.nextButton, 'button');
                    s.a11y.addLabel(s.nextButton, s.params.nextSlideMessage);
                }
                if (s.params.prevButton && s.prevButton && s.prevButton.length > 0) {
                    s.a11y.makeFocusable(s.prevButton);
                    s.a11y.addRole(s.prevButton, 'button');
                    s.a11y.addLabel(s.prevButton, s.params.prevSlideMessage);
                }

                $(s.container).append(s.a11y.liveRegion);
            },
            initPagination: function initPagination() {
                if (s.params.pagination && s.params.paginationClickable && s.bullets && s.bullets.length) {
                    s.bullets.each(function () {
                        var bullet = $(this);
                        s.a11y.makeFocusable(bullet);
                        s.a11y.addRole(bullet, 'button');
                        s.a11y.addLabel(bullet, s.params.paginationBulletMessage.replace(/{{index}}/, bullet.index() + 1));
                    });
                }
            },
            destroy: function destroy() {
                if (s.a11y.liveRegion && s.a11y.liveRegion.length > 0) s.a11y.liveRegion.remove();
            }
        };

        /*=========================
          Init/Destroy
          ===========================*/
        s.init = function () {
            if (s.params.loop) s.createLoop();
            s.updateContainerSize();
            s.updateSlidesSize();
            s.updatePagination();
            if (s.params.scrollbar && s.scrollbar) {
                s.scrollbar.set();
                if (s.params.scrollbarDraggable) {
                    s.scrollbar.enableDraggable();
                }
            }
            if (s.params.effect !== 'slide' && s.effects[s.params.effect]) {
                if (!s.params.loop) s.updateProgress();
                s.effects[s.params.effect].setTranslate();
            }
            if (s.params.loop) {
                s.slideTo(s.params.initialSlide + s.loopedSlides, 0, s.params.runCallbacksOnInit);
            } else {
                s.slideTo(s.params.initialSlide, 0, s.params.runCallbacksOnInit);
                if (s.params.initialSlide === 0) {
                    if (s.parallax && s.params.parallax) s.parallax.setTranslate();
                    if (s.lazy && s.params.lazyLoading) {
                        s.lazy.load();
                        s.lazy.initialImageLoaded = true;
                    }
                }
            }
            s.attachEvents();
            if (s.params.observer && s.support.observer) {
                s.initObservers();
            }
            if (s.params.preloadImages && !s.params.lazyLoading) {
                s.preloadImages();
            }
            if (s.params.zoom && s.zoom) {
                s.zoom.init();
            }
            if (s.params.autoplay) {
                s.startAutoplay();
            }
            if (s.params.keyboardControl) {
                if (s.enableKeyboardControl) s.enableKeyboardControl();
            }
            if (s.params.mousewheelControl) {
                if (s.enableMousewheelControl) s.enableMousewheelControl();
            }
            // Deprecated hashnavReplaceState changed to replaceState for use in hashnav and history
            if (s.params.hashnavReplaceState) {
                s.params.replaceState = s.params.hashnavReplaceState;
            }
            if (s.params.history) {
                if (s.history) s.history.init();
            }
            if (s.params.hashnav) {
                if (s.hashnav) s.hashnav.init();
            }
            if (s.params.a11y && s.a11y) s.a11y.init();
            s.emit('onInit', s);
        };

        // Cleanup dynamic styles
        s.cleanupStyles = function () {
            // Container
            s.container.removeClass(s.classNames.join(' ')).removeAttr('style');

            // Wrapper
            s.wrapper.removeAttr('style');

            // Slides
            if (s.slides && s.slides.length) {
                s.slides.removeClass([s.params.slideVisibleClass, s.params.slideActiveClass, s.params.slideNextClass, s.params.slidePrevClass].join(' ')).removeAttr('style').removeAttr('data-swiper-column').removeAttr('data-swiper-row');
            }

            // Pagination/Bullets
            if (s.paginationContainer && s.paginationContainer.length) {
                s.paginationContainer.removeClass(s.params.paginationHiddenClass);
            }
            if (s.bullets && s.bullets.length) {
                s.bullets.removeClass(s.params.bulletActiveClass);
            }

            // Buttons
            if (s.params.prevButton) $(s.params.prevButton).removeClass(s.params.buttonDisabledClass);
            if (s.params.nextButton) $(s.params.nextButton).removeClass(s.params.buttonDisabledClass);

            // Scrollbar
            if (s.params.scrollbar && s.scrollbar) {
                if (s.scrollbar.track && s.scrollbar.track.length) s.scrollbar.track.removeAttr('style');
                if (s.scrollbar.drag && s.scrollbar.drag.length) s.scrollbar.drag.removeAttr('style');
            }
        };

        // Destroy
        s.destroy = function (deleteInstance, cleanupStyles) {
            // Detach evebts
            s.detachEvents();
            // Stop autoplay
            s.stopAutoplay();
            // Disable draggable
            if (s.params.scrollbar && s.scrollbar) {
                if (s.params.scrollbarDraggable) {
                    s.scrollbar.disableDraggable();
                }
            }
            // Destroy loop
            if (s.params.loop) {
                s.destroyLoop();
            }
            // Cleanup styles
            if (cleanupStyles) {
                s.cleanupStyles();
            }
            // Disconnect observer
            s.disconnectObservers();

            // Destroy zoom
            if (s.params.zoom && s.zoom) {
                s.zoom.destroy();
            }
            // Disable keyboard/mousewheel
            if (s.params.keyboardControl) {
                if (s.disableKeyboardControl) s.disableKeyboardControl();
            }
            if (s.params.mousewheelControl) {
                if (s.disableMousewheelControl) s.disableMousewheelControl();
            }
            // Disable a11y
            if (s.params.a11y && s.a11y) s.a11y.destroy();
            // Delete history popstate
            if (s.params.history && !s.params.replaceState) {
                window.removeEventListener('popstate', s.history.setHistoryPopState);
            }
            if (s.params.hashnav && s.hashnav) {
                s.hashnav.destroy();
            }
            // Destroy callback
            s.emit('onDestroy');
            // Delete instance
            if (deleteInstance !== false) s = null;
        };

        s.init();

        // Return swiper instance
        return s;
    };

    /*==================================================
        Prototype
    ====================================================*/
    Swiper.prototype = {
        isSafari: function () {
            var ua = window.navigator.userAgent.toLowerCase();
            return ua.indexOf('safari') >= 0 && ua.indexOf('chrome') < 0 && ua.indexOf('android') < 0;
        }(),
        isUiWebView: /(iPhone|iPod|iPad).*AppleWebKit(?!.*Safari)/i.test(window.navigator.userAgent),
        isArray: function isArray(arr) {
            return Object.prototype.toString.apply(arr) === '[object Array]';
        },
        /*==================================================
        Browser
        ====================================================*/
        browser: {
            ie: window.navigator.pointerEnabled || window.navigator.msPointerEnabled,
            ieTouch: window.navigator.msPointerEnabled && window.navigator.msMaxTouchPoints > 1 || window.navigator.pointerEnabled && window.navigator.maxTouchPoints > 1,
            lteIE9: function () {
                // create temporary DIV
                var div = document.createElement('div');
                // add content to tmp DIV which is wrapped into the IE HTML conditional statement
                div.innerHTML = '<!--[if lte IE 9]><i></i><![endif]-->';
                // return true / false value based on what will browser render
                return div.getElementsByTagName('i').length === 1;
            }()
        },
        /*==================================================
        Devices
        ====================================================*/
        device: function () {
            var ua = window.navigator.userAgent;
            var android = ua.match(/(Android);?[\s\/]+([\d.]+)?/);
            var ipad = ua.match(/(iPad).*OS\s([\d_]+)/);
            var ipod = ua.match(/(iPod)(.*OS\s([\d_]+))?/);
            var iphone = !ipad && ua.match(/(iPhone\sOS|iOS)\s([\d_]+)/);
            return {
                ios: ipad || iphone || ipod,
                android: android
            };
        }(),
        /*==================================================
        Feature Detection
        ====================================================*/
        support: {
            touch: window.Modernizr && Modernizr.touch === true || function () {
                return !!('ontouchstart' in window || window.DocumentTouch && document instanceof DocumentTouch);
            }(),

            transforms3d: window.Modernizr && Modernizr.csstransforms3d === true || function () {
                var div = document.createElement('div').style;
                return 'webkitPerspective' in div || 'MozPerspective' in div || 'OPerspective' in div || 'MsPerspective' in div || 'perspective' in div;
            }(),

            flexbox: function () {
                var div = document.createElement('div').style;
                var styles = 'alignItems webkitAlignItems webkitBoxAlign msFlexAlign mozBoxAlign webkitFlexDirection msFlexDirection mozBoxDirection mozBoxOrient webkitBoxDirection webkitBoxOrient'.split(' ');
                for (var i = 0; i < styles.length; i++) {
                    if (styles[i] in div) return true;
                }
            }(),

            observer: function () {
                return 'MutationObserver' in window || 'WebkitMutationObserver' in window;
            }(),

            passiveListener: function () {
                var supportsPassive = false;
                try {
                    var opts = Object.defineProperty({}, 'passive', {
                        get: function get() {
                            supportsPassive = true;
                        }
                    });
                    window.addEventListener('testPassiveListener', null, opts);
                } catch (e) {}
                return supportsPassive;
            }(),

            gestures: function () {
                return 'ongesturestart' in window;
            }()
        },
        /*==================================================
        Plugins
        ====================================================*/
        plugins: {}
    };

    /*===========================
    Dom7 Library
    ===========================*/
    var Dom7 = function () {
        var Dom7 = function Dom7(arr) {
            var _this = this,
                i = 0;
            // Create array-like object
            for (i = 0; i < arr.length; i++) {
                _this[i] = arr[i];
            }
            _this.length = arr.length;
            // Return collection with methods
            return this;
        };
        var $ = function $(selector, context) {
            var arr = [],
                i = 0;
            if (selector && !context) {
                if (selector instanceof Dom7) {
                    return selector;
                }
            }
            if (selector) {
                // String
                if (typeof selector === 'string') {
                    var els,
                        tempParent,
                        html = selector.trim();
                    if (html.indexOf('<') >= 0 && html.indexOf('>') >= 0) {
                        var toCreate = 'div';
                        if (html.indexOf('<li') === 0) toCreate = 'ul';
                        if (html.indexOf('<tr') === 0) toCreate = 'tbody';
                        if (html.indexOf('<td') === 0 || html.indexOf('<th') === 0) toCreate = 'tr';
                        if (html.indexOf('<tbody') === 0) toCreate = 'table';
                        if (html.indexOf('<option') === 0) toCreate = 'select';
                        tempParent = document.createElement(toCreate);
                        tempParent.innerHTML = selector;
                        for (i = 0; i < tempParent.childNodes.length; i++) {
                            arr.push(tempParent.childNodes[i]);
                        }
                    } else {
                        if (!context && selector[0] === '#' && !selector.match(/[ .<>:~]/)) {
                            // Pure ID selector
                            els = [document.getElementById(selector.split('#')[1])];
                        } else {
                            // Other selectors
                            els = (context || document).querySelectorAll(selector);
                        }
                        for (i = 0; i < els.length; i++) {
                            if (els[i]) arr.push(els[i]);
                        }
                    }
                }
                // Node/element
                else if (selector.nodeType || selector === window || selector === document) {
                        arr.push(selector);
                    }
                    //Array of elements or instance of Dom
                    else if (selector.length > 0 && selector[0].nodeType) {
                            for (i = 0; i < selector.length; i++) {
                                arr.push(selector[i]);
                            }
                        }
            }
            return new Dom7(arr);
        };
        Dom7.prototype = {
            // Classes and attriutes
            addClass: function addClass(className) {
                if (typeof className === 'undefined') {
                    return this;
                }
                var classes = className.split(' ');
                for (var i = 0; i < classes.length; i++) {
                    for (var j = 0; j < this.length; j++) {
                        this[j].classList.add(classes[i]);
                    }
                }
                return this;
            },
            removeClass: function removeClass(className) {
                var classes = className.split(' ');
                for (var i = 0; i < classes.length; i++) {
                    for (var j = 0; j < this.length; j++) {
                        this[j].classList.remove(classes[i]);
                    }
                }
                return this;
            },
            hasClass: function hasClass(className) {
                if (!this[0]) return false;else return this[0].classList.contains(className);
            },
            toggleClass: function toggleClass(className) {
                var classes = className.split(' ');
                for (var i = 0; i < classes.length; i++) {
                    for (var j = 0; j < this.length; j++) {
                        this[j].classList.toggle(classes[i]);
                    }
                }
                return this;
            },
            attr: function attr(attrs, value) {
                if (arguments.length === 1 && typeof attrs === 'string') {
                    // Get attr
                    if (this[0]) return this[0].getAttribute(attrs);else return undefined;
                } else {
                    // Set attrs
                    for (var i = 0; i < this.length; i++) {
                        if (arguments.length === 2) {
                            // String
                            this[i].setAttribute(attrs, value);
                        } else {
                            // Object
                            for (var attrName in attrs) {
                                this[i][attrName] = attrs[attrName];
                                this[i].setAttribute(attrName, attrs[attrName]);
                            }
                        }
                    }
                    return this;
                }
            },
            removeAttr: function removeAttr(attr) {
                for (var i = 0; i < this.length; i++) {
                    this[i].removeAttribute(attr);
                }
                return this;
            },
            data: function data(key, value) {
                if (typeof value === 'undefined') {
                    // Get value
                    if (this[0]) {
                        var dataKey = this[0].getAttribute('data-' + key);
                        if (dataKey) return dataKey;else if (this[0].dom7ElementDataStorage && key in this[0].dom7ElementDataStorage) return this[0].dom7ElementDataStorage[key];else return undefined;
                    } else return undefined;
                } else {
                    // Set value
                    for (var i = 0; i < this.length; i++) {
                        var el = this[i];
                        if (!el.dom7ElementDataStorage) el.dom7ElementDataStorage = {};
                        el.dom7ElementDataStorage[key] = value;
                    }
                    return this;
                }
            },
            // Transforms
            transform: function transform(_transform) {
                for (var i = 0; i < this.length; i++) {
                    var elStyle = this[i].style;
                    elStyle.webkitTransform = elStyle.MsTransform = elStyle.msTransform = elStyle.MozTransform = elStyle.OTransform = elStyle.transform = _transform;
                }
                return this;
            },
            transition: function transition(duration) {
                if (typeof duration !== 'string') {
                    duration = duration + 'ms';
                }
                for (var i = 0; i < this.length; i++) {
                    var elStyle = this[i].style;
                    elStyle.webkitTransitionDuration = elStyle.MsTransitionDuration = elStyle.msTransitionDuration = elStyle.MozTransitionDuration = elStyle.OTransitionDuration = elStyle.transitionDuration = duration;
                }
                return this;
            },
            //Events
            on: function on(eventName, targetSelector, listener, capture) {
                function handleLiveEvent(e) {
                    var target = e.target;
                    if ($(target).is(targetSelector)) listener.call(target, e);else {
                        var parents = $(target).parents();
                        for (var k = 0; k < parents.length; k++) {
                            if ($(parents[k]).is(targetSelector)) listener.call(parents[k], e);
                        }
                    }
                }
                var events = eventName.split(' ');
                var i, j;
                for (i = 0; i < this.length; i++) {
                    if (typeof targetSelector === 'function' || targetSelector === false) {
                        // Usual events
                        if (typeof targetSelector === 'function') {
                            listener = arguments[1];
                            capture = arguments[2] || false;
                        }
                        for (j = 0; j < events.length; j++) {
                            this[i].addEventListener(events[j], listener, capture);
                        }
                    } else {
                        //Live events
                        for (j = 0; j < events.length; j++) {
                            if (!this[i].dom7LiveListeners) this[i].dom7LiveListeners = [];
                            this[i].dom7LiveListeners.push({ listener: listener, liveListener: handleLiveEvent });
                            this[i].addEventListener(events[j], handleLiveEvent, capture);
                        }
                    }
                }

                return this;
            },
            off: function off(eventName, targetSelector, listener, capture) {
                var events = eventName.split(' ');
                for (var i = 0; i < events.length; i++) {
                    for (var j = 0; j < this.length; j++) {
                        if (typeof targetSelector === 'function' || targetSelector === false) {
                            // Usual events
                            if (typeof targetSelector === 'function') {
                                listener = arguments[1];
                                capture = arguments[2] || false;
                            }
                            this[j].removeEventListener(events[i], listener, capture);
                        } else {
                            // Live event
                            if (this[j].dom7LiveListeners) {
                                for (var k = 0; k < this[j].dom7LiveListeners.length; k++) {
                                    if (this[j].dom7LiveListeners[k].listener === listener) {
                                        this[j].removeEventListener(events[i], this[j].dom7LiveListeners[k].liveListener, capture);
                                    }
                                }
                            }
                        }
                    }
                }
                return this;
            },
            once: function once(eventName, targetSelector, listener, capture) {
                var dom = this;
                if (typeof targetSelector === 'function') {
                    targetSelector = false;
                    listener = arguments[1];
                    capture = arguments[2];
                }
                function proxy(e) {
                    listener(e);
                    dom.off(eventName, targetSelector, proxy, capture);
                }
                dom.on(eventName, targetSelector, proxy, capture);
            },
            trigger: function trigger(eventName, eventData) {
                for (var i = 0; i < this.length; i++) {
                    var evt;
                    try {
                        evt = new window.CustomEvent(eventName, { detail: eventData, bubbles: true, cancelable: true });
                    } catch (e) {
                        evt = document.createEvent('Event');
                        evt.initEvent(eventName, true, true);
                        evt.detail = eventData;
                    }
                    this[i].dispatchEvent(evt);
                }
                return this;
            },
            transitionEnd: function transitionEnd(callback) {
                var events = ['webkitTransitionEnd', 'transitionend', 'oTransitionEnd', 'MSTransitionEnd', 'msTransitionEnd'],
                    i,
                    j,
                    dom = this;
                function fireCallBack(e) {
                    /*jshint validthis:true */
                    if (e.target !== this) return;
                    callback.call(this, e);
                    for (i = 0; i < events.length; i++) {
                        dom.off(events[i], fireCallBack);
                    }
                }
                if (callback) {
                    for (i = 0; i < events.length; i++) {
                        dom.on(events[i], fireCallBack);
                    }
                }
                return this;
            },
            // Sizing/Styles
            width: function width() {
                if (this[0] === window) {
                    return window.innerWidth;
                } else {
                    if (this.length > 0) {
                        return parseFloat(this.css('width'));
                    } else {
                        return null;
                    }
                }
            },
            outerWidth: function outerWidth(includeMargins) {
                if (this.length > 0) {
                    if (includeMargins) return this[0].offsetWidth + parseFloat(this.css('margin-right')) + parseFloat(this.css('margin-left'));else return this[0].offsetWidth;
                } else return null;
            },
            height: function height() {
                if (this[0] === window) {
                    return window.innerHeight;
                } else {
                    if (this.length > 0) {
                        return parseFloat(this.css('height'));
                    } else {
                        return null;
                    }
                }
            },
            outerHeight: function outerHeight(includeMargins) {
                if (this.length > 0) {
                    if (includeMargins) return this[0].offsetHeight + parseFloat(this.css('margin-top')) + parseFloat(this.css('margin-bottom'));else return this[0].offsetHeight;
                } else return null;
            },
            offset: function offset() {
                if (this.length > 0) {
                    var el = this[0];
                    var box = el.getBoundingClientRect();
                    var body = document.body;
                    var clientTop = el.clientTop || body.clientTop || 0;
                    var clientLeft = el.clientLeft || body.clientLeft || 0;
                    var scrollTop = window.pageYOffset || el.scrollTop;
                    var scrollLeft = window.pageXOffset || el.scrollLeft;
                    return {
                        top: box.top + scrollTop - clientTop,
                        left: box.left + scrollLeft - clientLeft
                    };
                } else {
                    return null;
                }
            },
            css: function css(props, value) {
                var i;
                if (arguments.length === 1) {
                    if (typeof props === 'string') {
                        if (this[0]) return window.getComputedStyle(this[0], null).getPropertyValue(props);
                    } else {
                        for (i = 0; i < this.length; i++) {
                            for (var prop in props) {
                                this[i].style[prop] = props[prop];
                            }
                        }
                        return this;
                    }
                }
                if (arguments.length === 2 && typeof props === 'string') {
                    for (i = 0; i < this.length; i++) {
                        this[i].style[props] = value;
                    }
                    return this;
                }
                return this;
            },

            //Dom manipulation
            each: function each(callback) {
                for (var i = 0; i < this.length; i++) {
                    callback.call(this[i], i, this[i]);
                }
                return this;
            },
            html: function html(_html) {
                if (typeof _html === 'undefined') {
                    return this[0] ? this[0].innerHTML : undefined;
                } else {
                    for (var i = 0; i < this.length; i++) {
                        this[i].innerHTML = _html;
                    }
                    return this;
                }
            },
            text: function text(_text) {
                if (typeof _text === 'undefined') {
                    if (this[0]) {
                        return this[0].textContent.trim();
                    } else return null;
                } else {
                    for (var i = 0; i < this.length; i++) {
                        this[i].textContent = _text;
                    }
                    return this;
                }
            },
            is: function is(selector) {
                if (!this[0]) return false;
                var compareWith, i;
                if (typeof selector === 'string') {
                    var el = this[0];
                    if (el === document) return selector === document;
                    if (el === window) return selector === window;

                    if (el.matches) return el.matches(selector);else if (el.webkitMatchesSelector) return el.webkitMatchesSelector(selector);else if (el.mozMatchesSelector) return el.mozMatchesSelector(selector);else if (el.msMatchesSelector) return el.msMatchesSelector(selector);else {
                        compareWith = $(selector);
                        for (i = 0; i < compareWith.length; i++) {
                            if (compareWith[i] === this[0]) return true;
                        }
                        return false;
                    }
                } else if (selector === document) return this[0] === document;else if (selector === window) return this[0] === window;else {
                    if (selector.nodeType || selector instanceof Dom7) {
                        compareWith = selector.nodeType ? [selector] : selector;
                        for (i = 0; i < compareWith.length; i++) {
                            if (compareWith[i] === this[0]) return true;
                        }
                        return false;
                    }
                    return false;
                }
            },
            index: function index() {
                if (this[0]) {
                    var child = this[0];
                    var i = 0;
                    while ((child = child.previousSibling) !== null) {
                        if (child.nodeType === 1) i++;
                    }
                    return i;
                } else return undefined;
            },
            eq: function eq(index) {
                if (typeof index === 'undefined') return this;
                var length = this.length;
                var returnIndex;
                if (index > length - 1) {
                    return new Dom7([]);
                }
                if (index < 0) {
                    returnIndex = length + index;
                    if (returnIndex < 0) return new Dom7([]);else return new Dom7([this[returnIndex]]);
                }
                return new Dom7([this[index]]);
            },
            append: function append(newChild) {
                var i, j;
                for (i = 0; i < this.length; i++) {
                    if (typeof newChild === 'string') {
                        var tempDiv = document.createElement('div');
                        tempDiv.innerHTML = newChild;
                        while (tempDiv.firstChild) {
                            this[i].appendChild(tempDiv.firstChild);
                        }
                    } else if (newChild instanceof Dom7) {
                        for (j = 0; j < newChild.length; j++) {
                            this[i].appendChild(newChild[j]);
                        }
                    } else {
                        this[i].appendChild(newChild);
                    }
                }
                return this;
            },
            prepend: function prepend(newChild) {
                var i, j;
                for (i = 0; i < this.length; i++) {
                    if (typeof newChild === 'string') {
                        var tempDiv = document.createElement('div');
                        tempDiv.innerHTML = newChild;
                        for (j = tempDiv.childNodes.length - 1; j >= 0; j--) {
                            this[i].insertBefore(tempDiv.childNodes[j], this[i].childNodes[0]);
                        }
                        // this[i].insertAdjacentHTML('afterbegin', newChild);
                    } else if (newChild instanceof Dom7) {
                        for (j = 0; j < newChild.length; j++) {
                            this[i].insertBefore(newChild[j], this[i].childNodes[0]);
                        }
                    } else {
                        this[i].insertBefore(newChild, this[i].childNodes[0]);
                    }
                }
                return this;
            },
            insertBefore: function insertBefore(selector) {
                var before = $(selector);
                for (var i = 0; i < this.length; i++) {
                    if (before.length === 1) {
                        before[0].parentNode.insertBefore(this[i], before[0]);
                    } else if (before.length > 1) {
                        for (var j = 0; j < before.length; j++) {
                            before[j].parentNode.insertBefore(this[i].cloneNode(true), before[j]);
                        }
                    }
                }
            },
            insertAfter: function insertAfter(selector) {
                var after = $(selector);
                for (var i = 0; i < this.length; i++) {
                    if (after.length === 1) {
                        after[0].parentNode.insertBefore(this[i], after[0].nextSibling);
                    } else if (after.length > 1) {
                        for (var j = 0; j < after.length; j++) {
                            after[j].parentNode.insertBefore(this[i].cloneNode(true), after[j].nextSibling);
                        }
                    }
                }
            },
            next: function next(selector) {
                if (this.length > 0) {
                    if (selector) {
                        if (this[0].nextElementSibling && $(this[0].nextElementSibling).is(selector)) return new Dom7([this[0].nextElementSibling]);else return new Dom7([]);
                    } else {
                        if (this[0].nextElementSibling) return new Dom7([this[0].nextElementSibling]);else return new Dom7([]);
                    }
                } else return new Dom7([]);
            },
            nextAll: function nextAll(selector) {
                var nextEls = [];
                var el = this[0];
                if (!el) return new Dom7([]);
                while (el.nextElementSibling) {
                    var next = el.nextElementSibling;
                    if (selector) {
                        if ($(next).is(selector)) nextEls.push(next);
                    } else nextEls.push(next);
                    el = next;
                }
                return new Dom7(nextEls);
            },
            prev: function prev(selector) {
                if (this.length > 0) {
                    if (selector) {
                        if (this[0].previousElementSibling && $(this[0].previousElementSibling).is(selector)) return new Dom7([this[0].previousElementSibling]);else return new Dom7([]);
                    } else {
                        if (this[0].previousElementSibling) return new Dom7([this[0].previousElementSibling]);else return new Dom7([]);
                    }
                } else return new Dom7([]);
            },
            prevAll: function prevAll(selector) {
                var prevEls = [];
                var el = this[0];
                if (!el) return new Dom7([]);
                while (el.previousElementSibling) {
                    var prev = el.previousElementSibling;
                    if (selector) {
                        if ($(prev).is(selector)) prevEls.push(prev);
                    } else prevEls.push(prev);
                    el = prev;
                }
                return new Dom7(prevEls);
            },
            parent: function parent(selector) {
                var parents = [];
                for (var i = 0; i < this.length; i++) {
                    if (selector) {
                        if ($(this[i].parentNode).is(selector)) parents.push(this[i].parentNode);
                    } else {
                        parents.push(this[i].parentNode);
                    }
                }
                return $($.unique(parents));
            },
            parents: function parents(selector) {
                var parents = [];
                for (var i = 0; i < this.length; i++) {
                    var parent = this[i].parentNode;
                    while (parent) {
                        if (selector) {
                            if ($(parent).is(selector)) parents.push(parent);
                        } else {
                            parents.push(parent);
                        }
                        parent = parent.parentNode;
                    }
                }
                return $($.unique(parents));
            },
            find: function find(selector) {
                var foundElements = [];
                for (var i = 0; i < this.length; i++) {
                    var found = this[i].querySelectorAll(selector);
                    for (var j = 0; j < found.length; j++) {
                        foundElements.push(found[j]);
                    }
                }
                return new Dom7(foundElements);
            },
            children: function children(selector) {
                var children = [];
                for (var i = 0; i < this.length; i++) {
                    var childNodes = this[i].childNodes;

                    for (var j = 0; j < childNodes.length; j++) {
                        if (!selector) {
                            if (childNodes[j].nodeType === 1) children.push(childNodes[j]);
                        } else {
                            if (childNodes[j].nodeType === 1 && $(childNodes[j]).is(selector)) children.push(childNodes[j]);
                        }
                    }
                }
                return new Dom7($.unique(children));
            },
            remove: function remove() {
                for (var i = 0; i < this.length; i++) {
                    if (this[i].parentNode) this[i].parentNode.removeChild(this[i]);
                }
                return this;
            },
            add: function add() {
                var dom = this;
                var i, j;
                for (i = 0; i < arguments.length; i++) {
                    var toAdd = $(arguments[i]);
                    for (j = 0; j < toAdd.length; j++) {
                        dom[dom.length] = toAdd[j];
                        dom.length++;
                    }
                }
                return dom;
            }
        };
        $.fn = Dom7.prototype;
        $.unique = function (arr) {
            var unique = [];
            for (var i = 0; i < arr.length; i++) {
                if (unique.indexOf(arr[i]) === -1) unique.push(arr[i]);
            }
            return unique;
        };

        return $;
    }();

    /*===========================
     Get Dom libraries
     ===========================*/
    var swiperDomPlugins = ['jQuery', 'Zepto', 'Dom7'];
    for (var i = 0; i < swiperDomPlugins.length; i++) {
        if (window[swiperDomPlugins[i]]) {
            addLibraryPlugin(window[swiperDomPlugins[i]]);
        }
    }
    // Required DOM Plugins
    var domLib;
    if (typeof Dom7 === 'undefined') {
        domLib = window.Dom7 || window.Zepto || window.jQuery;
    } else {
        domLib = Dom7;
    }

    /*===========================
    Add .swiper plugin from Dom libraries
    ===========================*/
    function addLibraryPlugin(lib) {
        lib.fn.swiper = function (params) {
            var firstInstance;
            lib(this).each(function () {
                var s = new Swiper(this, params);
                if (!firstInstance) firstInstance = s;
            });
            return firstInstance;
        };
    }

    if (domLib) {
        if (!('transitionEnd' in domLib.fn)) {
            domLib.fn.transitionEnd = function (callback) {
                var events = ['webkitTransitionEnd', 'transitionend', 'oTransitionEnd', 'MSTransitionEnd', 'msTransitionEnd'],
                    i,
                    j,
                    dom = this;
                function fireCallBack(e) {
                    /*jshint validthis:true */
                    if (e.target !== this) return;
                    callback.call(this, e);
                    for (i = 0; i < events.length; i++) {
                        dom.off(events[i], fireCallBack);
                    }
                }
                if (callback) {
                    for (i = 0; i < events.length; i++) {
                        dom.on(events[i], fireCallBack);
                    }
                }
                return this;
            };
        }
        if (!('transform' in domLib.fn)) {
            domLib.fn.transform = function (transform) {
                for (var i = 0; i < this.length; i++) {
                    var elStyle = this[i].style;
                    elStyle.webkitTransform = elStyle.MsTransform = elStyle.msTransform = elStyle.MozTransform = elStyle.OTransform = elStyle.transform = transform;
                }
                return this;
            };
        }
        if (!('transition' in domLib.fn)) {
            domLib.fn.transition = function (duration) {
                if (typeof duration !== 'string') {
                    duration = duration + 'ms';
                }
                for (var i = 0; i < this.length; i++) {
                    var elStyle = this[i].style;
                    elStyle.webkitTransitionDuration = elStyle.MsTransitionDuration = elStyle.msTransitionDuration = elStyle.MozTransitionDuration = elStyle.OTransitionDuration = elStyle.transitionDuration = duration;
                }
                return this;
            };
        }
        if (!('outerWidth' in domLib.fn)) {
            domLib.fn.outerWidth = function (includeMargins) {
                if (this.length > 0) {
                    if (includeMargins) return this[0].offsetWidth + parseFloat(this.css('margin-right')) + parseFloat(this.css('margin-left'));else return this[0].offsetWidth;
                } else return null;
            };
        }
    }

    window.Swiper = Swiper;
})();

/*===========================
Swiper AMD Export
===========================*/
if (true) {
    module.exports = window.Swiper;
} else if (typeof define === 'function' && define.amd) {
    define([], function () {
        'use strict';

        return window.Swiper;
    });
}

//# sourceMappingURL=maps/swiper.js.map

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;var require;var require;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/*!
 * enquire.js v2.1.6 - Awesome Media Queries in JavaScript
 * Copyright (c) 2017 Nick Williams - http://wicky.nillia.ms/enquire.js
 * License: MIT */

(function (f) {
    if (( false ? "undefined" : _typeof(exports)) === "object" && typeof module !== "undefined") {
        module.exports = f();
    } else if (true) {
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (f),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else {
        var g;if (typeof window !== "undefined") {
            g = window;
        } else if (typeof global !== "undefined") {
            g = global;
        } else if (typeof self !== "undefined") {
            g = self;
        } else {
            g = this;
        }g.enquire = f();
    }
})(function () {
    var define, module, exports;return function e(t, n, r) {
        function s(o, u) {
            if (!n[o]) {
                if (!t[o]) {
                    var a = typeof require == "function" && require;if (!u && a) return require(o, !0);if (i) return require(o, !0);var f = new Error("Cannot find module '" + o + "'");throw f.code = "MODULE_NOT_FOUND", f;
                }var l = n[o] = { exports: {} };t[o][0].call(l.exports, function (e) {
                    var n = t[o][1][e];return s(n ? n : e);
                }, l, l.exports, e, t, n, r);
            }return n[o].exports;
        }var i = typeof require == "function" && require;for (var o = 0; o < r.length; o++) {
            s(r[o]);
        }return s;
    }({ 1: [function (require, module, exports) {
            var QueryHandler = require(3);
            var each = require(4).each;

            /**
             * Represents a single media query, manages it's state and registered handlers for this query
             *
             * @constructor
             * @param {string} query the media query string
             * @param {boolean} [isUnconditional=false] whether the media query should run regardless of whether the conditions are met. Primarily for helping older browsers deal with mobile-first design
             */
            function MediaQuery(query, isUnconditional) {
                this.query = query;
                this.isUnconditional = isUnconditional;
                this.handlers = [];
                this.mql = window.matchMedia(query);

                var self = this;
                this.listener = function (mql) {
                    // Chrome passes an MediaQueryListEvent object, while other browsers pass MediaQueryList directly
                    self.mql = mql.currentTarget || mql;
                    self.assess();
                };
                this.mql.addListener(this.listener);
            }

            MediaQuery.prototype = {

                constuctor: MediaQuery,

                /**
                 * add a handler for this query, triggering if already active
                 *
                 * @param {object} handler
                 * @param {function} handler.match callback for when query is activated
                 * @param {function} [handler.unmatch] callback for when query is deactivated
                 * @param {function} [handler.setup] callback for immediate execution when a query handler is registered
                 * @param {boolean} [handler.deferSetup=false] should the setup callback be deferred until the first time the handler is matched?
                 */
                addHandler: function addHandler(handler) {
                    var qh = new QueryHandler(handler);
                    this.handlers.push(qh);

                    this.matches() && qh.on();
                },

                /**
                 * removes the given handler from the collection, and calls it's destroy methods
                 *
                 * @param {object || function} handler the handler to remove
                 */
                removeHandler: function removeHandler(handler) {
                    var handlers = this.handlers;
                    each(handlers, function (h, i) {
                        if (h.equals(handler)) {
                            h.destroy();
                            return !handlers.splice(i, 1); //remove from array and exit each early
                        }
                    });
                },

                /**
                 * Determine whether the media query should be considered a match
                 *
                 * @return {Boolean} true if media query can be considered a match, false otherwise
                 */
                matches: function matches() {
                    return this.mql.matches || this.isUnconditional;
                },

                /**
                 * Clears all handlers and unbinds events
                 */
                clear: function clear() {
                    each(this.handlers, function (handler) {
                        handler.destroy();
                    });
                    this.mql.removeListener(this.listener);
                    this.handlers.length = 0; //clear array
                },

                /*
                    * Assesses the query, turning on all handlers if it matches, turning them off if it doesn't match
                    */
                assess: function assess() {
                    var action = this.matches() ? 'on' : 'off';

                    each(this.handlers, function (handler) {
                        handler[action]();
                    });
                }
            };

            module.exports = MediaQuery;
        }, { "3": 3, "4": 4 }], 2: [function (require, module, exports) {
            var MediaQuery = require(1);
            var Util = require(4);
            var each = Util.each;
            var isFunction = Util.isFunction;
            var isArray = Util.isArray;

            /**
             * Allows for registration of query handlers.
             * Manages the query handler's state and is responsible for wiring up browser events
             *
             * @constructor
             */
            function MediaQueryDispatch() {
                if (!window.matchMedia) {
                    throw new Error('matchMedia not present, legacy browsers require a polyfill');
                }

                this.queries = {};
                this.browserIsIncapable = !window.matchMedia('only all').matches;
            }

            MediaQueryDispatch.prototype = {

                constructor: MediaQueryDispatch,

                /**
                 * Registers a handler for the given media query
                 *
                 * @param {string} q the media query
                 * @param {object || Array || Function} options either a single query handler object, a function, or an array of query handlers
                 * @param {function} options.match fired when query matched
                 * @param {function} [options.unmatch] fired when a query is no longer matched
                 * @param {function} [options.setup] fired when handler first triggered
                 * @param {boolean} [options.deferSetup=false] whether setup should be run immediately or deferred until query is first matched
                 * @param {boolean} [shouldDegrade=false] whether this particular media query should always run on incapable browsers
                 */
                register: function register(q, options, shouldDegrade) {
                    var queries = this.queries,
                        isUnconditional = shouldDegrade && this.browserIsIncapable;

                    if (!queries[q]) {
                        queries[q] = new MediaQuery(q, isUnconditional);
                    }

                    //normalise to object in an array
                    if (isFunction(options)) {
                        options = { match: options };
                    }
                    if (!isArray(options)) {
                        options = [options];
                    }
                    each(options, function (handler) {
                        if (isFunction(handler)) {
                            handler = { match: handler };
                        }
                        queries[q].addHandler(handler);
                    });

                    return this;
                },

                /**
                 * unregisters a query and all it's handlers, or a specific handler for a query
                 *
                 * @param {string} q the media query to target
                 * @param {object || function} [handler] specific handler to unregister
                 */
                unregister: function unregister(q, handler) {
                    var query = this.queries[q];

                    if (query) {
                        if (handler) {
                            query.removeHandler(handler);
                        } else {
                            query.clear();
                            delete this.queries[q];
                        }
                    }

                    return this;
                }
            };

            module.exports = MediaQueryDispatch;
        }, { "1": 1, "4": 4 }], 3: [function (require, module, exports) {
            /**
             * Delegate to handle a media query being matched and unmatched.
             *
             * @param {object} options
             * @param {function} options.match callback for when the media query is matched
             * @param {function} [options.unmatch] callback for when the media query is unmatched
             * @param {function} [options.setup] one-time callback triggered the first time a query is matched
             * @param {boolean} [options.deferSetup=false] should the setup callback be run immediately, rather than first time query is matched?
             * @constructor
             */
            function QueryHandler(options) {
                this.options = options;
                !options.deferSetup && this.setup();
            }

            QueryHandler.prototype = {

                constructor: QueryHandler,

                /**
                 * coordinates setup of the handler
                 *
                 * @function
                 */
                setup: function setup() {
                    if (this.options.setup) {
                        this.options.setup();
                    }
                    this.initialised = true;
                },

                /**
                 * coordinates setup and triggering of the handler
                 *
                 * @function
                 */
                on: function on() {
                    !this.initialised && this.setup();
                    this.options.match && this.options.match();
                },

                /**
                 * coordinates the unmatch event for the handler
                 *
                 * @function
                 */
                off: function off() {
                    this.options.unmatch && this.options.unmatch();
                },

                /**
                 * called when a handler is to be destroyed.
                 * delegates to the destroy or unmatch callbacks, depending on availability.
                 *
                 * @function
                 */
                destroy: function destroy() {
                    this.options.destroy ? this.options.destroy() : this.off();
                },

                /**
                 * determines equality by reference.
                 * if object is supplied compare options, if function, compare match callback
                 *
                 * @function
                 * @param {object || function} [target] the target for comparison
                 */
                equals: function equals(target) {
                    return this.options === target || this.options.match === target;
                }

            };

            module.exports = QueryHandler;
        }, {}], 4: [function (require, module, exports) {
            /**
             * Helper function for iterating over a collection
             *
             * @param collection
             * @param fn
             */
            function each(collection, fn) {
                var i = 0,
                    length = collection.length,
                    cont;

                for (i; i < length; i++) {
                    cont = fn(collection[i], i);
                    if (cont === false) {
                        break; //allow early exit
                    }
                }
            }

            /**
             * Helper function for determining whether target object is an array
             *
             * @param target the object under test
             * @return {Boolean} true if array, false otherwise
             */
            function isArray(target) {
                return Object.prototype.toString.apply(target) === '[object Array]';
            }

            /**
             * Helper function for determining whether target object is a function
             *
             * @param target the object under test
             * @return {Boolean} true if function, false otherwise
             */
            function isFunction(target) {
                return typeof target === 'function';
            }

            module.exports = {
                isFunction: isFunction,
                isArray: isArray,
                each: each
            };
        }, {}], 5: [function (require, module, exports) {
            var MediaQueryDispatch = require(2);
            module.exports = new MediaQueryDispatch();
        }, { "2": 2 }] }, {}, [5])(5);
});

/***/ }),
/* 3 */,
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/*! DataTables 1.10.15
 * ©2008-2017 SpryMedia Ltd - datatables.net/license
 */

/**
 * @summary     DataTables
 * @description Paginate, search and order HTML tables
 * @version     1.10.15
 * @file        jquery.dataTables.js
 * @author      SpryMedia Ltd
 * @contact     www.datatables.net
 * @copyright   Copyright 2008-2017 SpryMedia Ltd.
 *
 * This source file is free software, available under the following license:
 *   MIT license - http://datatables.net/license
 *
 * This source file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
 *
 * For details please refer to: http://www.datatables.net
 */

/*jslint evil: true, undef: true, browser: true */
/*globals $,require,jQuery,define,_selector_run,_selector_opts,_selector_first,_selector_row_indexes,_ext,_Api,_api_register,_api_registerPlural,_re_new_lines,_re_html,_re_formatted_numeric,_re_escape_regex,_empty,_intVal,_numToDecimal,_isNumber,_isHtml,_htmlNumeric,_pluck,_pluck_order,_range,_stripHtml,_unique,_fnBuildAjax,_fnAjaxUpdate,_fnAjaxParameters,_fnAjaxUpdateDraw,_fnAjaxDataSrc,_fnAddColumn,_fnColumnOptions,_fnAdjustColumnSizing,_fnVisibleToColumnIndex,_fnColumnIndexToVisible,_fnVisbleColumns,_fnGetColumns,_fnColumnTypes,_fnApplyColumnDefs,_fnHungarianMap,_fnCamelToHungarian,_fnLanguageCompat,_fnBrowserDetect,_fnAddData,_fnAddTr,_fnNodeToDataIndex,_fnNodeToColumnIndex,_fnGetCellData,_fnSetCellData,_fnSplitObjNotation,_fnGetObjectDataFn,_fnSetObjectDataFn,_fnGetDataMaster,_fnClearTable,_fnDeleteIndex,_fnInvalidate,_fnGetRowElements,_fnCreateTr,_fnBuildHead,_fnDrawHead,_fnDraw,_fnReDraw,_fnAddOptionsHtml,_fnDetectHeader,_fnGetUniqueThs,_fnFeatureHtmlFilter,_fnFilterComplete,_fnFilterCustom,_fnFilterColumn,_fnFilter,_fnFilterCreateSearch,_fnEscapeRegex,_fnFilterData,_fnFeatureHtmlInfo,_fnUpdateInfo,_fnInfoMacros,_fnInitialise,_fnInitComplete,_fnLengthChange,_fnFeatureHtmlLength,_fnFeatureHtmlPaginate,_fnPageChange,_fnFeatureHtmlProcessing,_fnProcessingDisplay,_fnFeatureHtmlTable,_fnScrollDraw,_fnApplyToChildren,_fnCalculateColumnWidths,_fnThrottle,_fnConvertToWidth,_fnGetWidestNode,_fnGetMaxLenString,_fnStringToCss,_fnSortFlatten,_fnSort,_fnSortAria,_fnSortListener,_fnSortAttachListener,_fnSortingClasses,_fnSortData,_fnSaveState,_fnLoadState,_fnSettingsFromNode,_fnLog,_fnMap,_fnBindAction,_fnCallbackReg,_fnCallbackFire,_fnLengthOverflow,_fnRenderer,_fnDataSource,_fnRowAttributes*/

(function (factory) {
	"use strict";

	if (true) {
		// AMD
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(0)], __WEBPACK_AMD_DEFINE_RESULT__ = function ($) {
			return factory($, window, document);
		}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else if ((typeof exports === 'undefined' ? 'undefined' : _typeof(exports)) === 'object') {
		// CommonJS
		module.exports = function (root, $) {
			if (!root) {
				// CommonJS environments without a window global must pass a
				// root. This will give an error otherwise
				root = window;
			}

			if (!$) {
				$ = typeof window !== 'undefined' ? // jQuery's factory checks for a global window
				require('jquery') : require('jquery')(root);
			}

			return factory($, root, root.document);
		};
	} else {
		// Browser
		factory(jQuery, window, document);
	}
})(function ($, window, document, undefined) {
	"use strict";

	/**
  * DataTables is a plug-in for the jQuery Javascript library. It is a highly
  * flexible tool, based upon the foundations of progressive enhancement,
  * which will add advanced interaction controls to any HTML table. For a
  * full list of features please refer to
  * [DataTables.net](href="http://datatables.net).
  *
  * Note that the `DataTable` object is not a global variable but is aliased
  * to `jQuery.fn.DataTable` and `jQuery.fn.dataTable` through which it may
  * be  accessed.
  *
  *  @class
  *  @param {object} [init={}] Configuration object for DataTables. Options
  *    are defined by {@link DataTable.defaults}
  *  @requires jQuery 1.7+
  *
  *  @example
  *    // Basic initialisation
  *    $(document).ready( function {
  *      $('#example').dataTable();
  *    } );
  *
  *  @example
  *    // Initialisation with configuration options - in this case, disable
  *    // pagination and sorting.
  *    $(document).ready( function {
  *      $('#example').dataTable( {
  *        "paginate": false,
  *        "sort": false
  *      } );
  *    } );
  */

	var DataTable = function DataTable(options) {
		/**
   * Perform a jQuery selector action on the table's TR elements (from the tbody) and
   * return the resulting jQuery object.
   *  @param {string|node|jQuery} sSelector jQuery selector or node collection to act on
   *  @param {object} [oOpts] Optional parameters for modifying the rows to be included
   *  @param {string} [oOpts.filter=none] Select TR elements that meet the current filter
   *    criterion ("applied") or all TR elements (i.e. no filter).
   *  @param {string} [oOpts.order=current] Order of the TR elements in the processed array.
   *    Can be either 'current', whereby the current sorting of the table is used, or
   *    'original' whereby the original order the data was read into the table is used.
   *  @param {string} [oOpts.page=all] Limit the selection to the currently displayed page
   *    ("current") or not ("all"). If 'current' is given, then order is assumed to be
   *    'current' and filter is 'applied', regardless of what they might be given as.
   *  @returns {object} jQuery object, filtered by the given selector.
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *
   *      // Highlight every second row
   *      oTable.$('tr:odd').css('backgroundColor', 'blue');
   *    } );
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *
   *      // Filter to rows with 'Webkit' in them, add a background colour and then
   *      // remove the filter, thus highlighting the 'Webkit' rows only.
   *      oTable.fnFilter('Webkit');
   *      oTable.$('tr', {"search": "applied"}).css('backgroundColor', 'blue');
   *      oTable.fnFilter('');
   *    } );
   */
		this.$ = function (sSelector, oOpts) {
			return this.api(true).$(sSelector, oOpts);
		};

		/**
   * Almost identical to $ in operation, but in this case returns the data for the matched
   * rows - as such, the jQuery selector used should match TR row nodes or TD/TH cell nodes
   * rather than any descendants, so the data can be obtained for the row/cell. If matching
   * rows are found, the data returned is the original data array/object that was used to
   * create the row (or a generated array if from a DOM source).
   *
   * This method is often useful in-combination with $ where both functions are given the
   * same parameters and the array indexes will match identically.
   *  @param {string|node|jQuery} sSelector jQuery selector or node collection to act on
   *  @param {object} [oOpts] Optional parameters for modifying the rows to be included
   *  @param {string} [oOpts.filter=none] Select elements that meet the current filter
   *    criterion ("applied") or all elements (i.e. no filter).
   *  @param {string} [oOpts.order=current] Order of the data in the processed array.
   *    Can be either 'current', whereby the current sorting of the table is used, or
   *    'original' whereby the original order the data was read into the table is used.
   *  @param {string} [oOpts.page=all] Limit the selection to the currently displayed page
   *    ("current") or not ("all"). If 'current' is given, then order is assumed to be
   *    'current' and filter is 'applied', regardless of what they might be given as.
   *  @returns {array} Data for the matched elements. If any elements, as a result of the
   *    selector, were not TR, TD or TH elements in the DataTable, they will have a null
   *    entry in the array.
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *
   *      // Get the data from the first row in the table
   *      var data = oTable._('tr:first');
   *
   *      // Do something useful with the data
   *      alert( "First cell is: "+data[0] );
   *    } );
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *
   *      // Filter to 'Webkit' and get all data for
   *      oTable.fnFilter('Webkit');
   *      var data = oTable._('tr', {"search": "applied"});
   *
   *      // Do something with the data
   *      alert( data.length+" rows matched the search" );
   *    } );
   */
		this._ = function (sSelector, oOpts) {
			return this.api(true).rows(sSelector, oOpts).data();
		};

		/**
   * Create a DataTables Api instance, with the currently selected tables for
   * the Api's context.
   * @param {boolean} [traditional=false] Set the API instance's context to be
   *   only the table referred to by the `DataTable.ext.iApiIndex` option, as was
   *   used in the API presented by DataTables 1.9- (i.e. the traditional mode),
   *   or if all tables captured in the jQuery object should be used.
   * @return {DataTables.Api}
   */
		this.api = function (traditional) {
			return traditional ? new _Api2(_fnSettingsFromNode(this[_ext.iApiIndex])) : new _Api2(this);
		};

		/**
   * Add a single new row or multiple rows of data to the table. Please note
   * that this is suitable for client-side processing only - if you are using
   * server-side processing (i.e. "bServerSide": true), then to add data, you
   * must add it to the data source, i.e. the server-side, through an Ajax call.
   *  @param {array|object} data The data to be added to the table. This can be:
   *    <ul>
   *      <li>1D array of data - add a single row with the data provided</li>
   *      <li>2D array of arrays - add multiple rows in a single call</li>
   *      <li>object - data object when using <i>mData</i></li>
   *      <li>array of objects - multiple data objects when using <i>mData</i></li>
   *    </ul>
   *  @param {bool} [redraw=true] redraw the table or not
   *  @returns {array} An array of integers, representing the list of indexes in
   *    <i>aoData</i> ({@link DataTable.models.oSettings}) that have been added to
   *    the table.
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    // Global var for counter
   *    var giCount = 2;
   *
   *    $(document).ready(function() {
   *      $('#example').dataTable();
   *    } );
   *
   *    function fnClickAddRow() {
   *      $('#example').dataTable().fnAddData( [
   *        giCount+".1",
   *        giCount+".2",
   *        giCount+".3",
   *        giCount+".4" ]
   *      );
   *
   *      giCount++;
   *    }
   */
		this.fnAddData = function (data, redraw) {
			var api = this.api(true);

			/* Check if we want to add multiple rows or not */
			var rows = $.isArray(data) && ($.isArray(data[0]) || $.isPlainObject(data[0])) ? api.rows.add(data) : api.row.add(data);

			if (redraw === undefined || redraw) {
				api.draw();
			}

			return rows.flatten().toArray();
		};

		/**
   * This function will make DataTables recalculate the column sizes, based on the data
   * contained in the table and the sizes applied to the columns (in the DOM, CSS or
   * through the sWidth parameter). This can be useful when the width of the table's
   * parent element changes (for example a window resize).
   *  @param {boolean} [bRedraw=true] Redraw the table or not, you will typically want to
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable( {
   *        "sScrollY": "200px",
   *        "bPaginate": false
   *      } );
   *
   *      $(window).on('resize', function () {
   *        oTable.fnAdjustColumnSizing();
   *      } );
   *    } );
   */
		this.fnAdjustColumnSizing = function (bRedraw) {
			var api = this.api(true).columns.adjust();
			var settings = api.settings()[0];
			var scroll = settings.oScroll;

			if (bRedraw === undefined || bRedraw) {
				api.draw(false);
			} else if (scroll.sX !== "" || scroll.sY !== "") {
				/* If not redrawing, but scrolling, we want to apply the new column sizes anyway */
				_fnScrollDraw(settings);
			}
		};

		/**
   * Quickly and simply clear a table
   *  @param {bool} [bRedraw=true] redraw the table or not
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *
   *      // Immediately 'nuke' the current rows (perhaps waiting for an Ajax callback...)
   *      oTable.fnClearTable();
   *    } );
   */
		this.fnClearTable = function (bRedraw) {
			var api = this.api(true).clear();

			if (bRedraw === undefined || bRedraw) {
				api.draw();
			}
		};

		/**
   * The exact opposite of 'opening' a row, this function will close any rows which
   * are currently 'open'.
   *  @param {node} nTr the table row to 'close'
   *  @returns {int} 0 on success, or 1 if failed (can't find the row)
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable;
   *
   *      // 'open' an information row when a row is clicked on
   *      $('#example tbody tr').click( function () {
   *        if ( oTable.fnIsOpen(this) ) {
   *          oTable.fnClose( this );
   *        } else {
   *          oTable.fnOpen( this, "Temporary row opened", "info_row" );
   *        }
   *      } );
   *
   *      oTable = $('#example').dataTable();
   *    } );
   */
		this.fnClose = function (nTr) {
			this.api(true).row(nTr).child.hide();
		};

		/**
   * Remove a row for the table
   *  @param {mixed} target The index of the row from aoData to be deleted, or
   *    the TR element you want to delete
   *  @param {function|null} [callBack] Callback function
   *  @param {bool} [redraw=true] Redraw the table or not
   *  @returns {array} The row that was deleted
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *
   *      // Immediately remove the first row
   *      oTable.fnDeleteRow( 0 );
   *    } );
   */
		this.fnDeleteRow = function (target, callback, redraw) {
			var api = this.api(true);
			var rows = api.rows(target);
			var settings = rows.settings()[0];
			var data = settings.aoData[rows[0][0]];

			rows.remove();

			if (callback) {
				callback.call(this, settings, data);
			}

			if (redraw === undefined || redraw) {
				api.draw();
			}

			return data;
		};

		/**
   * Restore the table to it's original state in the DOM by removing all of DataTables
   * enhancements, alterations to the DOM structure of the table and event listeners.
   *  @param {boolean} [remove=false] Completely remove the table from the DOM
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      // This example is fairly pointless in reality, but shows how fnDestroy can be used
   *      var oTable = $('#example').dataTable();
   *      oTable.fnDestroy();
   *    } );
   */
		this.fnDestroy = function (remove) {
			this.api(true).destroy(remove);
		};

		/**
   * Redraw the table
   *  @param {bool} [complete=true] Re-filter and resort (if enabled) the table before the draw.
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *
   *      // Re-draw the table - you wouldn't want to do it here, but it's an example :-)
   *      oTable.fnDraw();
   *    } );
   */
		this.fnDraw = function (complete) {
			// Note that this isn't an exact match to the old call to _fnDraw - it takes
			// into account the new data, but can hold position.
			this.api(true).draw(complete);
		};

		/**
   * Filter the input based on data
   *  @param {string} sInput String to filter the table on
   *  @param {int|null} [iColumn] Column to limit filtering to
   *  @param {bool} [bRegex=false] Treat as regular expression or not
   *  @param {bool} [bSmart=true] Perform smart filtering or not
   *  @param {bool} [bShowGlobal=true] Show the input global filter in it's input box(es)
   *  @param {bool} [bCaseInsensitive=true] Do case-insensitive matching (true) or not (false)
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *
   *      // Sometime later - filter...
   *      oTable.fnFilter( 'test string' );
   *    } );
   */
		this.fnFilter = function (sInput, iColumn, bRegex, bSmart, bShowGlobal, bCaseInsensitive) {
			var api = this.api(true);

			if (iColumn === null || iColumn === undefined) {
				api.search(sInput, bRegex, bSmart, bCaseInsensitive);
			} else {
				api.column(iColumn).search(sInput, bRegex, bSmart, bCaseInsensitive);
			}

			api.draw();
		};

		/**
   * Get the data for the whole table, an individual row or an individual cell based on the
   * provided parameters.
   *  @param {int|node} [src] A TR row node, TD/TH cell node or an integer. If given as
   *    a TR node then the data source for the whole row will be returned. If given as a
   *    TD/TH cell node then iCol will be automatically calculated and the data for the
   *    cell returned. If given as an integer, then this is treated as the aoData internal
   *    data index for the row (see fnGetPosition) and the data for that row used.
   *  @param {int} [col] Optional column index that you want the data of.
   *  @returns {array|object|string} If mRow is undefined, then the data for all rows is
   *    returned. If mRow is defined, just data for that row, and is iCol is
   *    defined, only data for the designated cell is returned.
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    // Row data
   *    $(document).ready(function() {
   *      oTable = $('#example').dataTable();
   *
   *      oTable.$('tr').click( function () {
   *        var data = oTable.fnGetData( this );
   *        // ... do something with the array / object of data for the row
   *      } );
   *    } );
   *
   *  @example
   *    // Individual cell data
   *    $(document).ready(function() {
   *      oTable = $('#example').dataTable();
   *
   *      oTable.$('td').click( function () {
   *        var sData = oTable.fnGetData( this );
   *        alert( 'The cell clicked on had the value of '+sData );
   *      } );
   *    } );
   */
		this.fnGetData = function (src, col) {
			var api = this.api(true);

			if (src !== undefined) {
				var type = src.nodeName ? src.nodeName.toLowerCase() : '';

				return col !== undefined || type == 'td' || type == 'th' ? api.cell(src, col).data() : api.row(src).data() || null;
			}

			return api.data().toArray();
		};

		/**
   * Get an array of the TR nodes that are used in the table's body. Note that you will
   * typically want to use the '$' API method in preference to this as it is more
   * flexible.
   *  @param {int} [iRow] Optional row index for the TR element you want
   *  @returns {array|node} If iRow is undefined, returns an array of all TR elements
   *    in the table's body, or iRow is defined, just the TR element requested.
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *
   *      // Get the nodes from the table
   *      var nNodes = oTable.fnGetNodes( );
   *    } );
   */
		this.fnGetNodes = function (iRow) {
			var api = this.api(true);

			return iRow !== undefined ? api.row(iRow).node() : api.rows().nodes().flatten().toArray();
		};

		/**
   * Get the array indexes of a particular cell from it's DOM element
   * and column index including hidden columns
   *  @param {node} node this can either be a TR, TD or TH in the table's body
   *  @returns {int} If nNode is given as a TR, then a single index is returned, or
   *    if given as a cell, an array of [row index, column index (visible),
   *    column index (all)] is given.
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      $('#example tbody td').click( function () {
   *        // Get the position of the current data from the node
   *        var aPos = oTable.fnGetPosition( this );
   *
   *        // Get the data array for this row
   *        var aData = oTable.fnGetData( aPos[0] );
   *
   *        // Update the data array and return the value
   *        aData[ aPos[1] ] = 'clicked';
   *        this.innerHTML = 'clicked';
   *      } );
   *
   *      // Init DataTables
   *      oTable = $('#example').dataTable();
   *    } );
   */
		this.fnGetPosition = function (node) {
			var api = this.api(true);
			var nodeName = node.nodeName.toUpperCase();

			if (nodeName == 'TR') {
				return api.row(node).index();
			} else if (nodeName == 'TD' || nodeName == 'TH') {
				var cell = api.cell(node).index();

				return [cell.row, cell.columnVisible, cell.column];
			}
			return null;
		};

		/**
   * Check to see if a row is 'open' or not.
   *  @param {node} nTr the table row to check
   *  @returns {boolean} true if the row is currently open, false otherwise
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable;
   *
   *      // 'open' an information row when a row is clicked on
   *      $('#example tbody tr').click( function () {
   *        if ( oTable.fnIsOpen(this) ) {
   *          oTable.fnClose( this );
   *        } else {
   *          oTable.fnOpen( this, "Temporary row opened", "info_row" );
   *        }
   *      } );
   *
   *      oTable = $('#example').dataTable();
   *    } );
   */
		this.fnIsOpen = function (nTr) {
			return this.api(true).row(nTr).child.isShown();
		};

		/**
   * This function will place a new row directly after a row which is currently
   * on display on the page, with the HTML contents that is passed into the
   * function. This can be used, for example, to ask for confirmation that a
   * particular record should be deleted.
   *  @param {node} nTr The table row to 'open'
   *  @param {string|node|jQuery} mHtml The HTML to put into the row
   *  @param {string} sClass Class to give the new TD cell
   *  @returns {node} The row opened. Note that if the table row passed in as the
   *    first parameter, is not found in the table, this method will silently
   *    return.
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable;
   *
   *      // 'open' an information row when a row is clicked on
   *      $('#example tbody tr').click( function () {
   *        if ( oTable.fnIsOpen(this) ) {
   *          oTable.fnClose( this );
   *        } else {
   *          oTable.fnOpen( this, "Temporary row opened", "info_row" );
   *        }
   *      } );
   *
   *      oTable = $('#example').dataTable();
   *    } );
   */
		this.fnOpen = function (nTr, mHtml, sClass) {
			return this.api(true).row(nTr).child(mHtml, sClass).show().child()[0];
		};

		/**
   * Change the pagination - provides the internal logic for pagination in a simple API
   * function. With this function you can have a DataTables table go to the next,
   * previous, first or last pages.
   *  @param {string|int} mAction Paging action to take: "first", "previous", "next" or "last"
   *    or page number to jump to (integer), note that page 0 is the first page.
   *  @param {bool} [bRedraw=true] Redraw the table or not
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *      oTable.fnPageChange( 'next' );
   *    } );
   */
		this.fnPageChange = function (mAction, bRedraw) {
			var api = this.api(true).page(mAction);

			if (bRedraw === undefined || bRedraw) {
				api.draw(false);
			}
		};

		/**
   * Show a particular column
   *  @param {int} iCol The column whose display should be changed
   *  @param {bool} bShow Show (true) or hide (false) the column
   *  @param {bool} [bRedraw=true] Redraw the table or not
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *
   *      // Hide the second column after initialisation
   *      oTable.fnSetColumnVis( 1, false );
   *    } );
   */
		this.fnSetColumnVis = function (iCol, bShow, bRedraw) {
			var api = this.api(true).column(iCol).visible(bShow);

			if (bRedraw === undefined || bRedraw) {
				api.columns.adjust().draw();
			}
		};

		/**
   * Get the settings for a particular table for external manipulation
   *  @returns {object} DataTables settings object. See
   *    {@link DataTable.models.oSettings}
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *      var oSettings = oTable.fnSettings();
   *
   *      // Show an example parameter from the settings
   *      alert( oSettings._iDisplayStart );
   *    } );
   */
		this.fnSettings = function () {
			return _fnSettingsFromNode(this[_ext.iApiIndex]);
		};

		/**
   * Sort the table by a particular column
   *  @param {int} iCol the data index to sort on. Note that this will not match the
   *    'display index' if you have hidden data entries
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *
   *      // Sort immediately with columns 0 and 1
   *      oTable.fnSort( [ [0,'asc'], [1,'asc'] ] );
   *    } );
   */
		this.fnSort = function (aaSort) {
			this.api(true).order(aaSort).draw();
		};

		/**
   * Attach a sort listener to an element for a given column
   *  @param {node} nNode the element to attach the sort listener to
   *  @param {int} iColumn the column that a click on this node will sort on
   *  @param {function} [fnCallback] callback function when sort is run
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *
   *      // Sort on column 1, when 'sorter' is clicked on
   *      oTable.fnSortListener( document.getElementById('sorter'), 1 );
   *    } );
   */
		this.fnSortListener = function (nNode, iColumn, fnCallback) {
			this.api(true).order.listener(nNode, iColumn, fnCallback);
		};

		/**
   * Update a table cell or row - this method will accept either a single value to
   * update the cell with, an array of values with one element for each column or
   * an object in the same format as the original data source. The function is
   * self-referencing in order to make the multi column updates easier.
   *  @param {object|array|string} mData Data to update the cell/row with
   *  @param {node|int} mRow TR element you want to update or the aoData index
   *  @param {int} [iColumn] The column to update, give as null or undefined to
   *    update a whole row.
   *  @param {bool} [bRedraw=true] Redraw the table or not
   *  @param {bool} [bAction=true] Perform pre-draw actions or not
   *  @returns {int} 0 on success, 1 on error
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *      oTable.fnUpdate( 'Example update', 0, 0 ); // Single cell
   *      oTable.fnUpdate( ['a', 'b', 'c', 'd', 'e'], $('tbody tr')[0] ); // Row
   *    } );
   */
		this.fnUpdate = function (mData, mRow, iColumn, bRedraw, bAction) {
			var api = this.api(true);

			if (iColumn === undefined || iColumn === null) {
				api.row(mRow).data(mData);
			} else {
				api.cell(mRow, iColumn).data(mData);
			}

			if (bAction === undefined || bAction) {
				api.columns.adjust();
			}

			if (bRedraw === undefined || bRedraw) {
				api.draw();
			}
			return 0;
		};

		/**
   * Provide a common method for plug-ins to check the version of DataTables being used, in order
   * to ensure compatibility.
   *  @param {string} sVersion Version string to check for, in the format "X.Y.Z". Note that the
   *    formats "X" and "X.Y" are also acceptable.
   *  @returns {boolean} true if this version of DataTables is greater or equal to the required
   *    version, or false if this version of DataTales is not suitable
   *  @method
   *  @dtopt API
   *  @deprecated Since v1.10
   *
   *  @example
   *    $(document).ready(function() {
   *      var oTable = $('#example').dataTable();
   *      alert( oTable.fnVersionCheck( '1.9.0' ) );
   *    } );
   */
		this.fnVersionCheck = _ext.fnVersionCheck;

		var _that = this;
		var emptyInit = options === undefined;
		var len = this.length;

		if (emptyInit) {
			options = {};
		}

		this.oApi = this.internal = _ext.internal;

		// Extend with old style plug-in API methods
		for (var fn in DataTable.ext.internal) {
			if (fn) {
				this[fn] = _fnExternApiFunc(fn);
			}
		}

		this.each(function () {
			// For each initialisation we want to give it a clean initialisation
			// object that can be bashed around
			var o = {};
			var oInit = len > 1 ? // optimisation for single table case
			_fnExtend(o, options, true) : options;

			/*global oInit,_that,emptyInit*/
			var i = 0,
			    iLen,
			    j,
			    jLen,
			    k,
			    kLen;
			var sId = this.getAttribute('id');
			var bInitHandedOff = false;
			var defaults = DataTable.defaults;
			var $this = $(this);

			/* Sanity check */
			if (this.nodeName.toLowerCase() != 'table') {
				_fnLog(null, 0, 'Non-table node initialisation (' + this.nodeName + ')', 2);
				return;
			}

			/* Backwards compatibility for the defaults */
			_fnCompatOpts(defaults);
			_fnCompatCols(defaults.column);

			/* Convert the camel-case defaults to Hungarian */
			_fnCamelToHungarian(defaults, defaults, true);
			_fnCamelToHungarian(defaults.column, defaults.column, true);

			/* Setting up the initialisation object */
			_fnCamelToHungarian(defaults, $.extend(oInit, $this.data()));

			/* Check to see if we are re-initialising a table */
			var allSettings = DataTable.settings;
			for (i = 0, iLen = allSettings.length; i < iLen; i++) {
				var s = allSettings[i];

				/* Base check on table node */
				if (s.nTable == this || s.nTHead.parentNode == this || s.nTFoot && s.nTFoot.parentNode == this) {
					var bRetrieve = oInit.bRetrieve !== undefined ? oInit.bRetrieve : defaults.bRetrieve;
					var bDestroy = oInit.bDestroy !== undefined ? oInit.bDestroy : defaults.bDestroy;

					if (emptyInit || bRetrieve) {
						return s.oInstance;
					} else if (bDestroy) {
						s.oInstance.fnDestroy();
						break;
					} else {
						_fnLog(s, 0, 'Cannot reinitialise DataTable', 3);
						return;
					}
				}

				/* If the element we are initialising has the same ID as a table which was previously
     * initialised, but the table nodes don't match (from before) then we destroy the old
     * instance by simply deleting it. This is under the assumption that the table has been
     * destroyed by other methods. Anyone using non-id selectors will need to do this manually
     */
				if (s.sTableId == this.id) {
					allSettings.splice(i, 1);
					break;
				}
			}

			/* Ensure the table has an ID - required for accessibility */
			if (sId === null || sId === "") {
				sId = "DataTables_Table_" + DataTable.ext._unique++;
				this.id = sId;
			}

			/* Create the settings object for this table and set some of the default parameters */
			var oSettings = $.extend(true, {}, DataTable.models.oSettings, {
				"sDestroyWidth": $this[0].style.width,
				"sInstance": sId,
				"sTableId": sId
			});
			oSettings.nTable = this;
			oSettings.oApi = _that.internal;
			oSettings.oInit = oInit;

			allSettings.push(oSettings);

			// Need to add the instance after the instance after the settings object has been added
			// to the settings array, so we can self reference the table instance if more than one
			oSettings.oInstance = _that.length === 1 ? _that : $this.dataTable();

			// Backwards compatibility, before we apply all the defaults
			_fnCompatOpts(oInit);

			if (oInit.oLanguage) {
				_fnLanguageCompat(oInit.oLanguage);
			}

			// If the length menu is given, but the init display length is not, use the length menu
			if (oInit.aLengthMenu && !oInit.iDisplayLength) {
				oInit.iDisplayLength = $.isArray(oInit.aLengthMenu[0]) ? oInit.aLengthMenu[0][0] : oInit.aLengthMenu[0];
			}

			// Apply the defaults and init options to make a single init object will all
			// options defined from defaults and instance options.
			oInit = _fnExtend($.extend(true, {}, defaults), oInit);

			// Map the initialisation options onto the settings object
			_fnMap(oSettings.oFeatures, oInit, ["bPaginate", "bLengthChange", "bFilter", "bSort", "bSortMulti", "bInfo", "bProcessing", "bAutoWidth", "bSortClasses", "bServerSide", "bDeferRender"]);
			_fnMap(oSettings, oInit, ["asStripeClasses", "ajax", "fnServerData", "fnFormatNumber", "sServerMethod", "aaSorting", "aaSortingFixed", "aLengthMenu", "sPaginationType", "sAjaxSource", "sAjaxDataProp", "iStateDuration", "sDom", "bSortCellsTop", "iTabIndex", "fnStateLoadCallback", "fnStateSaveCallback", "renderer", "searchDelay", "rowId", ["iCookieDuration", "iStateDuration"], // backwards compat
			["oSearch", "oPreviousSearch"], ["aoSearchCols", "aoPreSearchCols"], ["iDisplayLength", "_iDisplayLength"], ["bJQueryUI", "bJUI"]]);
			_fnMap(oSettings.oScroll, oInit, [["sScrollX", "sX"], ["sScrollXInner", "sXInner"], ["sScrollY", "sY"], ["bScrollCollapse", "bCollapse"]]);
			_fnMap(oSettings.oLanguage, oInit, "fnInfoCallback");

			/* Callback functions which are array driven */
			_fnCallbackReg(oSettings, 'aoDrawCallback', oInit.fnDrawCallback, 'user');
			_fnCallbackReg(oSettings, 'aoServerParams', oInit.fnServerParams, 'user');
			_fnCallbackReg(oSettings, 'aoStateSaveParams', oInit.fnStateSaveParams, 'user');
			_fnCallbackReg(oSettings, 'aoStateLoadParams', oInit.fnStateLoadParams, 'user');
			_fnCallbackReg(oSettings, 'aoStateLoaded', oInit.fnStateLoaded, 'user');
			_fnCallbackReg(oSettings, 'aoRowCallback', oInit.fnRowCallback, 'user');
			_fnCallbackReg(oSettings, 'aoRowCreatedCallback', oInit.fnCreatedRow, 'user');
			_fnCallbackReg(oSettings, 'aoHeaderCallback', oInit.fnHeaderCallback, 'user');
			_fnCallbackReg(oSettings, 'aoFooterCallback', oInit.fnFooterCallback, 'user');
			_fnCallbackReg(oSettings, 'aoInitComplete', oInit.fnInitComplete, 'user');
			_fnCallbackReg(oSettings, 'aoPreDrawCallback', oInit.fnPreDrawCallback, 'user');

			oSettings.rowIdFn = _fnGetObjectDataFn(oInit.rowId);

			/* Browser support detection */
			_fnBrowserDetect(oSettings);

			var oClasses = oSettings.oClasses;

			// @todo Remove in 1.11
			if (oInit.bJQueryUI) {
				/* Use the JUI classes object for display. You could clone the oStdClasses object if
     * you want to have multiple tables with multiple independent classes
     */
				$.extend(oClasses, DataTable.ext.oJUIClasses, oInit.oClasses);

				if (oInit.sDom === defaults.sDom && defaults.sDom === "lfrtip") {
					/* Set the DOM to use a layout suitable for jQuery UI's theming */
					oSettings.sDom = '<"H"lfr>t<"F"ip>';
				}

				if (!oSettings.renderer) {
					oSettings.renderer = 'jqueryui';
				} else if ($.isPlainObject(oSettings.renderer) && !oSettings.renderer.header) {
					oSettings.renderer.header = 'jqueryui';
				}
			} else {
				$.extend(oClasses, DataTable.ext.classes, oInit.oClasses);
			}
			$this.addClass(oClasses.sTable);

			if (oSettings.iInitDisplayStart === undefined) {
				/* Display start point, taking into account the save saving */
				oSettings.iInitDisplayStart = oInit.iDisplayStart;
				oSettings._iDisplayStart = oInit.iDisplayStart;
			}

			if (oInit.iDeferLoading !== null) {
				oSettings.bDeferLoading = true;
				var tmp = $.isArray(oInit.iDeferLoading);
				oSettings._iRecordsDisplay = tmp ? oInit.iDeferLoading[0] : oInit.iDeferLoading;
				oSettings._iRecordsTotal = tmp ? oInit.iDeferLoading[1] : oInit.iDeferLoading;
			}

			/* Language definitions */
			var oLanguage = oSettings.oLanguage;
			$.extend(true, oLanguage, oInit.oLanguage);

			if (oLanguage.sUrl) {
				/* Get the language definitions from a file - because this Ajax call makes the language
     * get async to the remainder of this function we use bInitHandedOff to indicate that
     * _fnInitialise will be fired by the returned Ajax handler, rather than the constructor
     */
				$.ajax({
					dataType: 'json',
					url: oLanguage.sUrl,
					success: function success(json) {
						_fnLanguageCompat(json);
						_fnCamelToHungarian(defaults.oLanguage, json);
						$.extend(true, oLanguage, json);
						_fnInitialise(oSettings);
					},
					error: function error() {
						// Error occurred loading language file, continue on as best we can
						_fnInitialise(oSettings);
					}
				});
				bInitHandedOff = true;
			}

			/*
    * Stripes
    */
			if (oInit.asStripeClasses === null) {
				oSettings.asStripeClasses = [oClasses.sStripeOdd, oClasses.sStripeEven];
			}

			/* Remove row stripe classes if they are already on the table row */
			var stripeClasses = oSettings.asStripeClasses;
			var rowOne = $this.children('tbody').find('tr').eq(0);
			if ($.inArray(true, $.map(stripeClasses, function (el, i) {
				return rowOne.hasClass(el);
			})) !== -1) {
				$('tbody tr', this).removeClass(stripeClasses.join(' '));
				oSettings.asDestroyStripes = stripeClasses.slice();
			}

			/*
    * Columns
    * See if we should load columns automatically or use defined ones
    */
			var anThs = [];
			var aoColumnsInit;
			var nThead = this.getElementsByTagName('thead');
			if (nThead.length !== 0) {
				_fnDetectHeader(oSettings.aoHeader, nThead[0]);
				anThs = _fnGetUniqueThs(oSettings);
			}

			/* If not given a column array, generate one with nulls */
			if (oInit.aoColumns === null) {
				aoColumnsInit = [];
				for (i = 0, iLen = anThs.length; i < iLen; i++) {
					aoColumnsInit.push(null);
				}
			} else {
				aoColumnsInit = oInit.aoColumns;
			}

			/* Add the columns */
			for (i = 0, iLen = aoColumnsInit.length; i < iLen; i++) {
				_fnAddColumn(oSettings, anThs ? anThs[i] : null);
			}

			/* Apply the column definitions */
			_fnApplyColumnDefs(oSettings, oInit.aoColumnDefs, aoColumnsInit, function (iCol, oDef) {
				_fnColumnOptions(oSettings, iCol, oDef);
			});

			/* HTML5 attribute detection - build an mData object automatically if the
    * attributes are found
    */
			if (rowOne.length) {
				var a = function a(cell, name) {
					return cell.getAttribute('data-' + name) !== null ? name : null;
				};

				$(rowOne[0]).children('th, td').each(function (i, cell) {
					var col = oSettings.aoColumns[i];

					if (col.mData === i) {
						var sort = a(cell, 'sort') || a(cell, 'order');
						var filter = a(cell, 'filter') || a(cell, 'search');

						if (sort !== null || filter !== null) {
							col.mData = {
								_: i + '.display',
								sort: sort !== null ? i + '.@data-' + sort : undefined,
								type: sort !== null ? i + '.@data-' + sort : undefined,
								filter: filter !== null ? i + '.@data-' + filter : undefined
							};

							_fnColumnOptions(oSettings, i);
						}
					}
				});
			}

			var features = oSettings.oFeatures;
			var loadedInit = function loadedInit() {
				/*
     * Sorting
     * @todo For modularisation (1.11) this needs to do into a sort start up handler
     */

				// If aaSorting is not defined, then we use the first indicator in asSorting
				// in case that has been altered, so the default sort reflects that option
				if (oInit.aaSorting === undefined) {
					var sorting = oSettings.aaSorting;
					for (i = 0, iLen = sorting.length; i < iLen; i++) {
						sorting[i][1] = oSettings.aoColumns[i].asSorting[0];
					}
				}

				/* Do a first pass on the sorting classes (allows any size changes to be taken into
     * account, and also will apply sorting disabled classes if disabled
     */
				_fnSortingClasses(oSettings);

				if (features.bSort) {
					_fnCallbackReg(oSettings, 'aoDrawCallback', function () {
						if (oSettings.bSorted) {
							var aSort = _fnSortFlatten(oSettings);
							var sortedColumns = {};

							$.each(aSort, function (i, val) {
								sortedColumns[val.src] = val.dir;
							});

							_fnCallbackFire(oSettings, null, 'order', [oSettings, aSort, sortedColumns]);
							_fnSortAria(oSettings);
						}
					});
				}

				_fnCallbackReg(oSettings, 'aoDrawCallback', function () {
					if (oSettings.bSorted || _fnDataSource(oSettings) === 'ssp' || features.bDeferRender) {
						_fnSortingClasses(oSettings);
					}
				}, 'sc');

				/*
     * Final init
     * Cache the header, body and footer as required, creating them if needed
     */

				// Work around for Webkit bug 83867 - store the caption-side before removing from doc
				var captions = $this.children('caption').each(function () {
					this._captionSide = $(this).css('caption-side');
				});

				var thead = $this.children('thead');
				if (thead.length === 0) {
					thead = $('<thead/>').appendTo($this);
				}
				oSettings.nTHead = thead[0];

				var tbody = $this.children('tbody');
				if (tbody.length === 0) {
					tbody = $('<tbody/>').appendTo($this);
				}
				oSettings.nTBody = tbody[0];

				var tfoot = $this.children('tfoot');
				if (tfoot.length === 0 && captions.length > 0 && (oSettings.oScroll.sX !== "" || oSettings.oScroll.sY !== "")) {
					// If we are a scrolling table, and no footer has been given, then we need to create
					// a tfoot element for the caption element to be appended to
					tfoot = $('<tfoot/>').appendTo($this);
				}

				if (tfoot.length === 0 || tfoot.children().length === 0) {
					$this.addClass(oClasses.sNoFooter);
				} else if (tfoot.length > 0) {
					oSettings.nTFoot = tfoot[0];
					_fnDetectHeader(oSettings.aoFooter, oSettings.nTFoot);
				}

				/* Check if there is data passing into the constructor */
				if (oInit.aaData) {
					for (i = 0; i < oInit.aaData.length; i++) {
						_fnAddData(oSettings, oInit.aaData[i]);
					}
				} else if (oSettings.bDeferLoading || _fnDataSource(oSettings) == 'dom') {
					/* Grab the data from the page - only do this when deferred loading or no Ajax
      * source since there is no point in reading the DOM data if we are then going
      * to replace it with Ajax data
      */
					_fnAddTr(oSettings, $(oSettings.nTBody).children('tr'));
				}

				/* Copy the data index array */
				oSettings.aiDisplay = oSettings.aiDisplayMaster.slice();

				/* Initialisation complete - table can be drawn */
				oSettings.bInitialised = true;

				/* Check if we need to initialise the table (it might not have been handed off to the
     * language processor)
     */
				if (bInitHandedOff === false) {
					_fnInitialise(oSettings);
				}
			};

			/* Must be done after everything which can be overridden by the state saving! */
			if (oInit.bStateSave) {
				features.bStateSave = true;
				_fnCallbackReg(oSettings, 'aoDrawCallback', _fnSaveState, 'state_save');
				_fnLoadState(oSettings, oInit, loadedInit);
			} else {
				loadedInit();
			}
		});
		_that = null;
		return this;
	};

	/*
  * It is useful to have variables which are scoped locally so only the
  * DataTables functions can access them and they don't leak into global space.
  * At the same time these functions are often useful over multiple files in the
  * core and API, so we list, or at least document, all variables which are used
  * by DataTables as private variables here. This also ensures that there is no
  * clashing of variable names and that they can easily referenced for reuse.
  */

	// Defined else where
	//  _selector_run
	//  _selector_opts
	//  _selector_first
	//  _selector_row_indexes

	var _ext; // DataTable.ext
	var _Api2; // DataTable.Api
	var _api_register; // DataTable.Api.register
	var _api_registerPlural; // DataTable.Api.registerPlural

	var _re_dic = {};
	var _re_new_lines = /[\r\n]/g;
	var _re_html = /<.*?>/g;

	// This is not strict ISO8601 - Date.parse() is quite lax, although
	// implementations differ between browsers.
	var _re_date = /^\d{2,4}[\.\/\-]\d{1,2}[\.\/\-]\d{1,2}([T ]{1}\d{1,2}[:\.]\d{2}([\.:]\d{2})?)?$/;

	// Escape regular expression special characters
	var _re_escape_regex = new RegExp('(\\' + ['/', '.', '*', '+', '?', '|', '(', ')', '[', ']', '{', '}', '\\', '$', '^', '-'].join('|\\') + ')', 'g');

	// http://en.wikipedia.org/wiki/Foreign_exchange_market
	// - \u20BD - Russian ruble.
	// - \u20a9 - South Korean Won
	// - \u20BA - Turkish Lira
	// - \u20B9 - Indian Rupee
	// - R - Brazil (R$) and South Africa
	// - fr - Swiss Franc
	// - kr - Swedish krona, Norwegian krone and Danish krone
	// - \u2009 is thin space and \u202F is narrow no-break space, both used in many
	//   standards as thousands separators.
	var _re_formatted_numeric = /[',$£€¥%\u2009\u202F\u20BD\u20a9\u20BArfk]/gi;

	var _empty = function _empty(d) {
		return !d || d === true || d === '-' ? true : false;
	};

	var _intVal = function _intVal(s) {
		var integer = parseInt(s, 10);
		return !isNaN(integer) && isFinite(s) ? integer : null;
	};

	// Convert from a formatted number with characters other than `.` as the
	// decimal place, to a Javascript number
	var _numToDecimal = function _numToDecimal(num, decimalPoint) {
		// Cache created regular expressions for speed as this function is called often
		if (!_re_dic[decimalPoint]) {
			_re_dic[decimalPoint] = new RegExp(_fnEscapeRegex(decimalPoint), 'g');
		}
		return typeof num === 'string' && decimalPoint !== '.' ? num.replace(/\./g, '').replace(_re_dic[decimalPoint], '.') : num;
	};

	var _isNumber = function _isNumber(d, decimalPoint, formatted) {
		var strType = typeof d === 'string';

		// If empty return immediately so there must be a number if it is a
		// formatted string (this stops the string "k", or "kr", etc being detected
		// as a formatted number for currency
		if (_empty(d)) {
			return true;
		}

		if (decimalPoint && strType) {
			d = _numToDecimal(d, decimalPoint);
		}

		if (formatted && strType) {
			d = d.replace(_re_formatted_numeric, '');
		}

		return !isNaN(parseFloat(d)) && isFinite(d);
	};

	// A string without HTML in it can be considered to be HTML still
	var _isHtml = function _isHtml(d) {
		return _empty(d) || typeof d === 'string';
	};

	var _htmlNumeric = function _htmlNumeric(d, decimalPoint, formatted) {
		if (_empty(d)) {
			return true;
		}

		var html = _isHtml(d);
		return !html ? null : _isNumber(_stripHtml(d), decimalPoint, formatted) ? true : null;
	};

	var _pluck = function _pluck(a, prop, prop2) {
		var out = [];
		var i = 0,
		    ien = a.length;

		// Could have the test in the loop for slightly smaller code, but speed
		// is essential here
		if (prop2 !== undefined) {
			for (; i < ien; i++) {
				if (a[i] && a[i][prop]) {
					out.push(a[i][prop][prop2]);
				}
			}
		} else {
			for (; i < ien; i++) {
				if (a[i]) {
					out.push(a[i][prop]);
				}
			}
		}

		return out;
	};

	// Basically the same as _pluck, but rather than looping over `a` we use `order`
	// as the indexes to pick from `a`
	var _pluck_order = function _pluck_order(a, order, prop, prop2) {
		var out = [];
		var i = 0,
		    ien = order.length;

		// Could have the test in the loop for slightly smaller code, but speed
		// is essential here
		if (prop2 !== undefined) {
			for (; i < ien; i++) {
				if (a[order[i]][prop]) {
					out.push(a[order[i]][prop][prop2]);
				}
			}
		} else {
			for (; i < ien; i++) {
				out.push(a[order[i]][prop]);
			}
		}

		return out;
	};

	var _range = function _range(len, start) {
		var out = [];
		var end;

		if (start === undefined) {
			start = 0;
			end = len;
		} else {
			end = start;
			start = len;
		}

		for (var i = start; i < end; i++) {
			out.push(i);
		}

		return out;
	};

	var _removeEmpty = function _removeEmpty(a) {
		var out = [];

		for (var i = 0, ien = a.length; i < ien; i++) {
			if (a[i]) {
				// careful - will remove all falsy values!
				out.push(a[i]);
			}
		}

		return out;
	};

	var _stripHtml = function _stripHtml(d) {
		return d.replace(_re_html, '');
	};

	/**
  * Determine if all values in the array are unique. This means we can short
  * cut the _unique method at the cost of a single loop. A sorted array is used
  * to easily check the values.
  *
  * @param  {array} src Source array
  * @return {boolean} true if all unique, false otherwise
  * @ignore
  */
	var _areAllUnique = function _areAllUnique(src) {
		if (src.length < 2) {
			return true;
		}

		var sorted = src.slice().sort();
		var last = sorted[0];

		for (var i = 1, ien = sorted.length; i < ien; i++) {
			if (sorted[i] === last) {
				return false;
			}

			last = sorted[i];
		}

		return true;
	};

	/**
  * Find the unique elements in a source array.
  *
  * @param  {array} src Source array
  * @return {array} Array of unique items
  * @ignore
  */
	var _unique = function _unique(src) {
		if (_areAllUnique(src)) {
			return src.slice();
		}

		// A faster unique method is to use object keys to identify used values,
		// but this doesn't work with arrays or objects, which we must also
		// consider. See jsperf.com/compare-array-unique-versions/4 for more
		// information.
		var out = [],
		    val,
		    i,
		    ien = src.length,
		    j,
		    k = 0;

		again: for (i = 0; i < ien; i++) {
			val = src[i];

			for (j = 0; j < k; j++) {
				if (out[j] === val) {
					continue again;
				}
			}

			out.push(val);
			k++;
		}

		return out;
	};

	/**
  * DataTables utility methods
  * 
  * This namespace provides helper methods that DataTables uses internally to
  * create a DataTable, but which are not exclusively used only for DataTables.
  * These methods can be used by extension authors to save the duplication of
  * code.
  *
  *  @namespace
  */
	DataTable.util = {
		/**
   * Throttle the calls to a function. Arguments and context are maintained
   * for the throttled function.
   *
   * @param {function} fn Function to be called
   * @param {integer} freq Call frequency in mS
   * @return {function} Wrapped function
   */
		throttle: function throttle(fn, freq) {
			var frequency = freq !== undefined ? freq : 200,
			    last,
			    timer;

			return function () {
				var that = this,
				    now = +new Date(),
				    args = arguments;

				if (last && now < last + frequency) {
					clearTimeout(timer);

					timer = setTimeout(function () {
						last = undefined;
						fn.apply(that, args);
					}, frequency);
				} else {
					last = now;
					fn.apply(that, args);
				}
			};
		},

		/**
   * Escape a string such that it can be used in a regular expression
   *
   *  @param {string} val string to escape
   *  @returns {string} escaped string
   */
		escapeRegex: function escapeRegex(val) {
			return val.replace(_re_escape_regex, '\\$1');
		}
	};

	/**
  * Create a mapping object that allows camel case parameters to be looked up
  * for their Hungarian counterparts. The mapping is stored in a private
  * parameter called `_hungarianMap` which can be accessed on the source object.
  *  @param {object} o
  *  @memberof DataTable#oApi
  */
	function _fnHungarianMap(o) {
		var hungarian = 'a aa ai ao as b fn i m o s ',
		    match,
		    newKey,
		    map = {};

		$.each(o, function (key, val) {
			match = key.match(/^([^A-Z]+?)([A-Z])/);

			if (match && hungarian.indexOf(match[1] + ' ') !== -1) {
				newKey = key.replace(match[0], match[2].toLowerCase());
				map[newKey] = key;

				if (match[1] === 'o') {
					_fnHungarianMap(o[key]);
				}
			}
		});

		o._hungarianMap = map;
	}

	/**
  * Convert from camel case parameters to Hungarian, based on a Hungarian map
  * created by _fnHungarianMap.
  *  @param {object} src The model object which holds all parameters that can be
  *    mapped.
  *  @param {object} user The object to convert from camel case to Hungarian.
  *  @param {boolean} force When set to `true`, properties which already have a
  *    Hungarian value in the `user` object will be overwritten. Otherwise they
  *    won't be.
  *  @memberof DataTable#oApi
  */
	function _fnCamelToHungarian(src, user, force) {
		if (!src._hungarianMap) {
			_fnHungarianMap(src);
		}

		var hungarianKey;

		$.each(user, function (key, val) {
			hungarianKey = src._hungarianMap[key];

			if (hungarianKey !== undefined && (force || user[hungarianKey] === undefined)) {
				// For objects, we need to buzz down into the object to copy parameters
				if (hungarianKey.charAt(0) === 'o') {
					// Copy the camelCase options over to the hungarian
					if (!user[hungarianKey]) {
						user[hungarianKey] = {};
					}
					$.extend(true, user[hungarianKey], user[key]);

					_fnCamelToHungarian(src[hungarianKey], user[hungarianKey], force);
				} else {
					user[hungarianKey] = user[key];
				}
			}
		});
	}

	/**
  * Language compatibility - when certain options are given, and others aren't, we
  * need to duplicate the values over, in order to provide backwards compatibility
  * with older language files.
  *  @param {object} oSettings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnLanguageCompat(lang) {
		var defaults = DataTable.defaults.oLanguage;
		var zeroRecords = lang.sZeroRecords;

		/* Backwards compatibility - if there is no sEmptyTable given, then use the same as
   * sZeroRecords - assuming that is given.
   */
		if (!lang.sEmptyTable && zeroRecords && defaults.sEmptyTable === "No data available in table") {
			_fnMap(lang, lang, 'sZeroRecords', 'sEmptyTable');
		}

		/* Likewise with loading records */
		if (!lang.sLoadingRecords && zeroRecords && defaults.sLoadingRecords === "Loading...") {
			_fnMap(lang, lang, 'sZeroRecords', 'sLoadingRecords');
		}

		// Old parameter name of the thousands separator mapped onto the new
		if (lang.sInfoThousands) {
			lang.sThousands = lang.sInfoThousands;
		}

		var decimal = lang.sDecimal;
		if (decimal) {
			_addNumericSort(decimal);
		}
	}

	/**
  * Map one parameter onto another
  *  @param {object} o Object to map
  *  @param {*} knew The new parameter name
  *  @param {*} old The old parameter name
  */
	var _fnCompatMap = function _fnCompatMap(o, knew, old) {
		if (o[knew] !== undefined) {
			o[old] = o[knew];
		}
	};

	/**
  * Provide backwards compatibility for the main DT options. Note that the new
  * options are mapped onto the old parameters, so this is an external interface
  * change only.
  *  @param {object} init Object to map
  */
	function _fnCompatOpts(init) {
		_fnCompatMap(init, 'ordering', 'bSort');
		_fnCompatMap(init, 'orderMulti', 'bSortMulti');
		_fnCompatMap(init, 'orderClasses', 'bSortClasses');
		_fnCompatMap(init, 'orderCellsTop', 'bSortCellsTop');
		_fnCompatMap(init, 'order', 'aaSorting');
		_fnCompatMap(init, 'orderFixed', 'aaSortingFixed');
		_fnCompatMap(init, 'paging', 'bPaginate');
		_fnCompatMap(init, 'pagingType', 'sPaginationType');
		_fnCompatMap(init, 'pageLength', 'iDisplayLength');
		_fnCompatMap(init, 'searching', 'bFilter');

		// Boolean initialisation of x-scrolling
		if (typeof init.sScrollX === 'boolean') {
			init.sScrollX = init.sScrollX ? '100%' : '';
		}
		if (typeof init.scrollX === 'boolean') {
			init.scrollX = init.scrollX ? '100%' : '';
		}

		// Column search objects are in an array, so it needs to be converted
		// element by element
		var searchCols = init.aoSearchCols;

		if (searchCols) {
			for (var i = 0, ien = searchCols.length; i < ien; i++) {
				if (searchCols[i]) {
					_fnCamelToHungarian(DataTable.models.oSearch, searchCols[i]);
				}
			}
		}
	}

	/**
  * Provide backwards compatibility for column options. Note that the new options
  * are mapped onto the old parameters, so this is an external interface change
  * only.
  *  @param {object} init Object to map
  */
	function _fnCompatCols(init) {
		_fnCompatMap(init, 'orderable', 'bSortable');
		_fnCompatMap(init, 'orderData', 'aDataSort');
		_fnCompatMap(init, 'orderSequence', 'asSorting');
		_fnCompatMap(init, 'orderDataType', 'sortDataType');

		// orderData can be given as an integer
		var dataSort = init.aDataSort;
		if (typeof dataSort === 'number' && !$.isArray(dataSort)) {
			init.aDataSort = [dataSort];
		}
	}

	/**
  * Browser feature detection for capabilities, quirks
  *  @param {object} settings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnBrowserDetect(settings) {
		// We don't need to do this every time DataTables is constructed, the values
		// calculated are specific to the browser and OS configuration which we
		// don't expect to change between initialisations
		if (!DataTable.__browser) {
			var browser = {};
			DataTable.__browser = browser;

			// Scrolling feature / quirks detection
			var n = $('<div/>').css({
				position: 'fixed',
				top: 0,
				left: $(window).scrollLeft() * -1, // allow for scrolling
				height: 1,
				width: 1,
				overflow: 'hidden'
			}).append($('<div/>').css({
				position: 'absolute',
				top: 1,
				left: 1,
				width: 100,
				overflow: 'scroll'
			}).append($('<div/>').css({
				width: '100%',
				height: 10
			}))).appendTo('body');

			var outer = n.children();
			var inner = outer.children();

			// Numbers below, in order, are:
			// inner.offsetWidth, inner.clientWidth, outer.offsetWidth, outer.clientWidth
			//
			// IE6 XP:                           100 100 100  83
			// IE7 Vista:                        100 100 100  83
			// IE 8+ Windows:                     83  83 100  83
			// Evergreen Windows:                 83  83 100  83
			// Evergreen Mac with scrollbars:     85  85 100  85
			// Evergreen Mac without scrollbars: 100 100 100 100

			// Get scrollbar width
			browser.barWidth = outer[0].offsetWidth - outer[0].clientWidth;

			// IE6/7 will oversize a width 100% element inside a scrolling element, to
			// include the width of the scrollbar, while other browsers ensure the inner
			// element is contained without forcing scrolling
			browser.bScrollOversize = inner[0].offsetWidth === 100 && outer[0].clientWidth !== 100;

			// In rtl text layout, some browsers (most, but not all) will place the
			// scrollbar on the left, rather than the right.
			browser.bScrollbarLeft = Math.round(inner.offset().left) !== 1;

			// IE8- don't provide height and width for getBoundingClientRect
			browser.bBounding = n[0].getBoundingClientRect().width ? true : false;

			n.remove();
		}

		$.extend(settings.oBrowser, DataTable.__browser);
		settings.oScroll.iBarWidth = DataTable.__browser.barWidth;
	}

	/**
  * Array.prototype reduce[Right] method, used for browsers which don't support
  * JS 1.6. Done this way to reduce code size, since we iterate either way
  *  @param {object} settings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnReduce(that, fn, init, start, end, inc) {
		var i = start,
		    value,
		    isSet = false;

		if (init !== undefined) {
			value = init;
			isSet = true;
		}

		while (i !== end) {
			if (!that.hasOwnProperty(i)) {
				continue;
			}

			value = isSet ? fn(value, that[i], i, that) : that[i];

			isSet = true;
			i += inc;
		}

		return value;
	}

	/**
  * Add a column to the list used for the table with default values
  *  @param {object} oSettings dataTables settings object
  *  @param {node} nTh The th element for this column
  *  @memberof DataTable#oApi
  */
	function _fnAddColumn(oSettings, nTh) {
		// Add column to aoColumns array
		var oDefaults = DataTable.defaults.column;
		var iCol = oSettings.aoColumns.length;
		var oCol = $.extend({}, DataTable.models.oColumn, oDefaults, {
			"nTh": nTh ? nTh : document.createElement('th'),
			"sTitle": oDefaults.sTitle ? oDefaults.sTitle : nTh ? nTh.innerHTML : '',
			"aDataSort": oDefaults.aDataSort ? oDefaults.aDataSort : [iCol],
			"mData": oDefaults.mData ? oDefaults.mData : iCol,
			idx: iCol
		});
		oSettings.aoColumns.push(oCol);

		// Add search object for column specific search. Note that the `searchCols[ iCol ]`
		// passed into extend can be undefined. This allows the user to give a default
		// with only some of the parameters defined, and also not give a default
		var searchCols = oSettings.aoPreSearchCols;
		searchCols[iCol] = $.extend({}, DataTable.models.oSearch, searchCols[iCol]);

		// Use the default column options function to initialise classes etc
		_fnColumnOptions(oSettings, iCol, $(nTh).data());
	}

	/**
  * Apply options for a column
  *  @param {object} oSettings dataTables settings object
  *  @param {int} iCol column index to consider
  *  @param {object} oOptions object with sType, bVisible and bSearchable etc
  *  @memberof DataTable#oApi
  */
	function _fnColumnOptions(oSettings, iCol, oOptions) {
		var oCol = oSettings.aoColumns[iCol];
		var oClasses = oSettings.oClasses;
		var th = $(oCol.nTh);

		// Try to get width information from the DOM. We can't get it from CSS
		// as we'd need to parse the CSS stylesheet. `width` option can override
		if (!oCol.sWidthOrig) {
			// Width attribute
			oCol.sWidthOrig = th.attr('width') || null;

			// Style attribute
			var t = (th.attr('style') || '').match(/width:\s*(\d+[pxem%]+)/);
			if (t) {
				oCol.sWidthOrig = t[1];
			}
		}

		/* User specified column options */
		if (oOptions !== undefined && oOptions !== null) {
			// Backwards compatibility
			_fnCompatCols(oOptions);

			// Map camel case parameters to their Hungarian counterparts
			_fnCamelToHungarian(DataTable.defaults.column, oOptions);

			/* Backwards compatibility for mDataProp */
			if (oOptions.mDataProp !== undefined && !oOptions.mData) {
				oOptions.mData = oOptions.mDataProp;
			}

			if (oOptions.sType) {
				oCol._sManualType = oOptions.sType;
			}

			// `class` is a reserved word in Javascript, so we need to provide
			// the ability to use a valid name for the camel case input
			if (oOptions.className && !oOptions.sClass) {
				oOptions.sClass = oOptions.className;
			}

			$.extend(oCol, oOptions);
			_fnMap(oCol, oOptions, "sWidth", "sWidthOrig");

			/* iDataSort to be applied (backwards compatibility), but aDataSort will take
    * priority if defined
    */
			if (oOptions.iDataSort !== undefined) {
				oCol.aDataSort = [oOptions.iDataSort];
			}
			_fnMap(oCol, oOptions, "aDataSort");
		}

		/* Cache the data get and set functions for speed */
		var mDataSrc = oCol.mData;
		var mData = _fnGetObjectDataFn(mDataSrc);
		var mRender = oCol.mRender ? _fnGetObjectDataFn(oCol.mRender) : null;

		var attrTest = function attrTest(src) {
			return typeof src === 'string' && src.indexOf('@') !== -1;
		};
		oCol._bAttrSrc = $.isPlainObject(mDataSrc) && (attrTest(mDataSrc.sort) || attrTest(mDataSrc.type) || attrTest(mDataSrc.filter));
		oCol._setter = null;

		oCol.fnGetData = function (rowData, type, meta) {
			var innerData = mData(rowData, type, undefined, meta);

			return mRender && type ? mRender(innerData, type, rowData, meta) : innerData;
		};
		oCol.fnSetData = function (rowData, val, meta) {
			return _fnSetObjectDataFn(mDataSrc)(rowData, val, meta);
		};

		// Indicate if DataTables should read DOM data as an object or array
		// Used in _fnGetRowElements
		if (typeof mDataSrc !== 'number') {
			oSettings._rowReadObject = true;
		}

		/* Feature sorting overrides column specific when off */
		if (!oSettings.oFeatures.bSort) {
			oCol.bSortable = false;
			th.addClass(oClasses.sSortableNone); // Have to add class here as order event isn't called
		}

		/* Check that the class assignment is correct for sorting */
		var bAsc = $.inArray('asc', oCol.asSorting) !== -1;
		var bDesc = $.inArray('desc', oCol.asSorting) !== -1;
		if (!oCol.bSortable || !bAsc && !bDesc) {
			oCol.sSortingClass = oClasses.sSortableNone;
			oCol.sSortingClassJUI = "";
		} else if (bAsc && !bDesc) {
			oCol.sSortingClass = oClasses.sSortableAsc;
			oCol.sSortingClassJUI = oClasses.sSortJUIAscAllowed;
		} else if (!bAsc && bDesc) {
			oCol.sSortingClass = oClasses.sSortableDesc;
			oCol.sSortingClassJUI = oClasses.sSortJUIDescAllowed;
		} else {
			oCol.sSortingClass = oClasses.sSortable;
			oCol.sSortingClassJUI = oClasses.sSortJUI;
		}
	}

	/**
  * Adjust the table column widths for new data. Note: you would probably want to
  * do a redraw after calling this function!
  *  @param {object} settings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnAdjustColumnSizing(settings) {
		/* Not interested in doing column width calculation if auto-width is disabled */
		if (settings.oFeatures.bAutoWidth !== false) {
			var columns = settings.aoColumns;

			_fnCalculateColumnWidths(settings);
			for (var i = 0, iLen = columns.length; i < iLen; i++) {
				columns[i].nTh.style.width = columns[i].sWidth;
			}
		}

		var scroll = settings.oScroll;
		if (scroll.sY !== '' || scroll.sX !== '') {
			_fnScrollDraw(settings);
		}

		_fnCallbackFire(settings, null, 'column-sizing', [settings]);
	}

	/**
  * Covert the index of a visible column to the index in the data array (take account
  * of hidden columns)
  *  @param {object} oSettings dataTables settings object
  *  @param {int} iMatch Visible column index to lookup
  *  @returns {int} i the data index
  *  @memberof DataTable#oApi
  */
	function _fnVisibleToColumnIndex(oSettings, iMatch) {
		var aiVis = _fnGetColumns(oSettings, 'bVisible');

		return typeof aiVis[iMatch] === 'number' ? aiVis[iMatch] : null;
	}

	/**
  * Covert the index of an index in the data array and convert it to the visible
  *   column index (take account of hidden columns)
  *  @param {int} iMatch Column index to lookup
  *  @param {object} oSettings dataTables settings object
  *  @returns {int} i the data index
  *  @memberof DataTable#oApi
  */
	function _fnColumnIndexToVisible(oSettings, iMatch) {
		var aiVis = _fnGetColumns(oSettings, 'bVisible');
		var iPos = $.inArray(iMatch, aiVis);

		return iPos !== -1 ? iPos : null;
	}

	/**
  * Get the number of visible columns
  *  @param {object} oSettings dataTables settings object
  *  @returns {int} i the number of visible columns
  *  @memberof DataTable#oApi
  */
	function _fnVisbleColumns(oSettings) {
		var vis = 0;

		// No reduce in IE8, use a loop for now
		$.each(oSettings.aoColumns, function (i, col) {
			if (col.bVisible && $(col.nTh).css('display') !== 'none') {
				vis++;
			}
		});

		return vis;
	}

	/**
  * Get an array of column indexes that match a given property
  *  @param {object} oSettings dataTables settings object
  *  @param {string} sParam Parameter in aoColumns to look for - typically
  *    bVisible or bSearchable
  *  @returns {array} Array of indexes with matched properties
  *  @memberof DataTable#oApi
  */
	function _fnGetColumns(oSettings, sParam) {
		var a = [];

		$.map(oSettings.aoColumns, function (val, i) {
			if (val[sParam]) {
				a.push(i);
			}
		});

		return a;
	}

	/**
  * Calculate the 'type' of a column
  *  @param {object} settings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnColumnTypes(settings) {
		var columns = settings.aoColumns;
		var data = settings.aoData;
		var types = DataTable.ext.type.detect;
		var i, ien, j, jen, k, ken;
		var col, cell, detectedType, cache;

		// For each column, spin over the 
		for (i = 0, ien = columns.length; i < ien; i++) {
			col = columns[i];
			cache = [];

			if (!col.sType && col._sManualType) {
				col.sType = col._sManualType;
			} else if (!col.sType) {
				for (j = 0, jen = types.length; j < jen; j++) {
					for (k = 0, ken = data.length; k < ken; k++) {
						// Use a cache array so we only need to get the type data
						// from the formatter once (when using multiple detectors)
						if (cache[k] === undefined) {
							cache[k] = _fnGetCellData(settings, k, i, 'type');
						}

						detectedType = types[j](cache[k], settings);

						// If null, then this type can't apply to this column, so
						// rather than testing all cells, break out. There is an
						// exception for the last type which is `html`. We need to
						// scan all rows since it is possible to mix string and HTML
						// types
						if (!detectedType && j !== types.length - 1) {
							break;
						}

						// Only a single match is needed for html type since it is
						// bottom of the pile and very similar to string
						if (detectedType === 'html') {
							break;
						}
					}

					// Type is valid for all data points in the column - use this
					// type
					if (detectedType) {
						col.sType = detectedType;
						break;
					}
				}

				// Fall back - if no type was detected, always use string
				if (!col.sType) {
					col.sType = 'string';
				}
			}
		}
	}

	/**
  * Take the column definitions and static columns arrays and calculate how
  * they relate to column indexes. The callback function will then apply the
  * definition found for a column to a suitable configuration object.
  *  @param {object} oSettings dataTables settings object
  *  @param {array} aoColDefs The aoColumnDefs array that is to be applied
  *  @param {array} aoCols The aoColumns array that defines columns individually
  *  @param {function} fn Callback function - takes two parameters, the calculated
  *    column index and the definition for that column.
  *  @memberof DataTable#oApi
  */
	function _fnApplyColumnDefs(oSettings, aoColDefs, aoCols, fn) {
		var i, iLen, j, jLen, k, kLen, def;
		var columns = oSettings.aoColumns;

		// Column definitions with aTargets
		if (aoColDefs) {
			/* Loop over the definitions array - loop in reverse so first instance has priority */
			for (i = aoColDefs.length - 1; i >= 0; i--) {
				def = aoColDefs[i];

				/* Each definition can target multiple columns, as it is an array */
				var aTargets = def.targets !== undefined ? def.targets : def.aTargets;

				if (!$.isArray(aTargets)) {
					aTargets = [aTargets];
				}

				for (j = 0, jLen = aTargets.length; j < jLen; j++) {
					if (typeof aTargets[j] === 'number' && aTargets[j] >= 0) {
						/* Add columns that we don't yet know about */
						while (columns.length <= aTargets[j]) {
							_fnAddColumn(oSettings);
						}

						/* Integer, basic index */
						fn(aTargets[j], def);
					} else if (typeof aTargets[j] === 'number' && aTargets[j] < 0) {
						/* Negative integer, right to left column counting */
						fn(columns.length + aTargets[j], def);
					} else if (typeof aTargets[j] === 'string') {
						/* Class name matching on TH element */
						for (k = 0, kLen = columns.length; k < kLen; k++) {
							if (aTargets[j] == "_all" || $(columns[k].nTh).hasClass(aTargets[j])) {
								fn(k, def);
							}
						}
					}
				}
			}
		}

		// Statically defined columns array
		if (aoCols) {
			for (i = 0, iLen = aoCols.length; i < iLen; i++) {
				fn(i, aoCols[i]);
			}
		}
	}

	/**
  * Add a data array to the table, creating DOM node etc. This is the parallel to
  * _fnGatherData, but for adding rows from a Javascript source, rather than a
  * DOM source.
  *  @param {object} oSettings dataTables settings object
  *  @param {array} aData data array to be added
  *  @param {node} [nTr] TR element to add to the table - optional. If not given,
  *    DataTables will create a row automatically
  *  @param {array} [anTds] Array of TD|TH elements for the row - must be given
  *    if nTr is.
  *  @returns {int} >=0 if successful (index of new aoData entry), -1 if failed
  *  @memberof DataTable#oApi
  */
	function _fnAddData(oSettings, aDataIn, nTr, anTds) {
		/* Create the object for storing information about this new row */
		var iRow = oSettings.aoData.length;
		var oData = $.extend(true, {}, DataTable.models.oRow, {
			src: nTr ? 'dom' : 'data',
			idx: iRow
		});

		oData._aData = aDataIn;
		oSettings.aoData.push(oData);

		/* Create the cells */
		var nTd, sThisType;
		var columns = oSettings.aoColumns;

		// Invalidate the column types as the new data needs to be revalidated
		for (var i = 0, iLen = columns.length; i < iLen; i++) {
			columns[i].sType = null;
		}

		/* Add to the display array */
		oSettings.aiDisplayMaster.push(iRow);

		var id = oSettings.rowIdFn(aDataIn);
		if (id !== undefined) {
			oSettings.aIds[id] = oData;
		}

		/* Create the DOM information, or register it if already present */
		if (nTr || !oSettings.oFeatures.bDeferRender) {
			_fnCreateTr(oSettings, iRow, nTr, anTds);
		}

		return iRow;
	}

	/**
  * Add one or more TR elements to the table. Generally we'd expect to
  * use this for reading data from a DOM sourced table, but it could be
  * used for an TR element. Note that if a TR is given, it is used (i.e.
  * it is not cloned).
  *  @param {object} settings dataTables settings object
  *  @param {array|node|jQuery} trs The TR element(s) to add to the table
  *  @returns {array} Array of indexes for the added rows
  *  @memberof DataTable#oApi
  */
	function _fnAddTr(settings, trs) {
		var row;

		// Allow an individual node to be passed in
		if (!(trs instanceof $)) {
			trs = $(trs);
		}

		return trs.map(function (i, el) {
			row = _fnGetRowElements(settings, el);
			return _fnAddData(settings, row.data, el, row.cells);
		});
	}

	/**
  * Take a TR element and convert it to an index in aoData
  *  @param {object} oSettings dataTables settings object
  *  @param {node} n the TR element to find
  *  @returns {int} index if the node is found, null if not
  *  @memberof DataTable#oApi
  */
	function _fnNodeToDataIndex(oSettings, n) {
		return n._DT_RowIndex !== undefined ? n._DT_RowIndex : null;
	}

	/**
  * Take a TD element and convert it into a column data index (not the visible index)
  *  @param {object} oSettings dataTables settings object
  *  @param {int} iRow The row number the TD/TH can be found in
  *  @param {node} n The TD/TH element to find
  *  @returns {int} index if the node is found, -1 if not
  *  @memberof DataTable#oApi
  */
	function _fnNodeToColumnIndex(oSettings, iRow, n) {
		return $.inArray(n, oSettings.aoData[iRow].anCells);
	}

	/**
  * Get the data for a given cell from the internal cache, taking into account data mapping
  *  @param {object} settings dataTables settings object
  *  @param {int} rowIdx aoData row id
  *  @param {int} colIdx Column index
  *  @param {string} type data get type ('display', 'type' 'filter' 'sort')
  *  @returns {*} Cell data
  *  @memberof DataTable#oApi
  */
	function _fnGetCellData(settings, rowIdx, colIdx, type) {
		var draw = settings.iDraw;
		var col = settings.aoColumns[colIdx];
		var rowData = settings.aoData[rowIdx]._aData;
		var defaultContent = col.sDefaultContent;
		var cellData = col.fnGetData(rowData, type, {
			settings: settings,
			row: rowIdx,
			col: colIdx
		});

		if (cellData === undefined) {
			if (settings.iDrawError != draw && defaultContent === null) {
				_fnLog(settings, 0, "Requested unknown parameter " + (typeof col.mData == 'function' ? '{function}' : "'" + col.mData + "'") + " for row " + rowIdx + ", column " + colIdx, 4);
				settings.iDrawError = draw;
			}
			return defaultContent;
		}

		// When the data source is null and a specific data type is requested (i.e.
		// not the original data), we can use default column data
		if ((cellData === rowData || cellData === null) && defaultContent !== null && type !== undefined) {
			cellData = defaultContent;
		} else if (typeof cellData === 'function') {
			// If the data source is a function, then we run it and use the return,
			// executing in the scope of the data object (for instances)
			return cellData.call(rowData);
		}

		if (cellData === null && type == 'display') {
			return '';
		}
		return cellData;
	}

	/**
  * Set the value for a specific cell, into the internal data cache
  *  @param {object} settings dataTables settings object
  *  @param {int} rowIdx aoData row id
  *  @param {int} colIdx Column index
  *  @param {*} val Value to set
  *  @memberof DataTable#oApi
  */
	function _fnSetCellData(settings, rowIdx, colIdx, val) {
		var col = settings.aoColumns[colIdx];
		var rowData = settings.aoData[rowIdx]._aData;

		col.fnSetData(rowData, val, {
			settings: settings,
			row: rowIdx,
			col: colIdx
		});
	}

	// Private variable that is used to match action syntax in the data property object
	var __reArray = /\[.*?\]$/;
	var __reFn = /\(\)$/;

	/**
  * Split string on periods, taking into account escaped periods
  * @param  {string} str String to split
  * @return {array} Split string
  */
	function _fnSplitObjNotation(str) {
		return $.map(str.match(/(\\.|[^\.])+/g) || [''], function (s) {
			return s.replace(/\\\./g, '.');
		});
	}

	/**
  * Return a function that can be used to get data from a source object, taking
  * into account the ability to use nested objects as a source
  *  @param {string|int|function} mSource The data source for the object
  *  @returns {function} Data get function
  *  @memberof DataTable#oApi
  */
	function _fnGetObjectDataFn(mSource) {
		if ($.isPlainObject(mSource)) {
			/* Build an object of get functions, and wrap them in a single call */
			var o = {};
			$.each(mSource, function (key, val) {
				if (val) {
					o[key] = _fnGetObjectDataFn(val);
				}
			});

			return function (data, type, row, meta) {
				var t = o[type] || o._;
				return t !== undefined ? t(data, type, row, meta) : data;
			};
		} else if (mSource === null) {
			/* Give an empty string for rendering / sorting etc */
			return function (data) {
				// type, row and meta also passed, but not used
				return data;
			};
		} else if (typeof mSource === 'function') {
			return function (data, type, row, meta) {
				return mSource(data, type, row, meta);
			};
		} else if (typeof mSource === 'string' && (mSource.indexOf('.') !== -1 || mSource.indexOf('[') !== -1 || mSource.indexOf('(') !== -1)) {
			/* If there is a . in the source string then the data source is in a
    * nested object so we loop over the data for each level to get the next
    * level down. On each loop we test for undefined, and if found immediately
    * return. This allows entire objects to be missing and sDefaultContent to
    * be used if defined, rather than throwing an error
    */
			var fetchData = function fetchData(data, type, src) {
				var arrayNotation, funcNotation, out, innerSrc;

				if (src !== "") {
					var a = _fnSplitObjNotation(src);

					for (var i = 0, iLen = a.length; i < iLen; i++) {
						// Check if we are dealing with special notation
						arrayNotation = a[i].match(__reArray);
						funcNotation = a[i].match(__reFn);

						if (arrayNotation) {
							// Array notation
							a[i] = a[i].replace(__reArray, '');

							// Condition allows simply [] to be passed in
							if (a[i] !== "") {
								data = data[a[i]];
							}
							out = [];

							// Get the remainder of the nested object to get
							a.splice(0, i + 1);
							innerSrc = a.join('.');

							// Traverse each entry in the array getting the properties requested
							if ($.isArray(data)) {
								for (var j = 0, jLen = data.length; j < jLen; j++) {
									out.push(fetchData(data[j], type, innerSrc));
								}
							}

							// If a string is given in between the array notation indicators, that
							// is used to join the strings together, otherwise an array is returned
							var join = arrayNotation[0].substring(1, arrayNotation[0].length - 1);
							data = join === "" ? out : out.join(join);

							// The inner call to fetchData has already traversed through the remainder
							// of the source requested, so we exit from the loop
							break;
						} else if (funcNotation) {
							// Function call
							a[i] = a[i].replace(__reFn, '');
							data = data[a[i]]();
							continue;
						}

						if (data === null || data[a[i]] === undefined) {
							return undefined;
						}
						data = data[a[i]];
					}
				}

				return data;
			};

			return function (data, type) {
				// row and meta also passed, but not used
				return fetchData(data, type, mSource);
			};
		} else {
			/* Array or flat object mapping */
			return function (data, type) {
				// row and meta also passed, but not used
				return data[mSource];
			};
		}
	}

	/**
  * Return a function that can be used to set data from a source object, taking
  * into account the ability to use nested objects as a source
  *  @param {string|int|function} mSource The data source for the object
  *  @returns {function} Data set function
  *  @memberof DataTable#oApi
  */
	function _fnSetObjectDataFn(mSource) {
		if ($.isPlainObject(mSource)) {
			/* Unlike get, only the underscore (global) option is used for for
    * setting data since we don't know the type here. This is why an object
    * option is not documented for `mData` (which is read/write), but it is
    * for `mRender` which is read only.
    */
			return _fnSetObjectDataFn(mSource._);
		} else if (mSource === null) {
			/* Nothing to do when the data source is null */
			return function () {};
		} else if (typeof mSource === 'function') {
			return function (data, val, meta) {
				mSource(data, 'set', val, meta);
			};
		} else if (typeof mSource === 'string' && (mSource.indexOf('.') !== -1 || mSource.indexOf('[') !== -1 || mSource.indexOf('(') !== -1)) {
			/* Like the get, we need to get data from a nested object */
			var setData = function setData(data, val, src) {
				var a = _fnSplitObjNotation(src),
				    b;
				var aLast = a[a.length - 1];
				var arrayNotation, funcNotation, o, innerSrc;

				for (var i = 0, iLen = a.length - 1; i < iLen; i++) {
					// Check if we are dealing with an array notation request
					arrayNotation = a[i].match(__reArray);
					funcNotation = a[i].match(__reFn);

					if (arrayNotation) {
						a[i] = a[i].replace(__reArray, '');
						data[a[i]] = [];

						// Get the remainder of the nested object to set so we can recurse
						b = a.slice();
						b.splice(0, i + 1);
						innerSrc = b.join('.');

						// Traverse each entry in the array setting the properties requested
						if ($.isArray(val)) {
							for (var j = 0, jLen = val.length; j < jLen; j++) {
								o = {};
								setData(o, val[j], innerSrc);
								data[a[i]].push(o);
							}
						} else {
							// We've been asked to save data to an array, but it
							// isn't array data to be saved. Best that can be done
							// is to just save the value.
							data[a[i]] = val;
						}

						// The inner call to setData has already traversed through the remainder
						// of the source and has set the data, thus we can exit here
						return;
					} else if (funcNotation) {
						// Function call
						a[i] = a[i].replace(__reFn, '');
						data = data[a[i]](val);
					}

					// If the nested object doesn't currently exist - since we are
					// trying to set the value - create it
					if (data[a[i]] === null || data[a[i]] === undefined) {
						data[a[i]] = {};
					}
					data = data[a[i]];
				}

				// Last item in the input - i.e, the actual set
				if (aLast.match(__reFn)) {
					// Function call
					data = data[aLast.replace(__reFn, '')](val);
				} else {
					// If array notation is used, we just want to strip it and use the property name
					// and assign the value. If it isn't used, then we get the result we want anyway
					data[aLast.replace(__reArray, '')] = val;
				}
			};

			return function (data, val) {
				// meta is also passed in, but not used
				return setData(data, val, mSource);
			};
		} else {
			/* Array or flat object mapping */
			return function (data, val) {
				// meta is also passed in, but not used
				data[mSource] = val;
			};
		}
	}

	/**
  * Return an array with the full table data
  *  @param {object} oSettings dataTables settings object
  *  @returns array {array} aData Master data array
  *  @memberof DataTable#oApi
  */
	function _fnGetDataMaster(settings) {
		return _pluck(settings.aoData, '_aData');
	}

	/**
  * Nuke the table
  *  @param {object} oSettings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnClearTable(settings) {
		settings.aoData.length = 0;
		settings.aiDisplayMaster.length = 0;
		settings.aiDisplay.length = 0;
		settings.aIds = {};
	}

	/**
 * Take an array of integers (index array) and remove a target integer (value - not
 * the key!)
 *  @param {array} a Index array to target
 *  @param {int} iTarget value to find
 *  @memberof DataTable#oApi
 */
	function _fnDeleteIndex(a, iTarget, splice) {
		var iTargetIndex = -1;

		for (var i = 0, iLen = a.length; i < iLen; i++) {
			if (a[i] == iTarget) {
				iTargetIndex = i;
			} else if (a[i] > iTarget) {
				a[i]--;
			}
		}

		if (iTargetIndex != -1 && splice === undefined) {
			a.splice(iTargetIndex, 1);
		}
	}

	/**
  * Mark cached data as invalid such that a re-read of the data will occur when
  * the cached data is next requested. Also update from the data source object.
  *
  * @param {object} settings DataTables settings object
  * @param {int}    rowIdx   Row index to invalidate
  * @param {string} [src]    Source to invalidate from: undefined, 'auto', 'dom'
  *     or 'data'
  * @param {int}    [colIdx] Column index to invalidate. If undefined the whole
  *     row will be invalidated
  * @memberof DataTable#oApi
  *
  * @todo For the modularisation of v1.11 this will need to become a callback, so
  *   the sort and filter methods can subscribe to it. That will required
  *   initialisation options for sorting, which is why it is not already baked in
  */
	function _fnInvalidate(settings, rowIdx, src, colIdx) {
		var row = settings.aoData[rowIdx];
		var i, ien;
		var cellWrite = function cellWrite(cell, col) {
			// This is very frustrating, but in IE if you just write directly
			// to innerHTML, and elements that are overwritten are GC'ed,
			// even if there is a reference to them elsewhere
			while (cell.childNodes.length) {
				cell.removeChild(cell.firstChild);
			}

			cell.innerHTML = _fnGetCellData(settings, rowIdx, col, 'display');
		};

		// Are we reading last data from DOM or the data object?
		if (src === 'dom' || (!src || src === 'auto') && row.src === 'dom') {
			// Read the data from the DOM
			row._aData = _fnGetRowElements(settings, row, colIdx, colIdx === undefined ? undefined : row._aData).data;
		} else {
			// Reading from data object, update the DOM
			var cells = row.anCells;

			if (cells) {
				if (colIdx !== undefined) {
					cellWrite(cells[colIdx], colIdx);
				} else {
					for (i = 0, ien = cells.length; i < ien; i++) {
						cellWrite(cells[i], i);
					}
				}
			}
		}

		// For both row and cell invalidation, the cached data for sorting and
		// filtering is nulled out
		row._aSortData = null;
		row._aFilterData = null;

		// Invalidate the type for a specific column (if given) or all columns since
		// the data might have changed
		var cols = settings.aoColumns;
		if (colIdx !== undefined) {
			cols[colIdx].sType = null;
		} else {
			for (i = 0, ien = cols.length; i < ien; i++) {
				cols[i].sType = null;
			}

			// Update DataTables special `DT_*` attributes for the row
			_fnRowAttributes(settings, row);
		}
	}

	/**
  * Build a data source object from an HTML row, reading the contents of the
  * cells that are in the row.
  *
  * @param {object} settings DataTables settings object
  * @param {node|object} TR element from which to read data or existing row
  *   object from which to re-read the data from the cells
  * @param {int} [colIdx] Optional column index
  * @param {array|object} [d] Data source object. If `colIdx` is given then this
  *   parameter should also be given and will be used to write the data into.
  *   Only the column in question will be written
  * @returns {object} Object with two parameters: `data` the data read, in
  *   document order, and `cells` and array of nodes (they can be useful to the
  *   caller, so rather than needing a second traversal to get them, just return
  *   them from here).
  * @memberof DataTable#oApi
  */
	function _fnGetRowElements(settings, row, colIdx, d) {
		var tds = [],
		    td = row.firstChild,
		    name,
		    col,
		    o,
		    i = 0,
		    contents,
		    columns = settings.aoColumns,
		    objectRead = settings._rowReadObject;

		// Allow the data object to be passed in, or construct
		d = d !== undefined ? d : objectRead ? {} : [];

		var attr = function attr(str, td) {
			if (typeof str === 'string') {
				var idx = str.indexOf('@');

				if (idx !== -1) {
					var attr = str.substring(idx + 1);
					var setter = _fnSetObjectDataFn(str);
					setter(d, td.getAttribute(attr));
				}
			}
		};

		// Read data from a cell and store into the data object
		var cellProcess = function cellProcess(cell) {
			if (colIdx === undefined || colIdx === i) {
				col = columns[i];
				contents = $.trim(cell.innerHTML);

				if (col && col._bAttrSrc) {
					var setter = _fnSetObjectDataFn(col.mData._);
					setter(d, contents);

					attr(col.mData.sort, cell);
					attr(col.mData.type, cell);
					attr(col.mData.filter, cell);
				} else {
					// Depending on the `data` option for the columns the data can
					// be read to either an object or an array.
					if (objectRead) {
						if (!col._setter) {
							// Cache the setter function
							col._setter = _fnSetObjectDataFn(col.mData);
						}
						col._setter(d, contents);
					} else {
						d[i] = contents;
					}
				}
			}

			i++;
		};

		if (td) {
			// `tr` element was passed in
			while (td) {
				name = td.nodeName.toUpperCase();

				if (name == "TD" || name == "TH") {
					cellProcess(td);
					tds.push(td);
				}

				td = td.nextSibling;
			}
		} else {
			// Existing row object passed in
			tds = row.anCells;

			for (var j = 0, jen = tds.length; j < jen; j++) {
				cellProcess(tds[j]);
			}
		}

		// Read the ID from the DOM if present
		var rowNode = row.firstChild ? row : row.nTr;

		if (rowNode) {
			var id = rowNode.getAttribute('id');

			if (id) {
				_fnSetObjectDataFn(settings.rowId)(d, id);
			}
		}

		return {
			data: d,
			cells: tds
		};
	}
	/**
  * Create a new TR element (and it's TD children) for a row
  *  @param {object} oSettings dataTables settings object
  *  @param {int} iRow Row to consider
  *  @param {node} [nTrIn] TR element to add to the table - optional. If not given,
  *    DataTables will create a row automatically
  *  @param {array} [anTds] Array of TD|TH elements for the row - must be given
  *    if nTr is.
  *  @memberof DataTable#oApi
  */
	function _fnCreateTr(oSettings, iRow, nTrIn, anTds) {
		var row = oSettings.aoData[iRow],
		    rowData = row._aData,
		    cells = [],
		    nTr,
		    nTd,
		    oCol,
		    i,
		    iLen;

		if (row.nTr === null) {
			nTr = nTrIn || document.createElement('tr');

			row.nTr = nTr;
			row.anCells = cells;

			/* Use a private property on the node to allow reserve mapping from the node
    * to the aoData array for fast look up
    */
			nTr._DT_RowIndex = iRow;

			/* Special parameters can be given by the data source to be used on the row */
			_fnRowAttributes(oSettings, row);

			/* Process each column */
			for (i = 0, iLen = oSettings.aoColumns.length; i < iLen; i++) {
				oCol = oSettings.aoColumns[i];

				nTd = nTrIn ? anTds[i] : document.createElement(oCol.sCellType);
				nTd._DT_CellIndex = {
					row: iRow,
					column: i
				};

				cells.push(nTd);

				// Need to create the HTML if new, or if a rendering function is defined
				if ((!nTrIn || oCol.mRender || oCol.mData !== i) && (!$.isPlainObject(oCol.mData) || oCol.mData._ !== i + '.display')) {
					nTd.innerHTML = _fnGetCellData(oSettings, iRow, i, 'display');
				}

				/* Add user defined class */
				if (oCol.sClass) {
					nTd.className += ' ' + oCol.sClass;
				}

				// Visibility - add or remove as required
				if (oCol.bVisible && !nTrIn) {
					nTr.appendChild(nTd);
				} else if (!oCol.bVisible && nTrIn) {
					nTd.parentNode.removeChild(nTd);
				}

				if (oCol.fnCreatedCell) {
					oCol.fnCreatedCell.call(oSettings.oInstance, nTd, _fnGetCellData(oSettings, iRow, i), rowData, iRow, i);
				}
			}

			_fnCallbackFire(oSettings, 'aoRowCreatedCallback', null, [nTr, rowData, iRow]);
		}

		// Remove once webkit bug 131819 and Chromium bug 365619 have been resolved
		// and deployed
		row.nTr.setAttribute('role', 'row');
	}

	/**
  * Add attributes to a row based on the special `DT_*` parameters in a data
  * source object.
  *  @param {object} settings DataTables settings object
  *  @param {object} DataTables row object for the row to be modified
  *  @memberof DataTable#oApi
  */
	function _fnRowAttributes(settings, row) {
		var tr = row.nTr;
		var data = row._aData;

		if (tr) {
			var id = settings.rowIdFn(data);

			if (id) {
				tr.id = id;
			}

			if (data.DT_RowClass) {
				// Remove any classes added by DT_RowClass before
				var a = data.DT_RowClass.split(' ');
				row.__rowc = row.__rowc ? _unique(row.__rowc.concat(a)) : a;

				$(tr).removeClass(row.__rowc.join(' ')).addClass(data.DT_RowClass);
			}

			if (data.DT_RowAttr) {
				$(tr).attr(data.DT_RowAttr);
			}

			if (data.DT_RowData) {
				$(tr).data(data.DT_RowData);
			}
		}
	}

	/**
  * Create the HTML header for the table
  *  @param {object} oSettings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnBuildHead(oSettings) {
		var i, ien, cell, row, column;
		var thead = oSettings.nTHead;
		var tfoot = oSettings.nTFoot;
		var createHeader = $('th, td', thead).length === 0;
		var classes = oSettings.oClasses;
		var columns = oSettings.aoColumns;

		if (createHeader) {
			row = $('<tr/>').appendTo(thead);
		}

		for (i = 0, ien = columns.length; i < ien; i++) {
			column = columns[i];
			cell = $(column.nTh).addClass(column.sClass);

			if (createHeader) {
				cell.appendTo(row);
			}

			// 1.11 move into sorting
			if (oSettings.oFeatures.bSort) {
				cell.addClass(column.sSortingClass);

				if (column.bSortable !== false) {
					cell.attr('tabindex', oSettings.iTabIndex).attr('aria-controls', oSettings.sTableId);

					_fnSortAttachListener(oSettings, column.nTh, i);
				}
			}

			if (column.sTitle != cell[0].innerHTML) {
				cell.html(column.sTitle);
			}

			_fnRenderer(oSettings, 'header')(oSettings, cell, column, classes);
		}

		if (createHeader) {
			_fnDetectHeader(oSettings.aoHeader, thead);
		}

		/* ARIA role for the rows */
		$(thead).find('>tr').attr('role', 'row');

		/* Deal with the footer - add classes if required */
		$(thead).find('>tr>th, >tr>td').addClass(classes.sHeaderTH);
		$(tfoot).find('>tr>th, >tr>td').addClass(classes.sFooterTH);

		// Cache the footer cells. Note that we only take the cells from the first
		// row in the footer. If there is more than one row the user wants to
		// interact with, they need to use the table().foot() method. Note also this
		// allows cells to be used for multiple columns using colspan
		if (tfoot !== null) {
			var cells = oSettings.aoFooter[0];

			for (i = 0, ien = cells.length; i < ien; i++) {
				column = columns[i];
				column.nTf = cells[i].cell;

				if (column.sClass) {
					$(column.nTf).addClass(column.sClass);
				}
			}
		}
	}

	/**
  * Draw the header (or footer) element based on the column visibility states. The
  * methodology here is to use the layout array from _fnDetectHeader, modified for
  * the instantaneous column visibility, to construct the new layout. The grid is
  * traversed over cell at a time in a rows x columns grid fashion, although each
  * cell insert can cover multiple elements in the grid - which is tracks using the
  * aApplied array. Cell inserts in the grid will only occur where there isn't
  * already a cell in that position.
  *  @param {object} oSettings dataTables settings object
  *  @param array {objects} aoSource Layout array from _fnDetectHeader
  *  @param {boolean} [bIncludeHidden=false] If true then include the hidden columns in the calc,
  *  @memberof DataTable#oApi
  */
	function _fnDrawHead(oSettings, aoSource, bIncludeHidden) {
		var i, iLen, j, jLen, k, kLen, n, nLocalTr;
		var aoLocal = [];
		var aApplied = [];
		var iColumns = oSettings.aoColumns.length;
		var iRowspan, iColspan;

		if (!aoSource) {
			return;
		}

		if (bIncludeHidden === undefined) {
			bIncludeHidden = false;
		}

		/* Make a copy of the master layout array, but without the visible columns in it */
		for (i = 0, iLen = aoSource.length; i < iLen; i++) {
			aoLocal[i] = aoSource[i].slice();
			aoLocal[i].nTr = aoSource[i].nTr;

			/* Remove any columns which are currently hidden */
			for (j = iColumns - 1; j >= 0; j--) {
				if (!oSettings.aoColumns[j].bVisible && !bIncludeHidden) {
					aoLocal[i].splice(j, 1);
				}
			}

			/* Prep the applied array - it needs an element for each row */
			aApplied.push([]);
		}

		for (i = 0, iLen = aoLocal.length; i < iLen; i++) {
			nLocalTr = aoLocal[i].nTr;

			/* All cells are going to be replaced, so empty out the row */
			if (nLocalTr) {
				while (n = nLocalTr.firstChild) {
					nLocalTr.removeChild(n);
				}
			}

			for (j = 0, jLen = aoLocal[i].length; j < jLen; j++) {
				iRowspan = 1;
				iColspan = 1;

				/* Check to see if there is already a cell (row/colspan) covering our target
     * insert point. If there is, then there is nothing to do.
     */
				if (aApplied[i][j] === undefined) {
					nLocalTr.appendChild(aoLocal[i][j].cell);
					aApplied[i][j] = 1;

					/* Expand the cell to cover as many rows as needed */
					while (aoLocal[i + iRowspan] !== undefined && aoLocal[i][j].cell == aoLocal[i + iRowspan][j].cell) {
						aApplied[i + iRowspan][j] = 1;
						iRowspan++;
					}

					/* Expand the cell to cover as many columns as needed */
					while (aoLocal[i][j + iColspan] !== undefined && aoLocal[i][j].cell == aoLocal[i][j + iColspan].cell) {
						/* Must update the applied array over the rows for the columns */
						for (k = 0; k < iRowspan; k++) {
							aApplied[i + k][j + iColspan] = 1;
						}
						iColspan++;
					}

					/* Do the actual expansion in the DOM */
					$(aoLocal[i][j].cell).attr('rowspan', iRowspan).attr('colspan', iColspan);
				}
			}
		}
	}

	/**
  * Insert the required TR nodes into the table for display
  *  @param {object} oSettings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnDraw(oSettings) {
		/* Provide a pre-callback function which can be used to cancel the draw is false is returned */
		var aPreDraw = _fnCallbackFire(oSettings, 'aoPreDrawCallback', 'preDraw', [oSettings]);
		if ($.inArray(false, aPreDraw) !== -1) {
			_fnProcessingDisplay(oSettings, false);
			return;
		}

		var i, iLen, n;
		var anRows = [];
		var iRowCount = 0;
		var asStripeClasses = oSettings.asStripeClasses;
		var iStripes = asStripeClasses.length;
		var iOpenRows = oSettings.aoOpenRows.length;
		var oLang = oSettings.oLanguage;
		var iInitDisplayStart = oSettings.iInitDisplayStart;
		var bServerSide = _fnDataSource(oSettings) == 'ssp';
		var aiDisplay = oSettings.aiDisplay;

		oSettings.bDrawing = true;

		/* Check and see if we have an initial draw position from state saving */
		if (iInitDisplayStart !== undefined && iInitDisplayStart !== -1) {
			oSettings._iDisplayStart = bServerSide ? iInitDisplayStart : iInitDisplayStart >= oSettings.fnRecordsDisplay() ? 0 : iInitDisplayStart;

			oSettings.iInitDisplayStart = -1;
		}

		var iDisplayStart = oSettings._iDisplayStart;
		var iDisplayEnd = oSettings.fnDisplayEnd();

		/* Server-side processing draw intercept */
		if (oSettings.bDeferLoading) {
			oSettings.bDeferLoading = false;
			oSettings.iDraw++;
			_fnProcessingDisplay(oSettings, false);
		} else if (!bServerSide) {
			oSettings.iDraw++;
		} else if (!oSettings.bDestroying && !_fnAjaxUpdate(oSettings)) {
			return;
		}

		if (aiDisplay.length !== 0) {
			var iStart = bServerSide ? 0 : iDisplayStart;
			var iEnd = bServerSide ? oSettings.aoData.length : iDisplayEnd;

			for (var j = iStart; j < iEnd; j++) {
				var iDataIndex = aiDisplay[j];
				var aoData = oSettings.aoData[iDataIndex];
				if (aoData.nTr === null) {
					_fnCreateTr(oSettings, iDataIndex);
				}

				var nRow = aoData.nTr;

				/* Remove the old striping classes and then add the new one */
				if (iStripes !== 0) {
					var sStripe = asStripeClasses[iRowCount % iStripes];
					if (aoData._sRowStripe != sStripe) {
						$(nRow).removeClass(aoData._sRowStripe).addClass(sStripe);
						aoData._sRowStripe = sStripe;
					}
				}

				// Row callback functions - might want to manipulate the row
				// iRowCount and j are not currently documented. Are they at all
				// useful?
				_fnCallbackFire(oSettings, 'aoRowCallback', null, [nRow, aoData._aData, iRowCount, j]);

				anRows.push(nRow);
				iRowCount++;
			}
		} else {
			/* Table is empty - create a row with an empty message in it */
			var sZero = oLang.sZeroRecords;
			if (oSettings.iDraw == 1 && _fnDataSource(oSettings) == 'ajax') {
				sZero = oLang.sLoadingRecords;
			} else if (oLang.sEmptyTable && oSettings.fnRecordsTotal() === 0) {
				sZero = oLang.sEmptyTable;
			}

			anRows[0] = $('<tr/>', { 'class': iStripes ? asStripeClasses[0] : '' }).append($('<td />', {
				'valign': 'top',
				'colSpan': _fnVisbleColumns(oSettings),
				'class': oSettings.oClasses.sRowEmpty
			}).html(sZero))[0];
		}

		/* Header and footer callbacks */
		_fnCallbackFire(oSettings, 'aoHeaderCallback', 'header', [$(oSettings.nTHead).children('tr')[0], _fnGetDataMaster(oSettings), iDisplayStart, iDisplayEnd, aiDisplay]);

		_fnCallbackFire(oSettings, 'aoFooterCallback', 'footer', [$(oSettings.nTFoot).children('tr')[0], _fnGetDataMaster(oSettings), iDisplayStart, iDisplayEnd, aiDisplay]);

		var body = $(oSettings.nTBody);

		body.children().detach();
		body.append($(anRows));

		/* Call all required callback functions for the end of a draw */
		_fnCallbackFire(oSettings, 'aoDrawCallback', 'draw', [oSettings]);

		/* Draw is complete, sorting and filtering must be as well */
		oSettings.bSorted = false;
		oSettings.bFiltered = false;
		oSettings.bDrawing = false;
	}

	/**
  * Redraw the table - taking account of the various features which are enabled
  *  @param {object} oSettings dataTables settings object
  *  @param {boolean} [holdPosition] Keep the current paging position. By default
  *    the paging is reset to the first page
  *  @memberof DataTable#oApi
  */
	function _fnReDraw(settings, holdPosition) {
		var features = settings.oFeatures,
		    sort = features.bSort,
		    filter = features.bFilter;

		if (sort) {
			_fnSort(settings);
		}

		if (filter) {
			_fnFilterComplete(settings, settings.oPreviousSearch);
		} else {
			// No filtering, so we want to just use the display master
			settings.aiDisplay = settings.aiDisplayMaster.slice();
		}

		if (holdPosition !== true) {
			settings._iDisplayStart = 0;
		}

		// Let any modules know about the draw hold position state (used by
		// scrolling internally)
		settings._drawHold = holdPosition;

		_fnDraw(settings);

		settings._drawHold = false;
	}

	/**
  * Add the options to the page HTML for the table
  *  @param {object} oSettings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnAddOptionsHtml(oSettings) {
		var classes = oSettings.oClasses;
		var table = $(oSettings.nTable);
		var holding = $('<div/>').insertBefore(table); // Holding element for speed
		var features = oSettings.oFeatures;

		// All DataTables are wrapped in a div
		var insert = $('<div/>', {
			id: oSettings.sTableId + '_wrapper',
			'class': classes.sWrapper + (oSettings.nTFoot ? '' : ' ' + classes.sNoFooter)
		});

		oSettings.nHolding = holding[0];
		oSettings.nTableWrapper = insert[0];
		oSettings.nTableReinsertBefore = oSettings.nTable.nextSibling;

		/* Loop over the user set positioning and place the elements as needed */
		var aDom = oSettings.sDom.split('');
		var featureNode, cOption, nNewNode, cNext, sAttr, j;
		for (var i = 0; i < aDom.length; i++) {
			featureNode = null;
			cOption = aDom[i];

			if (cOption == '<') {
				/* New container div */
				nNewNode = $('<div/>')[0];

				/* Check to see if we should append an id and/or a class name to the container */
				cNext = aDom[i + 1];
				if (cNext == "'" || cNext == '"') {
					sAttr = "";
					j = 2;
					while (aDom[i + j] != cNext) {
						sAttr += aDom[i + j];
						j++;
					}

					/* Replace jQuery UI constants @todo depreciated */
					if (sAttr == "H") {
						sAttr = classes.sJUIHeader;
					} else if (sAttr == "F") {
						sAttr = classes.sJUIFooter;
					}

					/* The attribute can be in the format of "#id.class", "#id" or "class" This logic
      * breaks the string into parts and applies them as needed
      */
					if (sAttr.indexOf('.') != -1) {
						var aSplit = sAttr.split('.');
						nNewNode.id = aSplit[0].substr(1, aSplit[0].length - 1);
						nNewNode.className = aSplit[1];
					} else if (sAttr.charAt(0) == "#") {
						nNewNode.id = sAttr.substr(1, sAttr.length - 1);
					} else {
						nNewNode.className = sAttr;
					}

					i += j; /* Move along the position array */
				}

				insert.append(nNewNode);
				insert = $(nNewNode);
			} else if (cOption == '>') {
				/* End container div */
				insert = insert.parent();
			}
			// @todo Move options into their own plugins?
			else if (cOption == 'l' && features.bPaginate && features.bLengthChange) {
					/* Length */
					featureNode = _fnFeatureHtmlLength(oSettings);
				} else if (cOption == 'f' && features.bFilter) {
					/* Filter */
					featureNode = _fnFeatureHtmlFilter(oSettings);
				} else if (cOption == 'r' && features.bProcessing) {
					/* pRocessing */
					featureNode = _fnFeatureHtmlProcessing(oSettings);
				} else if (cOption == 't') {
					/* Table */
					featureNode = _fnFeatureHtmlTable(oSettings);
				} else if (cOption == 'i' && features.bInfo) {
					/* Info */
					featureNode = _fnFeatureHtmlInfo(oSettings);
				} else if (cOption == 'p' && features.bPaginate) {
					/* Pagination */
					featureNode = _fnFeatureHtmlPaginate(oSettings);
				} else if (DataTable.ext.feature.length !== 0) {
					/* Plug-in features */
					var aoFeatures = DataTable.ext.feature;
					for (var k = 0, kLen = aoFeatures.length; k < kLen; k++) {
						if (cOption == aoFeatures[k].cFeature) {
							featureNode = aoFeatures[k].fnInit(oSettings);
							break;
						}
					}
				}

			/* Add to the 2D features array */
			if (featureNode) {
				var aanFeatures = oSettings.aanFeatures;

				if (!aanFeatures[cOption]) {
					aanFeatures[cOption] = [];
				}

				aanFeatures[cOption].push(featureNode);
				insert.append(featureNode);
			}
		}

		/* Built our DOM structure - replace the holding div with what we want */
		holding.replaceWith(insert);
		oSettings.nHolding = null;
	}

	/**
  * Use the DOM source to create up an array of header cells. The idea here is to
  * create a layout grid (array) of rows x columns, which contains a reference
  * to the cell that that point in the grid (regardless of col/rowspan), such that
  * any column / row could be removed and the new grid constructed
  *  @param array {object} aLayout Array to store the calculated layout in
  *  @param {node} nThead The header/footer element for the table
  *  @memberof DataTable#oApi
  */
	function _fnDetectHeader(aLayout, nThead) {
		var nTrs = $(nThead).children('tr');
		var nTr, nCell;
		var i, k, l, iLen, jLen, iColShifted, iColumn, iColspan, iRowspan;
		var bUnique;
		var fnShiftCol = function fnShiftCol(a, i, j) {
			var k = a[i];
			while (k[j]) {
				j++;
			}
			return j;
		};

		aLayout.splice(0, aLayout.length);

		/* We know how many rows there are in the layout - so prep it */
		for (i = 0, iLen = nTrs.length; i < iLen; i++) {
			aLayout.push([]);
		}

		/* Calculate a layout array */
		for (i = 0, iLen = nTrs.length; i < iLen; i++) {
			nTr = nTrs[i];
			iColumn = 0;

			/* For every cell in the row... */
			nCell = nTr.firstChild;
			while (nCell) {
				if (nCell.nodeName.toUpperCase() == "TD" || nCell.nodeName.toUpperCase() == "TH") {
					/* Get the col and rowspan attributes from the DOM and sanitise them */
					iColspan = nCell.getAttribute('colspan') * 1;
					iRowspan = nCell.getAttribute('rowspan') * 1;
					iColspan = !iColspan || iColspan === 0 || iColspan === 1 ? 1 : iColspan;
					iRowspan = !iRowspan || iRowspan === 0 || iRowspan === 1 ? 1 : iRowspan;

					/* There might be colspan cells already in this row, so shift our target
      * accordingly
      */
					iColShifted = fnShiftCol(aLayout, i, iColumn);

					/* Cache calculation for unique columns */
					bUnique = iColspan === 1 ? true : false;

					/* If there is col / rowspan, copy the information into the layout grid */
					for (l = 0; l < iColspan; l++) {
						for (k = 0; k < iRowspan; k++) {
							aLayout[i + k][iColShifted + l] = {
								"cell": nCell,
								"unique": bUnique
							};
							aLayout[i + k].nTr = nTr;
						}
					}
				}
				nCell = nCell.nextSibling;
			}
		}
	}

	/**
  * Get an array of unique th elements, one for each column
  *  @param {object} oSettings dataTables settings object
  *  @param {node} nHeader automatically detect the layout from this node - optional
  *  @param {array} aLayout thead/tfoot layout from _fnDetectHeader - optional
  *  @returns array {node} aReturn list of unique th's
  *  @memberof DataTable#oApi
  */
	function _fnGetUniqueThs(oSettings, nHeader, aLayout) {
		var aReturn = [];
		if (!aLayout) {
			aLayout = oSettings.aoHeader;
			if (nHeader) {
				aLayout = [];
				_fnDetectHeader(aLayout, nHeader);
			}
		}

		for (var i = 0, iLen = aLayout.length; i < iLen; i++) {
			for (var j = 0, jLen = aLayout[i].length; j < jLen; j++) {
				if (aLayout[i][j].unique && (!aReturn[j] || !oSettings.bSortCellsTop)) {
					aReturn[j] = aLayout[i][j].cell;
				}
			}
		}

		return aReturn;
	}

	/**
  * Create an Ajax call based on the table's settings, taking into account that
  * parameters can have multiple forms, and backwards compatibility.
  *
  * @param {object} oSettings dataTables settings object
  * @param {array} data Data to send to the server, required by
  *     DataTables - may be augmented by developer callbacks
  * @param {function} fn Callback function to run when data is obtained
  */
	function _fnBuildAjax(oSettings, data, fn) {
		// Compatibility with 1.9-, allow fnServerData and event to manipulate
		_fnCallbackFire(oSettings, 'aoServerParams', 'serverParams', [data]);

		// Convert to object based for 1.10+ if using the old array scheme which can
		// come from server-side processing or serverParams
		if (data && $.isArray(data)) {
			var tmp = {};
			var rbracket = /(.*?)\[\]$/;

			$.each(data, function (key, val) {
				var match = val.name.match(rbracket);

				if (match) {
					// Support for arrays
					var name = match[0];

					if (!tmp[name]) {
						tmp[name] = [];
					}
					tmp[name].push(val.value);
				} else {
					tmp[val.name] = val.value;
				}
			});
			data = tmp;
		}

		var ajaxData;
		var ajax = oSettings.ajax;
		var instance = oSettings.oInstance;
		var callback = function callback(json) {
			_fnCallbackFire(oSettings, null, 'xhr', [oSettings, json, oSettings.jqXHR]);
			fn(json);
		};

		if ($.isPlainObject(ajax) && ajax.data) {
			ajaxData = ajax.data;

			var newData = $.isFunction(ajaxData) ? ajaxData(data, oSettings) : // fn can manipulate data or return
			ajaxData; // an object object or array to merge

			// If the function returned something, use that alone
			data = $.isFunction(ajaxData) && newData ? newData : $.extend(true, data, newData);

			// Remove the data property as we've resolved it already and don't want
			// jQuery to do it again (it is restored at the end of the function)
			delete ajax.data;
		}

		var baseAjax = {
			"data": data,
			"success": function success(json) {
				var error = json.error || json.sError;
				if (error) {
					_fnLog(oSettings, 0, error);
				}

				oSettings.json = json;
				callback(json);
			},
			"dataType": "json",
			"cache": false,
			"type": oSettings.sServerMethod,
			"error": function error(xhr, _error, thrown) {
				var ret = _fnCallbackFire(oSettings, null, 'xhr', [oSettings, null, oSettings.jqXHR]);

				if ($.inArray(true, ret) === -1) {
					if (_error == "parsererror") {
						_fnLog(oSettings, 0, 'Invalid JSON response', 1);
					} else if (xhr.readyState === 4) {
						_fnLog(oSettings, 0, 'Ajax error', 7);
					}
				}

				_fnProcessingDisplay(oSettings, false);
			}
		};

		// Store the data submitted for the API
		oSettings.oAjaxData = data;

		// Allow plug-ins and external processes to modify the data
		_fnCallbackFire(oSettings, null, 'preXhr', [oSettings, data]);

		if (oSettings.fnServerData) {
			// DataTables 1.9- compatibility
			oSettings.fnServerData.call(instance, oSettings.sAjaxSource, $.map(data, function (val, key) {
				// Need to convert back to 1.9 trad format
				return { name: key, value: val };
			}), callback, oSettings);
		} else if (oSettings.sAjaxSource || typeof ajax === 'string') {
			// DataTables 1.9- compatibility
			oSettings.jqXHR = $.ajax($.extend(baseAjax, {
				url: ajax || oSettings.sAjaxSource
			}));
		} else if ($.isFunction(ajax)) {
			// Is a function - let the caller define what needs to be done
			oSettings.jqXHR = ajax.call(instance, data, callback, oSettings);
		} else {
			// Object to extend the base settings
			oSettings.jqXHR = $.ajax($.extend(baseAjax, ajax));

			// Restore for next time around
			ajax.data = ajaxData;
		}
	}

	/**
  * Update the table using an Ajax call
  *  @param {object} settings dataTables settings object
  *  @returns {boolean} Block the table drawing or not
  *  @memberof DataTable#oApi
  */
	function _fnAjaxUpdate(settings) {
		if (settings.bAjaxDataGet) {
			settings.iDraw++;
			_fnProcessingDisplay(settings, true);

			_fnBuildAjax(settings, _fnAjaxParameters(settings), function (json) {
				_fnAjaxUpdateDraw(settings, json);
			});

			return false;
		}
		return true;
	}

	/**
  * Build up the parameters in an object needed for a server-side processing
  * request. Note that this is basically done twice, is different ways - a modern
  * method which is used by default in DataTables 1.10 which uses objects and
  * arrays, or the 1.9- method with is name / value pairs. 1.9 method is used if
  * the sAjaxSource option is used in the initialisation, or the legacyAjax
  * option is set.
  *  @param {object} oSettings dataTables settings object
  *  @returns {bool} block the table drawing or not
  *  @memberof DataTable#oApi
  */
	function _fnAjaxParameters(settings) {
		var columns = settings.aoColumns,
		    columnCount = columns.length,
		    features = settings.oFeatures,
		    preSearch = settings.oPreviousSearch,
		    preColSearch = settings.aoPreSearchCols,
		    i,
		    data = [],
		    dataProp,
		    column,
		    columnSearch,
		    sort = _fnSortFlatten(settings),
		    displayStart = settings._iDisplayStart,
		    displayLength = features.bPaginate !== false ? settings._iDisplayLength : -1;

		var param = function param(name, value) {
			data.push({ 'name': name, 'value': value });
		};

		// DataTables 1.9- compatible method
		param('sEcho', settings.iDraw);
		param('iColumns', columnCount);
		param('sColumns', _pluck(columns, 'sName').join(','));
		param('iDisplayStart', displayStart);
		param('iDisplayLength', displayLength);

		// DataTables 1.10+ method
		var d = {
			draw: settings.iDraw,
			columns: [],
			order: [],
			start: displayStart,
			length: displayLength,
			search: {
				value: preSearch.sSearch,
				regex: preSearch.bRegex
			}
		};

		for (i = 0; i < columnCount; i++) {
			column = columns[i];
			columnSearch = preColSearch[i];
			dataProp = typeof column.mData == "function" ? 'function' : column.mData;

			d.columns.push({
				data: dataProp,
				name: column.sName,
				searchable: column.bSearchable,
				orderable: column.bSortable,
				search: {
					value: columnSearch.sSearch,
					regex: columnSearch.bRegex
				}
			});

			param("mDataProp_" + i, dataProp);

			if (features.bFilter) {
				param('sSearch_' + i, columnSearch.sSearch);
				param('bRegex_' + i, columnSearch.bRegex);
				param('bSearchable_' + i, column.bSearchable);
			}

			if (features.bSort) {
				param('bSortable_' + i, column.bSortable);
			}
		}

		if (features.bFilter) {
			param('sSearch', preSearch.sSearch);
			param('bRegex', preSearch.bRegex);
		}

		if (features.bSort) {
			$.each(sort, function (i, val) {
				d.order.push({ column: val.col, dir: val.dir });

				param('iSortCol_' + i, val.col);
				param('sSortDir_' + i, val.dir);
			});

			param('iSortingCols', sort.length);
		}

		// If the legacy.ajax parameter is null, then we automatically decide which
		// form to use, based on sAjaxSource
		var legacy = DataTable.ext.legacy.ajax;
		if (legacy === null) {
			return settings.sAjaxSource ? data : d;
		}

		// Otherwise, if legacy has been specified then we use that to decide on the
		// form
		return legacy ? data : d;
	}

	/**
  * Data the data from the server (nuking the old) and redraw the table
  *  @param {object} oSettings dataTables settings object
  *  @param {object} json json data return from the server.
  *  @param {string} json.sEcho Tracking flag for DataTables to match requests
  *  @param {int} json.iTotalRecords Number of records in the data set, not accounting for filtering
  *  @param {int} json.iTotalDisplayRecords Number of records in the data set, accounting for filtering
  *  @param {array} json.aaData The data to display on this page
  *  @param {string} [json.sColumns] Column ordering (sName, comma separated)
  *  @memberof DataTable#oApi
  */
	function _fnAjaxUpdateDraw(settings, json) {
		// v1.10 uses camelCase variables, while 1.9 uses Hungarian notation.
		// Support both
		var compat = function compat(old, modern) {
			return json[old] !== undefined ? json[old] : json[modern];
		};

		var data = _fnAjaxDataSrc(settings, json);
		var draw = compat('sEcho', 'draw');
		var recordsTotal = compat('iTotalRecords', 'recordsTotal');
		var recordsFiltered = compat('iTotalDisplayRecords', 'recordsFiltered');

		if (draw) {
			// Protect against out of sequence returns
			if (draw * 1 < settings.iDraw) {
				return;
			}
			settings.iDraw = draw * 1;
		}

		_fnClearTable(settings);
		settings._iRecordsTotal = parseInt(recordsTotal, 10);
		settings._iRecordsDisplay = parseInt(recordsFiltered, 10);

		for (var i = 0, ien = data.length; i < ien; i++) {
			_fnAddData(settings, data[i]);
		}
		settings.aiDisplay = settings.aiDisplayMaster.slice();

		settings.bAjaxDataGet = false;
		_fnDraw(settings);

		if (!settings._bInitComplete) {
			_fnInitComplete(settings, json);
		}

		settings.bAjaxDataGet = true;
		_fnProcessingDisplay(settings, false);
	}

	/**
  * Get the data from the JSON data source to use for drawing a table. Using
  * `_fnGetObjectDataFn` allows the data to be sourced from a property of the
  * source object, or from a processing function.
  *  @param {object} oSettings dataTables settings object
  *  @param  {object} json Data source object / array from the server
  *  @return {array} Array of data to use
  */
	function _fnAjaxDataSrc(oSettings, json) {
		var dataSrc = $.isPlainObject(oSettings.ajax) && oSettings.ajax.dataSrc !== undefined ? oSettings.ajax.dataSrc : oSettings.sAjaxDataProp; // Compatibility with 1.9-.

		// Compatibility with 1.9-. In order to read from aaData, check if the
		// default has been changed, if not, check for aaData
		if (dataSrc === 'data') {
			return json.aaData || json[dataSrc];
		}

		return dataSrc !== "" ? _fnGetObjectDataFn(dataSrc)(json) : json;
	}

	/**
  * Generate the node required for filtering text
  *  @returns {node} Filter control element
  *  @param {object} oSettings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnFeatureHtmlFilter(settings) {
		var classes = settings.oClasses;
		var tableId = settings.sTableId;
		var language = settings.oLanguage;
		var previousSearch = settings.oPreviousSearch;
		var features = settings.aanFeatures;
		var input = '<input type="search" class="' + classes.sFilterInput + '"/>';

		var str = language.sSearch;
		str = str.match(/_INPUT_/) ? str.replace('_INPUT_', input) : str + input;

		var filter = $('<div/>', {
			'id': !features.f ? tableId + '_filter' : null,
			'class': classes.sFilter
		}).append($('<label/>').append(str));

		var searchFn = function searchFn() {
			/* Update all other filter input elements for the new display */
			var n = features.f;
			var val = !this.value ? "" : this.value; // mental IE8 fix :-(

			/* Now do the filter */
			if (val != previousSearch.sSearch) {
				_fnFilterComplete(settings, {
					"sSearch": val,
					"bRegex": previousSearch.bRegex,
					"bSmart": previousSearch.bSmart,
					"bCaseInsensitive": previousSearch.bCaseInsensitive
				});

				// Need to redraw, without resorting
				settings._iDisplayStart = 0;
				_fnDraw(settings);
			}
		};

		var searchDelay = settings.searchDelay !== null ? settings.searchDelay : _fnDataSource(settings) === 'ssp' ? 400 : 0;

		var jqFilter = $('input', filter).val(previousSearch.sSearch).attr('placeholder', language.sSearchPlaceholder).on('keyup.DT search.DT input.DT paste.DT cut.DT', searchDelay ? _fnThrottle(searchFn, searchDelay) : searchFn).on('keypress.DT', function (e) {
			/* Prevent form submission */
			if (e.keyCode == 13) {
				return false;
			}
		}).attr('aria-controls', tableId);

		// Update the input elements whenever the table is filtered
		$(settings.nTable).on('search.dt.DT', function (ev, s) {
			if (settings === s) {
				// IE9 throws an 'unknown error' if document.activeElement is used
				// inside an iframe or frame...
				try {
					if (jqFilter[0] !== document.activeElement) {
						jqFilter.val(previousSearch.sSearch);
					}
				} catch (e) {}
			}
		});

		return filter[0];
	}

	/**
  * Filter the table using both the global filter and column based filtering
  *  @param {object} oSettings dataTables settings object
  *  @param {object} oSearch search information
  *  @param {int} [iForce] force a research of the master array (1) or not (undefined or 0)
  *  @memberof DataTable#oApi
  */
	function _fnFilterComplete(oSettings, oInput, iForce) {
		var oPrevSearch = oSettings.oPreviousSearch;
		var aoPrevSearch = oSettings.aoPreSearchCols;
		var fnSaveFilter = function fnSaveFilter(oFilter) {
			/* Save the filtering values */
			oPrevSearch.sSearch = oFilter.sSearch;
			oPrevSearch.bRegex = oFilter.bRegex;
			oPrevSearch.bSmart = oFilter.bSmart;
			oPrevSearch.bCaseInsensitive = oFilter.bCaseInsensitive;
		};
		var fnRegex = function fnRegex(o) {
			// Backwards compatibility with the bEscapeRegex option
			return o.bEscapeRegex !== undefined ? !o.bEscapeRegex : o.bRegex;
		};

		// Resolve any column types that are unknown due to addition or invalidation
		// @todo As per sort - can this be moved into an event handler?
		_fnColumnTypes(oSettings);

		/* In server-side processing all filtering is done by the server, so no point hanging around here */
		if (_fnDataSource(oSettings) != 'ssp') {
			/* Global filter */
			_fnFilter(oSettings, oInput.sSearch, iForce, fnRegex(oInput), oInput.bSmart, oInput.bCaseInsensitive);
			fnSaveFilter(oInput);

			/* Now do the individual column filter */
			for (var i = 0; i < aoPrevSearch.length; i++) {
				_fnFilterColumn(oSettings, aoPrevSearch[i].sSearch, i, fnRegex(aoPrevSearch[i]), aoPrevSearch[i].bSmart, aoPrevSearch[i].bCaseInsensitive);
			}

			/* Custom filtering */
			_fnFilterCustom(oSettings);
		} else {
			fnSaveFilter(oInput);
		}

		/* Tell the draw function we have been filtering */
		oSettings.bFiltered = true;
		_fnCallbackFire(oSettings, null, 'search', [oSettings]);
	}

	/**
  * Apply custom filtering functions
  *  @param {object} oSettings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnFilterCustom(settings) {
		var filters = DataTable.ext.search;
		var displayRows = settings.aiDisplay;
		var row, rowIdx;

		for (var i = 0, ien = filters.length; i < ien; i++) {
			var rows = [];

			// Loop over each row and see if it should be included
			for (var j = 0, jen = displayRows.length; j < jen; j++) {
				rowIdx = displayRows[j];
				row = settings.aoData[rowIdx];

				if (filters[i](settings, row._aFilterData, rowIdx, row._aData, j)) {
					rows.push(rowIdx);
				}
			}

			// So the array reference doesn't break set the results into the
			// existing array
			displayRows.length = 0;
			$.merge(displayRows, rows);
		}
	}

	/**
  * Filter the table on a per-column basis
  *  @param {object} oSettings dataTables settings object
  *  @param {string} sInput string to filter on
  *  @param {int} iColumn column to filter
  *  @param {bool} bRegex treat search string as a regular expression or not
  *  @param {bool} bSmart use smart filtering or not
  *  @param {bool} bCaseInsensitive Do case insenstive matching or not
  *  @memberof DataTable#oApi
  */
	function _fnFilterColumn(settings, searchStr, colIdx, regex, smart, caseInsensitive) {
		if (searchStr === '') {
			return;
		}

		var data;
		var out = [];
		var display = settings.aiDisplay;
		var rpSearch = _fnFilterCreateSearch(searchStr, regex, smart, caseInsensitive);

		for (var i = 0; i < display.length; i++) {
			data = settings.aoData[display[i]]._aFilterData[colIdx];

			if (rpSearch.test(data)) {
				out.push(display[i]);
			}
		}

		settings.aiDisplay = out;
	}

	/**
  * Filter the data table based on user input and draw the table
  *  @param {object} settings dataTables settings object
  *  @param {string} input string to filter on
  *  @param {int} force optional - force a research of the master array (1) or not (undefined or 0)
  *  @param {bool} regex treat as a regular expression or not
  *  @param {bool} smart perform smart filtering or not
  *  @param {bool} caseInsensitive Do case insenstive matching or not
  *  @memberof DataTable#oApi
  */
	function _fnFilter(settings, input, force, regex, smart, caseInsensitive) {
		var rpSearch = _fnFilterCreateSearch(input, regex, smart, caseInsensitive);
		var prevSearch = settings.oPreviousSearch.sSearch;
		var displayMaster = settings.aiDisplayMaster;
		var display, invalidated, i;
		var filtered = [];

		// Need to take account of custom filtering functions - always filter
		if (DataTable.ext.search.length !== 0) {
			force = true;
		}

		// Check if any of the rows were invalidated
		invalidated = _fnFilterData(settings);

		// If the input is blank - we just want the full data set
		if (input.length <= 0) {
			settings.aiDisplay = displayMaster.slice();
		} else {
			// New search - start from the master array
			if (invalidated || force || prevSearch.length > input.length || input.indexOf(prevSearch) !== 0 || settings.bSorted // On resort, the display master needs to be
			// re-filtered since indexes will have changed
			) {
					settings.aiDisplay = displayMaster.slice();
				}

			// Search the display array
			display = settings.aiDisplay;

			for (i = 0; i < display.length; i++) {
				if (rpSearch.test(settings.aoData[display[i]]._sFilterRow)) {
					filtered.push(display[i]);
				}
			}

			settings.aiDisplay = filtered;
		}
	}

	/**
  * Build a regular expression object suitable for searching a table
  *  @param {string} sSearch string to search for
  *  @param {bool} bRegex treat as a regular expression or not
  *  @param {bool} bSmart perform smart filtering or not
  *  @param {bool} bCaseInsensitive Do case insensitive matching or not
  *  @returns {RegExp} constructed object
  *  @memberof DataTable#oApi
  */
	function _fnFilterCreateSearch(search, regex, smart, caseInsensitive) {
		search = regex ? search : _fnEscapeRegex(search);

		if (smart) {
			/* For smart filtering we want to allow the search to work regardless of
    * word order. We also want double quoted text to be preserved, so word
    * order is important - a la google. So this is what we want to
    * generate:
    * 
    * ^(?=.*?\bone\b)(?=.*?\btwo three\b)(?=.*?\bfour\b).*$
    */
			var a = $.map(search.match(/"[^"]+"|[^ ]+/g) || [''], function (word) {
				if (word.charAt(0) === '"') {
					var m = word.match(/^"(.*)"$/);
					word = m ? m[1] : word;
				}

				return word.replace('"', '');
			});

			search = '^(?=.*?' + a.join(')(?=.*?') + ').*$';
		}

		return new RegExp(search, caseInsensitive ? 'i' : '');
	}

	/**
  * Escape a string such that it can be used in a regular expression
  *  @param {string} sVal string to escape
  *  @returns {string} escaped string
  *  @memberof DataTable#oApi
  */
	var _fnEscapeRegex = DataTable.util.escapeRegex;

	var __filter_div = $('<div>')[0];
	var __filter_div_textContent = __filter_div.textContent !== undefined;

	// Update the filtering data for each row if needed (by invalidation or first run)
	function _fnFilterData(settings) {
		var columns = settings.aoColumns;
		var column;
		var i, j, ien, jen, filterData, cellData, row;
		var fomatters = DataTable.ext.type.search;
		var wasInvalidated = false;

		for (i = 0, ien = settings.aoData.length; i < ien; i++) {
			row = settings.aoData[i];

			if (!row._aFilterData) {
				filterData = [];

				for (j = 0, jen = columns.length; j < jen; j++) {
					column = columns[j];

					if (column.bSearchable) {
						cellData = _fnGetCellData(settings, i, j, 'filter');

						if (fomatters[column.sType]) {
							cellData = fomatters[column.sType](cellData);
						}

						// Search in DataTables 1.10 is string based. In 1.11 this
						// should be altered to also allow strict type checking.
						if (cellData === null) {
							cellData = '';
						}

						if (typeof cellData !== 'string' && cellData.toString) {
							cellData = cellData.toString();
						}
					} else {
						cellData = '';
					}

					// If it looks like there is an HTML entity in the string,
					// attempt to decode it so sorting works as expected. Note that
					// we could use a single line of jQuery to do this, but the DOM
					// method used here is much faster http://jsperf.com/html-decode
					if (cellData.indexOf && cellData.indexOf('&') !== -1) {
						__filter_div.innerHTML = cellData;
						cellData = __filter_div_textContent ? __filter_div.textContent : __filter_div.innerText;
					}

					if (cellData.replace) {
						cellData = cellData.replace(/[\r\n]/g, '');
					}

					filterData.push(cellData);
				}

				row._aFilterData = filterData;
				row._sFilterRow = filterData.join('  ');
				wasInvalidated = true;
			}
		}

		return wasInvalidated;
	}

	/**
  * Convert from the internal Hungarian notation to camelCase for external
  * interaction
  *  @param {object} obj Object to convert
  *  @returns {object} Inverted object
  *  @memberof DataTable#oApi
  */
	function _fnSearchToCamel(obj) {
		return {
			search: obj.sSearch,
			smart: obj.bSmart,
			regex: obj.bRegex,
			caseInsensitive: obj.bCaseInsensitive
		};
	}

	/**
  * Convert from camelCase notation to the internal Hungarian. We could use the
  * Hungarian convert function here, but this is cleaner
  *  @param {object} obj Object to convert
  *  @returns {object} Inverted object
  *  @memberof DataTable#oApi
  */
	function _fnSearchToHung(obj) {
		return {
			sSearch: obj.search,
			bSmart: obj.smart,
			bRegex: obj.regex,
			bCaseInsensitive: obj.caseInsensitive
		};
	}

	/**
  * Generate the node required for the info display
  *  @param {object} oSettings dataTables settings object
  *  @returns {node} Information element
  *  @memberof DataTable#oApi
  */
	function _fnFeatureHtmlInfo(settings) {
		var tid = settings.sTableId,
		    nodes = settings.aanFeatures.i,
		    n = $('<div/>', {
			'class': settings.oClasses.sInfo,
			'id': !nodes ? tid + '_info' : null
		});

		if (!nodes) {
			// Update display on each draw
			settings.aoDrawCallback.push({
				"fn": _fnUpdateInfo,
				"sName": "information"
			});

			n.attr('role', 'status').attr('aria-live', 'polite');

			// Table is described by our info div
			$(settings.nTable).attr('aria-describedby', tid + '_info');
		}

		return n[0];
	}

	/**
  * Update the information elements in the display
  *  @param {object} settings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnUpdateInfo(settings) {
		/* Show information about the table */
		var nodes = settings.aanFeatures.i;
		if (nodes.length === 0) {
			return;
		}

		var lang = settings.oLanguage,
		    start = settings._iDisplayStart + 1,
		    end = settings.fnDisplayEnd(),
		    max = settings.fnRecordsTotal(),
		    total = settings.fnRecordsDisplay(),
		    out = total ? lang.sInfo : lang.sInfoEmpty;

		if (total !== max) {
			/* Record set after filtering */
			out += ' ' + lang.sInfoFiltered;
		}

		// Convert the macros
		out += lang.sInfoPostFix;
		out = _fnInfoMacros(settings, out);

		var callback = lang.fnInfoCallback;
		if (callback !== null) {
			out = callback.call(settings.oInstance, settings, start, end, max, total, out);
		}

		$(nodes).html(out);
	}

	function _fnInfoMacros(settings, str) {
		// When infinite scrolling, we are always starting at 1. _iDisplayStart is used only
		// internally
		var formatter = settings.fnFormatNumber,
		    start = settings._iDisplayStart + 1,
		    len = settings._iDisplayLength,
		    vis = settings.fnRecordsDisplay(),
		    all = len === -1;

		return str.replace(/_START_/g, formatter.call(settings, start)).replace(/_END_/g, formatter.call(settings, settings.fnDisplayEnd())).replace(/_MAX_/g, formatter.call(settings, settings.fnRecordsTotal())).replace(/_TOTAL_/g, formatter.call(settings, vis)).replace(/_PAGE_/g, formatter.call(settings, all ? 1 : Math.ceil(start / len))).replace(/_PAGES_/g, formatter.call(settings, all ? 1 : Math.ceil(vis / len)));
	}

	/**
  * Draw the table for the first time, adding all required features
  *  @param {object} settings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnInitialise(settings) {
		var i,
		    iLen,
		    iAjaxStart = settings.iInitDisplayStart;
		var columns = settings.aoColumns,
		    column;
		var features = settings.oFeatures;
		var deferLoading = settings.bDeferLoading; // value modified by the draw

		/* Ensure that the table data is fully initialised */
		if (!settings.bInitialised) {
			setTimeout(function () {
				_fnInitialise(settings);
			}, 200);
			return;
		}

		/* Show the display HTML options */
		_fnAddOptionsHtml(settings);

		/* Build and draw the header / footer for the table */
		_fnBuildHead(settings);
		_fnDrawHead(settings, settings.aoHeader);
		_fnDrawHead(settings, settings.aoFooter);

		/* Okay to show that something is going on now */
		_fnProcessingDisplay(settings, true);

		/* Calculate sizes for columns */
		if (features.bAutoWidth) {
			_fnCalculateColumnWidths(settings);
		}

		for (i = 0, iLen = columns.length; i < iLen; i++) {
			column = columns[i];

			if (column.sWidth) {
				column.nTh.style.width = _fnStringToCss(column.sWidth);
			}
		}

		_fnCallbackFire(settings, null, 'preInit', [settings]);

		// If there is default sorting required - let's do it. The sort function
		// will do the drawing for us. Otherwise we draw the table regardless of the
		// Ajax source - this allows the table to look initialised for Ajax sourcing
		// data (show 'loading' message possibly)
		_fnReDraw(settings);

		// Server-side processing init complete is done by _fnAjaxUpdateDraw
		var dataSrc = _fnDataSource(settings);
		if (dataSrc != 'ssp' || deferLoading) {
			// if there is an ajax source load the data
			if (dataSrc == 'ajax') {
				_fnBuildAjax(settings, [], function (json) {
					var aData = _fnAjaxDataSrc(settings, json);

					// Got the data - add it to the table
					for (i = 0; i < aData.length; i++) {
						_fnAddData(settings, aData[i]);
					}

					// Reset the init display for cookie saving. We've already done
					// a filter, and therefore cleared it before. So we need to make
					// it appear 'fresh'
					settings.iInitDisplayStart = iAjaxStart;

					_fnReDraw(settings);

					_fnProcessingDisplay(settings, false);
					_fnInitComplete(settings, json);
				}, settings);
			} else {
				_fnProcessingDisplay(settings, false);
				_fnInitComplete(settings);
			}
		}
	}

	/**
  * Draw the table for the first time, adding all required features
  *  @param {object} oSettings dataTables settings object
  *  @param {object} [json] JSON from the server that completed the table, if using Ajax source
  *    with client-side processing (optional)
  *  @memberof DataTable#oApi
  */
	function _fnInitComplete(settings, json) {
		settings._bInitComplete = true;

		// When data was added after the initialisation (data or Ajax) we need to
		// calculate the column sizing
		if (json || settings.oInit.aaData) {
			_fnAdjustColumnSizing(settings);
		}

		_fnCallbackFire(settings, null, 'plugin-init', [settings, json]);
		_fnCallbackFire(settings, 'aoInitComplete', 'init', [settings, json]);
	}

	function _fnLengthChange(settings, val) {
		var len = parseInt(val, 10);
		settings._iDisplayLength = len;

		_fnLengthOverflow(settings);

		// Fire length change event
		_fnCallbackFire(settings, null, 'length', [settings, len]);
	}

	/**
  * Generate the node required for user display length changing
  *  @param {object} settings dataTables settings object
  *  @returns {node} Display length feature node
  *  @memberof DataTable#oApi
  */
	function _fnFeatureHtmlLength(settings) {
		var classes = settings.oClasses,
		    tableId = settings.sTableId,
		    menu = settings.aLengthMenu,
		    d2 = $.isArray(menu[0]),
		    lengths = d2 ? menu[0] : menu,
		    language = d2 ? menu[1] : menu;

		var select = $('<select/>', {
			'name': tableId + '_length',
			'aria-controls': tableId,
			'class': classes.sLengthSelect
		});

		for (var i = 0, ien = lengths.length; i < ien; i++) {
			select[0][i] = new Option(language[i], lengths[i]);
		}

		var div = $('<div><label/></div>').addClass(classes.sLength);
		if (!settings.aanFeatures.l) {
			div[0].id = tableId + '_length';
		}

		div.children().append(settings.oLanguage.sLengthMenu.replace('_MENU_', select[0].outerHTML));

		// Can't use `select` variable as user might provide their own and the
		// reference is broken by the use of outerHTML
		$('select', div).val(settings._iDisplayLength).on('change.DT', function (e) {
			_fnLengthChange(settings, $(this).val());
			_fnDraw(settings);
		});

		// Update node value whenever anything changes the table's length
		$(settings.nTable).on('length.dt.DT', function (e, s, len) {
			if (settings === s) {
				$('select', div).val(len);
			}
		});

		return div[0];
	}

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  * Note that most of the paging logic is done in
  * DataTable.ext.pager
  */

	/**
  * Generate the node required for default pagination
  *  @param {object} oSettings dataTables settings object
  *  @returns {node} Pagination feature node
  *  @memberof DataTable#oApi
  */
	function _fnFeatureHtmlPaginate(settings) {
		var type = settings.sPaginationType,
		    plugin = DataTable.ext.pager[type],
		    modern = typeof plugin === 'function',
		    redraw = function redraw(settings) {
			_fnDraw(settings);
		},
		    node = $('<div/>').addClass(settings.oClasses.sPaging + type)[0],
		    features = settings.aanFeatures;

		if (!modern) {
			plugin.fnInit(settings, node, redraw);
		}

		/* Add a draw callback for the pagination on first instance, to update the paging display */
		if (!features.p) {
			node.id = settings.sTableId + '_paginate';

			settings.aoDrawCallback.push({
				"fn": function fn(settings) {
					if (modern) {
						var start = settings._iDisplayStart,
						    len = settings._iDisplayLength,
						    visRecords = settings.fnRecordsDisplay(),
						    all = len === -1,
						    page = all ? 0 : Math.ceil(start / len),
						    pages = all ? 1 : Math.ceil(visRecords / len),
						    buttons = plugin(page, pages),
						    i,
						    ien;

						for (i = 0, ien = features.p.length; i < ien; i++) {
							_fnRenderer(settings, 'pageButton')(settings, features.p[i], i, buttons, page, pages);
						}
					} else {
						plugin.fnUpdate(settings, redraw);
					}
				},
				"sName": "pagination"
			});
		}

		return node;
	}

	/**
  * Alter the display settings to change the page
  *  @param {object} settings DataTables settings object
  *  @param {string|int} action Paging action to take: "first", "previous",
  *    "next" or "last" or page number to jump to (integer)
  *  @param [bool] redraw Automatically draw the update or not
  *  @returns {bool} true page has changed, false - no change
  *  @memberof DataTable#oApi
  */
	function _fnPageChange(settings, action, redraw) {
		var start = settings._iDisplayStart,
		    len = settings._iDisplayLength,
		    records = settings.fnRecordsDisplay();

		if (records === 0 || len === -1) {
			start = 0;
		} else if (typeof action === "number") {
			start = action * len;

			if (start > records) {
				start = 0;
			}
		} else if (action == "first") {
			start = 0;
		} else if (action == "previous") {
			start = len >= 0 ? start - len : 0;

			if (start < 0) {
				start = 0;
			}
		} else if (action == "next") {
			if (start + len < records) {
				start += len;
			}
		} else if (action == "last") {
			start = Math.floor((records - 1) / len) * len;
		} else {
			_fnLog(settings, 0, "Unknown paging action: " + action, 5);
		}

		var changed = settings._iDisplayStart !== start;
		settings._iDisplayStart = start;

		if (changed) {
			_fnCallbackFire(settings, null, 'page', [settings]);

			if (redraw) {
				_fnDraw(settings);
			}
		}

		return changed;
	}

	/**
  * Generate the node required for the processing node
  *  @param {object} settings dataTables settings object
  *  @returns {node} Processing element
  *  @memberof DataTable#oApi
  */
	function _fnFeatureHtmlProcessing(settings) {
		return $('<div/>', {
			'id': !settings.aanFeatures.r ? settings.sTableId + '_processing' : null,
			'class': settings.oClasses.sProcessing
		}).html(settings.oLanguage.sProcessing).insertBefore(settings.nTable)[0];
	}

	/**
  * Display or hide the processing indicator
  *  @param {object} settings dataTables settings object
  *  @param {bool} show Show the processing indicator (true) or not (false)
  *  @memberof DataTable#oApi
  */
	function _fnProcessingDisplay(settings, show) {
		if (settings.oFeatures.bProcessing) {
			$(settings.aanFeatures.r).css('display', show ? 'block' : 'none');
		}

		_fnCallbackFire(settings, null, 'processing', [settings, show]);
	}

	/**
  * Add any control elements for the table - specifically scrolling
  *  @param {object} settings dataTables settings object
  *  @returns {node} Node to add to the DOM
  *  @memberof DataTable#oApi
  */
	function _fnFeatureHtmlTable(settings) {
		var table = $(settings.nTable);

		// Add the ARIA grid role to the table
		table.attr('role', 'grid');

		// Scrolling from here on in
		var scroll = settings.oScroll;

		if (scroll.sX === '' && scroll.sY === '') {
			return settings.nTable;
		}

		var scrollX = scroll.sX;
		var scrollY = scroll.sY;
		var classes = settings.oClasses;
		var caption = table.children('caption');
		var captionSide = caption.length ? caption[0]._captionSide : null;
		var headerClone = $(table[0].cloneNode(false));
		var footerClone = $(table[0].cloneNode(false));
		var footer = table.children('tfoot');
		var _div = '<div/>';
		var size = function size(s) {
			return !s ? null : _fnStringToCss(s);
		};

		if (!footer.length) {
			footer = null;
		}

		/*
   * The HTML structure that we want to generate in this function is:
   *  div - scroller
   *    div - scroll head
   *      div - scroll head inner
   *        table - scroll head table
   *          thead - thead
   *    div - scroll body
   *      table - table (master table)
   *        thead - thead clone for sizing
   *        tbody - tbody
   *    div - scroll foot
   *      div - scroll foot inner
   *        table - scroll foot table
   *          tfoot - tfoot
   */
		var scroller = $(_div, { 'class': classes.sScrollWrapper }).append($(_div, { 'class': classes.sScrollHead }).css({
			overflow: 'hidden',
			position: 'relative',
			border: 0,
			width: scrollX ? size(scrollX) : '100%'
		}).append($(_div, { 'class': classes.sScrollHeadInner }).css({
			'box-sizing': 'content-box',
			width: scroll.sXInner || '100%'
		}).append(headerClone.removeAttr('id').css('margin-left', 0).append(captionSide === 'top' ? caption : null).append(table.children('thead'))))).append($(_div, { 'class': classes.sScrollBody }).css({
			position: 'relative',
			overflow: 'auto',
			width: size(scrollX)
		}).append(table));

		if (footer) {
			scroller.append($(_div, { 'class': classes.sScrollFoot }).css({
				overflow: 'hidden',
				border: 0,
				width: scrollX ? size(scrollX) : '100%'
			}).append($(_div, { 'class': classes.sScrollFootInner }).append(footerClone.removeAttr('id').css('margin-left', 0).append(captionSide === 'bottom' ? caption : null).append(table.children('tfoot')))));
		}

		var children = scroller.children();
		var scrollHead = children[0];
		var scrollBody = children[1];
		var scrollFoot = footer ? children[2] : null;

		// When the body is scrolled, then we also want to scroll the headers
		if (scrollX) {
			$(scrollBody).on('scroll.DT', function (e) {
				var scrollLeft = this.scrollLeft;

				scrollHead.scrollLeft = scrollLeft;

				if (footer) {
					scrollFoot.scrollLeft = scrollLeft;
				}
			});
		}

		$(scrollBody).css(scrollY && scroll.bCollapse ? 'max-height' : 'height', scrollY);

		settings.nScrollHead = scrollHead;
		settings.nScrollBody = scrollBody;
		settings.nScrollFoot = scrollFoot;

		// On redraw - align columns
		settings.aoDrawCallback.push({
			"fn": _fnScrollDraw,
			"sName": "scrolling"
		});

		return scroller[0];
	}

	/**
  * Update the header, footer and body tables for resizing - i.e. column
  * alignment.
  *
  * Welcome to the most horrible function DataTables. The process that this
  * function follows is basically:
  *   1. Re-create the table inside the scrolling div
  *   2. Take live measurements from the DOM
  *   3. Apply the measurements to align the columns
  *   4. Clean up
  *
  *  @param {object} settings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnScrollDraw(settings) {
		// Given that this is such a monster function, a lot of variables are use
		// to try and keep the minimised size as small as possible
		var scroll = settings.oScroll,
		    scrollX = scroll.sX,
		    scrollXInner = scroll.sXInner,
		    scrollY = scroll.sY,
		    barWidth = scroll.iBarWidth,
		    divHeader = $(settings.nScrollHead),
		    divHeaderStyle = divHeader[0].style,
		    divHeaderInner = divHeader.children('div'),
		    divHeaderInnerStyle = divHeaderInner[0].style,
		    divHeaderTable = divHeaderInner.children('table'),
		    divBodyEl = settings.nScrollBody,
		    divBody = $(divBodyEl),
		    divBodyStyle = divBodyEl.style,
		    divFooter = $(settings.nScrollFoot),
		    divFooterInner = divFooter.children('div'),
		    divFooterTable = divFooterInner.children('table'),
		    header = $(settings.nTHead),
		    table = $(settings.nTable),
		    tableEl = table[0],
		    tableStyle = tableEl.style,
		    footer = settings.nTFoot ? $(settings.nTFoot) : null,
		    browser = settings.oBrowser,
		    ie67 = browser.bScrollOversize,
		    dtHeaderCells = _pluck(settings.aoColumns, 'nTh'),
		    headerTrgEls,
		    footerTrgEls,
		    headerSrcEls,
		    footerSrcEls,
		    headerCopy,
		    footerCopy,
		    headerWidths = [],
		    footerWidths = [],
		    headerContent = [],
		    footerContent = [],
		    idx,
		    correction,
		    sanityWidth,
		    zeroOut = function zeroOut(nSizer) {
			var style = nSizer.style;
			style.paddingTop = "0";
			style.paddingBottom = "0";
			style.borderTopWidth = "0";
			style.borderBottomWidth = "0";
			style.height = 0;
		};

		// If the scrollbar visibility has changed from the last draw, we need to
		// adjust the column sizes as the table width will have changed to account
		// for the scrollbar
		var scrollBarVis = divBodyEl.scrollHeight > divBodyEl.clientHeight;

		if (settings.scrollBarVis !== scrollBarVis && settings.scrollBarVis !== undefined) {
			settings.scrollBarVis = scrollBarVis;
			_fnAdjustColumnSizing(settings);
			return; // adjust column sizing will call this function again
		} else {
			settings.scrollBarVis = scrollBarVis;
		}

		/*
   * 1. Re-create the table inside the scrolling div
   */

		// Remove the old minimised thead and tfoot elements in the inner table
		table.children('thead, tfoot').remove();

		if (footer) {
			footerCopy = footer.clone().prependTo(table);
			footerTrgEls = footer.find('tr'); // the original tfoot is in its own table and must be sized
			footerSrcEls = footerCopy.find('tr');
		}

		// Clone the current header and footer elements and then place it into the inner table
		headerCopy = header.clone().prependTo(table);
		headerTrgEls = header.find('tr'); // original header is in its own table
		headerSrcEls = headerCopy.find('tr');
		headerCopy.find('th, td').removeAttr('tabindex');

		/*
   * 2. Take live measurements from the DOM - do not alter the DOM itself!
   */

		// Remove old sizing and apply the calculated column widths
		// Get the unique column headers in the newly created (cloned) header. We want to apply the
		// calculated sizes to this header
		if (!scrollX) {
			divBodyStyle.width = '100%';
			divHeader[0].style.width = '100%';
		}

		$.each(_fnGetUniqueThs(settings, headerCopy), function (i, el) {
			idx = _fnVisibleToColumnIndex(settings, i);
			el.style.width = settings.aoColumns[idx].sWidth;
		});

		if (footer) {
			_fnApplyToChildren(function (n) {
				n.style.width = "";
			}, footerSrcEls);
		}

		// Size the table as a whole
		sanityWidth = table.outerWidth();
		if (scrollX === "") {
			// No x scrolling
			tableStyle.width = "100%";

			// IE7 will make the width of the table when 100% include the scrollbar
			// - which is shouldn't. When there is a scrollbar we need to take this
			// into account.
			if (ie67 && (table.find('tbody').height() > divBodyEl.offsetHeight || divBody.css('overflow-y') == "scroll")) {
				tableStyle.width = _fnStringToCss(table.outerWidth() - barWidth);
			}

			// Recalculate the sanity width
			sanityWidth = table.outerWidth();
		} else if (scrollXInner !== "") {
			// legacy x scroll inner has been given - use it
			tableStyle.width = _fnStringToCss(scrollXInner);

			// Recalculate the sanity width
			sanityWidth = table.outerWidth();
		}

		// Hidden header should have zero height, so remove padding and borders. Then
		// set the width based on the real headers

		// Apply all styles in one pass
		_fnApplyToChildren(zeroOut, headerSrcEls);

		// Read all widths in next pass
		_fnApplyToChildren(function (nSizer) {
			headerContent.push(nSizer.innerHTML);
			headerWidths.push(_fnStringToCss($(nSizer).css('width')));
		}, headerSrcEls);

		// Apply all widths in final pass
		_fnApplyToChildren(function (nToSize, i) {
			// Only apply widths to the DataTables detected header cells - this
			// prevents complex headers from having contradictory sizes applied
			if ($.inArray(nToSize, dtHeaderCells) !== -1) {
				nToSize.style.width = headerWidths[i];
			}
		}, headerTrgEls);

		$(headerSrcEls).height(0);

		/* Same again with the footer if we have one */
		if (footer) {
			_fnApplyToChildren(zeroOut, footerSrcEls);

			_fnApplyToChildren(function (nSizer) {
				footerContent.push(nSizer.innerHTML);
				footerWidths.push(_fnStringToCss($(nSizer).css('width')));
			}, footerSrcEls);

			_fnApplyToChildren(function (nToSize, i) {
				nToSize.style.width = footerWidths[i];
			}, footerTrgEls);

			$(footerSrcEls).height(0);
		}

		/*
   * 3. Apply the measurements
   */

		// "Hide" the header and footer that we used for the sizing. We need to keep
		// the content of the cell so that the width applied to the header and body
		// both match, but we want to hide it completely. We want to also fix their
		// width to what they currently are
		_fnApplyToChildren(function (nSizer, i) {
			nSizer.innerHTML = '<div class="dataTables_sizing" style="height:0;overflow:hidden;">' + headerContent[i] + '</div>';
			nSizer.style.width = headerWidths[i];
		}, headerSrcEls);

		if (footer) {
			_fnApplyToChildren(function (nSizer, i) {
				nSizer.innerHTML = '<div class="dataTables_sizing" style="height:0;overflow:hidden;">' + footerContent[i] + '</div>';
				nSizer.style.width = footerWidths[i];
			}, footerSrcEls);
		}

		// Sanity check that the table is of a sensible width. If not then we are going to get
		// misalignment - try to prevent this by not allowing the table to shrink below its min width
		if (table.outerWidth() < sanityWidth) {
			// The min width depends upon if we have a vertical scrollbar visible or not */
			correction = divBodyEl.scrollHeight > divBodyEl.offsetHeight || divBody.css('overflow-y') == "scroll" ? sanityWidth + barWidth : sanityWidth;

			// IE6/7 are a law unto themselves...
			if (ie67 && (divBodyEl.scrollHeight > divBodyEl.offsetHeight || divBody.css('overflow-y') == "scroll")) {
				tableStyle.width = _fnStringToCss(correction - barWidth);
			}

			// And give the user a warning that we've stopped the table getting too small
			if (scrollX === "" || scrollXInner !== "") {
				_fnLog(settings, 1, 'Possible column misalignment', 6);
			}
		} else {
			correction = '100%';
		}

		// Apply to the container elements
		divBodyStyle.width = _fnStringToCss(correction);
		divHeaderStyle.width = _fnStringToCss(correction);

		if (footer) {
			settings.nScrollFoot.style.width = _fnStringToCss(correction);
		}

		/*
   * 4. Clean up
   */
		if (!scrollY) {
			/* IE7< puts a vertical scrollbar in place (when it shouldn't be) due to subtracting
    * the scrollbar height from the visible display, rather than adding it on. We need to
    * set the height in order to sort this. Don't want to do it in any other browsers.
    */
			if (ie67) {
				divBodyStyle.height = _fnStringToCss(tableEl.offsetHeight + barWidth);
			}
		}

		/* Finally set the width's of the header and footer tables */
		var iOuterWidth = table.outerWidth();
		divHeaderTable[0].style.width = _fnStringToCss(iOuterWidth);
		divHeaderInnerStyle.width = _fnStringToCss(iOuterWidth);

		// Figure out if there are scrollbar present - if so then we need a the header and footer to
		// provide a bit more space to allow "overflow" scrolling (i.e. past the scrollbar)
		var bScrolling = table.height() > divBodyEl.clientHeight || divBody.css('overflow-y') == "scroll";
		var padding = 'padding' + (browser.bScrollbarLeft ? 'Left' : 'Right');
		divHeaderInnerStyle[padding] = bScrolling ? barWidth + "px" : "0px";

		if (footer) {
			divFooterTable[0].style.width = _fnStringToCss(iOuterWidth);
			divFooterInner[0].style.width = _fnStringToCss(iOuterWidth);
			divFooterInner[0].style[padding] = bScrolling ? barWidth + "px" : "0px";
		}

		// Correct DOM ordering for colgroup - comes before the thead
		table.children('colgroup').insertBefore(table.children('thead'));

		/* Adjust the position of the header in case we loose the y-scrollbar */
		divBody.scroll();

		// If sorting or filtering has occurred, jump the scrolling back to the top
		// only if we aren't holding the position
		if ((settings.bSorted || settings.bFiltered) && !settings._drawHold) {
			divBodyEl.scrollTop = 0;
		}
	}

	/**
  * Apply a given function to the display child nodes of an element array (typically
  * TD children of TR rows
  *  @param {function} fn Method to apply to the objects
  *  @param array {nodes} an1 List of elements to look through for display children
  *  @param array {nodes} an2 Another list (identical structure to the first) - optional
  *  @memberof DataTable#oApi
  */
	function _fnApplyToChildren(fn, an1, an2) {
		var index = 0,
		    i = 0,
		    iLen = an1.length;
		var nNode1, nNode2;

		while (i < iLen) {
			nNode1 = an1[i].firstChild;
			nNode2 = an2 ? an2[i].firstChild : null;

			while (nNode1) {
				if (nNode1.nodeType === 1) {
					if (an2) {
						fn(nNode1, nNode2, index);
					} else {
						fn(nNode1, index);
					}

					index++;
				}

				nNode1 = nNode1.nextSibling;
				nNode2 = an2 ? nNode2.nextSibling : null;
			}

			i++;
		}
	}

	var __re_html_remove = /<.*?>/g;

	/**
  * Calculate the width of columns for the table
  *  @param {object} oSettings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnCalculateColumnWidths(oSettings) {
		var table = oSettings.nTable,
		    columns = oSettings.aoColumns,
		    scroll = oSettings.oScroll,
		    scrollY = scroll.sY,
		    scrollX = scroll.sX,
		    scrollXInner = scroll.sXInner,
		    columnCount = columns.length,
		    visibleColumns = _fnGetColumns(oSettings, 'bVisible'),
		    headerCells = $('th', oSettings.nTHead),
		    tableWidthAttr = table.getAttribute('width'),
		    // from DOM element
		tableContainer = table.parentNode,
		    userInputs = false,
		    i,
		    column,
		    columnIdx,
		    width,
		    outerWidth,
		    browser = oSettings.oBrowser,
		    ie67 = browser.bScrollOversize;

		var styleWidth = table.style.width;
		if (styleWidth && styleWidth.indexOf('%') !== -1) {
			tableWidthAttr = styleWidth;
		}

		/* Convert any user input sizes into pixel sizes */
		for (i = 0; i < visibleColumns.length; i++) {
			column = columns[visibleColumns[i]];

			if (column.sWidth !== null) {
				column.sWidth = _fnConvertToWidth(column.sWidthOrig, tableContainer);

				userInputs = true;
			}
		}

		/* If the number of columns in the DOM equals the number that we have to
   * process in DataTables, then we can use the offsets that are created by
   * the web- browser. No custom sizes can be set in order for this to happen,
   * nor scrolling used
   */
		if (ie67 || !userInputs && !scrollX && !scrollY && columnCount == _fnVisbleColumns(oSettings) && columnCount == headerCells.length) {
			for (i = 0; i < columnCount; i++) {
				var colIdx = _fnVisibleToColumnIndex(oSettings, i);

				if (colIdx !== null) {
					columns[colIdx].sWidth = _fnStringToCss(headerCells.eq(i).width());
				}
			}
		} else {
			// Otherwise construct a single row, worst case, table with the widest
			// node in the data, assign any user defined widths, then insert it into
			// the DOM and allow the browser to do all the hard work of calculating
			// table widths
			var tmpTable = $(table).clone() // don't use cloneNode - IE8 will remove events on the main table
			.css('visibility', 'hidden').removeAttr('id');

			// Clean up the table body
			tmpTable.find('tbody tr').remove();
			var tr = $('<tr/>').appendTo(tmpTable.find('tbody'));

			// Clone the table header and footer - we can't use the header / footer
			// from the cloned table, since if scrolling is active, the table's
			// real header and footer are contained in different table tags
			tmpTable.find('thead, tfoot').remove();
			tmpTable.append($(oSettings.nTHead).clone()).append($(oSettings.nTFoot).clone());

			// Remove any assigned widths from the footer (from scrolling)
			tmpTable.find('tfoot th, tfoot td').css('width', '');

			// Apply custom sizing to the cloned header
			headerCells = _fnGetUniqueThs(oSettings, tmpTable.find('thead')[0]);

			for (i = 0; i < visibleColumns.length; i++) {
				column = columns[visibleColumns[i]];

				headerCells[i].style.width = column.sWidthOrig !== null && column.sWidthOrig !== '' ? _fnStringToCss(column.sWidthOrig) : '';

				// For scrollX we need to force the column width otherwise the
				// browser will collapse it. If this width is smaller than the
				// width the column requires, then it will have no effect
				if (column.sWidthOrig && scrollX) {
					$(headerCells[i]).append($('<div/>').css({
						width: column.sWidthOrig,
						margin: 0,
						padding: 0,
						border: 0,
						height: 1
					}));
				}
			}

			// Find the widest cell for each column and put it into the table
			if (oSettings.aoData.length) {
				for (i = 0; i < visibleColumns.length; i++) {
					columnIdx = visibleColumns[i];
					column = columns[columnIdx];

					$(_fnGetWidestNode(oSettings, columnIdx)).clone(false).append(column.sContentPadding).appendTo(tr);
				}
			}

			// Tidy the temporary table - remove name attributes so there aren't
			// duplicated in the dom (radio elements for example)
			$('[name]', tmpTable).removeAttr('name');

			// Table has been built, attach to the document so we can work with it.
			// A holding element is used, positioned at the top of the container
			// with minimal height, so it has no effect on if the container scrolls
			// or not. Otherwise it might trigger scrolling when it actually isn't
			// needed
			var holder = $('<div/>').css(scrollX || scrollY ? {
				position: 'absolute',
				top: 0,
				left: 0,
				height: 1,
				right: 0,
				overflow: 'hidden'
			} : {}).append(tmpTable).appendTo(tableContainer);

			// When scrolling (X or Y) we want to set the width of the table as 
			// appropriate. However, when not scrolling leave the table width as it
			// is. This results in slightly different, but I think correct behaviour
			if (scrollX && scrollXInner) {
				tmpTable.width(scrollXInner);
			} else if (scrollX) {
				tmpTable.css('width', 'auto');
				tmpTable.removeAttr('width');

				// If there is no width attribute or style, then allow the table to
				// collapse
				if (tmpTable.width() < tableContainer.clientWidth && tableWidthAttr) {
					tmpTable.width(tableContainer.clientWidth);
				}
			} else if (scrollY) {
				tmpTable.width(tableContainer.clientWidth);
			} else if (tableWidthAttr) {
				tmpTable.width(tableWidthAttr);
			}

			// Get the width of each column in the constructed table - we need to
			// know the inner width (so it can be assigned to the other table's
			// cells) and the outer width so we can calculate the full width of the
			// table. This is safe since DataTables requires a unique cell for each
			// column, but if ever a header can span multiple columns, this will
			// need to be modified.
			var total = 0;
			for (i = 0; i < visibleColumns.length; i++) {
				var cell = $(headerCells[i]);
				var border = cell.outerWidth() - cell.width();

				// Use getBounding... where possible (not IE8-) because it can give
				// sub-pixel accuracy, which we then want to round up!
				var bounding = browser.bBounding ? Math.ceil(headerCells[i].getBoundingClientRect().width) : cell.outerWidth();

				// Total is tracked to remove any sub-pixel errors as the outerWidth
				// of the table might not equal the total given here (IE!).
				total += bounding;

				// Width for each column to use
				columns[visibleColumns[i]].sWidth = _fnStringToCss(bounding - border);
			}

			table.style.width = _fnStringToCss(total);

			// Finished with the table - ditch it
			holder.remove();
		}

		// If there is a width attr, we want to attach an event listener which
		// allows the table sizing to automatically adjust when the window is
		// resized. Use the width attr rather than CSS, since we can't know if the
		// CSS is a relative value or absolute - DOM read is always px.
		if (tableWidthAttr) {
			table.style.width = _fnStringToCss(tableWidthAttr);
		}

		if ((tableWidthAttr || scrollX) && !oSettings._reszEvt) {
			var bindResize = function bindResize() {
				$(window).on('resize.DT-' + oSettings.sInstance, _fnThrottle(function () {
					_fnAdjustColumnSizing(oSettings);
				}));
			};

			// IE6/7 will crash if we bind a resize event handler on page load.
			// To be removed in 1.11 which drops IE6/7 support
			if (ie67) {
				setTimeout(bindResize, 1000);
			} else {
				bindResize();
			}

			oSettings._reszEvt = true;
		}
	}

	/**
  * Throttle the calls to a function. Arguments and context are maintained for
  * the throttled function
  *  @param {function} fn Function to be called
  *  @param {int} [freq=200] call frequency in mS
  *  @returns {function} wrapped function
  *  @memberof DataTable#oApi
  */
	var _fnThrottle = DataTable.util.throttle;

	/**
  * Convert a CSS unit width to pixels (e.g. 2em)
  *  @param {string} width width to be converted
  *  @param {node} parent parent to get the with for (required for relative widths) - optional
  *  @returns {int} width in pixels
  *  @memberof DataTable#oApi
  */
	function _fnConvertToWidth(width, parent) {
		if (!width) {
			return 0;
		}

		var n = $('<div/>').css('width', _fnStringToCss(width)).appendTo(parent || document.body);

		var val = n[0].offsetWidth;
		n.remove();

		return val;
	}

	/**
  * Get the widest node
  *  @param {object} settings dataTables settings object
  *  @param {int} colIdx column of interest
  *  @returns {node} widest table node
  *  @memberof DataTable#oApi
  */
	function _fnGetWidestNode(settings, colIdx) {
		var idx = _fnGetMaxLenString(settings, colIdx);
		if (idx < 0) {
			return null;
		}

		var data = settings.aoData[idx];
		return !data.nTr ? // Might not have been created when deferred rendering
		$('<td/>').html(_fnGetCellData(settings, idx, colIdx, 'display'))[0] : data.anCells[colIdx];
	}

	/**
  * Get the maximum strlen for each data column
  *  @param {object} settings dataTables settings object
  *  @param {int} colIdx column of interest
  *  @returns {string} max string length for each column
  *  @memberof DataTable#oApi
  */
	function _fnGetMaxLenString(settings, colIdx) {
		var s,
		    max = -1,
		    maxIdx = -1;

		for (var i = 0, ien = settings.aoData.length; i < ien; i++) {
			s = _fnGetCellData(settings, i, colIdx, 'display') + '';
			s = s.replace(__re_html_remove, '');
			s = s.replace(/&nbsp;/g, ' ');

			if (s.length > max) {
				max = s.length;
				maxIdx = i;
			}
		}

		return maxIdx;
	}

	/**
  * Append a CSS unit (only if required) to a string
  *  @param {string} value to css-ify
  *  @returns {string} value with css unit
  *  @memberof DataTable#oApi
  */
	function _fnStringToCss(s) {
		if (s === null) {
			return '0px';
		}

		if (typeof s == 'number') {
			return s < 0 ? '0px' : s + 'px';
		}

		// Check it has a unit character already
		return s.match(/\d$/) ? s + 'px' : s;
	}

	function _fnSortFlatten(settings) {
		var i,
		    iLen,
		    k,
		    kLen,
		    aSort = [],
		    aiOrig = [],
		    aoColumns = settings.aoColumns,
		    aDataSort,
		    iCol,
		    sType,
		    srcCol,
		    fixed = settings.aaSortingFixed,
		    fixedObj = $.isPlainObject(fixed),
		    nestedSort = [],
		    add = function add(a) {
			if (a.length && !$.isArray(a[0])) {
				// 1D array
				nestedSort.push(a);
			} else {
				// 2D array
				$.merge(nestedSort, a);
			}
		};

		// Build the sort array, with pre-fix and post-fix options if they have been
		// specified
		if ($.isArray(fixed)) {
			add(fixed);
		}

		if (fixedObj && fixed.pre) {
			add(fixed.pre);
		}

		add(settings.aaSorting);

		if (fixedObj && fixed.post) {
			add(fixed.post);
		}

		for (i = 0; i < nestedSort.length; i++) {
			srcCol = nestedSort[i][0];
			aDataSort = aoColumns[srcCol].aDataSort;

			for (k = 0, kLen = aDataSort.length; k < kLen; k++) {
				iCol = aDataSort[k];
				sType = aoColumns[iCol].sType || 'string';

				if (nestedSort[i]._idx === undefined) {
					nestedSort[i]._idx = $.inArray(nestedSort[i][1], aoColumns[iCol].asSorting);
				}

				aSort.push({
					src: srcCol,
					col: iCol,
					dir: nestedSort[i][1],
					index: nestedSort[i]._idx,
					type: sType,
					formatter: DataTable.ext.type.order[sType + "-pre"]
				});
			}
		}

		return aSort;
	}

	/**
  * Change the order of the table
  *  @param {object} oSettings dataTables settings object
  *  @memberof DataTable#oApi
  *  @todo This really needs split up!
  */
	function _fnSort(oSettings) {
		var i,
		    ien,
		    iLen,
		    j,
		    jLen,
		    k,
		    kLen,
		    sDataType,
		    nTh,
		    aiOrig = [],
		    oExtSort = DataTable.ext.type.order,
		    aoData = oSettings.aoData,
		    aoColumns = oSettings.aoColumns,
		    aDataSort,
		    data,
		    iCol,
		    sType,
		    oSort,
		    formatters = 0,
		    sortCol,
		    displayMaster = oSettings.aiDisplayMaster,
		    aSort;

		// Resolve any column types that are unknown due to addition or invalidation
		// @todo Can this be moved into a 'data-ready' handler which is called when
		//   data is going to be used in the table?
		_fnColumnTypes(oSettings);

		aSort = _fnSortFlatten(oSettings);

		for (i = 0, ien = aSort.length; i < ien; i++) {
			sortCol = aSort[i];

			// Track if we can use the fast sort algorithm
			if (sortCol.formatter) {
				formatters++;
			}

			// Load the data needed for the sort, for each cell
			_fnSortData(oSettings, sortCol.col);
		}

		/* No sorting required if server-side or no sorting array */
		if (_fnDataSource(oSettings) != 'ssp' && aSort.length !== 0) {
			// Create a value - key array of the current row positions such that we can use their
			// current position during the sort, if values match, in order to perform stable sorting
			for (i = 0, iLen = displayMaster.length; i < iLen; i++) {
				aiOrig[displayMaster[i]] = i;
			}

			/* Do the sort - here we want multi-column sorting based on a given data source (column)
    * and sorting function (from oSort) in a certain direction. It's reasonably complex to
    * follow on it's own, but this is what we want (example two column sorting):
    *  fnLocalSorting = function(a,b){
    *    var iTest;
    *    iTest = oSort['string-asc']('data11', 'data12');
    *      if (iTest !== 0)
    *        return iTest;
    *    iTest = oSort['numeric-desc']('data21', 'data22');
    *    if (iTest !== 0)
    *      return iTest;
    *    return oSort['numeric-asc']( aiOrig[a], aiOrig[b] );
    *  }
    * Basically we have a test for each sorting column, if the data in that column is equal,
    * test the next column. If all columns match, then we use a numeric sort on the row
    * positions in the original data array to provide a stable sort.
    *
    * Note - I know it seems excessive to have two sorting methods, but the first is around
    * 15% faster, so the second is only maintained for backwards compatibility with sorting
    * methods which do not have a pre-sort formatting function.
    */
			if (formatters === aSort.length) {
				// All sort types have formatting functions
				displayMaster.sort(function (a, b) {
					var x,
					    y,
					    k,
					    test,
					    sort,
					    len = aSort.length,
					    dataA = aoData[a]._aSortData,
					    dataB = aoData[b]._aSortData;

					for (k = 0; k < len; k++) {
						sort = aSort[k];

						x = dataA[sort.col];
						y = dataB[sort.col];

						test = x < y ? -1 : x > y ? 1 : 0;
						if (test !== 0) {
							return sort.dir === 'asc' ? test : -test;
						}
					}

					x = aiOrig[a];
					y = aiOrig[b];
					return x < y ? -1 : x > y ? 1 : 0;
				});
			} else {
				// Depreciated - remove in 1.11 (providing a plug-in option)
				// Not all sort types have formatting methods, so we have to call their sorting
				// methods.
				displayMaster.sort(function (a, b) {
					var x,
					    y,
					    k,
					    l,
					    test,
					    sort,
					    fn,
					    len = aSort.length,
					    dataA = aoData[a]._aSortData,
					    dataB = aoData[b]._aSortData;

					for (k = 0; k < len; k++) {
						sort = aSort[k];

						x = dataA[sort.col];
						y = dataB[sort.col];

						fn = oExtSort[sort.type + "-" + sort.dir] || oExtSort["string-" + sort.dir];
						test = fn(x, y);
						if (test !== 0) {
							return test;
						}
					}

					x = aiOrig[a];
					y = aiOrig[b];
					return x < y ? -1 : x > y ? 1 : 0;
				});
			}
		}

		/* Tell the draw function that we have sorted the data */
		oSettings.bSorted = true;
	}

	function _fnSortAria(settings) {
		var label;
		var nextSort;
		var columns = settings.aoColumns;
		var aSort = _fnSortFlatten(settings);
		var oAria = settings.oLanguage.oAria;

		// ARIA attributes - need to loop all columns, to update all (removing old
		// attributes as needed)
		for (var i = 0, iLen = columns.length; i < iLen; i++) {
			var col = columns[i];
			var asSorting = col.asSorting;
			var sTitle = col.sTitle.replace(/<.*?>/g, "");
			var th = col.nTh;

			// IE7 is throwing an error when setting these properties with jQuery's
			// attr() and removeAttr() methods...
			th.removeAttribute('aria-sort');

			/* In ARIA only the first sorting column can be marked as sorting - no multi-sort option */
			if (col.bSortable) {
				if (aSort.length > 0 && aSort[0].col == i) {
					th.setAttribute('aria-sort', aSort[0].dir == "asc" ? "ascending" : "descending");
					nextSort = asSorting[aSort[0].index + 1] || asSorting[0];
				} else {
					nextSort = asSorting[0];
				}

				label = sTitle + (nextSort === "asc" ? oAria.sSortAscending : oAria.sSortDescending);
			} else {
				label = sTitle;
			}

			th.setAttribute('aria-label', label);
		}
	}

	/**
  * Function to run on user sort request
  *  @param {object} settings dataTables settings object
  *  @param {node} attachTo node to attach the handler to
  *  @param {int} colIdx column sorting index
  *  @param {boolean} [append=false] Append the requested sort to the existing
  *    sort if true (i.e. multi-column sort)
  *  @param {function} [callback] callback function
  *  @memberof DataTable#oApi
  */
	function _fnSortListener(settings, colIdx, append, callback) {
		var col = settings.aoColumns[colIdx];
		var sorting = settings.aaSorting;
		var asSorting = col.asSorting;
		var nextSortIdx;
		var next = function next(a, overflow) {
			var idx = a._idx;
			if (idx === undefined) {
				idx = $.inArray(a[1], asSorting);
			}

			return idx + 1 < asSorting.length ? idx + 1 : overflow ? null : 0;
		};

		// Convert to 2D array if needed
		if (typeof sorting[0] === 'number') {
			sorting = settings.aaSorting = [sorting];
		}

		// If appending the sort then we are multi-column sorting
		if (append && settings.oFeatures.bSortMulti) {
			// Are we already doing some kind of sort on this column?
			var sortIdx = $.inArray(colIdx, _pluck(sorting, '0'));

			if (sortIdx !== -1) {
				// Yes, modify the sort
				nextSortIdx = next(sorting[sortIdx], true);

				if (nextSortIdx === null && sorting.length === 1) {
					nextSortIdx = 0; // can't remove sorting completely
				}

				if (nextSortIdx === null) {
					sorting.splice(sortIdx, 1);
				} else {
					sorting[sortIdx][1] = asSorting[nextSortIdx];
					sorting[sortIdx]._idx = nextSortIdx;
				}
			} else {
				// No sort on this column yet
				sorting.push([colIdx, asSorting[0], 0]);
				sorting[sorting.length - 1]._idx = 0;
			}
		} else if (sorting.length && sorting[0][0] == colIdx) {
			// Single column - already sorting on this column, modify the sort
			nextSortIdx = next(sorting[0]);

			sorting.length = 1;
			sorting[0][1] = asSorting[nextSortIdx];
			sorting[0]._idx = nextSortIdx;
		} else {
			// Single column - sort only on this column
			sorting.length = 0;
			sorting.push([colIdx, asSorting[0]]);
			sorting[0]._idx = 0;
		}

		// Run the sort by calling a full redraw
		_fnReDraw(settings);

		// callback used for async user interaction
		if (typeof callback == 'function') {
			callback(settings);
		}
	}

	/**
  * Attach a sort handler (click) to a node
  *  @param {object} settings dataTables settings object
  *  @param {node} attachTo node to attach the handler to
  *  @param {int} colIdx column sorting index
  *  @param {function} [callback] callback function
  *  @memberof DataTable#oApi
  */
	function _fnSortAttachListener(settings, attachTo, colIdx, callback) {
		var col = settings.aoColumns[colIdx];

		_fnBindAction(attachTo, {}, function (e) {
			/* If the column is not sortable - don't to anything */
			if (col.bSortable === false) {
				return;
			}

			// If processing is enabled use a timeout to allow the processing
			// display to be shown - otherwise to it synchronously
			if (settings.oFeatures.bProcessing) {
				_fnProcessingDisplay(settings, true);

				setTimeout(function () {
					_fnSortListener(settings, colIdx, e.shiftKey, callback);

					// In server-side processing, the draw callback will remove the
					// processing display
					if (_fnDataSource(settings) !== 'ssp') {
						_fnProcessingDisplay(settings, false);
					}
				}, 0);
			} else {
				_fnSortListener(settings, colIdx, e.shiftKey, callback);
			}
		});
	}

	/**
  * Set the sorting classes on table's body, Note: it is safe to call this function
  * when bSort and bSortClasses are false
  *  @param {object} oSettings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnSortingClasses(settings) {
		var oldSort = settings.aLastSort;
		var sortClass = settings.oClasses.sSortColumn;
		var sort = _fnSortFlatten(settings);
		var features = settings.oFeatures;
		var i, ien, colIdx;

		if (features.bSort && features.bSortClasses) {
			// Remove old sorting classes
			for (i = 0, ien = oldSort.length; i < ien; i++) {
				colIdx = oldSort[i].src;

				// Remove column sorting
				$(_pluck(settings.aoData, 'anCells', colIdx)).removeClass(sortClass + (i < 2 ? i + 1 : 3));
			}

			// Add new column sorting
			for (i = 0, ien = sort.length; i < ien; i++) {
				colIdx = sort[i].src;

				$(_pluck(settings.aoData, 'anCells', colIdx)).addClass(sortClass + (i < 2 ? i + 1 : 3));
			}
		}

		settings.aLastSort = sort;
	}

	// Get the data to sort a column, be it from cache, fresh (populating the
	// cache), or from a sort formatter
	function _fnSortData(settings, idx) {
		// Custom sorting function - provided by the sort data type
		var column = settings.aoColumns[idx];
		var customSort = DataTable.ext.order[column.sSortDataType];
		var customData;

		if (customSort) {
			customData = customSort.call(settings.oInstance, settings, idx, _fnColumnIndexToVisible(settings, idx));
		}

		// Use / populate cache
		var row, cellData;
		var formatter = DataTable.ext.type.order[column.sType + "-pre"];

		for (var i = 0, ien = settings.aoData.length; i < ien; i++) {
			row = settings.aoData[i];

			if (!row._aSortData) {
				row._aSortData = [];
			}

			if (!row._aSortData[idx] || customSort) {
				cellData = customSort ? customData[i] : // If there was a custom sort function, use data from there
				_fnGetCellData(settings, i, idx, 'sort');

				row._aSortData[idx] = formatter ? formatter(cellData) : cellData;
			}
		}
	}

	/**
  * Save the state of a table
  *  @param {object} oSettings dataTables settings object
  *  @memberof DataTable#oApi
  */
	function _fnSaveState(settings) {
		if (!settings.oFeatures.bStateSave || settings.bDestroying) {
			return;
		}

		/* Store the interesting variables */
		var state = {
			time: +new Date(),
			start: settings._iDisplayStart,
			length: settings._iDisplayLength,
			order: $.extend(true, [], settings.aaSorting),
			search: _fnSearchToCamel(settings.oPreviousSearch),
			columns: $.map(settings.aoColumns, function (col, i) {
				return {
					visible: col.bVisible,
					search: _fnSearchToCamel(settings.aoPreSearchCols[i])
				};
			})
		};

		_fnCallbackFire(settings, "aoStateSaveParams", 'stateSaveParams', [settings, state]);

		settings.oSavedState = state;
		settings.fnStateSaveCallback.call(settings.oInstance, settings, state);
	}

	/**
  * Attempt to load a saved table state
  *  @param {object} oSettings dataTables settings object
  *  @param {object} oInit DataTables init object so we can override settings
  *  @param {function} callback Callback to execute when the state has been loaded
  *  @memberof DataTable#oApi
  */
	function _fnLoadState(settings, oInit, callback) {
		var i, ien;
		var columns = settings.aoColumns;
		var loaded = function loaded(s) {
			if (!s || !s.time) {
				callback();
				return;
			}

			// Allow custom and plug-in manipulation functions to alter the saved data set and
			// cancelling of loading by returning false
			var abStateLoad = _fnCallbackFire(settings, 'aoStateLoadParams', 'stateLoadParams', [settings, s]);
			if ($.inArray(false, abStateLoad) !== -1) {
				callback();
				return;
			}

			// Reject old data
			var duration = settings.iStateDuration;
			if (duration > 0 && s.time < +new Date() - duration * 1000) {
				callback();
				return;
			}

			// Number of columns have changed - all bets are off, no restore of settings
			if (s.columns && columns.length !== s.columns.length) {
				callback();
				return;
			}

			// Store the saved state so it might be accessed at any time
			settings.oLoadedState = $.extend(true, {}, s);

			// Restore key features - todo - for 1.11 this needs to be done by
			// subscribed events
			if (s.start !== undefined) {
				settings._iDisplayStart = s.start;
				settings.iInitDisplayStart = s.start;
			}
			if (s.length !== undefined) {
				settings._iDisplayLength = s.length;
			}

			// Order
			if (s.order !== undefined) {
				settings.aaSorting = [];
				$.each(s.order, function (i, col) {
					settings.aaSorting.push(col[0] >= columns.length ? [0, col[1]] : col);
				});
			}

			// Search
			if (s.search !== undefined) {
				$.extend(settings.oPreviousSearch, _fnSearchToHung(s.search));
			}

			// Columns
			//
			if (s.columns) {
				for (i = 0, ien = s.columns.length; i < ien; i++) {
					var col = s.columns[i];

					// Visibility
					if (col.visible !== undefined) {
						columns[i].bVisible = col.visible;
					}

					// Search
					if (col.search !== undefined) {
						$.extend(settings.aoPreSearchCols[i], _fnSearchToHung(col.search));
					}
				}
			}

			_fnCallbackFire(settings, 'aoStateLoaded', 'stateLoaded', [settings, s]);
			callback();
		};

		if (!settings.oFeatures.bStateSave) {
			callback();
			return;
		}

		var state = settings.fnStateLoadCallback.call(settings.oInstance, settings, loaded);

		if (state !== undefined) {
			loaded(state);
		}
		// otherwise, wait for the loaded callback to be executed
	}

	/**
  * Return the settings object for a particular table
  *  @param {node} table table we are using as a dataTable
  *  @returns {object} Settings object - or null if not found
  *  @memberof DataTable#oApi
  */
	function _fnSettingsFromNode(table) {
		var settings = DataTable.settings;
		var idx = $.inArray(table, _pluck(settings, 'nTable'));

		return idx !== -1 ? settings[idx] : null;
	}

	/**
  * Log an error message
  *  @param {object} settings dataTables settings object
  *  @param {int} level log error messages, or display them to the user
  *  @param {string} msg error message
  *  @param {int} tn Technical note id to get more information about the error.
  *  @memberof DataTable#oApi
  */
	function _fnLog(settings, level, msg, tn) {
		msg = 'DataTables warning: ' + (settings ? 'table id=' + settings.sTableId + ' - ' : '') + msg;

		if (tn) {
			msg += '. For more information about this error, please see ' + 'http://datatables.net/tn/' + tn;
		}

		if (!level) {
			// Backwards compatibility pre 1.10
			var ext = DataTable.ext;
			var type = ext.sErrMode || ext.errMode;

			if (settings) {
				_fnCallbackFire(settings, null, 'error', [settings, tn, msg]);
			}

			if (type == 'alert') {
				alert(msg);
			} else if (type == 'throw') {
				throw new Error(msg);
			} else if (typeof type == 'function') {
				type(settings, tn, msg);
			}
		} else if (window.console && console.log) {
			console.log(msg);
		}
	}

	/**
  * See if a property is defined on one object, if so assign it to the other object
  *  @param {object} ret target object
  *  @param {object} src source object
  *  @param {string} name property
  *  @param {string} [mappedName] name to map too - optional, name used if not given
  *  @memberof DataTable#oApi
  */
	function _fnMap(ret, src, name, mappedName) {
		if ($.isArray(name)) {
			$.each(name, function (i, val) {
				if ($.isArray(val)) {
					_fnMap(ret, src, val[0], val[1]);
				} else {
					_fnMap(ret, src, val);
				}
			});

			return;
		}

		if (mappedName === undefined) {
			mappedName = name;
		}

		if (src[name] !== undefined) {
			ret[mappedName] = src[name];
		}
	}

	/**
  * Extend objects - very similar to jQuery.extend, but deep copy objects, and
  * shallow copy arrays. The reason we need to do this, is that we don't want to
  * deep copy array init values (such as aaSorting) since the dev wouldn't be
  * able to override them, but we do want to deep copy arrays.
  *  @param {object} out Object to extend
  *  @param {object} extender Object from which the properties will be applied to
  *      out
  *  @param {boolean} breakRefs If true, then arrays will be sliced to take an
  *      independent copy with the exception of the `data` or `aaData` parameters
  *      if they are present. This is so you can pass in a collection to
  *      DataTables and have that used as your data source without breaking the
  *      references
  *  @returns {object} out Reference, just for convenience - out === the return.
  *  @memberof DataTable#oApi
  *  @todo This doesn't take account of arrays inside the deep copied objects.
  */
	function _fnExtend(out, extender, breakRefs) {
		var val;

		for (var prop in extender) {
			if (extender.hasOwnProperty(prop)) {
				val = extender[prop];

				if ($.isPlainObject(val)) {
					if (!$.isPlainObject(out[prop])) {
						out[prop] = {};
					}
					$.extend(true, out[prop], val);
				} else if (breakRefs && prop !== 'data' && prop !== 'aaData' && $.isArray(val)) {
					out[prop] = val.slice();
				} else {
					out[prop] = val;
				}
			}
		}

		return out;
	}

	/**
  * Bind an event handers to allow a click or return key to activate the callback.
  * This is good for accessibility since a return on the keyboard will have the
  * same effect as a click, if the element has focus.
  *  @param {element} n Element to bind the action to
  *  @param {object} oData Data object to pass to the triggered function
  *  @param {function} fn Callback function for when the event is triggered
  *  @memberof DataTable#oApi
  */
	function _fnBindAction(n, oData, fn) {
		$(n).on('click.DT', oData, function (e) {
			n.blur(); // Remove focus outline for mouse users
			fn(e);
		}).on('keypress.DT', oData, function (e) {
			if (e.which === 13) {
				e.preventDefault();
				fn(e);
			}
		}).on('selectstart.DT', function () {
			/* Take the brutal approach to cancelling text selection */
			return false;
		});
	}

	/**
  * Register a callback function. Easily allows a callback function to be added to
  * an array store of callback functions that can then all be called together.
  *  @param {object} oSettings dataTables settings object
  *  @param {string} sStore Name of the array storage for the callbacks in oSettings
  *  @param {function} fn Function to be called back
  *  @param {string} sName Identifying name for the callback (i.e. a label)
  *  @memberof DataTable#oApi
  */
	function _fnCallbackReg(oSettings, sStore, fn, sName) {
		if (fn) {
			oSettings[sStore].push({
				"fn": fn,
				"sName": sName
			});
		}
	}

	/**
  * Fire callback functions and trigger events. Note that the loop over the
  * callback array store is done backwards! Further note that you do not want to
  * fire off triggers in time sensitive applications (for example cell creation)
  * as its slow.
  *  @param {object} settings dataTables settings object
  *  @param {string} callbackArr Name of the array storage for the callbacks in
  *      oSettings
  *  @param {string} eventName Name of the jQuery custom event to trigger. If
  *      null no trigger is fired
  *  @param {array} args Array of arguments to pass to the callback function /
  *      trigger
  *  @memberof DataTable#oApi
  */
	function _fnCallbackFire(settings, callbackArr, eventName, args) {
		var ret = [];

		if (callbackArr) {
			ret = $.map(settings[callbackArr].slice().reverse(), function (val, i) {
				return val.fn.apply(settings.oInstance, args);
			});
		}

		if (eventName !== null) {
			var e = $.Event(eventName + '.dt');

			$(settings.nTable).trigger(e, args);

			ret.push(e.result);
		}

		return ret;
	}

	function _fnLengthOverflow(settings) {
		var start = settings._iDisplayStart,
		    end = settings.fnDisplayEnd(),
		    len = settings._iDisplayLength;

		/* If we have space to show extra rows (backing up from the end point - then do so */
		if (start >= end) {
			start = end - len;
		}

		// Keep the start record on the current page
		start -= start % len;

		if (len === -1 || start < 0) {
			start = 0;
		}

		settings._iDisplayStart = start;
	}

	function _fnRenderer(settings, type) {
		var renderer = settings.renderer;
		var host = DataTable.ext.renderer[type];

		if ($.isPlainObject(renderer) && renderer[type]) {
			// Specific renderer for this type. If available use it, otherwise use
			// the default.
			return host[renderer[type]] || host._;
		} else if (typeof renderer === 'string') {
			// Common renderer - if there is one available for this type use it,
			// otherwise use the default
			return host[renderer] || host._;
		}

		// Use the default
		return host._;
	}

	/**
  * Detect the data source being used for the table. Used to simplify the code
  * a little (ajax) and to make it compress a little smaller.
  *
  *  @param {object} settings dataTables settings object
  *  @returns {string} Data source
  *  @memberof DataTable#oApi
  */
	function _fnDataSource(settings) {
		if (settings.oFeatures.bServerSide) {
			return 'ssp';
		} else if (settings.ajax || settings.sAjaxSource) {
			return 'ajax';
		}
		return 'dom';
	}

	/**
  * Computed structure of the DataTables API, defined by the options passed to
  * `DataTable.Api.register()` when building the API.
  *
  * The structure is built in order to speed creation and extension of the Api
  * objects since the extensions are effectively pre-parsed.
  *
  * The array is an array of objects with the following structure, where this
  * base array represents the Api prototype base:
  *
  *     [
  *       {
  *         name:      'data'                -- string   - Property name
  *         val:       function () {},       -- function - Api method (or undefined if just an object
  *         methodExt: [ ... ],              -- array    - Array of Api object definitions to extend the method result
  *         propExt:   [ ... ]               -- array    - Array of Api object definitions to extend the property
  *       },
  *       {
  *         name:     'row'
  *         val:       {},
  *         methodExt: [ ... ],
  *         propExt:   [
  *           {
  *             name:      'data'
  *             val:       function () {},
  *             methodExt: [ ... ],
  *             propExt:   [ ... ]
  *           },
  *           ...
  *         ]
  *       }
  *     ]
  *
  * @type {Array}
  * @ignore
  */
	var __apiStruct = [];

	/**
  * `Array.prototype` reference.
  *
  * @type object
  * @ignore
  */
	var __arrayProto = Array.prototype;

	/**
  * Abstraction for `context` parameter of the `Api` constructor to allow it to
  * take several different forms for ease of use.
  *
  * Each of the input parameter types will be converted to a DataTables settings
  * object where possible.
  *
  * @param  {string|node|jQuery|object} mixed DataTable identifier. Can be one
  *   of:
  *
  *   * `string` - jQuery selector. Any DataTables' matching the given selector
  *     with be found and used.
  *   * `node` - `TABLE` node which has already been formed into a DataTable.
  *   * `jQuery` - A jQuery object of `TABLE` nodes.
  *   * `object` - DataTables settings object
  *   * `DataTables.Api` - API instance
  * @return {array|null} Matching DataTables settings objects. `null` or
  *   `undefined` is returned if no matching DataTable is found.
  * @ignore
  */
	var _toSettings = function _toSettings(mixed) {
		var idx, jq;
		var settings = DataTable.settings;
		var tables = $.map(settings, function (el, i) {
			return el.nTable;
		});

		if (!mixed) {
			return [];
		} else if (mixed.nTable && mixed.oApi) {
			// DataTables settings object
			return [mixed];
		} else if (mixed.nodeName && mixed.nodeName.toLowerCase() === 'table') {
			// Table node
			idx = $.inArray(mixed, tables);
			return idx !== -1 ? [settings[idx]] : null;
		} else if (mixed && typeof mixed.settings === 'function') {
			return mixed.settings().toArray();
		} else if (typeof mixed === 'string') {
			// jQuery selector
			jq = $(mixed);
		} else if (mixed instanceof $) {
			// jQuery object (also DataTables instance)
			jq = mixed;
		}

		if (jq) {
			return jq.map(function (i) {
				idx = $.inArray(this, tables);
				return idx !== -1 ? settings[idx] : null;
			}).toArray();
		}
	};

	/**
  * DataTables API class - used to control and interface with  one or more
  * DataTables enhanced tables.
  *
  * The API class is heavily based on jQuery, presenting a chainable interface
  * that you can use to interact with tables. Each instance of the API class has
  * a "context" - i.e. the tables that it will operate on. This could be a single
  * table, all tables on a page or a sub-set thereof.
  *
  * Additionally the API is designed to allow you to easily work with the data in
  * the tables, retrieving and manipulating it as required. This is done by
  * presenting the API class as an array like interface. The contents of the
  * array depend upon the actions requested by each method (for example
  * `rows().nodes()` will return an array of nodes, while `rows().data()` will
  * return an array of objects or arrays depending upon your table's
  * configuration). The API object has a number of array like methods (`push`,
  * `pop`, `reverse` etc) as well as additional helper methods (`each`, `pluck`,
  * `unique` etc) to assist your working with the data held in a table.
  *
  * Most methods (those which return an Api instance) are chainable, which means
  * the return from a method call also has all of the methods available that the
  * top level object had. For example, these two calls are equivalent:
  *
  *     // Not chained
  *     api.row.add( {...} );
  *     api.draw();
  *
  *     // Chained
  *     api.row.add( {...} ).draw();
  *
  * @class DataTable.Api
  * @param {array|object|string|jQuery} context DataTable identifier. This is
  *   used to define which DataTables enhanced tables this API will operate on.
  *   Can be one of:
  *
  *   * `string` - jQuery selector. Any DataTables' matching the given selector
  *     with be found and used.
  *   * `node` - `TABLE` node which has already been formed into a DataTable.
  *   * `jQuery` - A jQuery object of `TABLE` nodes.
  *   * `object` - DataTables settings object
  * @param {array} [data] Data to initialise the Api instance with.
  *
  * @example
  *   // Direct initialisation during DataTables construction
  *   var api = $('#example').DataTable();
  *
  * @example
  *   // Initialisation using a DataTables jQuery object
  *   var api = $('#example').dataTable().api();
  *
  * @example
  *   // Initialisation as a constructor
  *   var api = new $.fn.DataTable.Api( 'table.dataTable' );
  */
	_Api2 = function _Api(context, data) {
		if (!(this instanceof _Api2)) {
			return new _Api2(context, data);
		}

		var settings = [];
		var ctxSettings = function ctxSettings(o) {
			var a = _toSettings(o);
			if (a) {
				settings = settings.concat(a);
			}
		};

		if ($.isArray(context)) {
			for (var i = 0, ien = context.length; i < ien; i++) {
				ctxSettings(context[i]);
			}
		} else {
			ctxSettings(context);
		}

		// Remove duplicates
		this.context = _unique(settings);

		// Initial data
		if (data) {
			$.merge(this, data);
		}

		// selector
		this.selector = {
			rows: null,
			cols: null,
			opts: null
		};

		_Api2.extend(this, this, __apiStruct);
	};

	DataTable.Api = _Api2;

	// Don't destroy the existing prototype, just extend it. Required for jQuery 2's
	// isPlainObject.
	$.extend(_Api2.prototype, {
		any: function any() {
			return this.count() !== 0;
		},

		concat: __arrayProto.concat,

		context: [], // array of table settings objects


		count: function count() {
			return this.flatten().length;
		},

		each: function each(fn) {
			for (var i = 0, ien = this.length; i < ien; i++) {
				fn.call(this, this[i], i, this);
			}

			return this;
		},

		eq: function eq(idx) {
			var ctx = this.context;

			return ctx.length > idx ? new _Api2(ctx[idx], this[idx]) : null;
		},

		filter: function filter(fn) {
			var a = [];

			if (__arrayProto.filter) {
				a = __arrayProto.filter.call(this, fn, this);
			} else {
				// Compatibility for browsers without EMCA-252-5 (JS 1.6)
				for (var i = 0, ien = this.length; i < ien; i++) {
					if (fn.call(this, this[i], i, this)) {
						a.push(this[i]);
					}
				}
			}

			return new _Api2(this.context, a);
		},

		flatten: function flatten() {
			var a = [];
			return new _Api2(this.context, a.concat.apply(a, this.toArray()));
		},

		join: __arrayProto.join,

		indexOf: __arrayProto.indexOf || function (obj, start) {
			for (var i = start || 0, ien = this.length; i < ien; i++) {
				if (this[i] === obj) {
					return i;
				}
			}
			return -1;
		},

		iterator: function iterator(flatten, type, fn, alwaysNew) {
			var a = [],
			    ret,
			    i,
			    ien,
			    j,
			    jen,
			    context = this.context,
			    rows,
			    items,
			    item,
			    selector = this.selector;

			// Argument shifting
			if (typeof flatten === 'string') {
				alwaysNew = fn;
				fn = type;
				type = flatten;
				flatten = false;
			}

			for (i = 0, ien = context.length; i < ien; i++) {
				var apiInst = new _Api2(context[i]);

				if (type === 'table') {
					ret = fn.call(apiInst, context[i], i);

					if (ret !== undefined) {
						a.push(ret);
					}
				} else if (type === 'columns' || type === 'rows') {
					// this has same length as context - one entry for each table
					ret = fn.call(apiInst, context[i], this[i], i);

					if (ret !== undefined) {
						a.push(ret);
					}
				} else if (type === 'column' || type === 'column-rows' || type === 'row' || type === 'cell') {
					// columns and rows share the same structure.
					// 'this' is an array of column indexes for each context
					items = this[i];

					if (type === 'column-rows') {
						rows = _selector_row_indexes(context[i], selector.opts);
					}

					for (j = 0, jen = items.length; j < jen; j++) {
						item = items[j];

						if (type === 'cell') {
							ret = fn.call(apiInst, context[i], item.row, item.column, i, j);
						} else {
							ret = fn.call(apiInst, context[i], item, i, j, rows);
						}

						if (ret !== undefined) {
							a.push(ret);
						}
					}
				}
			}

			if (a.length || alwaysNew) {
				var api = new _Api2(context, flatten ? a.concat.apply([], a) : a);
				var apiSelector = api.selector;
				apiSelector.rows = selector.rows;
				apiSelector.cols = selector.cols;
				apiSelector.opts = selector.opts;
				return api;
			}
			return this;
		},

		lastIndexOf: __arrayProto.lastIndexOf || function (obj, start) {
			// Bit cheeky...
			return this.indexOf.apply(this.toArray.reverse(), arguments);
		},

		length: 0,

		map: function map(fn) {
			var a = [];

			if (__arrayProto.map) {
				a = __arrayProto.map.call(this, fn, this);
			} else {
				// Compatibility for browsers without EMCA-252-5 (JS 1.6)
				for (var i = 0, ien = this.length; i < ien; i++) {
					a.push(fn.call(this, this[i], i));
				}
			}

			return new _Api2(this.context, a);
		},

		pluck: function pluck(prop) {
			return this.map(function (el) {
				return el[prop];
			});
		},

		pop: __arrayProto.pop,

		push: __arrayProto.push,

		// Does not return an API instance
		reduce: __arrayProto.reduce || function (fn, init) {
			return _fnReduce(this, fn, init, 0, this.length, 1);
		},

		reduceRight: __arrayProto.reduceRight || function (fn, init) {
			return _fnReduce(this, fn, init, this.length - 1, -1, -1);
		},

		reverse: __arrayProto.reverse,

		// Object with rows, columns and opts
		selector: null,

		shift: __arrayProto.shift,

		slice: function slice() {
			return new _Api2(this.context, this);
		},

		sort: __arrayProto.sort, // ? name - order?


		splice: __arrayProto.splice,

		toArray: function toArray() {
			return __arrayProto.slice.call(this);
		},

		to$: function to$() {
			return $(this);
		},

		toJQuery: function toJQuery() {
			return $(this);
		},

		unique: function unique() {
			return new _Api2(this.context, _unique(this));
		},

		unshift: __arrayProto.unshift
	});

	_Api2.extend = function (scope, obj, ext) {
		// Only extend API instances and static properties of the API
		if (!ext.length || !obj || !(obj instanceof _Api2) && !obj.__dt_wrapper) {
			return;
		}

		var i,
		    ien,
		    j,
		    jen,
		    struct,
		    inner,
		    methodScoping = function methodScoping(scope, fn, struc) {
			return function () {
				var ret = fn.apply(scope, arguments);

				// Method extension
				_Api2.extend(ret, ret, struc.methodExt);
				return ret;
			};
		};

		for (i = 0, ien = ext.length; i < ien; i++) {
			struct = ext[i];

			// Value
			obj[struct.name] = typeof struct.val === 'function' ? methodScoping(scope, struct.val, struct) : $.isPlainObject(struct.val) ? {} : struct.val;

			obj[struct.name].__dt_wrapper = true;

			// Property extension
			_Api2.extend(scope, obj[struct.name], struct.propExt);
		}
	};

	// @todo - Is there need for an augment function?
	// _Api.augment = function ( inst, name )
	// {
	// 	// Find src object in the structure from the name
	// 	var parts = name.split('.');

	// 	_Api.extend( inst, obj );
	// };


	//     [
	//       {
	//         name:      'data'                -- string   - Property name
	//         val:       function () {},       -- function - Api method (or undefined if just an object
	//         methodExt: [ ... ],              -- array    - Array of Api object definitions to extend the method result
	//         propExt:   [ ... ]               -- array    - Array of Api object definitions to extend the property
	//       },
	//       {
	//         name:     'row'
	//         val:       {},
	//         methodExt: [ ... ],
	//         propExt:   [
	//           {
	//             name:      'data'
	//             val:       function () {},
	//             methodExt: [ ... ],
	//             propExt:   [ ... ]
	//           },
	//           ...
	//         ]
	//       }
	//     ]

	_Api2.register = _api_register = function _api_register(name, val) {
		if ($.isArray(name)) {
			for (var j = 0, jen = name.length; j < jen; j++) {
				_Api2.register(name[j], val);
			}
			return;
		}

		var i,
		    ien,
		    heir = name.split('.'),
		    struct = __apiStruct,
		    key,
		    method;

		var find = function find(src, name) {
			for (var i = 0, ien = src.length; i < ien; i++) {
				if (src[i].name === name) {
					return src[i];
				}
			}
			return null;
		};

		for (i = 0, ien = heir.length; i < ien; i++) {
			method = heir[i].indexOf('()') !== -1;
			key = method ? heir[i].replace('()', '') : heir[i];

			var src = find(struct, key);
			if (!src) {
				src = {
					name: key,
					val: {},
					methodExt: [],
					propExt: []
				};
				struct.push(src);
			}

			if (i === ien - 1) {
				src.val = val;
			} else {
				struct = method ? src.methodExt : src.propExt;
			}
		}
	};

	_Api2.registerPlural = _api_registerPlural = function _api_registerPlural(pluralName, singularName, val) {
		_Api2.register(pluralName, val);

		_Api2.register(singularName, function () {
			var ret = val.apply(this, arguments);

			if (ret === this) {
				// Returned item is the API instance that was passed in, return it
				return this;
			} else if (ret instanceof _Api2) {
				// New API instance returned, want the value from the first item
				// in the returned array for the singular result.
				return ret.length ? $.isArray(ret[0]) ? new _Api2(ret.context, ret[0]) : // Array results are 'enhanced'
				ret[0] : undefined;
			}

			// Non-API return - just fire it back
			return ret;
		});
	};

	/**
  * Selector for HTML tables. Apply the given selector to the give array of
  * DataTables settings objects.
  *
  * @param {string|integer} [selector] jQuery selector string or integer
  * @param  {array} Array of DataTables settings objects to be filtered
  * @return {array}
  * @ignore
  */
	var __table_selector = function __table_selector(selector, a) {
		// Integer is used to pick out a table by index
		if (typeof selector === 'number') {
			return [a[selector]];
		}

		// Perform a jQuery selector on the table nodes
		var nodes = $.map(a, function (el, i) {
			return el.nTable;
		});

		return $(nodes).filter(selector).map(function (i) {
			// Need to translate back from the table node to the settings
			var idx = $.inArray(this, nodes);
			return a[idx];
		}).toArray();
	};

	/**
  * Context selector for the API's context (i.e. the tables the API instance
  * refers to.
  *
  * @name    DataTable.Api#tables
  * @param {string|integer} [selector] Selector to pick which tables the iterator
  *   should operate on. If not given, all tables in the current context are
  *   used. This can be given as a jQuery selector (for example `':gt(0)'`) to
  *   select multiple tables or as an integer to select a single table.
  * @returns {DataTable.Api} Returns a new API instance if a selector is given.
  */
	_api_register('tables()', function (selector) {
		// A new instance is created if there was a selector specified
		return selector ? new _Api2(__table_selector(selector, this.context)) : this;
	});

	_api_register('table()', function (selector) {
		var tables = this.tables(selector);
		var ctx = tables.context;

		// Truncate to the first matched table
		return ctx.length ? new _Api2(ctx[0]) : tables;
	});

	_api_registerPlural('tables().nodes()', 'table().node()', function () {
		return this.iterator('table', function (ctx) {
			return ctx.nTable;
		}, 1);
	});

	_api_registerPlural('tables().body()', 'table().body()', function () {
		return this.iterator('table', function (ctx) {
			return ctx.nTBody;
		}, 1);
	});

	_api_registerPlural('tables().header()', 'table().header()', function () {
		return this.iterator('table', function (ctx) {
			return ctx.nTHead;
		}, 1);
	});

	_api_registerPlural('tables().footer()', 'table().footer()', function () {
		return this.iterator('table', function (ctx) {
			return ctx.nTFoot;
		}, 1);
	});

	_api_registerPlural('tables().containers()', 'table().container()', function () {
		return this.iterator('table', function (ctx) {
			return ctx.nTableWrapper;
		}, 1);
	});

	/**
  * Redraw the tables in the current context.
  */
	_api_register('draw()', function (paging) {
		return this.iterator('table', function (settings) {
			if (paging === 'page') {
				_fnDraw(settings);
			} else {
				if (typeof paging === 'string') {
					paging = paging === 'full-hold' ? false : true;
				}

				_fnReDraw(settings, paging === false);
			}
		});
	});

	/**
  * Get the current page index.
  *
  * @return {integer} Current page index (zero based)
  */ /**
     * Set the current page.
     *
     * Note that if you attempt to show a page which does not exist, DataTables will
     * not throw an error, but rather reset the paging.
     *
     * @param {integer|string} action The paging action to take. This can be one of:
     *  * `integer` - The page index to jump to
     *  * `string` - An action to take:
     *    * `first` - Jump to first page.
     *    * `next` - Jump to the next page
     *    * `previous` - Jump to previous page
     *    * `last` - Jump to the last page.
     * @returns {DataTables.Api} this
     */
	_api_register('page()', function (action) {
		if (action === undefined) {
			return this.page.info().page; // not an expensive call
		}

		// else, have an action to take on all tables
		return this.iterator('table', function (settings) {
			_fnPageChange(settings, action);
		});
	});

	/**
  * Paging information for the first table in the current context.
  *
  * If you require paging information for another table, use the `table()` method
  * with a suitable selector.
  *
  * @return {object} Object with the following properties set:
  *  * `page` - Current page index (zero based - i.e. the first page is `0`)
  *  * `pages` - Total number of pages
  *  * `start` - Display index for the first record shown on the current page
  *  * `end` - Display index for the last record shown on the current page
  *  * `length` - Display length (number of records). Note that generally `start
  *    + length = end`, but this is not always true, for example if there are
  *    only 2 records to show on the final page, with a length of 10.
  *  * `recordsTotal` - Full data set length
  *  * `recordsDisplay` - Data set length once the current filtering criterion
  *    are applied.
  */
	_api_register('page.info()', function (action) {
		if (this.context.length === 0) {
			return undefined;
		}

		var settings = this.context[0],
		    start = settings._iDisplayStart,
		    len = settings.oFeatures.bPaginate ? settings._iDisplayLength : -1,
		    visRecords = settings.fnRecordsDisplay(),
		    all = len === -1;

		return {
			"page": all ? 0 : Math.floor(start / len),
			"pages": all ? 1 : Math.ceil(visRecords / len),
			"start": start,
			"end": settings.fnDisplayEnd(),
			"length": len,
			"recordsTotal": settings.fnRecordsTotal(),
			"recordsDisplay": visRecords,
			"serverSide": _fnDataSource(settings) === 'ssp'
		};
	});

	/**
  * Get the current page length.
  *
  * @return {integer} Current page length. Note `-1` indicates that all records
  *   are to be shown.
  */ /**
     * Set the current page length.
     *
     * @param {integer} Page length to set. Use `-1` to show all records.
     * @returns {DataTables.Api} this
     */
	_api_register('page.len()', function (len) {
		// Note that we can't call this function 'length()' because `length`
		// is a Javascript property of functions which defines how many arguments
		// the function expects.
		if (len === undefined) {
			return this.context.length !== 0 ? this.context[0]._iDisplayLength : undefined;
		}

		// else, set the page length
		return this.iterator('table', function (settings) {
			_fnLengthChange(settings, len);
		});
	});

	var __reload = function __reload(settings, holdPosition, callback) {
		// Use the draw event to trigger a callback
		if (callback) {
			var api = new _Api2(settings);

			api.one('draw', function () {
				callback(api.ajax.json());
			});
		}

		if (_fnDataSource(settings) == 'ssp') {
			_fnReDraw(settings, holdPosition);
		} else {
			_fnProcessingDisplay(settings, true);

			// Cancel an existing request
			var xhr = settings.jqXHR;
			if (xhr && xhr.readyState !== 4) {
				xhr.abort();
			}

			// Trigger xhr
			_fnBuildAjax(settings, [], function (json) {
				_fnClearTable(settings);

				var data = _fnAjaxDataSrc(settings, json);
				for (var i = 0, ien = data.length; i < ien; i++) {
					_fnAddData(settings, data[i]);
				}

				_fnReDraw(settings, holdPosition);
				_fnProcessingDisplay(settings, false);
			});
		}
	};

	/**
  * Get the JSON response from the last Ajax request that DataTables made to the
  * server. Note that this returns the JSON from the first table in the current
  * context.
  *
  * @return {object} JSON received from the server.
  */
	_api_register('ajax.json()', function () {
		var ctx = this.context;

		if (ctx.length > 0) {
			return ctx[0].json;
		}

		// else return undefined;
	});

	/**
  * Get the data submitted in the last Ajax request
  */
	_api_register('ajax.params()', function () {
		var ctx = this.context;

		if (ctx.length > 0) {
			return ctx[0].oAjaxData;
		}

		// else return undefined;
	});

	/**
  * Reload tables from the Ajax data source. Note that this function will
  * automatically re-draw the table when the remote data has been loaded.
  *
  * @param {boolean} [reset=true] Reset (default) or hold the current paging
  *   position. A full re-sort and re-filter is performed when this method is
  *   called, which is why the pagination reset is the default action.
  * @returns {DataTables.Api} this
  */
	_api_register('ajax.reload()', function (callback, resetPaging) {
		return this.iterator('table', function (settings) {
			__reload(settings, resetPaging === false, callback);
		});
	});

	/**
  * Get the current Ajax URL. Note that this returns the URL from the first
  * table in the current context.
  *
  * @return {string} Current Ajax source URL
  */ /**
     * Set the Ajax URL. Note that this will set the URL for all tables in the
     * current context.
     *
     * @param {string} url URL to set.
     * @returns {DataTables.Api} this
     */
	_api_register('ajax.url()', function (url) {
		var ctx = this.context;

		if (url === undefined) {
			// get
			if (ctx.length === 0) {
				return undefined;
			}
			ctx = ctx[0];

			return ctx.ajax ? $.isPlainObject(ctx.ajax) ? ctx.ajax.url : ctx.ajax : ctx.sAjaxSource;
		}

		// set
		return this.iterator('table', function (settings) {
			if ($.isPlainObject(settings.ajax)) {
				settings.ajax.url = url;
			} else {
				settings.ajax = url;
			}
			// No need to consider sAjaxSource here since DataTables gives priority
			// to `ajax` over `sAjaxSource`. So setting `ajax` here, renders any
			// value of `sAjaxSource` redundant.
		});
	});

	/**
  * Load data from the newly set Ajax URL. Note that this method is only
  * available when `ajax.url()` is used to set a URL. Additionally, this method
  * has the same effect as calling `ajax.reload()` but is provided for
  * convenience when setting a new URL. Like `ajax.reload()` it will
  * automatically redraw the table once the remote data has been loaded.
  *
  * @returns {DataTables.Api} this
  */
	_api_register('ajax.url().load()', function (callback, resetPaging) {
		// Same as a reload, but makes sense to present it for easy access after a
		// url change
		return this.iterator('table', function (ctx) {
			__reload(ctx, resetPaging === false, callback);
		});
	});

	var _selector_run = function _selector_run(type, selector, selectFn, settings, opts) {
		var out = [],
		    res,
		    a,
		    i,
		    ien,
		    j,
		    jen,
		    selectorType = typeof selector === 'undefined' ? 'undefined' : _typeof(selector);

		// Can't just check for isArray here, as an API or jQuery instance might be
		// given with their array like look
		if (!selector || selectorType === 'string' || selectorType === 'function' || selector.length === undefined) {
			selector = [selector];
		}

		for (i = 0, ien = selector.length; i < ien; i++) {
			// Only split on simple strings - complex expressions will be jQuery selectors
			a = selector[i] && selector[i].split && !selector[i].match(/[\[\(:]/) ? selector[i].split(',') : [selector[i]];

			for (j = 0, jen = a.length; j < jen; j++) {
				res = selectFn(typeof a[j] === 'string' ? $.trim(a[j]) : a[j]);

				if (res && res.length) {
					out = out.concat(res);
				}
			}
		}

		// selector extensions
		var ext = _ext.selector[type];
		if (ext.length) {
			for (i = 0, ien = ext.length; i < ien; i++) {
				out = ext[i](settings, opts, out);
			}
		}

		return _unique(out);
	};

	var _selector_opts = function _selector_opts(opts) {
		if (!opts) {
			opts = {};
		}

		// Backwards compatibility for 1.9- which used the terminology filter rather
		// than search
		if (opts.filter && opts.search === undefined) {
			opts.search = opts.filter;
		}

		return $.extend({
			search: 'none',
			order: 'current',
			page: 'all'
		}, opts);
	};

	var _selector_first = function _selector_first(inst) {
		// Reduce the API instance to the first item found
		for (var i = 0, ien = inst.length; i < ien; i++) {
			if (inst[i].length > 0) {
				// Assign the first element to the first item in the instance
				// and truncate the instance and context
				inst[0] = inst[i];
				inst[0].length = 1;
				inst.length = 1;
				inst.context = [inst.context[i]];

				return inst;
			}
		}

		// Not found - return an empty instance
		inst.length = 0;
		return inst;
	};

	var _selector_row_indexes = function _selector_row_indexes(settings, opts) {
		var i,
		    ien,
		    tmp,
		    a = [],
		    displayFiltered = settings.aiDisplay,
		    displayMaster = settings.aiDisplayMaster;

		var search = opts.search,
		    // none, applied, removed
		order = opts.order,
		    // applied, current, index (original - compatibility with 1.9)
		page = opts.page; // all, current

		if (_fnDataSource(settings) == 'ssp') {
			// In server-side processing mode, most options are irrelevant since
			// rows not shown don't exist and the index order is the applied order
			// Removed is a special case - for consistency just return an empty
			// array
			return search === 'removed' ? [] : _range(0, displayMaster.length);
		} else if (page == 'current') {
			// Current page implies that order=current and fitler=applied, since it is
			// fairly senseless otherwise, regardless of what order and search actually
			// are
			for (i = settings._iDisplayStart, ien = settings.fnDisplayEnd(); i < ien; i++) {
				a.push(displayFiltered[i]);
			}
		} else if (order == 'current' || order == 'applied') {
			a = search == 'none' ? displayMaster.slice() : // no search
			search == 'applied' ? displayFiltered.slice() : // applied search
			$.map(displayMaster, function (el, i) {
				// removed search
				return $.inArray(el, displayFiltered) === -1 ? el : null;
			});
		} else if (order == 'index' || order == 'original') {
			for (i = 0, ien = settings.aoData.length; i < ien; i++) {
				if (search == 'none') {
					a.push(i);
				} else {
					// applied | removed
					tmp = $.inArray(i, displayFiltered);

					if (tmp === -1 && search == 'removed' || tmp >= 0 && search == 'applied') {
						a.push(i);
					}
				}
			}
		}

		return a;
	};

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  * Rows
  *
  * {}          - no selector - use all available rows
  * {integer}   - row aoData index
  * {node}      - TR node
  * {string}    - jQuery selector to apply to the TR elements
  * {array}     - jQuery array of nodes, or simply an array of TR nodes
  *
  */

	var __row_selector = function __row_selector(settings, selector, opts) {
		var rows;
		var run = function run(sel) {
			var selInt = _intVal(sel);
			var i, ien;

			// Short cut - selector is a number and no options provided (default is
			// all records, so no need to check if the index is in there, since it
			// must be - dev error if the index doesn't exist).
			if (selInt !== null && !opts) {
				return [selInt];
			}

			if (!rows) {
				rows = _selector_row_indexes(settings, opts);
			}

			if (selInt !== null && $.inArray(selInt, rows) !== -1) {
				// Selector - integer
				return [selInt];
			} else if (sel === null || sel === undefined || sel === '') {
				// Selector - none
				return rows;
			}

			// Selector - function
			if (typeof sel === 'function') {
				return $.map(rows, function (idx) {
					var row = settings.aoData[idx];
					return sel(idx, row._aData, row.nTr) ? idx : null;
				});
			}

			// Get nodes in the order from the `rows` array with null values removed
			var nodes = _removeEmpty(_pluck_order(settings.aoData, rows, 'nTr'));

			// Selector - node
			if (sel.nodeName) {
				if (sel._DT_RowIndex !== undefined) {
					return [sel._DT_RowIndex]; // Property added by DT for fast lookup
				} else if (sel._DT_CellIndex) {
					return [sel._DT_CellIndex.row];
				} else {
					var host = $(sel).closest('*[data-dt-row]');
					return host.length ? [host.data('dt-row')] : [];
				}
			}

			// ID selector. Want to always be able to select rows by id, regardless
			// of if the tr element has been created or not, so can't rely upon
			// jQuery here - hence a custom implementation. This does not match
			// Sizzle's fast selector or HTML4 - in HTML5 the ID can be anything,
			// but to select it using a CSS selector engine (like Sizzle or
			// querySelect) it would need to need to be escaped for some characters.
			// DataTables simplifies this for row selectors since you can select
			// only a row. A # indicates an id any anything that follows is the id -
			// unescaped.
			if (typeof sel === 'string' && sel.charAt(0) === '#') {
				// get row index from id
				var rowObj = settings.aIds[sel.replace(/^#/, '')];
				if (rowObj !== undefined) {
					return [rowObj.idx];
				}

				// need to fall through to jQuery in case there is DOM id that
				// matches
			}

			// Selector - jQuery selector string, array of nodes or jQuery object/
			// As jQuery's .filter() allows jQuery objects to be passed in filter,
			// it also allows arrays, so this will cope with all three options
			return $(nodes).filter(sel).map(function () {
				return this._DT_RowIndex;
			}).toArray();
		};

		return _selector_run('row', selector, run, settings, opts);
	};

	_api_register('rows()', function (selector, opts) {
		// argument shifting
		if (selector === undefined) {
			selector = '';
		} else if ($.isPlainObject(selector)) {
			opts = selector;
			selector = '';
		}

		opts = _selector_opts(opts);

		var inst = this.iterator('table', function (settings) {
			return __row_selector(settings, selector, opts);
		}, 1);

		// Want argument shifting here and in __row_selector?
		inst.selector.rows = selector;
		inst.selector.opts = opts;

		return inst;
	});

	_api_register('rows().nodes()', function () {
		return this.iterator('row', function (settings, row) {
			return settings.aoData[row].nTr || undefined;
		}, 1);
	});

	_api_register('rows().data()', function () {
		return this.iterator(true, 'rows', function (settings, rows) {
			return _pluck_order(settings.aoData, rows, '_aData');
		}, 1);
	});

	_api_registerPlural('rows().cache()', 'row().cache()', function (type) {
		return this.iterator('row', function (settings, row) {
			var r = settings.aoData[row];
			return type === 'search' ? r._aFilterData : r._aSortData;
		}, 1);
	});

	_api_registerPlural('rows().invalidate()', 'row().invalidate()', function (src) {
		return this.iterator('row', function (settings, row) {
			_fnInvalidate(settings, row, src);
		});
	});

	_api_registerPlural('rows().indexes()', 'row().index()', function () {
		return this.iterator('row', function (settings, row) {
			return row;
		}, 1);
	});

	_api_registerPlural('rows().ids()', 'row().id()', function (hash) {
		var a = [];
		var context = this.context;

		// `iterator` will drop undefined values, but in this case we want them
		for (var i = 0, ien = context.length; i < ien; i++) {
			for (var j = 0, jen = this[i].length; j < jen; j++) {
				var id = context[i].rowIdFn(context[i].aoData[this[i][j]]._aData);
				a.push((hash === true ? '#' : '') + id);
			}
		}

		return new _Api2(context, a);
	});

	_api_registerPlural('rows().remove()', 'row().remove()', function () {
		var that = this;

		this.iterator('row', function (settings, row, thatIdx) {
			var data = settings.aoData;
			var rowData = data[row];
			var i, ien, j, jen;
			var loopRow, loopCells;

			data.splice(row, 1);

			// Update the cached indexes
			for (i = 0, ien = data.length; i < ien; i++) {
				loopRow = data[i];
				loopCells = loopRow.anCells;

				// Rows
				if (loopRow.nTr !== null) {
					loopRow.nTr._DT_RowIndex = i;
				}

				// Cells
				if (loopCells !== null) {
					for (j = 0, jen = loopCells.length; j < jen; j++) {
						loopCells[j]._DT_CellIndex.row = i;
					}
				}
			}

			// Delete from the display arrays
			_fnDeleteIndex(settings.aiDisplayMaster, row);
			_fnDeleteIndex(settings.aiDisplay, row);
			_fnDeleteIndex(that[thatIdx], row, false); // maintain local indexes

			// Check for an 'overflow' they case for displaying the table
			_fnLengthOverflow(settings);

			// Remove the row's ID reference if there is one
			var id = settings.rowIdFn(rowData._aData);
			if (id !== undefined) {
				delete settings.aIds[id];
			}
		});

		this.iterator('table', function (settings) {
			for (var i = 0, ien = settings.aoData.length; i < ien; i++) {
				settings.aoData[i].idx = i;
			}
		});

		return this;
	});

	_api_register('rows.add()', function (rows) {
		var newRows = this.iterator('table', function (settings) {
			var row, i, ien;
			var out = [];

			for (i = 0, ien = rows.length; i < ien; i++) {
				row = rows[i];

				if (row.nodeName && row.nodeName.toUpperCase() === 'TR') {
					out.push(_fnAddTr(settings, row)[0]);
				} else {
					out.push(_fnAddData(settings, row));
				}
			}

			return out;
		}, 1);

		// Return an Api.rows() extended instance, so rows().nodes() etc can be used
		var modRows = this.rows(-1);
		modRows.pop();
		$.merge(modRows, newRows);

		return modRows;
	});

	/**
  *
  */
	_api_register('row()', function (selector, opts) {
		return _selector_first(this.rows(selector, opts));
	});

	_api_register('row().data()', function (data) {
		var ctx = this.context;

		if (data === undefined) {
			// Get
			return ctx.length && this.length ? ctx[0].aoData[this[0]]._aData : undefined;
		}

		// Set
		ctx[0].aoData[this[0]]._aData = data;

		// Automatically invalidate
		_fnInvalidate(ctx[0], this[0], 'data');

		return this;
	});

	_api_register('row().node()', function () {
		var ctx = this.context;

		return ctx.length && this.length ? ctx[0].aoData[this[0]].nTr || null : null;
	});

	_api_register('row.add()', function (row) {
		// Allow a jQuery object to be passed in - only a single row is added from
		// it though - the first element in the set
		if (row instanceof $ && row.length) {
			row = row[0];
		}

		var rows = this.iterator('table', function (settings) {
			if (row.nodeName && row.nodeName.toUpperCase() === 'TR') {
				return _fnAddTr(settings, row)[0];
			}
			return _fnAddData(settings, row);
		});

		// Return an Api.rows() extended instance, with the newly added row selected
		return this.row(rows[0]);
	});

	var __details_add = function __details_add(ctx, row, data, klass) {
		// Convert to array of TR elements
		var rows = [];
		var addRow = function addRow(r, k) {
			// Recursion to allow for arrays of jQuery objects
			if ($.isArray(r) || r instanceof $) {
				for (var i = 0, ien = r.length; i < ien; i++) {
					addRow(r[i], k);
				}
				return;
			}

			// If we get a TR element, then just add it directly - up to the dev
			// to add the correct number of columns etc
			if (r.nodeName && r.nodeName.toLowerCase() === 'tr') {
				rows.push(r);
			} else {
				// Otherwise create a row with a wrapper
				var created = $('<tr><td/></tr>').addClass(k);
				$('td', created).addClass(k).html(r)[0].colSpan = _fnVisbleColumns(ctx);

				rows.push(created[0]);
			}
		};

		addRow(data, klass);

		if (row._details) {
			row._details.detach();
		}

		row._details = $(rows);

		// If the children were already shown, that state should be retained
		if (row._detailsShow) {
			row._details.insertAfter(row.nTr);
		}
	};

	var __details_remove = function __details_remove(api, idx) {
		var ctx = api.context;

		if (ctx.length) {
			var row = ctx[0].aoData[idx !== undefined ? idx : api[0]];

			if (row && row._details) {
				row._details.remove();

				row._detailsShow = undefined;
				row._details = undefined;
			}
		}
	};

	var __details_display = function __details_display(api, show) {
		var ctx = api.context;

		if (ctx.length && api.length) {
			var row = ctx[0].aoData[api[0]];

			if (row._details) {
				row._detailsShow = show;

				if (show) {
					row._details.insertAfter(row.nTr);
				} else {
					row._details.detach();
				}

				__details_events(ctx[0]);
			}
		}
	};

	var __details_events = function __details_events(settings) {
		var api = new _Api2(settings);
		var namespace = '.dt.DT_details';
		var drawEvent = 'draw' + namespace;
		var colvisEvent = 'column-visibility' + namespace;
		var destroyEvent = 'destroy' + namespace;
		var data = settings.aoData;

		api.off(drawEvent + ' ' + colvisEvent + ' ' + destroyEvent);

		if (_pluck(data, '_details').length > 0) {
			// On each draw, insert the required elements into the document
			api.on(drawEvent, function (e, ctx) {
				if (settings !== ctx) {
					return;
				}

				api.rows({ page: 'current' }).eq(0).each(function (idx) {
					// Internal data grab
					var row = data[idx];

					if (row._detailsShow) {
						row._details.insertAfter(row.nTr);
					}
				});
			});

			// Column visibility change - update the colspan
			api.on(colvisEvent, function (e, ctx, idx, vis) {
				if (settings !== ctx) {
					return;
				}

				// Update the colspan for the details rows (note, only if it already has
				// a colspan)
				var row,
				    visible = _fnVisbleColumns(ctx);

				for (var i = 0, ien = data.length; i < ien; i++) {
					row = data[i];

					if (row._details) {
						row._details.children('td[colspan]').attr('colspan', visible);
					}
				}
			});

			// Table destroyed - nuke any child rows
			api.on(destroyEvent, function (e, ctx) {
				if (settings !== ctx) {
					return;
				}

				for (var i = 0, ien = data.length; i < ien; i++) {
					if (data[i]._details) {
						__details_remove(api, i);
					}
				}
			});
		}
	};

	// Strings for the method names to help minification
	var _emp = '';
	var _child_obj = _emp + 'row().child';
	var _child_mth = _child_obj + '()';

	// data can be:
	//  tr
	//  string
	//  jQuery or array of any of the above
	_api_register(_child_mth, function (data, klass) {
		var ctx = this.context;

		if (data === undefined) {
			// get
			return ctx.length && this.length ? ctx[0].aoData[this[0]]._details : undefined;
		} else if (data === true) {
			// show
			this.child.show();
		} else if (data === false) {
			// remove
			__details_remove(this);
		} else if (ctx.length && this.length) {
			// set
			__details_add(ctx[0], ctx[0].aoData[this[0]], data, klass);
		}

		return this;
	});

	_api_register([_child_obj + '.show()', _child_mth + '.show()' // only when `child()` was called with parameters (without
	], function (show) {
		// it returns an object and this method is not executed)
		__details_display(this, true);
		return this;
	});

	_api_register([_child_obj + '.hide()', _child_mth + '.hide()' // only when `child()` was called with parameters (without
	], function () {
		// it returns an object and this method is not executed)
		__details_display(this, false);
		return this;
	});

	_api_register([_child_obj + '.remove()', _child_mth + '.remove()' // only when `child()` was called with parameters (without
	], function () {
		// it returns an object and this method is not executed)
		__details_remove(this);
		return this;
	});

	_api_register(_child_obj + '.isShown()', function () {
		var ctx = this.context;

		if (ctx.length && this.length) {
			// _detailsShown as false or undefined will fall through to return false
			return ctx[0].aoData[this[0]]._detailsShow || false;
		}
		return false;
	});

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  * Columns
  *
  * {integer}           - column index (>=0 count from left, <0 count from right)
  * "{integer}:visIdx"  - visible column index (i.e. translate to column index)  (>=0 count from left, <0 count from right)
  * "{integer}:visible" - alias for {integer}:visIdx  (>=0 count from left, <0 count from right)
  * "{string}:name"     - column name
  * "{string}"          - jQuery selector on column header nodes
  *
  */

	// can be an array of these items, comma separated list, or an array of comma
	// separated lists

	var __re_column_selector = /^([^:]+):(name|visIdx|visible)$/;

	// r1 and r2 are redundant - but it means that the parameters match for the
	// iterator callback in columns().data()
	var __columnData = function __columnData(settings, column, r1, r2, rows) {
		var a = [];
		for (var row = 0, ien = rows.length; row < ien; row++) {
			a.push(_fnGetCellData(settings, rows[row], column));
		}
		return a;
	};

	var __column_selector = function __column_selector(settings, selector, opts) {
		var columns = settings.aoColumns,
		    names = _pluck(columns, 'sName'),
		    nodes = _pluck(columns, 'nTh');

		var run = function run(s) {
			var selInt = _intVal(s);

			// Selector - all
			if (s === '') {
				return _range(columns.length);
			}

			// Selector - index
			if (selInt !== null) {
				return [selInt >= 0 ? selInt : // Count from left
				columns.length + selInt // Count from right (+ because its a negative value)
				];
			}

			// Selector = function
			if (typeof s === 'function') {
				var rows = _selector_row_indexes(settings, opts);

				return $.map(columns, function (col, idx) {
					return s(idx, __columnData(settings, idx, 0, 0, rows), nodes[idx]) ? idx : null;
				});
			}

			// jQuery or string selector
			var match = typeof s === 'string' ? s.match(__re_column_selector) : '';

			if (match) {
				switch (match[2]) {
					case 'visIdx':
					case 'visible':
						var idx = parseInt(match[1], 10);
						// Visible index given, convert to column index
						if (idx < 0) {
							// Counting from the right
							var visColumns = $.map(columns, function (col, i) {
								return col.bVisible ? i : null;
							});
							return [visColumns[visColumns.length + idx]];
						}
						// Counting from the left
						return [_fnVisibleToColumnIndex(settings, idx)];

					case 'name':
						// match by name. `names` is column index complete and in order
						return $.map(names, function (name, i) {
							return name === match[1] ? i : null;
						});

					default:
						return [];
				}
			}

			// Cell in the table body
			if (s.nodeName && s._DT_CellIndex) {
				return [s._DT_CellIndex.column];
			}

			// jQuery selector on the TH elements for the columns
			var jqResult = $(nodes).filter(s).map(function () {
				return $.inArray(this, nodes); // `nodes` is column index complete and in order
			}).toArray();

			if (jqResult.length || !s.nodeName) {
				return jqResult;
			}

			// Otherwise a node which might have a `dt-column` data attribute, or be
			// a child or such an element
			var host = $(s).closest('*[data-dt-column]');
			return host.length ? [host.data('dt-column')] : [];
		};

		return _selector_run('column', selector, run, settings, opts);
	};

	var __setColumnVis = function __setColumnVis(settings, column, vis) {
		var cols = settings.aoColumns,
		    col = cols[column],
		    data = settings.aoData,
		    row,
		    cells,
		    i,
		    ien,
		    tr;

		// Get
		if (vis === undefined) {
			return col.bVisible;
		}

		// Set
		// No change
		if (col.bVisible === vis) {
			return;
		}

		if (vis) {
			// Insert column
			// Need to decide if we should use appendChild or insertBefore
			var insertBefore = $.inArray(true, _pluck(cols, 'bVisible'), column + 1);

			for (i = 0, ien = data.length; i < ien; i++) {
				tr = data[i].nTr;
				cells = data[i].anCells;

				if (tr) {
					// insertBefore can act like appendChild if 2nd arg is null
					tr.insertBefore(cells[column], cells[insertBefore] || null);
				}
			}
		} else {
			// Remove column
			$(_pluck(settings.aoData, 'anCells', column)).detach();
		}

		// Common actions
		col.bVisible = vis;
		_fnDrawHead(settings, settings.aoHeader);
		_fnDrawHead(settings, settings.aoFooter);

		_fnSaveState(settings);
	};

	_api_register('columns()', function (selector, opts) {
		// argument shifting
		if (selector === undefined) {
			selector = '';
		} else if ($.isPlainObject(selector)) {
			opts = selector;
			selector = '';
		}

		opts = _selector_opts(opts);

		var inst = this.iterator('table', function (settings) {
			return __column_selector(settings, selector, opts);
		}, 1);

		// Want argument shifting here and in _row_selector?
		inst.selector.cols = selector;
		inst.selector.opts = opts;

		return inst;
	});

	_api_registerPlural('columns().header()', 'column().header()', function (selector, opts) {
		return this.iterator('column', function (settings, column) {
			return settings.aoColumns[column].nTh;
		}, 1);
	});

	_api_registerPlural('columns().footer()', 'column().footer()', function (selector, opts) {
		return this.iterator('column', function (settings, column) {
			return settings.aoColumns[column].nTf;
		}, 1);
	});

	_api_registerPlural('columns().data()', 'column().data()', function () {
		return this.iterator('column-rows', __columnData, 1);
	});

	_api_registerPlural('columns().dataSrc()', 'column().dataSrc()', function () {
		return this.iterator('column', function (settings, column) {
			return settings.aoColumns[column].mData;
		}, 1);
	});

	_api_registerPlural('columns().cache()', 'column().cache()', function (type) {
		return this.iterator('column-rows', function (settings, column, i, j, rows) {
			return _pluck_order(settings.aoData, rows, type === 'search' ? '_aFilterData' : '_aSortData', column);
		}, 1);
	});

	_api_registerPlural('columns().nodes()', 'column().nodes()', function () {
		return this.iterator('column-rows', function (settings, column, i, j, rows) {
			return _pluck_order(settings.aoData, rows, 'anCells', column);
		}, 1);
	});

	_api_registerPlural('columns().visible()', 'column().visible()', function (vis, calc) {
		var ret = this.iterator('column', function (settings, column) {
			if (vis === undefined) {
				return settings.aoColumns[column].bVisible;
			} // else
			__setColumnVis(settings, column, vis);
		});

		// Group the column visibility changes
		if (vis !== undefined) {
			// Second loop once the first is done for events
			this.iterator('column', function (settings, column) {
				_fnCallbackFire(settings, null, 'column-visibility', [settings, column, vis, calc]);
			});

			if (calc === undefined || calc) {
				this.columns.adjust();
			}
		}

		return ret;
	});

	_api_registerPlural('columns().indexes()', 'column().index()', function (type) {
		return this.iterator('column', function (settings, column) {
			return type === 'visible' ? _fnColumnIndexToVisible(settings, column) : column;
		}, 1);
	});

	_api_register('columns.adjust()', function () {
		return this.iterator('table', function (settings) {
			_fnAdjustColumnSizing(settings);
		}, 1);
	});

	_api_register('column.index()', function (type, idx) {
		if (this.context.length !== 0) {
			var ctx = this.context[0];

			if (type === 'fromVisible' || type === 'toData') {
				return _fnVisibleToColumnIndex(ctx, idx);
			} else if (type === 'fromData' || type === 'toVisible') {
				return _fnColumnIndexToVisible(ctx, idx);
			}
		}
	});

	_api_register('column()', function (selector, opts) {
		return _selector_first(this.columns(selector, opts));
	});

	var __cell_selector = function __cell_selector(settings, selector, opts) {
		var data = settings.aoData;
		var rows = _selector_row_indexes(settings, opts);
		var cells = _removeEmpty(_pluck_order(data, rows, 'anCells'));
		var allCells = $([].concat.apply([], cells));
		var row;
		var columns = settings.aoColumns.length;
		var a, i, ien, j, o, host;

		var run = function run(s) {
			var fnSelector = typeof s === 'function';

			if (s === null || s === undefined || fnSelector) {
				// All cells and function selectors
				a = [];

				for (i = 0, ien = rows.length; i < ien; i++) {
					row = rows[i];

					for (j = 0; j < columns; j++) {
						o = {
							row: row,
							column: j
						};

						if (fnSelector) {
							// Selector - function
							host = data[row];

							if (s(o, _fnGetCellData(settings, row, j), host.anCells ? host.anCells[j] : null)) {
								a.push(o);
							}
						} else {
							// Selector - all
							a.push(o);
						}
					}
				}

				return a;
			}

			// Selector - index
			if ($.isPlainObject(s)) {
				return [s];
			}

			// Selector - jQuery filtered cells
			var jqResult = allCells.filter(s).map(function (i, el) {
				return { // use a new object, in case someone changes the values
					row: el._DT_CellIndex.row,
					column: el._DT_CellIndex.column
				};
			}).toArray();

			if (jqResult.length || !s.nodeName) {
				return jqResult;
			}

			// Otherwise the selector is a node, and there is one last option - the
			// element might be a child of an element which has dt-row and dt-column
			// data attributes
			host = $(s).closest('*[data-dt-row]');
			return host.length ? [{
				row: host.data('dt-row'),
				column: host.data('dt-column')
			}] : [];
		};

		return _selector_run('cell', selector, run, settings, opts);
	};

	_api_register('cells()', function (rowSelector, columnSelector, opts) {
		// Argument shifting
		if ($.isPlainObject(rowSelector)) {
			// Indexes
			if (rowSelector.row === undefined) {
				// Selector options in first parameter
				opts = rowSelector;
				rowSelector = null;
			} else {
				// Cell index objects in first parameter
				opts = columnSelector;
				columnSelector = null;
			}
		}
		if ($.isPlainObject(columnSelector)) {
			opts = columnSelector;
			columnSelector = null;
		}

		// Cell selector
		if (columnSelector === null || columnSelector === undefined) {
			return this.iterator('table', function (settings) {
				return __cell_selector(settings, rowSelector, _selector_opts(opts));
			});
		}

		// Row + column selector
		var columns = this.columns(columnSelector, opts);
		var rows = this.rows(rowSelector, opts);
		var a, i, ien, j, jen;

		var cells = this.iterator('table', function (settings, idx) {
			a = [];

			for (i = 0, ien = rows[idx].length; i < ien; i++) {
				for (j = 0, jen = columns[idx].length; j < jen; j++) {
					a.push({
						row: rows[idx][i],
						column: columns[idx][j]
					});
				}
			}

			return a;
		}, 1);

		$.extend(cells.selector, {
			cols: columnSelector,
			rows: rowSelector,
			opts: opts
		});

		return cells;
	});

	_api_registerPlural('cells().nodes()', 'cell().node()', function () {
		return this.iterator('cell', function (settings, row, column) {
			var data = settings.aoData[row];

			return data && data.anCells ? data.anCells[column] : undefined;
		}, 1);
	});

	_api_register('cells().data()', function () {
		return this.iterator('cell', function (settings, row, column) {
			return _fnGetCellData(settings, row, column);
		}, 1);
	});

	_api_registerPlural('cells().cache()', 'cell().cache()', function (type) {
		type = type === 'search' ? '_aFilterData' : '_aSortData';

		return this.iterator('cell', function (settings, row, column) {
			return settings.aoData[row][type][column];
		}, 1);
	});

	_api_registerPlural('cells().render()', 'cell().render()', function (type) {
		return this.iterator('cell', function (settings, row, column) {
			return _fnGetCellData(settings, row, column, type);
		}, 1);
	});

	_api_registerPlural('cells().indexes()', 'cell().index()', function () {
		return this.iterator('cell', function (settings, row, column) {
			return {
				row: row,
				column: column,
				columnVisible: _fnColumnIndexToVisible(settings, column)
			};
		}, 1);
	});

	_api_registerPlural('cells().invalidate()', 'cell().invalidate()', function (src) {
		return this.iterator('cell', function (settings, row, column) {
			_fnInvalidate(settings, row, src, column);
		});
	});

	_api_register('cell()', function (rowSelector, columnSelector, opts) {
		return _selector_first(this.cells(rowSelector, columnSelector, opts));
	});

	_api_register('cell().data()', function (data) {
		var ctx = this.context;
		var cell = this[0];

		if (data === undefined) {
			// Get
			return ctx.length && cell.length ? _fnGetCellData(ctx[0], cell[0].row, cell[0].column) : undefined;
		}

		// Set
		_fnSetCellData(ctx[0], cell[0].row, cell[0].column, data);
		_fnInvalidate(ctx[0], cell[0].row, 'data', cell[0].column);

		return this;
	});

	/**
  * Get current ordering (sorting) that has been applied to the table.
  *
  * @returns {array} 2D array containing the sorting information for the first
  *   table in the current context. Each element in the parent array represents
  *   a column being sorted upon (i.e. multi-sorting with two columns would have
  *   2 inner arrays). The inner arrays may have 2 or 3 elements. The first is
  *   the column index that the sorting condition applies to, the second is the
  *   direction of the sort (`desc` or `asc`) and, optionally, the third is the
  *   index of the sorting order from the `column.sorting` initialisation array.
  */ /**
     * Set the ordering for the table.
     *
     * @param {integer} order Column index to sort upon.
     * @param {string} direction Direction of the sort to be applied (`asc` or `desc`)
     * @returns {DataTables.Api} this
     */ /**
        * Set the ordering for the table.
        *
        * @param {array} order 1D array of sorting information to be applied.
        * @param {array} [...] Optional additional sorting conditions
        * @returns {DataTables.Api} this
        */ /**
           * Set the ordering for the table.
           *
           * @param {array} order 2D array of sorting information to be applied.
           * @returns {DataTables.Api} this
           */
	_api_register('order()', function (order, dir) {
		var ctx = this.context;

		if (order === undefined) {
			// get
			return ctx.length !== 0 ? ctx[0].aaSorting : undefined;
		}

		// set
		if (typeof order === 'number') {
			// Simple column / direction passed in
			order = [[order, dir]];
		} else if (order.length && !$.isArray(order[0])) {
			// Arguments passed in (list of 1D arrays)
			order = Array.prototype.slice.call(arguments);
		}
		// otherwise a 2D array was passed in

		return this.iterator('table', function (settings) {
			settings.aaSorting = order.slice();
		});
	});

	/**
  * Attach a sort listener to an element for a given column
  *
  * @param {node|jQuery|string} node Identifier for the element(s) to attach the
  *   listener to. This can take the form of a single DOM node, a jQuery
  *   collection of nodes or a jQuery selector which will identify the node(s).
  * @param {integer} column the column that a click on this node will sort on
  * @param {function} [callback] callback function when sort is run
  * @returns {DataTables.Api} this
  */
	_api_register('order.listener()', function (node, column, callback) {
		return this.iterator('table', function (settings) {
			_fnSortAttachListener(settings, node, column, callback);
		});
	});

	_api_register('order.fixed()', function (set) {
		if (!set) {
			var ctx = this.context;
			var fixed = ctx.length ? ctx[0].aaSortingFixed : undefined;

			return $.isArray(fixed) ? { pre: fixed } : fixed;
		}

		return this.iterator('table', function (settings) {
			settings.aaSortingFixed = $.extend(true, {}, set);
		});
	});

	// Order by the selected column(s)
	_api_register(['columns().order()', 'column().order()'], function (dir) {
		var that = this;

		return this.iterator('table', function (settings, i) {
			var sort = [];

			$.each(that[i], function (j, col) {
				sort.push([col, dir]);
			});

			settings.aaSorting = sort;
		});
	});

	_api_register('search()', function (input, regex, smart, caseInsen) {
		var ctx = this.context;

		if (input === undefined) {
			// get
			return ctx.length !== 0 ? ctx[0].oPreviousSearch.sSearch : undefined;
		}

		// set
		return this.iterator('table', function (settings) {
			if (!settings.oFeatures.bFilter) {
				return;
			}

			_fnFilterComplete(settings, $.extend({}, settings.oPreviousSearch, {
				"sSearch": input + "",
				"bRegex": regex === null ? false : regex,
				"bSmart": smart === null ? true : smart,
				"bCaseInsensitive": caseInsen === null ? true : caseInsen
			}), 1);
		});
	});

	_api_registerPlural('columns().search()', 'column().search()', function (input, regex, smart, caseInsen) {
		return this.iterator('column', function (settings, column) {
			var preSearch = settings.aoPreSearchCols;

			if (input === undefined) {
				// get
				return preSearch[column].sSearch;
			}

			// set
			if (!settings.oFeatures.bFilter) {
				return;
			}

			$.extend(preSearch[column], {
				"sSearch": input + "",
				"bRegex": regex === null ? false : regex,
				"bSmart": smart === null ? true : smart,
				"bCaseInsensitive": caseInsen === null ? true : caseInsen
			});

			_fnFilterComplete(settings, settings.oPreviousSearch, 1);
		});
	});

	/*
  * State API methods
  */

	_api_register('state()', function () {
		return this.context.length ? this.context[0].oSavedState : null;
	});

	_api_register('state.clear()', function () {
		return this.iterator('table', function (settings) {
			// Save an empty object
			settings.fnStateSaveCallback.call(settings.oInstance, settings, {});
		});
	});

	_api_register('state.loaded()', function () {
		return this.context.length ? this.context[0].oLoadedState : null;
	});

	_api_register('state.save()', function () {
		return this.iterator('table', function (settings) {
			_fnSaveState(settings);
		});
	});

	/**
  * Provide a common method for plug-ins to check the version of DataTables being
  * used, in order to ensure compatibility.
  *
  *  @param {string} version Version string to check for, in the format "X.Y.Z".
  *    Note that the formats "X" and "X.Y" are also acceptable.
  *  @returns {boolean} true if this version of DataTables is greater or equal to
  *    the required version, or false if this version of DataTales is not
  *    suitable
  *  @static
  *  @dtopt API-Static
  *
  *  @example
  *    alert( $.fn.dataTable.versionCheck( '1.9.0' ) );
  */
	DataTable.versionCheck = DataTable.fnVersionCheck = function (version) {
		var aThis = DataTable.version.split('.');
		var aThat = version.split('.');
		var iThis, iThat;

		for (var i = 0, iLen = aThat.length; i < iLen; i++) {
			iThis = parseInt(aThis[i], 10) || 0;
			iThat = parseInt(aThat[i], 10) || 0;

			// Parts are the same, keep comparing
			if (iThis === iThat) {
				continue;
			}

			// Parts are different, return immediately
			return iThis > iThat;
		}

		return true;
	};

	/**
  * Check if a `<table>` node is a DataTable table already or not.
  *
  *  @param {node|jquery|string} table Table node, jQuery object or jQuery
  *      selector for the table to test. Note that if more than more than one
  *      table is passed on, only the first will be checked
  *  @returns {boolean} true the table given is a DataTable, or false otherwise
  *  @static
  *  @dtopt API-Static
  *
  *  @example
  *    if ( ! $.fn.DataTable.isDataTable( '#example' ) ) {
  *      $('#example').dataTable();
  *    }
  */
	DataTable.isDataTable = DataTable.fnIsDataTable = function (table) {
		var t = $(table).get(0);
		var is = false;

		if (table instanceof DataTable.Api) {
			return true;
		}

		$.each(DataTable.settings, function (i, o) {
			var head = o.nScrollHead ? $('table', o.nScrollHead)[0] : null;
			var foot = o.nScrollFoot ? $('table', o.nScrollFoot)[0] : null;

			if (o.nTable === t || head === t || foot === t) {
				is = true;
			}
		});

		return is;
	};

	/**
  * Get all DataTable tables that have been initialised - optionally you can
  * select to get only currently visible tables.
  *
  *  @param {boolean} [visible=false] Flag to indicate if you want all (default)
  *    or visible tables only.
  *  @returns {array} Array of `table` nodes (not DataTable instances) which are
  *    DataTables
  *  @static
  *  @dtopt API-Static
  *
  *  @example
  *    $.each( $.fn.dataTable.tables(true), function () {
  *      $(table).DataTable().columns.adjust();
  *    } );
  */
	DataTable.tables = DataTable.fnTables = function (visible) {
		var api = false;

		if ($.isPlainObject(visible)) {
			api = visible.api;
			visible = visible.visible;
		}

		var a = $.map(DataTable.settings, function (o) {
			if (!visible || visible && $(o.nTable).is(':visible')) {
				return o.nTable;
			}
		});

		return api ? new _Api2(a) : a;
	};

	/**
  * Convert from camel case parameters to Hungarian notation. This is made public
  * for the extensions to provide the same ability as DataTables core to accept
  * either the 1.9 style Hungarian notation, or the 1.10+ style camelCase
  * parameters.
  *
  *  @param {object} src The model object which holds all parameters that can be
  *    mapped.
  *  @param {object} user The object to convert from camel case to Hungarian.
  *  @param {boolean} force When set to `true`, properties which already have a
  *    Hungarian value in the `user` object will be overwritten. Otherwise they
  *    won't be.
  */
	DataTable.camelToHungarian = _fnCamelToHungarian;

	/**
  *
  */
	_api_register('$()', function (selector, opts) {
		var rows = this.rows(opts).nodes(),
		    // Get all rows
		jqRows = $(rows);

		return $([].concat(jqRows.filter(selector).toArray(), jqRows.find(selector).toArray()));
	});

	// jQuery functions to operate on the tables
	$.each(['on', 'one', 'off'], function (i, key) {
		_api_register(key + '()', function () /* event, handler */{
			var args = Array.prototype.slice.call(arguments);

			// Add the `dt` namespace automatically if it isn't already present
			args[0] = $.map(args[0].split(/\s/), function (e) {
				return !e.match(/\.dt\b/) ? e + '.dt' : e;
			}).join(' ');

			var inst = $(this.tables().nodes());
			inst[key].apply(inst, args);
			return this;
		});
	});

	_api_register('clear()', function () {
		return this.iterator('table', function (settings) {
			_fnClearTable(settings);
		});
	});

	_api_register('settings()', function () {
		return new _Api2(this.context, this.context);
	});

	_api_register('init()', function () {
		var ctx = this.context;
		return ctx.length ? ctx[0].oInit : null;
	});

	_api_register('data()', function () {
		return this.iterator('table', function (settings) {
			return _pluck(settings.aoData, '_aData');
		}).flatten();
	});

	_api_register('destroy()', function (remove) {
		remove = remove || false;

		return this.iterator('table', function (settings) {
			var orig = settings.nTableWrapper.parentNode;
			var classes = settings.oClasses;
			var table = settings.nTable;
			var tbody = settings.nTBody;
			var thead = settings.nTHead;
			var tfoot = settings.nTFoot;
			var jqTable = $(table);
			var jqTbody = $(tbody);
			var jqWrapper = $(settings.nTableWrapper);
			var rows = $.map(settings.aoData, function (r) {
				return r.nTr;
			});
			var i, ien;

			// Flag to note that the table is currently being destroyed - no action
			// should be taken
			settings.bDestroying = true;

			// Fire off the destroy callbacks for plug-ins etc
			_fnCallbackFire(settings, "aoDestroyCallback", "destroy", [settings]);

			// If not being removed from the document, make all columns visible
			if (!remove) {
				new _Api2(settings).columns().visible(true);
			}

			// Blitz all `DT` namespaced events (these are internal events, the
			// lowercase, `dt` events are user subscribed and they are responsible
			// for removing them
			jqWrapper.off('.DT').find(':not(tbody *)').off('.DT');
			$(window).off('.DT-' + settings.sInstance);

			// When scrolling we had to break the table up - restore it
			if (table != thead.parentNode) {
				jqTable.children('thead').detach();
				jqTable.append(thead);
			}

			if (tfoot && table != tfoot.parentNode) {
				jqTable.children('tfoot').detach();
				jqTable.append(tfoot);
			}

			settings.aaSorting = [];
			settings.aaSortingFixed = [];
			_fnSortingClasses(settings);

			$(rows).removeClass(settings.asStripeClasses.join(' '));

			$('th, td', thead).removeClass(classes.sSortable + ' ' + classes.sSortableAsc + ' ' + classes.sSortableDesc + ' ' + classes.sSortableNone);

			if (settings.bJUI) {
				$('th span.' + classes.sSortIcon + ', td span.' + classes.sSortIcon, thead).detach();
				$('th, td', thead).each(function () {
					var wrapper = $('div.' + classes.sSortJUIWrapper, this);
					$(this).append(wrapper.contents());
					wrapper.detach();
				});
			}

			// Add the TR elements back into the table in their original order
			jqTbody.children().detach();
			jqTbody.append(rows);

			// Remove the DataTables generated nodes, events and classes
			var removedMethod = remove ? 'remove' : 'detach';
			jqTable[removedMethod]();
			jqWrapper[removedMethod]();

			// If we need to reattach the table to the document
			if (!remove && orig) {
				// insertBefore acts like appendChild if !arg[1]
				orig.insertBefore(table, settings.nTableReinsertBefore);

				// Restore the width of the original table - was read from the style property,
				// so we can restore directly to that
				jqTable.css('width', settings.sDestroyWidth).removeClass(classes.sTable);

				// If the were originally stripe classes - then we add them back here.
				// Note this is not fool proof (for example if not all rows had stripe
				// classes - but it's a good effort without getting carried away
				ien = settings.asDestroyStripes.length;

				if (ien) {
					jqTbody.children().each(function (i) {
						$(this).addClass(settings.asDestroyStripes[i % ien]);
					});
				}
			}

			/* Remove the settings object from the settings array */
			var idx = $.inArray(settings, DataTable.settings);
			if (idx !== -1) {
				DataTable.settings.splice(idx, 1);
			}
		});
	});

	// Add the `every()` method for rows, columns and cells in a compact form
	$.each(['column', 'row', 'cell'], function (i, type) {
		_api_register(type + 's().every()', function (fn) {
			var opts = this.selector.opts;
			var api = this;

			return this.iterator(type, function (settings, arg1, arg2, arg3, arg4) {
				// Rows and columns:
				//  arg1 - index
				//  arg2 - table counter
				//  arg3 - loop counter
				//  arg4 - undefined
				// Cells:
				//  arg1 - row index
				//  arg2 - column index
				//  arg3 - table counter
				//  arg4 - loop counter
				fn.call(api[type](arg1, type === 'cell' ? arg2 : opts, type === 'cell' ? opts : undefined), arg1, arg2, arg3, arg4);
			});
		});
	});

	// i18n method for extensions to be able to use the language object from the
	// DataTable
	_api_register('i18n()', function (token, def, plural) {
		var ctx = this.context[0];
		var resolved = _fnGetObjectDataFn(token)(ctx.oLanguage);

		if (resolved === undefined) {
			resolved = def;
		}

		if (plural !== undefined && $.isPlainObject(resolved)) {
			resolved = resolved[plural] !== undefined ? resolved[plural] : resolved._;
		}

		return resolved.replace('%d', plural); // nb: plural might be undefined,
	});
	/**
  * Version string for plug-ins to check compatibility. Allowed format is
  * `a.b.c-d` where: a:int, b:int, c:int, d:string(dev|beta|alpha). `d` is used
  * only for non-release builds. See http://semver.org/ for more information.
  *  @member
  *  @type string
  *  @default Version number
  */
	DataTable.version = "1.10.15";

	/**
  * Private data store, containing all of the settings objects that are
  * created for the tables on a given page.
  *
  * Note that the `DataTable.settings` object is aliased to
  * `jQuery.fn.dataTableExt` through which it may be accessed and
  * manipulated, or `jQuery.fn.dataTable.settings`.
  *  @member
  *  @type array
  *  @default []
  *  @private
  */
	DataTable.settings = [];

	/**
  * Object models container, for the various models that DataTables has
  * available to it. These models define the objects that are used to hold
  * the active state and configuration of the table.
  *  @namespace
  */
	DataTable.models = {};

	/**
  * Template object for the way in which DataTables holds information about
  * search information for the global filter and individual column filters.
  *  @namespace
  */
	DataTable.models.oSearch = {
		/**
   * Flag to indicate if the filtering should be case insensitive or not
   *  @type boolean
   *  @default true
   */
		"bCaseInsensitive": true,

		/**
   * Applied search term
   *  @type string
   *  @default <i>Empty string</i>
   */
		"sSearch": "",

		/**
   * Flag to indicate if the search term should be interpreted as a
   * regular expression (true) or not (false) and therefore and special
   * regex characters escaped.
   *  @type boolean
   *  @default false
   */
		"bRegex": false,

		/**
   * Flag to indicate if DataTables is to use its smart filtering or not.
   *  @type boolean
   *  @default true
   */
		"bSmart": true
	};

	/**
  * Template object for the way in which DataTables holds information about
  * each individual row. This is the object format used for the settings
  * aoData array.
  *  @namespace
  */
	DataTable.models.oRow = {
		/**
   * TR element for the row
   *  @type node
   *  @default null
   */
		"nTr": null,

		/**
   * Array of TD elements for each row. This is null until the row has been
   * created.
   *  @type array nodes
   *  @default []
   */
		"anCells": null,

		/**
   * Data object from the original data source for the row. This is either
   * an array if using the traditional form of DataTables, or an object if
   * using mData options. The exact type will depend on the passed in
   * data from the data source, or will be an array if using DOM a data
   * source.
   *  @type array|object
   *  @default []
   */
		"_aData": [],

		/**
   * Sorting data cache - this array is ostensibly the same length as the
   * number of columns (although each index is generated only as it is
   * needed), and holds the data that is used for sorting each column in the
   * row. We do this cache generation at the start of the sort in order that
   * the formatting of the sort data need be done only once for each cell
   * per sort. This array should not be read from or written to by anything
   * other than the master sorting methods.
   *  @type array
   *  @default null
   *  @private
   */
		"_aSortData": null,

		/**
   * Per cell filtering data cache. As per the sort data cache, used to
   * increase the performance of the filtering in DataTables
   *  @type array
   *  @default null
   *  @private
   */
		"_aFilterData": null,

		/**
   * Filtering data cache. This is the same as the cell filtering cache, but
   * in this case a string rather than an array. This is easily computed with
   * a join on `_aFilterData`, but is provided as a cache so the join isn't
   * needed on every search (memory traded for performance)
   *  @type array
   *  @default null
   *  @private
   */
		"_sFilterRow": null,

		/**
   * Cache of the class name that DataTables has applied to the row, so we
   * can quickly look at this variable rather than needing to do a DOM check
   * on className for the nTr property.
   *  @type string
   *  @default <i>Empty string</i>
   *  @private
   */
		"_sRowStripe": "",

		/**
   * Denote if the original data source was from the DOM, or the data source
   * object. This is used for invalidating data, so DataTables can
   * automatically read data from the original source, unless uninstructed
   * otherwise.
   *  @type string
   *  @default null
   *  @private
   */
		"src": null,

		/**
   * Index in the aoData array. This saves an indexOf lookup when we have the
   * object, but want to know the index
   *  @type integer
   *  @default -1
   *  @private
   */
		"idx": -1
	};

	/**
  * Template object for the column information object in DataTables. This object
  * is held in the settings aoColumns array and contains all the information that
  * DataTables needs about each individual column.
  *
  * Note that this object is related to {@link DataTable.defaults.column}
  * but this one is the internal data store for DataTables's cache of columns.
  * It should NOT be manipulated outside of DataTables. Any configuration should
  * be done through the initialisation options.
  *  @namespace
  */
	DataTable.models.oColumn = {
		/**
   * Column index. This could be worked out on-the-fly with $.inArray, but it
   * is faster to just hold it as a variable
   *  @type integer
   *  @default null
   */
		"idx": null,

		/**
   * A list of the columns that sorting should occur on when this column
   * is sorted. That this property is an array allows multi-column sorting
   * to be defined for a column (for example first name / last name columns
   * would benefit from this). The values are integers pointing to the
   * columns to be sorted on (typically it will be a single integer pointing
   * at itself, but that doesn't need to be the case).
   *  @type array
   */
		"aDataSort": null,

		/**
   * Define the sorting directions that are applied to the column, in sequence
   * as the column is repeatedly sorted upon - i.e. the first value is used
   * as the sorting direction when the column if first sorted (clicked on).
   * Sort it again (click again) and it will move on to the next index.
   * Repeat until loop.
   *  @type array
   */
		"asSorting": null,

		/**
   * Flag to indicate if the column is searchable, and thus should be included
   * in the filtering or not.
   *  @type boolean
   */
		"bSearchable": null,

		/**
   * Flag to indicate if the column is sortable or not.
   *  @type boolean
   */
		"bSortable": null,

		/**
   * Flag to indicate if the column is currently visible in the table or not
   *  @type boolean
   */
		"bVisible": null,

		/**
   * Store for manual type assignment using the `column.type` option. This
   * is held in store so we can manipulate the column's `sType` property.
   *  @type string
   *  @default null
   *  @private
   */
		"_sManualType": null,

		/**
   * Flag to indicate if HTML5 data attributes should be used as the data
   * source for filtering or sorting. True is either are.
   *  @type boolean
   *  @default false
   *  @private
   */
		"_bAttrSrc": false,

		/**
   * Developer definable function that is called whenever a cell is created (Ajax source,
   * etc) or processed for input (DOM source). This can be used as a compliment to mRender
   * allowing you to modify the DOM element (add background colour for example) when the
   * element is available.
   *  @type function
   *  @param {element} nTd The TD node that has been created
   *  @param {*} sData The Data for the cell
   *  @param {array|object} oData The data for the whole row
   *  @param {int} iRow The row index for the aoData data store
   *  @default null
   */
		"fnCreatedCell": null,

		/**
   * Function to get data from a cell in a column. You should <b>never</b>
   * access data directly through _aData internally in DataTables - always use
   * the method attached to this property. It allows mData to function as
   * required. This function is automatically assigned by the column
   * initialisation method
   *  @type function
   *  @param {array|object} oData The data array/object for the array
   *    (i.e. aoData[]._aData)
   *  @param {string} sSpecific The specific data type you want to get -
   *    'display', 'type' 'filter' 'sort'
   *  @returns {*} The data for the cell from the given row's data
   *  @default null
   */
		"fnGetData": null,

		/**
   * Function to set data for a cell in the column. You should <b>never</b>
   * set the data directly to _aData internally in DataTables - always use
   * this method. It allows mData to function as required. This function
   * is automatically assigned by the column initialisation method
   *  @type function
   *  @param {array|object} oData The data array/object for the array
   *    (i.e. aoData[]._aData)
   *  @param {*} sValue Value to set
   *  @default null
   */
		"fnSetData": null,

		/**
   * Property to read the value for the cells in the column from the data
   * source array / object. If null, then the default content is used, if a
   * function is given then the return from the function is used.
   *  @type function|int|string|null
   *  @default null
   */
		"mData": null,

		/**
   * Partner property to mData which is used (only when defined) to get
   * the data - i.e. it is basically the same as mData, but without the
   * 'set' option, and also the data fed to it is the result from mData.
   * This is the rendering method to match the data method of mData.
   *  @type function|int|string|null
   *  @default null
   */
		"mRender": null,

		/**
   * Unique header TH/TD element for this column - this is what the sorting
   * listener is attached to (if sorting is enabled.)
   *  @type node
   *  @default null
   */
		"nTh": null,

		/**
   * Unique footer TH/TD element for this column (if there is one). Not used
   * in DataTables as such, but can be used for plug-ins to reference the
   * footer for each column.
   *  @type node
   *  @default null
   */
		"nTf": null,

		/**
   * The class to apply to all TD elements in the table's TBODY for the column
   *  @type string
   *  @default null
   */
		"sClass": null,

		/**
   * When DataTables calculates the column widths to assign to each column,
   * it finds the longest string in each column and then constructs a
   * temporary table and reads the widths from that. The problem with this
   * is that "mmm" is much wider then "iiii", but the latter is a longer
   * string - thus the calculation can go wrong (doing it properly and putting
   * it into an DOM object and measuring that is horribly(!) slow). Thus as
   * a "work around" we provide this option. It will append its value to the
   * text that is found to be the longest string for the column - i.e. padding.
   *  @type string
   */
		"sContentPadding": null,

		/**
   * Allows a default value to be given for a column's data, and will be used
   * whenever a null data source is encountered (this can be because mData
   * is set to null, or because the data source itself is null).
   *  @type string
   *  @default null
   */
		"sDefaultContent": null,

		/**
   * Name for the column, allowing reference to the column by name as well as
   * by index (needs a lookup to work by name).
   *  @type string
   */
		"sName": null,

		/**
   * Custom sorting data type - defines which of the available plug-ins in
   * afnSortData the custom sorting will use - if any is defined.
   *  @type string
   *  @default std
   */
		"sSortDataType": 'std',

		/**
   * Class to be applied to the header element when sorting on this column
   *  @type string
   *  @default null
   */
		"sSortingClass": null,

		/**
   * Class to be applied to the header element when sorting on this column -
   * when jQuery UI theming is used.
   *  @type string
   *  @default null
   */
		"sSortingClassJUI": null,

		/**
   * Title of the column - what is seen in the TH element (nTh).
   *  @type string
   */
		"sTitle": null,

		/**
   * Column sorting and filtering type
   *  @type string
   *  @default null
   */
		"sType": null,

		/**
   * Width of the column
   *  @type string
   *  @default null
   */
		"sWidth": null,

		/**
   * Width of the column when it was first "encountered"
   *  @type string
   *  @default null
   */
		"sWidthOrig": null
	};

	/*
  * Developer note: The properties of the object below are given in Hungarian
  * notation, that was used as the interface for DataTables prior to v1.10, however
  * from v1.10 onwards the primary interface is camel case. In order to avoid
  * breaking backwards compatibility utterly with this change, the Hungarian
  * version is still, internally the primary interface, but is is not documented
  * - hence the @name tags in each doc comment. This allows a Javascript function
  * to create a map from Hungarian notation to camel case (going the other direction
  * would require each property to be listed, which would at around 3K to the size
  * of DataTables, while this method is about a 0.5K hit.
  *
  * Ultimately this does pave the way for Hungarian notation to be dropped
  * completely, but that is a massive amount of work and will break current
  * installs (therefore is on-hold until v2).
  */

	/**
  * Initialisation options that can be given to DataTables at initialisation
  * time.
  *  @namespace
  */
	DataTable.defaults = {
		/**
   * An array of data to use for the table, passed in at initialisation which
   * will be used in preference to any data which is already in the DOM. This is
   * particularly useful for constructing tables purely in Javascript, for
   * example with a custom Ajax call.
   *  @type array
   *  @default null
   *
   *  @dtopt Option
   *  @name DataTable.defaults.data
   *
   *  @example
   *    // Using a 2D array data source
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "data": [
   *          ['Trident', 'Internet Explorer 4.0', 'Win 95+', 4, 'X'],
   *          ['Trident', 'Internet Explorer 5.0', 'Win 95+', 5, 'C'],
   *        ],
   *        "columns": [
   *          { "title": "Engine" },
   *          { "title": "Browser" },
   *          { "title": "Platform" },
   *          { "title": "Version" },
   *          { "title": "Grade" }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using an array of objects as a data source (`data`)
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "data": [
   *          {
   *            "engine":   "Trident",
   *            "browser":  "Internet Explorer 4.0",
   *            "platform": "Win 95+",
   *            "version":  4,
   *            "grade":    "X"
   *          },
   *          {
   *            "engine":   "Trident",
   *            "browser":  "Internet Explorer 5.0",
   *            "platform": "Win 95+",
   *            "version":  5,
   *            "grade":    "C"
   *          }
   *        ],
   *        "columns": [
   *          { "title": "Engine",   "data": "engine" },
   *          { "title": "Browser",  "data": "browser" },
   *          { "title": "Platform", "data": "platform" },
   *          { "title": "Version",  "data": "version" },
   *          { "title": "Grade",    "data": "grade" }
   *        ]
   *      } );
   *    } );
   */
		"aaData": null,

		/**
   * If ordering is enabled, then DataTables will perform a first pass sort on
   * initialisation. You can define which column(s) the sort is performed
   * upon, and the sorting direction, with this variable. The `sorting` array
   * should contain an array for each column to be sorted initially containing
   * the column's index and a direction string ('asc' or 'desc').
   *  @type array
   *  @default [[0,'asc']]
   *
   *  @dtopt Option
   *  @name DataTable.defaults.order
   *
   *  @example
   *    // Sort by 3rd column first, and then 4th column
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "order": [[2,'asc'], [3,'desc']]
   *      } );
   *    } );
   *
   *    // No initial sorting
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "order": []
   *      } );
   *    } );
   */
		"aaSorting": [[0, 'asc']],

		/**
   * This parameter is basically identical to the `sorting` parameter, but
   * cannot be overridden by user interaction with the table. What this means
   * is that you could have a column (visible or hidden) which the sorting
   * will always be forced on first - any sorting after that (from the user)
   * will then be performed as required. This can be useful for grouping rows
   * together.
   *  @type array
   *  @default null
   *
   *  @dtopt Option
   *  @name DataTable.defaults.orderFixed
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "orderFixed": [[0,'asc']]
   *      } );
   *    } )
   */
		"aaSortingFixed": [],

		/**
   * DataTables can be instructed to load data to display in the table from a
   * Ajax source. This option defines how that Ajax call is made and where to.
   *
   * The `ajax` property has three different modes of operation, depending on
   * how it is defined. These are:
   *
   * * `string` - Set the URL from where the data should be loaded from.
   * * `object` - Define properties for `jQuery.ajax`.
   * * `function` - Custom data get function
   *
   * `string`
   * --------
   *
   * As a string, the `ajax` property simply defines the URL from which
   * DataTables will load data.
   *
   * `object`
   * --------
   *
   * As an object, the parameters in the object are passed to
   * [jQuery.ajax](http://api.jquery.com/jQuery.ajax/) allowing fine control
   * of the Ajax request. DataTables has a number of default parameters which
   * you can override using this option. Please refer to the jQuery
   * documentation for a full description of the options available, although
   * the following parameters provide additional options in DataTables or
   * require special consideration:
   *
   * * `data` - As with jQuery, `data` can be provided as an object, but it
   *   can also be used as a function to manipulate the data DataTables sends
   *   to the server. The function takes a single parameter, an object of
   *   parameters with the values that DataTables has readied for sending. An
   *   object may be returned which will be merged into the DataTables
   *   defaults, or you can add the items to the object that was passed in and
   *   not return anything from the function. This supersedes `fnServerParams`
   *   from DataTables 1.9-.
   *
   * * `dataSrc` - By default DataTables will look for the property `data` (or
   *   `aaData` for compatibility with DataTables 1.9-) when obtaining data
   *   from an Ajax source or for server-side processing - this parameter
   *   allows that property to be changed. You can use Javascript dotted
   *   object notation to get a data source for multiple levels of nesting, or
   *   it my be used as a function. As a function it takes a single parameter,
   *   the JSON returned from the server, which can be manipulated as
   *   required, with the returned value being that used by DataTables as the
   *   data source for the table. This supersedes `sAjaxDataProp` from
   *   DataTables 1.9-.
   *
   * * `success` - Should not be overridden it is used internally in
   *   DataTables. To manipulate / transform the data returned by the server
   *   use `ajax.dataSrc`, or use `ajax` as a function (see below).
   *
   * `function`
   * ----------
   *
   * As a function, making the Ajax call is left up to yourself allowing
   * complete control of the Ajax request. Indeed, if desired, a method other
   * than Ajax could be used to obtain the required data, such as Web storage
   * or an AIR database.
   *
   * The function is given four parameters and no return is required. The
   * parameters are:
   *
   * 1. _object_ - Data to send to the server
   * 2. _function_ - Callback function that must be executed when the required
   *    data has been obtained. That data should be passed into the callback
   *    as the only parameter
   * 3. _object_ - DataTables settings object for the table
   *
   * Note that this supersedes `fnServerData` from DataTables 1.9-.
   *
   *  @type string|object|function
   *  @default null
   *
   *  @dtopt Option
   *  @name DataTable.defaults.ajax
   *  @since 1.10.0
   *
   * @example
   *   // Get JSON data from a file via Ajax.
   *   // Note DataTables expects data in the form `{ data: [ ...data... ] }` by default).
   *   $('#example').dataTable( {
   *     "ajax": "data.json"
   *   } );
   *
   * @example
   *   // Get JSON data from a file via Ajax, using `dataSrc` to change
   *   // `data` to `tableData` (i.e. `{ tableData: [ ...data... ] }`)
   *   $('#example').dataTable( {
   *     "ajax": {
   *       "url": "data.json",
   *       "dataSrc": "tableData"
   *     }
   *   } );
   *
   * @example
   *   // Get JSON data from a file via Ajax, using `dataSrc` to read data
   *   // from a plain array rather than an array in an object
   *   $('#example').dataTable( {
   *     "ajax": {
   *       "url": "data.json",
   *       "dataSrc": ""
   *     }
   *   } );
   *
   * @example
   *   // Manipulate the data returned from the server - add a link to data
   *   // (note this can, should, be done using `render` for the column - this
   *   // is just a simple example of how the data can be manipulated).
   *   $('#example').dataTable( {
   *     "ajax": {
   *       "url": "data.json",
   *       "dataSrc": function ( json ) {
   *         for ( var i=0, ien=json.length ; i<ien ; i++ ) {
   *           json[i][0] = '<a href="/message/'+json[i][0]+'>View message</a>';
   *         }
   *         return json;
   *       }
   *     }
   *   } );
   *
   * @example
   *   // Add data to the request
   *   $('#example').dataTable( {
   *     "ajax": {
   *       "url": "data.json",
   *       "data": function ( d ) {
   *         return {
   *           "extra_search": $('#extra').val()
   *         };
   *       }
   *     }
   *   } );
   *
   * @example
   *   // Send request as POST
   *   $('#example').dataTable( {
   *     "ajax": {
   *       "url": "data.json",
   *       "type": "POST"
   *     }
   *   } );
   *
   * @example
   *   // Get the data from localStorage (could interface with a form for
   *   // adding, editing and removing rows).
   *   $('#example').dataTable( {
   *     "ajax": function (data, callback, settings) {
   *       callback(
   *         JSON.parse( localStorage.getItem('dataTablesData') )
   *       );
   *     }
   *   } );
   */
		"ajax": null,

		/**
   * This parameter allows you to readily specify the entries in the length drop
   * down menu that DataTables shows when pagination is enabled. It can be
   * either a 1D array of options which will be used for both the displayed
   * option and the value, or a 2D array which will use the array in the first
   * position as the value, and the array in the second position as the
   * displayed options (useful for language strings such as 'All').
   *
   * Note that the `pageLength` property will be automatically set to the
   * first value given in this array, unless `pageLength` is also provided.
   *  @type array
   *  @default [ 10, 25, 50, 100 ]
   *
   *  @dtopt Option
   *  @name DataTable.defaults.lengthMenu
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]]
   *      } );
   *    } );
   */
		"aLengthMenu": [10, 25, 50, 100],

		/**
   * The `columns` option in the initialisation parameter allows you to define
   * details about the way individual columns behave. For a full list of
   * column options that can be set, please see
   * {@link DataTable.defaults.column}. Note that if you use `columns` to
   * define your columns, you must have an entry in the array for every single
   * column that you have in your table (these can be null if you don't which
   * to specify any options).
   *  @member
   *
   *  @name DataTable.defaults.column
   */
		"aoColumns": null,

		/**
   * Very similar to `columns`, `columnDefs` allows you to target a specific
   * column, multiple columns, or all columns, using the `targets` property of
   * each object in the array. This allows great flexibility when creating
   * tables, as the `columnDefs` arrays can be of any length, targeting the
   * columns you specifically want. `columnDefs` may use any of the column
   * options available: {@link DataTable.defaults.column}, but it _must_
   * have `targets` defined in each object in the array. Values in the `targets`
   * array may be:
   *   <ul>
   *     <li>a string - class name will be matched on the TH for the column</li>
   *     <li>0 or a positive integer - column index counting from the left</li>
   *     <li>a negative integer - column index counting from the right</li>
   *     <li>the string "_all" - all columns (i.e. assign a default)</li>
   *   </ul>
   *  @member
   *
   *  @name DataTable.defaults.columnDefs
   */
		"aoColumnDefs": null,

		/**
   * Basically the same as `search`, this parameter defines the individual column
   * filtering state at initialisation time. The array must be of the same size
   * as the number of columns, and each element be an object with the parameters
   * `search` and `escapeRegex` (the latter is optional). 'null' is also
   * accepted and the default will be used.
   *  @type array
   *  @default []
   *
   *  @dtopt Option
   *  @name DataTable.defaults.searchCols
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "searchCols": [
   *          null,
   *          { "search": "My filter" },
   *          null,
   *          { "search": "^[0-9]", "escapeRegex": false }
   *        ]
   *      } );
   *    } )
   */
		"aoSearchCols": [],

		/**
   * An array of CSS classes that should be applied to displayed rows. This
   * array may be of any length, and DataTables will apply each class
   * sequentially, looping when required.
   *  @type array
   *  @default null <i>Will take the values determined by the `oClasses.stripe*`
   *    options</i>
   *
   *  @dtopt Option
   *  @name DataTable.defaults.stripeClasses
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "stripeClasses": [ 'strip1', 'strip2', 'strip3' ]
   *      } );
   *    } )
   */
		"asStripeClasses": null,

		/**
   * Enable or disable automatic column width calculation. This can be disabled
   * as an optimisation (it takes some time to calculate the widths) if the
   * tables widths are passed in using `columns`.
   *  @type boolean
   *  @default true
   *
   *  @dtopt Features
   *  @name DataTable.defaults.autoWidth
   *
   *  @example
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "autoWidth": false
   *      } );
   *    } );
   */
		"bAutoWidth": true,

		/**
   * Deferred rendering can provide DataTables with a huge speed boost when you
   * are using an Ajax or JS data source for the table. This option, when set to
   * true, will cause DataTables to defer the creation of the table elements for
   * each row until they are needed for a draw - saving a significant amount of
   * time.
   *  @type boolean
   *  @default false
   *
   *  @dtopt Features
   *  @name DataTable.defaults.deferRender
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "ajax": "sources/arrays.txt",
   *        "deferRender": true
   *      } );
   *    } );
   */
		"bDeferRender": false,

		/**
   * Replace a DataTable which matches the given selector and replace it with
   * one which has the properties of the new initialisation object passed. If no
   * table matches the selector, then the new DataTable will be constructed as
   * per normal.
   *  @type boolean
   *  @default false
   *
   *  @dtopt Options
   *  @name DataTable.defaults.destroy
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "srollY": "200px",
   *        "paginate": false
   *      } );
   *
   *      // Some time later....
   *      $('#example').dataTable( {
   *        "filter": false,
   *        "destroy": true
   *      } );
   *    } );
   */
		"bDestroy": false,

		/**
   * Enable or disable filtering of data. Filtering in DataTables is "smart" in
   * that it allows the end user to input multiple words (space separated) and
   * will match a row containing those words, even if not in the order that was
   * specified (this allow matching across multiple columns). Note that if you
   * wish to use filtering in DataTables this must remain 'true' - to remove the
   * default filtering input box and retain filtering abilities, please use
   * {@link DataTable.defaults.dom}.
   *  @type boolean
   *  @default true
   *
   *  @dtopt Features
   *  @name DataTable.defaults.searching
   *
   *  @example
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "searching": false
   *      } );
   *    } );
   */
		"bFilter": true,

		/**
   * Enable or disable the table information display. This shows information
   * about the data that is currently visible on the page, including information
   * about filtered data if that action is being performed.
   *  @type boolean
   *  @default true
   *
   *  @dtopt Features
   *  @name DataTable.defaults.info
   *
   *  @example
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "info": false
   *      } );
   *    } );
   */
		"bInfo": true,

		/**
   * Enable jQuery UI ThemeRoller support (required as ThemeRoller requires some
   * slightly different and additional mark-up from what DataTables has
   * traditionally used).
   *  @type boolean
   *  @default false
   *
   *  @dtopt Features
   *  @name DataTable.defaults.jQueryUI
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "jQueryUI": true
   *      } );
   *    } );
   */
		"bJQueryUI": false,

		/**
   * Allows the end user to select the size of a formatted page from a select
   * menu (sizes are 10, 25, 50 and 100). Requires pagination (`paginate`).
   *  @type boolean
   *  @default true
   *
   *  @dtopt Features
   *  @name DataTable.defaults.lengthChange
   *
   *  @example
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "lengthChange": false
   *      } );
   *    } );
   */
		"bLengthChange": true,

		/**
   * Enable or disable pagination.
   *  @type boolean
   *  @default true
   *
   *  @dtopt Features
   *  @name DataTable.defaults.paging
   *
   *  @example
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "paging": false
   *      } );
   *    } );
   */
		"bPaginate": true,

		/**
   * Enable or disable the display of a 'processing' indicator when the table is
   * being processed (e.g. a sort). This is particularly useful for tables with
   * large amounts of data where it can take a noticeable amount of time to sort
   * the entries.
   *  @type boolean
   *  @default false
   *
   *  @dtopt Features
   *  @name DataTable.defaults.processing
   *
   *  @example
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "processing": true
   *      } );
   *    } );
   */
		"bProcessing": false,

		/**
   * Retrieve the DataTables object for the given selector. Note that if the
   * table has already been initialised, this parameter will cause DataTables
   * to simply return the object that has already been set up - it will not take
   * account of any changes you might have made to the initialisation object
   * passed to DataTables (setting this parameter to true is an acknowledgement
   * that you understand this). `destroy` can be used to reinitialise a table if
   * you need.
   *  @type boolean
   *  @default false
   *
   *  @dtopt Options
   *  @name DataTable.defaults.retrieve
   *
   *  @example
   *    $(document).ready( function() {
   *      initTable();
   *      tableActions();
   *    } );
   *
   *    function initTable ()
   *    {
   *      return $('#example').dataTable( {
   *        "scrollY": "200px",
   *        "paginate": false,
   *        "retrieve": true
   *      } );
   *    }
   *
   *    function tableActions ()
   *    {
   *      var table = initTable();
   *      // perform API operations with oTable
   *    }
   */
		"bRetrieve": false,

		/**
   * When vertical (y) scrolling is enabled, DataTables will force the height of
   * the table's viewport to the given height at all times (useful for layout).
   * However, this can look odd when filtering data down to a small data set,
   * and the footer is left "floating" further down. This parameter (when
   * enabled) will cause DataTables to collapse the table's viewport down when
   * the result set will fit within the given Y height.
   *  @type boolean
   *  @default false
   *
   *  @dtopt Options
   *  @name DataTable.defaults.scrollCollapse
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "scrollY": "200",
   *        "scrollCollapse": true
   *      } );
   *    } );
   */
		"bScrollCollapse": false,

		/**
   * Configure DataTables to use server-side processing. Note that the
   * `ajax` parameter must also be given in order to give DataTables a
   * source to obtain the required data for each draw.
   *  @type boolean
   *  @default false
   *
   *  @dtopt Features
   *  @dtopt Server-side
   *  @name DataTable.defaults.serverSide
   *
   *  @example
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "serverSide": true,
   *        "ajax": "xhr.php"
   *      } );
   *    } );
   */
		"bServerSide": false,

		/**
   * Enable or disable sorting of columns. Sorting of individual columns can be
   * disabled by the `sortable` option for each column.
   *  @type boolean
   *  @default true
   *
   *  @dtopt Features
   *  @name DataTable.defaults.ordering
   *
   *  @example
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "ordering": false
   *      } );
   *    } );
   */
		"bSort": true,

		/**
   * Enable or display DataTables' ability to sort multiple columns at the
   * same time (activated by shift-click by the user).
   *  @type boolean
   *  @default true
   *
   *  @dtopt Options
   *  @name DataTable.defaults.orderMulti
   *
   *  @example
   *    // Disable multiple column sorting ability
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "orderMulti": false
   *      } );
   *    } );
   */
		"bSortMulti": true,

		/**
   * Allows control over whether DataTables should use the top (true) unique
   * cell that is found for a single column, or the bottom (false - default).
   * This is useful when using complex headers.
   *  @type boolean
   *  @default false
   *
   *  @dtopt Options
   *  @name DataTable.defaults.orderCellsTop
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "orderCellsTop": true
   *      } );
   *    } );
   */
		"bSortCellsTop": false,

		/**
   * Enable or disable the addition of the classes `sorting\_1`, `sorting\_2` and
   * `sorting\_3` to the columns which are currently being sorted on. This is
   * presented as a feature switch as it can increase processing time (while
   * classes are removed and added) so for large data sets you might want to
   * turn this off.
   *  @type boolean
   *  @default true
   *
   *  @dtopt Features
   *  @name DataTable.defaults.orderClasses
   *
   *  @example
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "orderClasses": false
   *      } );
   *    } );
   */
		"bSortClasses": true,

		/**
   * Enable or disable state saving. When enabled HTML5 `localStorage` will be
   * used to save table display information such as pagination information,
   * display length, filtering and sorting. As such when the end user reloads
   * the page the display display will match what thy had previously set up.
   *
   * Due to the use of `localStorage` the default state saving is not supported
   * in IE6 or 7. If state saving is required in those browsers, use
   * `stateSaveCallback` to provide a storage solution such as cookies.
   *  @type boolean
   *  @default false
   *
   *  @dtopt Features
   *  @name DataTable.defaults.stateSave
   *
   *  @example
   *    $(document).ready( function () {
   *      $('#example').dataTable( {
   *        "stateSave": true
   *      } );
   *    } );
   */
		"bStateSave": false,

		/**
   * This function is called when a TR element is created (and all TD child
   * elements have been inserted), or registered if using a DOM source, allowing
   * manipulation of the TR element (adding classes etc).
   *  @type function
   *  @param {node} row "TR" element for the current row
   *  @param {array} data Raw data array for this row
   *  @param {int} dataIndex The index of this row in the internal aoData array
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.createdRow
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "createdRow": function( row, data, dataIndex ) {
   *          // Bold the grade for all 'A' grade browsers
   *          if ( data[4] == "A" )
   *          {
   *            $('td:eq(4)', row).html( '<b>A</b>' );
   *          }
   *        }
   *      } );
   *    } );
   */
		"fnCreatedRow": null,

		/**
   * This function is called on every 'draw' event, and allows you to
   * dynamically modify any aspect you want about the created DOM.
   *  @type function
   *  @param {object} settings DataTables settings object
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.drawCallback
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "drawCallback": function( settings ) {
   *          alert( 'DataTables has redrawn the table' );
   *        }
   *      } );
   *    } );
   */
		"fnDrawCallback": null,

		/**
   * Identical to fnHeaderCallback() but for the table footer this function
   * allows you to modify the table footer on every 'draw' event.
   *  @type function
   *  @param {node} foot "TR" element for the footer
   *  @param {array} data Full table data (as derived from the original HTML)
   *  @param {int} start Index for the current display starting point in the
   *    display array
   *  @param {int} end Index for the current display ending point in the
   *    display array
   *  @param {array int} display Index array to translate the visual position
   *    to the full data array
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.footerCallback
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "footerCallback": function( tfoot, data, start, end, display ) {
   *          tfoot.getElementsByTagName('th')[0].innerHTML = "Starting index is "+start;
   *        }
   *      } );
   *    } )
   */
		"fnFooterCallback": null,

		/**
   * When rendering large numbers in the information element for the table
   * (i.e. "Showing 1 to 10 of 57 entries") DataTables will render large numbers
   * to have a comma separator for the 'thousands' units (e.g. 1 million is
   * rendered as "1,000,000") to help readability for the end user. This
   * function will override the default method DataTables uses.
   *  @type function
   *  @member
   *  @param {int} toFormat number to be formatted
   *  @returns {string} formatted string for DataTables to show the number
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.formatNumber
   *
   *  @example
   *    // Format a number using a single quote for the separator (note that
   *    // this can also be done with the language.thousands option)
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "formatNumber": function ( toFormat ) {
   *          return toFormat.toString().replace(
   *            /\B(?=(\d{3})+(?!\d))/g, "'"
   *          );
   *        };
   *      } );
   *    } );
   */
		"fnFormatNumber": function fnFormatNumber(toFormat) {
			return toFormat.toString().replace(/\B(?=(\d{3})+(?!\d))/g, this.oLanguage.sThousands);
		},

		/**
   * This function is called on every 'draw' event, and allows you to
   * dynamically modify the header row. This can be used to calculate and
   * display useful information about the table.
   *  @type function
   *  @param {node} head "TR" element for the header
   *  @param {array} data Full table data (as derived from the original HTML)
   *  @param {int} start Index for the current display starting point in the
   *    display array
   *  @param {int} end Index for the current display ending point in the
   *    display array
   *  @param {array int} display Index array to translate the visual position
   *    to the full data array
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.headerCallback
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "fheaderCallback": function( head, data, start, end, display ) {
   *          head.getElementsByTagName('th')[0].innerHTML = "Displaying "+(end-start)+" records";
   *        }
   *      } );
   *    } )
   */
		"fnHeaderCallback": null,

		/**
   * The information element can be used to convey information about the current
   * state of the table. Although the internationalisation options presented by
   * DataTables are quite capable of dealing with most customisations, there may
   * be times where you wish to customise the string further. This callback
   * allows you to do exactly that.
   *  @type function
   *  @param {object} oSettings DataTables settings object
   *  @param {int} start Starting position in data for the draw
   *  @param {int} end End position in data for the draw
   *  @param {int} max Total number of rows in the table (regardless of
   *    filtering)
   *  @param {int} total Total number of rows in the data set, after filtering
   *  @param {string} pre The string that DataTables has formatted using it's
   *    own rules
   *  @returns {string} The string to be displayed in the information element.
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.infoCallback
   *
   *  @example
   *    $('#example').dataTable( {
   *      "infoCallback": function( settings, start, end, max, total, pre ) {
   *        return start +" to "+ end;
   *      }
   *    } );
   */
		"fnInfoCallback": null,

		/**
   * Called when the table has been initialised. Normally DataTables will
   * initialise sequentially and there will be no need for this function,
   * however, this does not hold true when using external language information
   * since that is obtained using an async XHR call.
   *  @type function
   *  @param {object} settings DataTables settings object
   *  @param {object} json The JSON object request from the server - only
   *    present if client-side Ajax sourced data is used
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.initComplete
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "initComplete": function(settings, json) {
   *          alert( 'DataTables has finished its initialisation.' );
   *        }
   *      } );
   *    } )
   */
		"fnInitComplete": null,

		/**
   * Called at the very start of each table draw and can be used to cancel the
   * draw by returning false, any other return (including undefined) results in
   * the full draw occurring).
   *  @type function
   *  @param {object} settings DataTables settings object
   *  @returns {boolean} False will cancel the draw, anything else (including no
   *    return) will allow it to complete.
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.preDrawCallback
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "preDrawCallback": function( settings ) {
   *          if ( $('#test').val() == 1 ) {
   *            return false;
   *          }
   *        }
   *      } );
   *    } );
   */
		"fnPreDrawCallback": null,

		/**
   * This function allows you to 'post process' each row after it have been
   * generated for each table draw, but before it is rendered on screen. This
   * function might be used for setting the row class name etc.
   *  @type function
   *  @param {node} row "TR" element for the current row
   *  @param {array} data Raw data array for this row
   *  @param {int} displayIndex The display index for the current table draw
   *  @param {int} displayIndexFull The index of the data in the full list of
   *    rows (after filtering)
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.rowCallback
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "rowCallback": function( row, data, displayIndex, displayIndexFull ) {
   *          // Bold the grade for all 'A' grade browsers
   *          if ( data[4] == "A" ) {
   *            $('td:eq(4)', row).html( '<b>A</b>' );
   *          }
   *        }
   *      } );
   *    } );
   */
		"fnRowCallback": null,

		/**
   * __Deprecated__ The functionality provided by this parameter has now been
   * superseded by that provided through `ajax`, which should be used instead.
   *
   * This parameter allows you to override the default function which obtains
   * the data from the server so something more suitable for your application.
   * For example you could use POST data, or pull information from a Gears or
   * AIR database.
   *  @type function
   *  @member
   *  @param {string} source HTTP source to obtain the data from (`ajax`)
   *  @param {array} data A key/value pair object containing the data to send
   *    to the server
   *  @param {function} callback to be called on completion of the data get
   *    process that will draw the data on the page.
   *  @param {object} settings DataTables settings object
   *
   *  @dtopt Callbacks
   *  @dtopt Server-side
   *  @name DataTable.defaults.serverData
   *
   *  @deprecated 1.10. Please use `ajax` for this functionality now.
   */
		"fnServerData": null,

		/**
   * __Deprecated__ The functionality provided by this parameter has now been
   * superseded by that provided through `ajax`, which should be used instead.
   *
   *  It is often useful to send extra data to the server when making an Ajax
   * request - for example custom filtering information, and this callback
   * function makes it trivial to send extra information to the server. The
   * passed in parameter is the data set that has been constructed by
   * DataTables, and you can add to this or modify it as you require.
   *  @type function
   *  @param {array} data Data array (array of objects which are name/value
   *    pairs) that has been constructed by DataTables and will be sent to the
   *    server. In the case of Ajax sourced data with server-side processing
   *    this will be an empty array, for server-side processing there will be a
   *    significant number of parameters!
   *  @returns {undefined} Ensure that you modify the data array passed in,
   *    as this is passed by reference.
   *
   *  @dtopt Callbacks
   *  @dtopt Server-side
   *  @name DataTable.defaults.serverParams
   *
   *  @deprecated 1.10. Please use `ajax` for this functionality now.
   */
		"fnServerParams": null,

		/**
   * Load the table state. With this function you can define from where, and how, the
   * state of a table is loaded. By default DataTables will load from `localStorage`
   * but you might wish to use a server-side database or cookies.
   *  @type function
   *  @member
   *  @param {object} settings DataTables settings object
   *  @param {object} callback Callback that can be executed when done. It
   *    should be passed the loaded state object.
   *  @return {object} The DataTables state object to be loaded
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.stateLoadCallback
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "stateSave": true,
   *        "stateLoadCallback": function (settings, callback) {
   *          $.ajax( {
   *            "url": "/state_load",
   *            "dataType": "json",
   *            "success": function (json) {
   *              callback( json );
   *            }
   *          } );
   *        }
   *      } );
   *    } );
   */
		"fnStateLoadCallback": function fnStateLoadCallback(settings) {
			try {
				return JSON.parse((settings.iStateDuration === -1 ? sessionStorage : localStorage).getItem('DataTables_' + settings.sInstance + '_' + location.pathname));
			} catch (e) {}
		},

		/**
   * Callback which allows modification of the saved state prior to loading that state.
   * This callback is called when the table is loading state from the stored data, but
   * prior to the settings object being modified by the saved state. Note that for
   * plug-in authors, you should use the `stateLoadParams` event to load parameters for
   * a plug-in.
   *  @type function
   *  @param {object} settings DataTables settings object
   *  @param {object} data The state object that is to be loaded
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.stateLoadParams
   *
   *  @example
   *    // Remove a saved filter, so filtering is never loaded
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "stateSave": true,
   *        "stateLoadParams": function (settings, data) {
   *          data.oSearch.sSearch = "";
   *        }
   *      } );
   *    } );
   *
   *  @example
   *    // Disallow state loading by returning false
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "stateSave": true,
   *        "stateLoadParams": function (settings, data) {
   *          return false;
   *        }
   *      } );
   *    } );
   */
		"fnStateLoadParams": null,

		/**
   * Callback that is called when the state has been loaded from the state saving method
   * and the DataTables settings object has been modified as a result of the loaded state.
   *  @type function
   *  @param {object} settings DataTables settings object
   *  @param {object} data The state object that was loaded
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.stateLoaded
   *
   *  @example
   *    // Show an alert with the filtering value that was saved
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "stateSave": true,
   *        "stateLoaded": function (settings, data) {
   *          alert( 'Saved filter was: '+data.oSearch.sSearch );
   *        }
   *      } );
   *    } );
   */
		"fnStateLoaded": null,

		/**
   * Save the table state. This function allows you to define where and how the state
   * information for the table is stored By default DataTables will use `localStorage`
   * but you might wish to use a server-side database or cookies.
   *  @type function
   *  @member
   *  @param {object} settings DataTables settings object
   *  @param {object} data The state object to be saved
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.stateSaveCallback
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "stateSave": true,
   *        "stateSaveCallback": function (settings, data) {
   *          // Send an Ajax request to the server with the state object
   *          $.ajax( {
   *            "url": "/state_save",
   *            "data": data,
   *            "dataType": "json",
   *            "method": "POST"
   *            "success": function () {}
   *          } );
   *        }
   *      } );
   *    } );
   */
		"fnStateSaveCallback": function fnStateSaveCallback(settings, data) {
			try {
				(settings.iStateDuration === -1 ? sessionStorage : localStorage).setItem('DataTables_' + settings.sInstance + '_' + location.pathname, JSON.stringify(data));
			} catch (e) {}
		},

		/**
   * Callback which allows modification of the state to be saved. Called when the table
   * has changed state a new state save is required. This method allows modification of
   * the state saving object prior to actually doing the save, including addition or
   * other state properties or modification. Note that for plug-in authors, you should
   * use the `stateSaveParams` event to save parameters for a plug-in.
   *  @type function
   *  @param {object} settings DataTables settings object
   *  @param {object} data The state object to be saved
   *
   *  @dtopt Callbacks
   *  @name DataTable.defaults.stateSaveParams
   *
   *  @example
   *    // Remove a saved filter, so filtering is never saved
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "stateSave": true,
   *        "stateSaveParams": function (settings, data) {
   *          data.oSearch.sSearch = "";
   *        }
   *      } );
   *    } );
   */
		"fnStateSaveParams": null,

		/**
   * Duration for which the saved state information is considered valid. After this period
   * has elapsed the state will be returned to the default.
   * Value is given in seconds.
   *  @type int
   *  @default 7200 <i>(2 hours)</i>
   *
   *  @dtopt Options
   *  @name DataTable.defaults.stateDuration
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "stateDuration": 60*60*24; // 1 day
   *      } );
   *    } )
   */
		"iStateDuration": 7200,

		/**
   * When enabled DataTables will not make a request to the server for the first
   * page draw - rather it will use the data already on the page (no sorting etc
   * will be applied to it), thus saving on an XHR at load time. `deferLoading`
   * is used to indicate that deferred loading is required, but it is also used
   * to tell DataTables how many records there are in the full table (allowing
   * the information element and pagination to be displayed correctly). In the case
   * where a filtering is applied to the table on initial load, this can be
   * indicated by giving the parameter as an array, where the first element is
   * the number of records available after filtering and the second element is the
   * number of records without filtering (allowing the table information element
   * to be shown correctly).
   *  @type int | array
   *  @default null
   *
   *  @dtopt Options
   *  @name DataTable.defaults.deferLoading
   *
   *  @example
   *    // 57 records available in the table, no filtering applied
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "serverSide": true,
   *        "ajax": "scripts/server_processing.php",
   *        "deferLoading": 57
   *      } );
   *    } );
   *
   *  @example
   *    // 57 records after filtering, 100 without filtering (an initial filter applied)
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "serverSide": true,
   *        "ajax": "scripts/server_processing.php",
   *        "deferLoading": [ 57, 100 ],
   *        "search": {
   *          "search": "my_filter"
   *        }
   *      } );
   *    } );
   */
		"iDeferLoading": null,

		/**
   * Number of rows to display on a single page when using pagination. If
   * feature enabled (`lengthChange`) then the end user will be able to override
   * this to a custom setting using a pop-up menu.
   *  @type int
   *  @default 10
   *
   *  @dtopt Options
   *  @name DataTable.defaults.pageLength
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "pageLength": 50
   *      } );
   *    } )
   */
		"iDisplayLength": 10,

		/**
   * Define the starting point for data display when using DataTables with
   * pagination. Note that this parameter is the number of records, rather than
   * the page number, so if you have 10 records per page and want to start on
   * the third page, it should be "20".
   *  @type int
   *  @default 0
   *
   *  @dtopt Options
   *  @name DataTable.defaults.displayStart
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "displayStart": 20
   *      } );
   *    } )
   */
		"iDisplayStart": 0,

		/**
   * By default DataTables allows keyboard navigation of the table (sorting, paging,
   * and filtering) by adding a `tabindex` attribute to the required elements. This
   * allows you to tab through the controls and press the enter key to activate them.
   * The tabindex is default 0, meaning that the tab follows the flow of the document.
   * You can overrule this using this parameter if you wish. Use a value of -1 to
   * disable built-in keyboard navigation.
   *  @type int
   *  @default 0
   *
   *  @dtopt Options
   *  @name DataTable.defaults.tabIndex
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "tabIndex": 1
   *      } );
   *    } );
   */
		"iTabIndex": 0,

		/**
   * Classes that DataTables assigns to the various components and features
   * that it adds to the HTML table. This allows classes to be configured
   * during initialisation in addition to through the static
   * {@link DataTable.ext.oStdClasses} object).
   *  @namespace
   *  @name DataTable.defaults.classes
   */
		"oClasses": {},

		/**
   * All strings that DataTables uses in the user interface that it creates
   * are defined in this object, allowing you to modified them individually or
   * completely replace them all as required.
   *  @namespace
   *  @name DataTable.defaults.language
   */
		"oLanguage": {
			/**
    * Strings that are used for WAI-ARIA labels and controls only (these are not
    * actually visible on the page, but will be read by screenreaders, and thus
    * must be internationalised as well).
    *  @namespace
    *  @name DataTable.defaults.language.aria
    */
			"oAria": {
				/**
     * ARIA label that is added to the table headers when the column may be
     * sorted ascending by activing the column (click or return when focused).
     * Note that the column header is prefixed to this string.
     *  @type string
     *  @default : activate to sort column ascending
     *
     *  @dtopt Language
     *  @name DataTable.defaults.language.aria.sortAscending
     *
     *  @example
     *    $(document).ready( function() {
     *      $('#example').dataTable( {
     *        "language": {
     *          "aria": {
     *            "sortAscending": " - click/return to sort ascending"
     *          }
     *        }
     *      } );
     *    } );
     */
				"sSortAscending": ": activate to sort column ascending",

				/**
     * ARIA label that is added to the table headers when the column may be
     * sorted descending by activing the column (click or return when focused).
     * Note that the column header is prefixed to this string.
     *  @type string
     *  @default : activate to sort column ascending
     *
     *  @dtopt Language
     *  @name DataTable.defaults.language.aria.sortDescending
     *
     *  @example
     *    $(document).ready( function() {
     *      $('#example').dataTable( {
     *        "language": {
     *          "aria": {
     *            "sortDescending": " - click/return to sort descending"
     *          }
     *        }
     *      } );
     *    } );
     */
				"sSortDescending": ": activate to sort column descending"
			},

			/**
    * Pagination string used by DataTables for the built-in pagination
    * control types.
    *  @namespace
    *  @name DataTable.defaults.language.paginate
    */
			"oPaginate": {
				/**
     * Text to use when using the 'full_numbers' type of pagination for the
     * button to take the user to the first page.
     *  @type string
     *  @default First
     *
     *  @dtopt Language
     *  @name DataTable.defaults.language.paginate.first
     *
     *  @example
     *    $(document).ready( function() {
     *      $('#example').dataTable( {
     *        "language": {
     *          "paginate": {
     *            "first": "First page"
     *          }
     *        }
     *      } );
     *    } );
     */
				"sFirst": "First",

				/**
     * Text to use when using the 'full_numbers' type of pagination for the
     * button to take the user to the last page.
     *  @type string
     *  @default Last
     *
     *  @dtopt Language
     *  @name DataTable.defaults.language.paginate.last
     *
     *  @example
     *    $(document).ready( function() {
     *      $('#example').dataTable( {
     *        "language": {
     *          "paginate": {
     *            "last": "Last page"
     *          }
     *        }
     *      } );
     *    } );
     */
				"sLast": "Last",

				/**
     * Text to use for the 'next' pagination button (to take the user to the
     * next page).
     *  @type string
     *  @default Next
     *
     *  @dtopt Language
     *  @name DataTable.defaults.language.paginate.next
     *
     *  @example
     *    $(document).ready( function() {
     *      $('#example').dataTable( {
     *        "language": {
     *          "paginate": {
     *            "next": "Next page"
     *          }
     *        }
     *      } );
     *    } );
     */
				"sNext": "Next",

				/**
     * Text to use for the 'previous' pagination button (to take the user to
     * the previous page).
     *  @type string
     *  @default Previous
     *
     *  @dtopt Language
     *  @name DataTable.defaults.language.paginate.previous
     *
     *  @example
     *    $(document).ready( function() {
     *      $('#example').dataTable( {
     *        "language": {
     *          "paginate": {
     *            "previous": "Previous page"
     *          }
     *        }
     *      } );
     *    } );
     */
				"sPrevious": "Previous"
			},

			/**
    * This string is shown in preference to `zeroRecords` when the table is
    * empty of data (regardless of filtering). Note that this is an optional
    * parameter - if it is not given, the value of `zeroRecords` will be used
    * instead (either the default or given value).
    *  @type string
    *  @default No data available in table
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.emptyTable
    *
    *  @example
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "emptyTable": "No data available in table"
    *        }
    *      } );
    *    } );
    */
			"sEmptyTable": "No data available in table",

			/**
    * This string gives information to the end user about the information
    * that is current on display on the page. The following tokens can be
    * used in the string and will be dynamically replaced as the table
    * display updates. This tokens can be placed anywhere in the string, or
    * removed as needed by the language requires:
    *
    * * `\_START\_` - Display index of the first record on the current page
    * * `\_END\_` - Display index of the last record on the current page
    * * `\_TOTAL\_` - Number of records in the table after filtering
    * * `\_MAX\_` - Number of records in the table without filtering
    * * `\_PAGE\_` - Current page number
    * * `\_PAGES\_` - Total number of pages of data in the table
    *
    *  @type string
    *  @default Showing _START_ to _END_ of _TOTAL_ entries
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.info
    *
    *  @example
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "info": "Showing page _PAGE_ of _PAGES_"
    *        }
    *      } );
    *    } );
    */
			"sInfo": "Showing _START_ to _END_ of _TOTAL_ entries",

			/**
    * Display information string for when the table is empty. Typically the
    * format of this string should match `info`.
    *  @type string
    *  @default Showing 0 to 0 of 0 entries
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.infoEmpty
    *
    *  @example
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "infoEmpty": "No entries to show"
    *        }
    *      } );
    *    } );
    */
			"sInfoEmpty": "Showing 0 to 0 of 0 entries",

			/**
    * When a user filters the information in a table, this string is appended
    * to the information (`info`) to give an idea of how strong the filtering
    * is. The variable _MAX_ is dynamically updated.
    *  @type string
    *  @default (filtered from _MAX_ total entries)
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.infoFiltered
    *
    *  @example
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "infoFiltered": " - filtering from _MAX_ records"
    *        }
    *      } );
    *    } );
    */
			"sInfoFiltered": "(filtered from _MAX_ total entries)",

			/**
    * If can be useful to append extra information to the info string at times,
    * and this variable does exactly that. This information will be appended to
    * the `info` (`infoEmpty` and `infoFiltered` in whatever combination they are
    * being used) at all times.
    *  @type string
    *  @default <i>Empty string</i>
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.infoPostFix
    *
    *  @example
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "infoPostFix": "All records shown are derived from real information."
    *        }
    *      } );
    *    } );
    */
			"sInfoPostFix": "",

			/**
    * This decimal place operator is a little different from the other
    * language options since DataTables doesn't output floating point
    * numbers, so it won't ever use this for display of a number. Rather,
    * what this parameter does is modify the sort methods of the table so
    * that numbers which are in a format which has a character other than
    * a period (`.`) as a decimal place will be sorted numerically.
    *
    * Note that numbers with different decimal places cannot be shown in
    * the same table and still be sortable, the table must be consistent.
    * However, multiple different tables on the page can use different
    * decimal place characters.
    *  @type string
    *  @default 
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.decimal
    *
    *  @example
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "decimal": ","
    *          "thousands": "."
    *        }
    *      } );
    *    } );
    */
			"sDecimal": "",

			/**
    * DataTables has a build in number formatter (`formatNumber`) which is
    * used to format large numbers that are used in the table information.
    * By default a comma is used, but this can be trivially changed to any
    * character you wish with this parameter.
    *  @type string
    *  @default ,
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.thousands
    *
    *  @example
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "thousands": "'"
    *        }
    *      } );
    *    } );
    */
			"sThousands": ",",

			/**
    * Detail the action that will be taken when the drop down menu for the
    * pagination length option is changed. The '_MENU_' variable is replaced
    * with a default select list of 10, 25, 50 and 100, and can be replaced
    * with a custom select box if required.
    *  @type string
    *  @default Show _MENU_ entries
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.lengthMenu
    *
    *  @example
    *    // Language change only
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "lengthMenu": "Display _MENU_ records"
    *        }
    *      } );
    *    } );
    *
    *  @example
    *    // Language and options change
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "lengthMenu": 'Display <select>'+
    *            '<option value="10">10</option>'+
    *            '<option value="20">20</option>'+
    *            '<option value="30">30</option>'+
    *            '<option value="40">40</option>'+
    *            '<option value="50">50</option>'+
    *            '<option value="-1">All</option>'+
    *            '</select> records'
    *        }
    *      } );
    *    } );
    */
			"sLengthMenu": "Show _MENU_ entries",

			/**
    * When using Ajax sourced data and during the first draw when DataTables is
    * gathering the data, this message is shown in an empty row in the table to
    * indicate to the end user the the data is being loaded. Note that this
    * parameter is not used when loading data by server-side processing, just
    * Ajax sourced data with client-side processing.
    *  @type string
    *  @default Loading...
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.loadingRecords
    *
    *  @example
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "loadingRecords": "Please wait - loading..."
    *        }
    *      } );
    *    } );
    */
			"sLoadingRecords": "Loading...",

			/**
    * Text which is displayed when the table is processing a user action
    * (usually a sort command or similar).
    *  @type string
    *  @default Processing...
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.processing
    *
    *  @example
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "processing": "DataTables is currently busy"
    *        }
    *      } );
    *    } );
    */
			"sProcessing": "Processing...",

			/**
    * Details the actions that will be taken when the user types into the
    * filtering input text box. The variable "_INPUT_", if used in the string,
    * is replaced with the HTML text box for the filtering input allowing
    * control over where it appears in the string. If "_INPUT_" is not given
    * then the input box is appended to the string automatically.
    *  @type string
    *  @default Search:
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.search
    *
    *  @example
    *    // Input text box will be appended at the end automatically
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "search": "Filter records:"
    *        }
    *      } );
    *    } );
    *
    *  @example
    *    // Specify where the filter should appear
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "search": "Apply filter _INPUT_ to table"
    *        }
    *      } );
    *    } );
    */
			"sSearch": "Search:",

			/**
    * Assign a `placeholder` attribute to the search `input` element
    *  @type string
    *  @default 
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.searchPlaceholder
    */
			"sSearchPlaceholder": "",

			/**
    * All of the language information can be stored in a file on the
    * server-side, which DataTables will look up if this parameter is passed.
    * It must store the URL of the language file, which is in a JSON format,
    * and the object has the same properties as the oLanguage object in the
    * initialiser object (i.e. the above parameters). Please refer to one of
    * the example language files to see how this works in action.
    *  @type string
    *  @default <i>Empty string - i.e. disabled</i>
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.url
    *
    *  @example
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "url": "http://www.sprymedia.co.uk/dataTables/lang.txt"
    *        }
    *      } );
    *    } );
    */
			"sUrl": "",

			/**
    * Text shown inside the table records when the is no information to be
    * displayed after filtering. `emptyTable` is shown when there is simply no
    * information in the table at all (regardless of filtering).
    *  @type string
    *  @default No matching records found
    *
    *  @dtopt Language
    *  @name DataTable.defaults.language.zeroRecords
    *
    *  @example
    *    $(document).ready( function() {
    *      $('#example').dataTable( {
    *        "language": {
    *          "zeroRecords": "No records to display"
    *        }
    *      } );
    *    } );
    */
			"sZeroRecords": "No matching records found"
		},

		/**
   * This parameter allows you to have define the global filtering state at
   * initialisation time. As an object the `search` parameter must be
   * defined, but all other parameters are optional. When `regex` is true,
   * the search string will be treated as a regular expression, when false
   * (default) it will be treated as a straight string. When `smart`
   * DataTables will use it's smart filtering methods (to word match at
   * any point in the data), when false this will not be done.
   *  @namespace
   *  @extends DataTable.models.oSearch
   *
   *  @dtopt Options
   *  @name DataTable.defaults.search
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "search": {"search": "Initial search"}
   *      } );
   *    } )
   */
		"oSearch": $.extend({}, DataTable.models.oSearch),

		/**
   * __Deprecated__ The functionality provided by this parameter has now been
   * superseded by that provided through `ajax`, which should be used instead.
   *
   * By default DataTables will look for the property `data` (or `aaData` for
   * compatibility with DataTables 1.9-) when obtaining data from an Ajax
   * source or for server-side processing - this parameter allows that
   * property to be changed. You can use Javascript dotted object notation to
   * get a data source for multiple levels of nesting.
   *  @type string
   *  @default data
   *
   *  @dtopt Options
   *  @dtopt Server-side
   *  @name DataTable.defaults.ajaxDataProp
   *
   *  @deprecated 1.10. Please use `ajax` for this functionality now.
   */
		"sAjaxDataProp": "data",

		/**
   * __Deprecated__ The functionality provided by this parameter has now been
   * superseded by that provided through `ajax`, which should be used instead.
   *
   * You can instruct DataTables to load data from an external
   * source using this parameter (use aData if you want to pass data in you
   * already have). Simply provide a url a JSON object can be obtained from.
   *  @type string
   *  @default null
   *
   *  @dtopt Options
   *  @dtopt Server-side
   *  @name DataTable.defaults.ajaxSource
   *
   *  @deprecated 1.10. Please use `ajax` for this functionality now.
   */
		"sAjaxSource": null,

		/**
   * This initialisation variable allows you to specify exactly where in the
   * DOM you want DataTables to inject the various controls it adds to the page
   * (for example you might want the pagination controls at the top of the
   * table). DIV elements (with or without a custom class) can also be added to
   * aid styling. The follow syntax is used:
   *   <ul>
   *     <li>The following options are allowed:
   *       <ul>
   *         <li>'l' - Length changing</li>
   *         <li>'f' - Filtering input</li>
   *         <li>'t' - The table!</li>
   *         <li>'i' - Information</li>
   *         <li>'p' - Pagination</li>
   *         <li>'r' - pRocessing</li>
   *       </ul>
   *     </li>
   *     <li>The following constants are allowed:
   *       <ul>
   *         <li>'H' - jQueryUI theme "header" classes ('fg-toolbar ui-widget-header ui-corner-tl ui-corner-tr ui-helper-clearfix')</li>
   *         <li>'F' - jQueryUI theme "footer" classes ('fg-toolbar ui-widget-header ui-corner-bl ui-corner-br ui-helper-clearfix')</li>
   *       </ul>
   *     </li>
   *     <li>The following syntax is expected:
   *       <ul>
   *         <li>'&lt;' and '&gt;' - div elements</li>
   *         <li>'&lt;"class" and '&gt;' - div with a class</li>
   *         <li>'&lt;"#id" and '&gt;' - div with an ID</li>
   *       </ul>
   *     </li>
   *     <li>Examples:
   *       <ul>
   *         <li>'&lt;"wrapper"flipt&gt;'</li>
   *         <li>'&lt;lf&lt;t&gt;ip&gt;'</li>
   *       </ul>
   *     </li>
   *   </ul>
   *  @type string
   *  @default lfrtip <i>(when `jQueryUI` is false)</i> <b>or</b>
   *    <"H"lfr>t<"F"ip> <i>(when `jQueryUI` is true)</i>
   *
   *  @dtopt Options
   *  @name DataTable.defaults.dom
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "dom": '&lt;"top"i&gt;rt&lt;"bottom"flp&gt;&lt;"clear"&gt;'
   *      } );
   *    } );
   */
		"sDom": "lfrtip",

		/**
   * Search delay option. This will throttle full table searches that use the
   * DataTables provided search input element (it does not effect calls to
   * `dt-api search()`, providing a delay before the search is made.
   *  @type integer
   *  @default 0
   *
   *  @dtopt Options
   *  @name DataTable.defaults.searchDelay
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "searchDelay": 200
   *      } );
   *    } )
   */
		"searchDelay": null,

		/**
   * DataTables features six different built-in options for the buttons to
   * display for pagination control:
   *
   * * `numbers` - Page number buttons only
   * * `simple` - 'Previous' and 'Next' buttons only
   * * 'simple_numbers` - 'Previous' and 'Next' buttons, plus page numbers
   * * `full` - 'First', 'Previous', 'Next' and 'Last' buttons
   * * `full_numbers` - 'First', 'Previous', 'Next' and 'Last' buttons, plus page numbers
   * * `first_last_numbers` - 'First' and 'Last' buttons, plus page numbers
   *  
   * Further methods can be added using {@link DataTable.ext.oPagination}.
   *  @type string
   *  @default simple_numbers
   *
   *  @dtopt Options
   *  @name DataTable.defaults.pagingType
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "pagingType": "full_numbers"
   *      } );
   *    } )
   */
		"sPaginationType": "simple_numbers",

		/**
   * Enable horizontal scrolling. When a table is too wide to fit into a
   * certain layout, or you have a large number of columns in the table, you
   * can enable x-scrolling to show the table in a viewport, which can be
   * scrolled. This property can be `true` which will allow the table to
   * scroll horizontally when needed, or any CSS unit, or a number (in which
   * case it will be treated as a pixel measurement). Setting as simply `true`
   * is recommended.
   *  @type boolean|string
   *  @default <i>blank string - i.e. disabled</i>
   *
   *  @dtopt Features
   *  @name DataTable.defaults.scrollX
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "scrollX": true,
   *        "scrollCollapse": true
   *      } );
   *    } );
   */
		"sScrollX": "",

		/**
   * This property can be used to force a DataTable to use more width than it
   * might otherwise do when x-scrolling is enabled. For example if you have a
   * table which requires to be well spaced, this parameter is useful for
   * "over-sizing" the table, and thus forcing scrolling. This property can by
   * any CSS unit, or a number (in which case it will be treated as a pixel
   * measurement).
   *  @type string
   *  @default <i>blank string - i.e. disabled</i>
   *
   *  @dtopt Options
   *  @name DataTable.defaults.scrollXInner
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "scrollX": "100%",
   *        "scrollXInner": "110%"
   *      } );
   *    } );
   */
		"sScrollXInner": "",

		/**
   * Enable vertical scrolling. Vertical scrolling will constrain the DataTable
   * to the given height, and enable scrolling for any data which overflows the
   * current viewport. This can be used as an alternative to paging to display
   * a lot of data in a small area (although paging and scrolling can both be
   * enabled at the same time). This property can be any CSS unit, or a number
   * (in which case it will be treated as a pixel measurement).
   *  @type string
   *  @default <i>blank string - i.e. disabled</i>
   *
   *  @dtopt Features
   *  @name DataTable.defaults.scrollY
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "scrollY": "200px",
   *        "paginate": false
   *      } );
   *    } );
   */
		"sScrollY": "",

		/**
   * __Deprecated__ The functionality provided by this parameter has now been
   * superseded by that provided through `ajax`, which should be used instead.
   *
   * Set the HTTP method that is used to make the Ajax call for server-side
   * processing or Ajax sourced data.
   *  @type string
   *  @default GET
   *
   *  @dtopt Options
   *  @dtopt Server-side
   *  @name DataTable.defaults.serverMethod
   *
   *  @deprecated 1.10. Please use `ajax` for this functionality now.
   */
		"sServerMethod": "GET",

		/**
   * DataTables makes use of renderers when displaying HTML elements for
   * a table. These renderers can be added or modified by plug-ins to
   * generate suitable mark-up for a site. For example the Bootstrap
   * integration plug-in for DataTables uses a paging button renderer to
   * display pagination buttons in the mark-up required by Bootstrap.
   *
   * For further information about the renderers available see
   * DataTable.ext.renderer
   *  @type string|object
   *  @default null
   *
   *  @name DataTable.defaults.renderer
   *
   */
		"renderer": null,

		/**
   * Set the data property name that DataTables should use to get a row's id
   * to set as the `id` property in the node.
   *  @type string
   *  @default DT_RowId
   *
   *  @name DataTable.defaults.rowId
   */
		"rowId": "DT_RowId"
	};

	_fnHungarianMap(DataTable.defaults);

	/*
  * Developer note - See note in model.defaults.js about the use of Hungarian
  * notation and camel case.
  */

	/**
  * Column options that can be given to DataTables at initialisation time.
  *  @namespace
  */
	DataTable.defaults.column = {
		/**
   * Define which column(s) an order will occur on for this column. This
   * allows a column's ordering to take multiple columns into account when
   * doing a sort or use the data from a different column. For example first
   * name / last name columns make sense to do a multi-column sort over the
   * two columns.
   *  @type array|int
   *  @default null <i>Takes the value of the column index automatically</i>
   *
   *  @name DataTable.defaults.column.orderData
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columnDefs`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [
   *          { "orderData": [ 0, 1 ], "targets": [ 0 ] },
   *          { "orderData": [ 1, 0 ], "targets": [ 1 ] },
   *          { "orderData": 2, "targets": [ 2 ] }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          { "orderData": [ 0, 1 ] },
   *          { "orderData": [ 1, 0 ] },
   *          { "orderData": 2 },
   *          null,
   *          null
   *        ]
   *      } );
   *    } );
   */
		"aDataSort": null,
		"iDataSort": -1,

		/**
   * You can control the default ordering direction, and even alter the
   * behaviour of the sort handler (i.e. only allow ascending ordering etc)
   * using this parameter.
   *  @type array
   *  @default [ 'asc', 'desc' ]
   *
   *  @name DataTable.defaults.column.orderSequence
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columnDefs`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [
   *          { "orderSequence": [ "asc" ], "targets": [ 1 ] },
   *          { "orderSequence": [ "desc", "asc", "asc" ], "targets": [ 2 ] },
   *          { "orderSequence": [ "desc" ], "targets": [ 3 ] }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          null,
   *          { "orderSequence": [ "asc" ] },
   *          { "orderSequence": [ "desc", "asc", "asc" ] },
   *          { "orderSequence": [ "desc" ] },
   *          null
   *        ]
   *      } );
   *    } );
   */
		"asSorting": ['asc', 'desc'],

		/**
   * Enable or disable filtering on the data in this column.
   *  @type boolean
   *  @default true
   *
   *  @name DataTable.defaults.column.searchable
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columnDefs`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [
   *          { "searchable": false, "targets": [ 0 ] }
   *        ] } );
   *    } );
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          { "searchable": false },
   *          null,
   *          null,
   *          null,
   *          null
   *        ] } );
   *    } );
   */
		"bSearchable": true,

		/**
   * Enable or disable ordering on this column.
   *  @type boolean
   *  @default true
   *
   *  @name DataTable.defaults.column.orderable
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columnDefs`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [
   *          { "orderable": false, "targets": [ 0 ] }
   *        ] } );
   *    } );
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          { "orderable": false },
   *          null,
   *          null,
   *          null,
   *          null
   *        ] } );
   *    } );
   */
		"bSortable": true,

		/**
   * Enable or disable the display of this column.
   *  @type boolean
   *  @default true
   *
   *  @name DataTable.defaults.column.visible
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columnDefs`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [
   *          { "visible": false, "targets": [ 0 ] }
   *        ] } );
   *    } );
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          { "visible": false },
   *          null,
   *          null,
   *          null,
   *          null
   *        ] } );
   *    } );
   */
		"bVisible": true,

		/**
   * Developer definable function that is called whenever a cell is created (Ajax source,
   * etc) or processed for input (DOM source). This can be used as a compliment to mRender
   * allowing you to modify the DOM element (add background colour for example) when the
   * element is available.
   *  @type function
   *  @param {element} td The TD node that has been created
   *  @param {*} cellData The Data for the cell
   *  @param {array|object} rowData The data for the whole row
   *  @param {int} row The row index for the aoData data store
   *  @param {int} col The column index for aoColumns
   *
   *  @name DataTable.defaults.column.createdCell
   *  @dtopt Columns
   *
   *  @example
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [ {
   *          "targets": [3],
   *          "createdCell": function (td, cellData, rowData, row, col) {
   *            if ( cellData == "1.7" ) {
   *              $(td).css('color', 'blue')
   *            }
   *          }
   *        } ]
   *      });
   *    } );
   */
		"fnCreatedCell": null,

		/**
   * This parameter has been replaced by `data` in DataTables to ensure naming
   * consistency. `dataProp` can still be used, as there is backwards
   * compatibility in DataTables for this option, but it is strongly
   * recommended that you use `data` in preference to `dataProp`.
   *  @name DataTable.defaults.column.dataProp
   */

		/**
   * This property can be used to read data from any data source property,
   * including deeply nested objects / properties. `data` can be given in a
   * number of different ways which effect its behaviour:
   *
   * * `integer` - treated as an array index for the data source. This is the
   *   default that DataTables uses (incrementally increased for each column).
   * * `string` - read an object property from the data source. There are
   *   three 'special' options that can be used in the string to alter how
   *   DataTables reads the data from the source object:
   *    * `.` - Dotted Javascript notation. Just as you use a `.` in
   *      Javascript to read from nested objects, so to can the options
   *      specified in `data`. For example: `browser.version` or
   *      `browser.name`. If your object parameter name contains a period, use
   *      `\\` to escape it - i.e. `first\\.name`.
   *    * `[]` - Array notation. DataTables can automatically combine data
   *      from and array source, joining the data with the characters provided
   *      between the two brackets. For example: `name[, ]` would provide a
   *      comma-space separated list from the source array. If no characters
   *      are provided between the brackets, the original array source is
   *      returned.
   *    * `()` - Function notation. Adding `()` to the end of a parameter will
   *      execute a function of the name given. For example: `browser()` for a
   *      simple function on the data source, `browser.version()` for a
   *      function in a nested property or even `browser().version` to get an
   *      object property if the function called returns an object. Note that
   *      function notation is recommended for use in `render` rather than
   *      `data` as it is much simpler to use as a renderer.
   * * `null` - use the original data source for the row rather than plucking
   *   data directly from it. This action has effects on two other
   *   initialisation options:
   *    * `defaultContent` - When null is given as the `data` option and
   *      `defaultContent` is specified for the column, the value defined by
   *      `defaultContent` will be used for the cell.
   *    * `render` - When null is used for the `data` option and the `render`
   *      option is specified for the column, the whole data source for the
   *      row is used for the renderer.
   * * `function` - the function given will be executed whenever DataTables
   *   needs to set or get the data for a cell in the column. The function
   *   takes three parameters:
   *    * Parameters:
   *      * `{array|object}` The data source for the row
   *      * `{string}` The type call data requested - this will be 'set' when
   *        setting data or 'filter', 'display', 'type', 'sort' or undefined
   *        when gathering data. Note that when `undefined` is given for the
   *        type DataTables expects to get the raw data for the object back<
   *      * `{*}` Data to set when the second parameter is 'set'.
   *    * Return:
   *      * The return value from the function is not required when 'set' is
   *        the type of call, but otherwise the return is what will be used
   *        for the data requested.
   *
   * Note that `data` is a getter and setter option. If you just require
   * formatting of data for output, you will likely want to use `render` which
   * is simply a getter and thus simpler to use.
   *
   * Note that prior to DataTables 1.9.2 `data` was called `mDataProp`. The
   * name change reflects the flexibility of this property and is consistent
   * with the naming of mRender. If 'mDataProp' is given, then it will still
   * be used by DataTables, as it automatically maps the old name to the new
   * if required.
   *
   *  @type string|int|function|null
   *  @default null <i>Use automatically calculated column index</i>
   *
   *  @name DataTable.defaults.column.data
   *  @dtopt Columns
   *
   *  @example
   *    // Read table data from objects
   *    // JSON structure for each row:
   *    //   {
   *    //      "engine": {value},
   *    //      "browser": {value},
   *    //      "platform": {value},
   *    //      "version": {value},
   *    //      "grade": {value}
   *    //   }
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "ajaxSource": "sources/objects.txt",
   *        "columns": [
   *          { "data": "engine" },
   *          { "data": "browser" },
   *          { "data": "platform" },
   *          { "data": "version" },
   *          { "data": "grade" }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Read information from deeply nested objects
   *    // JSON structure for each row:
   *    //   {
   *    //      "engine": {value},
   *    //      "browser": {value},
   *    //      "platform": {
   *    //         "inner": {value}
   *    //      },
   *    //      "details": [
   *    //         {value}, {value}
   *    //      ]
   *    //   }
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "ajaxSource": "sources/deep.txt",
   *        "columns": [
   *          { "data": "engine" },
   *          { "data": "browser" },
   *          { "data": "platform.inner" },
   *          { "data": "platform.details.0" },
   *          { "data": "platform.details.1" }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using `data` as a function to provide different information for
   *    // sorting, filtering and display. In this case, currency (price)
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [ {
   *          "targets": [ 0 ],
   *          "data": function ( source, type, val ) {
   *            if (type === 'set') {
   *              source.price = val;
   *              // Store the computed dislay and filter values for efficiency
   *              source.price_display = val=="" ? "" : "$"+numberFormat(val);
   *              source.price_filter  = val=="" ? "" : "$"+numberFormat(val)+" "+val;
   *              return;
   *            }
   *            else if (type === 'display') {
   *              return source.price_display;
   *            }
   *            else if (type === 'filter') {
   *              return source.price_filter;
   *            }
   *            // 'sort', 'type' and undefined all just use the integer
   *            return source.price;
   *          }
   *        } ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using default content
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [ {
   *          "targets": [ 0 ],
   *          "data": null,
   *          "defaultContent": "Click to edit"
   *        } ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using array notation - outputting a list from an array
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [ {
   *          "targets": [ 0 ],
   *          "data": "name[, ]"
   *        } ]
   *      } );
   *    } );
   *
   */
		"mData": null,

		/**
   * This property is the rendering partner to `data` and it is suggested that
   * when you want to manipulate data for display (including filtering,
   * sorting etc) without altering the underlying data for the table, use this
   * property. `render` can be considered to be the the read only companion to
   * `data` which is read / write (then as such more complex). Like `data`
   * this option can be given in a number of different ways to effect its
   * behaviour:
   *
   * * `integer` - treated as an array index for the data source. This is the
   *   default that DataTables uses (incrementally increased for each column).
   * * `string` - read an object property from the data source. There are
   *   three 'special' options that can be used in the string to alter how
   *   DataTables reads the data from the source object:
   *    * `.` - Dotted Javascript notation. Just as you use a `.` in
   *      Javascript to read from nested objects, so to can the options
   *      specified in `data`. For example: `browser.version` or
   *      `browser.name`. If your object parameter name contains a period, use
   *      `\\` to escape it - i.e. `first\\.name`.
   *    * `[]` - Array notation. DataTables can automatically combine data
   *      from and array source, joining the data with the characters provided
   *      between the two brackets. For example: `name[, ]` would provide a
   *      comma-space separated list from the source array. If no characters
   *      are provided between the brackets, the original array source is
   *      returned.
   *    * `()` - Function notation. Adding `()` to the end of a parameter will
   *      execute a function of the name given. For example: `browser()` for a
   *      simple function on the data source, `browser.version()` for a
   *      function in a nested property or even `browser().version` to get an
   *      object property if the function called returns an object.
   * * `object` - use different data for the different data types requested by
   *   DataTables ('filter', 'display', 'type' or 'sort'). The property names
   *   of the object is the data type the property refers to and the value can
   *   defined using an integer, string or function using the same rules as
   *   `render` normally does. Note that an `_` option _must_ be specified.
   *   This is the default value to use if you haven't specified a value for
   *   the data type requested by DataTables.
   * * `function` - the function given will be executed whenever DataTables
   *   needs to set or get the data for a cell in the column. The function
   *   takes three parameters:
   *    * Parameters:
   *      * {array|object} The data source for the row (based on `data`)
   *      * {string} The type call data requested - this will be 'filter',
   *        'display', 'type' or 'sort'.
   *      * {array|object} The full data source for the row (not based on
   *        `data`)
   *    * Return:
   *      * The return value from the function is what will be used for the
   *        data requested.
   *
   *  @type string|int|function|object|null
   *  @default null Use the data source value.
   *
   *  @name DataTable.defaults.column.render
   *  @dtopt Columns
   *
   *  @example
   *    // Create a comma separated list from an array of objects
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "ajaxSource": "sources/deep.txt",
   *        "columns": [
   *          { "data": "engine" },
   *          { "data": "browser" },
   *          {
   *            "data": "platform",
   *            "render": "[, ].name"
   *          }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Execute a function to obtain data
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [ {
   *          "targets": [ 0 ],
   *          "data": null, // Use the full data source object for the renderer's source
   *          "render": "browserName()"
   *        } ]
   *      } );
   *    } );
   *
   *  @example
   *    // As an object, extracting different data for the different types
   *    // This would be used with a data source such as:
   *    //   { "phone": 5552368, "phone_filter": "5552368 555-2368", "phone_display": "555-2368" }
   *    // Here the `phone` integer is used for sorting and type detection, while `phone_filter`
   *    // (which has both forms) is used for filtering for if a user inputs either format, while
   *    // the formatted phone number is the one that is shown in the table.
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [ {
   *          "targets": [ 0 ],
   *          "data": null, // Use the full data source object for the renderer's source
   *          "render": {
   *            "_": "phone",
   *            "filter": "phone_filter",
   *            "display": "phone_display"
   *          }
   *        } ]
   *      } );
   *    } );
   *
   *  @example
   *    // Use as a function to create a link from the data source
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [ {
   *          "targets": [ 0 ],
   *          "data": "download_link",
   *          "render": function ( data, type, full ) {
   *            return '<a href="'+data+'">Download</a>';
   *          }
   *        } ]
   *      } );
   *    } );
   */
		"mRender": null,

		/**
   * Change the cell type created for the column - either TD cells or TH cells. This
   * can be useful as TH cells have semantic meaning in the table body, allowing them
   * to act as a header for a row (you may wish to add scope='row' to the TH elements).
   *  @type string
   *  @default td
   *
   *  @name DataTable.defaults.column.cellType
   *  @dtopt Columns
   *
   *  @example
   *    // Make the first column use TH cells
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [ {
   *          "targets": [ 0 ],
   *          "cellType": "th"
   *        } ]
   *      } );
   *    } );
   */
		"sCellType": "td",

		/**
   * Class to give to each cell in this column.
   *  @type string
   *  @default <i>Empty string</i>
   *
   *  @name DataTable.defaults.column.class
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columnDefs`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [
   *          { "class": "my_class", "targets": [ 0 ] }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          { "class": "my_class" },
   *          null,
   *          null,
   *          null,
   *          null
   *        ]
   *      } );
   *    } );
   */
		"sClass": "",

		/**
   * When DataTables calculates the column widths to assign to each column,
   * it finds the longest string in each column and then constructs a
   * temporary table and reads the widths from that. The problem with this
   * is that "mmm" is much wider then "iiii", but the latter is a longer
   * string - thus the calculation can go wrong (doing it properly and putting
   * it into an DOM object and measuring that is horribly(!) slow). Thus as
   * a "work around" we provide this option. It will append its value to the
   * text that is found to be the longest string for the column - i.e. padding.
   * Generally you shouldn't need this!
   *  @type string
   *  @default <i>Empty string<i>
   *
   *  @name DataTable.defaults.column.contentPadding
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          null,
   *          null,
   *          null,
   *          {
   *            "contentPadding": "mmm"
   *          }
   *        ]
   *      } );
   *    } );
   */
		"sContentPadding": "",

		/**
   * Allows a default value to be given for a column's data, and will be used
   * whenever a null data source is encountered (this can be because `data`
   * is set to null, or because the data source itself is null).
   *  @type string
   *  @default null
   *
   *  @name DataTable.defaults.column.defaultContent
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columnDefs`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [
   *          {
   *            "data": null,
   *            "defaultContent": "Edit",
   *            "targets": [ -1 ]
   *          }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          null,
   *          null,
   *          null,
   *          {
   *            "data": null,
   *            "defaultContent": "Edit"
   *          }
   *        ]
   *      } );
   *    } );
   */
		"sDefaultContent": null,

		/**
   * This parameter is only used in DataTables' server-side processing. It can
   * be exceptionally useful to know what columns are being displayed on the
   * client side, and to map these to database fields. When defined, the names
   * also allow DataTables to reorder information from the server if it comes
   * back in an unexpected order (i.e. if you switch your columns around on the
   * client-side, your server-side code does not also need updating).
   *  @type string
   *  @default <i>Empty string</i>
   *
   *  @name DataTable.defaults.column.name
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columnDefs`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [
   *          { "name": "engine", "targets": [ 0 ] },
   *          { "name": "browser", "targets": [ 1 ] },
   *          { "name": "platform", "targets": [ 2 ] },
   *          { "name": "version", "targets": [ 3 ] },
   *          { "name": "grade", "targets": [ 4 ] }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          { "name": "engine" },
   *          { "name": "browser" },
   *          { "name": "platform" },
   *          { "name": "version" },
   *          { "name": "grade" }
   *        ]
   *      } );
   *    } );
   */
		"sName": "",

		/**
   * Defines a data source type for the ordering which can be used to read
   * real-time information from the table (updating the internally cached
   * version) prior to ordering. This allows ordering to occur on user
   * editable elements such as form inputs.
   *  @type string
   *  @default std
   *
   *  @name DataTable.defaults.column.orderDataType
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columnDefs`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [
   *          { "orderDataType": "dom-text", "targets": [ 2, 3 ] },
   *          { "type": "numeric", "targets": [ 3 ] },
   *          { "orderDataType": "dom-select", "targets": [ 4 ] },
   *          { "orderDataType": "dom-checkbox", "targets": [ 5 ] }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          null,
   *          null,
   *          { "orderDataType": "dom-text" },
   *          { "orderDataType": "dom-text", "type": "numeric" },
   *          { "orderDataType": "dom-select" },
   *          { "orderDataType": "dom-checkbox" }
   *        ]
   *      } );
   *    } );
   */
		"sSortDataType": "std",

		/**
   * The title of this column.
   *  @type string
   *  @default null <i>Derived from the 'TH' value for this column in the
   *    original HTML table.</i>
   *
   *  @name DataTable.defaults.column.title
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columnDefs`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [
   *          { "title": "My column title", "targets": [ 0 ] }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          { "title": "My column title" },
   *          null,
   *          null,
   *          null,
   *          null
   *        ]
   *      } );
   *    } );
   */
		"sTitle": null,

		/**
   * The type allows you to specify how the data for this column will be
   * ordered. Four types (string, numeric, date and html (which will strip
   * HTML tags before ordering)) are currently available. Note that only date
   * formats understood by Javascript's Date() object will be accepted as type
   * date. For example: "Mar 26, 2008 5:03 PM". May take the values: 'string',
   * 'numeric', 'date' or 'html' (by default). Further types can be adding
   * through plug-ins.
   *  @type string
   *  @default null <i>Auto-detected from raw data</i>
   *
   *  @name DataTable.defaults.column.type
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columnDefs`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [
   *          { "type": "html", "targets": [ 0 ] }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          { "type": "html" },
   *          null,
   *          null,
   *          null,
   *          null
   *        ]
   *      } );
   *    } );
   */
		"sType": null,

		/**
   * Defining the width of the column, this parameter may take any CSS value
   * (3em, 20px etc). DataTables applies 'smart' widths to columns which have not
   * been given a specific width through this interface ensuring that the table
   * remains readable.
   *  @type string
   *  @default null <i>Automatic</i>
   *
   *  @name DataTable.defaults.column.width
   *  @dtopt Columns
   *
   *  @example
   *    // Using `columnDefs`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columnDefs": [
   *          { "width": "20%", "targets": [ 0 ] }
   *        ]
   *      } );
   *    } );
   *
   *  @example
   *    // Using `columns`
   *    $(document).ready( function() {
   *      $('#example').dataTable( {
   *        "columns": [
   *          { "width": "20%" },
   *          null,
   *          null,
   *          null,
   *          null
   *        ]
   *      } );
   *    } );
   */
		"sWidth": null
	};

	_fnHungarianMap(DataTable.defaults.column);

	/**
  * DataTables settings object - this holds all the information needed for a
  * given table, including configuration, data and current application of the
  * table options. DataTables does not have a single instance for each DataTable
  * with the settings attached to that instance, but rather instances of the
  * DataTable "class" are created on-the-fly as needed (typically by a
  * $().dataTable() call) and the settings object is then applied to that
  * instance.
  *
  * Note that this object is related to {@link DataTable.defaults} but this
  * one is the internal data store for DataTables's cache of columns. It should
  * NOT be manipulated outside of DataTables. Any configuration should be done
  * through the initialisation options.
  *  @namespace
  *  @todo Really should attach the settings object to individual instances so we
  *    don't need to create new instances on each $().dataTable() call (if the
  *    table already exists). It would also save passing oSettings around and
  *    into every single function. However, this is a very significant
  *    architecture change for DataTables and will almost certainly break
  *    backwards compatibility with older installations. This is something that
  *    will be done in 2.0.
  */
	DataTable.models.oSettings = {
		/**
   * Primary features of DataTables and their enablement state.
   *  @namespace
   */
		"oFeatures": {

			/**
    * Flag to say if DataTables should automatically try to calculate the
    * optimum table and columns widths (true) or not (false).
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bAutoWidth": null,

			/**
    * Delay the creation of TR and TD elements until they are actually
    * needed by a driven page draw. This can give a significant speed
    * increase for Ajax source and Javascript source data, but makes no
    * difference at all fro DOM and server-side processing tables.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bDeferRender": null,

			/**
    * Enable filtering on the table or not. Note that if this is disabled
    * then there is no filtering at all on the table, including fnFilter.
    * To just remove the filtering input use sDom and remove the 'f' option.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bFilter": null,

			/**
    * Table information element (the 'Showing x of y records' div) enable
    * flag.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bInfo": null,

			/**
    * Present a user control allowing the end user to change the page size
    * when pagination is enabled.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bLengthChange": null,

			/**
    * Pagination enabled or not. Note that if this is disabled then length
    * changing must also be disabled.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bPaginate": null,

			/**
    * Processing indicator enable flag whenever DataTables is enacting a
    * user request - typically an Ajax request for server-side processing.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bProcessing": null,

			/**
    * Server-side processing enabled flag - when enabled DataTables will
    * get all data from the server for every draw - there is no filtering,
    * sorting or paging done on the client-side.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bServerSide": null,

			/**
    * Sorting enablement flag.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bSort": null,

			/**
    * Multi-column sorting
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bSortMulti": null,

			/**
    * Apply a class to the columns which are being sorted to provide a
    * visual highlight or not. This can slow things down when enabled since
    * there is a lot of DOM interaction.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bSortClasses": null,

			/**
    * State saving enablement flag.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bStateSave": null
		},

		/**
   * Scrolling settings for a table.
   *  @namespace
   */
		"oScroll": {
			/**
    * When the table is shorter in height than sScrollY, collapse the
    * table container down to the height of the table (when true).
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type boolean
    */
			"bCollapse": null,

			/**
    * Width of the scrollbar for the web-browser's platform. Calculated
    * during table initialisation.
    *  @type int
    *  @default 0
    */
			"iBarWidth": 0,

			/**
    * Viewport width for horizontal scrolling. Horizontal scrolling is
    * disabled if an empty string.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type string
    */
			"sX": null,

			/**
    * Width to expand the table to when using x-scrolling. Typically you
    * should not need to use this.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type string
    *  @deprecated
    */
			"sXInner": null,

			/**
    * Viewport height for vertical scrolling. Vertical scrolling is disabled
    * if an empty string.
    * Note that this parameter will be set by the initialisation routine. To
    * set a default use {@link DataTable.defaults}.
    *  @type string
    */
			"sY": null
		},

		/**
   * Language information for the table.
   *  @namespace
   *  @extends DataTable.defaults.oLanguage
   */
		"oLanguage": {
			/**
    * Information callback function. See
    * {@link DataTable.defaults.fnInfoCallback}
    *  @type function
    *  @default null
    */
			"fnInfoCallback": null
		},

		/**
   * Browser support parameters
   *  @namespace
   */
		"oBrowser": {
			/**
    * Indicate if the browser incorrectly calculates width:100% inside a
    * scrolling element (IE6/7)
    *  @type boolean
    *  @default false
    */
			"bScrollOversize": false,

			/**
    * Determine if the vertical scrollbar is on the right or left of the
    * scrolling container - needed for rtl language layout, although not
    * all browsers move the scrollbar (Safari).
    *  @type boolean
    *  @default false
    */
			"bScrollbarLeft": false,

			/**
    * Flag for if `getBoundingClientRect` is fully supported or not
    *  @type boolean
    *  @default false
    */
			"bBounding": false,

			/**
    * Browser scrollbar width
    *  @type integer
    *  @default 0
    */
			"barWidth": 0
		},

		"ajax": null,

		/**
   * Array referencing the nodes which are used for the features. The
   * parameters of this object match what is allowed by sDom - i.e.
   *   <ul>
   *     <li>'l' - Length changing</li>
   *     <li>'f' - Filtering input</li>
   *     <li>'t' - The table!</li>
   *     <li>'i' - Information</li>
   *     <li>'p' - Pagination</li>
   *     <li>'r' - pRocessing</li>
   *   </ul>
   *  @type array
   *  @default []
   */
		"aanFeatures": [],

		/**
   * Store data information - see {@link DataTable.models.oRow} for detailed
   * information.
   *  @type array
   *  @default []
   */
		"aoData": [],

		/**
   * Array of indexes which are in the current display (after filtering etc)
   *  @type array
   *  @default []
   */
		"aiDisplay": [],

		/**
   * Array of indexes for display - no filtering
   *  @type array
   *  @default []
   */
		"aiDisplayMaster": [],

		/**
   * Map of row ids to data indexes
   *  @type object
   *  @default {}
   */
		"aIds": {},

		/**
   * Store information about each column that is in use
   *  @type array
   *  @default []
   */
		"aoColumns": [],

		/**
   * Store information about the table's header
   *  @type array
   *  @default []
   */
		"aoHeader": [],

		/**
   * Store information about the table's footer
   *  @type array
   *  @default []
   */
		"aoFooter": [],

		/**
   * Store the applied global search information in case we want to force a
   * research or compare the old search to a new one.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @namespace
   *  @extends DataTable.models.oSearch
   */
		"oPreviousSearch": {},

		/**
   * Store the applied search for each column - see
   * {@link DataTable.models.oSearch} for the format that is used for the
   * filtering information for each column.
   *  @type array
   *  @default []
   */
		"aoPreSearchCols": [],

		/**
   * Sorting that is applied to the table. Note that the inner arrays are
   * used in the following manner:
   * <ul>
   *   <li>Index 0 - column number</li>
   *   <li>Index 1 - current sorting direction</li>
   * </ul>
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type array
   *  @todo These inner arrays should really be objects
   */
		"aaSorting": null,

		/**
   * Sorting that is always applied to the table (i.e. prefixed in front of
   * aaSorting).
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type array
   *  @default []
   */
		"aaSortingFixed": [],

		/**
   * Classes to use for the striping of a table.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type array
   *  @default []
   */
		"asStripeClasses": null,

		/**
   * If restoring a table - we should restore its striping classes as well
   *  @type array
   *  @default []
   */
		"asDestroyStripes": [],

		/**
   * If restoring a table - we should restore its width
   *  @type int
   *  @default 0
   */
		"sDestroyWidth": 0,

		/**
   * Callback functions array for every time a row is inserted (i.e. on a draw).
   *  @type array
   *  @default []
   */
		"aoRowCallback": [],

		/**
   * Callback functions for the header on each draw.
   *  @type array
   *  @default []
   */
		"aoHeaderCallback": [],

		/**
   * Callback function for the footer on each draw.
   *  @type array
   *  @default []
   */
		"aoFooterCallback": [],

		/**
   * Array of callback functions for draw callback functions
   *  @type array
   *  @default []
   */
		"aoDrawCallback": [],

		/**
   * Array of callback functions for row created function
   *  @type array
   *  @default []
   */
		"aoRowCreatedCallback": [],

		/**
   * Callback functions for just before the table is redrawn. A return of
   * false will be used to cancel the draw.
   *  @type array
   *  @default []
   */
		"aoPreDrawCallback": [],

		/**
   * Callback functions for when the table has been initialised.
   *  @type array
   *  @default []
   */
		"aoInitComplete": [],

		/**
   * Callbacks for modifying the settings to be stored for state saving, prior to
   * saving state.
   *  @type array
   *  @default []
   */
		"aoStateSaveParams": [],

		/**
   * Callbacks for modifying the settings that have been stored for state saving
   * prior to using the stored values to restore the state.
   *  @type array
   *  @default []
   */
		"aoStateLoadParams": [],

		/**
   * Callbacks for operating on the settings object once the saved state has been
   * loaded
   *  @type array
   *  @default []
   */
		"aoStateLoaded": [],

		/**
   * Cache the table ID for quick access
   *  @type string
   *  @default <i>Empty string</i>
   */
		"sTableId": "",

		/**
   * The TABLE node for the main table
   *  @type node
   *  @default null
   */
		"nTable": null,

		/**
   * Permanent ref to the thead element
   *  @type node
   *  @default null
   */
		"nTHead": null,

		/**
   * Permanent ref to the tfoot element - if it exists
   *  @type node
   *  @default null
   */
		"nTFoot": null,

		/**
   * Permanent ref to the tbody element
   *  @type node
   *  @default null
   */
		"nTBody": null,

		/**
   * Cache the wrapper node (contains all DataTables controlled elements)
   *  @type node
   *  @default null
   */
		"nTableWrapper": null,

		/**
   * Indicate if when using server-side processing the loading of data
   * should be deferred until the second draw.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type boolean
   *  @default false
   */
		"bDeferLoading": false,

		/**
   * Indicate if all required information has been read in
   *  @type boolean
   *  @default false
   */
		"bInitialised": false,

		/**
   * Information about open rows. Each object in the array has the parameters
   * 'nTr' and 'nParent'
   *  @type array
   *  @default []
   */
		"aoOpenRows": [],

		/**
   * Dictate the positioning of DataTables' control elements - see
   * {@link DataTable.model.oInit.sDom}.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type string
   *  @default null
   */
		"sDom": null,

		/**
   * Search delay (in mS)
   *  @type integer
   *  @default null
   */
		"searchDelay": null,

		/**
   * Which type of pagination should be used.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type string
   *  @default two_button
   */
		"sPaginationType": "two_button",

		/**
   * The state duration (for `stateSave`) in seconds.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type int
   *  @default 0
   */
		"iStateDuration": 0,

		/**
   * Array of callback functions for state saving. Each array element is an
   * object with the following parameters:
   *   <ul>
   *     <li>function:fn - function to call. Takes two parameters, oSettings
   *       and the JSON string to save that has been thus far created. Returns
   *       a JSON string to be inserted into a json object
   *       (i.e. '"param": [ 0, 1, 2]')</li>
   *     <li>string:sName - name of callback</li>
   *   </ul>
   *  @type array
   *  @default []
   */
		"aoStateSave": [],

		/**
   * Array of callback functions for state loading. Each array element is an
   * object with the following parameters:
   *   <ul>
   *     <li>function:fn - function to call. Takes two parameters, oSettings
   *       and the object stored. May return false to cancel state loading</li>
   *     <li>string:sName - name of callback</li>
   *   </ul>
   *  @type array
   *  @default []
   */
		"aoStateLoad": [],

		/**
   * State that was saved. Useful for back reference
   *  @type object
   *  @default null
   */
		"oSavedState": null,

		/**
   * State that was loaded. Useful for back reference
   *  @type object
   *  @default null
   */
		"oLoadedState": null,

		/**
   * Source url for AJAX data for the table.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type string
   *  @default null
   */
		"sAjaxSource": null,

		/**
   * Property from a given object from which to read the table data from. This
   * can be an empty string (when not server-side processing), in which case
   * it is  assumed an an array is given directly.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type string
   */
		"sAjaxDataProp": null,

		/**
   * Note if draw should be blocked while getting data
   *  @type boolean
   *  @default true
   */
		"bAjaxDataGet": true,

		/**
   * The last jQuery XHR object that was used for server-side data gathering.
   * This can be used for working with the XHR information in one of the
   * callbacks
   *  @type object
   *  @default null
   */
		"jqXHR": null,

		/**
   * JSON returned from the server in the last Ajax request
   *  @type object
   *  @default undefined
   */
		"json": undefined,

		/**
   * Data submitted as part of the last Ajax request
   *  @type object
   *  @default undefined
   */
		"oAjaxData": undefined,

		/**
   * Function to get the server-side data.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type function
   */
		"fnServerData": null,

		/**
   * Functions which are called prior to sending an Ajax request so extra
   * parameters can easily be sent to the server
   *  @type array
   *  @default []
   */
		"aoServerParams": [],

		/**
   * Send the XHR HTTP method - GET or POST (could be PUT or DELETE if
   * required).
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type string
   */
		"sServerMethod": null,

		/**
   * Format numbers for display.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type function
   */
		"fnFormatNumber": null,

		/**
   * List of options that can be used for the user selectable length menu.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type array
   *  @default []
   */
		"aLengthMenu": null,

		/**
   * Counter for the draws that the table does. Also used as a tracker for
   * server-side processing
   *  @type int
   *  @default 0
   */
		"iDraw": 0,

		/**
   * Indicate if a redraw is being done - useful for Ajax
   *  @type boolean
   *  @default false
   */
		"bDrawing": false,

		/**
   * Draw index (iDraw) of the last error when parsing the returned data
   *  @type int
   *  @default -1
   */
		"iDrawError": -1,

		/**
   * Paging display length
   *  @type int
   *  @default 10
   */
		"_iDisplayLength": 10,

		/**
   * Paging start point - aiDisplay index
   *  @type int
   *  @default 0
   */
		"_iDisplayStart": 0,

		/**
   * Server-side processing - number of records in the result set
   * (i.e. before filtering), Use fnRecordsTotal rather than
   * this property to get the value of the number of records, regardless of
   * the server-side processing setting.
   *  @type int
   *  @default 0
   *  @private
   */
		"_iRecordsTotal": 0,

		/**
   * Server-side processing - number of records in the current display set
   * (i.e. after filtering). Use fnRecordsDisplay rather than
   * this property to get the value of the number of records, regardless of
   * the server-side processing setting.
   *  @type boolean
   *  @default 0
   *  @private
   */
		"_iRecordsDisplay": 0,

		/**
   * Flag to indicate if jQuery UI marking and classes should be used.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type boolean
   */
		"bJUI": null,

		/**
   * The classes to use for the table
   *  @type object
   *  @default {}
   */
		"oClasses": {},

		/**
   * Flag attached to the settings object so you can check in the draw
   * callback if filtering has been done in the draw. Deprecated in favour of
   * events.
   *  @type boolean
   *  @default false
   *  @deprecated
   */
		"bFiltered": false,

		/**
   * Flag attached to the settings object so you can check in the draw
   * callback if sorting has been done in the draw. Deprecated in favour of
   * events.
   *  @type boolean
   *  @default false
   *  @deprecated
   */
		"bSorted": false,

		/**
   * Indicate that if multiple rows are in the header and there is more than
   * one unique cell per column, if the top one (true) or bottom one (false)
   * should be used for sorting / title by DataTables.
   * Note that this parameter will be set by the initialisation routine. To
   * set a default use {@link DataTable.defaults}.
   *  @type boolean
   */
		"bSortCellsTop": null,

		/**
   * Initialisation object that is used for the table
   *  @type object
   *  @default null
   */
		"oInit": null,

		/**
   * Destroy callback functions - for plug-ins to attach themselves to the
   * destroy so they can clean up markup and events.
   *  @type array
   *  @default []
   */
		"aoDestroyCallback": [],

		/**
   * Get the number of records in the current record set, before filtering
   *  @type function
   */
		"fnRecordsTotal": function fnRecordsTotal() {
			return _fnDataSource(this) == 'ssp' ? this._iRecordsTotal * 1 : this.aiDisplayMaster.length;
		},

		/**
   * Get the number of records in the current record set, after filtering
   *  @type function
   */
		"fnRecordsDisplay": function fnRecordsDisplay() {
			return _fnDataSource(this) == 'ssp' ? this._iRecordsDisplay * 1 : this.aiDisplay.length;
		},

		/**
   * Get the display end point - aiDisplay index
   *  @type function
   */
		"fnDisplayEnd": function fnDisplayEnd() {
			var len = this._iDisplayLength,
			    start = this._iDisplayStart,
			    calc = start + len,
			    records = this.aiDisplay.length,
			    features = this.oFeatures,
			    paginate = features.bPaginate;

			if (features.bServerSide) {
				return paginate === false || len === -1 ? start + records : Math.min(start + len, this._iRecordsDisplay);
			} else {
				return !paginate || calc > records || len === -1 ? records : calc;
			}
		},

		/**
   * The DataTables object for this table
   *  @type object
   *  @default null
   */
		"oInstance": null,

		/**
   * Unique identifier for each instance of the DataTables object. If there
   * is an ID on the table node, then it takes that value, otherwise an
   * incrementing internal counter is used.
   *  @type string
   *  @default null
   */
		"sInstance": null,

		/**
   * tabindex attribute value that is added to DataTables control elements, allowing
   * keyboard navigation of the table and its controls.
   */
		"iTabIndex": 0,

		/**
   * DIV container for the footer scrolling table if scrolling
   */
		"nScrollHead": null,

		/**
   * DIV container for the footer scrolling table if scrolling
   */
		"nScrollFoot": null,

		/**
   * Last applied sort
   *  @type array
   *  @default []
   */
		"aLastSort": [],

		/**
   * Stored plug-in instances
   *  @type object
   *  @default {}
   */
		"oPlugins": {},

		/**
   * Function used to get a row's id from the row's data
   *  @type function
   *  @default null
   */
		"rowIdFn": null,

		/**
   * Data location where to store a row's id
   *  @type string
   *  @default null
   */
		"rowId": null
	};

	/**
  * Extension object for DataTables that is used to provide all extension
  * options.
  *
  * Note that the `DataTable.ext` object is available through
  * `jQuery.fn.dataTable.ext` where it may be accessed and manipulated. It is
  * also aliased to `jQuery.fn.dataTableExt` for historic reasons.
  *  @namespace
  *  @extends DataTable.models.ext
  */

	/**
  * DataTables extensions
  * 
  * This namespace acts as a collection area for plug-ins that can be used to
  * extend DataTables capabilities. Indeed many of the build in methods
  * use this method to provide their own capabilities (sorting methods for
  * example).
  *
  * Note that this namespace is aliased to `jQuery.fn.dataTableExt` for legacy
  * reasons
  *
  *  @namespace
  */
	DataTable.ext = _ext = {
		/**
   * Buttons. For use with the Buttons extension for DataTables. This is
   * defined here so other extensions can define buttons regardless of load
   * order. It is _not_ used by DataTables core.
   *
   *  @type object
   *  @default {}
   */
		buttons: {},

		/**
   * Element class names
   *
   *  @type object
   *  @default {}
   */
		classes: {},

		/**
   * DataTables build type (expanded by the download builder)
   *
   *  @type string
   */
		builder: "-source-",

		/**
   * Error reporting.
   * 
   * How should DataTables report an error. Can take the value 'alert',
   * 'throw', 'none' or a function.
   *
   *  @type string|function
   *  @default alert
   */
		errMode: "alert",

		/**
   * Feature plug-ins.
   * 
   * This is an array of objects which describe the feature plug-ins that are
   * available to DataTables. These feature plug-ins are then available for
   * use through the `dom` initialisation option.
   * 
   * Each feature plug-in is described by an object which must have the
   * following properties:
   * 
   * * `fnInit` - function that is used to initialise the plug-in,
   * * `cFeature` - a character so the feature can be enabled by the `dom`
   *   instillation option. This is case sensitive.
   *
   * The `fnInit` function has the following input parameters:
   *
   * 1. `{object}` DataTables settings object: see
   *    {@link DataTable.models.oSettings}
   *
   * And the following return is expected:
   * 
   * * {node|null} The element which contains your feature. Note that the
   *   return may also be void if your plug-in does not require to inject any
   *   DOM elements into DataTables control (`dom`) - for example this might
   *   be useful when developing a plug-in which allows table control via
   *   keyboard entry
   *
   *  @type array
   *
   *  @example
   *    $.fn.dataTable.ext.features.push( {
   *      "fnInit": function( oSettings ) {
   *        return new TableTools( { "oDTSettings": oSettings } );
   *      },
   *      "cFeature": "T"
   *    } );
   */
		feature: [],

		/**
   * Row searching.
   * 
   * This method of searching is complimentary to the default type based
   * searching, and a lot more comprehensive as it allows you complete control
   * over the searching logic. Each element in this array is a function
   * (parameters described below) that is called for every row in the table,
   * and your logic decides if it should be included in the searching data set
   * or not.
   *
   * Searching functions have the following input parameters:
   *
   * 1. `{object}` DataTables settings object: see
   *    {@link DataTable.models.oSettings}
   * 2. `{array|object}` Data for the row to be processed (same as the
   *    original format that was passed in as the data source, or an array
   *    from a DOM data source
   * 3. `{int}` Row index ({@link DataTable.models.oSettings.aoData}), which
   *    can be useful to retrieve the `TR` element if you need DOM interaction.
   *
   * And the following return is expected:
   *
   * * {boolean} Include the row in the searched result set (true) or not
   *   (false)
   *
   * Note that as with the main search ability in DataTables, technically this
   * is "filtering", since it is subtractive. However, for consistency in
   * naming we call it searching here.
   *
   *  @type array
   *  @default []
   *
   *  @example
   *    // The following example shows custom search being applied to the
   *    // fourth column (i.e. the data[3] index) based on two input values
   *    // from the end-user, matching the data in a certain range.
   *    $.fn.dataTable.ext.search.push(
   *      function( settings, data, dataIndex ) {
   *        var min = document.getElementById('min').value * 1;
   *        var max = document.getElementById('max').value * 1;
   *        var version = data[3] == "-" ? 0 : data[3]*1;
   *
   *        if ( min == "" && max == "" ) {
   *          return true;
   *        }
   *        else if ( min == "" && version < max ) {
   *          return true;
   *        }
   *        else if ( min < version && "" == max ) {
   *          return true;
   *        }
   *        else if ( min < version && version < max ) {
   *          return true;
   *        }
   *        return false;
   *      }
   *    );
   */
		search: [],

		/**
   * Selector extensions
   *
   * The `selector` option can be used to extend the options available for the
   * selector modifier options (`selector-modifier` object data type) that
   * each of the three built in selector types offer (row, column and cell +
   * their plural counterparts). For example the Select extension uses this
   * mechanism to provide an option to select only rows, columns and cells
   * that have been marked as selected by the end user (`{selected: true}`),
   * which can be used in conjunction with the existing built in selector
   * options.
   *
   * Each property is an array to which functions can be pushed. The functions
   * take three attributes:
   *
   * * Settings object for the host table
   * * Options object (`selector-modifier` object type)
   * * Array of selected item indexes
   *
   * The return is an array of the resulting item indexes after the custom
   * selector has been applied.
   *
   *  @type object
   */
		selector: {
			cell: [],
			column: [],
			row: []
		},

		/**
   * Internal functions, exposed for used in plug-ins.
   * 
   * Please note that you should not need to use the internal methods for
   * anything other than a plug-in (and even then, try to avoid if possible).
   * The internal function may change between releases.
   *
   *  @type object
   *  @default {}
   */
		internal: {},

		/**
   * Legacy configuration options. Enable and disable legacy options that
   * are available in DataTables.
   *
   *  @type object
   */
		legacy: {
			/**
    * Enable / disable DataTables 1.9 compatible server-side processing
    * requests
    *
    *  @type boolean
    *  @default null
    */
			ajax: null
		},

		/**
   * Pagination plug-in methods.
   * 
   * Each entry in this object is a function and defines which buttons should
   * be shown by the pagination rendering method that is used for the table:
   * {@link DataTable.ext.renderer.pageButton}. The renderer addresses how the
   * buttons are displayed in the document, while the functions here tell it
   * what buttons to display. This is done by returning an array of button
   * descriptions (what each button will do).
   *
   * Pagination types (the four built in options and any additional plug-in
   * options defined here) can be used through the `paginationType`
   * initialisation parameter.
   *
   * The functions defined take two parameters:
   *
   * 1. `{int} page` The current page index
   * 2. `{int} pages` The number of pages in the table
   *
   * Each function is expected to return an array where each element of the
   * array can be one of:
   *
   * * `first` - Jump to first page when activated
   * * `last` - Jump to last page when activated
   * * `previous` - Show previous page when activated
   * * `next` - Show next page when activated
   * * `{int}` - Show page of the index given
   * * `{array}` - A nested array containing the above elements to add a
   *   containing 'DIV' element (might be useful for styling).
   *
   * Note that DataTables v1.9- used this object slightly differently whereby
   * an object with two functions would be defined for each plug-in. That
   * ability is still supported by DataTables 1.10+ to provide backwards
   * compatibility, but this option of use is now decremented and no longer
   * documented in DataTables 1.10+.
   *
   *  @type object
   *  @default {}
   *
   *  @example
   *    // Show previous, next and current page buttons only
   *    $.fn.dataTableExt.oPagination.current = function ( page, pages ) {
   *      return [ 'previous', page, 'next' ];
   *    };
   */
		pager: {},

		renderer: {
			pageButton: {},
			header: {}
		},

		/**
   * Ordering plug-ins - custom data source
   * 
   * The extension options for ordering of data available here is complimentary
   * to the default type based ordering that DataTables typically uses. It
   * allows much greater control over the the data that is being used to
   * order a column, but is necessarily therefore more complex.
   * 
   * This type of ordering is useful if you want to do ordering based on data
   * live from the DOM (for example the contents of an 'input' element) rather
   * than just the static string that DataTables knows of.
   * 
   * The way these plug-ins work is that you create an array of the values you
   * wish to be ordering for the column in question and then return that
   * array. The data in the array much be in the index order of the rows in
   * the table (not the currently ordering order!). Which order data gathering
   * function is run here depends on the `dt-init columns.orderDataType`
   * parameter that is used for the column (if any).
   *
   * The functions defined take two parameters:
   *
   * 1. `{object}` DataTables settings object: see
   *    {@link DataTable.models.oSettings}
   * 2. `{int}` Target column index
   *
   * Each function is expected to return an array:
   *
   * * `{array}` Data for the column to be ordering upon
   *
   *  @type array
   *
   *  @example
   *    // Ordering using `input` node values
   *    $.fn.dataTable.ext.order['dom-text'] = function  ( settings, col )
   *    {
   *      return this.api().column( col, {order:'index'} ).nodes().map( function ( td, i ) {
   *        return $('input', td).val();
   *      } );
   *    }
   */
		order: {},

		/**
   * Type based plug-ins.
   *
   * Each column in DataTables has a type assigned to it, either by automatic
   * detection or by direct assignment using the `type` option for the column.
   * The type of a column will effect how it is ordering and search (plug-ins
   * can also make use of the column type if required).
   *
   * @namespace
   */
		type: {
			/**
    * Type detection functions.
    *
    * The functions defined in this object are used to automatically detect
    * a column's type, making initialisation of DataTables super easy, even
    * when complex data is in the table.
    *
    * The functions defined take two parameters:
    *
       *  1. `{*}` Data from the column cell to be analysed
       *  2. `{settings}` DataTables settings object. This can be used to
       *     perform context specific type detection - for example detection
       *     based on language settings such as using a comma for a decimal
       *     place. Generally speaking the options from the settings will not
       *     be required
    *
    * Each function is expected to return:
    *
    * * `{string|null}` Data type detected, or null if unknown (and thus
    *   pass it on to the other type detection functions.
    *
    *  @type array
    *
    *  @example
    *    // Currency type detection plug-in:
    *    $.fn.dataTable.ext.type.detect.push(
    *      function ( data, settings ) {
    *        // Check the numeric part
    *        if ( ! $.isNumeric( data.substring(1) ) ) {
    *          return null;
    *        }
    *
    *        // Check prefixed by currency
    *        if ( data.charAt(0) == '$' || data.charAt(0) == '&pound;' ) {
    *          return 'currency';
    *        }
    *        return null;
    *      }
    *    );
    */
			detect: [],

			/**
    * Type based search formatting.
    *
    * The type based searching functions can be used to pre-format the
    * data to be search on. For example, it can be used to strip HTML
    * tags or to de-format telephone numbers for numeric only searching.
    *
    * Note that is a search is not defined for a column of a given type,
    * no search formatting will be performed.
    * 
    * Pre-processing of searching data plug-ins - When you assign the sType
    * for a column (or have it automatically detected for you by DataTables
    * or a type detection plug-in), you will typically be using this for
    * custom sorting, but it can also be used to provide custom searching
    * by allowing you to pre-processing the data and returning the data in
    * the format that should be searched upon. This is done by adding
    * functions this object with a parameter name which matches the sType
    * for that target column. This is the corollary of <i>afnSortData</i>
    * for searching data.
    *
    * The functions defined take a single parameter:
    *
       *  1. `{*}` Data from the column cell to be prepared for searching
    *
    * Each function is expected to return:
    *
    * * `{string|null}` Formatted string that will be used for the searching.
    *
    *  @type object
    *  @default {}
    *
    *  @example
    *    $.fn.dataTable.ext.type.search['title-numeric'] = function ( d ) {
    *      return d.replace(/\n/g," ").replace( /<.*?>/g, "" );
    *    }
    */
			search: {},

			/**
    * Type based ordering.
    *
    * The column type tells DataTables what ordering to apply to the table
    * when a column is sorted upon. The order for each type that is defined,
    * is defined by the functions available in this object.
    *
    * Each ordering option can be described by three properties added to
    * this object:
    *
    * * `{type}-pre` - Pre-formatting function
    * * `{type}-asc` - Ascending order function
    * * `{type}-desc` - Descending order function
    *
    * All three can be used together, only `{type}-pre` or only
    * `{type}-asc` and `{type}-desc` together. It is generally recommended
    * that only `{type}-pre` is used, as this provides the optimal
    * implementation in terms of speed, although the others are provided
    * for compatibility with existing Javascript sort functions.
    *
    * `{type}-pre`: Functions defined take a single parameter:
    *
       *  1. `{*}` Data from the column cell to be prepared for ordering
    *
    * And return:
    *
    * * `{*}` Data to be sorted upon
    *
    * `{type}-asc` and `{type}-desc`: Functions are typical Javascript sort
    * functions, taking two parameters:
    *
       *  1. `{*}` Data to compare to the second parameter
       *  2. `{*}` Data to compare to the first parameter
    *
    * And returning:
    *
    * * `{*}` Ordering match: <0 if first parameter should be sorted lower
    *   than the second parameter, ===0 if the two parameters are equal and
    *   >0 if the first parameter should be sorted height than the second
    *   parameter.
    * 
    *  @type object
    *  @default {}
    *
    *  @example
    *    // Numeric ordering of formatted numbers with a pre-formatter
    *    $.extend( $.fn.dataTable.ext.type.order, {
    *      "string-pre": function(x) {
    *        a = (a === "-" || a === "") ? 0 : a.replace( /[^\d\-\.]/g, "" );
    *        return parseFloat( a );
    *      }
    *    } );
    *
    *  @example
    *    // Case-sensitive string ordering, with no pre-formatting method
    *    $.extend( $.fn.dataTable.ext.order, {
    *      "string-case-asc": function(x,y) {
    *        return ((x < y) ? -1 : ((x > y) ? 1 : 0));
    *      },
    *      "string-case-desc": function(x,y) {
    *        return ((x < y) ? 1 : ((x > y) ? -1 : 0));
    *      }
    *    } );
    */
			order: {}
		},

		/**
   * Unique DataTables instance counter
   *
   * @type int
   * @private
   */
		_unique: 0,

		//
		// Depreciated
		// The following properties are retained for backwards compatiblity only.
		// The should not be used in new projects and will be removed in a future
		// version
		//

		/**
   * Version check function.
   *  @type function
   *  @depreciated Since 1.10
   */
		fnVersionCheck: DataTable.fnVersionCheck,

		/**
   * Index for what 'this' index API functions should use
   *  @type int
   *  @deprecated Since v1.10
   */
		iApiIndex: 0,

		/**
   * jQuery UI class container
   *  @type object
   *  @deprecated Since v1.10
   */
		oJUIClasses: {},

		/**
   * Software version
   *  @type string
   *  @deprecated Since v1.10
   */
		sVersion: DataTable.version
	};

	//
	// Backwards compatibility. Alias to pre 1.10 Hungarian notation counter parts
	//
	$.extend(_ext, {
		afnFiltering: _ext.search,
		aTypes: _ext.type.detect,
		ofnSearch: _ext.type.search,
		oSort: _ext.type.order,
		afnSortData: _ext.order,
		aoFeatures: _ext.feature,
		oApi: _ext.internal,
		oStdClasses: _ext.classes,
		oPagination: _ext.pager
	});

	$.extend(DataTable.ext.classes, {
		"sTable": "dataTable",
		"sNoFooter": "no-footer",

		/* Paging buttons */
		"sPageButton": "paginate_button",
		"sPageButtonActive": "current",
		"sPageButtonDisabled": "disabled",

		/* Striping classes */
		"sStripeOdd": "odd",
		"sStripeEven": "even",

		/* Empty row */
		"sRowEmpty": "dataTables_empty",

		/* Features */
		"sWrapper": "dataTables_wrapper",
		"sFilter": "dataTables_filter",
		"sInfo": "dataTables_info",
		"sPaging": "dataTables_paginate paging_", /* Note that the type is postfixed */
		"sLength": "dataTables_length",
		"sProcessing": "dataTables_processing",

		/* Sorting */
		"sSortAsc": "sorting_asc",
		"sSortDesc": "sorting_desc",
		"sSortable": "sorting", /* Sortable in both directions */
		"sSortableAsc": "sorting_asc_disabled",
		"sSortableDesc": "sorting_desc_disabled",
		"sSortableNone": "sorting_disabled",
		"sSortColumn": "sorting_", /* Note that an int is postfixed for the sorting order */

		/* Filtering */
		"sFilterInput": "",

		/* Page length */
		"sLengthSelect": "",

		/* Scrolling */
		"sScrollWrapper": "dataTables_scroll",
		"sScrollHead": "dataTables_scrollHead",
		"sScrollHeadInner": "dataTables_scrollHeadInner",
		"sScrollBody": "dataTables_scrollBody",
		"sScrollFoot": "dataTables_scrollFoot",
		"sScrollFootInner": "dataTables_scrollFootInner",

		/* Misc */
		"sHeaderTH": "",
		"sFooterTH": "",

		// Deprecated
		"sSortJUIAsc": "",
		"sSortJUIDesc": "",
		"sSortJUI": "",
		"sSortJUIAscAllowed": "",
		"sSortJUIDescAllowed": "",
		"sSortJUIWrapper": "",
		"sSortIcon": "",
		"sJUIHeader": "",
		"sJUIFooter": ""
	});

	(function () {

		// Reused strings for better compression. Closure compiler appears to have a
		// weird edge case where it is trying to expand strings rather than use the
		// variable version. This results in about 200 bytes being added, for very
		// little preference benefit since it this run on script load only.
		var _empty = '';
		_empty = '';

		var _stateDefault = _empty + 'ui-state-default';
		var _sortIcon = _empty + 'css_right ui-icon ui-icon-';
		var _headerFooter = _empty + 'fg-toolbar ui-toolbar ui-widget-header ui-helper-clearfix';

		$.extend(DataTable.ext.oJUIClasses, DataTable.ext.classes, {
			/* Full numbers paging buttons */
			"sPageButton": "fg-button ui-button " + _stateDefault,
			"sPageButtonActive": "ui-state-disabled",
			"sPageButtonDisabled": "ui-state-disabled",

			/* Features */
			"sPaging": "dataTables_paginate fg-buttonset ui-buttonset fg-buttonset-multi " + "ui-buttonset-multi paging_", /* Note that the type is postfixed */

			/* Sorting */
			"sSortAsc": _stateDefault + " sorting_asc",
			"sSortDesc": _stateDefault + " sorting_desc",
			"sSortable": _stateDefault + " sorting",
			"sSortableAsc": _stateDefault + " sorting_asc_disabled",
			"sSortableDesc": _stateDefault + " sorting_desc_disabled",
			"sSortableNone": _stateDefault + " sorting_disabled",
			"sSortJUIAsc": _sortIcon + "triangle-1-n",
			"sSortJUIDesc": _sortIcon + "triangle-1-s",
			"sSortJUI": _sortIcon + "carat-2-n-s",
			"sSortJUIAscAllowed": _sortIcon + "carat-1-n",
			"sSortJUIDescAllowed": _sortIcon + "carat-1-s",
			"sSortJUIWrapper": "DataTables_sort_wrapper",
			"sSortIcon": "DataTables_sort_icon",

			/* Scrolling */
			"sScrollHead": "dataTables_scrollHead " + _stateDefault,
			"sScrollFoot": "dataTables_scrollFoot " + _stateDefault,

			/* Misc */
			"sHeaderTH": _stateDefault,
			"sFooterTH": _stateDefault,
			"sJUIHeader": _headerFooter + " ui-corner-tl ui-corner-tr",
			"sJUIFooter": _headerFooter + " ui-corner-bl ui-corner-br"
		});
	})();

	var extPagination = DataTable.ext.pager;

	function _numbers(page, pages) {
		var numbers = [],
		    buttons = extPagination.numbers_length,
		    half = Math.floor(buttons / 2),
		    i = 1;

		if (pages <= buttons) {
			numbers = _range(0, pages);
		} else if (page <= half) {
			numbers = _range(0, buttons - 2);
			numbers.push('ellipsis');
			numbers.push(pages - 1);
		} else if (page >= pages - 1 - half) {
			numbers = _range(pages - (buttons - 2), pages);
			numbers.splice(0, 0, 'ellipsis'); // no unshift in ie6
			numbers.splice(0, 0, 0);
		} else {
			numbers = _range(page - half + 2, page + half - 1);
			numbers.push('ellipsis');
			numbers.push(pages - 1);
			numbers.splice(0, 0, 'ellipsis');
			numbers.splice(0, 0, 0);
		}

		numbers.DT_el = 'span';
		return numbers;
	}

	$.extend(extPagination, {
		simple: function simple(page, pages) {
			return ['previous', 'next'];
		},

		full: function full(page, pages) {
			return ['first', 'previous', 'next', 'last'];
		},

		numbers: function numbers(page, pages) {
			return [_numbers(page, pages)];
		},

		simple_numbers: function simple_numbers(page, pages) {
			return ['previous', _numbers(page, pages), 'next'];
		},

		full_numbers: function full_numbers(page, pages) {
			return ['first', 'previous', _numbers(page, pages), 'next', 'last'];
		},

		first_last_numbers: function first_last_numbers(page, pages) {
			return ['first', _numbers(page, pages), 'last'];
		},

		// For testing and plug-ins to use
		_numbers: _numbers,

		// Number of number buttons (including ellipsis) to show. _Must be odd!_
		numbers_length: 7
	});

	$.extend(true, DataTable.ext.renderer, {
		pageButton: {
			_: function _(settings, host, idx, buttons, page, pages) {
				var classes = settings.oClasses;
				var lang = settings.oLanguage.oPaginate;
				var aria = settings.oLanguage.oAria.paginate || {};
				var btnDisplay,
				    btnClass,
				    counter = 0;

				var attach = function attach(container, buttons) {
					var i, ien, node, button;
					var clickHandler = function clickHandler(e) {
						_fnPageChange(settings, e.data.action, true);
					};

					for (i = 0, ien = buttons.length; i < ien; i++) {
						button = buttons[i];

						if ($.isArray(button)) {
							var inner = $('<' + (button.DT_el || 'div') + '/>').appendTo(container);
							attach(inner, button);
						} else {
							btnDisplay = null;
							btnClass = '';

							switch (button) {
								case 'ellipsis':
									container.append('<span class="ellipsis">&#x2026;</span>');
									break;

								case 'first':
									btnDisplay = lang.sFirst;
									btnClass = button + (page > 0 ? '' : ' ' + classes.sPageButtonDisabled);
									break;

								case 'previous':
									btnDisplay = lang.sPrevious;
									btnClass = button + (page > 0 ? '' : ' ' + classes.sPageButtonDisabled);
									break;

								case 'next':
									btnDisplay = lang.sNext;
									btnClass = button + (page < pages - 1 ? '' : ' ' + classes.sPageButtonDisabled);
									break;

								case 'last':
									btnDisplay = lang.sLast;
									btnClass = button + (page < pages - 1 ? '' : ' ' + classes.sPageButtonDisabled);
									break;

								default:
									btnDisplay = button + 1;
									btnClass = page === button ? classes.sPageButtonActive : '';
									break;
							}

							if (btnDisplay !== null) {
								node = $('<a>', {
									'class': classes.sPageButton + ' ' + btnClass,
									'aria-controls': settings.sTableId,
									'aria-label': aria[button],
									'data-dt-idx': counter,
									'tabindex': settings.iTabIndex,
									'id': idx === 0 && typeof button === 'string' ? settings.sTableId + '_' + button : null
								}).html(btnDisplay).appendTo(container);

								_fnBindAction(node, { action: button }, clickHandler);

								counter++;
							}
						}
					}
				};

				// IE9 throws an 'unknown error' if document.activeElement is used
				// inside an iframe or frame. Try / catch the error. Not good for
				// accessibility, but neither are frames.
				var activeEl;

				try {
					// Because this approach is destroying and recreating the paging
					// elements, focus is lost on the select button which is bad for
					// accessibility. So we want to restore focus once the draw has
					// completed
					activeEl = $(host).find(document.activeElement).data('dt-idx');
				} catch (e) {}

				attach($(host).empty(), buttons);

				if (activeEl !== undefined) {
					$(host).find('[data-dt-idx=' + activeEl + ']').focus();
				}
			}
		}
	});

	// Built in type detection. See model.ext.aTypes for information about
	// what is required from this methods.
	$.extend(DataTable.ext.type.detect, [
	// Plain numbers - first since V8 detects some plain numbers as dates
	// e.g. Date.parse('55') (but not all, e.g. Date.parse('22')...).
	function (d, settings) {
		var decimal = settings.oLanguage.sDecimal;
		return _isNumber(d, decimal) ? 'num' + decimal : null;
	},

	// Dates (only those recognised by the browser's Date.parse)
	function (d, settings) {
		// V8 tries _very_ hard to make a string passed into `Date.parse()`
		// valid, so we need to use a regex to restrict date formats. Use a
		// plug-in for anything other than ISO8601 style strings
		if (d && !(d instanceof Date) && !_re_date.test(d)) {
			return null;
		}
		var parsed = Date.parse(d);
		return parsed !== null && !isNaN(parsed) || _empty(d) ? 'date' : null;
	},

	// Formatted numbers
	function (d, settings) {
		var decimal = settings.oLanguage.sDecimal;
		return _isNumber(d, decimal, true) ? 'num-fmt' + decimal : null;
	},

	// HTML numeric
	function (d, settings) {
		var decimal = settings.oLanguage.sDecimal;
		return _htmlNumeric(d, decimal) ? 'html-num' + decimal : null;
	},

	// HTML numeric, formatted
	function (d, settings) {
		var decimal = settings.oLanguage.sDecimal;
		return _htmlNumeric(d, decimal, true) ? 'html-num-fmt' + decimal : null;
	},

	// HTML (this is strict checking - there must be html)
	function (d, settings) {
		return _empty(d) || typeof d === 'string' && d.indexOf('<') !== -1 ? 'html' : null;
	}]);

	// Filter formatting functions. See model.ext.ofnSearch for information about
	// what is required from these methods.
	// 
	// Note that additional search methods are added for the html numbers and
	// html formatted numbers by `_addNumericSort()` when we know what the decimal
	// place is


	$.extend(DataTable.ext.type.search, {
		html: function html(data) {
			return _empty(data) ? data : typeof data === 'string' ? data.replace(_re_new_lines, " ").replace(_re_html, "") : '';
		},

		string: function string(data) {
			return _empty(data) ? data : typeof data === 'string' ? data.replace(_re_new_lines, " ") : data;
		}
	});

	var __numericReplace = function __numericReplace(d, decimalPlace, re1, re2) {
		if (d !== 0 && (!d || d === '-')) {
			return -Infinity;
		}

		// If a decimal place other than `.` is used, it needs to be given to the
		// function so we can detect it and replace with a `.` which is the only
		// decimal place Javascript recognises - it is not locale aware.
		if (decimalPlace) {
			d = _numToDecimal(d, decimalPlace);
		}

		if (d.replace) {
			if (re1) {
				d = d.replace(re1, '');
			}

			if (re2) {
				d = d.replace(re2, '');
			}
		}

		return d * 1;
	};

	// Add the numeric 'deformatting' functions for sorting and search. This is done
	// in a function to provide an easy ability for the language options to add
	// additional methods if a non-period decimal place is used.
	function _addNumericSort(decimalPlace) {
		$.each({
			// Plain numbers
			"num": function num(d) {
				return __numericReplace(d, decimalPlace);
			},

			// Formatted numbers
			"num-fmt": function numFmt(d) {
				return __numericReplace(d, decimalPlace, _re_formatted_numeric);
			},

			// HTML numeric
			"html-num": function htmlNum(d) {
				return __numericReplace(d, decimalPlace, _re_html);
			},

			// HTML numeric, formatted
			"html-num-fmt": function htmlNumFmt(d) {
				return __numericReplace(d, decimalPlace, _re_html, _re_formatted_numeric);
			}
		}, function (key, fn) {
			// Add the ordering method
			_ext.type.order[key + decimalPlace + '-pre'] = fn;

			// For HTML types add a search formatter that will strip the HTML
			if (key.match(/^html\-/)) {
				_ext.type.search[key + decimalPlace] = _ext.type.search.html;
			}
		});
	}

	// Default sort methods
	$.extend(_ext.type.order, {
		// Dates
		"date-pre": function datePre(d) {
			return Date.parse(d) || -Infinity;
		},

		// html
		"html-pre": function htmlPre(a) {
			return _empty(a) ? '' : a.replace ? a.replace(/<.*?>/g, "").toLowerCase() : a + '';
		},

		// string
		"string-pre": function stringPre(a) {
			// This is a little complex, but faster than always calling toString,
			// http://jsperf.com/tostring-v-check
			return _empty(a) ? '' : typeof a === 'string' ? a.toLowerCase() : !a.toString ? '' : a.toString();
		},

		// string-asc and -desc are retained only for compatibility with the old
		// sort methods
		"string-asc": function stringAsc(x, y) {
			return x < y ? -1 : x > y ? 1 : 0;
		},

		"string-desc": function stringDesc(x, y) {
			return x < y ? 1 : x > y ? -1 : 0;
		}
	});

	// Numeric sorting types - order doesn't matter here
	_addNumericSort('');

	$.extend(true, DataTable.ext.renderer, {
		header: {
			_: function _(settings, cell, column, classes) {
				// No additional mark-up required
				// Attach a sort listener to update on sort - note that using the
				// `DT` namespace will allow the event to be removed automatically
				// on destroy, while the `dt` namespaced event is the one we are
				// listening for
				$(settings.nTable).on('order.dt.DT', function (e, ctx, sorting, columns) {
					if (settings !== ctx) {
						// need to check this this is the host
						return; // table, not a nested one
					}

					var colIdx = column.idx;

					cell.removeClass(column.sSortingClass + ' ' + classes.sSortAsc + ' ' + classes.sSortDesc).addClass(columns[colIdx] == 'asc' ? classes.sSortAsc : columns[colIdx] == 'desc' ? classes.sSortDesc : column.sSortingClass);
				});
			},

			jqueryui: function jqueryui(settings, cell, column, classes) {
				$('<div/>').addClass(classes.sSortJUIWrapper).append(cell.contents()).append($('<span/>').addClass(classes.sSortIcon + ' ' + column.sSortingClassJUI)).appendTo(cell);

				// Attach a sort listener to update on sort
				$(settings.nTable).on('order.dt.DT', function (e, ctx, sorting, columns) {
					if (settings !== ctx) {
						return;
					}

					var colIdx = column.idx;

					cell.removeClass(classes.sSortAsc + " " + classes.sSortDesc).addClass(columns[colIdx] == 'asc' ? classes.sSortAsc : columns[colIdx] == 'desc' ? classes.sSortDesc : column.sSortingClass);

					cell.find('span.' + classes.sSortIcon).removeClass(classes.sSortJUIAsc + " " + classes.sSortJUIDesc + " " + classes.sSortJUI + " " + classes.sSortJUIAscAllowed + " " + classes.sSortJUIDescAllowed).addClass(columns[colIdx] == 'asc' ? classes.sSortJUIAsc : columns[colIdx] == 'desc' ? classes.sSortJUIDesc : column.sSortingClassJUI);
				});
			}
		}
	});

	/*
  * Public helper functions. These aren't used internally by DataTables, or
  * called by any of the options passed into DataTables, but they can be used
  * externally by developers working with DataTables. They are helper functions
  * to make working with DataTables a little bit easier.
  */

	var __htmlEscapeEntities = function __htmlEscapeEntities(d) {
		return typeof d === 'string' ? d.replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;') : d;
	};

	/**
  * Helpers for `columns.render`.
  *
  * The options defined here can be used with the `columns.render` initialisation
  * option to provide a display renderer. The following functions are defined:
  *
  * * `number` - Will format numeric data (defined by `columns.data`) for
  *   display, retaining the original unformatted data for sorting and filtering.
  *   It takes 5 parameters:
  *   * `string` - Thousands grouping separator
  *   * `string` - Decimal point indicator
  *   * `integer` - Number of decimal points to show
  *   * `string` (optional) - Prefix.
  *   * `string` (optional) - Postfix (/suffix).
  * * `text` - Escape HTML to help prevent XSS attacks. It has no optional
  *   parameters.
  *
  * @example
  *   // Column definition using the number renderer
  *   {
  *     data: "salary",
  *     render: $.fn.dataTable.render.number( '\'', '.', 0, '$' )
  *   }
  *
  * @namespace
  */
	DataTable.render = {
		number: function number(thousands, decimal, precision, prefix, postfix) {
			return {
				display: function display(d) {
					if (typeof d !== 'number' && typeof d !== 'string') {
						return d;
					}

					var negative = d < 0 ? '-' : '';
					var flo = parseFloat(d);

					// If NaN then there isn't much formatting that we can do - just
					// return immediately, escaping any HTML (this was supposed to
					// be a number after all)
					if (isNaN(flo)) {
						return __htmlEscapeEntities(d);
					}

					flo = flo.toFixed(precision);
					d = Math.abs(flo);

					var intPart = parseInt(d, 10);
					var floatPart = precision ? decimal + (d - intPart).toFixed(precision).substring(2) : '';

					return negative + (prefix || '') + intPart.toString().replace(/\B(?=(\d{3})+(?!\d))/g, thousands) + floatPart + (postfix || '');
				}
			};
		},

		text: function text() {
			return {
				display: __htmlEscapeEntities
			};
		}
	};

	/*
  * This is really a good bit rubbish this method of exposing the internal methods
  * publicly... - To be fixed in 2.0 using methods on the prototype
  */

	/**
  * Create a wrapper function for exporting an internal functions to an external API.
  *  @param {string} fn API function name
  *  @returns {function} wrapped function
  *  @memberof DataTable#internal
  */
	function _fnExternApiFunc(fn) {
		return function () {
			var args = [_fnSettingsFromNode(this[DataTable.ext.iApiIndex])].concat(Array.prototype.slice.call(arguments));
			return DataTable.ext.internal[fn].apply(this, args);
		};
	}

	/**
  * Reference to internal functions for use by plug-in developers. Note that
  * these methods are references to internal functions and are considered to be
  * private. If you use these methods, be aware that they are liable to change
  * between versions.
  *  @namespace
  */
	$.extend(DataTable.ext.internal, {
		_fnExternApiFunc: _fnExternApiFunc,
		_fnBuildAjax: _fnBuildAjax,
		_fnAjaxUpdate: _fnAjaxUpdate,
		_fnAjaxParameters: _fnAjaxParameters,
		_fnAjaxUpdateDraw: _fnAjaxUpdateDraw,
		_fnAjaxDataSrc: _fnAjaxDataSrc,
		_fnAddColumn: _fnAddColumn,
		_fnColumnOptions: _fnColumnOptions,
		_fnAdjustColumnSizing: _fnAdjustColumnSizing,
		_fnVisibleToColumnIndex: _fnVisibleToColumnIndex,
		_fnColumnIndexToVisible: _fnColumnIndexToVisible,
		_fnVisbleColumns: _fnVisbleColumns,
		_fnGetColumns: _fnGetColumns,
		_fnColumnTypes: _fnColumnTypes,
		_fnApplyColumnDefs: _fnApplyColumnDefs,
		_fnHungarianMap: _fnHungarianMap,
		_fnCamelToHungarian: _fnCamelToHungarian,
		_fnLanguageCompat: _fnLanguageCompat,
		_fnBrowserDetect: _fnBrowserDetect,
		_fnAddData: _fnAddData,
		_fnAddTr: _fnAddTr,
		_fnNodeToDataIndex: _fnNodeToDataIndex,
		_fnNodeToColumnIndex: _fnNodeToColumnIndex,
		_fnGetCellData: _fnGetCellData,
		_fnSetCellData: _fnSetCellData,
		_fnSplitObjNotation: _fnSplitObjNotation,
		_fnGetObjectDataFn: _fnGetObjectDataFn,
		_fnSetObjectDataFn: _fnSetObjectDataFn,
		_fnGetDataMaster: _fnGetDataMaster,
		_fnClearTable: _fnClearTable,
		_fnDeleteIndex: _fnDeleteIndex,
		_fnInvalidate: _fnInvalidate,
		_fnGetRowElements: _fnGetRowElements,
		_fnCreateTr: _fnCreateTr,
		_fnBuildHead: _fnBuildHead,
		_fnDrawHead: _fnDrawHead,
		_fnDraw: _fnDraw,
		_fnReDraw: _fnReDraw,
		_fnAddOptionsHtml: _fnAddOptionsHtml,
		_fnDetectHeader: _fnDetectHeader,
		_fnGetUniqueThs: _fnGetUniqueThs,
		_fnFeatureHtmlFilter: _fnFeatureHtmlFilter,
		_fnFilterComplete: _fnFilterComplete,
		_fnFilterCustom: _fnFilterCustom,
		_fnFilterColumn: _fnFilterColumn,
		_fnFilter: _fnFilter,
		_fnFilterCreateSearch: _fnFilterCreateSearch,
		_fnEscapeRegex: _fnEscapeRegex,
		_fnFilterData: _fnFilterData,
		_fnFeatureHtmlInfo: _fnFeatureHtmlInfo,
		_fnUpdateInfo: _fnUpdateInfo,
		_fnInfoMacros: _fnInfoMacros,
		_fnInitialise: _fnInitialise,
		_fnInitComplete: _fnInitComplete,
		_fnLengthChange: _fnLengthChange,
		_fnFeatureHtmlLength: _fnFeatureHtmlLength,
		_fnFeatureHtmlPaginate: _fnFeatureHtmlPaginate,
		_fnPageChange: _fnPageChange,
		_fnFeatureHtmlProcessing: _fnFeatureHtmlProcessing,
		_fnProcessingDisplay: _fnProcessingDisplay,
		_fnFeatureHtmlTable: _fnFeatureHtmlTable,
		_fnScrollDraw: _fnScrollDraw,
		_fnApplyToChildren: _fnApplyToChildren,
		_fnCalculateColumnWidths: _fnCalculateColumnWidths,
		_fnThrottle: _fnThrottle,
		_fnConvertToWidth: _fnConvertToWidth,
		_fnGetWidestNode: _fnGetWidestNode,
		_fnGetMaxLenString: _fnGetMaxLenString,
		_fnStringToCss: _fnStringToCss,
		_fnSortFlatten: _fnSortFlatten,
		_fnSort: _fnSort,
		_fnSortAria: _fnSortAria,
		_fnSortListener: _fnSortListener,
		_fnSortAttachListener: _fnSortAttachListener,
		_fnSortingClasses: _fnSortingClasses,
		_fnSortData: _fnSortData,
		_fnSaveState: _fnSaveState,
		_fnLoadState: _fnLoadState,
		_fnSettingsFromNode: _fnSettingsFromNode,
		_fnLog: _fnLog,
		_fnMap: _fnMap,
		_fnBindAction: _fnBindAction,
		_fnCallbackReg: _fnCallbackReg,
		_fnCallbackFire: _fnCallbackFire,
		_fnLengthOverflow: _fnLengthOverflow,
		_fnRenderer: _fnRenderer,
		_fnDataSource: _fnDataSource,
		_fnRowAttributes: _fnRowAttributes,
		_fnCalculateEnd: function _fnCalculateEnd() {} // Used by a lot of plug-ins, but redundant
		// in 1.10, so this dead-end function is
		// added to prevent errors
	});

	// jQuery access
	$.fn.dataTable = DataTable;

	// Provide access to the host jQuery object (circular reference)
	DataTable.$ = $;

	// Legacy aliases
	$.fn.dataTableSettings = DataTable.settings;
	$.fn.dataTableExt = DataTable.ext;

	// With a capital `D` we return a DataTables API instance rather than a
	// jQuery object
	$.fn.DataTable = function (opts) {
		return $(this).dataTable(opts).api();
	};

	// All properties that are available to $.fn.dataTable should also be
	// available on $.fn.DataTable
	$.each(DataTable, function (prop, val) {
		$.fn.DataTable[prop] = val;
	});

	// Information about events fired by DataTables - for documentation.
	/**
  * Draw event, fired whenever the table is redrawn on the page, at the same
  * point as fnDrawCallback. This may be useful for binding events or
  * performing calculations when the table is altered at all.
  *  @name DataTable#draw.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
  */

	/**
  * Search event, fired when the searching applied to the table (using the
  * built-in global search, or column filters) is altered.
  *  @name DataTable#search.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
  */

	/**
  * Page change event, fired when the paging of the table is altered.
  *  @name DataTable#page.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
  */

	/**
  * Order event, fired when the ordering applied to the table is altered.
  *  @name DataTable#order.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
  */

	/**
  * DataTables initialisation complete event, fired when the table is fully
  * drawn, including Ajax data loaded, if Ajax data is required.
  *  @name DataTable#init.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} oSettings DataTables settings object
  *  @param {object} json The JSON object request from the server - only
  *    present if client-side Ajax sourced data is used</li></ol>
  */

	/**
  * State save event, fired when the table has changed state a new state save
  * is required. This event allows modification of the state saving object
  * prior to actually doing the save, including addition or other state
  * properties (for plug-ins) or modification of a DataTables core property.
  *  @name DataTable#stateSaveParams.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} oSettings DataTables settings object
  *  @param {object} json The state information to be saved
  */

	/**
  * State load event, fired when the table is loading state from the stored
  * data, but prior to the settings object being modified by the saved state
  * - allowing modification of the saved state is required or loading of
  * state for a plug-in.
  *  @name DataTable#stateLoadParams.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} oSettings DataTables settings object
  *  @param {object} json The saved state information
  */

	/**
  * State loaded event, fired when state has been loaded from stored data and
  * the settings object has been modified by the loaded data.
  *  @name DataTable#stateLoaded.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} oSettings DataTables settings object
  *  @param {object} json The saved state information
  */

	/**
  * Processing event, fired when DataTables is doing some kind of processing
  * (be it, order, searcg or anything else). It can be used to indicate to
  * the end user that there is something happening, or that something has
  * finished.
  *  @name DataTable#processing.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} oSettings DataTables settings object
  *  @param {boolean} bShow Flag for if DataTables is doing processing or not
  */

	/**
  * Ajax (XHR) event, fired whenever an Ajax request is completed from a
  * request to made to the server for new data. This event is called before
  * DataTables processed the returned data, so it can also be used to pre-
  * process the data returned from the server, if needed.
  *
  * Note that this trigger is called in `fnServerData`, if you override
  * `fnServerData` and which to use this event, you need to trigger it in you
  * success function.
  *  @name DataTable#xhr.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
  *  @param {object} json JSON returned from the server
  *
  *  @example
  *     // Use a custom property returned from the server in another DOM element
  *     $('#table').dataTable().on('xhr.dt', function (e, settings, json) {
  *       $('#status').html( json.status );
  *     } );
  *
  *  @example
  *     // Pre-process the data returned from the server
  *     $('#table').dataTable().on('xhr.dt', function (e, settings, json) {
  *       for ( var i=0, ien=json.aaData.length ; i<ien ; i++ ) {
  *         json.aaData[i].sum = json.aaData[i].one + json.aaData[i].two;
  *       }
  *       // Note no return - manipulate the data directly in the JSON object.
  *     } );
  */

	/**
  * Destroy event, fired when the DataTable is destroyed by calling fnDestroy
  * or passing the bDestroy:true parameter in the initialisation object. This
  * can be used to remove bound events, added DOM nodes, etc.
  *  @name DataTable#destroy.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
  */

	/**
  * Page length change event, fired when number of records to show on each
  * page (the length) is changed.
  *  @name DataTable#length.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
  *  @param {integer} len New length
  */

	/**
  * Column sizing has changed.
  *  @name DataTable#column-sizing.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
  */

	/**
  * Column visibility has changed.
  *  @name DataTable#column-visibility.dt
  *  @event
  *  @param {event} e jQuery event object
  *  @param {object} o DataTables settings object {@link DataTable.models.oSettings}
  *  @param {int} column Column index
  *  @param {bool} vis `false` if column now hidden, or `true` if visible
  */

	return $.fn.dataTable;
});

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// Generated by CoffeeScript 1.10.0
(function () {
  var _QJ, rreturn, rtrim;

  _QJ = function QJ(selector) {
    if (_QJ.isDOMElement(selector)) {
      return selector;
    }
    return document.querySelectorAll(selector);
  };

  _QJ.isDOMElement = function (el) {
    return el && el.nodeName != null;
  };

  rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;

  _QJ.trim = function (text) {
    if (text === null) {
      return "";
    } else {
      return (text + "").replace(rtrim, "");
    }
  };

  rreturn = /\r/g;

  _QJ.val = function (el, val) {
    var ret;
    if (arguments.length > 1) {
      return el.value = val;
    } else {
      ret = el.value;
      if (typeof ret === "string") {
        return ret.replace(rreturn, "");
      } else {
        if (ret === null) {
          return "";
        } else {
          return ret;
        }
      }
    }
  };

  _QJ.preventDefault = function (eventObject) {
    if (typeof eventObject.preventDefault === "function") {
      eventObject.preventDefault();
      return;
    }
    eventObject.returnValue = false;
    return false;
  };

  _QJ.normalizeEvent = function (e) {
    var original;
    original = e;
    e = {
      which: original.which != null ? original.which : void 0,
      target: original.target || original.srcElement,
      preventDefault: function preventDefault() {
        return _QJ.preventDefault(original);
      },
      originalEvent: original,
      data: original.data || original.detail
    };
    if (e.which == null) {
      e.which = original.charCode != null ? original.charCode : original.keyCode;
    }
    return e;
  };

  _QJ.on = function (element, eventName, callback) {
    var el, i, j, len, len1, multEventName, originalCallback, ref;
    if (element.length) {
      for (i = 0, len = element.length; i < len; i++) {
        el = element[i];
        _QJ.on(el, eventName, callback);
      }
      return;
    }
    if (eventName.match(" ")) {
      ref = eventName.split(" ");
      for (j = 0, len1 = ref.length; j < len1; j++) {
        multEventName = ref[j];
        _QJ.on(element, multEventName, callback);
      }
      return;
    }
    originalCallback = callback;
    callback = function callback(e) {
      e = _QJ.normalizeEvent(e);
      return originalCallback(e);
    };
    if (element.addEventListener) {
      return element.addEventListener(eventName, callback, false);
    }
    if (element.attachEvent) {
      eventName = "on" + eventName;
      return element.attachEvent(eventName, callback);
    }
    element['on' + eventName] = callback;
  };

  _QJ.addClass = function (el, className) {
    var e;
    if (el.length) {
      return function () {
        var i, len, results;
        results = [];
        for (i = 0, len = el.length; i < len; i++) {
          e = el[i];
          results.push(_QJ.addClass(e, className));
        }
        return results;
      }();
    }
    if (el.classList) {
      return el.classList.add(className);
    } else {
      return el.className += ' ' + className;
    }
  };

  _QJ.hasClass = function (el, className) {
    var e, hasClass, i, len;
    if (el.length) {
      hasClass = true;
      for (i = 0, len = el.length; i < len; i++) {
        e = el[i];
        hasClass = hasClass && _QJ.hasClass(e, className);
      }
      return hasClass;
    }
    if (el.classList) {
      return el.classList.contains(className);
    } else {
      return new RegExp('(^| )' + className + '( |$)', 'gi').test(el.className);
    }
  };

  _QJ.removeClass = function (el, className) {
    var cls, e, i, len, ref, results;
    if (el.length) {
      return function () {
        var i, len, results;
        results = [];
        for (i = 0, len = el.length; i < len; i++) {
          e = el[i];
          results.push(_QJ.removeClass(e, className));
        }
        return results;
      }();
    }
    if (el.classList) {
      ref = className.split(' ');
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        cls = ref[i];
        results.push(el.classList.remove(cls));
      }
      return results;
    } else {
      return el.className = el.className.replace(new RegExp('(^|\\b)' + className.split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
    }
  };

  _QJ.toggleClass = function (el, className, bool) {
    var e;
    if (el.length) {
      return function () {
        var i, len, results;
        results = [];
        for (i = 0, len = el.length; i < len; i++) {
          e = el[i];
          results.push(_QJ.toggleClass(e, className, bool));
        }
        return results;
      }();
    }
    if (bool) {
      if (!_QJ.hasClass(el, className)) {
        return _QJ.addClass(el, className);
      }
    } else {
      return _QJ.removeClass(el, className);
    }
  };

  _QJ.append = function (el, toAppend) {
    var e;
    if (el.length) {
      return function () {
        var i, len, results;
        results = [];
        for (i = 0, len = el.length; i < len; i++) {
          e = el[i];
          results.push(_QJ.append(e, toAppend));
        }
        return results;
      }();
    }
    return el.insertAdjacentHTML('beforeend', toAppend);
  };

  _QJ.find = function (el, selector) {
    if (el instanceof NodeList || el instanceof Array) {
      el = el[0];
    }
    return el.querySelectorAll(selector);
  };

  _QJ.trigger = function (el, name, data) {
    var e, error, ev;
    try {
      ev = new CustomEvent(name, {
        detail: data
      });
    } catch (error) {
      e = error;
      ev = document.createEvent('CustomEvent');
      if (ev.initCustomEvent) {
        ev.initCustomEvent(name, true, true, data);
      } else {
        ev.initEvent(name, true, true, data);
      }
    }
    return el.dispatchEvent(ev);
  };

  module.exports = _QJ;
}).call(undefined);

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var g;

// This works in non-strict mode
g = function () {
	return this;
}();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1, eval)("this");
} catch (e) {
	// This works if the window reference is available
	if ((typeof window === "undefined" ? "undefined" : _typeof(window)) === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;

/***/ }),
/* 7 */,
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/**
 * hoverIntent is similar to jQuery's built-in "hover" method except that
 * instead of firing the handlerIn function immediately, hoverIntent checks
 * to see if the user's mouse has slowed down (beneath the sensitivity
 * threshold) before firing the event. The handlerOut function is only
 * called after a matching handlerIn.
 *
 * hoverIntent r7 // 2013.03.11 // jQuery 1.9.1+
 * http://cherne.net/brian/resources/jquery.hoverIntent.html
 *
 * You may use hoverIntent under the terms of the MIT license. Basically that
 * means you are free to use hoverIntent as long as this header is left intact.
 * Copyright 2007, 2013 Brian Cherne
 *
 * // basic usage ... just like .hover()
 * .hoverIntent( handlerIn, handlerOut )
 * .hoverIntent( handlerInOut )
 *
 * // basic usage ... with event delegation!
 * .hoverIntent( handlerIn, handlerOut, selector )
 * .hoverIntent( handlerInOut, selector )
 *
 * // using a basic configuration object
 * .hoverIntent( config )
 *
 * @param  handlerIn   function OR configuration object
 * @param  handlerOut  function OR selector for delegation OR undefined
 * @param  selector    selector OR undefined
 * @author Brian Cherne <brian(at)cherne(dot)net>
 **/
(function ($) {
	$.fn.hoverIntent = function (handlerIn, handlerOut, selector) {

		// default configuration values
		var cfg = {
			interval: 100,
			sensitivity: 7,
			timeout: 0
		};

		if ((typeof handlerIn === "undefined" ? "undefined" : _typeof(handlerIn)) === "object") {
			cfg = $.extend(cfg, handlerIn);
		} else if ($.isFunction(handlerOut)) {
			cfg = $.extend(cfg, { over: handlerIn, out: handlerOut, selector: selector });
		} else {
			cfg = $.extend(cfg, { over: handlerIn, out: handlerIn, selector: handlerOut });
		}

		// instantiate variables
		// cX, cY = current X and Y position of mouse, updated by mousemove event
		// pX, pY = previous X and Y position of mouse, set by mouseover and polling interval
		var cX, cY, pX, pY;

		// A private function for getting mouse position
		var track = function track(ev) {
			cX = ev.pageX;
			cY = ev.pageY;
		};

		// A private function for comparing current and previous mouse position
		var compare = function compare(ev, ob) {
			ob.hoverIntent_t = clearTimeout(ob.hoverIntent_t);
			// compare mouse positions to see if they've crossed the threshold
			if (Math.abs(pX - cX) + Math.abs(pY - cY) < cfg.sensitivity) {
				$(ob).off("mousemove.hoverIntent", track);
				// set hoverIntent state to true (so mouseOut can be called)
				ob.hoverIntent_s = 1;
				return cfg.over.apply(ob, [ev]);
			} else {
				// set previous coordinates for next time
				pX = cX;pY = cY;
				// use self-calling timeout, guarantees intervals are spaced out properly (avoids JavaScript timer bugs)
				ob.hoverIntent_t = setTimeout(function () {
					compare(ev, ob);
				}, cfg.interval);
			}
		};

		// A private function for delaying the mouseOut function
		var delay = function delay(ev, ob) {
			ob.hoverIntent_t = clearTimeout(ob.hoverIntent_t);
			ob.hoverIntent_s = 0;
			return cfg.out.apply(ob, [ev]);
		};

		// A private function for handling mouse 'hovering'
		var handleHover = function handleHover(e) {
			// copy objects to be passed into t (required for event object to be passed in IE)
			var ev = jQuery.extend({}, e);
			var ob = this;

			// cancel hoverIntent timer if it exists
			if (ob.hoverIntent_t) {
				ob.hoverIntent_t = clearTimeout(ob.hoverIntent_t);
			}

			// if e.type == "mouseenter"
			if (e.type == "mouseenter") {
				// set "previous" X and Y position based on initial entry point
				pX = ev.pageX;pY = ev.pageY;
				// update "current" X and Y position based on mousemove
				$(ob).on("mousemove.hoverIntent", track);
				// start polling interval (self-calling timeout) to compare mouse coordinates over time
				if (ob.hoverIntent_s != 1) {
					ob.hoverIntent_t = setTimeout(function () {
						compare(ev, ob);
					}, cfg.interval);
				}

				// else e.type == "mouseleave"
			} else {
				// unbind expensive mousemove event
				$(ob).off("mousemove.hoverIntent", track);
				// if hoverIntent state is true, then call the mouseOut function after the specified delay
				if (ob.hoverIntent_s == 1) {
					ob.hoverIntent_t = setTimeout(function () {
						delay(ev, ob);
					}, cfg.timeout);
				}
			}
		};

		// listen for mouseenter and mouseleave
		return this.on({ 'mouseenter.hoverIntent': handleHover, 'mouseleave.hoverIntent': handleHover }, cfg.selector);
	};
})(jQuery);

/*
 * jQuery Superfish Menu Plugin - v1.7.9
 * Copyright (c) 2016 Joel Birch
 *
 * Dual licensed under the MIT and GPL licenses:
 *	http://www.opensource.org/licenses/mit-license.php
 *	http://www.gnu.org/licenses/gpl.html
 */

;(function ($, w) {
	"use strict";

	var methods = function () {
		// private properties and methods go here
		var c = {
			bcClass: 'sf-breadcrumb',
			menuClass: 'sf-js-enabled',
			anchorClass: 'sf-with-ul',
			menuArrowClass: 'sf-arrows'
		},
		    ios = function () {
			var ios = /^(?![\w\W]*Windows Phone)[\w\W]*(iPhone|iPad|iPod)/i.test(navigator.userAgent);
			if (ios) {
				// tap anywhere on iOS to unfocus a submenu
				$('html').css('cursor', 'pointer').on('click', $.noop);
			}
			return ios;
		}(),
		    wp7 = function () {
			var style = document.documentElement.style;
			return 'behavior' in style && 'fill' in style && /iemobile/i.test(navigator.userAgent);
		}(),
		    unprefixedPointerEvents = function () {
			return !!w.PointerEvent;
		}(),
		    toggleMenuClasses = function toggleMenuClasses($menu, o, add) {
			var classes = c.menuClass,
			    method;
			if (o.cssArrows) {
				classes += ' ' + c.menuArrowClass;
			}
			method = add ? 'addClass' : 'removeClass';
			$menu[method](classes);
		},
		    setPathToCurrent = function setPathToCurrent($menu, o) {
			return $menu.find('li.' + o.pathClass).slice(0, o.pathLevels).addClass(o.hoverClass + ' ' + c.bcClass).filter(function () {
				return $(this).children(o.popUpSelector).hide().show().length;
			}).removeClass(o.pathClass);
		},
		    toggleAnchorClass = function toggleAnchorClass($li, add) {
			var method = add ? 'addClass' : 'removeClass';
			$li.children('a')[method](c.anchorClass);
		},
		    toggleTouchAction = function toggleTouchAction($menu) {
			var msTouchAction = $menu.css('ms-touch-action');
			var touchAction = $menu.css('touch-action');
			touchAction = touchAction || msTouchAction;
			touchAction = touchAction === 'pan-y' ? 'auto' : 'pan-y';
			$menu.css({
				'ms-touch-action': touchAction,
				'touch-action': touchAction
			});
		},
		    getMenu = function getMenu($el) {
			return $el.closest('.' + c.menuClass);
		},
		    getOptions = function getOptions($el) {
			return getMenu($el).data('sfOptions');
		},
		    over = function over() {
			var $this = $(this),
			    o = getOptions($this);
			clearTimeout(o.sfTimer);
			$this.siblings().superfish('hide').end().superfish('show');
		},
		    close = function close(o) {
			o.retainPath = $.inArray(this[0], o.$path) > -1;
			this.superfish('hide');

			if (!this.parents('.' + o.hoverClass).length) {
				o.onIdle.call(getMenu(this));
				if (o.$path.length) {
					$.proxy(over, o.$path)();
				}
			}
		},
		    out = function out() {
			var $this = $(this),
			    o = getOptions($this);
			if (ios) {
				$.proxy(close, $this, o)();
			} else {
				clearTimeout(o.sfTimer);
				o.sfTimer = setTimeout($.proxy(close, $this, o), o.delay);
			}
		},
		    touchHandler = function touchHandler(e) {
			var $this = $(this),
			    o = getOptions($this),
			    $ul = $this.siblings(e.data.popUpSelector);

			if (o.onHandleTouch.call($ul) === false) {
				return this;
			}

			if ($ul.length > 0 && $ul.is(':hidden')) {
				//$this.one('click.superfish', false);
				if (e.type === 'MSPointerDown' || e.type === 'pointerdown') {
					$this.trigger('focus');
				} else {
					$.proxy(over, $this.parent('li'))();
				}
			}
		},
		    applyHandlers = function applyHandlers($menu, o) {
			var targets = 'li:has(' + o.popUpSelector + ')';
			if ($.fn.hoverIntent && !o.disableHI) {
				$menu.hoverIntent(over, out, targets);
			} else {
				$menu.on('mouseenter.superfish', targets, over).on('mouseleave.superfish', targets, out);
			}
			var touchevent = 'MSPointerDown.superfish';
			if (unprefixedPointerEvents) {
				touchevent = 'pointerdown.superfish';
			}
			if (!ios) {
				touchevent += ' touchend.superfish';
			}
			if (wp7) {
				touchevent += ' mousedown.superfish';
			}
			$menu
			//.on('focusin.superfish', 'li', over)
			//.on('focusout.superfish', 'li', out)
			.on(touchevent, 'a', o, touchHandler);
		};

		return {
			// public methods
			hide: function hide(instant) {
				if (this.length) {
					var $this = this,
					    o = getOptions($this);
					if (!o) {
						return this;
					}
					var not = o.retainPath === true ? o.$path : '',
					    $ul = $this.find('li.' + o.hoverClass).add(this).not(not).removeClass(o.hoverClass).children(o.popUpSelector),
					    speed = o.speedOut;

					if (instant) {
						$ul.show();
						speed = 0;
					}
					o.retainPath = false;

					if (o.onBeforeHide.call($ul) === false) {
						return this;
					}

					$ul.stop(true, true).animate(o.animationOut, speed, function () {
						var $this = $(this);
						o.onHide.call($this);
					});
				}
				return this;
			},
			show: function show() {
				var o = getOptions(this);
				if (!o) {
					return this;
				}
				var $this = this.addClass(o.hoverClass),
				    $ul = $this.children(o.popUpSelector);

				if (o.onBeforeShow.call($ul) === false) {
					return this;
				}

				$ul.stop(true, true).animate(o.animation, o.speed, function () {
					o.onShow.call($ul);
				});
				return this;
			},
			destroy: function destroy() {
				return this.each(function () {
					var $this = $(this),
					    o = $this.data('sfOptions'),
					    $hasPopUp;
					if (!o) {
						return false;
					}
					$hasPopUp = $this.find(o.popUpSelector).parent('li');
					clearTimeout(o.sfTimer);
					toggleMenuClasses($this, o);
					toggleAnchorClass($hasPopUp);
					toggleTouchAction($this);
					// remove event handlers
					$this.off('.superfish').off('.hoverIntent');
					// clear animation's inline display style
					$hasPopUp.children(o.popUpSelector).attr('style', function (i, style) {
						return style.replace(/display[^;]+;?/g, '');
					});
					// reset 'current' path classes
					o.$path.removeClass(o.hoverClass + ' ' + c.bcClass).addClass(o.pathClass);
					$this.find('.' + o.hoverClass).removeClass(o.hoverClass);
					o.onDestroy.call($this);
					$this.removeData('sfOptions');
				});
			},
			init: function init(op) {
				return this.each(function () {
					var $this = $(this);
					if ($this.data('sfOptions')) {
						return false;
					}
					var o = $.extend({}, $.fn.superfish.defaults, op),
					    $hasPopUp = $this.find(o.popUpSelector).parent('li');
					o.$path = setPathToCurrent($this, o);

					$this.data('sfOptions', o);

					toggleMenuClasses($this, o, true);
					toggleAnchorClass($hasPopUp, true);
					toggleTouchAction($this);
					applyHandlers($this, o);

					$hasPopUp.not('.' + c.bcClass).superfish('hide', true);

					o.onInit.call(this);
				});
			}
		};
	}();

	$.fn.superfish = function (method, args) {
		if (methods[method]) {
			return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
		} else if ((typeof method === "undefined" ? "undefined" : _typeof(method)) === 'object' || !method) {
			return methods.init.apply(this, arguments);
		} else {
			return $.error('Method ' + method + ' does not exist on jQuery.fn.superfish');
		}
	};

	$.fn.superfish.defaults = {
		popUpSelector: 'ul,.sf-mega', // within menu context
		hoverClass: 'sfHover',
		pathClass: 'overrideThisToUse',
		pathLevels: 1,
		delay: 800,
		animation: { opacity: 'show' },
		animationOut: { opacity: 'hide' },
		speed: 'normal',
		speedOut: 'fast',
		cssArrows: true,
		disableHI: false,
		onInit: $.noop,
		onBeforeShow: $.noop,
		onShow: $.noop,
		onBeforeHide: $.noop,
		onHide: $.noop,
		onIdle: $.noop,
		onDestroy: $.noop,
		onHandleTouch: $.noop
	};
})(jQuery, window);

/***/ }),
/* 9 */,
/* 10 */,
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _thin = __webpack_require__(37);

var _thin2 = _interopRequireDefault(_thin);

var _wide = __webpack_require__(38);

var _wide2 = _interopRequireDefault(_wide);

var _news = __webpack_require__(46);

var _news2 = _interopRequireDefault(_news);

var _servicesSlider = __webpack_require__(47);

var _servicesSlider2 = _interopRequireDefault(_servicesSlider);

var _boxesSlider = __webpack_require__(45);

var _boxesSlider2 = _interopRequireDefault(_boxesSlider);

var _tables = __webpack_require__(41);

var _tables2 = _interopRequireDefault(_tables);

var _checkboxes = __webpack_require__(39);

var _checkboxes2 = _interopRequireDefault(_checkboxes);

var _url = __webpack_require__(42);

var _url2 = _interopRequireDefault(_url);

var _collapse = __webpack_require__(40);

var _collapse2 = _interopRequireDefault(_collapse);

var _creditCard = __webpack_require__(35);

var _tabslider = __webpack_require__(43);

var _tabslider2 = _interopRequireDefault(_tabslider);

var _checkCollapse = __webpack_require__(34);

var _checkCollapse2 = _interopRequireDefault(_checkCollapse);

var _filesUpload = __webpack_require__(36);

var _filesUpload2 = _interopRequireDefault(_filesUpload);

var _boxes = __webpack_require__(33);

var _boxes2 = _interopRequireDefault(_boxes);

var _isMobile = __webpack_require__(44);

var _isMobile2 = _interopRequireDefault(_isMobile);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

$.fn.extend({
    clickOutside: function clickOutside(callback) {
        var that = this;
        $(document).click(function (event) {
            if (!$(event.target).closest(that).length) {
                callback();
            }
        });
    }
});

$.fn.clickOff = function (callback, selfDestroy) {
    var clicked = false;
    var parent = this;
    var destroy = selfDestroy || true;

    parent.click(function () {
        clicked = true;
    });

    $(document).click(function (event) {
        if (!clicked) {
            callback(parent, event);
        }
        if (destroy) {
            //parent.clickOff = function() {};
            //parent.off("click");
            //$(document).off("click");
            //parent.off("clickOff");
        }
        clicked = false;
    });
};
$ = window.jQuery;

//navigations


//widgets


//tables


//other


//import chart from './components/charts.js';


(0, _filesUpload2.default)();
_thin2.default.init();
_wide2.default.init();
_tables2.default.init();

$('[data-toggle=collapse]').on('click', _checkCollapse2.default);
(0, _creditCard.billingInfo)();

_tabslider2.default.init();
//init

/***/ }),
/* 12 */,
/* 13 */,
/* 14 */,
/* 15 */,
/* 16 */,
/* 17 */,
/* 18 */,
/* 19 */,
/* 20 */,
/* 21 */,
/* 22 */,
/* 23 */,
/* 24 */,
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

// Generated by CoffeeScript 1.10.0
(function () {
  var Card,
      QJ,
      extend,
      payment,
      bind = function bind(fn, me) {
    return function () {
      return fn.apply(me, arguments);
    };
  };

  __webpack_require__(55);

  QJ = __webpack_require__(5);

  payment = __webpack_require__(31);

  extend = __webpack_require__(29);

  Card = function () {
    var bindVal;

    Card.prototype.initializedDataAttr = "data-jp-card-initialized";

    Card.prototype.cardTemplate = '' + '<div class="jp-card-container">' + '<div class="jp-card">' + '<div class="jp-card-front">' + '<div class="jp-card-logo jp-card-elo">' + '<div class="e">e</div>' + '<div class="l">l</div>' + '<div class="o">o</div>' + '</div>' + '<div class="jp-card-logo jp-card-visa">visa</div>' + '<div class="jp-card-logo jp-card-mastercard">MasterCard</div>' + '<div class="jp-card-logo jp-card-maestro">Maestro</div>' + '<div class="jp-card-logo jp-card-amex"></div>' + '<div class="jp-card-logo jp-card-discover">discover</div>' + '<div class="jp-card-logo jp-card-dinersclub"></div>' + '<div class="jp-card-logo jp-card-dankort"><div class="dk"><div class="d"></div><div class="k"></div></div></div>' + '<div class="jp-card-lower">' + '<div class="jp-card-shiny"></div>' + '<div class="jp-card-cvc jp-card-display">{{cvc}}</div>' + '<div class="jp-card-number jp-card-display">{{number}}</div>' + '<div class="jp-card-name jp-card-display">{{name}}</div>' + '<div class="jp-card-expiry jp-card-display" data-before="{{monthYear}}" data-after="{{validDate}}">{{expiry}}</div>' + '</div>' + '</div>' + '<div class="jp-card-back">' + '<div class="jp-card-bar"></div>' + '<div class="jp-card-cvc jp-card-display">{{cvc}}</div>' + '<div class="jp-card-shiny"></div>' + '</div>' + '</div>' + '</div>';

    Card.prototype.template = function (tpl, data) {
      return tpl.replace(/\{\{(.*?)\}\}/g, function (match, key, str) {
        return data[key];
      });
    };

    Card.prototype.cardTypes = ['jp-card-amex', 'jp-card-dankort', 'jp-card-dinersclub', 'jp-card-discover', 'jp-card-jcb', 'jp-card-laser', 'jp-card-maestro', 'jp-card-mastercard', 'jp-card-unionpay', 'jp-card-visa', 'jp-card-visaelectron', 'jp-card-elo'];

    Card.prototype.defaults = {
      formatting: true,
      formSelectors: {
        numberInput: 'input[name="number"]',
        expiryInput: 'input[name="expiry"]',
        cvcInput: 'input[name="cvc"]',
        nameInput: 'input[name="name"]'
      },
      cardSelectors: {
        cardContainer: '.jp-card-container',
        card: '.jp-card',
        numberDisplay: '.jp-card-number',
        expiryDisplay: '.jp-card-expiry',
        cvcDisplay: '.jp-card-cvc',
        nameDisplay: '.jp-card-name'
      },
      messages: {
        validDate: 'valid\nthru',
        monthYear: 'month/year'
      },
      placeholders: {
        number: '&bull;&bull;&bull;&bull; &bull;&bull;&bull;&bull; &bull;&bull;&bull;&bull; &bull;&bull;&bull;&bull;',
        cvc: '&bull;&bull;&bull;',
        expiry: '&bull;&bull;/&bull;&bull;',
        name: 'Full Name'
      },
      masks: {
        cardNumber: false
      },
      classes: {
        valid: 'jp-card-valid',
        invalid: 'jp-card-invalid'
      },
      debug: false
    };

    function Card(opts) {
      this.maskCardNumber = bind(this.maskCardNumber, this);
      var toInitialize;
      this.options = extend(true, this.defaults, opts);
      if (!this.options.form) {
        console.log("Please provide a form");
        return;
      }
      this.$el = QJ(this.options.form);
      if (!this.options.container) {
        console.log("Please provide a container");
        return;
      }
      this.$container = QJ(this.options.container);
      toInitialize = QJ.isDOMElement(this.$container) ? this.$container : this.$container[0];
      if (toInitialize.getAttribute(this.initializedDataAttr)) {
        return;
      }
      toInitialize.setAttribute(this.initializedDataAttr, true);
      this.render();
      this.attachHandlers();
      this.handleInitialPlaceholders();
    }

    Card.prototype.render = function () {
      var $cardContainer, baseWidth, name, obj, ref, ref1, selector, ua;
      QJ.append(this.$container, this.template(this.cardTemplate, extend({}, this.options.messages, this.options.placeholders)));
      ref = this.options.cardSelectors;
      for (name in ref) {
        selector = ref[name];
        this["$" + name] = QJ.find(this.$container, selector);
      }
      ref1 = this.options.formSelectors;
      for (name in ref1) {
        selector = ref1[name];
        selector = this.options[name] ? this.options[name] : selector;
        obj = QJ.find(this.$el, selector);
        if (!obj.length && this.options.debug) {
          console.error("Card can't find a " + name + " in your form.");
        }
        this["$" + name] = obj;
      }
      if (this.options.formatting) {
        Payment.formatCardNumber(this.$numberInput);
        Payment.formatCardCVC(this.$cvcInput);
        Payment.formatCardExpiry(this.$expiryInput);
      }
      if (this.options.width) {
        $cardContainer = QJ(this.options.cardSelectors.cardContainer)[0];
        baseWidth = parseInt($cardContainer.clientWidth || window.getComputedStyle($cardContainer).width);
        $cardContainer.style.transform = "scale(" + this.options.width / baseWidth + ")";
      }
      if (typeof navigator !== "undefined" && navigator !== null ? navigator.userAgent : void 0) {
        ua = navigator.userAgent.toLowerCase();
        if (ua.indexOf('safari') !== -1 && ua.indexOf('chrome') === -1) {
          QJ.addClass(this.$card, 'jp-card-safari');
        }
      }
      if (/MSIE 10\./i.test(navigator.userAgent)) {
        QJ.addClass(this.$card, 'jp-card-ie-10');
      }
      if (/rv:11.0/i.test(navigator.userAgent)) {
        return QJ.addClass(this.$card, 'jp-card-ie-11');
      }
    };

    Card.prototype.attachHandlers = function () {
      var expiryFilters, numberInputFilters;
      numberInputFilters = [this.validToggler('cardNumber')];
      if (this.options.masks.cardNumber) {
        numberInputFilters.push(this.maskCardNumber);
      }
      bindVal(this.$numberInput, this.$numberDisplay, {
        fill: false,
        filters: numberInputFilters
      });
      QJ.on(this.$numberInput, 'payment.cardType', this.handle('setCardType'));
      expiryFilters = [function (val) {
        return val.replace(/(\s+)/g, '');
      }];
      expiryFilters.push(this.validToggler('cardExpiry'));
      bindVal(this.$expiryInput, this.$expiryDisplay, {
        join: function join(text) {
          if (text[0].length === 2 || text[1]) {
            return "/";
          } else {
            return "";
          }
        },
        filters: expiryFilters
      });
      bindVal(this.$cvcInput, this.$cvcDisplay, {
        filters: this.validToggler('cardCVC')
      });
      QJ.on(this.$cvcInput, 'focus', this.handle('flipCard'));
      QJ.on(this.$cvcInput, 'blur', this.handle('unflipCard'));
      return bindVal(this.$nameInput, this.$nameDisplay, {
        fill: false,
        filters: this.validToggler('cardHolderName'),
        join: ' '
      });
    };

    Card.prototype.handleInitialPlaceholders = function () {
      var el, name, ref, results, selector;
      ref = this.options.formSelectors;
      results = [];
      for (name in ref) {
        selector = ref[name];
        el = this["$" + name];
        if (QJ.val(el)) {
          QJ.trigger(el, 'paste');
          results.push(setTimeout(function () {
            return QJ.trigger(el, 'keyup');
          }));
        } else {
          results.push(void 0);
        }
      }
      return results;
    };

    Card.prototype.handle = function (fn) {
      return function (_this) {
        return function (e) {
          var args;
          args = Array.prototype.slice.call(arguments);
          args.unshift(e.target);
          return _this.handlers[fn].apply(_this, args);
        };
      }(this);
    };

    Card.prototype.validToggler = function (validatorName) {
      var isValid;
      if (validatorName === "cardExpiry") {
        isValid = function isValid(val) {
          var objVal;
          objVal = Payment.fns.cardExpiryVal(val);
          return Payment.fns.validateCardExpiry(objVal.month, objVal.year);
        };
      } else if (validatorName === "cardCVC") {
        isValid = function (_this) {
          return function (val) {
            return Payment.fns.validateCardCVC(val, _this.cardType);
          };
        }(this);
      } else if (validatorName === "cardNumber") {
        isValid = function isValid(val) {
          return Payment.fns.validateCardNumber(val);
        };
      } else if (validatorName === "cardHolderName") {
        isValid = function isValid(val) {
          return val !== "";
        };
      }
      return function (_this) {
        return function (val, $in, $out) {
          var result;
          result = isValid(val);
          _this.toggleValidClass($in, result);
          _this.toggleValidClass($out, result);
          return val;
        };
      }(this);
    };

    Card.prototype.toggleValidClass = function (el, test) {
      QJ.toggleClass(el, this.options.classes.valid, test);
      return QJ.toggleClass(el, this.options.classes.invalid, !test);
    };

    Card.prototype.maskCardNumber = function (val, el, out) {
      var mask, numbers;
      mask = this.options.masks.cardNumber;
      numbers = val.split(' ');
      if (numbers.length >= 3) {
        numbers.forEach(function (item, idx) {
          if (idx !== numbers.length - 1) {
            return numbers[idx] = numbers[idx].replace(/\d/g, mask);
          }
        });
        return numbers.join(' ');
      } else {
        return val.replace(/\d/g, mask);
      }
    };

    Card.prototype.handlers = {
      setCardType: function setCardType($el, e) {
        var cardType;
        cardType = e.data;
        if (!QJ.hasClass(this.$card, cardType)) {
          QJ.removeClass(this.$card, 'jp-card-unknown');
          QJ.removeClass(this.$card, this.cardTypes.join(' '));
          QJ.addClass(this.$card, "jp-card-" + cardType);
          QJ.toggleClass(this.$card, 'jp-card-identified', cardType !== 'unknown');
          return this.cardType = cardType;
        }
      },
      flipCard: function flipCard() {
        return QJ.addClass(this.$card, 'jp-card-flipped');
      },
      unflipCard: function unflipCard() {
        return QJ.removeClass(this.$card, 'jp-card-flipped');
      }
    };

    bindVal = function bindVal(el, out, opts) {
      var joiner, o, outDefaults;
      if (opts == null) {
        opts = {};
      }
      opts.fill = opts.fill || false;
      opts.filters = opts.filters || [];
      if (!(opts.filters instanceof Array)) {
        opts.filters = [opts.filters];
      }
      opts.join = opts.join || "";
      if (!(typeof opts.join === "function")) {
        joiner = opts.join;
        opts.join = function () {
          return joiner;
        };
      }
      outDefaults = function () {
        var j, len, results;
        results = [];
        for (j = 0, len = out.length; j < len; j++) {
          o = out[j];
          results.push(o.textContent);
        }
        return results;
      }();
      QJ.on(el, 'focus', function () {
        return QJ.addClass(out, 'jp-card-focused');
      });
      QJ.on(el, 'blur', function () {
        return QJ.removeClass(out, 'jp-card-focused');
      });
      QJ.on(el, 'keyup change paste', function (e) {
        var elem, filter, i, j, join, k, len, len1, outEl, outVal, ref, results, val;
        val = function () {
          var j, len, results;
          results = [];
          for (j = 0, len = el.length; j < len; j++) {
            elem = el[j];
            results.push(QJ.val(elem));
          }
          return results;
        }();
        join = opts.join(val);
        val = val.join(join);
        if (val === join) {
          val = "";
        }
        ref = opts.filters;
        for (j = 0, len = ref.length; j < len; j++) {
          filter = ref[j];
          val = filter(val, el, out);
        }
        results = [];
        for (i = k = 0, len1 = out.length; k < len1; i = ++k) {
          outEl = out[i];
          if (opts.fill) {
            outVal = val + outDefaults[i].substring(val.length);
          } else {
            outVal = val || outDefaults[i];
          }
          results.push(outEl.textContent = outVal);
        }
        return results;
      });
      return el;
    };

    return Card;
  }();

  module.exports = Card;

  global.Card = Card;
}).call(undefined);
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(6)))

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function (useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if (item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function (modules, mediaQuery) {
		if (typeof modules === "string") modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for (var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if (typeof id === "number") alreadyImportedModules[id] = true;
		}
		for (i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if (typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if (mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if (mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */';
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/*! Buttons for DataTables 1.3.1
 * ©2016 SpryMedia Ltd - datatables.net/license
 */

(function (factory) {
	if (true) {
		// AMD
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(0), __webpack_require__(4)], __WEBPACK_AMD_DEFINE_RESULT__ = function ($) {
			return factory($, window, document);
		}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else if ((typeof exports === 'undefined' ? 'undefined' : _typeof(exports)) === 'object') {
		// CommonJS
		module.exports = function (root, $) {
			if (!root) {
				root = window;
			}

			if (!$ || !$.fn.dataTable) {
				$ = require('datatables.net')(root, $).$;
			}

			return factory($, root, root.document);
		};
	} else {
		// Browser
		factory(jQuery, window, document);
	}
})(function ($, window, document, undefined) {
	'use strict';

	var DataTable = $.fn.dataTable;

	// Used for namespacing events added to the document by each instance, so they
	// can be removed on destroy
	var _instCounter = 0;

	// Button namespacing counter for namespacing events on individual buttons
	var _buttonCounter = 0;

	var _dtButtons = DataTable.ext.buttons;

	/**
  * [Buttons description]
  * @param {[type]}
  * @param {[type]}
  */
	var Buttons = function Buttons(dt, config) {
		// If there is no config set it to an empty object
		if (typeof config === 'undefined') {
			config = {};
		}

		// Allow a boolean true for defaults
		if (config === true) {
			config = {};
		}

		// For easy configuration of buttons an array can be given
		if ($.isArray(config)) {
			config = { buttons: config };
		}

		this.c = $.extend(true, {}, Buttons.defaults, config);

		// Don't want a deep copy for the buttons
		if (config.buttons) {
			this.c.buttons = config.buttons;
		}

		this.s = {
			dt: new DataTable.Api(dt),
			buttons: [],
			listenKeys: '',
			namespace: 'dtb' + _instCounter++
		};

		this.dom = {
			container: $('<' + this.c.dom.container.tag + '/>').addClass(this.c.dom.container.className)
		};

		this._constructor();
	};

	$.extend(Buttons.prototype, {
		/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * Public methods
   */

		/**
   * Get the action of a button
   * @param  {int|string} Button index
   * @return {function}
   */ /**
      * Set the action of a button
      * @param  {node} node Button element
      * @param  {function} action Function to set
      * @return {Buttons} Self for chaining
      */
		action: function action(node, _action) {
			var button = this._nodeToButton(node);

			if (_action === undefined) {
				return button.conf.action;
			}

			button.conf.action = _action;

			return this;
		},

		/**
   * Add an active class to the button to make to look active or get current
   * active state.
   * @param  {node} node Button element
   * @param  {boolean} [flag] Enable / disable flag
   * @return {Buttons} Self for chaining or boolean for getter
   */
		active: function active(node, flag) {
			var button = this._nodeToButton(node);
			var klass = this.c.dom.button.active;
			var jqNode = $(button.node);

			if (flag === undefined) {
				return jqNode.hasClass(klass);
			}

			jqNode.toggleClass(klass, flag === undefined ? true : flag);

			return this;
		},

		/**
   * Add a new button
   * @param {object} config Button configuration object, base string name or function
   * @param {int|string} [idx] Button index for where to insert the button
   * @return {Buttons} Self for chaining
   */
		add: function add(config, idx) {
			var buttons = this.s.buttons;

			if (typeof idx === 'string') {
				var split = idx.split('-');
				var base = this.s;

				for (var i = 0, ien = split.length - 1; i < ien; i++) {
					base = base.buttons[split[i] * 1];
				}

				buttons = base.buttons;
				idx = split[split.length - 1] * 1;
			}

			this._expandButton(buttons, config, false, idx);
			this._draw();

			return this;
		},

		/**
   * Get the container node for the buttons
   * @return {jQuery} Buttons node
   */
		container: function container() {
			return this.dom.container;
		},

		/**
   * Disable a button
   * @param  {node} node Button node
   * @return {Buttons} Self for chaining
   */
		disable: function disable(node) {
			var button = this._nodeToButton(node);

			$(button.node).addClass(this.c.dom.button.disabled);

			return this;
		},

		/**
   * Destroy the instance, cleaning up event handlers and removing DOM
   * elements
   * @return {Buttons} Self for chaining
   */
		destroy: function destroy() {
			// Key event listener
			$('body').off('keyup.' + this.s.namespace);

			// Individual button destroy (so they can remove their own events if
			// needed). Take a copy as the array is modified by `remove`
			var buttons = this.s.buttons.slice();
			var i, ien;

			for (i = 0, ien = buttons.length; i < ien; i++) {
				this.remove(buttons[i].node);
			}

			// Container
			this.dom.container.remove();

			// Remove from the settings object collection
			var buttonInsts = this.s.dt.settings()[0];

			for (i = 0, ien = buttonInsts.length; i < ien; i++) {
				if (buttonInsts.inst === this) {
					buttonInsts.splice(i, 1);
					break;
				}
			}

			return this;
		},

		/**
   * Enable / disable a button
   * @param  {node} node Button node
   * @param  {boolean} [flag=true] Enable / disable flag
   * @return {Buttons} Self for chaining
   */
		enable: function enable(node, flag) {
			if (flag === false) {
				return this.disable(node);
			}

			var button = this._nodeToButton(node);
			$(button.node).removeClass(this.c.dom.button.disabled);

			return this;
		},

		/**
   * Get the instance name for the button set selector
   * @return {string} Instance name
   */
		name: function name() {
			return this.c.name;
		},

		/**
   * Get a button's node
   * @param  {node} node Button node
   * @return {jQuery} Button element
   */
		node: function node(_node) {
			var button = this._nodeToButton(_node);
			return $(button.node);
		},

		/**
   * Set / get a processing class on the selected button
   * @param  {boolean} flag true to add, false to remove, undefined to get
   * @return {boolean|Buttons} Getter value or this if a setter.
   */
		processing: function processing(node, flag) {
			var button = this._nodeToButton(node);

			if (flag === undefined) {
				return $(button.node).hasClass('processing');
			}

			$(button.node).toggleClass('processing', flag);

			return this;
		},

		/**
   * Remove a button.
   * @param  {node} node Button node
   * @return {Buttons} Self for chaining
   */
		remove: function remove(node) {
			var button = this._nodeToButton(node);
			var host = this._nodeToHost(node);
			var dt = this.s.dt;

			// Remove any child buttons first
			if (button.buttons.length) {
				for (var i = button.buttons.length - 1; i >= 0; i--) {
					this.remove(button.buttons[i].node);
				}
			}

			// Allow the button to remove event handlers, etc
			if (button.conf.destroy) {
				button.conf.destroy.call(dt.button(node), dt, $(node), button.conf);
			}

			this._removeKey(button.conf);

			$(button.node).remove();

			var idx = $.inArray(button, host);
			host.splice(idx, 1);

			return this;
		},

		/**
   * Get the text for a button
   * @param  {int|string} node Button index
   * @return {string} Button text
   */ /**
      * Set the text for a button
      * @param  {int|string|function} node Button index
      * @param  {string} label Text
      * @return {Buttons} Self for chaining
      */
		text: function text(node, label) {
			var button = this._nodeToButton(node);
			var buttonLiner = this.c.dom.collection.buttonLiner;
			var linerTag = button.inCollection && buttonLiner && buttonLiner.tag ? buttonLiner.tag : this.c.dom.buttonLiner.tag;
			var dt = this.s.dt;
			var jqNode = $(button.node);
			var text = function text(opt) {
				return typeof opt === 'function' ? opt(dt, jqNode, button.conf) : opt;
			};

			if (label === undefined) {
				return text(button.conf.text);
			}

			button.conf.text = label;

			if (linerTag) {
				jqNode.children(linerTag).html(text(label));
			} else {
				jqNode.html(text(label));
			}

			return this;
		},

		/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * Constructor
   */

		/**
   * Buttons constructor
   * @private
   */
		_constructor: function _constructor() {
			var that = this;
			var dt = this.s.dt;
			var dtSettings = dt.settings()[0];
			var buttons = this.c.buttons;

			if (!dtSettings._buttons) {
				dtSettings._buttons = [];
			}

			dtSettings._buttons.push({
				inst: this,
				name: this.c.name
			});

			for (var i = 0, ien = buttons.length; i < ien; i++) {
				this.add(buttons[i]);
			}

			dt.on('destroy', function () {
				that.destroy();
			});

			// Global key event binding to listen for button keys
			$('body').on('keyup.' + this.s.namespace, function (e) {
				if (!document.activeElement || document.activeElement === document.body) {
					// SUse a string of characters for fast lookup of if we need to
					// handle this
					var character = String.fromCharCode(e.keyCode).toLowerCase();

					if (that.s.listenKeys.toLowerCase().indexOf(character) !== -1) {
						that._keypress(character, e);
					}
				}
			});
		},

		/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
   * Private methods
   */

		/**
   * Add a new button to the key press listener
   * @param {object} conf Resolved button configuration object
   * @private
   */
		_addKey: function _addKey(conf) {
			if (conf.key) {
				this.s.listenKeys += $.isPlainObject(conf.key) ? conf.key.key : conf.key;
			}
		},

		/**
   * Insert the buttons into the container. Call without parameters!
   * @param  {node} [container] Recursive only - Insert point
   * @param  {array} [buttons] Recursive only - Buttons array
   * @private
   */
		_draw: function _draw(container, buttons) {
			if (!container) {
				container = this.dom.container;
				buttons = this.s.buttons;
			}

			container.children().detach();

			for (var i = 0, ien = buttons.length; i < ien; i++) {
				container.append(buttons[i].inserter);

				if (buttons[i].buttons && buttons[i].buttons.length) {
					this._draw(buttons[i].collection, buttons[i].buttons);
				}
			}
		},

		/**
   * Create buttons from an array of buttons
   * @param  {array} attachTo Buttons array to attach to
   * @param  {object} button Button definition
   * @param  {boolean} inCollection true if the button is in a collection
   * @private
   */
		_expandButton: function _expandButton(attachTo, button, inCollection, attachPoint) {
			var dt = this.s.dt;
			var buttonCounter = 0;
			var buttons = !$.isArray(button) ? [button] : button;

			for (var i = 0, ien = buttons.length; i < ien; i++) {
				var conf = this._resolveExtends(buttons[i]);

				if (!conf) {
					continue;
				}

				// If the configuration is an array, then expand the buttons at this
				// point
				if ($.isArray(conf)) {
					this._expandButton(attachTo, conf, inCollection, attachPoint);
					continue;
				}

				var built = this._buildButton(conf, inCollection);
				if (!built) {
					continue;
				}

				if (attachPoint !== undefined) {
					attachTo.splice(attachPoint, 0, built);
					attachPoint++;
				} else {
					attachTo.push(built);
				}

				if (built.conf.buttons) {
					var collectionDom = this.c.dom.collection;
					built.collection = $('<' + collectionDom.tag + '/>').addClass(collectionDom.className).attr('role', 'menu');
					built.conf._collection = built.collection;

					this._expandButton(built.buttons, built.conf.buttons, true, attachPoint);
				}

				// init call is made here, rather than buildButton as it needs to
				// be selectable, and for that it needs to be in the buttons array
				if (conf.init) {
					conf.init.call(dt.button(built.node), dt, $(built.node), conf);
				}

				buttonCounter++;
			}
		},

		/**
   * Create an individual button
   * @param  {object} config            Resolved button configuration
   * @param  {boolean} inCollection `true` if a collection button
   * @return {jQuery} Created button node (jQuery)
   * @private
   */
		_buildButton: function _buildButton(config, inCollection) {
			var buttonDom = this.c.dom.button;
			var linerDom = this.c.dom.buttonLiner;
			var collectionDom = this.c.dom.collection;
			var dt = this.s.dt;
			var text = function text(opt) {
				return typeof opt === 'function' ? opt(dt, button, config) : opt;
			};

			if (inCollection && collectionDom.button) {
				buttonDom = collectionDom.button;
			}

			if (inCollection && collectionDom.buttonLiner) {
				linerDom = collectionDom.buttonLiner;
			}

			// Make sure that the button is available based on whatever requirements
			// it has. For example, Flash buttons require Flash
			if (config.available && !config.available(dt, config)) {
				return false;
			}

			var action = function action(e, dt, button, config) {
				config.action.call(dt.button(button), e, dt, button, config);

				$(dt.table().node()).triggerHandler('buttons-action.dt', [dt.button(button), dt, button, config]);
			};

			var button = $('<' + buttonDom.tag + '/>').addClass(buttonDom.className).attr('tabindex', this.s.dt.settings()[0].iTabIndex).attr('aria-controls', this.s.dt.table().node().id).on('click.dtb', function (e) {
				e.preventDefault();

				if (!button.hasClass(buttonDom.disabled) && config.action) {
					action(e, dt, button, config);
				}

				button.blur();
			}).on('keyup.dtb', function (e) {
				if (e.keyCode === 13) {
					if (!button.hasClass(buttonDom.disabled) && config.action) {
						action(e, dt, button, config);
					}
				}
			});

			// Make `a` tags act like a link
			if (buttonDom.tag.toLowerCase() === 'a') {
				button.attr('href', '#');
			}

			if (linerDom.tag) {
				var liner = $('<' + linerDom.tag + '/>').html(text(config.text)).addClass(linerDom.className);

				if (linerDom.tag.toLowerCase() === 'a') {
					liner.attr('href', '#');
				}

				button.append(liner);
			} else {
				button.html(text(config.text));
			}

			if (config.enabled === false) {
				button.addClass(buttonDom.disabled);
			}

			if (config.className) {
				button.addClass(config.className);
			}

			if (config.titleAttr) {
				button.attr('title', text(config.titleAttr));
			}

			if (!config.namespace) {
				config.namespace = '.dt-button-' + _buttonCounter++;
			}

			var buttonContainer = this.c.dom.buttonContainer;
			var inserter;
			if (buttonContainer && buttonContainer.tag) {
				inserter = $('<' + buttonContainer.tag + '/>').addClass(buttonContainer.className).append(button);
			} else {
				inserter = button;
			}

			this._addKey(config);

			return {
				conf: config,
				node: button.get(0),
				inserter: inserter,
				buttons: [],
				inCollection: inCollection,
				collection: null
			};
		},

		/**
   * Get the button object from a node (recursive)
   * @param  {node} node Button node
   * @param  {array} [buttons] Button array, uses base if not defined
   * @return {object} Button object
   * @private
   */
		_nodeToButton: function _nodeToButton(node, buttons) {
			if (!buttons) {
				buttons = this.s.buttons;
			}

			for (var i = 0, ien = buttons.length; i < ien; i++) {
				if (buttons[i].node === node) {
					return buttons[i];
				}

				if (buttons[i].buttons.length) {
					var ret = this._nodeToButton(node, buttons[i].buttons);

					if (ret) {
						return ret;
					}
				}
			}
		},

		/**
   * Get container array for a button from a button node (recursive)
   * @param  {node} node Button node
   * @param  {array} [buttons] Button array, uses base if not defined
   * @return {array} Button's host array
   * @private
   */
		_nodeToHost: function _nodeToHost(node, buttons) {
			if (!buttons) {
				buttons = this.s.buttons;
			}

			for (var i = 0, ien = buttons.length; i < ien; i++) {
				if (buttons[i].node === node) {
					return buttons;
				}

				if (buttons[i].buttons.length) {
					var ret = this._nodeToHost(node, buttons[i].buttons);

					if (ret) {
						return ret;
					}
				}
			}
		},

		/**
   * Handle a key press - determine if any button's key configured matches
   * what was typed and trigger the action if so.
   * @param  {string} character The character pressed
   * @param  {object} e Key event that triggered this call
   * @private
   */
		_keypress: function _keypress(character, e) {
			var run = function run(conf, node) {
				if (!conf.key) {
					return;
				}

				if (conf.key === character) {
					$(node).click();
				} else if ($.isPlainObject(conf.key)) {
					if (conf.key.key !== character) {
						return;
					}

					if (conf.key.shiftKey && !e.shiftKey) {
						return;
					}

					if (conf.key.altKey && !e.altKey) {
						return;
					}

					if (conf.key.ctrlKey && !e.ctrlKey) {
						return;
					}

					if (conf.key.metaKey && !e.metaKey) {
						return;
					}

					// Made it this far - it is good
					$(node).click();
				}
			};

			var recurse = function recurse(a) {
				for (var i = 0, ien = a.length; i < ien; i++) {
					run(a[i].conf, a[i].node);

					if (a[i].buttons.length) {
						recurse(a[i].buttons);
					}
				}
			};

			recurse(this.s.buttons);
		},

		/**
   * Remove a key from the key listener for this instance (to be used when a
   * button is removed)
   * @param  {object} conf Button configuration
   * @private
   */
		_removeKey: function _removeKey(conf) {
			if (conf.key) {
				var character = $.isPlainObject(conf.key) ? conf.key.key : conf.key;

				// Remove only one character, as multiple buttons could have the
				// same listening key
				var a = this.s.listenKeys.split('');
				var idx = $.inArray(character, a);
				a.splice(idx, 1);
				this.s.listenKeys = a.join('');
			}
		},

		/**
   * Resolve a button configuration
   * @param  {string|function|object} conf Button config to resolve
   * @return {object} Button configuration
   * @private
   */
		_resolveExtends: function _resolveExtends(conf) {
			var dt = this.s.dt;
			var i, ien;
			var toConfObject = function toConfObject(base) {
				var loop = 0;

				// Loop until we have resolved to a button configuration, or an
				// array of button configurations (which will be iterated
				// separately)
				while (!$.isPlainObject(base) && !$.isArray(base)) {
					if (base === undefined) {
						return;
					}

					if (typeof base === 'function') {
						base = base(dt, conf);

						if (!base) {
							return false;
						}
					} else if (typeof base === 'string') {
						if (!_dtButtons[base]) {
							throw 'Unknown button type: ' + base;
						}

						base = _dtButtons[base];
					}

					loop++;
					if (loop > 30) {
						// Protect against misconfiguration killing the browser
						throw 'Buttons: Too many iterations';
					}
				}

				return $.isArray(base) ? base : $.extend({}, base);
			};

			conf = toConfObject(conf);

			while (conf && conf.extend) {
				// Use `toConfObject` in case the button definition being extended
				// is itself a string or a function
				if (!_dtButtons[conf.extend]) {
					throw 'Cannot extend unknown button type: ' + conf.extend;
				}

				var objArray = toConfObject(_dtButtons[conf.extend]);
				if ($.isArray(objArray)) {
					return objArray;
				} else if (!objArray) {
					// This is a little brutal as it might be possible to have a
					// valid button without the extend, but if there is no extend
					// then the host button would be acting in an undefined state
					return false;
				}

				// Stash the current class name
				var originalClassName = objArray.className;

				conf = $.extend({}, objArray, conf);

				// The extend will have overwritten the original class name if the
				// `conf` object also assigned a class, but we want to concatenate
				// them so they are list that is combined from all extended buttons
				if (originalClassName && conf.className !== originalClassName) {
					conf.className = originalClassName + ' ' + conf.className;
				}

				// Buttons to be added to a collection  -gives the ability to define
				// if buttons should be added to the start or end of a collection
				var postfixButtons = conf.postfixButtons;
				if (postfixButtons) {
					if (!conf.buttons) {
						conf.buttons = [];
					}

					for (i = 0, ien = postfixButtons.length; i < ien; i++) {
						conf.buttons.push(postfixButtons[i]);
					}

					conf.postfixButtons = null;
				}

				var prefixButtons = conf.prefixButtons;
				if (prefixButtons) {
					if (!conf.buttons) {
						conf.buttons = [];
					}

					for (i = 0, ien = prefixButtons.length; i < ien; i++) {
						conf.buttons.splice(i, 0, prefixButtons[i]);
					}

					conf.prefixButtons = null;
				}

				// Although we want the `conf` object to overwrite almost all of
				// the properties of the object being extended, the `extend`
				// property should come from the object being extended
				conf.extend = objArray.extend;
			}

			return conf;
		}
	});

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  * Statics
  */

	/**
  * Show / hide a background layer behind a collection
  * @param  {boolean} Flag to indicate if the background should be shown or
  *   hidden 
  * @param  {string} Class to assign to the background
  * @static
  */
	Buttons.background = function (show, className, fade) {
		if (fade === undefined) {
			fade = 400;
		}

		if (show) {
			$('<div/>').addClass(className).css('display', 'none').appendTo('body').fadeIn(fade);
		} else {
			$('body > div.' + className).fadeOut(fade, function () {
				$(this).removeClass(className).remove();
			});
		}
	};

	/**
  * Instance selector - select Buttons instances based on an instance selector
  * value from the buttons assigned to a DataTable. This is only useful if
  * multiple instances are attached to a DataTable.
  * @param  {string|int|array} Instance selector - see `instance-selector`
  *   documentation on the DataTables site
  * @param  {array} Button instance array that was attached to the DataTables
  *   settings object
  * @return {array} Buttons instances
  * @static
  */
	Buttons.instanceSelector = function (group, buttons) {
		if (!group) {
			return $.map(buttons, function (v) {
				return v.inst;
			});
		}

		var ret = [];
		var names = $.map(buttons, function (v) {
			return v.name;
		});

		// Flatten the group selector into an array of single options
		var process = function process(input) {
			if ($.isArray(input)) {
				for (var i = 0, ien = input.length; i < ien; i++) {
					process(input[i]);
				}
				return;
			}

			if (typeof input === 'string') {
				if (input.indexOf(',') !== -1) {
					// String selector, list of names
					process(input.split(','));
				} else {
					// String selector individual name
					var idx = $.inArray($.trim(input), names);

					if (idx !== -1) {
						ret.push(buttons[idx].inst);
					}
				}
			} else if (typeof input === 'number') {
				// Index selector
				ret.push(buttons[input].inst);
			}
		};

		process(group);

		return ret;
	};

	/**
  * Button selector - select one or more buttons from a selector input so some
  * operation can be performed on them.
  * @param  {array} Button instances array that the selector should operate on
  * @param  {string|int|node|jQuery|array} Button selector - see
  *   `button-selector` documentation on the DataTables site
  * @return {array} Array of objects containing `inst` and `idx` properties of
  *   the selected buttons so you know which instance each button belongs to.
  * @static
  */
	Buttons.buttonSelector = function (insts, selector) {
		var ret = [];
		var nodeBuilder = function nodeBuilder(a, buttons, baseIdx) {
			var button;
			var idx;

			for (var i = 0, ien = buttons.length; i < ien; i++) {
				button = buttons[i];

				if (button) {
					idx = baseIdx !== undefined ? baseIdx + i : i + '';

					a.push({
						node: button.node,
						name: button.conf.name,
						idx: idx
					});

					if (button.buttons) {
						nodeBuilder(a, button.buttons, idx + '-');
					}
				}
			}
		};

		var run = function run(selector, inst) {
			var i, ien;
			var buttons = [];
			nodeBuilder(buttons, inst.s.buttons);

			var nodes = $.map(buttons, function (v) {
				return v.node;
			});

			if ($.isArray(selector) || selector instanceof $) {
				for (i = 0, ien = selector.length; i < ien; i++) {
					run(selector[i], inst);
				}
				return;
			}

			if (selector === null || selector === undefined || selector === '*') {
				// Select all
				for (i = 0, ien = buttons.length; i < ien; i++) {
					ret.push({
						inst: inst,
						node: buttons[i].node
					});
				}
			} else if (typeof selector === 'number') {
				// Main button index selector
				ret.push({
					inst: inst,
					node: inst.s.buttons[selector].node
				});
			} else if (typeof selector === 'string') {
				if (selector.indexOf(',') !== -1) {
					// Split
					var a = selector.split(',');

					for (i = 0, ien = a.length; i < ien; i++) {
						run($.trim(a[i]), inst);
					}
				} else if (selector.match(/^\d+(\-\d+)*$/)) {
					// Sub-button index selector
					var indexes = $.map(buttons, function (v) {
						return v.idx;
					});

					ret.push({
						inst: inst,
						node: buttons[$.inArray(selector, indexes)].node
					});
				} else if (selector.indexOf(':name') !== -1) {
					// Button name selector
					var name = selector.replace(':name', '');

					for (i = 0, ien = buttons.length; i < ien; i++) {
						if (buttons[i].name === name) {
							ret.push({
								inst: inst,
								node: buttons[i].node
							});
						}
					}
				} else {
					// jQuery selector on the nodes
					$(nodes).filter(selector).each(function () {
						ret.push({
							inst: inst,
							node: this
						});
					});
				}
			} else if ((typeof selector === 'undefined' ? 'undefined' : _typeof(selector)) === 'object' && selector.nodeName) {
				// Node selector
				var idx = $.inArray(selector, nodes);

				if (idx !== -1) {
					ret.push({
						inst: inst,
						node: nodes[idx]
					});
				}
			}
		};

		for (var i = 0, ien = insts.length; i < ien; i++) {
			var inst = insts[i];

			run(selector, inst);
		}

		return ret;
	};

	/**
  * Buttons defaults. For full documentation, please refer to the docs/option
  * directory or the DataTables site.
  * @type {Object}
  * @static
  */
	Buttons.defaults = {
		buttons: ['copy', 'excel', 'csv', 'pdf', 'print'],
		name: 'main',
		tabIndex: 0,
		dom: {
			container: {
				tag: 'div',
				className: 'dt-buttons'
			},
			collection: {
				tag: 'div',
				className: 'dt-button-collection'
			},
			button: {
				tag: 'a',
				className: 'dt-button',
				active: 'active',
				disabled: 'disabled'
			},
			buttonLiner: {
				tag: 'span',
				className: ''
			}
		}
	};

	/**
  * Version information
  * @type {string}
  * @static
  */
	Buttons.version = '1.3.1';

	$.extend(_dtButtons, {
		collection: {
			text: function text(dt) {
				return dt.i18n('buttons.collection', 'Collection');
			},
			className: 'buttons-collection',
			action: function action(e, dt, button, config) {
				var host = button;
				var hostOffset = host.offset();
				var tableContainer = $(dt.table().container());
				var multiLevel = false;

				// Remove any old collection
				if ($('div.dt-button-background').length) {
					multiLevel = $('.dt-button-collection').offset();
					$('body').trigger('click.dtb-collection');
				}

				config._collection.addClass(config.collectionLayout).css('display', 'none').appendTo('body').fadeIn(config.fade);

				var position = config._collection.css('position');

				if (multiLevel && position === 'absolute') {
					config._collection.css({
						top: multiLevel.top,
						left: multiLevel.left
					});
				} else if (position === 'absolute') {
					config._collection.css({
						top: hostOffset.top + host.outerHeight(),
						left: hostOffset.left
					});

					var listRight = hostOffset.left + config._collection.outerWidth();
					var tableRight = tableContainer.offset().left + tableContainer.width();
					if (listRight > tableRight) {
						config._collection.css('left', hostOffset.left - (listRight - tableRight));
					}
				} else {
					// Fix position - centre on screen
					var top = config._collection.height() / 2;
					if (top > $(window).height() / 2) {
						top = $(window).height() / 2;
					}

					config._collection.css('marginTop', top * -1);
				}

				if (config.background) {
					Buttons.background(true, config.backgroundClassName, config.fade);
				}

				// Need to break the 'thread' for the collection button being
				// activated by a click - it would also trigger this event
				setTimeout(function () {
					// This is bonkers, but if we don't have a click listener on the
					// background element, iOS Safari will ignore the body click
					// listener below. An empty function here is all that is
					// required to make it work...
					$('div.dt-button-background').on('click.dtb-collection', function () {});

					$('body').on('click.dtb-collection', function (e) {
						// andSelf is deprecated in jQ1.8, but we want 1.7 compat
						var back = $.fn.addBack ? 'addBack' : 'andSelf';

						if (!$(e.target).parents()[back]().filter(config._collection).length) {
							config._collection.fadeOut(config.fade, function () {
								config._collection.detach();
							});

							$('div.dt-button-background').off('click.dtb-collection');
							Buttons.background(false, config.backgroundClassName, config.fade);

							$('body').off('click.dtb-collection');
							dt.off('buttons-action.b-internal');
						}
					});
				}, 10);

				if (config.autoClose) {
					dt.on('buttons-action.b-internal', function () {
						$('div.dt-button-background').click();
					});
				}
			},
			background: true,
			collectionLayout: '',
			backgroundClassName: 'dt-button-background',
			autoClose: false,
			fade: 400
		},
		copy: function copy(dt, conf) {
			if (_dtButtons.copyHtml5) {
				return 'copyHtml5';
			}
			if (_dtButtons.copyFlash && _dtButtons.copyFlash.available(dt, conf)) {
				return 'copyFlash';
			}
		},
		csv: function csv(dt, conf) {
			// Common option that will use the HTML5 or Flash export buttons
			if (_dtButtons.csvHtml5 && _dtButtons.csvHtml5.available(dt, conf)) {
				return 'csvHtml5';
			}
			if (_dtButtons.csvFlash && _dtButtons.csvFlash.available(dt, conf)) {
				return 'csvFlash';
			}
		},
		excel: function excel(dt, conf) {
			// Common option that will use the HTML5 or Flash export buttons
			if (_dtButtons.excelHtml5 && _dtButtons.excelHtml5.available(dt, conf)) {
				return 'excelHtml5';
			}
			if (_dtButtons.excelFlash && _dtButtons.excelFlash.available(dt, conf)) {
				return 'excelFlash';
			}
		},
		pdf: function pdf(dt, conf) {
			// Common option that will use the HTML5 or Flash export buttons
			if (_dtButtons.pdfHtml5 && _dtButtons.pdfHtml5.available(dt, conf)) {
				return 'pdfHtml5';
			}
			if (_dtButtons.pdfFlash && _dtButtons.pdfFlash.available(dt, conf)) {
				return 'pdfFlash';
			}
		},
		pageLength: function pageLength(dt) {
			var lengthMenu = dt.settings()[0].aLengthMenu;
			var vals = $.isArray(lengthMenu[0]) ? lengthMenu[0] : lengthMenu;
			var lang = $.isArray(lengthMenu[0]) ? lengthMenu[1] : lengthMenu;
			var text = function text(dt) {
				return dt.i18n('buttons.pageLength', {
					"-1": 'Show all rows',
					_: 'Show %d rows'
				}, dt.page.len());
			};

			return {
				extend: 'collection',
				text: text,
				className: 'buttons-page-length',
				autoClose: true,
				buttons: $.map(vals, function (val, i) {
					return {
						text: lang[i],
						className: 'button-page-length',
						action: function action(e, dt) {
							dt.page.len(val).draw();
						},
						init: function init(dt, node, conf) {
							var that = this;
							var fn = function fn() {
								that.active(dt.page.len() === val);
							};

							dt.on('length.dt' + conf.namespace, fn);
							fn();
						},
						destroy: function destroy(dt, node, conf) {
							dt.off('length.dt' + conf.namespace);
						}
					};
				}),
				init: function init(dt, node, conf) {
					var that = this;
					dt.on('length.dt' + conf.namespace, function () {
						that.text(text(dt));
					});
				},
				destroy: function destroy(dt, node, conf) {
					dt.off('length.dt' + conf.namespace);
				}
			};
		}
	});

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  * DataTables API
  *
  * For complete documentation, please refer to the docs/api directory or the
  * DataTables site
  */

	// Buttons group and individual button selector
	DataTable.Api.register('buttons()', function (group, selector) {
		// Argument shifting
		if (selector === undefined) {
			selector = group;
			group = undefined;
		}

		this.selector.buttonGroup = group;

		var res = this.iterator(true, 'table', function (ctx) {
			if (ctx._buttons) {
				return Buttons.buttonSelector(Buttons.instanceSelector(group, ctx._buttons), selector);
			}
		}, true);

		res._groupSelector = group;
		return res;
	});

	// Individual button selector
	DataTable.Api.register('button()', function (group, selector) {
		// just run buttons() and truncate
		var buttons = this.buttons(group, selector);

		if (buttons.length > 1) {
			buttons.splice(1, buttons.length);
		}

		return buttons;
	});

	// Active buttons
	DataTable.Api.registerPlural('buttons().active()', 'button().active()', function (flag) {
		if (flag === undefined) {
			return this.map(function (set) {
				return set.inst.active(set.node);
			});
		}

		return this.each(function (set) {
			set.inst.active(set.node, flag);
		});
	});

	// Get / set button action
	DataTable.Api.registerPlural('buttons().action()', 'button().action()', function (action) {
		if (action === undefined) {
			return this.map(function (set) {
				return set.inst.action(set.node);
			});
		}

		return this.each(function (set) {
			set.inst.action(set.node, action);
		});
	});

	// Enable / disable buttons
	DataTable.Api.register(['buttons().enable()', 'button().enable()'], function (flag) {
		return this.each(function (set) {
			set.inst.enable(set.node, flag);
		});
	});

	// Disable buttons
	DataTable.Api.register(['buttons().disable()', 'button().disable()'], function () {
		return this.each(function (set) {
			set.inst.disable(set.node);
		});
	});

	// Get button nodes
	DataTable.Api.registerPlural('buttons().nodes()', 'button().node()', function () {
		var jq = $();

		// jQuery will automatically reduce duplicates to a single entry
		$(this.each(function (set) {
			jq = jq.add(set.inst.node(set.node));
		}));

		return jq;
	});

	// Get / set button processing state
	DataTable.Api.registerPlural('buttons().processing()', 'button().processing()', function (flag) {
		if (flag === undefined) {
			return this.map(function (set) {
				return set.inst.processing(set.node);
			});
		}

		return this.each(function (set) {
			set.inst.processing(set.node, flag);
		});
	});

	// Get / set button text (i.e. the button labels)
	DataTable.Api.registerPlural('buttons().text()', 'button().text()', function (label) {
		if (label === undefined) {
			return this.map(function (set) {
				return set.inst.text(set.node);
			});
		}

		return this.each(function (set) {
			set.inst.text(set.node, label);
		});
	});

	// Trigger a button's action
	DataTable.Api.registerPlural('buttons().trigger()', 'button().trigger()', function () {
		return this.each(function (set) {
			set.inst.node(set.node).trigger('click');
		});
	});

	// Get the container elements
	DataTable.Api.registerPlural('buttons().containers()', 'buttons().container()', function () {
		var jq = $();
		var groupSelector = this._groupSelector;

		// We need to use the group selector directly, since if there are no buttons
		// the result set will be empty
		this.iterator(true, 'table', function (ctx) {
			if (ctx._buttons) {
				var insts = Buttons.instanceSelector(groupSelector, ctx._buttons);

				for (var i = 0, ien = insts.length; i < ien; i++) {
					jq = jq.add(insts[i].container());
				}
			}
		});

		return jq;
	});

	// Add a new button
	DataTable.Api.register('button().add()', function (idx, conf) {
		var ctx = this.context;

		// Don't use `this` as it could be empty - select the instances directly
		if (ctx.length) {
			var inst = Buttons.instanceSelector(this._groupSelector, ctx[0]._buttons);

			if (inst.length) {
				inst[0].add(conf, idx);
			}
		}

		return this.button(this._groupSelector, idx);
	});

	// Destroy the button sets selected
	DataTable.Api.register('buttons().destroy()', function () {
		this.pluck('inst').unique().each(function (inst) {
			inst.destroy();
		});

		return this;
	});

	// Remove a button
	DataTable.Api.registerPlural('buttons().remove()', 'buttons().remove()', function () {
		this.each(function (set) {
			set.inst.remove(set.node);
		});

		return this;
	});

	// Information box that can be used by buttons
	var _infoTimer;
	DataTable.Api.register('buttons.info()', function (title, message, time) {
		var that = this;

		if (title === false) {
			$('#datatables_buttons_info').fadeOut(function () {
				$(this).remove();
			});
			clearTimeout(_infoTimer);
			_infoTimer = null;

			return this;
		}

		if (_infoTimer) {
			clearTimeout(_infoTimer);
		}

		if ($('#datatables_buttons_info').length) {
			$('#datatables_buttons_info').remove();
		}

		title = title ? '<h2>' + title + '</h2>' : '';

		$('<div id="datatables_buttons_info" class="dt-button-info"/>').html(title).append($('<div/>')[typeof message === 'string' ? 'html' : 'append'](message)).css('display', 'none').appendTo('body').fadeIn();

		if (time !== undefined && time !== 0) {
			_infoTimer = setTimeout(function () {
				that.buttons.info(false);
			}, time);
		}

		return this;
	});

	// Get data from the table for export - this is common to a number of plug-in
	// buttons so it is included in the Buttons core library
	DataTable.Api.register('buttons.exportData()', function (options) {
		if (this.context.length) {
			return _exportData(new DataTable.Api(this.context[0]), options);
		}
	});

	var _exportTextarea = $('<textarea/>')[0];
	var _exportData = function _exportData(dt, inOpts) {
		var config = $.extend(true, {}, {
			rows: null,
			columns: '',
			modifier: {
				search: 'applied',
				order: 'applied'
			},
			orthogonal: 'display',
			stripHtml: true,
			stripNewlines: true,
			decodeEntities: true,
			trim: true,
			format: {
				header: function header(d) {
					return strip(d);
				},
				footer: function footer(d) {
					return strip(d);
				},
				body: function body(d) {
					return strip(d);
				}
			}
		}, inOpts);

		var strip = function strip(str) {
			if (typeof str !== 'string') {
				return str;
			}

			// Always remove script tags
			str = str.replace(/<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi, '');

			if (config.stripHtml) {
				str = str.replace(/<[^>]*>/g, '');
			}

			if (config.trim) {
				str = str.replace(/^\s+|\s+$/g, '');
			}

			if (config.stripNewlines) {
				str = str.replace(/\n/g, ' ');
			}

			if (config.decodeEntities) {
				_exportTextarea.innerHTML = str;
				str = _exportTextarea.value;
			}

			return str;
		};

		var header = dt.columns(config.columns).indexes().map(function (idx) {
			var el = dt.column(idx).header();
			return config.format.header(el.innerHTML, idx, el);
		}).toArray();

		var footer = dt.table().footer() ? dt.columns(config.columns).indexes().map(function (idx) {
			var el = dt.column(idx).footer();
			return config.format.footer(el ? el.innerHTML : '', idx, el);
		}).toArray() : null;

		var rowIndexes = dt.rows(config.rows, config.modifier).indexes().toArray();
		var selectedCells = dt.cells(rowIndexes, config.columns);
		var cells = selectedCells.render(config.orthogonal).toArray();
		var cellNodes = selectedCells.nodes().toArray();

		var columns = header.length;
		var rows = columns > 0 ? cells.length / columns : 0;
		var body = new Array(rows);
		var cellCounter = 0;

		for (var i = 0, ien = rows; i < ien; i++) {
			var row = new Array(columns);

			for (var j = 0; j < columns; j++) {
				row[j] = config.format.body(cells[cellCounter], i, j, cellNodes[cellCounter]);
				cellCounter++;
			}

			body[i] = row;
		}

		return {
			header: header,
			footer: footer,
			body: body
		};
	};

	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
  * DataTables interface
  */

	// Attach to DataTables objects for global access
	$.fn.dataTable.Buttons = Buttons;
	$.fn.DataTable.Buttons = Buttons;

	// DataTables creation - check if the buttons have been defined for this table,
	// they will have been if the `B` option was used in `dom`, otherwise we should
	// create the buttons instance here so they can be inserted into the document
	// using the API. Listen for `init` for compatibility with pre 1.10.10, but to
	// be removed in future.
	$(document).on('init.dt plugin-init.dt', function (e, settings) {
		if (e.namespace !== 'dt') {
			return;
		}

		var opts = settings.oInit.buttons || DataTable.defaults.buttons;

		if (opts && !settings._buttons) {
			new Buttons(settings, opts).container();
		}
	});

	// DataTables `dom` feature option
	DataTable.ext.feature.push({
		fnInit: function fnInit(settings) {
			var api = new DataTable.Api(settings);
			var opts = api.init().buttons || DataTable.defaults.buttons;

			return new Buttons(api, opts).container();
		},
		cFeature: "B"
	});

	return Buttons;
});

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* globals window, HTMLElement */



/**!
 * is
 * the definitive JavaScript type testing library
 *
 * @copyright 2013-2014 Enrico Marino / Jordan Harband
 * @license MIT
 */

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var objProto = Object.prototype;
var owns = objProto.hasOwnProperty;
var toStr = objProto.toString;
var symbolValueOf;
if (typeof Symbol === 'function') {
  symbolValueOf = Symbol.prototype.valueOf;
}
var isActualNaN = function isActualNaN(value) {
  return value !== value;
};
var NON_HOST_TYPES = {
  'boolean': 1,
  number: 1,
  string: 1,
  undefined: 1
};

var base64Regex = /^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$/;
var hexRegex = /^[A-Fa-f0-9]+$/;

/**
 * Expose `is`
 */

var is = {};

/**
 * Test general.
 */

/**
 * is.type
 * Test if `value` is a type of `type`.
 *
 * @param {Mixed} value value to test
 * @param {String} type type
 * @return {Boolean} true if `value` is a type of `type`, false otherwise
 * @api public
 */

is.a = is.type = function (value, type) {
  return (typeof value === 'undefined' ? 'undefined' : _typeof(value)) === type;
};

/**
 * is.defined
 * Test if `value` is defined.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if 'value' is defined, false otherwise
 * @api public
 */

is.defined = function (value) {
  return typeof value !== 'undefined';
};

/**
 * is.empty
 * Test if `value` is empty.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is empty, false otherwise
 * @api public
 */

is.empty = function (value) {
  var type = toStr.call(value);
  var key;

  if (type === '[object Array]' || type === '[object Arguments]' || type === '[object String]') {
    return value.length === 0;
  }

  if (type === '[object Object]') {
    for (key in value) {
      if (owns.call(value, key)) {
        return false;
      }
    }
    return true;
  }

  return !value;
};

/**
 * is.equal
 * Test if `value` is equal to `other`.
 *
 * @param {Mixed} value value to test
 * @param {Mixed} other value to compare with
 * @return {Boolean} true if `value` is equal to `other`, false otherwise
 */

is.equal = function equal(value, other) {
  if (value === other) {
    return true;
  }

  var type = toStr.call(value);
  var key;

  if (type !== toStr.call(other)) {
    return false;
  }

  if (type === '[object Object]') {
    for (key in value) {
      if (!is.equal(value[key], other[key]) || !(key in other)) {
        return false;
      }
    }
    for (key in other) {
      if (!is.equal(value[key], other[key]) || !(key in value)) {
        return false;
      }
    }
    return true;
  }

  if (type === '[object Array]') {
    key = value.length;
    if (key !== other.length) {
      return false;
    }
    while (key--) {
      if (!is.equal(value[key], other[key])) {
        return false;
      }
    }
    return true;
  }

  if (type === '[object Function]') {
    return value.prototype === other.prototype;
  }

  if (type === '[object Date]') {
    return value.getTime() === other.getTime();
  }

  return false;
};

/**
 * is.hosted
 * Test if `value` is hosted by `host`.
 *
 * @param {Mixed} value to test
 * @param {Mixed} host host to test with
 * @return {Boolean} true if `value` is hosted by `host`, false otherwise
 * @api public
 */

is.hosted = function (value, host) {
  var type = _typeof(host[value]);
  return type === 'object' ? !!host[value] : !NON_HOST_TYPES[type];
};

/**
 * is.instance
 * Test if `value` is an instance of `constructor`.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is an instance of `constructor`
 * @api public
 */

is.instance = is['instanceof'] = function (value, constructor) {
  return value instanceof constructor;
};

/**
 * is.nil / is.null
 * Test if `value` is null.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is null, false otherwise
 * @api public
 */

is.nil = is['null'] = function (value) {
  return value === null;
};

/**
 * is.undef / is.undefined
 * Test if `value` is undefined.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is undefined, false otherwise
 * @api public
 */

is.undef = is.undefined = function (value) {
  return typeof value === 'undefined';
};

/**
 * Test arguments.
 */

/**
 * is.args
 * Test if `value` is an arguments object.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is an arguments object, false otherwise
 * @api public
 */

is.args = is.arguments = function (value) {
  var isStandardArguments = toStr.call(value) === '[object Arguments]';
  var isOldArguments = !is.array(value) && is.arraylike(value) && is.object(value) && is.fn(value.callee);
  return isStandardArguments || isOldArguments;
};

/**
 * Test array.
 */

/**
 * is.array
 * Test if 'value' is an array.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is an array, false otherwise
 * @api public
 */

is.array = Array.isArray || function (value) {
  return toStr.call(value) === '[object Array]';
};

/**
 * is.arguments.empty
 * Test if `value` is an empty arguments object.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is an empty arguments object, false otherwise
 * @api public
 */
is.args.empty = function (value) {
  return is.args(value) && value.length === 0;
};

/**
 * is.array.empty
 * Test if `value` is an empty array.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is an empty array, false otherwise
 * @api public
 */
is.array.empty = function (value) {
  return is.array(value) && value.length === 0;
};

/**
 * is.arraylike
 * Test if `value` is an arraylike object.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is an arguments object, false otherwise
 * @api public
 */

is.arraylike = function (value) {
  return !!value && !is.bool(value) && owns.call(value, 'length') && isFinite(value.length) && is.number(value.length) && value.length >= 0;
};

/**
 * Test boolean.
 */

/**
 * is.bool
 * Test if `value` is a boolean.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is a boolean, false otherwise
 * @api public
 */

is.bool = is['boolean'] = function (value) {
  return toStr.call(value) === '[object Boolean]';
};

/**
 * is.false
 * Test if `value` is false.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is false, false otherwise
 * @api public
 */

is['false'] = function (value) {
  return is.bool(value) && Boolean(Number(value)) === false;
};

/**
 * is.true
 * Test if `value` is true.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is true, false otherwise
 * @api public
 */

is['true'] = function (value) {
  return is.bool(value) && Boolean(Number(value)) === true;
};

/**
 * Test date.
 */

/**
 * is.date
 * Test if `value` is a date.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is a date, false otherwise
 * @api public
 */

is.date = function (value) {
  return toStr.call(value) === '[object Date]';
};

/**
 * is.date.valid
 * Test if `value` is a valid date.
 *
 * @param {Mixed} value value to test
 * @returns {Boolean} true if `value` is a valid date, false otherwise
 */
is.date.valid = function (value) {
  return is.date(value) && !isNaN(Number(value));
};

/**
 * Test element.
 */

/**
 * is.element
 * Test if `value` is an html element.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is an HTML Element, false otherwise
 * @api public
 */

is.element = function (value) {
  return value !== undefined && typeof HTMLElement !== 'undefined' && value instanceof HTMLElement && value.nodeType === 1;
};

/**
 * Test error.
 */

/**
 * is.error
 * Test if `value` is an error object.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is an error object, false otherwise
 * @api public
 */

is.error = function (value) {
  return toStr.call(value) === '[object Error]';
};

/**
 * Test function.
 */

/**
 * is.fn / is.function (deprecated)
 * Test if `value` is a function.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is a function, false otherwise
 * @api public
 */

is.fn = is['function'] = function (value) {
  var isAlert = typeof window !== 'undefined' && value === window.alert;
  if (isAlert) {
    return true;
  }
  var str = toStr.call(value);
  return str === '[object Function]' || str === '[object GeneratorFunction]' || str === '[object AsyncFunction]';
};

/**
 * Test number.
 */

/**
 * is.number
 * Test if `value` is a number.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is a number, false otherwise
 * @api public
 */

is.number = function (value) {
  return toStr.call(value) === '[object Number]';
};

/**
 * is.infinite
 * Test if `value` is positive or negative infinity.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is positive or negative Infinity, false otherwise
 * @api public
 */
is.infinite = function (value) {
  return value === Infinity || value === -Infinity;
};

/**
 * is.decimal
 * Test if `value` is a decimal number.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is a decimal number, false otherwise
 * @api public
 */

is.decimal = function (value) {
  return is.number(value) && !isActualNaN(value) && !is.infinite(value) && value % 1 !== 0;
};

/**
 * is.divisibleBy
 * Test if `value` is divisible by `n`.
 *
 * @param {Number} value value to test
 * @param {Number} n dividend
 * @return {Boolean} true if `value` is divisible by `n`, false otherwise
 * @api public
 */

is.divisibleBy = function (value, n) {
  var isDividendInfinite = is.infinite(value);
  var isDivisorInfinite = is.infinite(n);
  var isNonZeroNumber = is.number(value) && !isActualNaN(value) && is.number(n) && !isActualNaN(n) && n !== 0;
  return isDividendInfinite || isDivisorInfinite || isNonZeroNumber && value % n === 0;
};

/**
 * is.integer
 * Test if `value` is an integer.
 *
 * @param value to test
 * @return {Boolean} true if `value` is an integer, false otherwise
 * @api public
 */

is.integer = is['int'] = function (value) {
  return is.number(value) && !isActualNaN(value) && value % 1 === 0;
};

/**
 * is.maximum
 * Test if `value` is greater than 'others' values.
 *
 * @param {Number} value value to test
 * @param {Array} others values to compare with
 * @return {Boolean} true if `value` is greater than `others` values
 * @api public
 */

is.maximum = function (value, others) {
  if (isActualNaN(value)) {
    throw new TypeError('NaN is not a valid value');
  } else if (!is.arraylike(others)) {
    throw new TypeError('second argument must be array-like');
  }
  var len = others.length;

  while (--len >= 0) {
    if (value < others[len]) {
      return false;
    }
  }

  return true;
};

/**
 * is.minimum
 * Test if `value` is less than `others` values.
 *
 * @param {Number} value value to test
 * @param {Array} others values to compare with
 * @return {Boolean} true if `value` is less than `others` values
 * @api public
 */

is.minimum = function (value, others) {
  if (isActualNaN(value)) {
    throw new TypeError('NaN is not a valid value');
  } else if (!is.arraylike(others)) {
    throw new TypeError('second argument must be array-like');
  }
  var len = others.length;

  while (--len >= 0) {
    if (value > others[len]) {
      return false;
    }
  }

  return true;
};

/**
 * is.nan
 * Test if `value` is not a number.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is not a number, false otherwise
 * @api public
 */

is.nan = function (value) {
  return !is.number(value) || value !== value;
};

/**
 * is.even
 * Test if `value` is an even number.
 *
 * @param {Number} value value to test
 * @return {Boolean} true if `value` is an even number, false otherwise
 * @api public
 */

is.even = function (value) {
  return is.infinite(value) || is.number(value) && value === value && value % 2 === 0;
};

/**
 * is.odd
 * Test if `value` is an odd number.
 *
 * @param {Number} value value to test
 * @return {Boolean} true if `value` is an odd number, false otherwise
 * @api public
 */

is.odd = function (value) {
  return is.infinite(value) || is.number(value) && value === value && value % 2 !== 0;
};

/**
 * is.ge
 * Test if `value` is greater than or equal to `other`.
 *
 * @param {Number} value value to test
 * @param {Number} other value to compare with
 * @return {Boolean}
 * @api public
 */

is.ge = function (value, other) {
  if (isActualNaN(value) || isActualNaN(other)) {
    throw new TypeError('NaN is not a valid value');
  }
  return !is.infinite(value) && !is.infinite(other) && value >= other;
};

/**
 * is.gt
 * Test if `value` is greater than `other`.
 *
 * @param {Number} value value to test
 * @param {Number} other value to compare with
 * @return {Boolean}
 * @api public
 */

is.gt = function (value, other) {
  if (isActualNaN(value) || isActualNaN(other)) {
    throw new TypeError('NaN is not a valid value');
  }
  return !is.infinite(value) && !is.infinite(other) && value > other;
};

/**
 * is.le
 * Test if `value` is less than or equal to `other`.
 *
 * @param {Number} value value to test
 * @param {Number} other value to compare with
 * @return {Boolean} if 'value' is less than or equal to 'other'
 * @api public
 */

is.le = function (value, other) {
  if (isActualNaN(value) || isActualNaN(other)) {
    throw new TypeError('NaN is not a valid value');
  }
  return !is.infinite(value) && !is.infinite(other) && value <= other;
};

/**
 * is.lt
 * Test if `value` is less than `other`.
 *
 * @param {Number} value value to test
 * @param {Number} other value to compare with
 * @return {Boolean} if `value` is less than `other`
 * @api public
 */

is.lt = function (value, other) {
  if (isActualNaN(value) || isActualNaN(other)) {
    throw new TypeError('NaN is not a valid value');
  }
  return !is.infinite(value) && !is.infinite(other) && value < other;
};

/**
 * is.within
 * Test if `value` is within `start` and `finish`.
 *
 * @param {Number} value value to test
 * @param {Number} start lower bound
 * @param {Number} finish upper bound
 * @return {Boolean} true if 'value' is is within 'start' and 'finish'
 * @api public
 */
is.within = function (value, start, finish) {
  if (isActualNaN(value) || isActualNaN(start) || isActualNaN(finish)) {
    throw new TypeError('NaN is not a valid value');
  } else if (!is.number(value) || !is.number(start) || !is.number(finish)) {
    throw new TypeError('all arguments must be numbers');
  }
  var isAnyInfinite = is.infinite(value) || is.infinite(start) || is.infinite(finish);
  return isAnyInfinite || value >= start && value <= finish;
};

/**
 * Test object.
 */

/**
 * is.object
 * Test if `value` is an object.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is an object, false otherwise
 * @api public
 */
is.object = function (value) {
  return toStr.call(value) === '[object Object]';
};

/**
 * is.primitive
 * Test if `value` is a primitive.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is a primitive, false otherwise
 * @api public
 */
is.primitive = function isPrimitive(value) {
  if (!value) {
    return true;
  }
  if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object' || is.object(value) || is.fn(value) || is.array(value)) {
    return false;
  }
  return true;
};

/**
 * is.hash
 * Test if `value` is a hash - a plain object literal.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is a hash, false otherwise
 * @api public
 */

is.hash = function (value) {
  return is.object(value) && value.constructor === Object && !value.nodeType && !value.setInterval;
};

/**
 * Test regexp.
 */

/**
 * is.regexp
 * Test if `value` is a regular expression.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is a regexp, false otherwise
 * @api public
 */

is.regexp = function (value) {
  return toStr.call(value) === '[object RegExp]';
};

/**
 * Test string.
 */

/**
 * is.string
 * Test if `value` is a string.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if 'value' is a string, false otherwise
 * @api public
 */

is.string = function (value) {
  return toStr.call(value) === '[object String]';
};

/**
 * Test base64 string.
 */

/**
 * is.base64
 * Test if `value` is a valid base64 encoded string.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if 'value' is a base64 encoded string, false otherwise
 * @api public
 */

is.base64 = function (value) {
  return is.string(value) && (!value.length || base64Regex.test(value));
};

/**
 * Test base64 string.
 */

/**
 * is.hex
 * Test if `value` is a valid hex encoded string.
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if 'value' is a hex encoded string, false otherwise
 * @api public
 */

is.hex = function (value) {
  return is.string(value) && (!value.length || hexRegex.test(value));
};

/**
 * is.symbol
 * Test if `value` is an ES6 Symbol
 *
 * @param {Mixed} value value to test
 * @return {Boolean} true if `value` is a Symbol, false otherise
 * @api public
 */

is.symbol = function (value) {
  return typeof Symbol === 'function' && toStr.call(value) === '[object Symbol]' && _typeof(symbolValueOf.call(value)) === 'symbol';
};

module.exports = is;

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__(30);

/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/*!
 * node.extend
 * Copyright 2011, John Resig
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * @fileoverview
 * Port of jQuery.extend that actually works on node.js
 */

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var is = __webpack_require__(28);

var extend = function extend() {
  var target = arguments[0] || {};
  var i = 1;
  var length = arguments.length;
  var deep = false;
  var options, name, src, copy, copyIsArray, clone;

  // Handle a deep copy situation
  if (typeof target === 'boolean') {
    deep = target;
    target = arguments[1] || {};
    // skip the boolean and the target
    i = 2;
  }

  // Handle case when target is a string or something (possible in deep copy)
  if ((typeof target === 'undefined' ? 'undefined' : _typeof(target)) !== 'object' && !is.fn(target)) {
    target = {};
  }

  for (; i < length; i++) {
    // Only deal with non-null/undefined values
    options = arguments[i];
    if (options != null) {
      if (typeof options === 'string') {
        options = options.split('');
      }
      // Extend the base object
      for (name in options) {
        src = target[name];
        copy = options[name];

        // Prevent never-ending loop
        if (target === copy) {
          continue;
        }

        // Recurse if we're merging plain objects or arrays
        if (deep && copy && (is.hash(copy) || (copyIsArray = is.array(copy)))) {
          if (copyIsArray) {
            copyIsArray = false;
            clone = src && is.array(src) ? src : [];
          } else {
            clone = src && is.hash(src) ? src : {};
          }

          // Never move original objects, clone them
          target[name] = extend(deep, clone, copy);

          // Don't bring in undefined values
        } else if (typeof copy !== 'undefined') {
          target[name] = copy;
        }
      }
    }
  }

  // Return the modified object
  return target;
};

/**
 * @public
 */
extend.version = '1.1.3';

/**
 * Exports module.
 */
module.exports = extend;

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

// Generated by CoffeeScript 1.10.0
(function () {
  var Payment,
      QJ,
      cardFromNumber,
      cardFromType,
      cards,
      defaultFormat,
      formatBackCardNumber,
      formatBackExpiry,
      formatCardNumber,
      formatExpiry,
      formatForwardExpiry,
      formatForwardSlash,
      formatMonthExpiry,
      hasTextSelected,
      luhnCheck,
      reFormatCardNumber,
      restrictCVC,
      restrictCardNumber,
      restrictCombinedExpiry,
      restrictExpiry,
      restrictMonthExpiry,
      restrictNumeric,
      restrictYearExpiry,
      setCardType,
      indexOf = [].indexOf || function (item) {
    for (var i = 0, l = this.length; i < l; i++) {
      if (i in this && this[i] === item) return i;
    }return -1;
  };

  QJ = __webpack_require__(5);

  defaultFormat = /(\d{1,4})/g;

  cards = [{
    type: 'amex',
    pattern: /^3[47]/,
    format: /(\d{1,4})(\d{1,6})?(\d{1,5})?/,
    length: [15],
    cvcLength: [4],
    luhn: true
  }, {
    type: 'dankort',
    pattern: /^5019/,
    format: defaultFormat,
    length: [16],
    cvcLength: [3],
    luhn: true
  }, {
    type: 'dinersclub',
    pattern: /^(36|38|30[0-5])/,
    format: /(\d{1,4})(\d{1,6})?(\d{1,4})?/,
    length: [14],
    cvcLength: [3],
    luhn: true
  }, {
    type: 'discover',
    pattern: /^(6011|65|64[4-9]|622)/,
    format: defaultFormat,
    length: [16],
    cvcLength: [3],
    luhn: true
  }, {
    type: 'jcb',
    pattern: /^35/,
    format: defaultFormat,
    length: [16],
    cvcLength: [3],
    luhn: true
  }, {
    type: 'laser',
    pattern: /^(6706|6771|6709)/,
    format: defaultFormat,
    length: [16, 17, 18, 19],
    cvcLength: [3],
    luhn: true
  }, {
    type: 'maestro',
    pattern: /^(5018|5020|5038|6304|6703|6708|6759|676[1-3])/,
    format: defaultFormat,
    length: [12, 13, 14, 15, 16, 17, 18, 19],
    cvcLength: [3],
    luhn: true
  }, {
    type: 'mastercard',
    pattern: /^(5[1-5]|677189)|^(222[1-9]|2[3-6]\d{2}|27[0-1]\d|2720)/,
    format: defaultFormat,
    length: [16],
    cvcLength: [3],
    luhn: true
  }, {
    type: 'unionpay',
    pattern: /^62/,
    format: defaultFormat,
    length: [16, 17, 18, 19],
    cvcLength: [3],
    luhn: false
  }, {
    type: 'visaelectron',
    pattern: /^4(026|17500|405|508|844|91[37])/,
    format: defaultFormat,
    length: [16],
    cvcLength: [3],
    luhn: true
  }, {
    type: 'elo',
    pattern: /^(4011|438935|45(1416|76|7393)|50(4175|6699|67|90[4-7])|63(6297|6368))/,
    format: defaultFormat,
    length: [16],
    cvcLength: [3],
    luhn: true
  }, {
    type: 'visa',
    pattern: /^4/,
    format: defaultFormat,
    length: [13, 16, 19],
    cvcLength: [3],
    luhn: true
  }];

  cardFromNumber = function cardFromNumber(num) {
    var card, j, len;
    num = (num + '').replace(/\D/g, '');
    for (j = 0, len = cards.length; j < len; j++) {
      card = cards[j];
      if (card.pattern.test(num)) {
        return card;
      }
    }
  };

  cardFromType = function cardFromType(type) {
    var card, j, len;
    for (j = 0, len = cards.length; j < len; j++) {
      card = cards[j];
      if (card.type === type) {
        return card;
      }
    }
  };

  luhnCheck = function luhnCheck(num) {
    var digit, digits, j, len, odd, sum;
    odd = true;
    sum = 0;
    digits = (num + '').split('').reverse();
    for (j = 0, len = digits.length; j < len; j++) {
      digit = digits[j];
      digit = parseInt(digit, 10);
      if (odd = !odd) {
        digit *= 2;
      }
      if (digit > 9) {
        digit -= 9;
      }
      sum += digit;
    }
    return sum % 10 === 0;
  };

  hasTextSelected = function hasTextSelected(target) {
    var e, error, ref;
    try {
      if (target.selectionStart != null && target.selectionStart !== target.selectionEnd) {
        return true;
      }
      if ((typeof document !== "undefined" && document !== null ? (ref = document.selection) != null ? ref.createRange : void 0 : void 0) != null) {
        if (document.selection.createRange().text) {
          return true;
        }
      }
    } catch (error) {
      e = error;
    }
    return false;
  };

  reFormatCardNumber = function reFormatCardNumber(e) {
    return setTimeout(function (_this) {
      return function () {
        var target, value;
        target = e.target;
        value = QJ.val(target);
        value = Payment.fns.formatCardNumber(value);
        QJ.val(target, value);
        return QJ.trigger(target, 'change');
      };
    }(this));
  };

  formatCardNumber = function formatCardNumber(e) {
    var card, digit, i, j, len, length, re, target, upperLength, upperLengths, value;
    digit = String.fromCharCode(e.which);
    if (!/^\d+$/.test(digit)) {
      return;
    }
    target = e.target;
    value = QJ.val(target);
    card = cardFromNumber(value + digit);
    length = (value.replace(/\D/g, '') + digit).length;
    upperLengths = [16];
    if (card) {
      upperLengths = card.length;
    }
    for (i = j = 0, len = upperLengths.length; j < len; i = ++j) {
      upperLength = upperLengths[i];
      if (length >= upperLength && upperLengths[i + 1]) {
        continue;
      }
      if (length >= upperLength) {
        return;
      }
    }
    if (hasTextSelected(target)) {
      return;
    }
    if (card && card.type === 'amex') {
      re = /^(\d{4}|\d{4}\s\d{6})$/;
    } else {
      re = /(?:^|\s)(\d{4})$/;
    }
    if (re.test(value)) {
      e.preventDefault();
      QJ.val(target, value + ' ' + digit);
      return QJ.trigger(target, 'change');
    }
  };

  formatBackCardNumber = function formatBackCardNumber(e) {
    var target, value;
    target = e.target;
    value = QJ.val(target);
    if (e.meta) {
      return;
    }
    if (e.which !== 8) {
      return;
    }
    if (hasTextSelected(target)) {
      return;
    }
    if (/\d\s$/.test(value)) {
      e.preventDefault();
      QJ.val(target, value.replace(/\d\s$/, ''));
      return QJ.trigger(target, 'change');
    } else if (/\s\d?$/.test(value)) {
      e.preventDefault();
      QJ.val(target, value.replace(/\s\d?$/, ''));
      return QJ.trigger(target, 'change');
    }
  };

  formatExpiry = function formatExpiry(e) {
    var digit, target, val;
    digit = String.fromCharCode(e.which);
    if (!/^\d+$/.test(digit)) {
      return;
    }
    target = e.target;
    val = QJ.val(target) + digit;
    if (/^\d$/.test(val) && val !== '0' && val !== '1') {
      e.preventDefault();
      QJ.val(target, "0" + val + " / ");
      return QJ.trigger(target, 'change');
    } else if (/^\d\d$/.test(val)) {
      e.preventDefault();
      QJ.val(target, val + " / ");
      return QJ.trigger(target, 'change');
    }
  };

  formatMonthExpiry = function formatMonthExpiry(e) {
    var digit, target, val;
    digit = String.fromCharCode(e.which);
    if (!/^\d+$/.test(digit)) {
      return;
    }
    target = e.target;
    val = QJ.val(target) + digit;
    if (/^\d$/.test(val) && val !== '0' && val !== '1') {
      e.preventDefault();
      QJ.val(target, "0" + val);
      return QJ.trigger(target, 'change');
    } else if (/^\d\d$/.test(val)) {
      e.preventDefault();
      QJ.val(target, "" + val);
      return QJ.trigger(target, 'change');
    }
  };

  formatForwardExpiry = function formatForwardExpiry(e) {
    var digit, target, val;
    digit = String.fromCharCode(e.which);
    if (!/^\d+$/.test(digit)) {
      return;
    }
    target = e.target;
    val = QJ.val(target);
    if (/^\d\d$/.test(val)) {
      QJ.val(target, val + " / ");
      return QJ.trigger(target, 'change');
    }
  };

  formatForwardSlash = function formatForwardSlash(e) {
    var slash, target, val;
    slash = String.fromCharCode(e.which);
    if (slash !== '/') {
      return;
    }
    target = e.target;
    val = QJ.val(target);
    if (/^\d$/.test(val) && val !== '0') {
      QJ.val(target, "0" + val + " / ");
      return QJ.trigger(target, 'change');
    }
  };

  formatBackExpiry = function formatBackExpiry(e) {
    var target, value;
    if (e.metaKey) {
      return;
    }
    target = e.target;
    value = QJ.val(target);
    if (e.which !== 8) {
      return;
    }
    if (hasTextSelected(target)) {
      return;
    }
    if (/\d(\s|\/)+$/.test(value)) {
      e.preventDefault();
      QJ.val(target, value.replace(/\d(\s|\/)*$/, ''));
      return QJ.trigger(target, 'change');
    } else if (/\s\/\s?\d?$/.test(value)) {
      e.preventDefault();
      QJ.val(target, value.replace(/\s\/\s?\d?$/, ''));
      return QJ.trigger(target, 'change');
    }
  };

  restrictNumeric = function restrictNumeric(e) {
    var input;
    if (e.metaKey || e.ctrlKey) {
      return true;
    }
    if (e.which === 32) {
      return e.preventDefault();
    }
    if (e.which === 0) {
      return true;
    }
    if (e.which < 33) {
      return true;
    }
    input = String.fromCharCode(e.which);
    if (!/[\d\s]/.test(input)) {
      return e.preventDefault();
    }
  };

  restrictCardNumber = function restrictCardNumber(e) {
    var card, digit, target, value;
    target = e.target;
    digit = String.fromCharCode(e.which);
    if (!/^\d+$/.test(digit)) {
      return;
    }
    if (hasTextSelected(target)) {
      return;
    }
    value = (QJ.val(target) + digit).replace(/\D/g, '');
    card = cardFromNumber(value);
    if (card) {
      if (!(value.length <= card.length[card.length.length - 1])) {
        return e.preventDefault();
      }
    } else {
      if (!(value.length <= 16)) {
        return e.preventDefault();
      }
    }
  };

  restrictExpiry = function restrictExpiry(e, length) {
    var digit, target, value;
    target = e.target;
    digit = String.fromCharCode(e.which);
    if (!/^\d+$/.test(digit)) {
      return;
    }
    if (hasTextSelected(target)) {
      return;
    }
    value = QJ.val(target) + digit;
    value = value.replace(/\D/g, '');
    if (value.length > length) {
      return e.preventDefault();
    }
  };

  restrictCombinedExpiry = function restrictCombinedExpiry(e) {
    return restrictExpiry(e, 6);
  };

  restrictMonthExpiry = function restrictMonthExpiry(e) {
    return restrictExpiry(e, 2);
  };

  restrictYearExpiry = function restrictYearExpiry(e) {
    return restrictExpiry(e, 4);
  };

  restrictCVC = function restrictCVC(e) {
    var digit, target, val;
    target = e.target;
    digit = String.fromCharCode(e.which);
    if (!/^\d+$/.test(digit)) {
      return;
    }
    if (hasTextSelected(target)) {
      return;
    }
    val = QJ.val(target) + digit;
    if (!(val.length <= 4)) {
      return e.preventDefault();
    }
  };

  setCardType = function setCardType(e) {
    var allTypes, card, cardType, target, val;
    target = e.target;
    val = QJ.val(target);
    cardType = Payment.fns.cardType(val) || 'unknown';
    if (!QJ.hasClass(target, cardType)) {
      allTypes = function () {
        var j, len, results;
        results = [];
        for (j = 0, len = cards.length; j < len; j++) {
          card = cards[j];
          results.push(card.type);
        }
        return results;
      }();
      QJ.removeClass(target, 'unknown');
      QJ.removeClass(target, allTypes.join(' '));
      QJ.addClass(target, cardType);
      QJ.toggleClass(target, 'identified', cardType !== 'unknown');
      return QJ.trigger(target, 'payment.cardType', cardType);
    }
  };

  Payment = function () {
    function Payment() {}

    Payment.fns = {
      cardExpiryVal: function cardExpiryVal(value) {
        var month, prefix, ref, year;
        value = value.replace(/\s/g, '');
        ref = value.split('/', 2), month = ref[0], year = ref[1];
        if ((year != null ? year.length : void 0) === 2 && /^\d+$/.test(year)) {
          prefix = new Date().getFullYear();
          prefix = prefix.toString().slice(0, 2);
          year = prefix + year;
        }
        month = parseInt(month, 10);
        year = parseInt(year, 10);
        return {
          month: month,
          year: year
        };
      },
      validateCardNumber: function validateCardNumber(num) {
        var card, ref;
        num = (num + '').replace(/\s+|-/g, '');
        if (!/^\d+$/.test(num)) {
          return false;
        }
        card = cardFromNumber(num);
        if (!card) {
          return false;
        }
        return (ref = num.length, indexOf.call(card.length, ref) >= 0) && (card.luhn === false || luhnCheck(num));
      },
      validateCardExpiry: function validateCardExpiry(month, year) {
        var currentTime, expiry, prefix, ref, ref1;
        if ((typeof month === 'undefined' ? 'undefined' : _typeof(month)) === 'object' && 'month' in month) {
          ref = month, month = ref.month, year = ref.year;
        } else if (typeof month === 'string' && indexOf.call(month, '/') >= 0) {
          ref1 = Payment.fns.cardExpiryVal(month), month = ref1.month, year = ref1.year;
        }
        if (!(month && year)) {
          return false;
        }
        month = QJ.trim(month);
        year = QJ.trim(year);
        if (!/^\d+$/.test(month)) {
          return false;
        }
        if (!/^\d+$/.test(year)) {
          return false;
        }
        month = parseInt(month, 10);
        if (!(month && month <= 12)) {
          return false;
        }
        if (year.length === 2) {
          prefix = new Date().getFullYear();
          prefix = prefix.toString().slice(0, 2);
          year = prefix + year;
        }
        expiry = new Date(year, month);
        currentTime = new Date();
        expiry.setMonth(expiry.getMonth() - 1);
        expiry.setMonth(expiry.getMonth() + 1, 1);
        return expiry > currentTime;
      },
      validateCardCVC: function validateCardCVC(cvc, type) {
        var ref, ref1;
        cvc = QJ.trim(cvc);
        if (!/^\d+$/.test(cvc)) {
          return false;
        }
        if (type && cardFromType(type)) {
          return ref = cvc.length, indexOf.call((ref1 = cardFromType(type)) != null ? ref1.cvcLength : void 0, ref) >= 0;
        } else {
          return cvc.length >= 3 && cvc.length <= 4;
        }
      },
      cardType: function cardType(num) {
        var ref;
        if (!num) {
          return null;
        }
        return ((ref = cardFromNumber(num)) != null ? ref.type : void 0) || null;
      },
      formatCardNumber: function formatCardNumber(num) {
        var card, groups, ref, upperLength;
        card = cardFromNumber(num);
        if (!card) {
          return num;
        }
        upperLength = card.length[card.length.length - 1];
        num = num.replace(/\D/g, '');
        num = num.slice(0, upperLength);
        if (card.format.global) {
          return (ref = num.match(card.format)) != null ? ref.join(' ') : void 0;
        } else {
          groups = card.format.exec(num);
          if (groups != null) {
            groups.shift();
          }
          return groups != null ? groups.join(' ') : void 0;
        }
      }
    };

    Payment.restrictNumeric = function (el) {
      return QJ.on(el, 'keypress', restrictNumeric);
    };

    Payment.cardExpiryVal = function (el) {
      return Payment.fns.cardExpiryVal(QJ.val(el));
    };

    Payment.formatCardCVC = function (el) {
      Payment.restrictNumeric(el);
      QJ.on(el, 'keypress', restrictCVC);
      return el;
    };

    Payment.formatCardExpiry = function (el) {
      var month, year;
      Payment.restrictNumeric(el);
      if (el.length && el.length === 2) {
        month = el[0], year = el[1];
        this.formatCardExpiryMultiple(month, year);
      } else {
        QJ.on(el, 'keypress', restrictCombinedExpiry);
        QJ.on(el, 'keypress', formatExpiry);
        QJ.on(el, 'keypress', formatForwardSlash);
        QJ.on(el, 'keypress', formatForwardExpiry);
        QJ.on(el, 'keydown', formatBackExpiry);
      }
      return el;
    };

    Payment.formatCardExpiryMultiple = function (month, year) {
      QJ.on(month, 'keypress', restrictMonthExpiry);
      QJ.on(month, 'keypress', formatMonthExpiry);
      return QJ.on(year, 'keypress', restrictYearExpiry);
    };

    Payment.formatCardNumber = function (el) {
      Payment.restrictNumeric(el);
      QJ.on(el, 'keypress', restrictCardNumber);
      QJ.on(el, 'keypress', formatCardNumber);
      QJ.on(el, 'keydown', formatBackCardNumber);
      QJ.on(el, 'keyup blur', setCardType);
      QJ.on(el, 'paste', reFormatCardNumber);
      return el;
    };

    Payment.getCardArray = function () {
      return cards;
    };

    Payment.setCardArray = function (cardArray) {
      cards = cardArray;
      return true;
    };

    Payment.addToCardArray = function (cardObject) {
      return cards.push(cardObject);
    };

    Payment.removeFromCardArray = function (type) {
      var key, value;
      for (key in cards) {
        value = cards[key];
        if (value.type === type) {
          cards.splice(key, 1);
        }
      }
      return true;
    };

    return Payment;
  }();

  module.exports = Payment;

  global.Payment = Payment;
}).call(undefined);
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(6)))

/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * When source maps are enabled, `style-loader` uses a link element with a data-uri to
 * embed the css on the page. This breaks all relative urls because now they are relative to a
 * bundle instead of the current page.
 *
 * One solution is to only use full urls, but that may be impossible.
 *
 * Instead, this function "fixes" the relative urls to be absolute according to the current page location.
 *
 * A rudimentary test suite is located at `test/fixUrls.js` and can be run via the `npm test` command.
 *
 */

module.exports = function (css) {
	// get current location
	var location = typeof window !== "undefined" && window.location;

	if (!location) {
		throw new Error("fixUrls requires window.location");
	}

	// blank or null?
	if (!css || typeof css !== "string") {
		return css;
	}

	var baseUrl = location.protocol + "//" + location.host;
	var currentDir = baseUrl + location.pathname.replace(/\/[^\/]*$/, "/");

	// convert each url(...)
	/*
 This regular expression is just a way to recursively match brackets within
 a string.
 	 /url\s*\(  = Match on the word "url" with any whitespace after it and then a parens
    (  = Start a capturing group
      (?:  = Start a non-capturing group
          [^)(]  = Match anything that isn't a parentheses
          |  = OR
          \(  = Match a start parentheses
              (?:  = Start another non-capturing groups
                  [^)(]+  = Match anything that isn't a parentheses
                  |  = OR
                  \(  = Match a start parentheses
                      [^)(]*  = Match anything that isn't a parentheses
                  \)  = Match a end parentheses
              )  = End Group
              *\) = Match anything and then a close parens
          )  = Close non-capturing group
          *  = Match anything
       )  = Close capturing group
  \)  = Match a close parens
 	 /gi  = Get all matches, not the first.  Be case insensitive.
  */
	var fixedCss = css.replace(/url\s*\(((?:[^)(]|\((?:[^)(]+|\([^)(]*\))*\))*)\)/gi, function (fullMatch, origUrl) {
		// strip quotes (if they exist)
		var unquotedOrigUrl = origUrl.trim().replace(/^"(.*)"$/, function (o, $1) {
			return $1;
		}).replace(/^'(.*)'$/, function (o, $1) {
			return $1;
		});

		// already a full url? no change
		if (/^(#|data:|http:\/\/|https:\/\/|file:\/\/\/)/i.test(unquotedOrigUrl)) {
			return fullMatch;
		}

		// convert the url to a full url
		var newUrl;

		if (unquotedOrigUrl.indexOf("//") === 0) {
			//TODO: should we add protocol?
			newUrl = unquotedOrigUrl;
		} else if (unquotedOrigUrl.indexOf("/") === 0) {
			// path should be relative to the base url
			newUrl = baseUrl + unquotedOrigUrl; // already starts with '/'
		} else {
			// path should be relative to current directory
			newUrl = currentDir + unquotedOrigUrl.replace(/^\.\//, ""); // Strip leading './'
		}

		// send back the fixed url(...)
		return "url(" + JSON.stringify(newUrl) + ")";
	});

	// send back the fixed css
	return fixedCss;
};

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _knob = __webpack_require__(50);

var _knob2 = _interopRequireDefault(_knob);

__webpack_require__(49);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var boxknob = function boxknob() {
    $(".knob").knob({
        change: function change(value) {
            //console.log("change : " + value);
        },
        release: function release(value) {
            //console.log(this.$.attr('value'));
            //console.log("release : " + value);
            this.$div.closest('.box').find('.slider').slider("value", value);
        },
        cancel: function cancel() {
            //console.log("cancel : ", this);
        },
        /*format : function (value) {
            return value + '%';
        },*/
        draw: function draw() {}
    });
};

var isMobile = false; //initiate as false
// device detection
if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0, 4))) isMobile = true;

var delay = 50;
var timeout = null;

document.addEventListener('touchmove', function (e) {
    console.log('touchmove');
}, false);

$(window).bind('scroll', function () {
    clearTimeout(timeout);
    if (isMobile == true) {
        $('.ls-swiper').addClass('swiper-no-swiping');
    }
    timeout = setTimeout(function () {
        if (isMobile == true) {
            $('.ls-swiper').removeClass('swiper-no-swiping');
        }
    }, delay);
});

$(document).on('click', '.box--radio', function () {
    $(this).closest('.box-container').find('.box.is-active').removeClass('is-active');
    $(this).addClass('is-active');
    $(this).find('input[type="radio"]').prop('checked', true);
    if ($(this).data('location')) {
        $(this).closest('.section__body').find('.pin').removeClass('is-active');
        $(this).closest('.section__body').find('[data-location=' + $(this).data('location') + ']').addClass('is-active');
    }
});

//box checkbox

$(document).on('click', '.box--checkbox .box__body, .box--checkbox .box__stripe', function (e) {
    if ($(this).parent().hasClass('is-active')) {
        if (!$(e.target).hasClass('knob')) {
            $(this).parent().removeClass('is-active');
            $(this).parent().find('input[type="checkbox"]').prop('checked', false);
        }
    } else {
        $(this).parent().addClass('is-active');
        $(this).parent().find('input[type="checkbox"]').prop('checked', true);
    }
});

//change knob on load when box is-active

$(window).on('load', function () {
    $('body').find('.box--slider.is-active .knob').trigger('configure', {
        "fgColor": "#3ba5ff"
    });
});

//change knob when click on box

$(document).on('click', '.box--slider', function () {
    if ($(this).hasClass('is-active')) {
        $(this).find('.knob').trigger('configure', {
            "fgColor": "#3ba5ff"
        });
    } else {
        $(this).find('.knob').trigger('configure', {
            "fgColor": "#d8edff"
        });
    }
});

//close dropdown when scrolling ... stupid but it works
$(window).on('scroll', function (e) {
    $('body').trigger('click');
});

//value sliders
$(".slider").slider({
    range: "min",
    value: 1,
    min: 1,
    max: 10,
    slide: function slide(event, ui) {
        $(this).closest('.box').trigger('click');
        $(this).closest('.box').find('.knob').val(ui.value).trigger('change');
    },
    start: function start(event, ui) {
        $(this).closest('.box').addClass('is-active').find('input[type="checkbox"]').prop('checked', true);
    }
});

//sliders actions + -
$(document).on('click', '.box__slider [data-slider="plus"]', function () {
    var sliderCurrentValue = $(this).siblings('.slider').slider("option", "value");
    $(this).siblings('.slider').slider("value", sliderCurrentValue + 1);
    $(this).closest('.box').find('.knob').val(sliderCurrentValue + 1).trigger('change');
});

$(document).on('click', '.box__slider [data-slider="minus"]', function () {
    var sliderCurrentValue = $(this).siblings('.slider').slider("option", "value");
    $(this).siblings('.slider').slider("value", sliderCurrentValue - 1);
    $(this).closest('.box').find('.knob').val(sliderCurrentValue - 1).trigger('change');
});

$(document).on('click', '.dropdown--box a', function () {
    $('.dropdown--box a').removeClass('is-active');
    $(this).addClass('is-active');
    $('.box:not(.drop-enabled) .btn--link span').text('Choose Version');
    $('.box:not(.drop-enabled)').removeClass('is-active');
    $('body').find('.box.drop-enabled').addClass('is-active');
    $('body').find('.box.drop-enabled .btn--link span').text($(this).text());
    $('body').trigger('click');
});

/* box qty */
$(document).on('click', '.box__qty [data-qty="plus"]', function (e) {
    e.preventDefault();
    var maxValue = $(this).siblings('.qty').data('max');
    var qtyCurrentValue = $(this).siblings('.qty').val();
    if (qtyCurrentValue < maxValue) {
        qtyCurrentValue++;
        $(this).siblings('.btn').removeClass('disabled');
        $(this).siblings('.qty').val(qtyCurrentValue);
    } else {
        $(this).addClass('disabled');
    }
});

$(document).on('click', '.box__qty [data-qty="minus"]', function (e) {
    e.preventDefault();
    var minValue = $(this).siblings('.qty').data('min');
    var qtyCurrentValue = $(this).siblings('.qty').val();
    if (qtyCurrentValue > minValue) {
        qtyCurrentValue--;
        $(this).siblings('.btn').removeClass('disabled');
        $(this).siblings('.qty').val(qtyCurrentValue);
    } else {
        $(this).addClass('disabled');
    }
});

$('.box__qty .qty').on('keyup', function (e) {
    var minValue = $(this).data('min');
    var maxValue = $(this).data('max');

    if ($(this).val() > maxValue && e.keyCode != 46 && e.keyCode != 8) {
        $(this).siblings('[data-qty="minus"]').removeClass('disabled');
        $(this).siblings('[data-qty="plus"]').addClass('disabled');
        e.preventDefault();
        $(this).val(maxValue);
    } else if ($(this).val() < minValue && e.keyCode != 46 && e.keyCode != 8) {
        console.log($(this).val());
        $(this).siblings('[data-qty="plus"]').removeClass('disabled');
        $(this).siblings('[data-qty="minus"]').addClass('disabled');
        e.preventDefault();
        $(this).val(minValue);
    }
});

var focusQtyValue = function focusQtyValue() {
    var Qtyvalue = '';
    $('.box__qty .qty').focusin(function () {
        Qtyvalue = $(this).val();
    });
    $('.box__qty .qty').focusout(function () {
        if ($(this).val() == '') {
            $(this).val(Qtyvalue);
        }
    });
};
focusQtyValue();

boxknob();

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
function checkCollapse() {
    var that = this;
    setTimeout(function () {
        if ($(that).is('input[type=checkbox') || $(that).is('input[type=radio]')) {
            if ($(that).attr('aria-expanded') === 'true') {
                $(that).prop('checked', true);
            } else {
                $(that).prop('checked', false);
            }
        }
    }, 30);
}
exports.default = checkCollapse;

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.billingInfo = undefined;

var _card = __webpack_require__(25);

var _card2 = _interopRequireDefault(_card);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Credit Card
function billingInfo() {

    var creditCard = new _card2.default({
        form: document.querySelector('.form-section'),
        container: document.querySelector('.card-wrapper'),

        formSelectors: {
            nameInput: 'input[name="first-name"], input[name="last-name"]',
            expiryInput: 'input[name="expiry-mm"], input[name="expiry-yy"]'
        },
        placeholders: {
            number: '**** **** **** 4809',
            name: 'John Doe',
            cvc: '111'
        }
    });
}

var yearSelector = 'select[name="expiry-yy"]';
var monthSelector = 'select[name="expiry-mm"]';

$(monthSelector).change(function () {
    var year = $(yearSelector).val() == '' ? '••' : $(yearSelector).val();
    $('.jp-card-expiry').text($(this).val() + '/' + year);
});
$(yearSelector).change(function () {
    var month = $(monthSelector).val() == '' ? '••' : $(monthSelector).val();
    $('.jp-card-expiry').text(month + '/' + $(this).val());
});
$(monthSelector).add(yearSelector).on('focus', function () {
    $('.jp-card-expiry').addClass('jp-card-focused');
}).on('blur', function () {
    $('.jp-card-expiry').removeClass('jp-card-focused');
});

billingInfo();

exports.billingInfo = billingInfo;

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

function filesUpload() {
	var inputs = document.querySelectorAll('.file-input');
	Array.prototype.forEach.call(inputs, function (input) {
		var label = input.nextElementSibling,
		    labelVal = label.innerHTML;

		input.addEventListener('change', function (e) {
			var fileName = '';
			if (this.files && this.files.length > 1) fileName = (this.getAttribute('data-multiple-caption') || '').replace('{count}', this.files.length);else fileName = e.target.value.split('\\').pop();

			console.log('|' + fileName + '|');
			console.log('|' + labelVal + '|');

			if (fileName) label.querySelector('span').innerHTML = fileName + '<button class="btn btn-xs btn-link btn-icon clear-file-btn" type="button"><i class="zmdi zmdi-close"></button>';
			//else
			//label.innerHTML = labelVal;
		});
	});
	$('.add-file-input').on('click', function () {
		var fileId = $('.file-uploads .file-btn').length + 2;

		$('.file-input-new').each(function (index) {
			if ($('.file-input-new').eq(index).length === 0) {
				$(this).closest('.file-btn').remove();
			}
		});
		$(this).parent().find(".file-uploads").append('<div class="file-btn"><input type="file" name="attachments[]" id="inputAttachments' + fileId + '" class="form-control file-input file-input-new" /><label for="inputAttachments' + fileId + '" class="btn btn-sm btn-outline btn-default"><i class="zmdi zmdi-upload"></i><span>Choose a file</span></label></div>');

		var inputs = document.querySelectorAll('.file-input-new');
		Array.prototype.forEach.call(inputs, function (input) {
			var label = input.nextElementSibling,
			    labelVal = label.innerHTML;

			input.addEventListener('change', function (e) {
				var fileName = '';
				if (this.files && this.files.length > 1) fileName = (this.getAttribute('data-multiple-caption') || '').replace('{count}', this.files.length);else fileName = e.target.value.split('\\').pop();

				if (fileName) label.querySelector('span').innerHTML = fileName + '<button class="btn btn-xs btn-link btn-icon remove-file-btn" type="button"><i class="zmdi zmdi-close"></button>';
				//else
				//label.innerHTML = labelVal;
			});
		});
	});
	$('.file-uploads').on('click', '.remove-file-btn', function () {
		$(this).closest('.file-btn').remove();
	});
	$('.file-uploads').on('click', '.clear-file-btn', function (e) {
		e.preventDefault();
		$(this).closest('.file-btn label').html('<i class="zmdi zmdi-upload"></i><span>Choose a file</span>');
	});
	$('.file-uploads').bind('DOMSubtreeModified', function () {
		$('.file-btn:last-child .file-input-new').trigger('click');
	});
}

exports.default = filesUpload;

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _enquire = __webpack_require__(2);

var _enquire2 = _interopRequireDefault(_enquire);

var _superfish = __webpack_require__(8);

var _superfish2 = _interopRequireDefault(_superfish);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var navigation = {
    init: function init() {
        this.cacheDom();
        if (!$('.app-sidebar').hasClass('app-sidebar--sm')) {
            return;
        }
        this.bindEvents();
    },
    cacheDom: function cacheDom() {
        this.$navigationContainer = $('.app-sidebar.app-sidebar--sm');
        this.$sidebarNav = $('.app-sidebar_nav');
        this.$navigationDroDownLi = this.$navigationContainer.find('.nav__item.has-dropdown');
        this.$showMobileNavigationBtn = $('[data-target=".app-sidebar--main"]');
        this.$dropDownArrow = this.$navigationContainer.find('[data-toggle="back"]');
    },
    bindEvents: function bindEvents() {
        var that = this;

        this.$showMobileNavigationBtn.on('click', this.showSidebar.bind(this));
        this.setIsMobile();

        this.$dropDownArrow.on('click', function () {
            this.hideOldDropDown();
        }.bind(this));

        that.$navigationContainer.find('.has-dropdown.is-open').clickOff(function () {
            this.$navigationDroDownLi.removeClass('is-open');
        }.bind(this));
    },
    showSidebar: function showSidebar() {
        if (!this.$navigationContainer.hasClass('is-open')) {
            this.$navigationContainer.addClass('is-open');
            this.$showMobileNavigationBtn.addClass('is-active');
        } else {
            this.hideSidebar();
        }
    },
    hideSidebar: function hideSidebar() {
        this.$navigationContainer.removeClass('is-open');
        this.$showMobileNavigationBtn.removeClass('is-active');
        this.hideOldDropDown();
    },
    hideOldDropDown: function hideOldDropDown(event) {
        this.$navigationContainer.find('.has-dropdown').removeClass('is-open');
    },

    setIsMobile: function setIsMobile() {
        var that = this;
        that.isMobile = false;
        _enquire2.default.register("screen and (min-width: 0) and (max-width: 740px)", {
            match: function match() {
                that.isMobile = true;
                $('.app-sidebar__nav').superfish('destroy');
            },
            unmatch: function unmatch() {
                that.isMobile = false;
                $('.app-sidebar__nav').superfish({
                    hoverClass: 'is-open',
                    popUpSelector: '.nav--sub',
                    delay: 600,
                    animation: {}
                });
            }
        });

        _enquire2.default.register("screen and (min-width: 740px)", {
            match: function match(event) {
                that.isMobile = true;
                $('.app-sidebar__nav').superfish({
                    hoverClass: 'is-open',
                    popUpSelector: '.nav--sub',
                    delay: 600,
                    animation: {}
                });
            },
            unmatch: function unmatch() {
                $('.app-sidebar__nav').superfish('destroy');
            }
        });
    },
    clearAnimated: function clearAnimated() {}

};

exports.default = navigation;

/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _enquire = __webpack_require__(2);

var _enquire2 = _interopRequireDefault(_enquire);

var _superfish = __webpack_require__(8);

var _superfish2 = _interopRequireDefault(_superfish);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var navigation = {
    init: function init() {
        this.cacheDom();
        this.bindEvents();
    },
    cacheDom: function cacheDom() {
        this.$navigationContainer = $('.app-sidebar:not(.app-sidebar--sm)');
        this.$sidebarNav = $('.app-sidebar__nav');
        this.$navigationDroDownLi = this.$navigationContainer.find('.nav__item.has-dropdown');
        this.$showMobileNavigationBtn = $('[data-target=".app-sidebar--main"]');
        this.$dropDownArrow = this.$navigationContainer.find('[data-toggle="back"]');
    },
    bindEvents: function bindEvents() {
        this.$showMobileNavigationBtn.on('click', this.showSidebar.bind(this));

        this.$dropDownArrow.on('click', function () {
            this.hideOldDropDown();
        }.bind(this));

        $('.nav--sub').on('click', function (event) {
            event.stopPropagation(); // I need to change that
        });

        $(window).on('resize', function () {
            this.hideSidebar();
        }.bind(this));
    },

    showSidebar: function showSidebar() {
        if (!this.$navigationContainer.hasClass('is-open')) {
            this.$navigationContainer.addClass('is-open');
            this.$showMobileNavigationBtn.addClass('is-active');
        } else {
            this.hideSidebar();
        }
    },
    hideSidebar: function hideSidebar() {
        this.$navigationContainer.removeClass('is-open');
        this.$showMobileNavigationBtn.removeClass('is-active');
        this.hideOldDropDown();
    },
    hideOldDropDown: function hideOldDropDown(event) {
        this.$navigationContainer.find('.has-dropdown').removeClass('is-open');
    }
};
exports.default = navigation;

/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var table = $('.table--checkboxes');
var selectAll = table.find('thead input');
var allInputs = table.find('tbody input');
var checkedCounter = 0;

function changeSelectAll(checkedCounter) {
    if (allInputs.length == checkedCounter) {
        selectAll.prop('checked', true);
    } else {
        selectAll.prop('checked', false);
    }
}

selectAll.on('change', function (event) {
    allInputs.prop('checked', event.target.checked);
    if (event.target.checked) {
        checkedCounter = allInputs.length;
    } else {
        checkedCounter = 0;
    }
});

allInputs.on('change', function (event) {
    if (event.target.checked) {
        checkedCounter++;
        changeSelectAll(checkedCounter);
    } else {
        checkedCounter--;
        changeSelectAll(checkedCounter);
    }
});

$('.table--collapsible tr').on('hidden.bs.collapse', function () {
    $(this).find('.zmdi-plus').toggleClass('zmdi-plus zmdi-minus');
    console.log($(this).find('.zmdi-plus'));
});

/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var openCounter = 0,
    allRows = $('.table--collapsible > tbody > tr').length / 2;

function changeSelectAllIcon() {
    var $icon = $('.table--collapsible .select-all i');
    console.log(openCounter);
    if (openCounter === 0) {
        $icon.removeClass('zmdi-minus').addClass('zmdi-plus');
    } else {
        $icon.removeClass('zmdi-plus').addClass('zmdi-minus');
    }
}

$('.table--collapsible .collapseInit').on('click', function () {

    var id = $(this).attr('href');
    $(id).collapse('toggle');
});

$('.table--collapsible .select-all').on('click', function () {
    var $icon = $('.table--collapsible .select-all i');
    if ($icon.hasClass('zmdi-plus')) {
        $(this).closest('.table--collapsible').find('.collapse').collapse('show');
    } else {
        $(this).closest('.table--collapsible').find('.collapse').collapse('hide');
    }
});

$('.table--collapsible').find('.collapse').on('hidden.bs.collapse', function () {

    $(this).prev().find('i').removeClass('zmdi-minus').addClass('zmdi-plus');
    openCounter--;
    changeSelectAllIcon();
});
$('.table--collapsible').find('.collapse').on('shown.bs.collapse', function () {

    $(this).prev().find('i').removeClass('zmdi-plus').addClass('zmdi-minus');
    openCounter++;
    changeSelectAllIcon();
});

/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _datatables = __webpack_require__(4);

var _datatables2 = _interopRequireDefault(_datatables);

var _datatables3 = __webpack_require__(27);

var _datatables4 = _interopRequireDefault(_datatables3);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var initTable = {
    init: function init() {
        this.cacheDom();
        this.bindEvents();
        this.initPlugin();
        this.filterColumns();
        this.customSearch();
    },
    cacheDom: function cacheDom() {
        this.tableId = $('#services-table');
        this.tableFilters = $(".table-search .dropdown__menu");
        this.tableFilter = $(this.tableFilters).find('li');
    },
    bindEvents: function bindEvents() {
        $('body').on('click', this.tableFilter, this.filterColumns.bind(this));
    },
    initPlugin: function initPlugin() {
        var tableFooter = this.tableId.data('table-footer');
        var dom = '';
        var tableItemsLenght = this.tableId.find('tbody tr').length;
        if (tableItemsLenght >= 6) {
            dom = '<t><"table-footer"p B>';
        } else {
            dom = '<t>';
        }
        this.table = this.tableId.DataTable({
            "dom": dom,
            "autoWidth": false,
            "pageLength": 6,
            "lengthMenu": [2, 3, 100],
            "language": {
                "paginate": {
                    "previous": " ",
                    "next": " "
                }
            },
            "columnDefs": [{
                "targets": 'no-sort',
                "orderable": false
            }],
            buttons: [{
                text: '15',
                action: function action(e, dt, node, config) {
                    dt.page.len(6).draw();
                    $(node).parent().find('.active').removeClass('active');
                    $(node).addClass('active');
                },
                init: function init(dt, node, config) {
                    $(node).addClass('active');
                }
            }, {
                text: '25',
                action: function action(e, dt, node, config) {
                    dt.page.len(25).draw();
                    $(node).parent().find('.active').removeClass('active');
                    $(node).addClass('active');
                }
            }, {
                text: '∞',
                action: function action(e, dt, node, config) {
                    dt.page.len(1000).draw();
                    $(node).parent().find('.active').removeClass('active');
                    $(node).addClass('active');
                }
            }]
        });
    },
    filterColumns: function filterColumns(event) {
        var table = this.tableId.dataTable();
        var that = this;
        $('body').on('click', '[data-filter] li', function () {
            var $filtersList = $(this).closest('ul'),
                $filtersListTarget = $filtersList.data('filter');
            table.fnFilter($(this).data('value'), 0, true);

            if ($(this).data('value')) {
                $("[data-table-filter='" + $filtersListTarget + "']").find('.filter').text($(this).data('value'));
            } else {
                $("[data-table-filter='" + $filtersListTarget + "']").find('.filter').text('All');
            }

            $filtersList.find('.is-active').removeClass('is-active');
            $(this).addClass('is-active');
            console.log(Drop.drops);
        });
    },
    customSearch: function customSearch() {
        var that = this;
        $('.table-search').on('keyup', function () {
            console.log('sd');
            that.table.column(0).search(this.value).draw();
        });
    }
};

exports.default = initTable;

/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


$('[data-table-link] tbody tr').on('click', function (event) {
    var $url = $(this).data('url');
    console.log($url);
    window.location.href = $url;
});
$('.table label, .table .has-dropdown, .table a').on('click', function (event) {
    event.stopPropagation();
});

/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _Swiper = __webpack_require__(1);

var _Swiper2 = _interopRequireDefault(_Swiper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var delayTime = function delayTime(callback, ms) {
    clearTimeout(eventTime);
    var eventTime = setTimeout(callback, ms);
};

// var tabslider = {
//     slider: [],
//     storage: {},
//     init: function () {

//         this.tabSlider();
//         this.elementCheck();
//         this.bindEvents();
//     },
//     bindEvents: function () {
//         $(window).on('resize', this.resize.bind(this));
//         $('.ls-swiper__slide').on('click', this.getActive.bind(this));
//     },
//     tabSlider: function () {
//         var that = this;
//         if ($('.ls-swiper').length > 0) {
//             $('.ls-swiper').each(function (index) {
//                 var tabsWidth = 0;
//                 var tabContainer = document.querySelectorAll('.ls-swiper')[index].offsetWidth;
//                 var navTabs = $(this).find('.ls-swiper__slide')
//                 navTabs.each(function () {
//                     tabsWidth += $(this).outerWidth(true);

//                 });
//                 if ((tabsWidth > tabContainer) && (that.slider[index] === undefined)) {

//                     that.slider[index] = new Swiper(this, {
//                         slidesPerView: 'auto',
//                         speed: 0
//                     });
//                     // console.log( that.slider);
//                 } else if ((tabsWidth < tabContainer) && (that.slider.length > 0)) {
//                     // console.log('działa' + index);
//                     if(that.slider[index] !== undefined){
//                         that.slider[index].destroy(false, true);
//                         that.slider[index] = undefined;
//                     }

//                 }
//             });

//         }

//     },
//     localStr: function (event) {
//         var target = $(event.currentTarget).closest('.ls-swiper__slide').index();
//         var slider = $(event.currentTarget).closest('.ls-swiper').data('name');
//         this.storage[slider] = target;
//         console.log(target);
//         localStorage.setItem('currentActitve', JSON.stringify(this.storage));
//     },
//     elementCheck: function () {
//         var liIndex = JSON.parse(localStorage.getItem('currentActitve'));
//         window.storage = liIndex;
//         var that = this;
//         // console.log(this);
//         $('.ls-swiper').each(function (index) {
//             var active = $('.ls-swiper__slide.is-active').index();
//             var data = $(this).data('name');
//             console.log(that.slider);
//             for (var key in liIndex) {
//                 if (key === data) {
//                     if ((active != liIndex[key]) && (that.slider[index] != undefined)) {
//                         that.slider[index].slideTo(liIndex[key]);
//                         $(this).find('.ls-swiper__slide.is-active').removeClass('is-active');
//                         $(this).find('.ls-swiper__slide').eq(liIndex[key]).addClass('is-active');
//                     } else {
//                         $(this).find('.ls-swiper__slide.is-active').removeClass('is-active');
//                         $(this).find('.ls-swiper__slide').eq(liIndex[key]).addClass('is-active');
//                     }
//                 }
//             }
//         });
//     },

//     resize: function () {
//         var that = this;
//         var liIndex = JSON.parse(localStorage.getItem('currentActitve'));
//         delayTime(function(){
//                 that.tabSlider()
//                 $('.ls-swiper').each(function (index){
//                     console.log(index);
//                     var active = $('.ls-swiper__slide.swiper-slide-active').index();
//                     var data = $(this).data('name');
//                     for (var key in liIndex) {
//                         if (key === data) {
//                             if ((active != liIndex[key]) && (that.slider[index] != undefined)) {
//                                 console.log(that.slider[index]);
//                                 console.log(liIndex[key]);
//                                 that.slider[index].slideTo(liIndex[key]);
//                             }
//                         }
//                     }
//                 });

//             },
//             50);
//     },
//     getActive: function (event) {

//         console.log(" getafctiveasda " + event);

//         $(event.currentTarget).addClass('is-active').siblings().removeClass('is-active');
//         this.localStr(event);

//     }

// };

var tabSlider = {
    slider: [],
    storage: {},
    init: function init() {

        this.tabSlider();
        this.bindEvents();
        this.tabsContent();
        if ($('.nav--tabs[role="data-tab"] .nav__link').length > 0) {
            this.hashChange();
        }
        this.setIndexes();
        this.slideTo();
    },
    bindEvents: function bindEvents() {
        $(window).on('resize', this.resize.bind(this));

        $('.ls-swiper__slide').on('click', this.slideToClicked.bind(this));
        $(window).on('popstate', this.tabsContent.bind(this));
    },
    tabSlider: function tabSlider() {
        var that = this;
        if ($('.ls-swiper').length > 0) {
            $('.ls-swiper').each(function (index) {
                var tabsWidth = 0;
                var tabContainer = document.querySelectorAll('.ls-swiper')[index].offsetWidth;
                var navTabs = $(this).find('.ls-swiper__slide');
                navTabs.each(function () {
                    tabsWidth += $(this).outerWidth(true);
                });
                if (tabsWidth > tabContainer && that.slider[index] === undefined) {

                    that.slider[index] = new _Swiper2.default(this, {
                        slidesPerView: 'auto',
                        speed: 0,
                        freMode: true
                    });
                } else if (tabsWidth < tabContainer && that.slider.length > 0) {
                    if (that.slider[index] !== undefined) {
                        that.slider[index].destroy(false, true);
                        that.slider[index] = undefined;
                    }
                }
            });
        }
    },

    slideToClicked: function slideToClicked(event) {
        var target = event.target;
        var slide = $(target).closest('.ls-swiper__slide').index();
        var swiper = $(target).closest('.ls-swiper').attr('data-index');
        if (this.slider[swiper] != undefined) {
            this.slider[swiper].slideTo(slide);
        }
    },
    setIndexes: function setIndexes() {
        var index = 0;
        $('.ls-swiper').each(function (index, el) {
            $(this).attr('data-index', index);
            index++;
        });
    },

    resize: function resize() {
        var that = this;
        delayTime(function () {
            that.tabSlider();
            that.slideTo();
        }, 50);
    },

    slideTo: function slideTo() {
        var that = this;
        $('.ls-swiper').each(function (index) {
            var active = $(this).find('.ls-swiper__slide.is-active').index();
            if (that.slider[index] != undefined) {
                that.slider[index].slideTo(active);
            }
        });
    },

    //Adding class active to hash tabs
    tabsContent: function tabsContent() {
        var datatabs = $('.nav--tabs[role="data-tab"] .nav__link');
        datatabs.each(function () {
            var href = $(this).attr('href').replace('#tab-', '#');
            if (href === document.location.hash) {
                $(this).closest('.nav__item').siblings('.is-active').removeClass('is-active');
                $(this).closest('.nav__item').addClass('is-active');
            }
        });
    },

    hashChange: function hashChange() {
        var href = $('.nav--tabs[role="data-tab"] .nav__link').attr('href').replace('#tab-', '#');
        var context = $('.nav--tabs');
        var prefix = "#tab-";

        var settings = $.extend({
            getHashCallback: function getHashCallback(hash) {
                return hash;
            }
        });

        $('a', context).on('click', function () {
            var hash = this.hash.replace(prefix, "#");
            window.location.hash = settings.getHashCallback(hash);
        });

        var showTabFromHash = function showTabFromHash() {
            var hash = window.location.hash;
            var selector = hash ? 'a[href="' + hash.replace("#", prefix) + '"]' : 'li:first-child > a';
            $(selector, context).tab('show');
        };

        if (window.location.hash) {
            showTabFromHash(context);
        }

        $(window).on('hashchange', showTabFromHash);

        if (window.location.hash.length === 0) {
            window.location.hash = href;
        }
    }

};

exports.default = tabSlider;

/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
var isMobile = false;
if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0, 4))) isMobile = true;

exports.default = isMobile;

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _Swiper = __webpack_require__(1);

var _Swiper2 = _interopRequireDefault(_Swiper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

$(".tiles-slider").each(function (index, element) {
    var $this = $(this);
    var slider = new _Swiper2.default($this.find('.swiper-container'), {
        slidesPerView: 3,
        slidesPerColumn: 2,
        spaceBetween: 8,
        nextButton: $this.find(".swiper-button-next")[0],
        prevButton: $this.find(".swiper-button-prev")[0],
        pagination: $this.find(".pagination")[0],
        bulletClass: 'pagination__item',
        bulletActiveClass: 'pagination__item--active',
        paginationBulletRender: function paginationBulletRender(swiper, index, className) {
            return '<span class=" ' + className + '">' + (index + 1) + '</span>';
        }
    });
});

/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _Swiper = __webpack_require__(1);

var _Swiper2 = _interopRequireDefault(_Swiper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

$(".news").each(function (index, element) {
    var $this = $(this);
    var slider = new _Swiper2.default($this.find('.swiper-container'), {
        items: 1,
        paginationClickable: true,
        spaceBetween: 8,
        nextButton: $this.find(".swiper-button-next")[0],
        prevButton: $this.find(".swiper-button-prev")[0],
        pagination: $this.find(".pagination")[0],
        bulletClass: 'pagination__item',
        bulletActiveClass: 'pagination__item--active',
        paginationBulletRender: function paginationBulletRender(swiper, index, className) {
            return '<span class=" ' + className + '">' + (index + 1) + '</span>';
        }
    });
});

/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


$('.widget .js-toggle-popup').on('click', function () {
    event.preventDefault();
    $(this).closest('.widget').find('.widget__popup').toggleClass('widget__popup--active');
    $(this).closest('.widget').find('.widget__popup-title i').toggleClass('zmdi-plus zmdi-close');
});

$(".services-slider").each(function (index, element) {
    var $this = $(this);
    var swiper = new Swiper($(this).find('.swiper-container'), {
        nextButton: $this.find(".swiper-button-next")[0],
        prevButton: $this.find(".swiper-button-prev")[0],
        pagination: $this.find(".pagination")[0],
        paginationClickable: true,
        preloadImages: false,
        lazyLoading: true,
        slidesPerView: 1,
        slidesPerColumn: 4,
        bulletClass: 'pagination__item',
        bulletActiveClass: 'pagination__item--active',
        resistanceRatio: 0,
        paginationBulletRender: function paginationBulletRender(swiper, index, className) {
            return '<span class=" ' + className + '">' + (index + 1) + '</span>';
        },
        onInit: function onInit(swiper) {
            if (swiper.slides.length <= 4) {
                $this.find(".widget__pagination").addClass('hidden');
            }
        }
    });
});

/***/ }),
/* 48 */,
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

/*! jQuery UI - v1.12.1 - 2017-03-23
* http://jqueryui.com
* Includes: widget.js, keycode.js, widgets/mouse.js, widgets/slider.js
* Copyright jQuery Foundation and other contributors; Licensed MIT */

(function (factory) {
	if (true) {

		// AMD. Register as an anonymous module.
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(0)], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {

		// Browser globals
		factory(jQuery);
	}
})(function ($) {

	$.ui = $.ui || {};

	var version = $.ui.version = "1.12.1";

	/*!
  * jQuery UI Widget 1.12.1
  * http://jqueryui.com
  *
  * Copyright jQuery Foundation and other contributors
  * Released under the MIT license.
  * http://jquery.org/license
  */

	//>>label: Widget
	//>>group: Core
	//>>description: Provides a factory for creating stateful widgets with a common API.
	//>>docs: http://api.jqueryui.com/jQuery.widget/
	//>>demos: http://jqueryui.com/widget/


	var widgetUuid = 0;
	var widgetSlice = Array.prototype.slice;

	$.cleanData = function (orig) {
		return function (elems) {
			var events, elem, i;
			for (i = 0; (elem = elems[i]) != null; i++) {
				try {

					// Only trigger remove when necessary to save time
					events = $._data(elem, "events");
					if (events && events.remove) {
						$(elem).triggerHandler("remove");
					}

					// Http://bugs.jquery.com/ticket/8235
				} catch (e) {}
			}
			orig(elems);
		};
	}($.cleanData);

	$.widget = function (name, base, prototype) {
		var existingConstructor, constructor, basePrototype;

		// ProxiedPrototype allows the provided prototype to remain unmodified
		// so that it can be used as a mixin for multiple widgets (#8876)
		var proxiedPrototype = {};

		var namespace = name.split(".")[0];
		name = name.split(".")[1];
		var fullName = namespace + "-" + name;

		if (!prototype) {
			prototype = base;
			base = $.Widget;
		}

		if ($.isArray(prototype)) {
			prototype = $.extend.apply(null, [{}].concat(prototype));
		}

		// Create selector for plugin
		$.expr[":"][fullName.toLowerCase()] = function (elem) {
			return !!$.data(elem, fullName);
		};

		$[namespace] = $[namespace] || {};
		existingConstructor = $[namespace][name];
		constructor = $[namespace][name] = function (options, element) {

			// Allow instantiation without "new" keyword
			if (!this._createWidget) {
				return new constructor(options, element);
			}

			// Allow instantiation without initializing for simple inheritance
			// must use "new" keyword (the code above always passes args)
			if (arguments.length) {
				this._createWidget(options, element);
			}
		};

		// Extend with the existing constructor to carry over any static properties
		$.extend(constructor, existingConstructor, {
			version: prototype.version,

			// Copy the object used to create the prototype in case we need to
			// redefine the widget later
			_proto: $.extend({}, prototype),

			// Track widgets that inherit from this widget in case this widget is
			// redefined after a widget inherits from it
			_childConstructors: []
		});

		basePrototype = new base();

		// We need to make the options hash a property directly on the new instance
		// otherwise we'll modify the options hash on the prototype that we're
		// inheriting from
		basePrototype.options = $.widget.extend({}, basePrototype.options);
		$.each(prototype, function (prop, value) {
			if (!$.isFunction(value)) {
				proxiedPrototype[prop] = value;
				return;
			}
			proxiedPrototype[prop] = function () {
				function _super() {
					return base.prototype[prop].apply(this, arguments);
				}

				function _superApply(args) {
					return base.prototype[prop].apply(this, args);
				}

				return function () {
					var __super = this._super;
					var __superApply = this._superApply;
					var returnValue;

					this._super = _super;
					this._superApply = _superApply;

					returnValue = value.apply(this, arguments);

					this._super = __super;
					this._superApply = __superApply;

					return returnValue;
				};
			}();
		});
		constructor.prototype = $.widget.extend(basePrototype, {

			// TODO: remove support for widgetEventPrefix
			// always use the name + a colon as the prefix, e.g., draggable:start
			// don't prefix for widgets that aren't DOM-based
			widgetEventPrefix: existingConstructor ? basePrototype.widgetEventPrefix || name : name
		}, proxiedPrototype, {
			constructor: constructor,
			namespace: namespace,
			widgetName: name,
			widgetFullName: fullName
		});

		// If this widget is being redefined then we need to find all widgets that
		// are inheriting from it and redefine all of them so that they inherit from
		// the new version of this widget. We're essentially trying to replace one
		// level in the prototype chain.
		if (existingConstructor) {
			$.each(existingConstructor._childConstructors, function (i, child) {
				var childPrototype = child.prototype;

				// Redefine the child widget using the same prototype that was
				// originally used, but inherit from the new version of the base
				$.widget(childPrototype.namespace + "." + childPrototype.widgetName, constructor, child._proto);
			});

			// Remove the list of existing child constructors from the old constructor
			// so the old child constructors can be garbage collected
			delete existingConstructor._childConstructors;
		} else {
			base._childConstructors.push(constructor);
		}

		$.widget.bridge(name, constructor);

		return constructor;
	};

	$.widget.extend = function (target) {
		var input = widgetSlice.call(arguments, 1);
		var inputIndex = 0;
		var inputLength = input.length;
		var key;
		var value;

		for (; inputIndex < inputLength; inputIndex++) {
			for (key in input[inputIndex]) {
				value = input[inputIndex][key];
				if (input[inputIndex].hasOwnProperty(key) && value !== undefined) {

					// Clone objects
					if ($.isPlainObject(value)) {
						target[key] = $.isPlainObject(target[key]) ? $.widget.extend({}, target[key], value) :

						// Don't extend strings, arrays, etc. with objects
						$.widget.extend({}, value);

						// Copy everything else by reference
					} else {
						target[key] = value;
					}
				}
			}
		}
		return target;
	};

	$.widget.bridge = function (name, object) {
		var fullName = object.prototype.widgetFullName || name;
		$.fn[name] = function (options) {
			var isMethodCall = typeof options === "string";
			var args = widgetSlice.call(arguments, 1);
			var returnValue = this;

			if (isMethodCall) {

				// If this is an empty collection, we need to have the instance method
				// return undefined instead of the jQuery instance
				if (!this.length && options === "instance") {
					returnValue = undefined;
				} else {
					this.each(function () {
						var methodValue;
						var instance = $.data(this, fullName);

						if (options === "instance") {
							returnValue = instance;
							return false;
						}

						if (!instance) {
							return $.error("cannot call methods on " + name + " prior to initialization; " + "attempted to call method '" + options + "'");
						}

						if (!$.isFunction(instance[options]) || options.charAt(0) === "_") {
							return $.error("no such method '" + options + "' for " + name + " widget instance");
						}

						methodValue = instance[options].apply(instance, args);

						if (methodValue !== instance && methodValue !== undefined) {
							returnValue = methodValue && methodValue.jquery ? returnValue.pushStack(methodValue.get()) : methodValue;
							return false;
						}
					});
				}
			} else {

				// Allow multiple hashes to be passed on init
				if (args.length) {
					options = $.widget.extend.apply(null, [options].concat(args));
				}

				this.each(function () {
					var instance = $.data(this, fullName);
					if (instance) {
						instance.option(options || {});
						if (instance._init) {
							instance._init();
						}
					} else {
						$.data(this, fullName, new object(options, this));
					}
				});
			}

			return returnValue;
		};
	};

	$.Widget = function () /* options, element */{};
	$.Widget._childConstructors = [];

	$.Widget.prototype = {
		widgetName: "widget",
		widgetEventPrefix: "",
		defaultElement: "<div>",

		options: {
			classes: {},
			disabled: false,

			// Callbacks
			create: null
		},

		_createWidget: function _createWidget(options, element) {
			element = $(element || this.defaultElement || this)[0];
			this.element = $(element);
			this.uuid = widgetUuid++;
			this.eventNamespace = "." + this.widgetName + this.uuid;

			this.bindings = $();
			this.hoverable = $();
			this.focusable = $();
			this.classesElementLookup = {};

			if (element !== this) {
				$.data(element, this.widgetFullName, this);
				this._on(true, this.element, {
					remove: function remove(event) {
						if (event.target === element) {
							this.destroy();
						}
					}
				});
				this.document = $(element.style ?

				// Element within the document
				element.ownerDocument :

				// Element is window or document
				element.document || element);
				this.window = $(this.document[0].defaultView || this.document[0].parentWindow);
			}

			this.options = $.widget.extend({}, this.options, this._getCreateOptions(), options);

			this._create();

			if (this.options.disabled) {
				this._setOptionDisabled(this.options.disabled);
			}

			this._trigger("create", null, this._getCreateEventData());
			this._init();
		},

		_getCreateOptions: function _getCreateOptions() {
			return {};
		},

		_getCreateEventData: $.noop,

		_create: $.noop,

		_init: $.noop,

		destroy: function destroy() {
			var that = this;

			this._destroy();
			$.each(this.classesElementLookup, function (key, value) {
				that._removeClass(value, key);
			});

			// We can probably remove the unbind calls in 2.0
			// all event bindings should go through this._on()
			this.element.off(this.eventNamespace).removeData(this.widgetFullName);
			this.widget().off(this.eventNamespace).removeAttr("aria-disabled");

			// Clean up events and states
			this.bindings.off(this.eventNamespace);
		},

		_destroy: $.noop,

		widget: function widget() {
			return this.element;
		},

		option: function option(key, value) {
			var options = key;
			var parts;
			var curOption;
			var i;

			if (arguments.length === 0) {

				// Don't return a reference to the internal hash
				return $.widget.extend({}, this.options);
			}

			if (typeof key === "string") {

				// Handle nested keys, e.g., "foo.bar" => { foo: { bar: ___ } }
				options = {};
				parts = key.split(".");
				key = parts.shift();
				if (parts.length) {
					curOption = options[key] = $.widget.extend({}, this.options[key]);
					for (i = 0; i < parts.length - 1; i++) {
						curOption[parts[i]] = curOption[parts[i]] || {};
						curOption = curOption[parts[i]];
					}
					key = parts.pop();
					if (arguments.length === 1) {
						return curOption[key] === undefined ? null : curOption[key];
					}
					curOption[key] = value;
				} else {
					if (arguments.length === 1) {
						return this.options[key] === undefined ? null : this.options[key];
					}
					options[key] = value;
				}
			}

			this._setOptions(options);

			return this;
		},

		_setOptions: function _setOptions(options) {
			var key;

			for (key in options) {
				this._setOption(key, options[key]);
			}

			return this;
		},

		_setOption: function _setOption(key, value) {
			if (key === "classes") {
				this._setOptionClasses(value);
			}

			this.options[key] = value;

			if (key === "disabled") {
				this._setOptionDisabled(value);
			}

			return this;
		},

		_setOptionClasses: function _setOptionClasses(value) {
			var classKey, elements, currentElements;

			for (classKey in value) {
				currentElements = this.classesElementLookup[classKey];
				if (value[classKey] === this.options.classes[classKey] || !currentElements || !currentElements.length) {
					continue;
				}

				// We are doing this to create a new jQuery object because the _removeClass() call
				// on the next line is going to destroy the reference to the current elements being
				// tracked. We need to save a copy of this collection so that we can add the new classes
				// below.
				elements = $(currentElements.get());
				this._removeClass(currentElements, classKey);

				// We don't use _addClass() here, because that uses this.options.classes
				// for generating the string of classes. We want to use the value passed in from
				// _setOption(), this is the new value of the classes option which was passed to
				// _setOption(). We pass this value directly to _classes().
				elements.addClass(this._classes({
					element: elements,
					keys: classKey,
					classes: value,
					add: true
				}));
			}
		},

		_setOptionDisabled: function _setOptionDisabled(value) {
			this._toggleClass(this.widget(), this.widgetFullName + "-disabled", null, !!value);

			// If the widget is becoming disabled, then nothing is interactive
			if (value) {
				this._removeClass(this.hoverable, null, "ui-state-hover");
				this._removeClass(this.focusable, null, "ui-state-focus");
			}
		},

		enable: function enable() {
			return this._setOptions({ disabled: false });
		},

		disable: function disable() {
			return this._setOptions({ disabled: true });
		},

		_classes: function _classes(options) {
			var full = [];
			var that = this;

			options = $.extend({
				element: this.element,
				classes: this.options.classes || {}
			}, options);

			function processClassString(classes, checkOption) {
				var current, i;
				for (i = 0; i < classes.length; i++) {
					current = that.classesElementLookup[classes[i]] || $();
					if (options.add) {
						current = $($.unique(current.get().concat(options.element.get())));
					} else {
						current = $(current.not(options.element).get());
					}
					that.classesElementLookup[classes[i]] = current;
					full.push(classes[i]);
					if (checkOption && options.classes[classes[i]]) {
						full.push(options.classes[classes[i]]);
					}
				}
			}

			this._on(options.element, {
				"remove": "_untrackClassesElement"
			});

			if (options.keys) {
				processClassString(options.keys.match(/\S+/g) || [], true);
			}
			if (options.extra) {
				processClassString(options.extra.match(/\S+/g) || []);
			}

			return full.join(" ");
		},

		_untrackClassesElement: function _untrackClassesElement(event) {
			var that = this;
			$.each(that.classesElementLookup, function (key, value) {
				if ($.inArray(event.target, value) !== -1) {
					that.classesElementLookup[key] = $(value.not(event.target).get());
				}
			});
		},

		_removeClass: function _removeClass(element, keys, extra) {
			return this._toggleClass(element, keys, extra, false);
		},

		_addClass: function _addClass(element, keys, extra) {
			return this._toggleClass(element, keys, extra, true);
		},

		_toggleClass: function _toggleClass(element, keys, extra, add) {
			add = typeof add === "boolean" ? add : extra;
			var shift = typeof element === "string" || element === null,
			    options = {
				extra: shift ? keys : extra,
				keys: shift ? element : keys,
				element: shift ? this.element : element,
				add: add
			};
			options.element.toggleClass(this._classes(options), add);
			return this;
		},

		_on: function _on(suppressDisabledCheck, element, handlers) {
			var delegateElement;
			var instance = this;

			// No suppressDisabledCheck flag, shuffle arguments
			if (typeof suppressDisabledCheck !== "boolean") {
				handlers = element;
				element = suppressDisabledCheck;
				suppressDisabledCheck = false;
			}

			// No element argument, shuffle and use this.element
			if (!handlers) {
				handlers = element;
				element = this.element;
				delegateElement = this.widget();
			} else {
				element = delegateElement = $(element);
				this.bindings = this.bindings.add(element);
			}

			$.each(handlers, function (event, handler) {
				function handlerProxy() {

					// Allow widgets to customize the disabled handling
					// - disabled as an array instead of boolean
					// - disabled class as method for disabling individual parts
					if (!suppressDisabledCheck && (instance.options.disabled === true || $(this).hasClass("ui-state-disabled"))) {
						return;
					}
					return (typeof handler === "string" ? instance[handler] : handler).apply(instance, arguments);
				}

				// Copy the guid so direct unbinding works
				if (typeof handler !== "string") {
					handlerProxy.guid = handler.guid = handler.guid || handlerProxy.guid || $.guid++;
				}

				var match = event.match(/^([\w:-]*)\s*(.*)$/);
				var eventName = match[1] + instance.eventNamespace;
				var selector = match[2];

				if (selector) {
					delegateElement.on(eventName, selector, handlerProxy);
				} else {
					element.on(eventName, handlerProxy);
				}
			});
		},

		_off: function _off(element, eventName) {
			eventName = (eventName || "").split(" ").join(this.eventNamespace + " ") + this.eventNamespace;
			element.off(eventName).off(eventName);

			// Clear the stack to avoid memory leaks (#10056)
			this.bindings = $(this.bindings.not(element).get());
			this.focusable = $(this.focusable.not(element).get());
			this.hoverable = $(this.hoverable.not(element).get());
		},

		_delay: function _delay(handler, delay) {
			function handlerProxy() {
				return (typeof handler === "string" ? instance[handler] : handler).apply(instance, arguments);
			}
			var instance = this;
			return setTimeout(handlerProxy, delay || 0);
		},

		_hoverable: function _hoverable(element) {
			this.hoverable = this.hoverable.add(element);
			this._on(element, {
				mouseenter: function mouseenter(event) {
					this._addClass($(event.currentTarget), null, "ui-state-hover");
				},
				mouseleave: function mouseleave(event) {
					this._removeClass($(event.currentTarget), null, "ui-state-hover");
				}
			});
		},

		_focusable: function _focusable(element) {
			this.focusable = this.focusable.add(element);
			this._on(element, {
				focusin: function focusin(event) {
					this._addClass($(event.currentTarget), null, "ui-state-focus");
				},
				focusout: function focusout(event) {
					this._removeClass($(event.currentTarget), null, "ui-state-focus");
				}
			});
		},

		_trigger: function _trigger(type, event, data) {
			var prop, orig;
			var callback = this.options[type];

			data = data || {};
			event = $.Event(event);
			event.type = (type === this.widgetEventPrefix ? type : this.widgetEventPrefix + type).toLowerCase();

			// The original event may come from any element
			// so we need to reset the target on the new event
			event.target = this.element[0];

			// Copy original event properties over to the new event
			orig = event.originalEvent;
			if (orig) {
				for (prop in orig) {
					if (!(prop in event)) {
						event[prop] = orig[prop];
					}
				}
			}

			this.element.trigger(event, data);
			return !($.isFunction(callback) && callback.apply(this.element[0], [event].concat(data)) === false || event.isDefaultPrevented());
		}
	};

	$.each({ show: "fadeIn", hide: "fadeOut" }, function (method, defaultEffect) {
		$.Widget.prototype["_" + method] = function (element, options, callback) {
			if (typeof options === "string") {
				options = { effect: options };
			}

			var hasOptions;
			var effectName = !options ? method : options === true || typeof options === "number" ? defaultEffect : options.effect || defaultEffect;

			options = options || {};
			if (typeof options === "number") {
				options = { duration: options };
			}

			hasOptions = !$.isEmptyObject(options);
			options.complete = callback;

			if (options.delay) {
				element.delay(options.delay);
			}

			if (hasOptions && $.effects && $.effects.effect[effectName]) {
				element[method](options);
			} else if (effectName !== method && element[effectName]) {
				element[effectName](options.duration, options.easing, callback);
			} else {
				element.queue(function (next) {
					$(this)[method]();
					if (callback) {
						callback.call(element[0]);
					}
					next();
				});
			}
		};
	});

	var widget = $.widget;

	/*!
  * jQuery UI Keycode 1.12.1
  * http://jqueryui.com
  *
  * Copyright jQuery Foundation and other contributors
  * Released under the MIT license.
  * http://jquery.org/license
  */

	//>>label: Keycode
	//>>group: Core
	//>>description: Provide keycodes as keynames
	//>>docs: http://api.jqueryui.com/jQuery.ui.keyCode/


	var keycode = $.ui.keyCode = {
		BACKSPACE: 8,
		COMMA: 188,
		DELETE: 46,
		DOWN: 40,
		END: 35,
		ENTER: 13,
		ESCAPE: 27,
		HOME: 36,
		LEFT: 37,
		PAGE_DOWN: 34,
		PAGE_UP: 33,
		PERIOD: 190,
		RIGHT: 39,
		SPACE: 32,
		TAB: 9,
		UP: 38
	};

	// This file is deprecated
	var ie = $.ui.ie = !!/msie [\w.]+/.exec(navigator.userAgent.toLowerCase());

	/*!
  * jQuery UI Mouse 1.12.1
  * http://jqueryui.com
  *
  * Copyright jQuery Foundation and other contributors
  * Released under the MIT license.
  * http://jquery.org/license
  */

	//>>label: Mouse
	//>>group: Widgets
	//>>description: Abstracts mouse-based interactions to assist in creating certain widgets.
	//>>docs: http://api.jqueryui.com/mouse/


	var mouseHandled = false;
	$(document).on("mouseup", function () {
		mouseHandled = false;
	});

	var widgetsMouse = $.widget("ui.mouse", {
		version: "1.12.1",
		options: {
			cancel: "input, textarea, button, select, option",
			distance: 1,
			delay: 0
		},
		_mouseInit: function _mouseInit() {
			var that = this;

			this.element.on("mousedown." + this.widgetName, function (event) {
				return that._mouseDown(event);
			}).on("click." + this.widgetName, function (event) {
				if (true === $.data(event.target, that.widgetName + ".preventClickEvent")) {
					$.removeData(event.target, that.widgetName + ".preventClickEvent");
					event.stopImmediatePropagation();
					return false;
				}
			});

			this.started = false;
		},

		// TODO: make sure destroying one instance of mouse doesn't mess with
		// other instances of mouse
		_mouseDestroy: function _mouseDestroy() {
			this.element.off("." + this.widgetName);
			if (this._mouseMoveDelegate) {
				this.document.off("mousemove." + this.widgetName, this._mouseMoveDelegate).off("mouseup." + this.widgetName, this._mouseUpDelegate);
			}
		},

		_mouseDown: function _mouseDown(event) {

			// don't let more than one widget handle mouseStart
			if (mouseHandled) {
				return;
			}

			this._mouseMoved = false;

			// We may have missed mouseup (out of window)
			this._mouseStarted && this._mouseUp(event);

			this._mouseDownEvent = event;

			var that = this,
			    btnIsLeft = event.which === 1,


			// event.target.nodeName works around a bug in IE 8 with
			// disabled inputs (#7620)
			elIsCancel = typeof this.options.cancel === "string" && event.target.nodeName ? $(event.target).closest(this.options.cancel).length : false;
			if (!btnIsLeft || elIsCancel || !this._mouseCapture(event)) {
				return true;
			}

			this.mouseDelayMet = !this.options.delay;
			if (!this.mouseDelayMet) {
				this._mouseDelayTimer = setTimeout(function () {
					that.mouseDelayMet = true;
				}, this.options.delay);
			}

			if (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {
				this._mouseStarted = this._mouseStart(event) !== false;
				if (!this._mouseStarted) {
					event.preventDefault();
					return true;
				}
			}

			// Click event may never have fired (Gecko & Opera)
			if (true === $.data(event.target, this.widgetName + ".preventClickEvent")) {
				$.removeData(event.target, this.widgetName + ".preventClickEvent");
			}

			// These delegates are required to keep context
			this._mouseMoveDelegate = function (event) {
				return that._mouseMove(event);
			};
			this._mouseUpDelegate = function (event) {
				return that._mouseUp(event);
			};

			this.document.on("mousemove." + this.widgetName, this._mouseMoveDelegate).on("mouseup." + this.widgetName, this._mouseUpDelegate);

			event.preventDefault();

			mouseHandled = true;
			return true;
		},

		_mouseMove: function _mouseMove(event) {

			// Only check for mouseups outside the document if you've moved inside the document
			// at least once. This prevents the firing of mouseup in the case of IE<9, which will
			// fire a mousemove event if content is placed under the cursor. See #7778
			// Support: IE <9
			if (this._mouseMoved) {

				// IE mouseup check - mouseup happened when mouse was out of window
				if ($.ui.ie && (!document.documentMode || document.documentMode < 9) && !event.button) {
					return this._mouseUp(event);

					// Iframe mouseup check - mouseup occurred in another document
				} else if (!event.which) {

					// Support: Safari <=8 - 9
					// Safari sets which to 0 if you press any of the following keys
					// during a drag (#14461)
					if (event.originalEvent.altKey || event.originalEvent.ctrlKey || event.originalEvent.metaKey || event.originalEvent.shiftKey) {
						this.ignoreMissingWhich = true;
					} else if (!this.ignoreMissingWhich) {
						return this._mouseUp(event);
					}
				}
			}

			if (event.which || event.button) {
				this._mouseMoved = true;
			}

			if (this._mouseStarted) {
				this._mouseDrag(event);
				return event.preventDefault();
			}

			if (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {
				this._mouseStarted = this._mouseStart(this._mouseDownEvent, event) !== false;
				this._mouseStarted ? this._mouseDrag(event) : this._mouseUp(event);
			}

			return !this._mouseStarted;
		},

		_mouseUp: function _mouseUp(event) {
			this.document.off("mousemove." + this.widgetName, this._mouseMoveDelegate).off("mouseup." + this.widgetName, this._mouseUpDelegate);

			if (this._mouseStarted) {
				this._mouseStarted = false;

				if (event.target === this._mouseDownEvent.target) {
					$.data(event.target, this.widgetName + ".preventClickEvent", true);
				}

				this._mouseStop(event);
			}

			if (this._mouseDelayTimer) {
				clearTimeout(this._mouseDelayTimer);
				delete this._mouseDelayTimer;
			}

			this.ignoreMissingWhich = false;
			mouseHandled = false;
			event.preventDefault();
		},

		_mouseDistanceMet: function _mouseDistanceMet(event) {
			return Math.max(Math.abs(this._mouseDownEvent.pageX - event.pageX), Math.abs(this._mouseDownEvent.pageY - event.pageY)) >= this.options.distance;
		},

		_mouseDelayMet: function _mouseDelayMet() /* event */{
			return this.mouseDelayMet;
		},

		// These are placeholder methods, to be overriden by extending plugin
		_mouseStart: function _mouseStart() /* event */{},
		_mouseDrag: function _mouseDrag() /* event */{},
		_mouseStop: function _mouseStop() /* event */{},
		_mouseCapture: function _mouseCapture() /* event */{
			return true;
		}
	});

	/*!
  * jQuery UI Slider 1.12.1
  * http://jqueryui.com
  *
  * Copyright jQuery Foundation and other contributors
  * Released under the MIT license.
  * http://jquery.org/license
  */

	//>>label: Slider
	//>>group: Widgets
	//>>description: Displays a flexible slider with ranges and accessibility via keyboard.
	//>>docs: http://api.jqueryui.com/slider/
	//>>demos: http://jqueryui.com/slider/
	//>>css.structure: ../../themes/base/core.css
	//>>css.structure: ../../themes/base/slider.css
	//>>css.theme: ../../themes/base/theme.css


	var widgetsSlider = $.widget("ui.slider", $.ui.mouse, {
		version: "1.12.1",
		widgetEventPrefix: "slide",

		options: {
			animate: false,
			classes: {
				"ui-slider": "ui-corner-all",
				"ui-slider-handle": "ui-corner-all",

				// Note: ui-widget-header isn't the most fittingly semantic framework class for this
				// element, but worked best visually with a variety of themes
				"ui-slider-range": "ui-corner-all ui-widget-header"
			},
			distance: 0,
			max: 100,
			min: 0,
			orientation: "horizontal",
			range: false,
			step: 1,
			value: 0,
			values: null,

			// Callbacks
			change: null,
			slide: null,
			start: null,
			stop: null
		},

		// Number of pages in a slider
		// (how many times can you page up/down to go through the whole range)
		numPages: 5,

		_create: function _create() {
			this._keySliding = false;
			this._mouseSliding = false;
			this._animateOff = true;
			this._handleIndex = null;
			this._detectOrientation();
			this._mouseInit();
			this._calculateNewMax();

			this._addClass("ui-slider ui-slider-" + this.orientation, "ui-widget ui-widget-content");

			this._refresh();

			this._animateOff = false;
		},

		_refresh: function _refresh() {
			this._createRange();
			this._createHandles();
			this._setupEvents();
			this._refreshValue();
		},

		_createHandles: function _createHandles() {
			var i,
			    handleCount,
			    options = this.options,
			    existingHandles = this.element.find(".ui-slider-handle"),
			    handle = "<span tabindex='0'></span>",
			    handles = [];

			handleCount = options.values && options.values.length || 1;

			if (existingHandles.length > handleCount) {
				existingHandles.slice(handleCount).remove();
				existingHandles = existingHandles.slice(0, handleCount);
			}

			for (i = existingHandles.length; i < handleCount; i++) {
				handles.push(handle);
			}

			this.handles = existingHandles.add($(handles.join("")).appendTo(this.element));

			this._addClass(this.handles, "ui-slider-handle", "ui-state-default");

			this.handle = this.handles.eq(0);

			this.handles.each(function (i) {
				$(this).data("ui-slider-handle-index", i).attr("tabIndex", 0);
			});
		},

		_createRange: function _createRange() {
			var options = this.options;

			if (options.range) {
				if (options.range === true) {
					if (!options.values) {
						options.values = [this._valueMin(), this._valueMin()];
					} else if (options.values.length && options.values.length !== 2) {
						options.values = [options.values[0], options.values[0]];
					} else if ($.isArray(options.values)) {
						options.values = options.values.slice(0);
					}
				}

				if (!this.range || !this.range.length) {
					this.range = $("<div>").appendTo(this.element);

					this._addClass(this.range, "ui-slider-range");
				} else {
					this._removeClass(this.range, "ui-slider-range-min ui-slider-range-max");

					// Handle range switching from true to min/max
					this.range.css({
						"left": "",
						"bottom": ""
					});
				}
				if (options.range === "min" || options.range === "max") {
					this._addClass(this.range, "ui-slider-range-" + options.range);
				}
			} else {
				if (this.range) {
					this.range.remove();
				}
				this.range = null;
			}
		},

		_setupEvents: function _setupEvents() {
			this._off(this.handles);
			this._on(this.handles, this._handleEvents);
			this._hoverable(this.handles);
			this._focusable(this.handles);
		},

		_destroy: function _destroy() {
			this.handles.remove();
			if (this.range) {
				this.range.remove();
			}

			this._mouseDestroy();
		},

		_mouseCapture: function _mouseCapture(event) {
			var position,
			    normValue,
			    distance,
			    closestHandle,
			    index,
			    allowed,
			    offset,
			    mouseOverHandle,
			    that = this,
			    o = this.options;

			if (o.disabled) {
				return false;
			}

			this.elementSize = {
				width: this.element.outerWidth(),
				height: this.element.outerHeight()
			};
			this.elementOffset = this.element.offset();

			position = { x: event.pageX, y: event.pageY };
			normValue = this._normValueFromMouse(position);
			distance = this._valueMax() - this._valueMin() + 1;
			this.handles.each(function (i) {
				var thisDistance = Math.abs(normValue - that.values(i));
				if (distance > thisDistance || distance === thisDistance && (i === that._lastChangedValue || that.values(i) === o.min)) {
					distance = thisDistance;
					closestHandle = $(this);
					index = i;
				}
			});

			allowed = this._start(event, index);
			if (allowed === false) {
				return false;
			}
			this._mouseSliding = true;

			this._handleIndex = index;

			this._addClass(closestHandle, null, "ui-state-active");
			closestHandle.trigger("focus");

			offset = closestHandle.offset();
			mouseOverHandle = !$(event.target).parents().addBack().is(".ui-slider-handle");
			this._clickOffset = mouseOverHandle ? { left: 0, top: 0 } : {
				left: event.pageX - offset.left - closestHandle.width() / 2,
				top: event.pageY - offset.top - closestHandle.height() / 2 - (parseInt(closestHandle.css("borderTopWidth"), 10) || 0) - (parseInt(closestHandle.css("borderBottomWidth"), 10) || 0) + (parseInt(closestHandle.css("marginTop"), 10) || 0)
			};

			if (!this.handles.hasClass("ui-state-hover")) {
				this._slide(event, index, normValue);
			}
			this._animateOff = true;
			return true;
		},

		_mouseStart: function _mouseStart() {
			return true;
		},

		_mouseDrag: function _mouseDrag(event) {
			var position = { x: event.pageX, y: event.pageY },
			    normValue = this._normValueFromMouse(position);

			this._slide(event, this._handleIndex, normValue);

			return false;
		},

		_mouseStop: function _mouseStop(event) {
			this._removeClass(this.handles, null, "ui-state-active");
			this._mouseSliding = false;

			this._stop(event, this._handleIndex);
			this._change(event, this._handleIndex);

			this._handleIndex = null;
			this._clickOffset = null;
			this._animateOff = false;

			return false;
		},

		_detectOrientation: function _detectOrientation() {
			this.orientation = this.options.orientation === "vertical" ? "vertical" : "horizontal";
		},

		_normValueFromMouse: function _normValueFromMouse(position) {
			var pixelTotal, pixelMouse, percentMouse, valueTotal, valueMouse;

			if (this.orientation === "horizontal") {
				pixelTotal = this.elementSize.width;
				pixelMouse = position.x - this.elementOffset.left - (this._clickOffset ? this._clickOffset.left : 0);
			} else {
				pixelTotal = this.elementSize.height;
				pixelMouse = position.y - this.elementOffset.top - (this._clickOffset ? this._clickOffset.top : 0);
			}

			percentMouse = pixelMouse / pixelTotal;
			if (percentMouse > 1) {
				percentMouse = 1;
			}
			if (percentMouse < 0) {
				percentMouse = 0;
			}
			if (this.orientation === "vertical") {
				percentMouse = 1 - percentMouse;
			}

			valueTotal = this._valueMax() - this._valueMin();
			valueMouse = this._valueMin() + percentMouse * valueTotal;

			return this._trimAlignValue(valueMouse);
		},

		_uiHash: function _uiHash(index, value, values) {
			var uiHash = {
				handle: this.handles[index],
				handleIndex: index,
				value: value !== undefined ? value : this.value()
			};

			if (this._hasMultipleValues()) {
				uiHash.value = value !== undefined ? value : this.values(index);
				uiHash.values = values || this.values();
			}

			return uiHash;
		},

		_hasMultipleValues: function _hasMultipleValues() {
			return this.options.values && this.options.values.length;
		},

		_start: function _start(event, index) {
			return this._trigger("start", event, this._uiHash(index));
		},

		_slide: function _slide(event, index, newVal) {
			var allowed,
			    otherVal,
			    currentValue = this.value(),
			    newValues = this.values();

			if (this._hasMultipleValues()) {
				otherVal = this.values(index ? 0 : 1);
				currentValue = this.values(index);

				if (this.options.values.length === 2 && this.options.range === true) {
					newVal = index === 0 ? Math.min(otherVal, newVal) : Math.max(otherVal, newVal);
				}

				newValues[index] = newVal;
			}

			if (newVal === currentValue) {
				return;
			}

			allowed = this._trigger("slide", event, this._uiHash(index, newVal, newValues));

			// A slide can be canceled by returning false from the slide callback
			if (allowed === false) {
				return;
			}

			if (this._hasMultipleValues()) {
				this.values(index, newVal);
			} else {
				this.value(newVal);
			}
		},

		_stop: function _stop(event, index) {
			this._trigger("stop", event, this._uiHash(index));
		},

		_change: function _change(event, index) {
			if (!this._keySliding && !this._mouseSliding) {

				//store the last changed value index for reference when handles overlap
				this._lastChangedValue = index;
				this._trigger("change", event, this._uiHash(index));
			}
		},

		value: function value(newValue) {
			if (arguments.length) {
				this.options.value = this._trimAlignValue(newValue);
				this._refreshValue();
				this._change(null, 0);
				return;
			}

			return this._value();
		},

		values: function values(index, newValue) {
			var vals, newValues, i;

			if (arguments.length > 1) {
				this.options.values[index] = this._trimAlignValue(newValue);
				this._refreshValue();
				this._change(null, index);
				return;
			}

			if (arguments.length) {
				if ($.isArray(arguments[0])) {
					vals = this.options.values;
					newValues = arguments[0];
					for (i = 0; i < vals.length; i += 1) {
						vals[i] = this._trimAlignValue(newValues[i]);
						this._change(null, i);
					}
					this._refreshValue();
				} else {
					if (this._hasMultipleValues()) {
						return this._values(index);
					} else {
						return this.value();
					}
				}
			} else {
				return this._values();
			}
		},

		_setOption: function _setOption(key, value) {
			var i,
			    valsLength = 0;

			if (key === "range" && this.options.range === true) {
				if (value === "min") {
					this.options.value = this._values(0);
					this.options.values = null;
				} else if (value === "max") {
					this.options.value = this._values(this.options.values.length - 1);
					this.options.values = null;
				}
			}

			if ($.isArray(this.options.values)) {
				valsLength = this.options.values.length;
			}

			this._super(key, value);

			switch (key) {
				case "orientation":
					this._detectOrientation();
					this._removeClass("ui-slider-horizontal ui-slider-vertical")._addClass("ui-slider-" + this.orientation);
					this._refreshValue();
					if (this.options.range) {
						this._refreshRange(value);
					}

					// Reset positioning from previous orientation
					this.handles.css(value === "horizontal" ? "bottom" : "left", "");
					break;
				case "value":
					this._animateOff = true;
					this._refreshValue();
					this._change(null, 0);
					this._animateOff = false;
					break;
				case "values":
					this._animateOff = true;
					this._refreshValue();

					// Start from the last handle to prevent unreachable handles (#9046)
					for (i = valsLength - 1; i >= 0; i--) {
						this._change(null, i);
					}
					this._animateOff = false;
					break;
				case "step":
				case "min":
				case "max":
					this._animateOff = true;
					this._calculateNewMax();
					this._refreshValue();
					this._animateOff = false;
					break;
				case "range":
					this._animateOff = true;
					this._refresh();
					this._animateOff = false;
					break;
			}
		},

		_setOptionDisabled: function _setOptionDisabled(value) {
			this._super(value);

			this._toggleClass(null, "ui-state-disabled", !!value);
		},

		//internal value getter
		// _value() returns value trimmed by min and max, aligned by step
		_value: function _value() {
			var val = this.options.value;
			val = this._trimAlignValue(val);

			return val;
		},

		//internal values getter
		// _values() returns array of values trimmed by min and max, aligned by step
		// _values( index ) returns single value trimmed by min and max, aligned by step
		_values: function _values(index) {
			var val, vals, i;

			if (arguments.length) {
				val = this.options.values[index];
				val = this._trimAlignValue(val);

				return val;
			} else if (this._hasMultipleValues()) {

				// .slice() creates a copy of the array
				// this copy gets trimmed by min and max and then returned
				vals = this.options.values.slice();
				for (i = 0; i < vals.length; i += 1) {
					vals[i] = this._trimAlignValue(vals[i]);
				}

				return vals;
			} else {
				return [];
			}
		},

		// Returns the step-aligned value that val is closest to, between (inclusive) min and max
		_trimAlignValue: function _trimAlignValue(val) {
			if (val <= this._valueMin()) {
				return this._valueMin();
			}
			if (val >= this._valueMax()) {
				return this._valueMax();
			}
			var step = this.options.step > 0 ? this.options.step : 1,
			    valModStep = (val - this._valueMin()) % step,
			    alignValue = val - valModStep;

			if (Math.abs(valModStep) * 2 >= step) {
				alignValue += valModStep > 0 ? step : -step;
			}

			// Since JavaScript has problems with large floats, round
			// the final value to 5 digits after the decimal point (see #4124)
			return parseFloat(alignValue.toFixed(5));
		},

		_calculateNewMax: function _calculateNewMax() {
			var max = this.options.max,
			    min = this._valueMin(),
			    step = this.options.step,
			    aboveMin = Math.round((max - min) / step) * step;
			max = aboveMin + min;
			if (max > this.options.max) {

				//If max is not divisible by step, rounding off may increase its value
				max -= step;
			}
			this.max = parseFloat(max.toFixed(this._precision()));
		},

		_precision: function _precision() {
			var precision = this._precisionOf(this.options.step);
			if (this.options.min !== null) {
				precision = Math.max(precision, this._precisionOf(this.options.min));
			}
			return precision;
		},

		_precisionOf: function _precisionOf(num) {
			var str = num.toString(),
			    decimal = str.indexOf(".");
			return decimal === -1 ? 0 : str.length - decimal - 1;
		},

		_valueMin: function _valueMin() {
			return this.options.min;
		},

		_valueMax: function _valueMax() {
			return this.max;
		},

		_refreshRange: function _refreshRange(orientation) {
			if (orientation === "vertical") {
				this.range.css({ "width": "", "left": "" });
			}
			if (orientation === "horizontal") {
				this.range.css({ "height": "", "bottom": "" });
			}
		},

		_refreshValue: function _refreshValue() {
			var lastValPercent,
			    valPercent,
			    value,
			    valueMin,
			    valueMax,
			    oRange = this.options.range,
			    o = this.options,
			    that = this,
			    animate = !this._animateOff ? o.animate : false,
			    _set = {};

			if (this._hasMultipleValues()) {
				this.handles.each(function (i) {
					valPercent = (that.values(i) - that._valueMin()) / (that._valueMax() - that._valueMin()) * 100;
					_set[that.orientation === "horizontal" ? "left" : "bottom"] = valPercent + "%";
					$(this).stop(1, 1)[animate ? "animate" : "css"](_set, o.animate);
					if (that.options.range === true) {
						if (that.orientation === "horizontal") {
							if (i === 0) {
								that.range.stop(1, 1)[animate ? "animate" : "css"]({
									left: valPercent + "%"
								}, o.animate);
							}
							if (i === 1) {
								that.range[animate ? "animate" : "css"]({
									width: valPercent - lastValPercent + "%"
								}, {
									queue: false,
									duration: o.animate
								});
							}
						} else {
							if (i === 0) {
								that.range.stop(1, 1)[animate ? "animate" : "css"]({
									bottom: valPercent + "%"
								}, o.animate);
							}
							if (i === 1) {
								that.range[animate ? "animate" : "css"]({
									height: valPercent - lastValPercent + "%"
								}, {
									queue: false,
									duration: o.animate
								});
							}
						}
					}
					lastValPercent = valPercent;
				});
			} else {
				value = this.value();
				valueMin = this._valueMin();
				valueMax = this._valueMax();
				valPercent = valueMax !== valueMin ? (value - valueMin) / (valueMax - valueMin) * 100 : 0;
				_set[this.orientation === "horizontal" ? "left" : "bottom"] = valPercent + "%";
				this.handle.stop(1, 1)[animate ? "animate" : "css"](_set, o.animate);

				if (oRange === "min" && this.orientation === "horizontal") {
					this.range.stop(1, 1)[animate ? "animate" : "css"]({
						width: valPercent + "%"
					}, o.animate);
				}
				if (oRange === "max" && this.orientation === "horizontal") {
					this.range.stop(1, 1)[animate ? "animate" : "css"]({
						width: 100 - valPercent + "%"
					}, o.animate);
				}
				if (oRange === "min" && this.orientation === "vertical") {
					this.range.stop(1, 1)[animate ? "animate" : "css"]({
						height: valPercent + "%"
					}, o.animate);
				}
				if (oRange === "max" && this.orientation === "vertical") {
					this.range.stop(1, 1)[animate ? "animate" : "css"]({
						height: 100 - valPercent + "%"
					}, o.animate);
				}
			}
		},

		_handleEvents: {
			keydown: function keydown(event) {
				var allowed,
				    curVal,
				    newVal,
				    step,
				    index = $(event.target).data("ui-slider-handle-index");

				switch (event.keyCode) {
					case $.ui.keyCode.HOME:
					case $.ui.keyCode.END:
					case $.ui.keyCode.PAGE_UP:
					case $.ui.keyCode.PAGE_DOWN:
					case $.ui.keyCode.UP:
					case $.ui.keyCode.RIGHT:
					case $.ui.keyCode.DOWN:
					case $.ui.keyCode.LEFT:
						event.preventDefault();
						if (!this._keySliding) {
							this._keySliding = true;
							this._addClass($(event.target), null, "ui-state-active");
							allowed = this._start(event, index);
							if (allowed === false) {
								return;
							}
						}
						break;
				}

				step = this.options.step;
				if (this._hasMultipleValues()) {
					curVal = newVal = this.values(index);
				} else {
					curVal = newVal = this.value();
				}

				switch (event.keyCode) {
					case $.ui.keyCode.HOME:
						newVal = this._valueMin();
						break;
					case $.ui.keyCode.END:
						newVal = this._valueMax();
						break;
					case $.ui.keyCode.PAGE_UP:
						newVal = this._trimAlignValue(curVal + (this._valueMax() - this._valueMin()) / this.numPages);
						break;
					case $.ui.keyCode.PAGE_DOWN:
						newVal = this._trimAlignValue(curVal - (this._valueMax() - this._valueMin()) / this.numPages);
						break;
					case $.ui.keyCode.UP:
					case $.ui.keyCode.RIGHT:
						if (curVal === this._valueMax()) {
							return;
						}
						newVal = this._trimAlignValue(curVal + step);
						break;
					case $.ui.keyCode.DOWN:
					case $.ui.keyCode.LEFT:
						if (curVal === this._valueMin()) {
							return;
						}
						newVal = this._trimAlignValue(curVal - step);
						break;
				}

				this._slide(event, index, newVal);
			},
			keyup: function keyup(event) {
				var index = $(event.target).data("ui-slider-handle-index");

				if (this._keySliding) {
					this._keySliding = false;
					this._stop(event, index);
					this._change(event, index);
					this._removeClass($(event.target), null, "ui-state-active");
				}
			}
		}
	});
});

/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/*!jQuery Knob*/
/**
 * Downward compatible, touchable dial
 *
 * Version: 1.2.12
 * Requires: jQuery v1.7+
 *
 * Copyright (c) 2012 Anthony Terrien
 * Under MIT License (http://www.opensource.org/licenses/mit-license.php)
 *
 * Thanks to vor, eskimoblood, spiffistan, FabrizioC
 */
+function (factory) {
  if (( false ? 'undefined' : _typeof(exports)) === 'object') {
    // CommonJS
    module.exports = factory(__webpack_require__(0));
  } else if (true) {
    // AMD. Register as an anonymous module.
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(0)], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {
    // Browser globals
    factory(jQuery);
  }
}(function ($) {

  /**
   * Kontrol library
   */
  "use strict";

  /**
   * Definition of globals and core
   */

  var k = {},
      // kontrol
  max = Math.max,
      min = Math.min;

  k.c = {};
  k.c.d = $(document);
  k.c.t = function (e) {
    return e.originalEvent.touches.length - 1;
  };

  /**
   * Kontrol Object
   *
   * Definition of an abstract UI control
   *
   * Each concrete component must call this one.
   * <code>
   * k.o.call(this);
   * </code>
   */
  k.o = function () {
    var s = this;

    this.o = null; // array of options
    this.$ = null; // jQuery wrapped element
    this.i = null; // mixed HTMLInputElement or array of HTMLInputElement
    this.g = null; // deprecated 2D graphics context for 'pre-rendering'
    this.v = null; // value ; mixed array or integer
    this.cv = null; // change value ; not commited value
    this.x = 0; // canvas x position
    this.y = 0; // canvas y position
    this.w = 0; // canvas width
    this.h = 0; // canvas height
    this.$c = null; // jQuery canvas element
    this.c = null; // rendered canvas context
    this.t = 0; // touches index
    this.isInit = false;
    this.fgColor = null; // main color
    this.pColor = null; // previous color
    this.dH = null; // draw hook
    this.cH = null; // change hook
    this.eH = null; // cancel hook
    this.rH = null; // release hook
    this.scale = 1; // scale factor
    this.relative = false;
    this.relativeWidth = false;
    this.relativeHeight = false;
    this.$div = null; // component div

    this.run = function () {
      var cf = function cf(e, conf) {
        var k;
        for (k in conf) {
          s.o[k] = conf[k];
        }
        s._carve().init();
        s._configure()._draw();
      };

      if (this.$.data('kontroled')) return;
      this.$.data('kontroled', true);

      this.extend();
      this.o = $.extend({
        // Config
        min: this.$.data('min') !== undefined ? this.$.data('min') : 0,
        max: this.$.data('max') !== undefined ? this.$.data('max') : 100,
        stopper: true,
        readOnly: this.$.data('readonly') || this.$.attr('readonly') === 'readonly',

        // UI
        cursor: this.$.data('cursor') === true && 30 || this.$.data('cursor') || 0,
        thickness: this.$.data('thickness') && Math.max(Math.min(this.$.data('thickness'), 1), 0.01) || 0.35,
        lineCap: this.$.data('linecap') || 'butt',
        width: this.$.data('width') || 200,
        height: this.$.data('height') || 200,
        displayInput: this.$.data('displayinput') == null || this.$.data('displayinput'),
        displayPrevious: this.$.data('displayprevious'),
        fgColor: this.$.data('fgcolor') || '#87CEEB',
        inputColor: this.$.data('inputcolor'),
        font: this.$.data('font') || 'Arial',
        fontWeight: this.$.data('font-weight') || 'bold',
        inline: false,
        step: this.$.data('step') || 1,
        rotation: this.$.data('rotation'),

        // Hooks
        draw: null, // function () {}
        change: null, // function (value) {}
        cancel: null, // function () {}
        release: null, // function (value) {}

        // Output formatting, allows to add unit: %, ms ...
        format: function format(v) {
          return v;
        },
        parse: function parse(v) {
          return parseFloat(v);
        }
      }, this.o);

      // finalize options
      this.o.flip = this.o.rotation === 'anticlockwise' || this.o.rotation === 'acw';
      if (!this.o.inputColor) {
        this.o.inputColor = this.o.fgColor;
      }

      // routing value
      if (this.$.is('fieldset')) {

        // fieldset = array of integer
        this.v = {};
        this.i = this.$.find('input');
        this.i.each(function (k) {
          var $this = $(this);
          s.i[k] = $this;
          s.v[k] = s.o.parse($this.val());

          $this.bind('change blur', function () {
            var val = {};
            val[k] = $this.val();
            s.val(s._validate(val));
          });
        });
        this.$.find('legend').remove();
      } else {

        // input = integer
        this.i = this.$;
        this.v = this.o.parse(this.$.val());
        this.v === '' && (this.v = this.o.min);
        this.$.bind('change blur', function () {
          s.val(s._validate(s.o.parse(s.$.val())));
        });
      }

      !this.o.displayInput && this.$.hide();

      // adds needed DOM elements (canvas, div)
      this.$c = $(document.createElement('canvas')).attr({
        width: this.o.width,
        height: this.o.height
      });

      // wraps all elements in a div
      // add to DOM before Canvas init is triggered
      this.$div = $('<div style="' + (this.o.inline ? 'display:inline;' : '') + 'width:' + this.o.width + 'px;height:' + this.o.height + 'px;' + '"></div>');

      this.$.wrap(this.$div).before(this.$c);
      this.$div = this.$.parent();

      if (typeof G_vmlCanvasManager !== 'undefined') {
        G_vmlCanvasManager.initElement(this.$c[0]);
      }

      this.c = this.$c[0].getContext ? this.$c[0].getContext('2d') : null;

      if (!this.c) {
        throw {
          name: "CanvasNotSupportedException",
          message: "Canvas not supported. Please use excanvas on IE8.0.",
          toString: function toString() {
            return this.name + ": " + this.message;
          }
        };
      }

      // hdpi support
      this.scale = (window.devicePixelRatio || 1) / (this.c.webkitBackingStorePixelRatio || this.c.mozBackingStorePixelRatio || this.c.msBackingStorePixelRatio || this.c.oBackingStorePixelRatio || this.c.backingStorePixelRatio || 1);

      // detects relative width / height
      this.relativeWidth = this.o.width % 1 !== 0 && this.o.width.indexOf('%');
      this.relativeHeight = this.o.height % 1 !== 0 && this.o.height.indexOf('%');
      this.relative = this.relativeWidth || this.relativeHeight;

      // computes size and carves the component
      this._carve();

      // prepares props for transaction
      if (this.v instanceof Object) {
        this.cv = {};
        this.copy(this.v, this.cv);
      } else {
        this.cv = this.v;
      }

      // binds configure event
      this.$.bind("configure", cf).parent().bind("configure", cf);

      // finalize init
      this._listen()._configure()._xy().init();

      this.isInit = true;

      this.$.val(this.o.format(this.v));
      this._draw();

      return this;
    };

    this._carve = function () {
      if (this.relative) {
        var w = this.relativeWidth ? this.$div.parent().width() * parseInt(this.o.width) / 100 : this.$div.parent().width(),
            h = this.relativeHeight ? this.$div.parent().height() * parseInt(this.o.height) / 100 : this.$div.parent().height();

        // apply relative
        this.w = this.h = Math.min(w, h);
      } else {
        this.w = this.o.width;
        this.h = this.o.height;
      }

      // finalize div
      this.$div.css({
        'width': this.w + 'px',
        'height': this.h + 'px'
      });

      // finalize canvas with computed width
      this.$c.attr({
        width: this.w,
        height: this.h
      });

      // scaling
      if (this.scale !== 1) {
        this.$c[0].width = this.$c[0].width * this.scale;
        this.$c[0].height = this.$c[0].height * this.scale;
        this.$c.width(this.w);
        this.$c.height(this.h);
      }

      return this;
    };

    this._draw = function () {

      // canvas pre-rendering
      var d = true;

      s.g = s.c;

      s.clear();

      s.dH && (d = s.dH());

      d !== false && s.draw();
    };

    this._touch = function (e) {
      var touchMove = function touchMove(e) {
        var v = s.xy2val(e.originalEvent.touches[s.t].pageX, e.originalEvent.touches[s.t].pageY);

        if (v == s.cv) return;

        if (s.cH && s.cH(v) === false) return;

        s.change(s._validate(v));
        s._draw();
      };

      // get touches index
      this.t = k.c.t(e);

      // First touch
      touchMove(e);

      // Touch events listeners
      k.c.d.bind("touchmove.k", touchMove).bind("touchend.k", function () {
        k.c.d.unbind('touchmove.k touchend.k');
        s.val(s.cv);
      });

      return this;
    };

    this._mouse = function (e) {
      var mouseMove = function mouseMove(e) {
        var v = s.xy2val(e.pageX, e.pageY);

        if (v == s.cv) return;

        if (s.cH && s.cH(v) === false) return;

        s.change(s._validate(v));
        s._draw();
      };

      // First click
      mouseMove(e);

      // Mouse events listeners
      k.c.d.bind("mousemove.k", mouseMove).bind(
      // Escape key cancel current change
      "keyup.k", function (e) {
        if (e.keyCode === 27) {
          k.c.d.unbind("mouseup.k mousemove.k keyup.k");

          if (s.eH && s.eH() === false) return;

          s.cancel();
        }
      }).bind("mouseup.k", function (e) {
        k.c.d.unbind('mousemove.k mouseup.k keyup.k');
        s.val(s.cv);
      });

      return this;
    };

    this._xy = function () {
      var o = this.$c.offset();
      this.x = o.left;
      this.y = o.top;

      return this;
    };

    this._listen = function () {
      if (!this.o.readOnly) {
        this.$c.bind("mousedown", function (e) {
          e.preventDefault();
          s._xy()._mouse(e);
        }).bind("touchstart", function (e) {
          e.preventDefault();
          s._xy()._touch(e);
        });

        this.listen();
      } else {
        this.$.attr('readonly', 'readonly');
      }

      if (this.relative) {
        $(window).resize(function () {
          s._carve().init();
          s._draw();
        });
      }

      return this;
    };

    this._configure = function () {

      // Hooks
      if (this.o.draw) this.dH = this.o.draw;
      if (this.o.change) this.cH = this.o.change;
      if (this.o.cancel) this.eH = this.o.cancel;
      if (this.o.release) this.rH = this.o.release;

      if (this.o.displayPrevious) {
        this.pColor = this.h2rgba(this.o.fgColor, "0.4");
        this.fgColor = this.h2rgba(this.o.fgColor, "0.6");
      } else {
        this.fgColor = this.o.fgColor;
      }

      return this;
    };

    this._clear = function () {
      this.$c[0].width = this.$c[0].width;
    };

    this._validate = function (v) {
      var val = ~~((v < 0 ? -0.5 : 0.5) + v / this.o.step) * this.o.step;
      return Math.round(val * 100) / 100;
    };

    // Abstract methods
    this.listen = function () {}; // on start, one time
    this.extend = function () {}; // each time configure triggered
    this.init = function () {}; // each time configure triggered
    this.change = function (v) {}; // on change
    this.val = function (v) {}; // on release
    this.xy2val = function (x, y) {}; //
    this.draw = function () {}; // on change / on release
    this.clear = function () {
      this._clear();
    };

    // Utils
    this.h2rgba = function (h, a) {
      var rgb;
      h = h.substring(1, 7);
      rgb = [parseInt(h.substring(0, 2), 16), parseInt(h.substring(2, 4), 16), parseInt(h.substring(4, 6), 16)];

      return "rgba(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + "," + a + ")";
    };

    this.copy = function (f, t) {
      for (var i in f) {
        t[i] = f[i];
      }
    };
  };

  /**
   * k.Dial
   */
  k.Dial = function () {
    k.o.call(this);

    this.startAngle = null;
    this.xy = null;
    this.radius = null;
    this.lineWidth = null;
    this.cursorExt = null;
    this.w2 = null;
    this.PI2 = 2 * Math.PI;

    this.extend = function () {
      this.o = $.extend({
        bgColor: this.$.data('bgcolor') || '#EEEEEE',
        angleOffset: this.$.data('angleoffset') || 0,
        angleArc: this.$.data('anglearc') || 360,
        inline: true
      }, this.o);
    };

    this.val = function (v, triggerRelease) {
      if (null != v) {

        // reverse format
        v = this.o.parse(v);

        if (triggerRelease !== false && v != this.v && this.rH && this.rH(v) === false) {
          return;
        }

        this.cv = this.o.stopper ? max(min(v, this.o.max), this.o.min) : v;
        this.v = this.cv;
        this.$.val(this.o.format(this.v));
        this._draw();
      } else {
        return this.v;
      }
    };

    this.xy2val = function (x, y) {
      var a, ret;

      a = Math.atan2(x - (this.x + this.w2), -(y - this.y - this.w2)) - this.angleOffset;

      if (this.o.flip) {
        a = this.angleArc - a - this.PI2;
      }

      if (this.angleArc != this.PI2 && a < 0 && a > -0.5) {

        // if isset angleArc option, set to min if .5 under min
        a = 0;
      } else if (a < 0) {
        a += this.PI2;
      }

      ret = a * (this.o.max - this.o.min) / this.angleArc + this.o.min;

      this.o.stopper && (ret = max(min(ret, this.o.max), this.o.min));

      return ret;
    };

    this.listen = function () {

      // bind MouseWheel
      var s = this,
          mwTimerStop,
          mwTimerRelease,
          mw = function mw(e) {
        e.preventDefault();

        var ori = e.originalEvent,
            deltaX = ori.detail || ori.wheelDeltaX,
            deltaY = ori.detail || ori.wheelDeltaY,
            v = s._validate(s.o.parse(s.$.val())) + (deltaX > 0 || deltaY > 0 ? s.o.step : deltaX < 0 || deltaY < 0 ? -s.o.step : 0);

        v = max(min(v, s.o.max), s.o.min);

        s.val(v, false);

        if (s.rH) {
          // Handle mousewheel stop
          clearTimeout(mwTimerStop);
          mwTimerStop = setTimeout(function () {
            s.rH(v);
            mwTimerStop = null;
          }, 100);

          // Handle mousewheel releases
          if (!mwTimerRelease) {
            mwTimerRelease = setTimeout(function () {
              if (mwTimerStop) s.rH(v);
              mwTimerRelease = null;
            }, 200);
          }
        }
      },
          kval,
          to,
          m = 1,
          kv = {
        37: -s.o.step,
        38: s.o.step,
        39: s.o.step,
        40: -s.o.step
      };

      this.$.bind("keydown", function (e) {
        var kc = e.keyCode;

        // numpad support
        if (kc >= 96 && kc <= 105) {
          kc = e.keyCode = kc - 48;
        }

        kval = parseInt(String.fromCharCode(kc));

        if (isNaN(kval)) {
          kc !== 13 && // enter
          kc !== 8 // bs
          && kc !== 9 // tab
          && kc !== 189 // -
          && (kc !== 190 || s.$.val().match(/\./)) // . allowed once
          && e.preventDefault();

          // arrows
          if ($.inArray(kc, [37, 38, 39, 40]) > -1) {
            e.preventDefault();

            var v = s.o.parse(s.$.val()) + kv[kc] * m;
            s.o.stopper && (v = max(min(v, s.o.max), s.o.min));

            s.change(s._validate(v));
            s._draw();

            // long time keydown speed-up
            to = window.setTimeout(function () {
              m *= 2;
            }, 30);
          }
        }
      }).bind("keyup", function (e) {
        if (isNaN(kval)) {
          if (to) {
            window.clearTimeout(to);
            to = null;
            m = 1;
            s.val(s.$.val());
          }
        } else {
          // kval postcond
          s.$.val() > s.o.max && s.$.val(s.o.max) || s.$.val() < s.o.min && s.$.val(s.o.min);
        }
      });

      this.$c.bind("mousewheel DOMMouseScroll", mw);
      this.$.bind("mousewheel DOMMouseScroll", mw);
    };

    this.init = function () {
      if (this.v < this.o.min || this.v > this.o.max) {
        this.v = this.o.min;
      }

      this.$.val(this.v);
      this.w2 = this.w / 2;
      this.cursorExt = this.o.cursor / 100;
      this.xy = this.w2 * this.scale;
      this.lineWidth = this.xy * this.o.thickness;
      this.lineCap = this.o.lineCap;
      this.radius = this.xy - this.lineWidth / 2;

      this.o.angleOffset && (this.o.angleOffset = isNaN(this.o.angleOffset) ? 0 : this.o.angleOffset);

      this.o.angleArc && (this.o.angleArc = isNaN(this.o.angleArc) ? this.PI2 : this.o.angleArc);

      // deg to rad
      this.angleOffset = this.o.angleOffset * Math.PI / 180;
      this.angleArc = this.o.angleArc * Math.PI / 180;

      // compute start and end angles
      this.startAngle = 1.5 * Math.PI + this.angleOffset;
      this.endAngle = 1.5 * Math.PI + this.angleOffset + this.angleArc;

      var s = max(String(Math.abs(this.o.max)).length, String(Math.abs(this.o.min)).length, 2) + 2;

      this.o.displayInput && this.i.css({
        'width': (this.w / 2 + 4 >> 0) + 'px',
        'height': (this.w / 3 >> 0) + 'px',
        'position': 'absolute',
        'vertical-align': 'middle',
        'margin-top': (this.w / 3 >> 0) + 'px',
        'margin-left': '-' + (this.w * 3 / 4 + 2 >> 0) + 'px',
        'border': 0,
        'background': 'none',
        'font': this.o.fontWeight + ' ' + (this.w / s >> 0) + 'px ' + this.o.font,
        'text-align': 'center',
        'color': this.o.inputColor || this.o.fgColor,
        'padding': '0px',
        '-webkit-appearance': 'none'
      }) || this.i.css({
        'width': '0px',
        'visibility': 'hidden'
      });
    };

    this.change = function (v) {
      this.cv = v;
      this.$.val(this.o.format(v));
    };

    this.angle = function (v) {
      return (v - this.o.min) * this.angleArc / (this.o.max - this.o.min);
    };

    this.arc = function (v) {
      var sa, ea;
      v = this.angle(v);
      if (this.o.flip) {
        sa = this.endAngle + 0.00001;
        ea = sa - v - 0.00001;
      } else {
        sa = this.startAngle - 0.00001;
        ea = sa + v + 0.00001;
      }
      this.o.cursor && (sa = ea - this.cursorExt) && (ea = ea + this.cursorExt);

      return {
        s: sa,
        e: ea,
        d: this.o.flip && !this.o.cursor
      };
    };

    this.draw = function () {
      var c = this.g,
          // context
      a = this.arc(this.cv),
          // Arc
      pa,
          // Previous arc
      r = 1;

      c.lineWidth = this.lineWidth;
      c.lineCap = this.lineCap;

      if (this.o.bgColor !== "none") {
        c.beginPath();
        c.strokeStyle = this.o.bgColor;
        c.arc(this.xy, this.xy, this.radius, this.endAngle - 0.00001, this.startAngle + 0.00001, true);
        c.stroke();
      }

      if (this.o.displayPrevious) {
        pa = this.arc(this.v);
        c.beginPath();
        c.strokeStyle = this.pColor;
        c.arc(this.xy, this.xy, this.radius, pa.s, pa.e, pa.d);
        c.stroke();
        r = this.cv == this.v;
      }

      c.beginPath();
      c.strokeStyle = r ? this.o.fgColor : this.fgColor;
      c.arc(this.xy, this.xy, this.radius, a.s, a.e, a.d);
      c.stroke();
    };

    this.cancel = function () {
      this.val(this.v);
    };
  };

  $.fn.dial = $.fn.knob = function (o) {
    return this.each(function () {
      var d = new k.Dial();
      d.o = o;
      d.$ = $(this);
      d.run();
    }).parent();
  };
});

/***/ }),
/* 51 */,
/* 52 */,
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(26)(undefined);
// imports


// module
exports.push([module.i, ".jp-card.jp-card-safari.jp-card-identified .jp-card-front:before, .jp-card.jp-card-safari.jp-card-identified .jp-card-back:before {\n  background-image: repeating-linear-gradient(45deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-linear-gradient(135deg, rgba(255, 255, 255, 0.05) 1px, rgba(255, 255, 255, 0) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.03) 4px), repeating-linear-gradient(90deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-linear-gradient(210deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), -webkit-linear-gradient(-245deg, rgba(255, 255, 255, 0) 50%, rgba(255, 255, 255, 0.2) 70%, rgba(255, 255, 255, 0) 90%);\n  background-image: repeating-linear-gradient(45deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-linear-gradient(135deg, rgba(255, 255, 255, 0.05) 1px, rgba(255, 255, 255, 0) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.03) 4px), repeating-linear-gradient(90deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-linear-gradient(210deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), linear-gradient(-25deg, rgba(255, 255, 255, 0) 50%, rgba(255, 255, 255, 0.2) 70%, rgba(255, 255, 255, 0) 90%); }\n\n.jp-card.jp-card-ie-10.jp-card-flipped, .jp-card.jp-card-ie-11.jp-card-flipped {\n  -webkit-transform: 0deg;\n  -moz-transform: 0deg;\n  -ms-transform: 0deg;\n  -o-transform: 0deg;\n  transform: 0deg; }\n  .jp-card.jp-card-ie-10.jp-card-flipped .jp-card-front, .jp-card.jp-card-ie-11.jp-card-flipped .jp-card-front {\n    -webkit-transform: rotateY(0deg);\n    -moz-transform: rotateY(0deg);\n    -ms-transform: rotateY(0deg);\n    -o-transform: rotateY(0deg);\n    transform: rotateY(0deg); }\n  .jp-card.jp-card-ie-10.jp-card-flipped .jp-card-back, .jp-card.jp-card-ie-11.jp-card-flipped .jp-card-back {\n    -webkit-transform: rotateY(0deg);\n    -moz-transform: rotateY(0deg);\n    -ms-transform: rotateY(0deg);\n    -o-transform: rotateY(0deg);\n    transform: rotateY(0deg); }\n    .jp-card.jp-card-ie-10.jp-card-flipped .jp-card-back:after, .jp-card.jp-card-ie-11.jp-card-flipped .jp-card-back:after {\n      left: 18%; }\n    .jp-card.jp-card-ie-10.jp-card-flipped .jp-card-back .jp-card-cvc, .jp-card.jp-card-ie-11.jp-card-flipped .jp-card-back .jp-card-cvc {\n      -webkit-transform: rotateY(180deg);\n      -moz-transform: rotateY(180deg);\n      -ms-transform: rotateY(180deg);\n      -o-transform: rotateY(180deg);\n      transform: rotateY(180deg);\n      left: 5%; }\n    .jp-card.jp-card-ie-10.jp-card-flipped .jp-card-back .jp-card-shiny, .jp-card.jp-card-ie-11.jp-card-flipped .jp-card-back .jp-card-shiny {\n      left: 84%; }\n      .jp-card.jp-card-ie-10.jp-card-flipped .jp-card-back .jp-card-shiny:after, .jp-card.jp-card-ie-11.jp-card-flipped .jp-card-back .jp-card-shiny:after {\n        left: -480%;\n        -webkit-transform: rotateY(180deg);\n        -moz-transform: rotateY(180deg);\n        -ms-transform: rotateY(180deg);\n        -o-transform: rotateY(180deg);\n        transform: rotateY(180deg); }\n\n.jp-card.jp-card-ie-10.jp-card-amex .jp-card-back, .jp-card.jp-card-ie-11.jp-card-amex .jp-card-back {\n  display: none; }\n\n.jp-card-logo {\n  height: 36px;\n  width: 60px;\n  font-style: italic; }\n  .jp-card-logo, .jp-card-logo:before, .jp-card-logo:after {\n    box-sizing: border-box; }\n\n.jp-card-logo.jp-card-amex {\n  text-transform: uppercase;\n  font-size: 4px;\n  font-weight: bold;\n  color: white;\n  background-image: repeating-radial-gradient(circle at center, #FFF 1px, #999 2px);\n  background-image: repeating-radial-gradient(circle at center, #FFF 1px, #999 2px);\n  border: 1px solid #EEE; }\n  .jp-card-logo.jp-card-amex:before, .jp-card-logo.jp-card-amex:after {\n    width: 28px;\n    display: block;\n    position: absolute;\n    left: 16px; }\n  .jp-card-logo.jp-card-amex:before {\n    height: 28px;\n    content: \"american\";\n    top: 3px;\n    text-align: left;\n    padding-left: 2px;\n    padding-top: 11px;\n    background: #267AC3; }\n  .jp-card-logo.jp-card-amex:after {\n    content: \"express\";\n    bottom: 11px;\n    text-align: right;\n    padding-right: 2px; }\n\n.jp-card.jp-card-amex.jp-card-flipped {\n  -webkit-transform: none;\n  -moz-transform: none;\n  -ms-transform: none;\n  -o-transform: none;\n  transform: none; }\n\n.jp-card.jp-card-amex.jp-card-identified .jp-card-front:before, .jp-card.jp-card-amex.jp-card-identified .jp-card-back:before {\n  background-color: #108168; }\n\n.jp-card.jp-card-amex.jp-card-identified .jp-card-front .jp-card-logo.jp-card-amex {\n  opacity: 1; }\n\n.jp-card.jp-card-amex.jp-card-identified .jp-card-front .jp-card-cvc {\n  visibility: visible; }\n\n.jp-card.jp-card-amex.jp-card-identified .jp-card-front:after {\n  opacity: 1; }\n\n.jp-card-logo.jp-card-discover {\n  background: #FF6600;\n  color: #111;\n  text-transform: uppercase;\n  font-style: normal;\n  font-weight: bold;\n  font-size: 10px;\n  text-align: center;\n  overflow: hidden;\n  z-index: 1;\n  padding-top: 9px;\n  letter-spacing: .03em;\n  border: 1px solid #EEE; }\n  .jp-card-logo.jp-card-discover:before, .jp-card-logo.jp-card-discover:after {\n    content: \" \";\n    display: block;\n    position: absolute; }\n  .jp-card-logo.jp-card-discover:before {\n    background: white;\n    width: 200px;\n    height: 200px;\n    border-radius: 200px;\n    bottom: -5%;\n    right: -80%;\n    z-index: -1; }\n  .jp-card-logo.jp-card-discover:after {\n    width: 8px;\n    height: 8px;\n    border-radius: 4px;\n    top: 10px;\n    left: 27px;\n    background-color: #FF6600;\n    background-image: -webkit-radial-gradient(#FF6600, #fff);\n    background-image: radial-gradient(  #FF6600, #fff);\n    content: \"network\";\n    font-size: 4px;\n    line-height: 24px;\n    text-indent: -7px; }\n\n.jp-card .jp-card-front .jp-card-logo.jp-card-discover {\n  right: 12%;\n  top: 18%; }\n\n.jp-card.jp-card-discover.jp-card-identified .jp-card-front:before, .jp-card.jp-card-discover.jp-card-identified .jp-card-back:before {\n  background-color: #86B8CF; }\n\n.jp-card.jp-card-discover.jp-card-identified .jp-card-logo.jp-card-discover {\n  opacity: 1; }\n\n.jp-card.jp-card-discover.jp-card-identified .jp-card-front:after {\n  -webkit-transition: 400ms;\n  -moz-transition: 400ms;\n  transition: 400ms;\n  content: \" \";\n  display: block;\n  background-color: #FF6600;\n  background-image: -webkit-linear-gradient(#FF6600, #ffa366, #FF6600);\n  background-image: linear-gradient(#FF6600, #ffa366, #FF6600);\n  height: 50px;\n  width: 50px;\n  border-radius: 25px;\n  position: absolute;\n  left: 100%;\n  top: 15%;\n  margin-left: -25px;\n  box-shadow: inset 1px 1px 3px 1px rgba(0, 0, 0, 0.5); }\n\n.jp-card-logo.jp-card-visa {\n  background: white;\n  text-transform: uppercase;\n  color: #1A1876;\n  text-align: center;\n  font-weight: bold;\n  font-size: 15px;\n  line-height: 18px; }\n  .jp-card-logo.jp-card-visa:before, .jp-card-logo.jp-card-visa:after {\n    content: \" \";\n    display: block;\n    width: 100%;\n    height: 25%; }\n  .jp-card-logo.jp-card-visa:before {\n    background: #1A1876; }\n  .jp-card-logo.jp-card-visa:after {\n    background: #E79800; }\n\n.jp-card.jp-card-visa.jp-card-identified .jp-card-front:before, .jp-card.jp-card-visa.jp-card-identified .jp-card-back:before {\n  background-color: #191278; }\n\n.jp-card.jp-card-visa.jp-card-identified .jp-card-logo.jp-card-visa {\n  opacity: 1; }\n\n.jp-card-logo.jp-card-mastercard {\n  color: white;\n  font-weight: bold;\n  text-align: center;\n  font-size: 9px;\n  line-height: 36px;\n  z-index: 1;\n  text-shadow: 1px 1px rgba(0, 0, 0, 0.6); }\n  .jp-card-logo.jp-card-mastercard:before, .jp-card-logo.jp-card-mastercard:after {\n    content: \" \";\n    display: block;\n    width: 36px;\n    top: 0;\n    position: absolute;\n    height: 36px;\n    border-radius: 18px; }\n  .jp-card-logo.jp-card-mastercard:before {\n    left: 0;\n    background: #FF0000;\n    z-index: -1; }\n  .jp-card-logo.jp-card-mastercard:after {\n    right: 0;\n    background: #FFAB00;\n    z-index: -2; }\n\n.jp-card.jp-card-mastercard.jp-card-identified .jp-card-front .jp-card-logo.jp-card-mastercard, .jp-card.jp-card-mastercard.jp-card-identified .jp-card-back .jp-card-logo.jp-card-mastercard {\n  box-shadow: none; }\n\n.jp-card.jp-card-mastercard.jp-card-identified .jp-card-front:before, .jp-card.jp-card-mastercard.jp-card-identified .jp-card-back:before {\n  background-color: #0061A8; }\n\n.jp-card.jp-card-mastercard.jp-card-identified .jp-card-logo.jp-card-mastercard {\n  opacity: 1; }\n\n.jp-card-logo.jp-card-maestro {\n  color: white;\n  font-weight: bold;\n  text-align: center;\n  font-size: 14px;\n  line-height: 36px;\n  z-index: 1;\n  text-shadow: 1px 1px rgba(0, 0, 0, 0.6); }\n  .jp-card-logo.jp-card-maestro:before, .jp-card-logo.jp-card-maestro:after {\n    content: \" \";\n    display: block;\n    width: 36px;\n    top: 0;\n    position: absolute;\n    height: 36px;\n    border-radius: 18px; }\n  .jp-card-logo.jp-card-maestro:before {\n    left: 0;\n    background: #0064CB;\n    z-index: -1; }\n  .jp-card-logo.jp-card-maestro:after {\n    right: 0;\n    background: #CC0000;\n    z-index: -2; }\n\n.jp-card.jp-card-maestro.jp-card-identified .jp-card-front .jp-card-logo.jp-card-maestro, .jp-card.jp-card-maestro.jp-card-identified .jp-card-back .jp-card-logo.jp-card-maestro {\n  box-shadow: none; }\n\n.jp-card.jp-card-maestro.jp-card-identified .jp-card-front:before, .jp-card.jp-card-maestro.jp-card-identified .jp-card-back:before {\n  background-color: #0B2C5F; }\n\n.jp-card.jp-card-maestro.jp-card-identified .jp-card-logo.jp-card-maestro {\n  opacity: 1; }\n\n.jp-card-logo.jp-card-dankort {\n  width: 60px;\n  height: 36px;\n  padding: 3px;\n  border-radius: 8px;\n  border: #000000 1px solid;\n  background-color: #FFFFFF; }\n  .jp-card-logo.jp-card-dankort .dk {\n    position: relative;\n    width: 100%;\n    height: 100%;\n    overflow: hidden; }\n    .jp-card-logo.jp-card-dankort .dk:before {\n      background-color: #ED1C24;\n      content: '';\n      position: absolute;\n      width: 100%;\n      height: 100%;\n      display: block;\n      border-radius: 6px; }\n    .jp-card-logo.jp-card-dankort .dk:after {\n      content: '';\n      position: absolute;\n      top: 50%;\n      margin-top: -7.7px;\n      right: 0;\n      width: 0;\n      height: 0;\n      border-style: solid;\n      border-width: 7px 7px 10px 0;\n      border-color: transparent #ED1C24 transparent transparent;\n      z-index: 1; }\n  .jp-card-logo.jp-card-dankort .d, .jp-card-logo.jp-card-dankort .k {\n    position: absolute;\n    top: 50%;\n    width: 50%;\n    display: block;\n    height: 15.4px;\n    margin-top: -7.7px;\n    background: white; }\n  .jp-card-logo.jp-card-dankort .d {\n    left: 0;\n    border-radius: 0 8px 10px 0; }\n    .jp-card-logo.jp-card-dankort .d:before {\n      content: '';\n      position: absolute;\n      top: 50%;\n      left: 50%;\n      display: block;\n      background: #ED1C24;\n      border-radius: 2px 4px 6px 0px;\n      height: 5px;\n      width: 7px;\n      margin: -3px 0 0 -4px; }\n  .jp-card-logo.jp-card-dankort .k {\n    right: 0; }\n    .jp-card-logo.jp-card-dankort .k:before, .jp-card-logo.jp-card-dankort .k:after {\n      content: '';\n      position: absolute;\n      right: 50%;\n      width: 0;\n      height: 0;\n      border-style: solid;\n      margin-right: -1px; }\n    .jp-card-logo.jp-card-dankort .k:before {\n      top: 0;\n      border-width: 8px 5px 0 0;\n      border-color: #ED1C24 transparent transparent transparent; }\n    .jp-card-logo.jp-card-dankort .k:after {\n      bottom: 0;\n      border-width: 0 5px 8px 0;\n      border-color: transparent transparent #ED1C24 transparent; }\n\n.jp-card.jp-card-dankort.jp-card-identified .jp-card-front:before, .jp-card.jp-card-dankort.jp-card-identified .jp-card-back:before {\n  background-color: #0055C7; }\n\n.jp-card.jp-card-dankort.jp-card-identified .jp-card-logo.jp-card-dankort {\n  opacity: 1; }\n\n.jp-card-logo.jp-card-elo {\n  height: 50px;\n  width: 50px;\n  border-radius: 100%;\n  background: black;\n  color: white;\n  text-align: center;\n  text-transform: lowercase;\n  font-size: 21px;\n  font-style: normal;\n  letter-spacing: 1px;\n  font-weight: bold;\n  padding-top: 13px; }\n  .jp-card-logo.jp-card-elo .e, .jp-card-logo.jp-card-elo .l, .jp-card-logo.jp-card-elo .o {\n    display: inline-block;\n    position: relative; }\n  .jp-card-logo.jp-card-elo .e {\n    -webkit-transform: rotate(-15deg);\n    -moz-transform: rotate(-15deg);\n    -ms-transform: rotate(-15deg);\n    -o-transform: rotate(-15deg);\n    transform: rotate(-15deg); }\n  .jp-card-logo.jp-card-elo .o {\n    position: relative;\n    display: inline-block;\n    width: 12px;\n    height: 12px;\n    right: 0;\n    top: 7px;\n    border-radius: 100%;\n    background-image: -webkit-linear-gradient( yellow 50%, red 50%);\n    background-image: linear-gradient( yellow 50%, red 50%);\n    -webkit-transform: rotate(40deg);\n    -moz-transform: rotate(40deg);\n    -ms-transform: rotate(40deg);\n    -o-transform: rotate(40deg);\n    transform: rotate(40deg);\n    text-indent: -9999px; }\n    .jp-card-logo.jp-card-elo .o:before {\n      content: \"\";\n      position: absolute;\n      width: 49%;\n      height: 49%;\n      background: black;\n      border-radius: 100%;\n      text-indent: -99999px;\n      top: 25%;\n      left: 25%; }\n\n.jp-card.jp-card-elo.jp-card-identified .jp-card-front:before, .jp-card.jp-card-elo.jp-card-identified .jp-card-back:before {\n  background-color: #6F6969; }\n\n.jp-card.jp-card-elo.jp-card-identified .jp-card-logo.jp-card-elo {\n  opacity: 1; }\n\n.jp-card-logo.jp-card-dinersclub {\n  font-family: serif;\n  height: 40px;\n  width: 100px;\n  color: white;\n  font-size: 17px;\n  font-style: normal;\n  letter-spacing: 1px; }\n  .jp-card-logo.jp-card-dinersclub::before, .jp-card-logo.jp-card-dinersclub::after {\n    display: block;\n    position: relative; }\n  .jp-card-logo.jp-card-dinersclub::before {\n    content: 'Diners Club'; }\n  .jp-card-logo.jp-card-dinersclub::after {\n    content: 'International';\n    text-transform: uppercase;\n    font-size: 0.6em; }\n\n.jp-card.jp-card-dinersclub .jp-card-front .jp-card-logo {\n  box-shadow: none !important; }\n\n.jp-card.jp-card-dinersclub.jp-card-identified .jp-card-front:before, .jp-card.jp-card-dinersclub.jp-card-identified .jp-card-back:before {\n  background-color: #999; }\n\n.jp-card.jp-card-dinersclub.jp-card-identified .jp-card-logo.jp-card-dinersclub {\n  opacity: 1; }\n\n.jp-card-container {\n  -webkit-perspective: 1000px;\n  -moz-perspective: 1000px;\n  perspective: 1000px;\n  width: 350px;\n  max-width: 100%;\n  height: 200px;\n  margin: auto;\n  z-index: 1;\n  position: relative; }\n\n.jp-card {\n  font-family: \"Helvetica Neue\", Helvetica, Arial, sans-serif;\n  line-height: 1;\n  position: relative;\n  width: 100%;\n  height: 100%;\n  min-width: 315px;\n  border-radius: 10px;\n  -webkit-transform-style: preserve-3d;\n  -moz-transform-style: preserve-3d;\n  -ms-transform-style: preserve-3d;\n  -o-transform-style: preserve-3d;\n  transform-style: preserve-3d;\n  -webkit-transition: all 400ms linear;\n  -moz-transition: all 400ms linear;\n  transition: all 400ms linear; }\n  .jp-card > *, .jp-card > *:before, .jp-card > *:after {\n    -moz-box-sizing: border-box;\n    -webkit-box-sizing: border-box;\n    box-sizing: border-box;\n    font-family: inherit; }\n  .jp-card.jp-card-flipped {\n    -webkit-transform: rotateY(180deg);\n    -moz-transform: rotateY(180deg);\n    -ms-transform: rotateY(180deg);\n    -o-transform: rotateY(180deg);\n    transform: rotateY(180deg); }\n  .jp-card .jp-card-front, .jp-card .jp-card-back {\n    -webkit-backface-visibility: hidden;\n    backface-visibility: hidden;\n    -webkit-transform-style: preserve-3d;\n    -moz-transform-style: preserve-3d;\n    -ms-transform-style: preserve-3d;\n    -o-transform-style: preserve-3d;\n    transform-style: preserve-3d;\n    -webkit-transition: all 400ms linear;\n    -moz-transition: all 400ms linear;\n    transition: all 400ms linear;\n    width: 100%;\n    height: 100%;\n    position: absolute;\n    top: 0;\n    left: 0;\n    overflow: hidden;\n    border-radius: 10px;\n    background: #DDD; }\n    .jp-card .jp-card-front:before, .jp-card .jp-card-back:before {\n      content: \" \";\n      display: block;\n      position: absolute;\n      width: 100%;\n      height: 100%;\n      top: 0;\n      left: 0;\n      opacity: 0;\n      border-radius: 10px;\n      -webkit-transition: all 400ms ease;\n      -moz-transition: all 400ms ease;\n      transition: all 400ms ease; }\n    .jp-card .jp-card-front:after, .jp-card .jp-card-back:after {\n      content: \" \";\n      display: block; }\n    .jp-card .jp-card-front .jp-card-display, .jp-card .jp-card-back .jp-card-display {\n      color: white;\n      font-weight: normal;\n      opacity: 0.5;\n      -webkit-transition: opacity 400ms linear;\n      -moz-transition: opacity 400ms linear;\n      transition: opacity 400ms linear; }\n      .jp-card .jp-card-front .jp-card-display.jp-card-focused, .jp-card .jp-card-back .jp-card-display.jp-card-focused {\n        opacity: 1;\n        font-weight: 700; }\n    .jp-card .jp-card-front .jp-card-cvc, .jp-card .jp-card-back .jp-card-cvc {\n      font-family: \"Bitstream Vera Sans Mono\", Consolas, Courier, monospace;\n      font-size: 14px; }\n    .jp-card .jp-card-front .jp-card-shiny, .jp-card .jp-card-back .jp-card-shiny {\n      width: 50px;\n      height: 35px;\n      border-radius: 5px;\n      background: #CCC;\n      position: relative; }\n      .jp-card .jp-card-front .jp-card-shiny:before, .jp-card .jp-card-back .jp-card-shiny:before {\n        content: \" \";\n        display: block;\n        width: 70%;\n        height: 60%;\n        border-top-right-radius: 5px;\n        border-bottom-right-radius: 5px;\n        background: #d9d9d9;\n        position: absolute;\n        top: 20%; }\n  .jp-card .jp-card-front .jp-card-logo {\n    position: absolute;\n    opacity: 0;\n    right: 5%;\n    top: 8%;\n    -webkit-transition: 400ms;\n    -moz-transition: 400ms;\n    transition: 400ms; }\n  .jp-card .jp-card-front .jp-card-lower {\n    width: 80%;\n    position: absolute;\n    left: 10%;\n    bottom: 30px; }\n    @media only screen and (max-width: 480px) {\n      .jp-card .jp-card-front .jp-card-lower {\n        width: 90%;\n        left: 5%; } }\n    .jp-card .jp-card-front .jp-card-lower .jp-card-cvc {\n      visibility: hidden;\n      float: right;\n      position: relative;\n      bottom: 5px; }\n    .jp-card .jp-card-front .jp-card-lower .jp-card-number {\n      font-family: \"Bitstream Vera Sans Mono\", Consolas, Courier, monospace;\n      font-size: 24px;\n      clear: both;\n      margin-bottom: 30px; }\n    .jp-card .jp-card-front .jp-card-lower .jp-card-expiry {\n      font-family: \"Bitstream Vera Sans Mono\", Consolas, Courier, monospace;\n      letter-spacing: 0em;\n      position: relative;\n      float: right;\n      width: 25%; }\n      .jp-card .jp-card-front .jp-card-lower .jp-card-expiry:before, .jp-card .jp-card-front .jp-card-lower .jp-card-expiry:after {\n        font-family: \"Helvetica Neue\", Helvetica, Arial, sans-serif;\n        font-weight: bold;\n        font-size: 7px;\n        white-space: pre;\n        display: block;\n        opacity: .5; }\n      .jp-card .jp-card-front .jp-card-lower .jp-card-expiry:before {\n        content: attr(data-before);\n        margin-bottom: 2px;\n        font-size: 7px;\n        text-transform: uppercase; }\n      .jp-card .jp-card-front .jp-card-lower .jp-card-expiry:after {\n        position: absolute;\n        content: attr(data-after);\n        text-align: right;\n        right: 100%;\n        margin-right: 5px;\n        margin-top: 2px;\n        bottom: 0; }\n    .jp-card .jp-card-front .jp-card-lower .jp-card-name {\n      text-transform: uppercase;\n      font-family: \"Bitstream Vera Sans Mono\", Consolas, Courier, monospace;\n      font-size: 20px;\n      max-height: 45px;\n      position: absolute;\n      bottom: 0;\n      width: 190px;\n      display: -webkit-box;\n      -webkit-line-clamp: 2;\n      -webkit-box-orient: horizontal;\n      overflow: hidden;\n      text-overflow: ellipsis; }\n  .jp-card .jp-card-back {\n    -webkit-transform: rotateY(180deg);\n    -moz-transform: rotateY(180deg);\n    -ms-transform: rotateY(180deg);\n    -o-transform: rotateY(180deg);\n    transform: rotateY(180deg); }\n    .jp-card .jp-card-back .jp-card-bar {\n      background-color: #444;\n      background-image: -webkit-linear-gradient(#444, #333);\n      background-image: linear-gradient(#444, #333);\n      width: 100%;\n      height: 20%;\n      position: absolute;\n      top: 10%; }\n    .jp-card .jp-card-back:after {\n      content: \" \";\n      display: block;\n      background-color: #FFF;\n      background-image: -webkit-linear-gradient(#FFF, #FFF);\n      background-image: linear-gradient(#FFF, #FFF);\n      width: 80%;\n      height: 16%;\n      position: absolute;\n      top: 40%;\n      left: 2%; }\n    .jp-card .jp-card-back .jp-card-cvc {\n      position: absolute;\n      top: 40%;\n      left: 85%;\n      -webkit-transition-delay: 600ms;\n      -moz-transition-delay: 600ms;\n      transition-delay: 600ms; }\n    .jp-card .jp-card-back .jp-card-shiny {\n      position: absolute;\n      top: 66%;\n      left: 2%; }\n      .jp-card .jp-card-back .jp-card-shiny:after {\n        content: \"This card has been issued by Jesse Pollak and is licensed for anyone to use anywhere for free. It comes with no warranty. For support issues, please visit: github.com/jessepollak/card.\";\n        position: absolute;\n        left: 120%;\n        top: 5%;\n        color: white;\n        font-size: 7px;\n        width: 230px;\n        opacity: .5; }\n  .jp-card.jp-card-identified {\n    box-shadow: 0 0 20px rgba(0, 0, 0, 0.3); }\n    .jp-card.jp-card-identified .jp-card-front, .jp-card.jp-card-identified .jp-card-back {\n      background-color: #000;\n      background-color: rgba(0, 0, 0, 0.5); }\n      .jp-card.jp-card-identified .jp-card-front:before, .jp-card.jp-card-identified .jp-card-back:before {\n        -webkit-transition: all 400ms ease;\n        -moz-transition: all 400ms ease;\n        transition: all 400ms ease;\n        background-image: repeating-linear-gradient(45deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-linear-gradient(135deg, rgba(255, 255, 255, 0.05) 1px, rgba(255, 255, 255, 0) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.03) 4px), repeating-linear-gradient(90deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-linear-gradient(210deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-radial-gradient(circle at 30% 30%, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-radial-gradient(circle at 70% 70%, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-radial-gradient(circle at 90% 20%, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-radial-gradient(circle at 15% 80%, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), -webkit-linear-gradient(-245deg, rgba(255, 255, 255, 0) 50%, rgba(255, 255, 255, 0.2) 70%, rgba(255, 255, 255, 0) 90%);\n        background-image: repeating-linear-gradient(45deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-linear-gradient(135deg, rgba(255, 255, 255, 0.05) 1px, rgba(255, 255, 255, 0) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.03) 4px), repeating-linear-gradient(90deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-linear-gradient(210deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-radial-gradient(circle at 30% 30%, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-radial-gradient(circle at 70% 70%, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-radial-gradient(circle at 90% 20%, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-radial-gradient(circle at 15% 80%, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), linear-gradient(-25deg, rgba(255, 255, 255, 0) 50%, rgba(255, 255, 255, 0.2) 70%, rgba(255, 255, 255, 0) 90%);\n        opacity: 1; }\n      .jp-card.jp-card-identified .jp-card-front .jp-card-logo, .jp-card.jp-card-identified .jp-card-back .jp-card-logo {\n        box-shadow: 0 0 0 2px rgba(255, 255, 255, 0.3); }\n    .jp-card.jp-card-identified.no-radial-gradient .jp-card-front:before, .jp-card.jp-card-identified.no-radial-gradient .jp-card-back:before {\n      background-image: repeating-linear-gradient(45deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-linear-gradient(135deg, rgba(255, 255, 255, 0.05) 1px, rgba(255, 255, 255, 0) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.03) 4px), repeating-linear-gradient(90deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-linear-gradient(210deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), -webkit-linear-gradient(-245deg, rgba(255, 255, 255, 0) 50%, rgba(255, 255, 255, 0.2) 70%, rgba(255, 255, 255, 0) 90%);\n      background-image: repeating-linear-gradient(45deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-linear-gradient(135deg, rgba(255, 255, 255, 0.05) 1px, rgba(255, 255, 255, 0) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.03) 4px), repeating-linear-gradient(90deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), repeating-linear-gradient(210deg, rgba(255, 255, 255, 0) 1px, rgba(255, 255, 255, 0.03) 2px, rgba(255, 255, 255, 0.04) 3px, rgba(255, 255, 255, 0.05) 4px), linear-gradient(-25deg, rgba(255, 255, 255, 0) 50%, rgba(255, 255, 255, 0.2) 70%, rgba(255, 255, 255, 0) 90%); }\n", ""]);

// exports


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
var stylesInDom = {},
	memoize = function(fn) {
		var memo;
		return function () {
			if (typeof memo === "undefined") memo = fn.apply(this, arguments);
			return memo;
		};
	},
	isOldIE = memoize(function() {
		// Test for IE <= 9 as proposed by Browserhacks
		// @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
		// Tests for existence of standard globals is to allow style-loader 
		// to operate correctly into non-standard environments
		// @see https://github.com/webpack-contrib/style-loader/issues/177
		return window && document && document.all && !window.atob;
	}),
	getElement = (function(fn) {
		var memo = {};
		return function(selector) {
			if (typeof memo[selector] === "undefined") {
				memo[selector] = fn.call(this, selector);
			}
			return memo[selector]
		};
	})(function (styleTarget) {
		return document.querySelector(styleTarget)
	}),
	singletonElement = null,
	singletonCounter = 0,
	styleElementsInsertedAtTop = [],
	fixUrls = __webpack_require__(32);

module.exports = function(list, options) {
	if(typeof DEBUG !== "undefined" && DEBUG) {
		if(typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};
	options.attrs = typeof options.attrs === "object" ? options.attrs : {};

	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (typeof options.singleton === "undefined") options.singleton = isOldIE();

	// By default, add <style> tags to the <head> element
	if (typeof options.insertInto === "undefined") options.insertInto = "head";

	// By default, add <style> tags to the bottom of the target
	if (typeof options.insertAt === "undefined") options.insertAt = "bottom";

	var styles = listToStyles(list, options);
	addStylesToDom(styles, options);

	return function update(newList) {
		var mayRemove = [];
		for(var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];
			domStyle.refs--;
			mayRemove.push(domStyle);
		}
		if(newList) {
			var newStyles = listToStyles(newList, options);
			addStylesToDom(newStyles, options);
		}
		for(var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];
			if(domStyle.refs === 0) {
				for(var j = 0; j < domStyle.parts.length; j++)
					domStyle.parts[j]();
				delete stylesInDom[domStyle.id];
			}
		}
	};
};

function addStylesToDom(styles, options) {
	for(var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];
		if(domStyle) {
			domStyle.refs++;
			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}
			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];
			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}
			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles(list, options) {
	var styles = [];
	var newStyles = {};
	for(var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = options.base ? item[0] + options.base : item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};
		if(!newStyles[id])
			styles.push(newStyles[id] = {id: id, parts: [part]});
		else
			newStyles[id].parts.push(part);
	}
	return styles;
}

function insertStyleElement(options, styleElement) {
	var styleTarget = getElement(options.insertInto)
	if (!styleTarget) {
		throw new Error("Couldn't find a style target. This probably means that the value for the 'insertInto' parameter is invalid.");
	}
	var lastStyleElementInsertedAtTop = styleElementsInsertedAtTop[styleElementsInsertedAtTop.length - 1];
	if (options.insertAt === "top") {
		if(!lastStyleElementInsertedAtTop) {
			styleTarget.insertBefore(styleElement, styleTarget.firstChild);
		} else if(lastStyleElementInsertedAtTop.nextSibling) {
			styleTarget.insertBefore(styleElement, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			styleTarget.appendChild(styleElement);
		}
		styleElementsInsertedAtTop.push(styleElement);
	} else if (options.insertAt === "bottom") {
		styleTarget.appendChild(styleElement);
	} else {
		throw new Error("Invalid value for parameter 'insertAt'. Must be 'top' or 'bottom'.");
	}
}

function removeStyleElement(styleElement) {
	styleElement.parentNode.removeChild(styleElement);
	var idx = styleElementsInsertedAtTop.indexOf(styleElement);
	if(idx >= 0) {
		styleElementsInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement(options) {
	var styleElement = document.createElement("style");
	options.attrs.type = "text/css";

	attachTagAttrs(styleElement, options.attrs);
	insertStyleElement(options, styleElement);
	return styleElement;
}

function createLinkElement(options) {
	var linkElement = document.createElement("link");
	options.attrs.type = "text/css";
	options.attrs.rel = "stylesheet";

	attachTagAttrs(linkElement, options.attrs);
	insertStyleElement(options, linkElement);
	return linkElement;
}

function attachTagAttrs(element, attrs) {
	Object.keys(attrs).forEach(function (key) {
		element.setAttribute(key, attrs[key]);
	});
}

function addStyle(obj, options) {
	var styleElement, update, remove, transformResult;

	// If a transform function was defined, run it on the css
	if (options.transform && obj.css) {
	    transformResult = options.transform(obj.css);
	    
	    if (transformResult) {
	    	// If transform returns a value, use that instead of the original css.
	    	// This allows running runtime transformations on the css.
	    	obj.css = transformResult;
	    } else {
	    	// If the transform function returns a falsy value, don't add this css. 
	    	// This allows conditional loading of css
	    	return function() {
	    		// noop
	    	};
	    }
	}

	if (options.singleton) {
		var styleIndex = singletonCounter++;
		styleElement = singletonElement || (singletonElement = createStyleElement(options));
		update = applyToSingletonTag.bind(null, styleElement, styleIndex, false);
		remove = applyToSingletonTag.bind(null, styleElement, styleIndex, true);
	} else if(obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function") {
		styleElement = createLinkElement(options);
		update = updateLink.bind(null, styleElement, options);
		remove = function() {
			removeStyleElement(styleElement);
			if(styleElement.href)
				URL.revokeObjectURL(styleElement.href);
		};
	} else {
		styleElement = createStyleElement(options);
		update = applyToTag.bind(null, styleElement);
		remove = function() {
			removeStyleElement(styleElement);
		};
	}

	update(obj);

	return function updateStyle(newObj) {
		if(newObj) {
			if(newObj.css === obj.css && newObj.media === obj.media && newObj.sourceMap === obj.sourceMap)
				return;
			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;
		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag(styleElement, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (styleElement.styleSheet) {
		styleElement.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = styleElement.childNodes;
		if (childNodes[index]) styleElement.removeChild(childNodes[index]);
		if (childNodes.length) {
			styleElement.insertBefore(cssNode, childNodes[index]);
		} else {
			styleElement.appendChild(cssNode);
		}
	}
}

function applyToTag(styleElement, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		styleElement.setAttribute("media", media)
	}

	if(styleElement.styleSheet) {
		styleElement.styleSheet.cssText = css;
	} else {
		while(styleElement.firstChild) {
			styleElement.removeChild(styleElement.firstChild);
		}
		styleElement.appendChild(document.createTextNode(css));
	}
}

function updateLink(linkElement, options, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	/* If convertToAbsoluteUrls isn't defined, but sourcemaps are enabled
	and there is no publicPath defined then lets turn convertToAbsoluteUrls
	on by default.  Otherwise default to the convertToAbsoluteUrls option
	directly
	*/
	var autoFixUrls = options.convertToAbsoluteUrls === undefined && sourceMap;

	if (options.convertToAbsoluteUrls || autoFixUrls){
		css = fixUrls(css);
	}

	if(sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = linkElement.href;

	linkElement.href = URL.createObjectURL(blob);

	if(oldSrc)
		URL.revokeObjectURL(oldSrc);
}


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(53);
if(typeof content === 'string') content = [[module.i, content, '']];
// Prepare cssTransformation
var transform;

var options = {}
options.transform = transform
// add the styles to the DOM
var update = __webpack_require__(54)(content, options);
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!../../css-loader/index.js!./card.css", function() {
			var newContent = require("!!../../css-loader/index.js!./card.css");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ }),
/* 56 */,
/* 57 */,
/* 58 */,
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(11);


/***/ })
/******/ ]);