class RsGroupColors {
    constructor(instance) {
        this.group = $(instance);
        this.groupSwitchButton = $(instance).find('[data-rs-toggle]');
        this.cacheDOM();
        this.bindEvents();

        this.GLOBAL = {
            lock: true
        };
    }

    cacheDOM() {
        this.disabledFields = this.group.find('.color-chose__container.hsl-field');
    }

    bindEvents() {
        this.groupSwitchButton.on('click.rs_group', event => {
            this.disabledFields.toggleClass('disabled');
            this.group.toggleClass('disabled');

            this.GLOBAL.lock = !this.GLOBAL.lock;
        });
    }

}

class RsDropdown {
    constructor(instance , location = 'admin') {
        this.document = $(document);
        this.dropdown = $(instance);
        this.rsInput = $(instance).find('.rs-input');
        this.dropActions = $(instance).find('.drop-actions');
        this.colorPreviewBox = $(instance).find('.color-preview.activeColor');
        this.openClass = 'is-open';
        this.refs = {
            type: $(instance).data('rs-dropdown'),
            colorHex: $(instance).data('color-hex'),
            currentGroupIndex: $(instance).closest('.rs-group').data('group'),
            location: location,
            inputType: 'change'
        };


        // Kasze DOM hehe :P
        this.cacheDOM();
        this.bindEvents();
    }

    cacheDOM() {
        this.dropdownListContainer = this.dropdown.find('.rs-dropdown');
        this.allDropdowns = $('[data-rs-drop]');
        this.dropItems = this.dropdownListContainer.find('.item[data-value]');
        this.searchInput = this.dropdown.find('.item__search input');

        this.group = this.dropdown.closest('.rs-group');
        this.hslInputs = this.group.find('.hsl-field .rs-input');
    }

    bindEvents() {
        // Drop arrow click (toggle drop)
        this.dropActions.on('click.rs_color', event => {
            this.dropdownToggle(event);
        });

        // Click html element (display color static)
        this.colorPreviewBox.on('click.rs_colorPreviewBox', event => {
            this.colorPickerInit(event.currentTarget);
            this.refs.picker.setColor(this.refs.colorHex);
            this.refs.picker.show();
        });

        // Select value from dropdown (click on drop item)
        this.dropItems.on('click', (event) => {
            let selectValue = $(event.currentTarget).data('value');
            let displayInput = this.dropdown.find('.rs-input_display');

            if (this.refs.type === 'color-picker') {
                let selectColor = $(event.currentTarget).data('color');
                this.rsInput.val(selectColor);

                displayInput.val($(event.currentTarget).find('.value__text').html());

                // Check init picker instance
                if (this.refs.picker) {
                    this.refs.picker.setColor(selectColor);
                } else {
                    this.refs.colorHex = selectColor;
                    this.colorPreviewBox.css('background-color', selectColor)
                }
            }
            this.rsInput.val(selectValue);
            this.dropdown.toggleClass(this.openClass);
        });

        // Click outside (close dropdown)
        this.document.mouseup((event) => {
            if (!this.dropdown.is(event.target) && this.dropdown.has(event.target).length === 0) {
                this.dropdown.removeClass(this.openClass);
            }
        });

        // Search inside dropdown
        this.searchInput.on('keyup.rs_search', (event) => {
            this.search(event);
        });

    }

    colorPickerInit(element) {
        let currentHexColor;
        let colorPickerElement;

        if($(element).hasClass('rs-input')){
            currentHexColor = $(element).val();
            colorPickerElement = $(element).closest('.dropdown-container').find('.color-preview')[0];
        }else{
            colorPickerElement = element;
            currentHexColor = $(element).closest('.dropdown-container').find('.rs-input').val();
        }

        let position = 'bottom';
        if(this.refs.location === 'client'){
            position = 'right-end'
        }else{
            position = 'bottom';
        }

        this.refs.picker = Pickr.create({
            el: colorPickerElement,
            useAsButton: false,
            comparison: false,
            theme: 'monolith', // or 'monolith', or 'nano'
            default: currentHexColor ? currentHexColor : this.refs.colorHex,
            position: position,

            components: {
                // Main components
                preview: true, opacity: true, hue: true,

                // Input / output Options
                interaction: {
                    hex: false,
                    rgba: false,
                    hsla: false,
                    hsva: false,
                    cmyk: false,
                    input: true,
                    clear: false,
                    save: false
                }
            }
        });

        this.refs.picker.on('swatchselect', (color, instance) => {
            this.rsInput.val(instance.getColor().toHEXA().toString());
        });

        this.refs.picker.on('change', (color, instance) => {
            let displayInput = this.dropdown.find('.rs-input_display');
            if(this.refs.inputType === 'change'){
                this.rsInput.val(instance.getColor().toHEXA().toString());
                displayInput.val(instance.getColor().toHEXA().toString());
            }
            // Check if Group is enabled
            if (this.group.hasClass('disabled')) {
                for (let [index, value] of Object.entries(this.dropdown.closest('.rs-group').find('.hsl-field'))) {
                    let color = instance.getColor().toHSLA();
                    this.generateColor(color , parseInt(index) );
                }
            }

            this.refs.inputType = 'change';
        });

        if (this.refs.colorHex) {
            this.refs.picker.setColor(this.refs.colorHex);
        }
    }

    generateColor($color, $index){
        if(!isNaN($index)){
            let colorPreview = $('[data-group="'+this.refs.currentGroupIndex+'"]').find('.hsl-field');

            if(this.refs.currentGroupIndex === 'Gray') {
                //console.log('Gray');
                if ($index === 0) {
                    $color[2] += 16;
                }else if ($index === 1) {
                    $color[2] += 36;
                }else if ($index === 2) {
                    $color[2] += 42;
                }else if ($index === 3) {
                    $color[2] += 46;
                }else if ($index === 4) {
                    $color[2] -= 32;
                }else if ($index === 5) {
                    $color[2] += 24;
                }
            }else if (this.refs.currentGroupIndex === 'Secondary') {
                //console.log('Secondary');
                if ($index === 0) {
                    $color[2] += 16;
                }else if ($index === 1) {
                    $color[2] += 40;
                }else if ($index === 2) {
                    $color[2] += 43;
                }else if ($index === 3) {
                    $color[2] += 46;
                }else if ($index === 4) {
                    $color[2] -= 16;
                }
            } else if (this.refs.currentGroupIndex === 'SVG Icons') {
                //console.log('SVG Icons');
                if ($index === 0) {
                    $color[0] -= 10;
                    $color[1] -= 20;
                }else if ($index === 1) {
                    $color[0] -= 15;
                    $color[2] += 20;
                }else if ($index === 2) {
                    $color[0] -= 15;
                    $color[2] += 25;
                }else if ($index === 3) {
                    $color[0] -= 15;
                    $color[2] += 30;
                }else if ($index === 4) {
                    $color[0] -= 15;
                    $color[2] += 35;
                } else if ($index === 5) {
                    $color[0] -= 15;
                    $color[2] += 40;
                } else if ($index === 6) {
                    $color[0] -= 15;
                    $color[2] += 55;
                    if ($color[2] >= 98){
                        $color[2] = 100;
                    }
                }
            } else {
                console.log('Other');
                // Other colors
                if ($index === 0) {
                    $color[2] += 16;
                } else if ($index === 1) {
                    $color[2] += 40 ;
                    if($color[2]>= 92){
                        $color[2] = 92;
                    }
                } else if ($index === 2) {
                    $color[2] += 43;
                    if($color[2] >= 95){
                        $color[2] = 95;
                    }
                } else if ($index === 3) {
                    $color[2] += 46;
                    if($color[2]>= 98){
                        $color[2] = 98;
                    }
                } else if ($index === 4) {
                    $color[2] -= 8;
                }
            }

            let hsla = {
                h: $color[0].toFixed(0),
                s: $color[1].toFixed(0),
                l: $color[2].toFixed(0),
                a: $color[3].toFixed(2),
            };

            colorPreview.find('.rs-input')[$index].value = this.hslaToHexa(hsla.h, hsla.s, hsla.l, hsla.a);
            this.refs.colorHex = this.hslaToHexa(hsla.h, hsla.s, hsla.l, hsla.a);

            if(colorPreview[$index].getElementsByClassName('activeColor')[0]){
                colorPreview[$index].getElementsByClassName('activeColor')[0].style.backgroundColor = 'hsla(' + hsla.h + ',' + hsla.s + '%,' + hsla.l + '%,' + hsla.a + ')';
            }
        }
    }

    hslaToHexa(h, s, l, a) {
        console.log(h,s,l,a);
        if(h >= 360){
            h = 359;

        }else if(h <= 0){
            h = 0;
        }

        if(l <= 0){
            l = 0;
        }else if(l > 100){
            l=100;
        }

        s /= 100;
        l /= 100;

        let c = (1 - Math.abs(2 * l - 1)) * s,
            x = c * (1 - Math.abs((h / 60) % 2 - 1)),
            m = l - c / 2,
            r = 0,
            g = 0,
            b = 0;

        if (0 <= h && h < 60) {
            r = c;
            g = x;
            b = 0;
        } else if (60 <= h && h < 120) {
            r = x;
            g = c;
            b = 0;
        } else if (120 <= h && h < 180) {
            r = 0;
            g = c;
            b = x;
        } else if (180 <= h && h < 240) {
            r = 0;
            g = x;
            b = c;
        } else if (240 <= h && h < 300) {
            r = x;
            g = 0;
            b = c;
        } else if (300 <= h && h < 360) {
            r = c;
            g = 0;
            b = x;
        }
        // Having obtained RGB, convert channels to hex
        r = Math.round((r + m) * 255).toString(16);
        g = Math.round((g + m) * 255).toString(16);
        b = Math.round((b + m) * 255).toString(16);

        // Prepend 0s, if necessary
        if (r.length === 1)
            r = "0" + r;
        if (g.length === 1)
            g = "0" + g;
        if (b.length === 1)
            b = "0" + b;

        a = Math.round(a * 255).toString(16);

        if (r.length === 1)
            r = "0" + r;
        if (g.length === 1)
            g = "0" + g;
        if (b.length === 1)
            b = "0" + b;
        if (a.length === 1)
            a = "0" + a;

        return "#" + r + g + b + a;
    }

    dropdownToggle(event) {
        if (!$(event.currentTarget).closest('[data-rs-drop]').hasClass(this.openClass)) {
            this.allDropdowns.removeClass(this.openClass);
            this.dropdown.toggleClass(this.openClass);
        } else {
            this.dropdown.removeClass(this.openClass);
        }
    }

    search(event) {
        let value = event.currentTarget.value.toLowerCase();
        this.dropItems.show().filter(function () {
            return $(this).text().toLowerCase().trim().indexOf(value) === -1;
        }).hide();

    }
}

function rs_color_selector() {
    $("[data-rs-dropdown]").each((index, instance) => {
        new RsDropdown(instance);
    });

    let groupInstance = [];
    $('[data-group]').each((index, instance) => {
        groupInstance[index] = new RsGroupColors(instance);
    });
    console.log(groupInstance);


    $('.hiddenInitialization').fadeIn();
    $('#colorsForm .preloader--xl').hide();
    console.log('after initialization');
}

function rs_color_picker() {
    $('.color-picker').each(function () {
        initColorPickers(this);
    });
}

function initColorPickers(element) {
    let $element = $(element);
    let picker = Pickr.create({
        el: element,
        useAsButton: true,
        comparison: false,
        theme: 'monolith', // or 'monolith', or 'nano'
        default: element.value,

        components: {
            // Main components
            preview: true,
            opacity: true,
            hue: true,

            // Input / output Options
            interaction: {
                hex: false,
                rgba: false,
                hsla: false,
                hsva: false,
                cmyk: false,
                input: true,
                clear: false,
                save: false
            }
        }
    });
    picker.on('swatchselect', (color, instance) => {
        element.value = instance.getColor().toHEXA().toString();
        $element.trigger('change');
    });

    picker.on('change', (color, instance) => {
        element.value = instance.getColor().toHEXA().toString();
        $element.trigger('change');
        console.log(this.hasClass('hsl-match'));
    });
}
