<?php

/*
Client area login notifications for WHMCS (works with versions 6-8)
Created by whmcsguru
Contributions by brian!
*/

use WHMCS\Database\Capsule;
$myver = get_whmcs_version();
$isadmin = $_SESSION['adminid'];

$admnotify = FALSE;
//change this to true you want to send notifications when admin logged in..
//NOT advisable. this will let your clients know when you're logging into their account

if (!empty($isadmin))
{
	if (!$admnotify)
	{
		return;
	}
}
function hook_client_login_notify($vars)
{
	$mailsent=FALSE;


	global $myver;
	$myver = get_whmcs_version();
	if ($myver < 8)
	{
		$userid = $vars['userid'];

		send_login_notify($userid);
		return;
	}
	if ($myver >= 8)
	{
		$user = $vars['user'];
		$userid = $user->id;
		//a dirty hack to try to work around a couple of things, maybe

		$acctowner = Capsule::table('tblusers_clients')
		->where('auth_user_id', '=', $userid)
		->where('owner', '=', 1)
		->count();

		$numrows = Capsule::table('tblusers_clients')
		->where('auth_user_id', '=', $userid)
		->count();

		//we own our account. We must always notify us directly
		if ($acctowner > 0)
		{
			send_login_notify($userid);
			return;
		}

		//we don't own our account, so, notify the owner, if we only exist once.
		if ($numrows < 2)
		{
			foreach (Capsule::table('tblusers_clients')->WHERE('auth_user_id', '=', $userid)->get() as $userstuff){
				$userid = $userstuff->auth_user_id;
				$clientid = $userstuff->client_id;
				$owner = $owner;
				if ($acctowner < 1)
				{
					send_login_notify($clientid, $userid);
					return;
				}

			}
		}

		return;
	}



}


function send_login_notify($myclient, $theuserid="")
{
	global $myver;

	$ip = $_SERVER['REMOTE_ADDR'];

	$res = json_decode(file_get_contents('https://www.iplocate.io/api/lookup/'.$ip));
	$city = $res->city;
	$hostname = gethostbyaddr($ip);

	if ($myver < 8)
	{

		$clientinfo = Capsule::table('tblclients')->select('firstname', 'lastname')->WHERE('id', $myclient)->get();
		foreach ($clientinfo as $clrow)
		{
			$firstname = $clrow->firstname;
			$lastname = $clrow->lastname;
		}
	}
	if ($myver >= 8)
	{

		$clientinfo = Capsule::table('tblusers')->select('first_name', 'last_name')->WHERE('id', $myclient)->get();
		foreach ($clientinfo as $clrow)
		{
			$firstname = $clrow->first_name;
			$lastname = $clrow->last_name;
		}
	}


	$command = "sendemail";
	$values["customtype"] = "general";
	if (empty($theuserid))
	{
		//$values["customsubject"] = "Account Login from $hostname";
		//$values["custommessage"] = "<p>Hello $firstname $lastname,<p>Your account was recently successfully accessed by a remote user. If this was not you, please do contact us immediately<p>IP Address: $ip<br/>City: $city<br/>Hostname: $hostname<br />";
		$values["messagename"] = 'AlertaLogin2';
	}

	elseif ($theuserid > 0)
	{
		$moreinfo = Capsule::table('tblusers')->select('first_name', 'last_name', 'email')->WHERE('id', $theuserid)->get();
		//greet them
		foreach ($moreinfo as $userrow)
		{
			$ufirst = $userrow->first_name;
			$ulast = $userrow->last_name;
			$uemail = $userrow->email;
		}

		$values["customsubject"] = "Subaccount Login from $hostname";
		$values["custommessage"] = "<p>Hello
		$firstname $lastname,<p>
		A subaccount of yours just logged in. Please see the details of the login below
		<p>
		Name: $ufirst $ulast
		Email: $uemail
		IP Address: $ip
		City: $city
		Hostname: $hostname<br />";
	}
	$values["id"] = $myclient;

	$results = localAPI($command, $values);
	
}
if ($myver < 8)
{
	add_hook('ClientLogin', 1, 'hook_client_login_notify');
	add_hook('EmailPreSend', 1, 'login_avisa_email');
}
if ($myver >= 8)

{
	add_hook('UserLogin', 1, 'hook_client_login_notify');
	add_hook('EmailPreSend', 1, 'login_avisa_email');
}

function get_whmcs_version()
{
        $theversion = Capsule::table('tblconfiguration')->where('setting', '=', 'Version')->value('value');
        $retver = substr($theversion, 0,1);

        return ($retver);

}

//Strings para E-mail
function login_avisa_email($vars){

	//Pegando URL do site
	foreach (Capsule::table('tblconfiguration')->WHERE('setting', 'SystemURL')->get() as $system){
	    $urlsistema = $system->value;
	}

	//ID do usuário
	$id = $_SESSION['uid'];

	//Cria a Array
	$login_avisa = array();
	$login_avisa['ip'] = getenv("REMOTE_ADDR");
	$login_avisa['hostname'] = gethostbyaddr($login_avisa['ip']);

	//Tratando o JSON DECODE
	$obterjson = file_get_contents("http://ip-api.com/json/".$login_avisa['ip']."");
	$json = json_decode($obterjson);
	$login_avisa['pais'] = $json->country;
	$login_avisa['pais_codigo'] = $json->countryCode;
	$login_avisa['estado_codigo'] = $json->region;
	$login_avisa['estado'] = $json->regionName;
	$login_avisa['cidade'] = $json->city;
	$login_avisa['cep'] = $json->zip;
	$login_avisa['isp'] = $json->isp;
	$login_avisa['organizacao'] = $json->org;
	$login_avisa['as'] = $json->as;
	$login_avisa['latitude'] = $json->lat;
	$login_avisa['longitude'] = $json->lon;
	$login_avisa['data_atual'] = date("d/m/Y");
	$login_avisa['horario'] = date("H:i");

	//Montando a hash
	foreach (Capsule::table('tblclients')->WHERE('id', $id)->get() as $usuario){
		$emailusuario = $usuario->email;
	}
	$dataatual = date("d/m/Y");
	$horaatual = date("H:i:s");
	$preparomd5 = "".$emailusuario."".$id."".$dataatual."".$horaatual."";
	$md5 = md5($preparomd5);
	$login_avisa['hashloginavisa'] = $md5;
	$login_avisa['hashloginavisa_link'] = "".$urlsistema."clientarea.php?login-avisa=".$md5."";

	//retorna os valores
	return $login_avisa;

}