/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Configuration;
import com.jcraft.jcterm.ConfigurationRepository;
import com.jcraft.jcterm.Frame;
import com.jcraft.jcterm.JCTermSwing;
import com.jcraft.jcterm.JCTermSwingFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class JCTermApplet
extends JApplet {
    JDesktopPane desktop = new JDesktopPane();
    private String configName = "default";

    @Override
    public void init() {
        int i;
        JCTermSwingFrame.resetCounter();
        String s = this.getParameter("jcterm.config.repository");
        if (s != null) {
            try {
                Class<?> c = Class.forName(s);
                ConfigurationRepository cr = (ConfigurationRepository)c.newInstance();
                JCTermSwing.setCR(cr);
            }
            catch (Exception e) {
                System.err.println("invalid jcterm.config.repository: " + s);
            }
        }
        if ((s = this.getParameter("jcterm.config.name")) != null) {
            this.configName = s;
        }
        Configuration conf = JCTermSwing.getCR().load(this.configName);
        boolean conf_update = false;
        s = this.getParameter("jcterm.font_size");
        if (s != null) {
            try {
                int font_size = Integer.parseInt(s);
                if (conf.font_size == Configuration.FONT_SIZE) {
                    conf.font_size = font_size;
                    conf_update = true;
                }
            }
            catch (NumberFormatException e) {
                System.err.println("invalid jcterm.font_size: " + s);
            }
        }
        if ((s = this.getParameter("jcterm.destinations")) != null) {
            String[] tmp = Configuration.parseDestinations(s);
            if ((tmp = this.difference(tmp, conf.destinations)).length > 0) {
                conf_update = true;
                for (i = tmp.length - 1; i >= 0; --i) {
                    conf.addDestination(tmp[i]);
                }
            }
        }
        if ((s = this.getParameter("jcterm.fg_bg")) != null) {
            String[] tmp = Configuration.parseFgBg(s);
            if (tmp != null) {
                if ((tmp = this.difference(tmp, conf.fg_bg)).length > 0) {
                    conf_update = true;
                    for (i = tmp.length - 1; i >= 0; --i) {
                        conf.addFgBg(tmp[i]);
                    }
                }
            } else {
                System.err.println("invalid jcterm.fg_bg: " + s);
            }
        }
        if (conf_update) {
            JCTermSwing.getCR().save(conf);
        }
        this.setVisible(true);
        if (Toolkit.getDefaultToolkit().getDesktopProperty("win.mdi.backgroundColor") != null) {
            this.desktop.setBackground((Color)Toolkit.getDefaultToolkit().getDesktopProperty("win.mdi.backgroundColor"));
        }
        Container content = this.getContentPane();
        content.add((Component)this.desktop, "Center");
        this.desktop.setVisible(true);
        JButton addButton = new JButton("New window");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCTermApplet.this.openFrame(0, JCTermApplet.this.configName);
            }
        });
        content.add((Component)addButton, "North");
        addButton.setLocation(0, 0);
        addButton.setVisible(true);
        this.setFocusable(true);
    }

    @Override
    public void start() {
        this.requestFocus();
        this.setFocusable(true);
        this.openFrame(0, this.configName);
    }

    public void openFrame(int mode, String configNname) {
        final JCTermSwing term = new JCTermSwing();
        JCTermSwingFrame jctermsf = new JCTermSwingFrame();
        MyFrame frame = new MyFrame(jctermsf);
        frame.setTitle("JCTerm");
        frame.setIconifiable(true);
        frame.getContentPane().add("Center", term);
        jctermsf.setCloseOnExit(true);
        jctermsf.setTerm(term);
        jctermsf.setFrame(frame);
        frame.setJMenuBar(jctermsf.getJMenuBar());
        frame.pack();
        this.desktop.add(frame);
        ComponentAdapter l = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                Container cp = ((JInternalFrame)c).getContentPane();
                int cw = c.getWidth();
                int ch = c.getHeight();
                int cwm = c.getWidth() - cp.getWidth();
                int chm = c.getHeight() - cp.getHeight();
                term.setSize(cw -= cwm, ch -= chm);
            }
        };
        frame.addComponentListener(l);
        this.addKeyListener(term);
        term.setVisible(true);
        frame.setVisible(true);
        frame.setResizable(true);
        frame.setMaximizable(true);
        jctermsf.applyConfig(this.configName);
        frame.setLocation((this.getWidth() - frame.getWidth()) / 2, (this.getHeight() - frame.getHeight()) / 2);
        jctermsf.openSession();
    }

    private String[] difference(String[] a, String[] b) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < a.length; ++i) {
            String tmp = a[i].trim();
            for (int j = 0; j < b.length; ++j) {
                if (!tmp.equals(b[j])) continue;
                tmp = null;
                break;
            }
            if (tmp == null) continue;
            v.addElement(tmp);
        }
        return v.toArray(new String[0]);
    }

    class MyFrame
    extends JInternalFrame
    implements Frame {
        JCTermSwingFrame jctermsf;
        InternalFrameAdapter l = new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                MyFrame.this.jctermsf.dispose_connection();
            }
        };

        MyFrame(JCTermSwingFrame jctermsf) {
            this.jctermsf = jctermsf;
            this.setClosable(true);
            this.addInternalFrameListener(this.l);
        }

        @Override
        public void openFrame(int mode, String configName) {
            JCTermApplet.this.openFrame(mode, configName);
        }
    }
}

